/*
 *	mbc.c
 *
 *	GameBoy/EMU
 *
 *	* Thu Mar 03 20:00:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 */
//#include "app.h"

/****************************************************************************
 *	
 ****************************************************************************/

typedef struct _MBC {
	int rom_bank_no;
	int ram_batt_size;			/* obeobNAbvRAM̃oCg */
	/* MBC1 */
	int mbc1_memory_model;			/* 0 = 16Mbit ROM/8KByte RAM, 1 = 4Mbit ROM/32KByte RAM */
	/* MBC3 */
	unsigned char mbc3_rtc_latch[5];	/* [0] = Sec, [1] = Min, [2] = DayLo, [3] = DayHi */
#ifdef PIECE
	char save_fname[MAXFILENAME];
#else /*PIECE*/
	char save_fname[_MAX_PATH];
#endif /*PIECE*/
} MBC;

MBC mbc;

/****************************************************************************
 *	
 ****************************************************************************/

void
mbc_set_rom_bank(int no)
{
	ROM_BANK = &rom[0x4000 * no - 0x4000];	/* $4000-$7FFF: ROM bank #1 */
}

void
mbc_set_ram_bank(int no)
{
	RAM_BANK = &ram[0x2000 * no - 0xa000];	/* $A000-$BFFF: RAM bank #0 */
}

int
mbc_init(const char* rom_fname)
{
	FILE* fp;
	char* p;

	/* MBCݒNA܂B */
	memset(&mbc, 0, sizeof mbc);

	/* MBC̎ނmF܂B */
	switch(rom[0x147]) {
	case 0x00: /* ROM ONLY */
	case 0x01: /* ROM+MBC1 */
	case 0x02: /* ROM+MBC1+RAM */
	case 0x03: /* ROM+MBC1+RAM+BATT */
	case 0x05: /* ROM+MBC2 */
	case 0x06: /* ROM+MBC2+BATTERY */
	case 0x08: /* ROM+RAM */
	case 0x09: /* ROM+RAM+BATTERY */
	case 0x0b: /* ROM+MMM01 */		// MBC1Ɠ?
	case 0x0c: /* ROM+MMM01+SRAM */		// MBC1Ɠ?
	case 0x0d: /* ROM+MMM01+SRAM+BATT */	// MBC1Ɠ?
	case 0x0f: /* ROM+MBC3+TIMER+BATT */
	case 0x10: /* ROM+MBC3+TIMER+RAM+BATT */
	case 0x11: /* ROM+MBC3 */
	case 0x12: /* ROM+MBC3+RAM */
	case 0x13: /* ROM+MBC3+RAM+BATT */
	case 0x19: /* ROM+MBC5 */
	case 0x1a: /* ROM+MBC5+RAM */
	case 0x1b: /* ROM+MBC5+RAM+BATT */
	case 0x1c: /* ROM+MBC5+RUMBLE */
	case 0x1d: /* ROM+MBC5+RUMBLE+SRAM */
	case 0x1e: /* ROM+MBC5+RUMBLE+SRAM+BATT */
	//case 0x1f: /* Pocket Camera */	// Ή
	//case 0xfd: /* Bandai TAMA5 */		// Ή
	case 0xfe: /* Hudson HuC-3 */		// MBC3Ɠ?
	case 0xff: /* Hudson HuC-1 */		// MBC1Ɠ?
		break;
	default:
		return -1; /* Ή */
	}

	/* ROMeʂ͌܂B
	 * P/ECẼtbVɒu܂ܗp̂ŁA_łB
	 */

	/* RAMeʂ擾܂B
	 * - RAMeʕśARAMe=0ŋs邱Ƃɂ܂B
	 *   {vÓAobeobNAbv̂߂RAMeʂQƂ܂B
	 *   RAMeʕsłAsRAMgp͂ł̂ŁA肭sΓ삷邩c
	 */
	switch(rom[0x0149]) {
	//case 0: /* None */
	case 1: /*  16kBit =   2kB =  1 bank  */
		mbc.ram_batt_size = 1024 * 2;
		break;
	case 2: /*  64kBit =   8kB =  1 bank  */
		mbc.ram_batt_size = 1024 * 8;
		break;
	case 3: /* 256kBit =  32kB =  4 banks */
		mbc.ram_batt_size = 1024 * 32;
		break;
	case 4: /*   1MBit = 128kB = 16 banks */
		mbc.ram_batt_size = 1024 * 128;
		break;
	}
	switch(rom[0x147]) { /* MBC2 */
	case 0x05: /* ROM+MBC2 */
	case 0x06: /* ROM+MBC2+BATTERY */
		/* !!
		 * u8bit~256oCgvł͂܂!!u4bit~512oCgvł!!
		 * GameBoyG~[^łԈĂ̂A(VisualBoyAdvanceȂ)
		 * ̃G~[^ł́AEmSaEGǎpvCł܂B
		 */
		mbc.ram_batt_size = 512;
		break;
	}
	if(mbc.ram_batt_size > sizeof ram) {
		return -1;
	}

	/* obeobNAbvȂMBCȂ΁ARAMeʂLZ܂B */
	switch(rom[0x147]) {
	//case 0x00: /* ROM ONLY */
	//case 0x01: /* ROM+MBC1 */
	//case 0x02: /* ROM+MBC1+RAM */
	case 0x03: /* ROM+MBC1+RAM+BATT */
	//case 0x05: /* ROM+MBC2 */
	case 0x06: /* ROM+MBC2+BATTERY */
	//case 0x08: /* ROM+RAM */
	case 0x09: /* ROM+RAM+BATTERY */
	//case 0x0b: /* ROM+MMM01 */
	//case 0x0c: /* ROM+MMM01+SRAM */
	case 0x0d: /* ROM+MMM01+SRAM+BATT */
	case 0x0f: /* ROM+MBC3+TIMER+BATT */
	case 0x10: /* ROM+MBC3+TIMER+RAM+BATT */
	//case 0x11: /* ROM+MBC3 */
	//case 0x12: /* ROM+MBC3+RAM */
	case 0x13: /* ROM+MBC3+RAM+BATT */
	//case 0x19: /* ROM+MBC5 */
	//case 0x1a: /* ROM+MBC5+RAM */
	case 0x1b: /* ROM+MBC5+RAM+BATT */
	//case 0x1c: /* ROM+MBC5+RUMBLE */
	//case 0x1d: /* ROM+MBC5+RUMBLE+SRAM */
	case 0x1e: /* ROM+MBC5+RUMBLE+SRAM+BATT */
	//case 0x1f: /* Pocket Camera */
	//case 0xfd: /* Bandai TAMA5 */
	//case 0xfe: /* Hudson HuC-3 */
	//case 0xff: /* Hudson HuC-1 */
		break;
	default:
		mbc.ram_batt_size = 0;
		break;
	}

	/* CARAMoNNA܂B */
	memset(dmgmem, 0, 0x10000);
	memset(ram, 0, sizeof ram);

	/* ROMoNARAMoN܂B() */
	memcpy(dmgmem, rom, 0x4000);		/* $0000-$3FFF: ROM bank #0 */
	mbc_set_rom_bank(1);			/* $4000-$7FFF: ROM bank #1 */
	mbc_set_ram_bank(0);			/* $A000-$BFFF: RAM bank #0 */

	/* obeobNAbvRAM𕜌܂B */
	if(mbc.ram_batt_size) {
#ifdef PIECE
		strcpy(mbc.save_fname, rom_fname);
#else /*PIECE*/
		_splitpath(rom_fname, NULL, NULL, mbc.save_fname, NULL); /* ݂̃tH_ɃZ[u */
#endif /*PIECE*/
		p = strrchr(mbc.save_fname, '.');
		if(p) {
			*p = '\0';
		}
		strcat(mbc.save_fname, ".sav");
		fp = fopen(mbc.save_fname, "rb");
		if(fp) {
			fread(ram, 1, mbc.ram_batt_size, fp);
			fclose(fp);
		}
		memcpy(old_ram, ram, mbc.ram_batt_size); /* Z[uOrpɕۑ */
	}

	return 0;
}

void
mbc_exit()
{
#ifdef PIECE
	FILEACC fa;
	int size;
	int len;
	int sct;
	int turbo_save;
#else /*PIECE*/
	FILE* fp;
#endif /*PIECE*/

	/* obeobNAbvRAMۑ܂B */
	if(mbc.ram_batt_size) {
		/* eςĂꍇ̂݁AXV܂B */
		if(memcmp(old_ram, ram, mbc.ram_batt_size) != 0) {
#ifdef PIECE
			turbo_save = turbo(0); /* Kv!! */
			if(pceFileCreate(mbc.save_fname, mbc.ram_batt_size) == 0) {
				if(pceFileOpen(&fa, mbc.save_fname, FOMD_WR) == 0) {
					render_string_framed(&render, (DISP_X - 5 * 15) / 2, (DISP_Y - 10) / 2,
					//	 012345678901234
						"Z[uł...",
						0x80, 0x330);
					pceLCDTrans();
					//
					size = mbc.ram_batt_size;
					sct = 0;
					while(size) {
						len = size;
						if(len > BLOCKSIZE) {
							len = BLOCKSIZE;
						}
						pceFileWriteSct(&fa, &ram[BLOCKSIZE * sct], sct, len);
						size -= len;
						sct++;
					}
					pceFileClose(&fa);
				}
			}
			turbo(turbo_save); /* Kv!! */
#else /*PIECE*/
			fp = fopen(mbc.save_fname, "wb");
			if(fp) {
				fwrite(ram, 1, mbc.ram_batt_size, fp);
				fclose(fp);
			}
#endif /*PIECE*/
		}
	}
}

/* RAMoÑveNVɂ͑ΉĂ܂B
 * RAMoÑveNVɈˑsQ[́AԂ񖳂Ǝv܂B
 */
void
mbc_write(int addr, int data)
{
	time_t t;
	struct tm* tm;

	switch(rom[0x147]) {
	case 0x01: /* ROM+MBC1 */
	case 0x02: /* ROM+MBC1+RAM */
	case 0x03: /* ROM+MBC1+RAM+BATT */
	case 0x0b: /* ROM+MMM01 */		// MBC1Ɠ?
	case 0x0c: /* ROM+MMM01+SRAM */		// MBC1Ɠ?
	case 0x0d: /* ROM+MMM01+SRAM+BATT */	// MBC1Ɠ?
	case 0xff: /* Hudson HuC-1 */		// MBC1Ɠ?
		{
			/* $0000-$1FFF */
			if(addr < 0x2000) {
				/** no job **/

			/* $2000-$3FFF */
			} else if(addr < 0x4000) {
				data &= 0x1f; /* xxxBBBBB */
				if(!mbc.mbc1_memory_model) { /* 0 = 16Mbit ROM/8KByte RAM */
					mbc.rom_bank_no &= ~0x1f;
					mbc.rom_bank_no |=  data;
				} else { /* 1 = 4Mbit ROM/32KByte RAM */
					mbc.rom_bank_no = data;
				}
				mbc_set_rom_bank(mbc.rom_bank_no ? mbc.rom_bank_no : 1);

			/* $4000-$5FFF */
			} else if(addr < 0x6000) {
				data &= 0x03; /* xxxxxxBB */
				if(!mbc.mbc1_memory_model) { /* 0 = 16Mbit ROM/8KByte RAM */
					mbc.rom_bank_no &= ~(0x03 << 5);
					mbc.rom_bank_no |=  (data << 5);
					mbc_set_rom_bank(mbc.rom_bank_no ? mbc.rom_bank_no : 1);
				} else { /* 1 = 4Mbit ROM/32KByte RAM */
					mbc_set_ram_bank(data);
				}

			/* $6000-$7FFF */
			} else { /* addr < 0x8000 */
				mbc.mbc1_memory_model = data & 1; /* xxxxxxxS */
			}
			return;
		}
	case 0x05: /* ROM+MBC2 */
	case 0x06: /* ROM+MBC2+BATTERY */
		{
			/* $0000-$1FFF */
			if(addr < 0x2000) {
				/** no job **/

			/* $2000-$3FFF */
			} else if(addr < 0x4000) {
				data &= 0x0f; /* xxxxBBBB */
				mbc.rom_bank_no = data;
				mbc_set_rom_bank(mbc.rom_bank_no ? mbc.rom_bank_no : 1);
			}
			return;
		}
	case 0x0f: /* ROM+MBC3+TIMER+BATT */
	case 0x10: /* ROM+MBC3+TIMER+RAM+BATT */
	case 0x11: /* ROM+MBC3 */
	case 0x12: /* ROM+MBC3+RAM */
	case 0x13: /* ROM+MBC3+RAM+BATT */
	case 0xfe: /* Hudson HuC-3 */		// MBC3Ɠ?
		{
			/* $0000-$1FFF */
			if(addr < 0x2000) {
				/** no job **/

			/* $2000-$3FFF */
			} else if(addr < 0x4000) {
				data &= 0x7f; /* xBBBBBBB */
				mbc.rom_bank_no = data;
				mbc_set_rom_bank(mbc.rom_bank_no ? mbc.rom_bank_no : 1);

			/* $4000-$5FFF */
			} else if(addr < 0x6000) {
				if(data < 8) {
					mbc_set_ram_bank(data);
				} else if(data < 13) {
					/* C$A000-$BFFF͎gȂ̂ŁARTCoNƂėp܂B */
					//memset(&dmgmem[0xa000], mbc.mbc3_rtc_latch[data - 8], 0x2000);
					//{͏̂悤ɂׂłÂ߂ɐ擪1oCgݒ肵܂B
					//킴킴$A000ȊȌꏊRTClǂݏoQ[͖AƐ܂B
					dmgmem[0xa000] = mbc.mbc3_rtc_latch[data - 8];
					RAM_BANK = &dmgmem[0xa000 - 0xa000];	/* $A000-$BFFF: RTC bank #8-12 */
				}

			/* $6000-$7FFF */
			} else { /* addr < 0x8000 */
				/* {0->1GbWŃb`̂łǁA̋ɈˑQ[͖AƐ܂B
				 * $6000-$7FFFɉ񂾂AɃb`邱Ƃɂ܂B
				 */
				time(&t);
				tm = localtime(&t);
				mbc.mbc3_rtc_latch[0] = tm->tm_sec;			/* RAM Bank# 8 */
				mbc.mbc3_rtc_latch[1] = tm->tm_min;			/* RAM Bank# 9 */
				mbc.mbc3_rtc_latch[2] = tm->tm_hour;			/* RAM Bank#10 */
				mbc.mbc3_rtc_latch[3] = (tm->tm_yday >> 0) & 0xff;	/* RAM Bank#11 */
				mbc.mbc3_rtc_latch[4] = (tm->tm_yday >> 8) & 0xff;	/* RAM Bank#12 */
			}
			return;
		}
	case 0x19: /* ROM+MBC5 */
	case 0x1a: /* ROM+MBC5+RAM */
	case 0x1b: /* ROM+MBC5+RAM+BATT */
	case 0x1c: /* ROM+MBC5+RUMBLE */
	case 0x1d: /* ROM+MBC5+RUMBLE+SRAM */
	case 0x1e: /* ROM+MBC5+RUMBLE+SRAM+BATT */
		{
			if(addr < 0x2000) {
				/** no job **/
			} else if(addr < 0x3000) {
				//data &= 0xff; /* BBBBBBBB */
				mbc.rom_bank_no &= ~0xff;
				mbc.rom_bank_no |=  data;
				mbc_set_rom_bank(mbc.rom_bank_no); /* Bank#0  */
			} else if(addr < 0x4000) {
				data &= 0x01; /* xxxxxxxB */
				mbc.rom_bank_no &= ~(0x01 << 8);
				mbc.rom_bank_no |=  (data << 8);
				mbc_set_rom_bank(mbc.rom_bank_no); /* Bank#0  */
			} else if(addr < 0x6000) {
				if(rom[0x147] < 0x1c) {
				//case 0x19: /* ROM+MBC5 */
				//case 0x1a: /* ROM+MBC5+RAM */
				//case 0x1b: /* ROM+MBC5+RAM+BATT */
					data &= 0x0f; /* xxxxBBBB */
				} else {
				//case 0x1c: /* ROM+MBC5+RUMBLE */
				//case 0x1d: /* ROM+MBC5+RUMBLE+SRAM */
				//case 0x1e: /* ROM+MBC5+RUMBLE+SRAM+BATT */
					data &= 0x07; /* xxxxMBBB */
				}
				mbc_set_ram_bank(data);
			}
			return;
		}
	}
}
