/*	
 *	clipuvi.h
 *
 *	P/ECE Signetics 2637 UVI(Universal Video Interface) Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Sat Apr 30 13:14:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 */
#ifndef __CLIP_UVI_H__
#define __CLIP_UVI_H__

/****************************************************************************
 *
 ****************************************************************************/

/* UVI_ASMV{`ǂݍ݂܂B
 * UVI_ASMV{̖`/`ɂC/AZuR[h̐؂ւ́A
 * C\[Xt@C(*.c)ƃAZu\[Xt@C(*.s)QƂ̂ŁA
 * ʂ̃CN[ht@CɕĂ܂B
 * (CL̒`܂ރCN[ht@Ĉ܂܃AZu\[X
 *  CN[hƁAAZuG[ɂȂĂ܂߁B)
 */
#include "clipuvia.h"

/********** ȍ~͏Ȃł **********/

/* P/ECEȊOł̓AZuR[h͎gpł܂B
 */
#ifndef PIECE
#undef UVI_ASM
#endif /*PIECE*/

/****************************************************************************
 *	UVI (Universal Video Interface)
 ****************************************************************************/

//			  +++------------------------- TV picture width
//			  ||| +++--------------------- horizontalblank
//			  ||| |||   +++--------------- TV picture height
//			  ||| |||   ||| ++------------ vertical blank
//			  ||| |||   ||| || +---------- vertical sync
//			  ||| |||   ||| || |  ++------ 60 frames per second
//			  ||| |||   ||| || |  ||
//#define UVI_CLOCK	((128+100)*(208+51+3)*60)   /* NTSCUVIClock */
/* vŹ̒ʂłAۂNTSC Clocḱx߂ɐݒ肳Ă܂B */
#define UVI_CLOCK	NTSC_COLOR_SUBCARRIER
#define ARCADIA_CLOCK	UVI_CLOCK             /* NTSCARCADIA CPUClock */

#define UVIBUFLEN 320 /* =16000/50 c 1[tick](=1/50[sec])̃Tv */

#ifdef PIECE
#define UVI_GRAYSCALE
#endif /*PIECE*/

/*  */
/* AZu[`璼ڎQƂĂ̂ŁAtH[}bgŒłB */
/* tH[}bgύXƂ́Aclipuvia.h̒`Ǐ]ĂB */
/*  */

typedef struct _UVIOBJ {
	unsigned char size;				/* + 0,1: TCY (0=W,1=c2{g) */
	unsigned char color;				/* + 1,1: J[ */
	short resv;					/* + 2,2: (\) */
	short x;					/* + 4,2: XW */
	short y;					/* + 6,2: YW */
	unsigned char* font/*[8]*/;			/* + 8,4: tHg */
} UVIOBJ;						/* =12 */
#define SIZEOF_UVIOBJ					    12

typedef struct _UVI {
	/*---------- Video ----------*/
	unsigned char* ram/*[0x400]*/;			/* +  0,  4: ORAMAWX^ */
	unsigned char* vbuff/*[128*208]*/;		/* +  4,  4: ݂̉z (NULL=`斳) */
	short scan_start;				/* +  8,  2: ÕXLCʒu (`ԏ[  ) */
	short scan_end;					/* + 10,  2: ݂̃XLCʒu (`ԉ[+1) */
	short scroll_y;					/* + 12,  2: XN[ (t[P) */
	char  scroll_x[26/*Row*/];			/* + 14, 26: XN[ (-1:s擾A0..7:擾) */
	unsigned short bg[26/*Row*/][16/*Col*/];	/* + 40,832: BG (000000cc0gffffff c=Color,g=GM,f=Code) */
	unsigned char color[4/*B7:6*/][2/*Font*/];	/* +872,  8: BGJ[ */
	unsigned char pot[4];				/* +880,  4: A/D Potentiometer */
	UVIOBJ obj[4];					/* +884, 48: OBJ1,OBJ2,OBJ3,OBJ4 */
	/*---------- Sound ----------*/
	int tone_count;					/* +932,  4: Tone  isJE^ */
	int noise_count;				/* +936,  4: Noise isJE^ */
	unsigned short tone_polar;			/* +940,  2: Tone  o͋ɐ */
	unsigned short noise_lfsr;			/* +942,  2: Noise Linear Feedback Shift Register */
} UVI;							/* =944 */
#define SIZEOF_UVI					    944

/****************************************************************************
 *	O[oϐ
 ****************************************************************************/

extern UVI uvi;
extern unsigned char uvi_font[8/*Line*/ * 64/*Character*/ * 2/*Mode*/];

#ifdef UVI_GRAYSCALE
extern const unsigned char uvi_grayscale_table[8/*Color*/];
#else /*UVI_GRAYSCALE*/
extern const unsigned char uvi_color_table[8/*Color*/][3/*R,G,B*/];
#endif /*UVI_GRAYSCALE*/

/****************************************************************************
 *	֐ (Video)
 ****************************************************************************/

void uvi_update_pot();
void uvi_update_color();

void uvi_partial_update();
void uvi_draw_chr_8x8(int x, int y, int code, int color);
void uvi_draw_chr_8x16(int x, int y, int code, int color);
void uvi_draw_obj_8x8(UVIOBJ* obj);
void uvi_draw_obj_8x16(UVIOBJ* obj);

void uvi_collision();
int uvi_collision_obj_8x8_bg_8x8(UVIOBJ* obj);
int uvi_collision_obj_8x8_bg_8x16(UVIOBJ* obj);
int uvi_collision_obj_8x16_bg_8x8(UVIOBJ* obj);
int uvi_collision_obj_8x16_bg_8x16(UVIOBJ* obj);
int uvi_collision_obj_8x8_obj_8x8(UVIOBJ* obj1, UVIOBJ* obj2);
int uvi_collision_obj_8x8_obj_8x16(UVIOBJ* obj1, UVIOBJ* obj2);
int uvi_collision_obj_8x16_obj_8x8(UVIOBJ* obj1, UVIOBJ* obj2);
int uvi_collision_obj_8x16_obj_8x16(UVIOBJ* obj1, UVIOBJ* obj2);
int uvi_collision_font_8x8_font_8x8(int x1, int y1, const unsigned char* font1/*[8]*/, int x2, int y2, const unsigned char* font2/*[8]*/);
int uvi_collision_font_8x8_font_8x16(int x1, int y1, const unsigned char* font1/*[8]*/, int x2, int y2, const unsigned char* font2/*[8]*/);
int uvi_collision_font_8x16_font_8x8(int x1, int y1, const unsigned char* font1/*[8]*/, int x2, int y2, const unsigned char* font2/*[8]*/);
int uvi_collision_font_8x16_font_8x16(int x1, int y1, const unsigned char* font1/*[8]*/, int x2, int y2, const unsigned char* font2/*[8]*/);

/****************************************************************************
 *	AvP[Vp֐ (Video)
 ****************************************************************************/

/* UVIRAZbg܂B
 * [in]
 *	ram		UVI̊ORAM̐擪AhXw肵ĂB
 *			ARCADIȀꍇACPUCԂ$1800..$1BFFw肵܂B
 */
void uvi_reset(unsigned char* ram/*[0x400]*/);

/* ORAM܂UVIWX^ǂݏo܂B
 * [in]
 *	addr		ORAM܂UVIWX^AhXB($000..$3FF)
 * [out]
 *	߂l		ǂݏof[^B($00..$FF)
 */
int uvi_read(int addr);

/* ORAM܂UVIWX^֏݂܂B
 * [in]
 *	addr		ORAM܂UVIWX^AhXB($000..$3FF)
 *	data		ރf[^B($00..$FF)
 */
void uvi_write(int addr, int data);

/* AiO͒lݒ肵܂B
 * [in]
 *	pot		|[gAhXB(0=POT1,1=POT2,2=POT3,3=POT4)
 *	data		AiO͒lB($00..$FF)
 *			ARCADIȀꍇA悻 :$00`:$70`E:$F0 ƂȂ܂B
 */
void uvi_set_pot(int pot, int data);

/* Vt[Jn܂B
 * [in]
 *	vbuff		`悷鉼zʁB
 *			NULLw肷ƁÃt[͎`斳ƂȂ܂B
 */
void uvi_new_frame(unsigned char* vbuff/*[128*208]*/);

/* XLC1Ci߂܂B
 * [out]
 *	߂l		̃XLCVblankԂȂ1Ԃ܂B
 *			ARCADIȀꍇA2650 CPU ւSENSE͂ɑ܂B
 * [note]
 *	* ARCADIȀꍇAuvi_new_frame()uvi_next_line()Â悤ɎgĂB
 *		1. Vt[JnB		uvi_new_frame(vbuff)
 *		2. 2650 CPUSENSE͂0ƂB	s2650_set_sense(0)
 *		3. 1CCPUsB			s2650_run(ARCADIA_CLOCK/60/262)
 *		4. XLCi߂B		uvi_next_line()
 *		   ߂l0Ȃ΁A3JԂB
 *		5. 2650 CPUSENSE͂1ƂB	s2650_set_sense(1)
 *		6. 1CCPUsB			s2650_run(ARCADIA_CLOCK/60/262)
 *		7. XLCi߂B		uvi_next_line()
 *		   ߂l1Ȃ΁A5JԂB
 *		8. 1t[̏̂ŁAzʂfBXvCɓ]B
 */
int uvi_next_line();

#ifdef UVI_GRAYSCALE
/* 128x208x16~OCXP[A88x128x16~OCXP[֏kRs[܂B
 * [in]
 *	src		128x208x16~OCXP[ʃobt@B
 *	dst		 88x128x16~OCXP[ʃobt@B
 *
 * [note]
 *	* srcdst͓AhXwĂĂ\܂B
 *	  ŏII88x128̉ʃC[WKvȂ΁A128x20888x128̉ʃobt@ʉāA
 *	  ߖł܂B
 */
void uvi_reduce(unsigned char dst[/*88*128*/], const unsigned char src[/*128*208*/]);
#endif UVI_GRAYSCALE

/****************************************************************************
 *	֐ (Sound)
 ****************************************************************************/

void uvi_tone_mix(short wbuff[/*UVIBUFLEN*/], int volume, int period);
void uvi_noise_mix(short wbuff[/*UVIBUFLEN*/], int volume, int period);
void uvi_volume_shift(short wbuff[/*UVIBUFLEN*/]);

/****************************************************************************
 *	AvP[Vp֐ (Sound)
 ****************************************************************************/

/* o̓TvO[g=SPEAKER_OUTPUT[Hz]ŁAUVIBUFLENTṽ~LVOs܂B
 * [in]
 *	wbuff		o̓Tvobt@B
 */
void uvi_mix(short wbuff[/*UVIBUFLEN*/]);

#endif /*__CLIP_UVI_H__*/
