/*
 *	clipsnds.c
 *
 *	TEhV[PT
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2015 Naoyuki Sawa
 *
 *	* Thu Oct 03 00:19:14 JST 2013 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Oct 05 15:05:45 JST 2013 Naoyuki Sawa
 *	- p^[R}hɁA4oCgEFCgǉ܂B
 *	  4oCgEFCgɂ̓ItZbgS͈͂Jo[̂ŁAƂŃf[^쐬鎞4oCgEFCggpƒIɍ쐬ł܂B
 *	  1`3oCgEFCg̕ߖł̂ŁAc[Ńf[^쐬鎞̓EFCgԂɂ1`4oCgEFCg𐶐ĂB
 *	* Fri Nov 01 17:54:30 JST 2013 Naoyuki Sawa
 *	- SndSeq_Play()Ap^[f[^擪0ms^C~Oɑ鏈𑦎s悤ɁAC܂B
 *	* Sun Jun 01 22:15:15 JST 2014 Naoyuki Sawa
 *	- SndSeqCmd_Vol,SndSeqCmd_Pañ}N`ԈĂ̂ŁAC܂B
 *	* Tue Jul 01 22:19:13 JST 2014 Naoyuki Sawa
 *	- Cg[v\̍Đǉ܂B
 *	* Mon Jul 07 01:54:09 JST 2014 Naoyuki Sawa
 *	- SndSeq_Stop()SndSeq_StopAll()̈ɁAbForce(~)ǉ܂B
 *	* Tue May 05 17:15:43 JST 2015 Naoyuki Sawa
 *	- SndSeq_PlayNo()ǉ܂B
 */
#include "clip.h"
/****************************************************************************
 *	[Jϐ
 ****************************************************************************/
static ST_SndSeq stSndSeq;
/****************************************************************************
 *	[J֐錾
 ****************************************************************************/
static void SndTrk_Exec(int iTrk, int ElapsedTime);
static void SndSeqCh_Exec(int iSndSeqCh, int ElapsedTime);
/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/
/* TEhV[PTB
 * [in]
 *	pSndSeqInfo	ւ̃|C^
 * [note]
 *	- {֐́ARs[A|C^i[邱ƂɒӂB
 *	  AvP[V́A{֐ԂAύXjĂ͂ȂB
 */
void SndSeq_Init(const ST_SndSeqInfo* pSndSeqInfo) {
	/* TEhV[PTŜNAB */
	memset(&stSndSeq, 0, sizeof stSndSeq);
	/* 񂪐ł邱ƂmFB */
	if(!pSndSeqInfo || !pSndSeqInfo->fnTime || !pSndSeqInfo->fnPlay || !pSndSeqInfo->fnStop || !pSndSeqInfo->fnVol || !pSndSeqInfo->fnPan || !pSndSeqInfo->fnLen || !pSndSeqInfo->fnNext || !pSndSeqInfo->fnPrev) { DIE(); }
	/* ւ̃|C^i[B
	 * - Rs[ł͂ȂA|C^i[邱ƂɒӂBAvP[V́A{֐ԂAύXjĂ͂ȂB
	 */
	stSndSeq.pSndSeqInfo = pSndSeqInfo;
	/* gbNNAB */
	memset(stSndSeq.SndTrk, -1, sizeof stSndSeq.SndTrk); //,l
	/* O񎞍ƂāA̎i[B
	 * - sɒԌo߂邱Ƃ邽߁Aɗ́A̒OɎ擾̂K؂łB
	 *   m̂߂ɂ́AC[vJnOɈASndSeq_Exec()ĂяoĂƗǂB
	 */
	stSndSeq.Time = (*stSndSeq.pSndSeqInfo->fnTime)();
}
/*--------------------------------------------------------------------------*/
/* TEhV[PTsB
 * [note]
 *	- {֐́AAvP[ṼC[v(荞݊O),,^C}荞ݏ́Aǂ炩ĂԂ悤ɂĂǂB
 *	- {֐̒ŁAoߎԂ𔻒fAK؂Ȍ̃R}hsB
 *	  AvP[V́AKԊuŖ{֐ĂяoKv͖AC[v(rW[[v)ĂяoėǂB
 */
void SndSeq_Exec() {
	int Time, ElapsedTime, iTrk, iSndSeqCh;
	/* ݎ擾B */
	Time = (*stSndSeq.pSndSeqInfo->fnTime)();
	/* oߎԂvZB */
	ElapsedTime = Time - stSndSeq.Time;
	/* O񎞍ƂāAݎi[ */
	stSndSeq.Time = Time;
	/* fobOȂǂɁAoߎԂُɒȂ\L̂ŁASĂ̒le邱ƂɂB */
	if(ElapsedTime <    0) { ElapsedTime =    0; }	/* oߎԂ0bȂ΁A0bɕ␳B */
	if(ElapsedTime > 1000) { ElapsedTime = 1000; }	/* oߎԂ1b߂Ȃ΁A1bɕ␳B */
	/* egbNɂāc */
	for(iTrk = 0; iTrk <= SndTrk_Max; iTrk++) {
		/* gbNsB */
		SndTrk_Exec(iTrk, ElapsedTime);
	}
	//̏K{BtɂƁAĐJñgbÑCgJE^炵Ă܂B
	/* eTEhV[PT`lɂāc */
	for(iSndSeqCh = 0; iSndSeqCh <= SndSeqCh_Max; iSndSeqCh++) {
		/* TEhV[PT`lsB */
		SndSeqCh_Exec(iSndSeqCh, ElapsedTime);
	}
}
/*--------------------------------------------------------------------------*/
/* gbNAw肳ꂽoߎԂ̕AsB
 * [in]
 *	iTrk		gbNԍ(0`SndTrk_Max)
 *	ElapsedTime	oߎ[ms]
 */
static void SndTrk_Exec(int iTrk, int ElapsedTime) {
	ST_SndTrk* pSndTrk;
	int iPhr;
	/* gbNԍł邱ƂmFB */
	if((unsigned)iTrk > SndTrk_Max) { DIE(); }
	/* gbN擾B */
	pSndTrk = &stSndSeq.SndTrk[iTrk];
	/* Đ̃t[YACgt[YȂ΁c */
	if((pSndTrk->iPhr != -1) && (pSndTrk->Intr != -1)) {
		/* CgJE^oߎԂZA0ȉɂȂc */
		if((pSndTrk->Intr -= ElapsedTime) <= 0) {
			/* [vt[Y擾B */
			iPhr = (*stSndSeq.pSndSeqInfo->fnNext)(pSndTrk->iPhr);
			if(iPhr == -1) { DIE(); }
			/* gbNXVB */
			pSndTrk->iPhr = iPhr; /* Ll */
			/* CgJE^~B */
			pSndTrk->Intr = -1;
			/* ĐsB */
			(*stSndSeq.pSndSeqInfo->fnPlay)(iTrk, iPhr, pSndTrk->iVol, pSndTrk->iPan);
		}
	}
}
/*--------------------------------------------------------------------------*/
/* TEhV[PT`lAw肳ꂽoߎԂ̕AsB
 * [in]
 *	iSndSeqCh	TEhV[PT`lԍ(0`SndSeqCh_Max)
 *	ElapsedTime	oߎ[ms]
 */
static void SndSeqCh_Exec(int iSndSeqCh, int ElapsedTime) {
	ST_SndSeqCh* pSndSeqCh;
	ST_SndTrk* pSndTrk;
	int iCmd, Wait, iTrk, iPhr, iVol, iPan, iNext, iPrev;
	/* TEhV[PT`lԍł邱ƂmFB */
	if((unsigned)iSndSeqCh > SndSeqCh_Max) { DIE(); }
	/* TEhV[PT`l擾B */
	pSndSeqCh = &stSndSeq.SndSeqCh[iSndSeqCh];
	/* ~Ȃ΁AȂB */
	if(!pSndSeqCh->pData) { return; }
	/* EFCgJE^oߎԂZB0߂ȂΉȂB */
	pSndSeqCh->Wait -= ElapsedTime;
	/* EFCgJE^0ȉłԁAp^[R}hsB */
	while(pSndSeqCh->Wait <= 0) {
		/* p^[R}h擾B */
		iCmd = *pSndSeqCh->pData++;
		/* p^[R}hɂāc */
		switch(iCmd) {
		/* p^[I */
		case 0x00: /*  */
			/* V[PT~sB */
			SndSeq_Stop(iSndSeqCh, 0);
			return; /* ܂ */
		/* 1oCgEFCg */
		case 0x01: /* (ms-0x00001)[7:0] */
			/* EFCgԂ擾B */							//1oCgEFCg͈̔ = 0x00001+(0`0x000000FF) [ms]
			Wait  = ((*pSndSeqCh->pData++) + 1);
			/* EFCgJE^ɃEFCgԂZB */
			pSndSeqCh->Wait += Wait;
			break;
		/* 2oCgEFCg */
		case 0x02: /* (ms-0x00101)[7:0] (ms-0x00101)[15:8] */					//2oCgEFCg͈̔ = 0x00101+(0`0x0000FFFF) [ms]
			/* EFCgԂ擾B */
			Wait  = ((*pSndSeqCh->pData++) + 1);
			Wait += ((*pSndSeqCh->pData++) + 1) <<  8;
			/* EFCgJE^ɃEFCgԂZB */
			pSndSeqCh->Wait += Wait;
			break;
		/* 3oCgEFCg */
		case 0x03: /* (ms-0x10101)[7:0] (ms-0x10101)[15:8] (ms-0x10101)[23:16] */		//3oCgEFCg͈̔ = 0x10101+(0`0x00FFFFFF) [ms]
			/* EFCgԂ擾B */
			Wait  = ((*pSndSeqCh->pData++) + 1);
			Wait += ((*pSndSeqCh->pData++) + 1) <<  8;
			Wait += ((*pSndSeqCh->pData++) + 1) << 16;
			/* EFCgJE^ɃEFCgԂZB */
			pSndSeqCh->Wait += Wait;
			break;
		/* 4oCgEFCg */
		case 0x04: /* (ms        )[7:0] (ms        )[15:8] (ms        )[23:16] (ms)[31:24] */	//4oCgEFCg͈̔ =         (0`0xFFFFFFFF) [ms]
			/* EFCgԂ擾B */
			Wait  =  (*pSndSeqCh->pData++);
			Wait |=  (*pSndSeqCh->pData++)      <<  8;
			Wait |=  (*pSndSeqCh->pData++)      << 16;
			Wait |=  (*pSndSeqCh->pData++)      << 24;
			/* EFCgJE^ɃEFCgԂZB */
			pSndSeqCh->Wait += Wait;
			break;
		/* gbN~ */
		case 0x10: /* trk */
			/* gbNԍ擾B */
			iTrk = *pSndSeqCh->pData++;
			/* gbNԍł邱ƂmFB */
			if((unsigned)iTrk > SndTrk_Max) { DIE(); }
			/* gbN擾B */
			pSndTrk = &stSndSeq.SndTrk[iTrk];
			/* ̃TEhV[PT`l䂵ĂgbNȂ΁c */
			if(pSndTrk->iSndSeqCh == iSndSeqCh) {
				/* Đ̃t[YAʏt[YȂ΁c */
				if((*stSndSeq.pSndSeqInfo->fnNext)(pSndTrk->iPhr) == -1) {
					/* gbNNAB */
					memset(pSndTrk, -1, sizeof(ST_SndTrk)); /* ,l */
					/* gbN~sB */
					(*stSndSeq.pSndSeqInfo->fnStop)(iTrk);
				}
			}
			break;
		/* mĐ */
		case 0x11: /* trk phrL phrH vol pan */
			/* gbNԍ擾B */
			iTrk  = *pSndSeqCh->pData++;
			/* t[Yԍ擾B */
			iPhr  = *pSndSeqCh->pData++;
			iPhr |= *pSndSeqCh->pData++ << 8;
			/* {[擾B */
			iVol  = *pSndSeqCh->pData++;
			/* p擾B */
			iPan  = *pSndSeqCh->pData++;
			/* gbNԍ,t[Yԍ,{[,pł邱ƂmFB */
			if(((unsigned)iTrk > SndTrk_Max) || ((unsigned)iPhr > SndPhr_Max) || ((unsigned)iVol > SndVol_Max) || ((unsigned)iPan > SndPan_Max)) { DIE(); }
			/* gbN擾B */
			pSndTrk = &stSndSeq.SndTrk[iTrk];
			/* ̃TEhV[PT`l䂵ĂgbN,,
			 * Vt[Y[vt[Y  łƉ肵AĐ̃t[YCgt[Y,,[vt[YɈv
			 * ,,
			 * Vt[YCgt[YłƉ肵AĐ̃t[YCgt[Y,,[vt[YɈv
			 * Ȃ΁c */
			iNext = (*stSndSeq.pSndSeqInfo->fnNext)(iPhr);
			iPrev = (*stSndSeq.pSndSeqInfo->fnPrev)(iPhr);
			if((pSndTrk->iSndSeqCh == iSndSeqCh) &&
			   (((iNext != -1) && ((pSndTrk->iPhr == iNext) || (pSndTrk->iPhr == iPhr))) ||
			    ((iPrev != -1) && ((pSndTrk->iPhr == iPrev) || (pSndTrk->iPhr == iPhr))))) {
				/* Đ̃{[ƐV{[c */
				if(pSndTrk->iVol != iVol) {
					/* gbNXVB */
					pSndTrk->iVol = iVol; /* Ll */
					/* {[XVsB */
					(*stSndSeq.pSndSeqInfo->fnVol)(iTrk, iVol);
				}
				/* Đ̃pƐVpc */
				if(pSndTrk->iPan != iPan) {
					/* gbNXVB */
					pSndTrk->iPan = iPan; /* Ll */
					/* pXVsB */
					(*stSndSeq.pSndSeqInfo->fnPan)(iTrk, iPan);
				}
			/* łȂ΁c */
			} else {
				/* [vt[Y̍ĐJnwꂽꍇACgt[Y̍ĐJnɕϊB */
				if((iPrev != -1) && (iPrev != iPhr)) {
					iPhr = iPrev;
					/* [vt[ÝAϊOiPhrł͂Am̂߂ɍĎ擾邱ƂɂB */
					iNext = (*stSndSeq.pSndSeqInfo->fnNext)(iPhr);
				}
				/* gbNi[B */
				pSndTrk->iSndSeqCh = iSndSeqCh;
				pSndTrk->iPhr = iPhr; /* Ll */
				pSndTrk->iVol = iVol; /* Ll */
				pSndTrk->iPan = iPan; /* Ll */
				/* Cgt[YȂ΁ACgJE^ɍĐԂi[B
				 * Cgt[YȊOȂ΁ACgJE^(-1)i[B */
				pSndTrk->Intr = (iNext != -1) && (iNext != iPhr) ? (*stSndSeq.pSndSeqInfo->fnLen)(iPhr) : -1;
				/* ĐsB */
				(*stSndSeq.pSndSeqInfo->fnPlay)(iTrk, iPhr, iVol, iPan);
			}
			break;
		/* XeIĐ */
		case 0x12: /* trk phrL phrH vol */
			/* gbNԍ擾B */
			iTrk  = *pSndSeqCh->pData++;
			/* t[Yԍ擾B */
			iPhr  = *pSndSeqCh->pData++;
			iPhr |= *pSndSeqCh->pData++ << 8;
			/* {[擾B */
			iVol  = *pSndSeqCh->pData++;
			/* gbNԍ,t[Yԍ,{[ł邱ƂmFB */
			if(((unsigned)iTrk > SndTrk_Max) || ((unsigned)iPhr > SndPhr_Max) || ((unsigned)iVol > SndVol_Max)) { DIE(); }
			/* gbN擾B */
			pSndTrk = &stSndSeq.SndTrk[iTrk];
			/* ̃TEhV[PT`l䂵ĂgbN,,
			 * Vt[Y[vt[Y  łƉ肵AĐ̃t[YCgt[Y,,[vt[YɈv
			 * ,,
			 * Vt[YCgt[YłƉ肵AĐ̃t[YCgt[Y,,[vt[YɈv
			 * Ȃ΁c */
			iNext = (*stSndSeq.pSndSeqInfo->fnNext)(iPhr);
			iPrev = (*stSndSeq.pSndSeqInfo->fnPrev)(iPhr);
			if((pSndTrk->iSndSeqCh == iSndSeqCh) &&
			   (((iNext != -1) && ((pSndTrk->iPhr == iNext) || (pSndTrk->iPhr == iPhr))) ||
			    ((iPrev != -1) && ((pSndTrk->iPhr == iPrev) || (pSndTrk->iPhr == iPhr))))) {
				/* Đ̃{[ƐV{[c */
				if(pSndTrk->iVol != iVol) {
					/* gbNXVB */
					pSndTrk->iVol = iVol; /* Ll */
					/* {[XVsB */
					(*stSndSeq.pSndSeqInfo->fnVol)(iTrk, iVol);
				}
			/* łȂ΁c */
			} else {
				/* [vt[Y̍ĐJnwꂽꍇACgt[Y̍ĐJnɕϊB */
				if((iPrev != -1) && (iPrev != iPhr)) {
					iPhr = iPrev;
					/* [vt[ÝAϊOiPhrł͂Am̂߂ɍĎ擾邱ƂɂB */
					iNext = (*stSndSeq.pSndSeqInfo->fnNext)(iPhr);
				}
				/* gbNi[B */
				pSndTrk->iSndSeqCh = iSndSeqCh;
				pSndTrk->iPhr = iPhr; /* Ll */
				pSndTrk->iVol = iVol; /* Ll */
				pSndTrk->iPan =   -1; /* l */
				/* Cgt[YȂ΁ACgJE^ɍĐԂi[B
				 * Cgt[YȊOȂ΁ACgJE^(-1)i[B */
				pSndTrk->Intr = (iNext != -1) && (iNext != iPhr) ? (*stSndSeq.pSndSeqInfo->fnLen)(iPhr) : -1;
				/* ĐsB */
				(*stSndSeq.pSndSeqInfo->fnPlay)(iTrk, iPhr, iVol, -1/*l*/);
			}
			break;
		/* {[XV */
		case 0x20: /* trk vol */
			/* gbNԍ擾B */
			iTrk = *pSndSeqCh->pData++;
			/* {[擾B */
			iVol = *pSndSeqCh->pData++;
			/* gbNԍ,{[ł邱ƂmFB */
			if(((unsigned)iTrk > SndTrk_Max) || ((unsigned)iVol > SndVol_Max)) { DIE(); }
			/* gbN擾B */
			pSndTrk = &stSndSeq.SndTrk[iTrk];
			/* ̃TEhV[PT`l䂵ĂgbNȂ΁c */
			if(pSndTrk->iSndSeqCh == iSndSeqCh) {
				/* Đ̃{[ƐV{[c */
				if(pSndTrk->iVol != iVol) {
					/* gbNXVB */
					pSndTrk->iVol = iVol; /* Ll */
					/* {[XVsB */
					(*stSndSeq.pSndSeqInfo->fnVol)(iTrk, iVol);
				}
			}
			break;
		/* pXV */
		case 0x21: /* trk pan */
			/* gbNԍ擾B */
			iTrk = *pSndSeqCh->pData++;
			/* p擾B */
			iPan  = *pSndSeqCh->pData++;
			/* gbNԍ,pł邱ƂmFB */
			if(((unsigned)iTrk > SndTrk_Max) || ((unsigned)iPan > SndPan_Max)) { DIE(); }
			/* gbN擾B */
			pSndTrk = &stSndSeq.SndTrk[iTrk];
			/* ̃TEhV[PT`l䂵ĂgbNȂ΁c */
			if(pSndTrk->iSndSeqCh == iSndSeqCh) {
				/* Đ̃pƐVpc */
				if(pSndTrk->iPan != iPan) {
					/* gbNXVB */
					pSndTrk->iPan = iPan; /* Ll */
					/* pXVsB */
					(*stSndSeq.pSndSeqInfo->fnPan)(iTrk, iPan);
				}
			}
			break;
		default:
			DIE(); /* p^[R}hs */
		}
	}
}
/*--------------------------------------------------------------------------*/
/* p^[f[^ĐJnB
 * [in]
 *	iSndSeqCh	TEhV[PT`lԍ(0`SndSeqCh_Max)
 *	pData		p^[f[^̃AhX
 */
void SndSeq_Play(int iSndSeqCh, const void* pData) {
	ST_SndSeqCh* pSndSeqCh;
	/* TEhV[PT`lԍƃp^[f[^̃AhXł邱ƂmFB */
	if(((unsigned)iSndSeqCh > SndSeqCh_Max) || (!pData)) { DIE(); }
	/* TEhV[PT`lmɒ~B */
	SndSeq_Stop(iSndSeqCh, 0);
	/* TEhV[PT`l擾B */
	pSndSeqCh = &stSndSeq.SndSeqCh[iSndSeqCh];
ENTER_CS;
	/* p^[f[^̃AhXi[B */
	pSndSeqCh->pData = pData;
	/* EFCgJE^NAB */
	pSndSeqCh->Wait  = 0;
	/* p^[f[^擪0ms^C~Oɑ鏈𑦎sB
	 * - ȂƁASndSeq_Play()SndSeq_Stop()AŌĂяoɁAp^[f[^擪0ms^C~Oɑ鏈Asꂽ肳Ȃ肵ĕsɂȂB
	 *   ɁAp^[f[^擪0ms^C~OɁA[vt[Yݒ肳ĂAĐ̖[vt[Y~߂鏈ݒ肳ĂꍇɁA肪ƂȂB
	 *   p^[f[^擪0ms^C~Oɑ鏈́A荞݃^C~OɊ֌WKŝRłƍlAp^[f[^擪̏𑦎s邱ƂɂB
	 */
	SndSeqCh_Exec(iSndSeqCh, 0);
LEAVE_CS;
}
/*--------------------------------------------------------------------------*/
/* TEhV[PT`l~B
 * [in]
 *	iSndSeqCh	TEhV[PT`lԍ(0`SndSeqCh_Max)
 *	bForce		~tOB~Ƃ́A[vt[Y܂߁ÃTEhV[PT`l䂵Ă(,Ă)gbNSĒ~邱ƂłB
 * [note]
 *	- {֐́AuAvP[VɂA荞݊ǑĂяovƁuSndSeqCh_Exec()ɂA荞ݓ(͊荞݊Oł)̌Ăяov́AĂяoB
 *	  {֐̏Hv̂ŁA{֐ł̊荞݋֎~͕svƂȂB
 */
void SndSeq_Stop(int iSndSeqCh, int bForce) {
	ST_SndSeqCh* pSndSeqCh;
	ST_SndTrk* pSndTrk;
	int iTrk;
	/* TEhV[PT`lԍł邱ƂmFB */
	if((unsigned)iSndSeqCh > SndSeqCh_Max) { DIE(); }
	/* TEhV[PT`l擾B */
	pSndSeqCh = &stSndSeq.SndSeqCh[iSndSeqCh];
/*{{̏ŏ΁A荞݋֎~svłB*/
	/* ~w肳Ă炸,,~Ȃ΁AȂB */	//TEhV[PT`l~鎞ɁA[vt[Y͒~Ȃ̂ŁAĐpĂ\B
	if(!bForce && !pSndSeqCh->pData) { return; }				//~w肳ꂽꍇ́A[vt[Y~邽߂ɁATEhV[PT`l~ĂĂAȉ̏sB
	/* p^[f[^̃AhXNAB */
	pSndSeqCh->pData = NULL;						//ɒ~ĂTEhV[PT`lɑ΂āA~w肳ꂽꍇ́Ȁ͖ʏƂȂ邪ł邪AQ͖B
	/* egbNɂāc */
	for(iTrk = 0; iTrk <= SndTrk_Max; iTrk++) {
		/* gbN擾B */
		pSndTrk = &stSndSeq.SndTrk[iTrk];
		/* ̃TEhV[PT`l䂵ĂgbNȂ΁c */
		if(pSndTrk->iSndSeqCh == iSndSeqCh) {
			/* ~w肳Ă邩,,Đ̃t[Yʏt[YȂ΁c */
			if(bForce || (*stSndSeq.pSndSeqInfo->fnNext)(pSndTrk->iPhr) == -1) {
				/* gbNNAB */
				memset(pSndTrk, -1, sizeof(ST_SndTrk)); /* ,l */
				/* gbN~sB */
				(*stSndSeq.pSndSeqInfo->fnStop)(iTrk);
			}
		}
	}
/*}}̏ŏ΁A荞݋֎~svłB*/
}
/*--------------------------------------------------------------------------*/
/* TEhV[PT`lSĒ~B
 * [in]
 *	bForce		~tOB~Ƃ́A[vt[Y܂߁ÃTEhV[PT`l䂵Ă(,Ă)gbNSĒ~邱ƂłB
 */
void SndSeq_StopAll(int bForce) {
	int iSndSeqCh;
	/* eTEhV[PT`lɂāc */
	for(iSndSeqCh = 0; iSndSeqCh <= SndSeqCh_Max; iSndSeqCh++) {
		/* TEhV[PT`l~B */
		SndSeq_Stop(iSndSeqCh, bForce);
	}
}
/*--------------------------------------------------------------------------*/
/* gbN擾B
 * [in]
 *	iTrk		gbNԍ
 *	pSndTrk		gbNi[\̂ւ̃|C^
 * [note]
 *	- stSndSeq.SndTrk[]̓éA荞ݓĂяoꂽSndSeq_Exec()ɂāA񓯊ɕύX\̂ŁAڎQƂĂ͂ȂB
 *	  AvP[VgbNQƂꍇ́A{֐ĂяoăXibvVbg擾邱ƁB
 */
void SndSeq_GetTrk(int iTrk, ST_SndTrk* pSndTrk) {
	/* gbNԍƃgbNi[\̂ւ̃|C^ł邱ƂmFB */
	if(((unsigned)iTrk > SndTrk_Max) || !pSndTrk) { DIE(); }
ENTER_CS;/*Rs[ɃgbN񂪕ωȂ悤A荞݋֎~䂪KvłB*/
	/* gbNRs[B */
	memcpy(pSndTrk, &stSndSeq.SndTrk[iTrk], sizeof(ST_SndTrk));
LEAVE_CS;/*Rs[ɃgbN񂪕ωȂ悤A荞݋֎~䂪KvłB*/
}
/****************************************************************************
 *	dSndSeqC.exeo͂oCi`߂̃[eBeB֐
 ****************************************************************************/
#ifdef  USE_SNDDEF_BIN
void SndSeq_PlayNo(int iSndSeqCh, const void* pSndDefBin, int iSndSeqNo) {
	const int* const TBL_SndSeqNo = pSndDefBin;						//oCi̐擪ɃAhXe[uLBAhX̓f[^{(BYTEz)̃CfNXłB
	const int nSndSeqNo = TBL_SndSeqNo[0];							//AhXe[u̐擪[0]ɗvfĂBvf͂ꎩg([0])܂ށB
	const unsigned char* const TBL_SndSeq = (const unsigned char*)&TBL_SndSeqNo[nSndSeqNo];	//AhXe[u̒ォf[^{(BYTEz)JnB
	if((iSndSeqNo <= 0) || (iSndSeqNo >= nSndSeqNo)) { DIE(); }
	SndSeq_Play(iSndSeqCh, &TBL_SndSeq[TBL_SndSeqNo[iSndSeqNo]]);
}
#endif//USE_SNDDEF_BIN
/****************************************************************************
 *	Tv
 ****************************************************************************/
//	//t[Yԍ`Bۂɂsound.hɂĒ`B
//	#define SND_BGM1_INTR 1
//	#define SND_BGM1_LOOP 2
//	#define SND_BGM2_LOOP 3
//	#define SND_BGM3_LOOP 4
//	#define SND_SE1       5
//	#define SND_SE2       6
//	#define SND_SE3       7
//	//ȉ́ATEh}l[WƃV[PT𕹗płBTEh}l[Wgp邱Ƃ͕K{ł͂ȂBځAsound_play()ĂяoĂ\ȂB
//	extern const ST_SndMgrInfo stSndMgrInfo; //TEh}l[W̒`́Aclipsndm.hQƂB
//	ST_SndMgr* pSndMgr;
//	//--- V[PTR[obN֐ ---
//	static int SndSeq_fnLen(int iPhr) {
//		return ppd_playback_time(sound_table[iPhr]);
//	}
//	static int SndSeq_fnNext(int iPhr) {
//		switch(iPhr) {
//		case SND_BGM1_INTR: return SND_BGM1_LOOP;
//		case SND_BGM1_LOOP: return SND_BGM1_LOOP;
//		case SND_BGM2_LOOP: return SND_BGM2_LOOP;
//		case SND_BGM3_LOOP: return SND_BGM3_LOOP;
//		}
//		return -1;
//	}
//	static int SndSeq_fnPrev(int iPhr) {
//		switch(iPhr) {
//		case SND_BGM1_INTR: return SND_BGM1_INTR;
//		case SND_BGM1_LOOP: return SND_BGM1_INTR;
//		case SND_BGM2_LOOP: return SND_BGM2_LOOP;
//		case SND_BGM3_LOOP: return SND_BGM3_LOOP;
//		}
//		return -1;
//	}
//	static void SndSeq_fnPan(int iTrk, int iPan) {
//		//P/ECEɂ̓XeIĐ͖̂ŁA{֐͎gpȂB
//	}
//	static void SndSeq_fnVol(int iTrk, int iVol) {
//		int Att = (SndVol_Max - iVol) * 64 / SndVol_Max; //{[ˌʕϊ
//		SndMgr_AttCh(pSndMgr, iTrk, Att, 0/**/); //ωԂ͑ƂBTEh}l[Wɂ錸ʂAIɕω@\͎gȂBV[PT{[wB
//	}
//	static void SndSeq_fnStop(int iTrk) {
//		SndMgr_StopCh(pSndMgr, iTrk);
//	}
//	static void SndSeq_fnPlay(int iTrk, int iPhr, int iVol, int iPan) {
//		SndMgr_PlayCh(pSndMgr, iTrk, iPhr, -1/*[v*/); //ɖ[vƂčĐB~^C~O͂̎ɃV[PTIɎwB
//		SndSeq_fnVol(iTrk, iVol);
//		//P/ECEɂ̓XeIĐ͖̂ŁAiPan𖳎B
//	}
//	static int SndSeq_fnTime() {
//		return pceTimerGetCount(); //ݎ[ms]PʂŕԂB
//	}
//	static const ST_SndSeqInfo stSndSeqInfo = { &SndSeq_fnTime, &SndSeq_fnPlay, &SndSeq_fnStop, &SndSeq_fnVol, &SndSeq_fnPan, &SndSeq_fnLen, &SndSeq_fnNext, &SndSeq_fnPrev };
//	//--- eXg֐ ---
//	void TestInit() {
//		pSndMgr = SndMgr_Init(&stSndMgrInfo, 0, SOUND_MAXCH-1); //Sound Manager
//		SndSeq_Init(&stSndSeqInfo);
//	}
//	//--- eXgC֐ ---
//	static const unsigned char PatternData[] = {
//		SndSeqCmd_PlayM(0,SND_BGM1_INTRO,128,64),	//gbN0BGM1ĐJnBCgt[YĐAIɃ[vt[Y֑JڂB
//		SndSeqCmd_Wait2(1000),				//1b҂
//		SndSeqCmd_Vol(0,64),				//gbN0BGM1
//		SndSeqCmd_PlayM(1,SND_SE1,128,64),		//gbN1SE1ĐJn
//		SndSeqCmd_PlayM(2,SND_SE2,128,64),		//gbN2SE2ĐJn
//		SndSeqCmd_Wait2(1000),				//1b҂
//		SndSeqCmd_Stop(1),				//gbN1SE1~
//		SndSeqCmd_Vol(0,128),				//gbN0BGM1A
//		SndSeqCmd_Wait2(1000),				//1b҂
//		SndSeqCmd_Stop(0),				//gbN0BGM1~BBGM1͖[vt[YȂ̂ŁAۂɂ͒~ȂB̃R}h͖Ă\ȂB
//		SndSeqCmd_End(),				//p^[IBgbN0BGM1͍ĐpBgbN2SE2͎~B
//	};
//	void TestMain() {
//		for(;;) {
//			schedule();
//			SndMgr_Exec(pSndMgr);	//SndMgr_Exec()1fPʂɓē삷邪A
//			SndSeq_Exec();		//SndSeq_Exec()͎Ԃɓē삷邱ƂɒӂB
//			if(joy & TRG_A) { SndSeq_Play(0, PatternData); }
//			if(joy & TRG_B) { SndSeq_Stop(0, 0); }
//		}
//	}
