/*
 *	app.c
 *
 *	UTF-8eLXgr[A
 *
 *	* Sun Mar 08 12:12:40 JST 2015 Naoyuki Sawa
 *	- 1st [XB
 */
#include "app.h"

/****************************************************************************
 *	
 ****************************************************************************/

#ifdef USE_SOUND
const void* sound_table[SOUND_COUNT];
#endif /*USE_SOUND*/

#ifdef USE_TEXTURE
TEXTURE texture_table[TEXTURE_COUNT];
#endif /*USE_TEXTURE*/

#ifdef USE_SPRITE
#define SPRITE_ SPRITE_INIT2
const SPRITE sprite_table[SPRITE_COUNT] = {
#include "sprite.h"
};
#undef SPRITE_
#endif /*USE_SPRITE*/

#define extern
#include "work.h"
#undef extern

/****************************************************************************
 *	main
 ****************************************************************************/

int
main()
{
	/* B */
	app_init();

	/* C[vB */
	app_main();

	return 0;
}

/****************************************************************************
 *	app_init
 ****************************************************************************/

#ifdef  USE_SOUND_MANAGER
static void sound_play_stub(int iCh, int iData, int iLoop) {
	if((unsigned)iData >= SOUND_COUNT) { DIE(); }
	sound_play(iCh, sound_table[iData], iLoop);
}
#endif/*USE_SOUND_MANAGER*/

#ifdef  USE_SOUND_MIXER
static void SndMxr_Update() {
	int i;
	unsigned char AttSum[32];
	SndMxr_GetSndChAttAll(pSndMxr,-1,AttSum); //Sق̌ʂ擾
	for(i=0;i<SOUND_MAXCH;i++) {sound_att(i,AttSum[i]);} //Sق̌ʂݒ肷
}
static void SndMxr_TimerProc(void* context) { //Sound Mixerpϊ
	if(sound_stat(1)) {SndMxr_SetMxrChAtt(pSndMxr,4,64, 0,0);} //1ŉoBGMĐȂΤðBGM𑦏          
	else              {SndMxr_SetMxrChAtt(pSndMxr,4, 0,64,5);} //1ŉoBGM~ȂΤðBGM0.5bŕA     {{TODO:عݒ}}
	if(sound_stat(3)) {SndMxr_SetMxrChAtt(pSndMxr,5,64, 0,0);} //3ŴװĐȂΤðBGM,oBGM,SE𑦏 
	else              {SndMxr_SetMxrChAtt(pSndMxr,5, 0, 0,0);} //3Ŵװ~ȂΤðBGM,oBGM,SE𑦕A 
	SndMxr_Exec(pSndMxr); //Sound Mixers
	SndMxr_Update(); //Sق̌ʂݒ肷
}
#endif/*USE_SOUND_MIXER*/

#ifdef  USE_SOUND_SEQUENCER
static int SndSeq_fnLen(int iPhr) {
	return ppd_playback_time(sound_table[iPhr]);
}
static int SndSeq_fnNext(int iPhr) {
	return (iPhr == SND_BGM_1G) || (iPhr == SND_BGM_ST) ? iPhr : -1;
}
static int SndSeq_fnPrev(int iPhr) {
	return (iPhr == SND_BGM_1G) || (iPhr == SND_BGM_ST) ? iPhr : -1;
}
static void SndSeq_fnPan(int iTrk, int iPan) {
	//P/ECEɂ̓XeIĐ͖̂ŁA{֐͎gpȂB
}
static void SndSeq_fnVol(int iTrk, int iVol) {
	SndMxr_SetMxrChAtt(pSndMxr, iTrk, 64-(iVol*64/SndVol_Max), 0, 0);
	SndMxr_Update();
}
static void SndSeq_fnStop(int iTrk) {
	sound_stop(iTrk);
}
static void SndSeq_fnPlay(int iTrk, int iPhr, int iVol, int iPan) {
	sound_play(iTrk, sound_table[iPhr], -1);
	SndMxr_SetMxrChAtt(pSndMxr, iTrk, 64-(iVol*64/SndVol_Max), 0, 0);
	SndMxr_Update();
}
static int SndSeq_fnTime() {
	return pceTimerGetCount(); //ݎ[ms]PʂŕԂB
}
#endif/*USE_SOUND_SEQUENCER*/

#ifdef  USE_EVENT_TIMER
static void EvtTmr_onEvent(int iEvtTmrCh, int iEvent) { //ϗpď֐
	TRACE("%d:%d:%d\n", now / FPS, iEvtTmrCh, iEvent);
}
#endif/*USE_EVENT_TIMER*/

#ifdef  USE_LOG_BUFFER
static int LogBuf_fnDraw(int x, int y, const char* Str) { //عݒ`̕`֐
	render_reduced_string(&render, x, y, Str, 3);
	return 10;
}
#endif/*USE_LOG_BUFFER*/

#ifdef  USE_TCL
//srand seed
static int Tcl_SrandCmd(Tcl_Interp* iPtr) {
	if((iPtr->argc < 1) || (iPtr->argc > 2)) { DIE(); }
	srand((iPtr->argc == 2) ? atoi(iPtr->argv[1]) : time(NULL));
	return TCL_OK;
}
//rand
static int Tcl_RandCmd(Tcl_Interp* iPtr) {
	if(iPtr->argc != 1) { DIE(); }
	iPtr->result = strdup_printf("%d", rand());
	return TCL_OK;
}
//log string
static int Tcl_LogCmd(Tcl_Interp* iPtr) {
	if(iPtr->argc != 2) { DIE(); }
#ifdef  USE_LOG_BUFFER
	LogBuf_Print(pLogBuf, iPtr->argv[1]);
	update();
#else //USE_LOG_BUFFER
	TRACE("%s\n", iPtr->argv[1]);
#endif//USE_LOG_BUFFER
	return TCL_OK;
}
//schedule
static int Tcl_ScheduleCmd(Tcl_Interp* iPtr) {
	if(iPtr->argc != 1) { DIE(); }
	schedule();
	return TCL_OK;
}
#endif//USE_TCL

void
app_init()
{
#ifdef  USE_USBSUSPEND_PROBLEMWORKAROUND
	//uUSBTXyhP/ECEnOAbv鎖Lv鏈ݒ肵܂B
	Intel915G_WindowsXp_UsbSuspend_ProblemWorkaround_init();
#endif//USE_USBSUSPEND_PROBLEMWORKAROUND

	/* ʓIȏB */
	pceAppSetProcPeriod(1000 / FPS);
#ifdef V_SCREEN
	pceLCDSetBuffer(_def_vbuff);
#else /*V_SCREEN*/
	pceLCDSetBuffer(vbuff);
#endif /*V_SCREEN*/
//sv	pceLCDDispStart();	//{{2014/12/31폜:cstart.cpceAppInit00()pceLCDDispStart()ĂяoAtʂ̕\Jn悤ɂ܂B}}
#ifdef USE_REPEAT
	pad_set_repeat(REPEAT_PAD, REPEAT_DELAY, REPEAT_INTERVAL);
#endif /*USE_REPEAT*/

	/* `B */
	surface.w = DISP_X;
	surface.h = DISP_Y;
	surface.vbuff = vbuff;
#ifdef USE_3D
	surface.zbuff = zbuff;
	render_init_3d(&render, &surface, 0, 0, 0, 0, FRONT, BACK, FOVY);
#else /*USE_3D*/
	render_init_2d(&render, &surface, 0, 0, 0, 0);
#endif /*USE_3D*/
#ifdef USE_RENDF
	surface.zbuff = zbuff;
	rendf_init(&rendf, &surface, 0, 0, 0, 0, FRONT, BACK, FOVY);
#endif /*USE_RENDF*/

#if defined(TRACE_ON) && (TRACE_ON)
	/* WG[o͂J܂B */
	stderr_open(9/*WG[o̓j^ڑ҂()*/);
#endif /*TRACE_ON*/

#ifdef USE_UFE
	/* USBt@CVXeG~[VJn܂B */
	ufe_setup(9/*PCt@CT[oڑ҂()*/);
#endif /*USE_UFE*/

#ifdef USE_RESOURCE
	/* pext@CYt\[X擾܂B */
	resource = resource_address(PRESCAN_STRINGIFY(PROJECT) ".pex");
#endif /*USE_RESOURCE*/

#ifdef TURBO
	/* NbNEEFCgؑւ܂B */
	turbo(TURBO);
#endif /*TURBO*/

#ifdef USE_DBG
	/* DBGjbgݒ肵܂B */
	dbg_init();
#endif /*USE_DBG*/

#ifdef GC_LEVEL
	/* K[x[WRN^[܂B */
	gc_init(GC_LEVEL);
#endif /*GC_LEVEL*/

#ifdef BITMAP_GC_UNIT
	/* Bitmap GC܂B */
	BitmapGC_Init(BITMAP_GC_UNIT);
#endif /*BITMAP_GC_UNIT*/

#ifdef LDIRECT_INTERVAL
	/* ؑցE16K\܂B */
	ldirect_init(LDIRECT_INTERVAL);
#endif /*LDIRECT_INTERVAL*/

#ifdef USE_MUSIC
	/* yCu܂B */
	InitMusic();
#if defined(USE_2BIT_ADPCM) || defined(USE_TRUESPEECH)
	/* - 2-bit ADPCM Decoder,,DSP Group TrueSpeech DecoderƁAyCu𕹗pꍇ́AyCu̎gp`l炷Ƃɂ܂B
	 *   ̑΍sȂƁA`l0gp悤ƂāAnOAbvĂ܂܂B
	 * - 2-bit ADPCM Decoder,,DSP Group TrueSpeech DecoderɌ炸Astream_play()𗘗p@\ƁAyCuƕpꍇ́Al̑΍􂪕KvłB
	 * //{{2015/01/15Rg폜:muslib.cłInitMusic()́umusic_wch = 0;vsȂ悤ɂ̂ŁAǂ̃^C~Omusic_wchύXĂ\܂B
	 * //- music_wchύX鏈́AInitMusic()ōsKv܂B
	 * //  InitMusic()Aumusic_wch = 0;vsĂ邩łBInitMusic()ɕύXƁA0ɖ߂Ă܂܂B
	 * //- Amusic_loudness()̋@\music_wchQƂĂ܂A
	 * //  Al擾Ă̂ŁAmusic_loudness()Ăяomusic_wchύXĂA͂܂B
	 * //}}2015/01/15Rg폜:muslib.cłInitMusic()́umusic_wch = 0;vsȂ悤ɂ̂ŁAǂ̃^C~Omusic_wchύXĂ\܂B */
	music_wch = 3; /* `l0=2-bit ADPCM Decoder,,DSP Group TrueSpeech DecoderA`l1-2=AvP[VgpA`l3=yCuƂ */
#endif /*defined(USE_2BIT_ADPCM) || defined(USE_TRUESPEECH)*/
#endif /*USE_MUSIC*/

	/* N[Abv֐o^B */
	atexit(app_exit);

#ifdef USE_2BIT_ADPCM
	/* 2-bit ADPCM DecoderN܂B */
	adpcm_init(SOUND_MAXCH);
#endif /*USE_2BIT_ADPCM*/

#ifdef USE_TRUESPEECH
	/* DSP Group TrueSpeech DecoderN܂B */
	TrueSpeech_Init(SOUND_MAXCH);
#endif /*USE_TRUESPEECH*/

	/* TEh܂B */
#ifdef USE_SOUND
	{
#define SOUND_(name) { extern const unsigned char name[]; sound_table[SND_##name] = name; }
#define SOUND_RESOURCE_(name,fname) { sound_table[SND_##name] = fpk_address(resource, fname, NULL); }
#include "sound.h"
#undef SOUND_
#undef SOUND_RESOURCE_
	}
#endif /*USE_SOUND*/

	/* Sound Manager܂B */
#ifdef  USE_SOUND_MANAGER
	{
		static const ST_SndMgrInfo stSndMgrInfo = { sound_play_stub, sound_stop, sound_stat, sound_att };
		pSndMgrBgm = SndMgr_Init(&stSndMgrInfo, SOUND_MANAGER_BGM_MINCH, SOUND_MANAGER_BGM_MAXCH); /* BGM Sound Manager */
		pSndMgrSe1 = SndMgr_Init(&stSndMgrInfo, SOUND_MANAGER_SE1_MINCH, SOUND_MANAGER_SE1_MAXCH); /* SE1 Sound Manager */
		pSndMgrSe2 = SndMgr_Init(&stSndMgrInfo, SOUND_MANAGER_SE2_MINCH, SOUND_MANAGER_SE2_MAXCH); /* SE2 Sound Manager */
	}
#endif/*USE_SOUND_MANAGER*/

	/* Sound Mixer܂B */
#ifdef  USE_SOUND_MIXER
	{
		static const int TBL_SndMxr_SndChMask[] = { //Ͻz
			(1<<0),               //Sound Mixer0:ׯ0(޼ݻɂحюw)         
			(1<<1),               //Sound Mixer1:ׯ1(޼ݻɂحюw)         
			(1<<2),               //Sound Mixer2:ׯ2(޼ݻɂحюw)         
			(1<<3),               //Sound Mixer3:ׯ3(޼ݻɂحюw)         {{TODO:عݒ}}
			(1<<0),               //Sound Mixer4:oBGMĐΏ:ðBGM            
			(1<<0)|(1<<1)|(1<<2), //Sound Mixer5:װĐΏ  :ðBGM,oBGM,SE 
			-1};                  //Sound Mixer6:İح           :S         
		pSndMxr = SndMxr_Init(ARRAY_SIZE(TBL_SndMxr_SndChMask), TBL_SndMxr_SndChMask); //Sound Mixer쐬
		timer_start(100, SndMxr_TimerProc, NULL); //Sound MixerpϊJn
	}
#endif/*USE_SOUND_MIXER*/

	/* TEhV[PT܂B */
#ifdef  USE_SOUND_SEQUENCER
	{
		static const ST_SndSeqInfo stSndSeqInfo = { &SndSeq_fnTime, &SndSeq_fnPlay, &SndSeq_fnStop, &SndSeq_fnVol, &SndSeq_fnPan, &SndSeq_fnLen, &SndSeq_fnNext, &SndSeq_fnPrev };
		SndSeq_Init(&stSndSeqInfo);
		timer_start(10, SndSeq_Exec, NULL); //޼ݻpϊJn
	}
#endif/*USE_SOUND_SEQUENCER*/

	/* Cxg^C}܂B */
#ifdef  USE_EVENT_TIMER
	{
		static const uint16_t TBL_EvtTmr_Data0[]={//#0ް
			SEC(0),10, //Jnɤޔԍ(10)s
			SEC(2),11, // 2b҂Ĥޔԍ(11)s
			SEC(1),12, // 1b҂Ĥޔԍ(12)s
			SEC(0),13, //̌シޔԍ(13)s
			SEC(3),-1};// 3b҂Ĥ擪ٰ߂
		static const uint16_t TBL_EvtTmr_Data1[]={//#1ް
			SEC(9),20, // 9b҂Ĥޔԍ(20)s
			SEC(0), 0};//̌シI
		static const uint16_t* const TBL_EvtTmr_Data[]={//eقް
			TBL_EvtTmr_Data0, //#0ް
			TBL_EvtTmr_Data1};//#1ް
		pEvtTmr=EvtTmr_Init(ARRAY_SIZE(TBL_EvtTmr_Data),TBL_EvtTmr_Data,EvtTmr_onEvent);//ς
	}
#endif/*USE_EVENT_TIMER*/

	/* ėpJE^Ǘ܂B */
#ifdef  USE_COUNTER_MANAGER
	pCntMgr = CntMgr_Init(COUNTER_MAXCH);
#endif/*USE_COUNTER_MANAGER*/

	/* Oobt@܂B */
#ifdef  USE_LOG_BUFFER
	pLogBuf = LogBuf_Init((DISP_Y+9)/10, LogBuf_fnDraw);
#endif/*USE_LOG_BUFFER*/

#ifdef  USE_TCL
	//TclC^v^邽߂ɁAIɃK[x[WRNVsB
#if     defined(GC_LEVEL)
/*K{*/timer_start(500/**/, gc_run, NULL);//cliptcl.c̃RgQƁBʏGCTclC^v^gpꍇ́A̍ssȂƋɒ[ɒxȂB
#elif   defined(BITMAP_GC_UNIT)
//C	timer_start(500/**/, gc_run, NULL);//cliptcl.c̃RgQƁBBitmap GCgpꍇ͋ɒ[ɒx͂ȂA̍ssł͂B
#else //defined(GC_LEVEL)||defined(BITMAP_GC_UNIT)
	#error TclC^v^̓K[x[WRN^[̕pK{łB
#endif//defined(GC_LEVEL)||defined(BITMAP_GC_UNIT)
	//TclC^v^쐬B
	iPtr = Tcl_CreateInterp();
	//ėpIȃAvP[V`̃R}ho^B
	Tcl_CreateCommand(iPtr, "srand",    Tcl_SrandCmd,    NULL);
	Tcl_CreateCommand(iPtr, "rand",     Tcl_RandCmd,     NULL);
	Tcl_CreateCommand(iPtr, "log",      Tcl_LogCmd,      NULL);
	Tcl_CreateCommand(iPtr, "schedule", Tcl_ScheduleCmd, NULL);
#endif//USE_TCL

	/* eNX`܂B */
#ifdef USE_TEXTURE
	{
#define TEXTURE_(name) extern const unsigned char name[];
#define TEXTURE_RESOURCE_(name,fname) const void* const name = fpk_address(resource, fname, NULL);
#include "texture.h"
#undef TEXTURE_
#undef TEXTURE_RESOURCE_
		texture_table_init(texture_table, TEXTURE_COUNT,
#define TEXTURE_(name) name,
#define TEXTURE_RESOURCE_(name,fname) name,
#include "texture.h"
#undef TEXTURE_
#undef TEXTURE_RESOURCE_
		NULL/*Ō','z邽߂̃_~[Btexture_table_init()ɑ΂Ă͖ӖłB*/);
	}
#endif /*USE_TEXTURE*/

#ifdef USE_SPRITE
	/* ȈՃXvCghCo܂B */
	sprite_init(&render, sprite_table, SPRITE_COUNT, texture_table, TEXTURE_COUNT);
#endif /*USE_SPRITE*/

#ifdef USE_TCPIP
	/* TCP/IPvgRXC[gJn܂B */
	tcpip_start(0/*EthernethCoMobt@TCY()*/);
#endif /*USE_TCPIP*/

#ifdef USE_VIDREC
	/* ʏo͂܂B */
	yield(); /* runŎsꍇ̎smFɉ邽߁AUSB@\̐؂ւ͂ɒx点 */
#ifdef LDIRECT_INTERVAL
	cdcacm_start(0, sizeof vbuff / 2, NULL, NULL);
#else /*LDIRECT_INTERVAL*/
	cdcacm_start(0, sizeof vbuff / 4, NULL, NULL);
#endif /*LDIRECT_INTERVAL*/
#endif /*USE_VIDREC*/

#ifdef  USE_TASK
	/* ^XNXPW[܂B
	 * - AChXbhƕpꍇ́Aidle_proc()̒ŏĂB
	 *   AChXbhƕp@́Atask_yield()[note]QƂĂB */
	task_init(INT_MIN);//{{TODO:ѱ̎sDxͱعݒ}}
#endif/*USE_TASK*/

/*{{AvP[VL̏*/
	srand(pceTimerGetCount());
/*}}AvP[VL̏*/
}

/****************************************************************************
 *	app_exit
 ****************************************************************************/

void
app_exit()
{
/*{{AvP[VL̃N[Abv*/
	/** no job **/
/*}}AvP[VL̃N[Abv*/

#ifdef USE_VIDREC
	/* ʏo͂I܂B */
	cdcacm_stop();
#endif /*USE_VIDREC*/

#ifdef USE_TCPIP
	/* TCP/IPvgRXC[gI܂B */
	tcpip_stop();
#endif /*USE_TCPIP*/

#ifdef LDIRECT_INTERVAL
	/* ؑցE16K\܂B */
	ldirect_free();
#endif /*LDIRECT_INTERVAL*/

#ifdef BITMAP_GC_UNIT
	/* Bitmap GC܂B */
	BitmapGC_Free();
#endif /*BITMAP_GC_UNIT*/

#ifdef GC_LEVEL
	/* K[x[WRN^[܂B */
	gc_free();
#endif /*GC_LEVEL*/

#ifdef USE_DBG
	/* DBGjbg̐ݒ܂B */
	dbg_free();
#endif /*USE_DBG*/

#ifdef USE_UFE
	/* USBt@CVXeG~[VI܂B */
	ufe_stop();
#endif /*USE_UFE*/

#ifdef  USE_USBSUSPEND_PROBLEMWORKAROUND
	//uUSBTXyhP/ECEnOAbv鎖Lv鏈܂B
	Intel915G_WindowsXp_UsbSuspend_ProblemWorkaround_free();
#endif//USE_USBSUSPEND_PROBLEMWORKAROUND
}

/****************************************************************************
 *	update
 ****************************************************************************/

/* * Mon Mar 10 13:29:56 JST 2008 Naoyuki Sawa
 * - update()AʍXV𕪗A܂B
 */
#ifdef V_SCREEN
/* vbuff(c)_def_vbuff()ϊ */
//static void rotate_screen() {
//	unsigned char *src = &vbuff[88 - 1];	/* ]̉ʂ͍ォ瑖Jn܂ */
//	unsigned char *dst = &_def_vbuff[0];	/* ]̏cʂ͉Eォ瑖Jn܂ */
//	int x = 88;
//	do {
//		int y = 128;
//		do {
//			*dst++ = *src;		/* ʂEɑ܂ */
//			src += 88;		/* cʂɑ܂ */
//		} while(--y);
//						/* ʂ͊Ɏ̍sֈړĂ܂ */
//		src -= 88 * 128 + 1;		/* cʂ̗̈ԏֈړ܂ */
//	} while(--x);
//}
// (C = 9.2ms/1call  ASM = 3.2ms/1call)
/*static*/ void rotate_screen();
asm("
	.code
	.align	1
rotate_screen:
	xld.w	%r12, 0x0e00			; %r12 := FRAM4_START
	xld.w	%r13, rotate_screen_DOX		; %r13 := DOY
	xld.w	%r14, rotate_screen_END		; %r14 := END
	xcall.d	memcpy				; %r10 := FRAM4_START = memcpy(FRAM4_START, DOX, END - DOX)
	sub	%r14, %r13			; %r14 := END - DOY			*delay*
	xld.w	%r4, vbuff+87			; %r4  := src = &vbuff[88 - 1]
	xld.w	%r5, _def_vbuff			; %r5  := dst = &_def_vbuff[0]
	xld.w	%r6, 88				; %r6  := 88
	xld.w	%r7, 128			; %r7  := 128
	xld.w	%r11, 11265			; %r11 := 88 * 128 + 1
	ld.w	%r12, %r6			; %r12 := x = 88
	jp	%r10				; goto FRAM4_START			(jp.d͕s!!)
;//{{FRAM4̈֓]
rotate_screen_DOX:				; do {
	ld.w	%r13, %r7			;   %r13 := y = 128
rotate_screen_DOY:				;   do {
	ld.ub	%r9, [%r4]			;     %r9  := c = *src
	sub	%r13, 1				;     %r13 := --y			*anti-interlock*
	ld.b	[%r5]+, %r9			;     %r5  := *dst++ = c
	jrne.d	rotate_screen_DOY		;   } while(--y)
	add	%r4, %r6			;     %r4  := src += 88			*delay*
	sub	%r12, 1				;   %r12 := --x
	jrne.d	rotate_screen_DOX		; } while(--x)
	sub	%r4, %r11			;   %r4  := src -= 88 * 128 + 1		*delay*
	ret
rotate_screen_END:
;//}}܂FRAM4̈֓]
");
#endif /*V_SCREEN*/

/* * Mon Nov 06 17:37:17 JST 2006 Naoyuki Sawa
 * - schedule()AʍXV𕪗܂B
 *   t[҂ʍXVsꍇ́Å֐ĂяoĂB
 * * Thu Dec 21 21:17:56 JST 2014 Naoyuki Sawa
 * - Oobt@`A܂łschedule()ōsĂ܂Aupdate()ōs悤ɕύX܂B
 *   ɉāAOobt@`OŁAzVRAMۑ悤ɂ܂B
 *   ̕ύXɂāAAvP[V́AOobt@`̉e𖳎āAI[o[CƌȂ悤ɂȂ܂B
 *   ȉ̂悤ȏ\ƂȂ܂B
 *   1
 *   void app_main(){
 *     surface_clear(&surface,0);
 *     render_ellipse(&render,0,0,DISP_X,DISP_Y,3);//~`悷
 *     for(;;){
 *       schedule();//~j󂹂۸ޯ̧`݂̂۰قł
 *       LogBuf_Printf(pLogBuf,"%d",now);
 *   } }
 *   2
 *   void test(){
 *     //``
 *     LogBuf_Printf(pLogBuf,"some message");
 *     update();//۸ޯ̧`݂̂XV
 *     //``
 *   } }
 * - ̕ύXɔAOobt@`悪A^ƁAPC̉ʃLv`Ɋ܂܂ȂȂƂɁAӂĂB
 *   ^schedule()̒vidrec()ŁCLv`schedule()̒yield()ōs鏈łB
 *   vidrec()yield()Ă΂鎞_ł́AzVRAM͕ĂAOobt@`͎cĂȂłB
 *   Oobt@`́AɃeXĝ߂̕\ł̂ŁA^Lv`Ɋ܂܂ĂȂĂ肪Ǝv܂A
 *   Kvłꍇ́A֐̍ṒAzVRAM𕜌鏈폜΁AύXOƓlɊ܂܂悤ɂł܂B
 */
void
update()
{
#ifdef  USE_LOG_BUFFER
	/* Oobt@`OɉzVRAMޔB */
    #ifdef  V_SCREEN
	static unsigned char tmpbuf[sizeof vbuff];	//Oobt@Əcʂ𕹗pꍇ́AzVRAMޔꎞIȃobt@Ƃ_def_vbuffgȂBrotate_screen()_def_vbuffj󂷂邩łBtmpbuf[]̕gpʂ邱ƂɒӂB
	memcpy(tmpbuf, vbuff, sizeof vbuff);
    #else //V_SCREEN
	memcpy(_def_vbuff, vbuff, sizeof vbuff);	//Oobt@Əcʂ𕹗pȂꍇ́AzVRAMޔꎞIȃobt@Ƃ_def_vbuffgB
    #endif//V_SCREEN
	/* Oobt@`B */
	LogBuf_Draw(pLogBuf, 0, 0);
#endif/*USE_LOG_BUFFER*/

#ifdef V_SCREEN
	rotate_screen();
#endif /*V_SCREEN*/

	/* ʓ] */
	pceLCDTrans();

#ifdef  USE_LOG_BUFFER
	/* Oobt@`OɑޔzVRAM𕜌B */
    #ifdef  V_SCREEN
	memcpy(vbuff, tmpbuf, sizeof vbuff);		//Oobt@Əcʂ𕹗pꍇ
    #else //V_SCREEN
	memcpy(vbuff, _def_vbuff, sizeof vbuff);	//Oobt@Əcʂ𕹗pȂꍇ
    #endif//V_SCREEN
#endif/*USE_LOG_BUFFER*/
}

/****************************************************************************
 *	vidrec
 ****************************************************************************/

#ifdef USE_VIDREC
static void
vidrec()
{
#ifdef LDIRECT_INTERVAL
	static const unsigned char hdr[4] = { DISP_X,DISP_Y,4/*[bpp]*/,FPS };
#else /*LDIRECT_INTERVAL*/
	static const unsigned char hdr[4] = { DISP_X,DISP_Y,2/*[bpp]*/,FPS };
#endif /*LDIRECT_INTERVAL*/
	static int active;
	//
	unsigned char buf[128/**/]; /* (sizeof vbuff)/ÑTCYƂ邱 */
	const unsigned char* src;
	unsigned char* dst;

	if(cdcacm_recv(buf, 1) > 0) {
		switch(buf[0]) {
		case 0:
			active = 0; /* ʏo͒~ */
			break;
		case 1:
			active = 1; /* ʏo͊Jn */
			src = hdr;
			do {
				if(pcePadGetDirect() & PAD_SELECT) {
					exit(0); /* M҂Ɋ荞ŋI */
				}
				src += cdcacm_send(src, &hdr[sizeof hdr] - src);
			} while(src < &hdr[sizeof hdr]);
			break;
		}
	}
	if(active) {
		src = vbuff;
		do {
			dst = buf;
			do {
#ifdef LDIRECT_INTERVAL
				*dst++ = src[0]|(src[1]<<4); 
				src += 2;
#else /*LDIRECT_INTERVAL*/
				*dst++ = src[0]|(src[1]<<2)|(src[2]<<4)|(src[3]<<6);
				src += 4;
#endif /*LDIRECT_INTERVAL*/
			} while(dst < &buf[sizeof buf]);
			dst = buf;
			do {
				if(pcePadGetDirect() & PAD_SELECT) {
					exit(0); /* M҂Ɋ荞ŋI */
				}
				dst += cdcacm_send(dst, &buf[sizeof buf] - dst);
			} while(dst < &buf[sizeof buf]);
		} while(src < &vbuff[sizeof vbuff]);
	}
}
#endif /*USE_VIDREC*/

/****************************************************************************
 *	schedule
 ****************************************************************************/

/* * Fri Dec 15 00:49:15 JST 2006 Naoyuki Sawa
 * - schedule()֐ɁATEh|[YΉR[hǉ܂B
 *   ł͏肭삵Ă悤łAX[v̕Aɖ肪NȂmFłB
 * - A|[YԂ̂܂܁AȂ킿ATEh|[YԂ̂܂܂ŃAvP[VIĂ܂ꍇɂA
 *   CLiPCupceAppExit()pceWaveStop(1)ĂяoĂATEhԂZbĝŁAvłB
 */

void
schedule()
{
#ifdef  USE_EVENT_TIMER
	/* Cxg^C}B */
	EvtTmr_Exec(pEvtTmr);
#endif/*USE_EVENT_TIMER*/

#ifdef  USE_COUNTER_MANAGER
	/* ėpJE^ǗB */
	CntMgr_Exec(pCntMgr);
#endif/*USE_COUNTER_MANAGER*/

#ifdef USE_PAUSE
	{
		/* PAUSEbZ[Ẅ̃C[Wޔpobt@́A324oCgKvłB
		 * X^bNɎ̂͊댯łAstaticɎ̖̂ʂłB
		 * ŁAPAUSEɂ̂݃q[vmۂ邱Ƃɂ܂B
		 */
		//unsigned char save[PAUSE_H][PAUSE_W];
		unsigned char (*save)[PAUSE_W] = NULL/*x}*/;
		int pause = 0;
		/*{{2006/12/15:TEh|[YΉ*/
		int sound_pause = 0/*x}*/;
		/*}}2006/12/15:TEh|[YΉ*/
		int x, y;
		for(;;) {
#endif /*USE_PAUSE*/

			/* ʍXVB */
			update();

#ifdef USE_VIDREC
			/* ʏóB */
			vidrec();
#endif /*USE_VIDREC*/

#ifdef  USE_SOUND_MANAGER
			/* Sound ManagerB */
			SndMgr_Exec(pSndMgrBgm); /* BGM Sound Manager */
			SndMgr_Exec(pSndMgrSe1); /* SE1 Sound Manager */
			SndMgr_Exec(pSndMgrSe2); /* SE2 Sound Manager */
#endif/*USE_SOUND_MANAGER*/

#ifdef USE_IDLE
			/* ACh+VXeB */
			idle_yield();
#else /*USE_IDLE*/
			/* VXeB */
			yield();
#endif /*USE_IDLE*/

			/* pbhԍXVB */
			joy = pad_get();
#ifdef V_SCREEN
			joy = (joy & ~(PAD_LF | PAD_RI | PAD_UP | PAD_DN | /* cʗp͕ϊ */
				       TRG_LF | TRG_RI | TRG_UP | TRG_DN))
				| (joy & PAD_LF ? PAD_UP : 0)
				| (joy & PAD_RI ? PAD_DN : 0)
				| (joy & PAD_UP ? PAD_RI : 0)
				| (joy & PAD_DN ? PAD_LF : 0)
				| (joy & TRG_LF ? TRG_UP : 0)
				| (joy & TRG_RI ? TRG_DN : 0)
				| (joy & TRG_UP ? TRG_RI : 0)
				| (joy & TRG_DN ? TRG_LF : 0);
#endif /*V_SCREEN*/

			/* SELECT{^ꂽIB */ /* AvP[VɂĕsvȂ΁A2s폜ĂB */
			if(joy & TRG_SELECT) exit(EXIT_SUCCESS); /* AvP[VɂĕsvȂ΁A2s폜ĂB */

#ifdef USE_PAUSE
			/* PAUSEB */
			if(joy & TRG_START) {
				pause = !pause;	/* PAUSEԐ؂ւ */
				if(pause) {	/* PAUSE IN */
					/*{{2006/12/15:TEh|[YΉ*/
					ENTER_CS;
					sound_pause = fINT_EDMA.EHDM1;
					if(sound_pause) {
						fINT_EDMA.EHDM1 = 0;
					}
					LEAVE_CS;
					/*}}2006/12/15:TEh|[YΉ*/
					/* PAUSEbZ[W\̃C[WޔB */
					save = (unsigned char (*)[PAUSE_W])malloc(PAUSE_W * PAUSE_H); /* C[Wޔpobt@m */
					if(save == NULL) DIE();
					for(y = 0; y < PAUSE_H; y++) {
						for(x = 0; x < PAUSE_W; x++) {
							save[y][x] = vbuff[DISP_X * (PAUSE_Y + y) + (PAUSE_X + x)];
						}
					}
				} else {	/* PAUSE OUT */
					/*{{2006/12/15:TEh|[YΉ*/
					ENTER_CS;
					if(sound_pause) {
						fINT_EDMA.EHDM1 = 1;
					}
					LEAVE_CS;
					/*}}2006/12/15:TEh|[YΉ*/
					/* PAUSEbZ[W\̃C[W𕜋AB */
					for(y = 0; y < PAUSE_H; y++) {
						for(x = 0; x < PAUSE_W; x++) {
							vbuff[DISP_X * (PAUSE_Y + y) + (PAUSE_X + x)] = save[y][x];
						}
					}
					free(save); /* C[Wޔpobt@J */
				}
			}
			if(!pause) break;
			/* PAUSEbZ[W_ŕ\B */
			if(pceTimerGetCount() % 1000 < 750) {
				render_string_framed(&render, PAUSE_X, PAUSE_Y, PAUSE_STR, PAUSE_FONT, PAUSE_COLOR);
			} else {
				for(y = 0; y < PAUSE_H; y++) {
					for(x = 0; x < PAUSE_W; x++) {
						vbuff[DISP_X * (PAUSE_Y + y) + (PAUSE_X + x)] = save[y][x];
					}
				}
			}
		}
	}
#endif /*USE_PAUSE*/

	now++;	/* O[o^C}XV */
}

/****************************************************************************
 *	
 ****************************************************************************/
#define MAX_DISP	13	/* Sɕ\łACe */
typedef struct _ITEM {
	char name[MAXFILENAME + 1/*nul*/];	/* t@C */
	int size;				/* t@CTCY */
} ITEM;
static ITEM TBL_Item[MAXDIR];	/* ACeXg */
static int nItem;		/* ACe̐ */
static int cursel;		/* ݂̑IACeCfNX */
static int curtop;		/* ŏi\ACeCfNX */
/*--------------------------------------------------------------------------*/
static int scandir_filter(const struct dirent* e) {
	return !fnmatch("*.txt", e->d_name, 0);
}
static void init_sel() {
	int i;
	struct dirent** e;
	nItem = scandir(".", &e, scandir_filter, alphasort);
	for(i = 0; i < nItem; i++) {
		struct stat st;
		strcpy(TBL_Item[i].name, (*e++)->d_name);
		if(stat(TBL_Item[i].name, &st)) { DIE(); }
		TBL_Item[i].size = st.st_size;
	}
	if(!nItem) {
		die("txtt@CL܂BSELECT{^ƁAI܂B");
	}
}
/*--------------------------------------------------------------------------*/
static void do_sel() {
	int c, i, y;
	for(;;) {
		schedule();
		surface_clear(&surface, 0);
		if(joy & TRG_AB) { return; }
		//XgI
		if(joy & TRG_UP) { cursel--; }
		if(joy & TRG_DN) { cursel++; }
		if(joy & TRG_LF) { cursel -= MAX_DISP; }
		if(joy & TRG_RI) { cursel += MAX_DISP; }
		if(cursel < 0                      ) { cursel = 0; }
		if(cursel > nItem - 1              ) { cursel = nItem - 1; }
		if(cursel < curtop                 ) { curtop = cursel; }
		if(cursel > curtop + (MAX_DISP - 1)) { curtop = cursel - (MAX_DISP - 1); }
		//Xg\
		y = 8;
		for(i = curtop; i < curtop + MAX_DISP + 1; i++) {
			if(i > nItem - 1) { break; }
			if(i == cursel) {
				render_rectangle_fill(&render, 0, y - 1, DISP_X, 6 + 1, 2);
				c = 0;
			} else {
				c = 2;
			}
			render_string(&render, 4 + 4 *  1, y, TBL_Item[i].name, 2, c);
			render_printf(&render, 4 + 4 * 15, y, 2, c, "%8d Bytes", TBL_Item[i].size);
			y += 6;
		}
		//^Cg\
		render_rectangle_fill(&render, 0, 0, DISP_X, 6 + 1, 3);
		render_string(&render, 0, 1,
		//       01234567890123456789012345678901
			"========= UTF-8 Viewer =========",
			0x82, 0);
	}
}
/****************************************************************************
 *	
 ****************************************************************************/
#define MAX_LINE	999		/* eLXg̍ős */
#define COLS		((DISP_X*2)/5)	/*  */
#define ROWS		(DISP_Y/10)	/* s */
static char* TBL_Line[MAX_LINE];	/* s̐擪ւ̃|C^ */
static int nLine;			/* s */
static int curline;			/* ݂̕\擪s */
/*--------------------------------------------------------------------------*/
volatile int iLine;
static int _idle_proc() {
	char** TBL_Tmp = malloc(sizeof(char*) * MAX_LINE);
	int nTmp = 0;
	for(iLine = 0; iLine < nLine; iLine++) {
		//UTF-8˃VtgJISϊsB
		char *s, **argv;
		s = TBL_Line[iLine];
		TBL_Line[iLine] = NULL;	//ῗ̕svȂ̂GCJł悤ɎQƂNAĂBK{ł͂ȂB
		s = strdup_Utf8ToShiftJis(s);
		//܂ԂsB
		argv = textwrap(s, COLS);
		while((s = *argv++)) {
			TBL_Tmp[nTmp++] = s;
			if(nTmp >= MAX_LINE) { break; }
		}
	}
	//܂Ԃ̕Rs[B
	memcpy(TBL_Line, TBL_Tmp, sizeof(char*) * nTmp);
	//܂Ԃ̍sԂB
	//CXbhnLineQƂĂ̂ŁA܂nLineɂ͊i[ȂB
	return nTmp;
}
static int idle_proc(void* param) {
	//CXbhRAMɗpӂX^bN֐؂ւĎsB
	return stack_switch(param, _idle_proc, 0, 0);
}
static int init_view() {
	unsigned char stack[1024]; //idle_proc()pRAMX^bNB210oCg炢gȂ悤Ȃ̂ŁA1KBΏ[B
	FILE* fp;
	char* s;
	int n, t;
	surface_clear(&surface, 0);
	render_string(&render, 0,  0, TBL_Item[cursel].name, 0, 3);
	render_string(&render, 0, 10, "t@Cǂݍݒ", 0, 3);
	update();
	//t@CŜǂݍށB
	fp = fopen(TBL_Item[cursel].name, "r");
	if(!fp) { DIE(); }
	s = NULL;
	n = 0;
	getdelim(&s, &n, 0, fp);
	fclose(fp);
	//sB
	nLine = 0;
#if 0
	{ char** argv = strsplit_set(s, "\r\n", 0);
	  while((s = *argv++)) {
		if((s = strstrip(s))) {
			TBL_Line[nLine++] = s;
			if(nLine >= MAX_LINE) { break; }
		}
	} }
#else//ł̓s鎖L̂Łȉ̂悤ɕύXBclipstr.cstrsplit_set()̃RgQƂB
	s = strtok(s, "\r\n");
	while(s) {
		if((s = strstrip(s))) {
			TBL_Line[nLine++] = s;
			if(nLine >= MAX_LINE) { break; }
		}
		s = strtok(NULL, "\r\n");
	}
#endif
	//UTF-8˃VtgJISϊƐ܂ԂsB
	t = pceTimerGetCount();
	memset(stack, 0x77, sizeof stack);
	idle_init(idle_proc, stack + sizeof stack, 0);
	do {
		apptm_wk = pceTimerGetCount(); //idle_proc()ɏ[ȃ^CXCX^邽߁B
		schedule();
		if(stack[0] != 0x77) { DIE(); } //idle_proc()pRAMX^bNꂽBstack[]𑝂₹B
		surface_clear(&surface, 0);
		render_string(&render, 0,  0, TBL_Item[cursel].name, 0, 3);
		render_string(&render, 0, 10, "UTF-8S-JISϊ", 0, 3);
		render_printf(&render, 0, 20, 0, 3, "%d/%ds %.1fbo", iLine, nLine, (pceTimerGetCount() - t)/1000.0);
		render_string(&render, 0, 30, "݂Ʒݾق܂", 0, 3);
		if(joy & TRG_AB) {
			idle_free();
			return 0;
		}
	} while(idle_stat());
	t = pceTimerGetCount() - t;
	//Ԃ\B
	surface_clear(&surface, 0);
	render_string(&render, 0,  0, TBL_Item[cursel].name, 0, 3);
	render_string(&render, 0, 10, "UTF-8S-JISϊ", 0, 3);
	render_printf(&render, 0, 20, 0, 3, "%d/%ds %.1fb", iLine, nLine, t);
	update();
	//܂Ԃ̍s擾B
	nLine = idle_wait();
	//Ԃ1bԕ\B
	REPEAT_TIMEOUT(1000,
		gc_run();//GCsĂ̂̂߂Ɍǂ낤B[vłȂ擪Ɉł悢̂sĂ͂ȂB
		schedule();
		if(joy & TRG_MASK) { BREAK_TIMEOUT; }
	);
	return 1;
}
/*--------------------------------------------------------------------------*/
#define BkColor 0
#define TxColor 3
static void do_view() {
	int i, x, y;
	curline = 0;
	for(;;) {
		schedule();
		surface_clear(&surface, BkColor);
		if(joy & TRG_AB) { return; }
		//XN[
		if(joy & TRG_UP) { curline--; }
		if(joy & TRG_DN) { curline++; }
		if(joy & TRG_LF) { curline -= ROWS; }
		if(joy & TRG_RI) { curline += ROWS; }
		if(curline + ROWS > nLine) { curline = nLine - ROWS; }
		if(curline < 0) { curline = 0; }
		//eLXg\
		x = 0;
		y = 0;
		for(i = 0; i <= ROWS; i++) {
			if((curline + i) > (nLine - 1)) { break; }
			render_reduced_string(&render, x, y, TBL_Line[curline + i], TxColor);
			y += 10;
		}
	}
}
/****************************************************************************
 *	app_main
 ****************************************************************************/
void app_main() {
	init_sel();
	for(;;) {
		do_sel();
		if(init_view()) {
			do_view();
		}
	}
}
