/*
 *	app.c
 *
 *	dpavigen - AVI c[
 *	Copyright (C) 2013-2015 Naoyuki Sawa
 *
 *	* Mon Sep 02 00:00:29 JST 2013 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Jan 31 15:44:13 JST 2015 Naoyuki Sawa
 *	- uLua 5.2.3vˁuLua 5.3.0vֈڍsƂɔAăRpC܂B
 *	  \[Xt@C͕̏ύXĂ܂B
 *	- lua_Integeruintvˁu__int64vɕς߁Aȉ̌xo悤ɂȂ܂:
 *	  warning C4244: '=' : '__int64 '  'int ' ɕϊ܂BްĂ邩܂B
 *	  'Ľ^ύXɂsĂȂ'𖢌؂ł邽߁AČxȂɂ܂B
 *	  肪mFɁA(int)ւ̃LXgČx\łB˒ǋL:肪L̂ŏCs܂Bȉ̃RgQƂĂB
 *	* Sat Jan 31 17:30:32 JST 2015 Naoyuki Sawa
 *	- uLua 5.2.3vˁuLua 5.3.0vֈڍsƂɔCs܂B
 *	  ̓Iɂ́Aȉ̓_łB
 *	- XNvg̏C
 *	  uLua 5.3.0vł́AWRpCbit32gȂȂ̂ŁAɃrbgZqg悤ɂ܂B
 *	- C֐̏C
 *	  uLua 5.3.0vł́A܂ޒlluaL_checkinteger()Ŏ擾悤ƂƁAG[Ȃ悤ɂȂ܂B
 *	  ɂ́AXNvgŐɐ؂̂ĂĂC֐ĂяoׂȂ̂łAύXӏ߂ăGoOSzȂ̂ŁA
 *	  C֐Œl擾鏊luaL_checkinteger()luaL_checknumber()ɕύXAC֐Ő؂̂Ă悤ɂ܂B
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/* Win32 */
#define STRICT
#include <windows.h>
#include <vfw.h>
#pragma comment(lib, "vfw32.lib")
/* Lua */
#include "lua.h"
#include "lauxlib.h"
#include "lualib.h"
#pragma comment(lib, "liblua.lib")

/* dv
 * Lua C API̎s`FbNLɂ邽߂ɁAȉ̐ݒs܂B
 * mvWFNgn
 *   ˁmݒn
 *   ˁuݒ̑Ώہv = Win32 Debug, liblua
 *   ˁuC/C++v
 *   ˁuJeSv = 
 *   ˁuvvZbT̒`v = LUA_USE_APICHECK ǉ
 * mvWFNgn
 *   ˁmݒn
 *   ˁuݒ̑Ώہv = Win32 Release, liblua
 *   ˁuC/C++v
 *   ˁuJeSv = 
 *   ˁuvvZbT̒`v = LUA_USE_APICHECK ǉ, NDEBUG 폜
 * (ݒ̈Ӗ́A"../../liblua/Makefile"̃RgQƂĂB)
 */

#define VERSION "20150131"

/****************************************************************************
 *	
 ****************************************************************************/

#define CFG_FNAME "dpavigen.cfg" /* kݒt@C */

/* IvV */
int opt_Silent;		/* 1Ȃ΁Ai\sȂ */
int g_DispX = 320;	/* [sNZ] */
int g_DispY = 240;	/* [sNZ] */
int g_Rate  =  30;	/* t[[g[t[/b] */

/* Lua */
lua_State* g_pL;	/* LuaXe[g */
lua_State* g_pThread;	/* */
int        g_lThread;	/* */

/* VFW */
PAVIFILE            g_pAviFile;			/* AVIt@C */
AVISTREAMINFO       g_AviStreamInfo;		/* 񈳏kXg[̃tH[}bg */
PAVISTREAM          g_pAviStream;		/* 񈳏kXg[ */
PAVISTREAM          g_pAviCompressedStream;	/* kXg[ */
AVICOMPRESSOPTIONS* g_pAviCompressOptions;	/* kݒ */
BITMAPINFOHEADER    g_BitmapInfoHeader;		/* kXg[̃tH[}bg */

HDC        g_hDc;		/* DC */
HBITMAP    g_hBitmap;		/* DIBZNV */
DIBSECTION g_DibSection;	/* DIBZNV̏ */
HFONT      g_hFont;		/* tHg */
LOGFONT    g_LogFont;		/* _tHg̓ */

const char* g_pAviFileName;	/* AVIt@C */
int         g_iFrameNumber;	/* t[ԍ(0`) */

/*--------------------------------------------------------------------------*/

__declspec(noreturn) void usage();
__declspec(noreturn) void die(const char* fmt, ...);
#define DIE() die(__FILE__, __LINE__)
__declspec(noreturn) int atpanic(lua_State* L);

/* C֐BLuãO[oɓo^ */
int cPset(lua_State* L);
int cLine(lua_State* L);
int cFill(lua_State* L);
int cText(lua_State* L);
const luaL_Reg TBL_Reg[] = {
	{ "Pset", cPset },
	{ "Line", cLine },
	{ "Fill", cFill },
	{ "Text", cText },
	{ NULL, NULL },
};

#define __CLIP_H__
/* getopt */
#include "../../include/getopt.h"
#include "../../getopt.c"
#undef  __CLIP_H__

/****************************************************************************
 *	
 ****************************************************************************/

int main(int argc, char* argv[]) {
	int RetVal, Size, opt, top;
	HGDIOBJ hGdiObj;
	FILE* fp;
/*{{Lua*/
	/* Lua܂B */
	g_pL = luaL_newstate();
	if(g_pL == NULL) { die("luaL_newstate s܂B"); }
	lua_atpanic(g_pL, atpanic);
	luaL_openlibs(g_pL);
/*}}Lua*/
	/* R}hC͂܂B */
	if(argc <= 1) { usage(); }
	while((opt = getopt(argc, argv, "f:e:x:y:r:chs")) != -1) {
		switch(opt) {
		case 'f':
			/* Luat@Cǂݍ݂܂B
			 * - u-f Luat@CvIvV́Aw\łB
			 *   u-f Luat@CvIvVw肳ꂽꍇASĂLuat@Cǂݍ݂܂B
			 */
		//{{
		//	top = lua_gettop(g_pL);
		//	  if(luaL_dofile(g_pL, optarg) != 0) { die("%s: luaL_dofile s܂B", optarg); }
		//	lua_settop(g_pL, top); /* luaL_dofile()̖߂l̐'LUA_MULTRET'BIɎ̂Ă鏈KvłB */
		//ł̓[hG[̃bZ[WĥŁÂ悤ɕύX܂B
			top = lua_gettop(g_pL);
			  if(luaL_loadfile(g_pL, optarg) != 0) { die("luaL_loadfile: %s", luaL_checkstring(g_pL, -1)); }
			  lua_call(g_pL, 0, 0);
			lua_settop(g_pL, top);
		//}}
			break;
		case 'e':
			/* LuaXNvgs܂B
			 * - u-e LuaXNvgvIvV́Aw\łB
			 *   u-f LuaXNvgvIvVw肳ꂽꍇASĂLuaXNvgs܂B
			 */
			top = lua_gettop(g_pL);
			  if(luaL_loadstring(g_pL, optarg) != 0) { die("luaL_loadstring: %s", luaL_checkstring(g_pL, -1)); }
			  lua_call(g_pL, 0, 0);
			lua_settop(g_pL, top);
			break;
		case 'x':
			g_DispX = atoi(optarg);
			if(g_DispX <= 0) { die("%s: -%cIvV̈słB", optarg, optopt); }
			break;
		case 'y':
			g_DispY = atoi(optarg);
			if(g_DispY <= 0) { die("%s: -%cIvV̈słB", optarg, optopt); }
			break;
		case 'r':
			g_Rate = atoi(optarg);
			if(g_Rate <= 0) { die("%s: -%cIvV̈słB", optarg, optopt); }
			break;
		case 'c':
			//kݒt@C폜܂B
			remove(CFG_FNAME);
			break;
		case 'h':
			usage();
			break;
		case 's':
			opt_Silent = 1;
			break;
		default:
			die("%c: IvV̎gsłB", optopt);
			break;
		}
	}
	/* IvVȍ~Ac̃R}hĆAAVIt@CłB(ws) */
	g_pAviFileName = argv[optind++];
	if(optind != argc) { die("AVIt@Cw肳ĂȂ,,w肳Ă܂B"); }
	/* VFW܂B */
	AVIFileInit();
	/* AVIt@C쐬܂B */
	remove(g_pAviFileName);	//AVIFileOpen()OF_CREATEw肵ĂÃt@CȂȂ悤BAVIFileOpen()̕s̂悤ȋC邪Ad̂ŖIɍ폜ĉB
	RetVal = AVIFileOpen(&g_pAviFile, g_pAviFileName, OF_CREATE|OF_WRITE|OF_SHARE_EXCLUSIVE, NULL);
	if(RetVal != 0) { die("%s: AVIStreamInfo s܂B", g_pAviFileName); }
	/* 񈳏kXg[쐬܂B */
	memset(&g_AviStreamInfo, 0, sizeof g_AviStreamInfo);
	g_AviStreamInfo.fccType		= streamtypeVIDEO;
	g_AviStreamInfo.dwScale		= 1;
	g_AviStreamInfo.dwRate		= g_Rate;
	g_AviStreamInfo.rcFrame.right	= g_DispX;
	g_AviStreamInfo.rcFrame.bottom	= g_DispY;
	RetVal = AVIFileCreateStream(g_pAviFile, &g_pAviStream, &g_AviStreamInfo);
	if(RetVal != 0) { die("%s: AVIFileCreateStream s܂B", g_pAviFileName); }
	/* kݒt@CJ܂B */
	fp = fopen(CFG_FNAME, "rb");
	/* kݒt@CL΁c */
	if(fp != NULL) {
		/* kݒt@C̃TCY擾܂B */
		RetVal = fseek(fp, 0, SEEK_END);
		if(RetVal != 0) { die("%s: fseek s܂B", CFG_FNAME); }
		Size = ftell(fp);
		if(Size < sizeof(AVICOMPRESSOPTIONS)) { die("%sĂ܂B%s폜邩,,-cIvVw肵čĎsĂB", CFG_FNAME, CFG_FNAME); }
		/* kݒt@Cǂݍ݂܂B */
		rewind(fp);
		g_pAviCompressOptions = malloc(Size);
		if(g_pAviCompressOptions == NULL) { die("malloc s܂B"); }
		RetVal = fread(g_pAviCompressOptions, 1, Size, fp);
		if(RetVal != Size) { die("%s: fread s܂B", CFG_FNAME); }
		if(Size != (int)((sizeof(AVICOMPRESSOPTIONS) + g_pAviCompressOptions->cbFormat + g_pAviCompressOptions->cbParms))) {
			if(RetVal == 0) { die("%sĂ܂B%s폜邩,,-cIvVw肵čĎsĂB", CFG_FNAME, CFG_FNAME); }
		}
		/* lpFormatlpParms̃|C^Đݒ肵܂B */
		g_pAviCompressOptions->lpFormat = (g_pAviCompressOptions->cbFormat == 0) ? NULL : (char*)(g_pAviCompressOptions + 1);
		g_pAviCompressOptions->lpParms  = (g_pAviCompressOptions->cbParms  == 0) ? NULL : (char*)(g_pAviCompressOptions + 1) + g_pAviCompressOptions->cbFormat;
		/* kݒt@C܂B */
		RetVal = fclose(fp);
		if(RetVal != 0) { die("%s: fclose s܂B", CFG_FNAME); }
	/* kݒt@C΁c */
	} else {
		/* kݒ_CAO\܂B */
		g_pAviCompressOptions = calloc(sizeof(AVICOMPRESSOPTIONS), 1);	//NAK{BAVISaveOptions()֓nAVICOMPRESSOPTIONŚA_CAȌlƂĎQƂ邽߁ALAVICOMPRESSOPTIONSł邩,,NAĂȂ΂ȂȂBۂɂ́ALAVICOMPRESSOPTIONSłĂ肪LB_CAOňk`ύXāAAVISaveOptions()lpFormat,lpParmsĊĂɁAAvP[ṼAP[^Ɛُ퓮ɂȂBǂ̂ƂA_CAȌl͎włANAlnȂB
		if(g_pAviCompressOptions == NULL) { die("calloc s܂B"); }
		RetVal = AVISaveOptions(NULL, ICMF_CHOOSE_KEYFRAME|ICMF_CHOOSE_DATARATE, 1, &g_pAviStream, &g_pAviCompressOptions);
		if(RetVal == 0) { die("kݒ肪LZ܂B"); }
	}
	/* kXg[쐬܂B */
	RetVal = AVIMakeCompressedStream(&g_pAviCompressedStream, g_pAviStream, g_pAviCompressOptions, NULL);
	if(RetVal != 0) { die("%s: AVIMakeCompressedStream s܂Bkݒ肪sł\܂B-cIvVw肵čĎsĂB", g_pAviFileName); }
	/* kXg[̃tH[}bgݒ肵܂B */
	memset(&g_BitmapInfoHeader, 0, sizeof g_BitmapInfoHeader);
	g_BitmapInfoHeader.biSize	= sizeof(BITMAPINFOHEADER);
	g_BitmapInfoHeader.biWidth	= g_DispX;
	g_BitmapInfoHeader.biHeight	= g_DispY;
	g_BitmapInfoHeader.biPlanes	= 1;
	g_BitmapInfoHeader.biBitCount	= 24;
	RetVal = AVIStreamSetFormat(g_pAviCompressedStream, 0, &g_BitmapInfoHeader, sizeof g_BitmapInfoHeader);
	if(RetVal != 0) { die("%s: AVIStreamSetFormat s܂Bkݒ肪sł\܂B-cIvVw肵čĎsĂB", g_pAviFileName); }
	/* kXg[̍쐬,y,tH[}bgݒɐÄkݒ͐łƔfÂ߂Ɉkݒt@Cɕۑ܂B */
	fp = fopen(CFG_FNAME, "wb");
	if(fp == NULL) { die("%s: fopen s܂B", CFG_FNAME); }
	RetVal = fwrite(g_pAviCompressOptions, 1, sizeof(AVICOMPRESSOPTIONS), fp);
	if(RetVal != sizeof(AVICOMPRESSOPTIONS)) { die("%s: fwrite s܂B", CFG_FNAME); }
	if(g_pAviCompressOptions->cbFormat != 0) {
		RetVal = fwrite(g_pAviCompressOptions->lpFormat, 1, g_pAviCompressOptions->cbFormat, fp);
		if(RetVal != (int)g_pAviCompressOptions->cbFormat) { die("%s: fwrite s܂B", CFG_FNAME); }
	}
	if(g_pAviCompressOptions->cbParms != 0) {
		RetVal = fwrite(g_pAviCompressOptions->lpParms, 1, g_pAviCompressOptions->cbParms, fp);
		if(RetVal != (int)g_pAviCompressOptions->cbParms) { die("%s: fwrite s܂B", CFG_FNAME); }
	}
	RetVal = fclose(fp);
	if(RetVal != 0) { die("%s: fclose s܂B", CFG_FNAME); }
	/* DC쐬܂B */
	g_hDc = CreateCompatibleDC(NULL);
	if(g_hDc == NULL) { die("CreateCompatibleDC s܂B"); }
	/* DIBZNV쐬܂B */
	g_hBitmap = CreateDIBSection(NULL, (BITMAPINFO*)&g_BitmapInfoHeader, DIB_RGB_COLORS, NULL/*ppvBits*/, NULL, 0);	//pvBitsg_DibSection.dsBm.bmBitsƓȂ̂Ŏ擾svłBAUnDoc'dppvBitsNULLővȂ悤B
	if(g_hBitmap == NULL) { die("CreateDIBSection s܂B"); }
	/* DIBZNV̏擾܂B */
	RetVal = GetObject(g_hBitmap, sizeof g_DibSection, &g_DibSection);
	if(RetVal == 0) { die("GetObject s܂B"); }
	/* tHg쐬܂B */
	memset(&g_LogFont, 0, sizeof g_LogFont);
	g_LogFont.lfHeight  = 12;	//ꖢ̃TCYɂƁAMSSVbNɂȂB
	g_LogFont.lfCharSet = SHIFTJIS_CHARSET;
	strcpy(g_LogFont.lfFaceName, "lr ");
	g_hFont = CreateFontIndirect(&g_LogFont);
	if(g_hFont == NULL) { die("CreateFontIndirect s܂B"); }
	/* DC̏Ԃۑ܂B */
	RetVal = SaveDC(g_hDc);
	if(RetVal == 0) { die("SaveDC s܂B"); }
	/* DCDIBZNVI܂B */
	hGdiObj = SelectObject(g_hDc, g_hBitmap);
	if(hGdiObj == 0) { die("SelectObject s܂B"); }
	/* DCɃtHgI܂B */
	hGdiObj = SelectObject(g_hDc, g_hFont);
	if(hGdiObj == 0) { die("SelectObject s܂B"); }
	/* DC̔wi[hݒ肵܂B */
	RetVal = SetBkMode(g_hDc, TRANSPARENT);
	if(RetVal == 0) { die("SetBkMode s܂B"); }
/*{{Lua*/
	/* C֐o^܂B */
	top = lua_gettop(g_pL);
	  lua_pushglobaltable(g_pL);
	  luaL_setfuncs(g_pL, TBL_Reg, 0);
	lua_settop(g_pL, top);
	/* O[oϐo^܂B */
	lua_pushnumber(g_pL, g_DispX); lua_setglobal(g_pL, "DispX");	/* [sNZ] */
	lua_pushnumber(g_pL, g_DispY); lua_setglobal(g_pL, "DispY");	/* [sNZ] */
	lua_pushnumber(g_pL, g_Rate ); lua_setglobal(g_pL, "Rate" );	/* t[[g[t[/b] */
	/* R[`쐬܂B */
	g_pThread = lua_newthread(g_pL);
	if(g_pThread == NULL) { die("lua_newthread s܂B"); }
	lua_getglobal(g_pThread, "Main");
	if(!lua_isfunction(g_pThread, -1)) { die("%s `Ă܂B", "Main"); }
	for(;;) {
		/* R[`s܂B */
		RetVal = lua_resume(g_pThread, NULL, 0);
		if(RetVal == 0) { break; }
		if(RetVal != LUA_YIELD) { atpanic(g_pThread); }
		lua_settop(g_pThread, 0);	//lua_resume()̖߂l̐'LUA_MULTRET'BIɎ̂Ă鏈KvłBAg_pThread̓R[`pȂ̂ŁAX^bNgbv0ƌߑłėǂB
/*}}Lua*/
		/* kXg[1t[݂܂B */
		RetVal = AVIStreamWrite(g_pAviCompressedStream, g_iFrameNumber++, 1,
			g_DibSection.dsBm.bmBits,
			g_DibSection.dsBm.bmWidthBytes * g_DibSection.dsBm.bmHeight,
			0/*AVIIF_KEYFRAME*/, NULL, NULL);	//L[t[px͈kݒɂĎw肳Ă̂ŁAǉ̃L[t[w肷邱Ƃ͕svłB
		if(RetVal != 0) { die("%s: AVIStreamWrite s܂B", g_pAviFileName); }
/*{{i\p*/
		if(!opt_Silent) { fprintf(stderr, "%s: %df\r", g_pAviFileName, g_iFrameNumber); }
/*}}i\p*/
	}
/*{{i\p*/
	if(!opt_Silent) { fprintf(stderr, "\n"); }
/*}}i\p*/
	/* DC̏Ԃ𕜌܂B */
	RetVal = RestoreDC(g_hDc, -1);
	if(RetVal == 0) { die("RestoreDC s܂B"); }
	/* tHg폜܂B */
	RetVal = DeleteObject(g_hFont);
	if(RetVal == 0) { die("DeleteObject s܂B"); }
	/* DIBZNV폜܂B */
	RetVal = DeleteObject(g_hBitmap);
	if(RetVal == 0) { die("DeleteObject s܂B"); }
	/* DC폜܂B */
	RetVal = DeleteDC(g_hDc);
	if(RetVal == 0) { die("DeleteDC s܂B"); }
	/* kXg[܂B */
	RetVal = AVIStreamRelease(g_pAviCompressedStream);
	if(RetVal != 0) { die("%s: AVIStreamRelease s܂B", g_pAviFileName); }
	/* 񈳏kXg[܂B */
	RetVal = AVIStreamRelease(g_pAviStream);
	if(RetVal != 0) { die("%s: AVIStreamRelease s܂B", g_pAviFileName); }
	/* AVIt@C܂B */
	RetVal = AVIFileRelease(g_pAviFile);
	if(RetVal != 0) { die("%s: AVIFileRelease s܂B", g_pAviFileName); }
	/* VFWI܂B */
	AVIFileExit();
/*{{Lua*/
	/* LuaI܂B */
	lua_close(g_pL);
/*}}Lua*/
	return EXIT_SUCCESS;
}

/*--------------------------------------------------------------------------*/

/* g\AG[IB */
void usage() {
	fprintf(stderr, "dpavigen - AVI c[ (%s)\n", VERSION);
	fprintf(stderr, "Copyright (C) 2013 Naoyuki Sawa All Rights Reserved.\n");
	fprintf(stderr, "Usage:\n");
	fprintf(stderr, "    dpavigen [options] -f script.lua [-f script.lua ...] movie.avi\n");
	fprintf(stderr, "Options:\n");
	fprintf(stderr, "    -h            g\܂B\n");
	fprintf(stderr, "    -s            i\܂B\n");
	fprintf(stderr, "    -c            kݒs܂B(l=%sǂݍ)\n", CFG_FNAME);
	fprintf(stderr, "    -x DispX        [sNZ]w肵܂B(l=%d)\n", g_DispX);
	fprintf(stderr, "    -y DispY      [sNZ]w肵܂B(l=%d)\n", g_DispY);
	fprintf(stderr, "    -r Rate       t[[gw肵܂B(l=%d)\n", g_Rate );
	fprintf(stderr, "    -f script.lua LuaXNvgt@Cǂݍ݂܂B(w)\n");
	fprintf(stderr, "    -e lua-script LuaXNvg𒼐ڎs܂B(w)\n");
	fprintf(stderr, "Summary:\n");
	fprintf(stderr, "  - AVIt@C̊et[ALuaXNvgŕ`悵܂B\n");
	fprintf(stderr, "    LuaXNvg𕡐w肵ꍇASĘÂƂĈ܂B\n");
	fprintf(stderr, "    AVIt@C𕡐w肵ꍇASĘÂƂĈ܂B\n");
	fprintf(stderr, "  - LuaXNvgɂ́Aȉ̊֐`ĂȂ΂Ȃ܂B\n");
	fprintf(stderr, "    Main                      R[`̃C֐ƂČĂяo܂B\n");
	fprintf(stderr, "  - R[`̃C֐́ALC֐𗘗pł܂B\n");
	fprintf(stderr, "    Pset(x,y,v)               _`܂B()\n");
	fprintf(stderr, "    Pset(x,y,{r,g,b})         _`܂B(J[)\n");
	fprintf(stderr, "    Line(x1,y1,x2,y2,v)       `܂B()\n");
	fprintf(stderr, "    Line(x1,y1,x2,y2,{r,g,b}) `܂B(J[)\n");
	fprintf(stderr, "    Fill(x,y,w,h,v)           ``܂B()\n");
	fprintf(stderr, "    Fill(x,y,w,h,{r,g,b})     ``܂B(J[)\n");
	fprintf(stderr, "    Text(x,y,\"s\",v)           `܂B()\n");
	fprintf(stderr, "    Text(x,y,\"s\",{r,g,b})     `܂B(J[)\n");
	fprintf(stderr, "  - R[`̃C֐́AL̃O[oϐ𗘗pł܂B\n");
	fprintf(stderr, "    DispX                       [sNZ]\n");
	fprintf(stderr, "    DispY                     [sNZ]\n");
	fprintf(stderr, "    Rate                      t[[g\n");
	fprintf(stderr, "Example:\n");
	fprintf(stderr, "    dpavigen.exe -x 128 -y 88 -r 20 -f Sample.lua Output.avi\n");
	exit(EXIT_FAILURE);
}

/*--------------------------------------------------------------------------*/

/* bZ[W\AG[IB */
void die(const char* fmt, ...) {
	va_list ap;
	va_start(ap, fmt);
	 fprintf(stderr, "\n### ");
	vfprintf(stderr, fmt, ap);
	 fprintf(stderr, "\n");
	va_end(ap);
#ifdef  _DEBUG
	__asm int 3; /* fobOՂ悤ɁAfobO̓fobKŎ~߂ */
#endif/*_DEBUG*/
	exit(EXIT_FAILURE);
}

/*--------------------------------------------------------------------------*/

/* LuãpjbN֐ */
int atpanic(lua_State* L) {
	die("atpanic: %s", luaL_checkstring(L, -1));
}

/****************************************************************************
 *	
 ****************************************************************************/

static COLORREF GetColorRef(lua_State* L, int narg) {
	double r, g, b;
	if(lua_istable(L, narg)) {
		/* J[̐Fw̏ꍇc */
		lua_rawgeti(L, narg, 1); r = luaL_checknumber(L, -1); lua_pop(L, 1);
		lua_rawgeti(L, narg, 2); g = luaL_checknumber(L, -1); lua_pop(L, 1);
		lua_rawgeti(L, narg, 3); b = luaL_checknumber(L, -1); lua_pop(L, 1);
	} else {
		/* ̋Pxw̏ꍇc */
		r = g = b = luaL_checknumber(L, narg);
	}
	r *= (255 + 1); if(r < 0) { r = 0; } if(r > 255) { r = 255; }
	g *= (255 + 1); if(g < 0) { g = 0; } if(g > 255) { g = 255; }
	b *= (255 + 1); if(b < 0) { b = 0; } if(b > 255) { b = 255; }
	return RGB(r, g, b);
}

/*--------------------------------------------------------------------------*/

/*  Pset(x, y, v)
 *  Pset(x, y, {r,g,b})
 */
int cPset(lua_State* L) {
	int x, y;
	COLORREF c;
    //{{2015/01/31ύX:uLua 5.2.3vˁuLua 5.3.0vֈڍsƂɔCs܂B
    //	x = luaL_checkinteger(L, 1);	/* 1: xW */
    //	y = luaL_checkinteger(L, 2);	/* 2: yW */
    //2015/01/31ύX:uLua 5.2.3vˁuLua 5.3.0vֈڍsƂɔCs܂B
	x = (int)luaL_checknumber(L, 1);	/* 1: xW */
	y = (int)luaL_checknumber(L, 2);	/* 2: yW */
    //}}2015/01/31ύX:uLua 5.2.3vˁuLua 5.3.0vֈڍsƂɔCs܂B
	c = GetColorRef(L, 3);		/* 3: F(,,J[) */
	/* _`܂B */
	SetPixel(g_hDc, x, y, c);
	return 0;
}

/*--------------------------------------------------------------------------*/

/*  Line(x1, y1, x2, y2, v)
 *  Line(x1, y1, x2, y2, {r,g,b})
 */
int cLine(lua_State* L) {
	int x1, y1, x2, y2;
	COLORREF c;
	HPEN hPen;
    //{{2015/01/31ύX:uLua 5.2.3vˁuLua 5.3.0vֈڍsƂɔCs܂B
    //	x1 = luaL_checkinteger(L, 1);	/* 1: n_xW */
    //	y1 = luaL_checkinteger(L, 2);	/* 2: n_yW */
    //	x2 = luaL_checkinteger(L, 3);	/* 3: I_xW */
    //	y2 = luaL_checkinteger(L, 4);	/* 4: I_yW */
    //2015/01/31ύX:uLua 5.2.3vˁuLua 5.3.0vֈڍsƂɔCs܂B
	x1 = (int)luaL_checknumber(L, 1);	/* 1: n_xW */
	y1 = (int)luaL_checknumber(L, 2);	/* 2: n_yW */
	x2 = (int)luaL_checknumber(L, 3);	/* 3: I_xW */
	y2 = (int)luaL_checknumber(L, 4);	/* 4: I_yW */
    //}}2015/01/31ύX:uLua 5.2.3vˁuLua 5.3.0vֈڍsƂɔCs܂B
	c = GetColorRef(L, 5);		/* 5: F(,,J[) */
	/* y쐬܂B */
	hPen = CreatePen(PS_SOLID, 0, c);
	/* DC̏Ԃۑ܂B */
	SaveDC(g_hDc);
	/* yI܂B */
	SelectObject(g_hDc, hPen);
	/* `܂B */
	MoveToEx(g_hDc, x1, y1, NULL);
	LineTo(g_hDc, x2, y2);
	/* DC̏Ԃ𕜌܂B */
	RestoreDC(g_hDc, -1);
	/* y폜܂B */
	DeleteObject(hPen);
	return 0;
}

/*--------------------------------------------------------------------------*/

/*  Fill(x, y, w, h, v)
 *  Fill(x, y, w, h, {r,g,b})
 */
int cFill(lua_State* L) {
	RECT rc;
	COLORREF c;
	HBRUSH hBrush;
    //{{2015/01/31ύX:uLua 5.2.3vˁuLua 5.3.0vֈڍsƂɔCs܂B
    //	rc.left   = luaL_checkinteger(L, 1);		/* 1: xW */
    //	rc.top    = luaL_checkinteger(L, 2);		/* 2: yW */
    //	rc.right  = luaL_checkinteger(L, 3) + rc.left;	/* 3:  */
    //	rc.bottom = luaL_checkinteger(L, 4) + rc.top;	/* 4:  */
    //2015/01/31ύX:uLua 5.2.3vˁuLua 5.3.0vֈڍsƂɔCs܂B
	rc.left   = (int)luaL_checknumber(L, 1);		/* 1: xW */
	rc.top    = (int)luaL_checknumber(L, 2);		/* 2: yW */
	rc.right  = (int)luaL_checknumber(L, 3) + rc.left;	/* 3:  */
	rc.bottom = (int)luaL_checknumber(L, 4) + rc.top;	/* 4:  */
    //}}2015/01/31ύX:uLua 5.2.3vˁuLua 5.3.0vֈڍsƂɔCs܂B
	c = GetColorRef(L, 5);				/* 5: F(,,J[) */
	/* uV쐬܂B */
	hBrush = CreateSolidBrush(c);
	/* ``܂B */
	FillRect(g_hDc, &rc, hBrush);
	/* uV폜܂B */
	DeleteObject(hBrush);
	return 0;
}

/*--------------------------------------------------------------------------*/

/*  Text(x, y, "s", v)
 *  Text(x, y, "s", {r,g,b})
 */
int cText(lua_State* L) {
	int x, y;
	const char* s;
	COLORREF c;
    //{{2015/01/31ύX:uLua 5.2.3vˁuLua 5.3.0vֈڍsƂɔCs܂B
    //	x = luaL_checkinteger(L, 1);	/* 1: xW */
    //	y = luaL_checkinteger(L, 2);	/* 2: yW */
    //2015/01/31ύX:uLua 5.2.3vˁuLua 5.3.0vֈڍsƂɔCs܂B
	x = (int)luaL_checknumber(L, 1);	/* 1: xW */
	y = (int)luaL_checknumber(L, 2);	/* 2: yW */
    //}}2015/01/31ύX:uLua 5.2.3vˁuLua 5.3.0vֈڍsƂɔCs܂B
	s = luaL_checkstring(L, 3);	/* 3:  */
	c = GetColorRef(L, 4);		/* 4: F(,,J[) */
	/* Fݒ肵܂B */
	SetTextColor(g_hDc, c);
	/* `܂B */
	TextOut(g_hDc, x, y, s, strlen(s));
	return 0;
}

