
;  GNU C 2.7.2 [AL 1.1, MM 40] RISC NEWS-OS compiled by CC

;  Cc1 defaults:
;  -mmemcpy

;  Cc1 arguments (-G value = 0, Cpu = 3000, ISA = 1):
;  -quiet -dumpbase -O2 -Wall -o

gcc2_compiled.:
__gnu_compiled_c:
	.code
	.align	2
inst:
	.word	i_square0
	.word	i_saw0
	.word	i_triangle0
	.word	i_square
	.word	i_saw
	.word	i_triangle
	.word	i_BD909
	.word	i_SDGATE
	.word	i_SD909
	.word	i_HO909
	.word	i_HC909
	.word	i_CYMBD
	.word	i_CYMBD
	.word	i_TOMH1
	.word	i_TOMM1
	.word	i_TOML1
	.word	i_HANDCLAP
	.align	2
TBL_expt:
	.half	32768
	.half	34716
	.half	36781
	.half	38968
	.half	41285
	.half	43740
	.half	46341
	.half	49097
	.half	52016
	.half	55109
	.half	58386
	.half	61858
	.half	65535
; APP
	
		.code
		.align		1
gexp:
		ld.ub		%r4, %r12		;//%r4  := (unsigned char)n
		sra		%r12, 8			;//%r12 :=  (n >> 8)
	ext	__divsi3@rm	; 		xcall.d		__divsi3		;//%r10 := ((n >> 8) / 12), %ahr := ((n >> 8) % 12)				//ksvec200.s__divsi3%ahrɏ]ԂɈˑB
	call.d	__divsi3@rl
		ld.w		%r13, 12		;//%r13 :=             12					*delay*
		ld.w		%r5, %ahr		;//%r5  := div12t1 = ((n >> 8) % 12)
		sla		%r5, 1			;//%r5  := div12t1 * 2
		ext		TBL_expt+0@ah		;//%r6  := expt = TBL_expt[div12t1 + 0]
		ext		TBL_expt+0@al		;//
		ld.uh		%r6, [%r5]		;//
		ext		TBL_expt+2@ah		;//%r5  :=        TBL_expt[div12t1 + 1]
		ext		TBL_expt+2@al		;//
		ld.uh		%r5, [%r5]		;//
	;//	sub		%r5, %r6		;//%r5  := expb = TBL_expt[div12t1 + 1] - expt		
		ld.w		%r7, 20			;//%r7  :=           20					@
		sub		%r7, %r10		;//%r7  := div12t2 = 20 - ((n >> 8) / 12)		@
		jrge.d		3			;//if(div12t2 < 0) {					@
		 sub		%r5, %r6		;//%r5  := expb = TBL_expt[div12t1 + 1] - expt			*delay*
		 ld.w		%r7, 0			;//  %r7  := div12t2 = 0 }
		mlt.h		%r5, %r4		;//%alr :=          (expb * (unsigned char)n)
		ld.w		%r10, %alr		;//%r10 :=          (expb * (unsigned char)n)
		sra		%r10, 8			;//%r10 :=          (expb * (unsigned char)n) >> 8
		add		%r10, %r6		;//%r10 := (expt + ((expb * (unsigned char)n) >> 8))
	    ;//{{%r7j󂵂Ăǂ̂xsraœK
	    ;//	xsra		%r10, %r7
	    ;//	ret
	    ;//%r7j󂵂Ăǂ̂xsraœK
		cmp		%r7, 8			;//
		jrle		4			;//
		sra		%r10, 8			;//@
		jp.d		-3			;//
		sub		%r7, 8			;//@								*delay*
		ret.d					;//
		sra		%r10, %r7		;//								*delay*
	    ;//}}%r7j󂵂Ăǂ̂xsraœK

	
		.code
		.align		1
MakeWave:
		ld.w		%r4, [%r12]+		;//%r4  := freqwk   = mp->freqwk
		ld.w		%r5, [%r12]+		;//%r5  := freq     = mp->freq
		ld.w		%r6, [%r12]+		;//%r6  := pData    = mp->pData
		ld.w		%r7, [%r12]+		;//%r7  := loop_end = mp->loop_end
		ld.w		%r9, [%r12]		;//%r9  := loop_w   = mp->loop_w
		sub		%r12, 16		;//%r12 :=            mp
		sra		%r14, 1			;//%r14 := v >>= 1
		ld.w		%r10, %r4		;//%r10 := x = freqwk			
MakeWave_LOOP:						;//do {					@
	srl	%r10,0x8	; 		xsrl		%r10, 14		;//  %r10 := x >>= 14			
	srl	%r10,0x6
		add		%r10, %r6		;//  %r10 :=     &pData[x]		@
		ld.b		%r10, [%r10]		;//  %r10 := d1 = pData[x]		@
		ld.w		%r11, [%r13]		;//  %r11 := t = *p			@	*anti-interlock*
		mlt.h		%r10, %r14		;//  %alr :=      (d1 * v)		@
		ld.w		%r10, %alr		;//  %r10 :=      (d1 * v)		@
		add		%r4, %r5		;//  %r4  := freqwk += freq		@
		cmp		%r4, %r7		;//  if(freqwk >= loop_end) {		@
		jrlt.d		MakeWave_NEXT		;//    					@
		sra		%r10, 7			;//  %r10 :=      (d1 * v) >> 7		@	*delay*
		cmp		%r9, 0			;//    if(!loop_w) { goto STOP }	@
		jreq		MakeWave_STOP		;//    					@
		sub		%r4, %r9		;//    %r4  := freqwk -= loop_w		@
MakeWave_NEXT:						;//  }					@
		add		%r11, %r10		;//  %r11 := t += (d1 * v) >> 7		@
		ld.w		[%r13]+, %r11		;//  *p++ =  t				@
		sub		%r15, 1			;//  %r15 := cnt--			@
		jrne.d		MakeWave_LOOP		;//} while(cnt)				@
		ld.w		%r10, %r4		;//%r10 := x = freqwk				*delay*
	ld.w	[%r12],%r4	; 		xld.w		[%r12+0], %r4		;//mp->freqwk = x
		ret					;//return
MakeWave_STOP:						;//
	ext	0x4		; 		xld.w		[%r12+4], %r8		;//mp->freq = 0
	ld.w	[%r12],%r8
		ret					;//return

	
		.code
		.align		1
MakeWaveSQR:
	ld.w	%r4,[%r12]	; 		xld.w		%r4, [%r12+0]		;//%r4  := x = mp->freqwk
	ext	0x4		; 		xld.w		%r5, [%r12+4]		;//%r5  := y = mp->freq		*anti-interlock*
	ld.w	%r5,[%r12]
	sla	%r4,0x8		; 		xsla		%r4, 16			;//%r4  := x <<= 16		*anti-interlock*
	sla	%r4,0x8
	sla	%r5,0x8		; 		xsla		%r5, 16			;//%r5  := y <<= 16
	sla	%r5,0x8
		ld.w		%r6, %r14		;//%r6  := w = v
		sra		%r6, 1			;//%r6  := w >>= 1
		add		%r4, %r5		;//%r4  := x += y	
MakeWaveSQR_LOOP:					;//do {			@
		ld.w		%r7, [%r13]		;//  %r7  := t = *p	@
		jrge.d		3			;//  if(x < 0) {		*anti-interlock*
		 add		%r7, %r6		;//  %r7  := t += w	@	*delay*
		 sub		%r7, %r14		;//    %r7  := t -= v	@
		ld.w		[%r13]+, %r7		;//  *p++  = t }	@
		sub		%r15, 1			;//  %r15 := cnt--	@
		jrne.d		MakeWaveSQR_LOOP	;//} while(cnt)		@
		add		%r4, %r5		;//%r4  := x += y		*delay*
	sra	%r4,0x8		; 		xsra		%r4, 16			;//%r4  := x >>= 16
	sra	%r4,0x8
	ld.w	[%r12],%r4	; 		xld.w		[%r12+0], %r4		;//mp->freqwk = x
		ret					;//return

	
		.code
		.align		1
MakeWaveSAW:
	ld.w	%r4,[%r12]	; 		xld.w		%r4, [%r12+0]		;//%r4  := x = mp->freqwk
	ext	0x4		; 		xld.w		%r5, [%r12+4]		;//%r5  := y = mp->freq
	ld.w	%r5,[%r12]
		sra		%r14, 1			;//%r14 := v >>= 1
MakeWaveSAW_LOOP:					;//do {
		ld.w		%r6, [%r13]		;//  %r6  := t = *p
		mlt.h		%r4, %r14		;//  %alr :=      (x * v)
		ld.w		%r7, %alr		;//  %r7  :=      (x * v)
	sra	%r7,0x8		; 		xsra		%r7, 15			;//  %r7  :=      (x * v) >> 15
	sra	%r7,0x7
		add		%r6, %r7		;//  %r6  := t += (x * v) >> 15
		ld.w		[%r13]+, %r6		;//  *p++  = t
		sub		%r15, 1			;//  %r15 := cnt--
		jrne.d		MakeWaveSAW_LOOP	;//} while(cnt)
		add		%r4, %r5		;//%r4  := x += y	*delay*
	ld.w	[%r12],%r4	; 		xld.w		[%r12+0], %r4		;//mp->freqwk = x
		ret					;//return

	
		.code
		.align		1
MakeWaveTRI:
	ld.w	%r4,[%r12]	; 		xld.w		%r4, [%r12+0]		;//%r4  := x = mp->freqwk
	ext	0x4		; 		xld.w		%r5, [%r12+4]		;//%r5  := y = mp->freq
	ld.w	%r5,[%r12]
		sra		%r14, 1			;//%r14 := v >>= 1
MakeWaveTRI_LOOP:					;//do {
		ld.w		%r6, [%r13]		;//  %r6  := t = *p
		mlt.h		%r4, %r14		;//  %alr :=          (x * v)
		ld.w		%r7, %alr		;//  %r7  :=          (x * v)
		cmp		%r7, 0			;//  %r7  :=       abs(x * v)
		jrge.d		4			;//  
		 sra		%r7, 8			;//  %r7  :=       abs(x * v) >> 8	*delay*
		 not		%r7, %r7		;//  
		 add		%r7, 1			;//  
		sra		%r7, 6			;//  %r7  :=       abs(x * v) >> 14
		sub		%r7, %r14		;//  %r7  :=      (abs(x * v) >> 14) - v
		add		%r6, %r7		;//  %r6  := t += (abs(x * v) >> 14) - v
		ld.w		[%r13]+, %r6		;//  *p++  = t
		sub		%r15, 1			;//  %r15 := cnt--
		jrne.d		MakeWaveTRI_LOOP	;//} while(cnt)
		add		%r4, %r5		;//%r4  := x += y			*delay*
	ld.w	[%r12],%r4	; 		xld.w		[%r12+0], %r4		;//mp->freqwk = x
		ret					;//return

; NO_APP
	.code
	.align	1
GenEnvR:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x24		; 	xld.w	%r10,[%r12+36]
	ld.w	%r10,[%r12]
	ext	0x3e		; 	xsub	%r10,%r10,4000
	sub	%r10,0x20
	ext	0x24		; 	xld.w	[%r12+36],%r10
	ld.w	[%r12],%r10
	ext	0x1e20		; 	xld.w	%r11,-30720			; 0xffff8800
	ld.w	%r11,0x0
	cmp	%r10,%r11
	jrge	__LX71		; 	xjrge	__L71
	ext	0x24		; 	xld.w	[%r12+36],%r11
	ld.w	[%r12],%r11
	ld.w	%r13,0x0
	ext	0x4		; 	xld.w	[%r12+4],%r13
	ld.w	[%r12],%r13
__LX71:				; __L71:
	ret
	.align	1
GenEnvS:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x24		; 	xld.w	%r10,[%r12+36]
	ld.w	%r10,[%r12]
	ext	0x34		; 	xld.w	%r11,[%r12+52]
	ld.w	%r11,[%r12]
	sub	%r10,%r11
	ext	0x24		; 	xld.w	[%r12+36],%r10
	ld.w	[%r12],%r10
	ext	0x1e20		; 	xld.w	%r11,-30720			; 0xffff8800
	ld.w	%r11,0x0
	cmp	%r10,%r11
	jrge	__LX73		; 	xjrge	__L73
	ext	0x24		; 	xld.w	[%r12+36],%r11
	ld.w	[%r12],%r11
	ld.w	%r13,0x0
	ext	0x4		; 	xld.w	[%r12+4],%r13
	ld.w	[%r12],%r13
__LX73:				; __L73:
	ret
	.align	1
GenEnvD:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x24		; 	xld.w	%r10,[%r12+36]
	ld.w	%r10,[%r12]
	ext	0x2c		; 	xld.w	%r11,[%r12+44]
	ld.w	%r11,[%r12]
	sub	%r10,%r11
	ext	0x24		; 	xld.w	[%r12+36],%r10
	ld.w	[%r12],%r10
	ext	0x30		; 	xld.w	%r11,[%r12+48]
	ld.w	%r11,[%r12]
	cmp	%r10,%r11
	jrge	__LX75		; 	xjrge	__L75
	ext	GenEnvS+0x0@h	; 	xld.w	%r10,GenEnvS
	ext	GenEnvS+0x0@m
	ld.w	%r10,GenEnvS+0x0@l
	ext	0x50		; 	xld.w	[%r12+80],%r10
	ld.w	[%r12],%r10
__LX75:				; __L75:
	ret
	.align	1
GenEnvA:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x24		; 	xld.w	%r10,[%r12+36]
	ld.w	%r10,[%r12]
	ext	0x28		; 	xld.w	%r11,[%r12+40]
	ld.w	%r11,[%r12]
	add	%r10,%r11
	ext	0x24		; 	xld.w	[%r12+36],%r10
	ld.w	[%r12],%r10
	jrle	__LX77		; 	xjrle	__L77
	ld.w	%r13,0x0
	ext	0x24		; 	xld.w	[%r12+36],%r13
	ld.w	[%r12],%r13
	ext	GenEnvD+0x0@h	; 	xld.w	%r10,GenEnvD
	ext	GenEnvD+0x0@m
	ld.w	%r10,GenEnvD+0x0@l
	ext	0x50		; 	xld.w	[%r12+80],%r10
	ld.w	[%r12],%r10
__LX77:				; __L77:
	ret
	.align	1
GenEnvInit:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x28		; 	xld.w	%r11,[%r12+40]
	ld.w	%r11,[%r12]
	not	%r10,%r11
	add	%r10,1
	or	%r10,%r11
	sra	%r10,0x8	; 	xsra	%r10,31
	sra	%r10,0x8
	sra	%r10,0x8
	sra	%r10,0x7
	ext	0x1f40		; 	xand	%r10,%r10,0xffffd000
	and	%r10,0x0
	ext	0x24		; 	xld.w	[%r12+36],%r10
	ld.w	[%r12],%r10
	ext	GenEnvA+0x0@h	; 	xld.w	%r10,GenEnvA
	ext	GenEnvA+0x0@m
	ld.w	%r10,GenEnvA+0x0@l
	ext	0x50		; 	xld.w	[%r12+80],%r10
	ld.w	[%r12],%r10
	ret
	.align	1
SetEnvSpeed:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x3		; 	xld.w	%r10,0x000000c0		; 192
	ld.w	%r10,0x0
	mlt.w	%r12,%r10
	ld.w	%r12,%alr
	ext	0xc0		; 	xadd	%r12,%r12,12288
	add	%r12,0x0
	ext	gexp@rm		; 	xcall	gexp
	call	gexp@rl
	ret
	.align	1
SetEnv:
;	.frame	%sp,16,$31		# vars= 0, regs= 4/0, args= 0, extra= 0
;	.mask	0x80070000,-4
;	.fmask	0x00000000,0
	pushn	%r2
	ld.w	%r2,%r12
	ld.w	%r0,%r14
	ld.w	%r1,%r15
	ld.w	%r12,%r13
	call	SetEnvSpeed	; 	xcall	SetEnvSpeed
	ext	0x28		; 	xld.w	[%r2+40],%r10
	ld.w	[%r2],%r10
	ld.w	%r12,%r0
	call	SetEnvSpeed	; 	xcall	SetEnvSpeed
	ext	0x2c		; 	xld.w	[%r2+44],%r10
	ld.w	[%r2],%r10
	ext	0x1		; 	xsub	%r1,%r1,127
	sub	%r1,0x3f
	jrle	__LX83		; 	xjrle	__L83
	ld.w	%r1,0x0
__LX83:				; __L83:
	ext	0x3		; 	xld.w	%r10,0x000000c0		; 192
	ld.w	%r10,0x0
	mlt.w	%r1,%r10
	ld.w	%r11,%alr
	ext	0x30		; 	xld.w	[%r2+48],%r11
	ld.w	[%r2],%r11
	ld.w	%r12,[%sp+0x4]	; 	xld.w	%r12,[%sp+16]
	call	SetEnvSpeed	; 	xcall	SetEnvSpeed
	ext	0x34		; 	xld.w	[%r2+52],%r10
	ld.w	[%r2],%r10
	popn	%r2
	ret
	.align	1
GenVibS2:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x40		; 	xld.uh	%r10,[%r12+64]
	ld.uh	%r10,[%r12]
	ext	0x42		; 	xld.uh	%r13,[%r12+66]
	ld.uh	%r13,[%r12]
	add	%r10,%r13
	ext	0x40		; 	xld.h	[%r12+64],%r10
	ld.h	[%r12],%r10
	ld.h	%r11,%r10
	cmp	%r11,0x0
	jrge	__LX85		; 	xjrge	__L85
	not	%r11,%r11
	add	%r11,1
__LX85:				; __L85:
	ext	0x100		; 	xld.w	%r10,0x00004000		; 16384
	ld.w	%r10,0x0
	sub	%r10,%r11
	ext	0x48		; 	xld.h	%r11,[%r12+72]
	ld.h	%r11,[%r12]
	mlt.w	%r10,%r11
	ld.w	%r10,%alr
	sra	%r10,0x3	; 	xsra	%r10,3
	ext	0x20		; 	xld.w	[%r12+32],%r10
	ld.w	[%r12],%r10
	ret
	.align	1
GenVibS1:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x48		; 	xld.uh	%r10,[%r12+72]
	ld.uh	%r10,[%r12]
	ext	0x46		; 	xld.uh	%r13,[%r12+70]
	ld.uh	%r13,[%r12]
	add	%r10,%r13
	ext	0x48		; 	xld.h	[%r12+72],%r10
	ld.h	[%r12],%r10
	ld.h	%r10,%r10
	ext	0x4a		; 	xld.h	%r11,[%r12+74]
	ld.h	%r11,[%r12]
	cmp	%r10,%r11
	jrlt	__LX87		; 	xjrlt	__L87
	ext	GenVibS2+0x0@h	; 	xld.w	%r10,GenVibS2
	ext	GenVibS2+0x0@m
	ld.w	%r10,GenVibS2+0x0@l
	ext	0x54		; 	xld.w	[%r12+84],%r10
	ld.w	[%r12],%r10
	ext	0x4a		; 	xld.uh	%r10,[%r12+74]
	ld.uh	%r10,[%r12]
	ext	0x48		; 	xld.h	[%r12+72],%r10
	ld.h	[%r12],%r10
__LX87:				; __L87:
	call	GenVibS2	; 	xcall	GenVibS2
	ret
	.align	1
GenVibS0:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x48		; 	xld.uh	%r10,[%r12+72]
	ld.uh	%r10,[%r12]
	ext	0x44		; 	xld.uh	%r11,[%r12+68]
	ld.uh	%r11,[%r12]
	add	%r10,%r11
	ext	0x48		; 	xld.h	[%r12+72],%r10
	ld.h	[%r12],%r10
	ld.h	%r10,%r10
	cmp	%r10,0x0
	jrlt	__LX89		; 	xjrlt	__L89
	ext	GenVibS1+0x0@h	; 	xld.w	%r10,GenVibS1
	ext	GenVibS1+0x0@m
	ld.w	%r10,GenVibS1+0x0@l
	ext	0x54		; 	xld.w	[%r12+84],%r10
	ld.w	[%r12],%r10
	ld.w	%r11,0x0
	ext	0x40		; 	xld.h	[%r12+64],%r11
	ld.h	[%r12],%r11
	ext	0x48		; 	xld.h	[%r12+72],%r11
	ld.h	[%r12],%r11
__LX89:				; __L89:
	ret
	.align	1
GenVibInit:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	GenVibS0+0x0@h	; 	xld.w	%r10,GenVibS0
	ext	GenVibS0+0x0@m
	ld.w	%r10,GenVibS0+0x0@l
	ext	0x54		; 	xld.w	[%r12+84],%r10
	ld.w	[%r12],%r10
	ext	0x1f00		; 	xld.w	%r10,-16384			; 0xffffc000
	ld.w	%r10,0x0
	ext	0x48		; 	xld.h	[%r12+72],%r10
	ld.h	[%r12],%r10
	ret
	.align	1
SetVib:
;	.frame	%sp,20,$31		# vars= 0, regs= 5/0, args= 0, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	ld.w	%r2,%r12
	ld.w	%r3,%r15
	ext	0x1		; 	xld.w	%r10,0x00000060		; 96
	ld.w	%r10,0x20
	mlt.w	%r13,%r10
	ld.w	%r11,%alr
	ext	0x4a		; 	xld.h	[%r2+74],%r11
	ld.h	[%r2],%r11
	ext	0x3		; 	xld.w	%r1,0x000000c0		; 192
	ld.w	%r1,0x0
	mlt.w	%r14,%r1
	ext	0x180		; 	xld.w	%r0,0x00006000		; 24576
	ld.w	%r0,0x0
	ld.w	%r12,%alr
	add	%r12,%r0
	ext	gexp@rm		; 	xcall	gexp
	call	gexp@rl
	ext	0x42		; 	xld.h	[%r2+66],%r10
	ld.h	[%r2],%r10
	mlt.w	%r3,%r1
	ld.w	%r12,%alr
	add	%r12,%r0
	ext	gexp@rm		; 	xcall	gexp
	call	gexp@rl
	ext	0x44		; 	xld.h	[%r2+68],%r10
	ld.h	[%r2],%r10
	ld.w	%r11,[%sp+0x5]	; 	xld.w	%r11,[%sp+20]
	mlt.w	%r11,%r1
	ld.w	%r12,%alr
	add	%r12,%r0
	ext	gexp@rm		; 	xcall	gexp
	call	gexp@rl
	ext	0x46		; 	xld.h	[%r2+70],%r10
	ld.h	[%r2],%r10
	popn	%r3
	ret
	.code
	.align	2
TBL_genwave.90:
	.word	MakeWaveSQR
	.word	MakeWaveSAW
	.word	MakeWaveTRI
	.code
	.align	1
SetInst:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	sll	%r13,0x2	; 	xsll	%r13,2
	ext	inst+0x0@h	; 	xld.w	%r13,[%r13+inst]
	ext	inst+0x0@m
	ld.w	%r9,inst+0x0@l
	add	%r9,%r13
	ld.w	%r13,[%r9]
	ld.w	%r14,0x0
	ext	0x4		; 	xld.w	[%r12+4],%r14
	ld.w	[%r12],%r14
	ext	0x8		; 	xld.w	%r10,[%r13+8]
	ld.w	%r10,[%r13]
	ext	0x8		; 	xld.w	[%r12+8],%r10
	ld.w	[%r12],%r10
	ext	0x10		; 	xld.w	%r11,[%r13+16]
	ld.w	%r11,[%r13]
	ext	0xc		; 	xld.w	[%r12+12],%r11
	ld.w	[%r12],%r11
	ld.ub	%r10,[%r13]	; 	xld.ub	%r10,[%r13]
	and	%r10,0x10	; 	xand	%r10,%r10,0x00000010
	jreq	__LX93		; 	xjreq	__L93
	ext	0xc		; 	xld.w	%r10,[%r13+12]
	ld.w	%r10,[%r13]
	sub	%r11,%r10
	ld.w	%r10,%r11
__LX93:				; __L93:
	ext	0x10		; 	xld.w	[%r12+16],%r10
	ld.w	[%r12],%r10
	ext	0x4		; 	xld.uh	%r10,[%r13+4]
	ld.uh	%r10,[%r13]
	ext	0x6		; 	xld.uh	%r11,[%r13+6]
	ld.uh	%r11,[%r13]
	sub	%r10,%r11
	ext	0x183		; 	xadd	%r10,%r10,24777
	add	%r10,0x9
	ext	0x14		; 	xld.w	[%r12+20],%r10
	ld.w	[%r12],%r10
	ld.w	%r14,0x0
	ext	0x28		; 	xld.w	[%r12+40],%r14
	ld.w	[%r12],%r14
	btst	[%r13],0x7	; 	xbtst	[%r13],0x7
	jreq	__LX95		; 	xjreq	__L95
	ext	0x1		; 	xld.ub	%r10,[%r13+1]
	ld.ub	%r10,[%r13]
	sll	%r10,0x2	; 	xsll	%r10,2
	ext	TBL_genwave.90+0x0@h	; 	xld.w	%r10,[%r10+TBL_genwave.90]
	ext	TBL_genwave.90+0x0@m
	ld.w	%r9,TBL_genwave.90+0x0@l
	add	%r9,%r10
	ld.w	%r10,[%r9]
	jp	__LX97		; 	xjp	__L97
__LX95:				; __L95:
	ext	MakeWave+0x0@h	; 	xld.w	%r10,MakeWave
	ext	MakeWave+0x0@m
	ld.w	%r10,MakeWave+0x0@l
__LX97:				; __L97:
	ext	0x4c		; 	xld.w	[%r12+76],%r10
	ld.w	[%r12],%r10
	ret
	.align	1
SetVol:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x3		; 	xld.w	%r10,0x000000c0		; 192
	ld.w	%r10,0x0
	mlt.w	%r13,%r10
	ld.w	%r10,%alr
	ext	0x210		; 	xadd	%r10,%r10,33792
	add	%r10,0x0
	ext	0x38		; 	xld.w	[%r12+56],%r10
	ld.w	[%r12],%r10
	ld.w	%r11,0x0
	ext	0x3c		; 	xld.w	[%r12+60],%r11
	ld.w	[%r12],%r11
	ret
	.align	1
SetExp:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x1		; 	xsub	%r13,%r13,127
	sub	%r13,0x3f
	ext	0x3		; 	xld.w	%r10,0x000000c0		; 192
	ld.w	%r10,0x0
	mlt.w	%r13,%r10
	ld.w	%r11,%alr
	ext	0x3c		; 	xld.w	[%r12+60],%r11
	ld.w	[%r12],%r11
	ret
	.align	1
SetExpRel:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x3		; 	xld.w	%r10,0x000000c0		; 192
	ld.w	%r10,0x0
	mlt.w	%r13,%r10
	ext	0x3c		; 	xld.w	%r10,[%r12+60]
	ld.w	%r10,[%r12]
	ld.w	%r11,%alr
	add	%r10,%r11
	ext	0x3c		; 	xld.w	[%r12+60],%r10
	ld.w	[%r12],%r10
	ret
	.align	1
NoteOn:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ld.w	%r11,0x0
	ld.w	[%r0],%r11	; 	xld.w	[%r0],%r11
	ld.w	%r10,0x1	; 	xld.w	%r10,0x00000001		; 1
	ext	0x4		; 	xld.w	[%r0+4],%r10
	ld.w	[%r0],%r10
	ext	0x14		; 	xld.w	%r10,[%r0+20]
	ld.w	%r10,[%r0]
	add	%r10,%r13
	ext	0x18		; 	xld.w	[%r0+24],%r10
	ld.w	[%r0],%r10
	ext	0x1c		; 	xld.w	[%r0+28],%r11
	ld.w	[%r0],%r11
	ext	0x20		; 	xld.w	[%r0+32],%r11
	ld.w	[%r0],%r11
	ext	GenEnvInit@rm	; 	xcall	GenEnvInit
	call	GenEnvInit@rl
	ld.w	%r12,%r0
	ext	GenVibInit@rm	; 	xcall	GenVibInit
	call	GenVibInit@rl
	popn	%r0
	ret
	.align	1
NotePitch:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x14		; 	xld.w	%r10,[%r12+20]
	ld.w	%r10,[%r12]
	add	%r10,%r13
	ext	0x18		; 	xld.w	[%r12+24],%r10
	ld.w	[%r12],%r10
	ret
	.align	1
NoteOff:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	GenEnvR+0x0@h	; 	xld.w	%r10,GenEnvR
	ext	GenEnvR+0x0@m
	ld.w	%r10,GenEnvR+0x0@l
	ext	0x50		; 	xld.w	[%r12+80],%r10
	ld.w	[%r12],%r10
	ret
	.global	title
	.code
	.align	2
__LC0:
	.ascii	"\000"
	.data
	.align	2
title:
	.word	__LC0
	.global	title2
	.align	2
title2:
	.word	__LC0
	.global	music_wch
music_wch:
	.byte	0
using_wch:
	.byte	-1
	.code
	.align	1
getadrs:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.ub	%r10,[%r12]	; 	xld.ub	%r10,[%r12]
	ext	0x1		; 	xld.ub	%r11,[%r12+1]
	ld.ub	%r11,[%r12]
	sll	%r11,0x8	; 	xsll	%r11,8
	or	%r10,%r11
	ret
	.align	1
SeqNop:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ret
	.align	1
SeqNop1:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x58		; 	xld.w	%r10,[%r12+88]
	ld.w	%r10,[%r12]
	add	%r10,0x1	; 	xadd	%r10,%r10,1
	ext	0x58		; 	xld.w	[%r12+88],%r10
	ld.w	[%r12],%r10
	ret
	.align	1
SeqNop2:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x58		; 	xld.w	%r10,[%r12+88]
	ld.w	%r10,[%r12]
	add	%r10,0x2	; 	xadd	%r10,%r10,2
	ext	0x58		; 	xld.w	[%r12+88],%r10
	ld.w	[%r12],%r10
	ret
	.code
	.align	2
__LC1:
	.ascii	"muslib.$\000"
	.code
	.align	1
StartSeq:
;	.frame	%sp,20,$31		# vars= 0, regs= 5/0, args= 0, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	ld.w	%r1,%r12
	ext	datatop+0x0@ah	; 	xld.w	[datatop],%r1
	ext	datatop+0x0@al
	ld.w	[%r8],%r1
	ext	0x1e		; 	xld.w	%r10,0x00000780		; 1920
	ld.w	%r10,0x0
	ext	tempo+0x0@ah	; 	xld.h	[tempo],%r10
	ext	tempo+0x0@al
	ld.h	[%r8],%r10
	ld.w	%r15,0x0
	ext	tempowk+0x0@ah	; 	xld.h	[tempowk],%r15
	ext	tempowk+0x0@al
	ld.h	[%r8],%r15
	ld.w	%r10,0x1	; 	xld.w	%r10,0x00000001		; 1
	ext	runf+0x0@ah	; 	xld.b	[runf],%r10
	ext	runf+0x0@al
	ld.b	[%r8],%r10
	ld.ub	%r3,[%r1]	; 	xld.ub	%r3,[%r1]
	add	%r1,0x1		; 	xadd	%r1,%r1,1
	cmp	%r3,0x0
	jrne	__LX109		; 	xjrne	__L109
	ld.ub	%r3,[%r1]	; 	xld.ub	%r3,[%r1]
	add	%r1,0x1		; 	xadd	%r1,%r1,1
__LX109:				; __L109:
	ext	0x1		; 	xsub	%r10,%r3,1
	sub	%r10,%r3
	cmp	%r10,0x5	; 	xcmp	%r10,5
	jrule	__LX110		; 	xjrule	__L110
	ext	__LC1+0x0@h	; 	xld.w	%r12,__LC1
	ext	__LC1+0x0@m
	ld.w	%r12,__LC1+0x0@l
	ext	0xa		; 	xld.w	%r13,0x00000298		; 664
	ld.w	%r13,0x18
	ext	die2@rm		; 	xcall	die2
	call	die2@rl
__LX110:				; __L110:
	ext	seqwk+0x0@h	; 	xld.w	%r12,seqwk
	ext	seqwk+0x0@m
	ld.w	%r12,seqwk+0x0@l
	ld.w	%r13,0x0
	ext	0xf		; 	xld.w	%r14,0x000003d8		; 984
	ld.w	%r14,0x18
	ext	memset@rm	; 	xcall	memset
	call	memset@rl
	ld.w	%r2,0x0
	cmp	%r2,%r3
	jrge	__LX112		; 	xjrge	__L112
__LX114:				; __L114:
	ext	0x2		; 	xld.w	%r10,0x000000a4		; 164
	ld.w	%r10,0x24
	mlt.w	%r2,%r10
	ext	seqwk+0x0@h	; 	xld.w	%r0,seqwk
	ext	seqwk+0x0@m
	ld.w	%r0,seqwk+0x0@l
	ld.w	%r15,%alr
	add	%r15,%r0
	ld.w	%r0,%r15
	ld.w	%r12,%r1
	call	getadrs		; 	xcall	getadrs
	ext	datatop+0x0@ah	; 	xld.w	%r11,[datatop]
	ext	datatop+0x0@al
	ld.w	%r11,[%r8]
	add	%r11,%r10
	ext	0x58		; 	xld.w	[%r0+88],%r11
	ld.w	[%r0],%r11
	add	%r1,0x2		; 	xadd	%r1,%r1,2
	ext	0x0		; 	xld.w	%r10,0x00000029		; 41
	ld.w	%r10,0x29
	ext	0x66		; 	xld.h	[%r0+102],%r10
	ld.h	[%r0],%r10
	ld.w	%r10,0x1	; 	xld.w	%r10,0x00000001		; 1
	ext	0x68		; 	xld.b	[%r0+104],%r10
	ld.b	[%r0],%r10
	ext	SeqNop+0x0@h	; 	xld.w	%r10,SeqNop
	ext	SeqNop+0x0@m
	ld.w	%r10,SeqNop+0x0@l
	ext	0x70		; 	xld.w	[%r0+112],%r10
	ld.w	[%r0],%r10
	ld.w	%r12,%r0
	ld.w	%r13,0x0
	ext	SetInst@rm	; 	xcall	SetInst
	call	SetInst@rl
	ld.w	%r12,%r0
	ext	0x1		; 	xld.w	%r13,0x0000007f		; 127
	ld.w	%r13,0x3f
	ext	SetVol@rm	; 	xcall	SetVol
	call	SetVol@rl
	add	%r2,0x1		; 	xadd	%r2,%r2,1
	cmp	%r2,%r3
	jrlt	__LX114		; 	xjrlt	__L114
__LX112:				; __L112:
	ld.w	%r12,%r1
	call	getadrs		; 	xcall	getadrs
	ext	datatop+0x0@ah	; 	xld.w	%r11,[datatop]
	ext	datatop+0x0@al
	ld.w	%r11,[%r8]
	add	%r11,%r10
	ext	drumsbase+0x0@ah	; 	xld.w	[drumsbase],%r11
	ext	drumsbase+0x0@al
	ld.w	[%r8],%r11
	add	%r1,0x2		; 	xadd	%r1,%r1,2
	ld.w	%r12,%r1
	call	getadrs		; 	xcall	getadrs
	ext	datatop+0x0@ah	; 	xld.w	%r11,[datatop]
	ext	datatop+0x0@al
	ld.w	%r11,[%r8]
	add	%r11,%r10
	ext	title+0x0@ah	; 	xld.w	[title],%r11
	ext	title+0x0@al
	ld.w	[%r8],%r11
	ext	0x2		; 	xadd	%r12,%r1,2
	add	%r12,%r1
	ext	getadrs@rm	; 	xcall	getadrs
	call	getadrs@rl
	ext	datatop+0x0@ah	; 	xld.w	%r11,[datatop]
	ext	datatop+0x0@al
	ld.w	%r11,[%r8]
	add	%r11,%r10
	ext	title2+0x0@ah	; 	xld.w	[title2],%r11
	ext	title2+0x0@al
	ld.w	[%r8],%r11
	popn	%r3
	ret
	.align	1
SeqPortaExecP:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x1c		; 	xld.w	%r10,[%r12+28]
	ld.w	%r10,[%r12]
	ext	0x5c		; 	xld.w	%r11,[%r12+92]
	ld.w	%r11,[%r12]
	add	%r10,%r11
	ext	0x1c		; 	xld.w	[%r12+28],%r10
	ld.w	[%r12],%r10
	jrlt	__LX117		; 	xjrlt	__L117
	ld.w	%r13,0x0
	ext	0x1c		; 	xld.w	[%r12+28],%r13
	ld.w	[%r12],%r13
	ext	0x6b		; 	xbclr	[%r12+107],0x1
	bclr	[%r12],0x1
__LX117:				; __L117:
	ret
	.align	1
SeqPortaExecN:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x1c		; 	xld.w	%r10,[%r12+28]
	ld.w	%r10,[%r12]
	ext	0x5c		; 	xld.w	%r11,[%r12+92]
	ld.w	%r11,[%r12]
	sub	%r10,%r11
	ext	0x1c		; 	xld.w	[%r12+28],%r10
	ld.w	[%r12],%r10
	jrgt	__LX119		; 	xjrgt	__L119
	ld.w	%r13,0x0
	ext	0x1c		; 	xld.w	[%r12+28],%r13
	ld.w	[%r12],%r13
	ext	0x6b		; 	xbclr	[%r12+107],0x1
	bclr	[%r12],0x1
__LX119:				; __L119:
	ret
	.align	1
SeqNote:
;	.frame	%sp,12,$31		# vars= 0, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	ld.w	%r0,%r12
	ld.w	%r1,%r13
	ext	0x6c		; 	xld.b	%r10,[%r0+108]
	ld.b	%r10,[%r0]
	ld.w	%r14,%r1
	add	%r14,%r10
	ld.w	%r10,%r14
	sll	%r10,0x8	; 	xsll	%r10,8
	ext	0x6d		; 	xld.b	%r11,[%r0+109]
	ld.b	%r11,[%r0]
	ld.w	%r13,%r10
	add	%r13,%r11
	ext	0x62		; 	xld.uh	%r10,[%r0+98]
	ld.uh	%r10,[%r0]
	ext	0x60		; 	xld.h	[%r0+96],%r10
	ld.h	[%r0],%r10
	ext	0x68		; 	xld.w	%r10,[%r0+104]
	ld.w	%r10,[%r0]
	ext	0x100		; 	xand	%r10,%r10,0x080000ff
	ext	0x3
	and	%r10,0x3f
	ext	0x100		; 	xcmp	%r10,134217730
	ext	0x0
	cmp	%r10,0x2
	jrne	__LX121		; 	xjrne	__L121
	ext	NotePitch@rm	; 	xcall	NotePitch
	call	NotePitch@rl
	jp	__LX122		; 	xjp	__L122
__LX121:				; __L121:
	ld.w	%r12,%r0
	ext	NoteOn@rm	; 	xcall	NoteOn
	call	NoteOn@rl
	ld.w	%r10,0x2	; 	xld.w	%r10,0x00000002		; 2
	ext	0x68		; 	xld.b	[%r0+104],%r10
	ld.b	[%r0],%r10
__LX122:				; __L122:
	ext	0x6b		; 	xld.ub	%r11,[%r0+107]
	ld.ub	%r11,[%r0]
	ld.w	%r10,%r11
	and	%r10,0xc	; 	xand	%r10,%r10,0x0000000c
	cmp	%r10,0x8	; 	xcmp	%r10,8
	jrne	__LX123		; 	xjrne	__L123
	ld.w	%r10,%r11
	ext	0x3		; 	xand	%r10,%r10,0x000000f7
	and	%r10,0x37
	ext	0x6b		; 	xld.b	[%r0+107],%r10
	ld.b	[%r0],%r10
__LX123:				; __L123:
	ext	0x6b		; 	xbtst	[%r0+107],0x0
	btst	[%r0],0x0
	jreq	__LX124		; 	xjreq	__L124
	ext	0x6e		; 	xld.b	%r11,[%r0+110]
	ld.b	%r11,[%r0]
	cmp	%r11,0x0
	jrne	__LX125		; 	xjrne	__L125
	ext	0x6f		; 	xld.b	%r10,[%r0+111]
	ld.b	%r10,[%r0]
	ld.w	%r11,%r10
	sub	%r11,%r1
__LX125:				; __L125:
	ld.w	%r10,%r11
	sll	%r10,0x8	; 	xsll	%r10,18
	sll	%r10,0x8
	sll	%r10,0x2
	ext	0x1c		; 	xld.w	[%r0+28],%r10
	ld.w	[%r0],%r10
	ext	SeqPortaExecN+0x0@h	; 	xld.w	%r10,SeqPortaExecN
	ext	SeqPortaExecN+0x0@m
	ld.w	%r10,SeqPortaExecN+0x0@l
	cmp	%r11,0x0
	jrge	__LX126		; 	xjrge	__L126
	ext	SeqPortaExecP+0x0@h	; 	xld.w	%r10,SeqPortaExecP
	ext	SeqPortaExecP+0x0@m
	ld.w	%r10,SeqPortaExecP+0x0@l
__LX126:				; __L126:
	ext	0x70		; 	xld.w	[%r0+112],%r10
	ld.w	[%r0],%r10
	ext	0x6b		; 	xbset	[%r0+107],0x1
	bset	[%r0],0x1
__LX124:				; __L124:
	ext	0x6f		; 	xld.b	[%r0+111],%r1
	ld.b	[%r0],%r1
	ld.w	%r11,0x0
	ext	0x6a		; 	xbtst	[%r0+106],0x1
	btst	[%r0],0x1
	jrne	__LX128		; 	xjrne	__L128
	ext	0x62		; 	xld.h	%r12,[%r0+98]
	ld.h	%r12,[%r0]
	ext	0x66		; 	xld.h	%r10,[%r0+102]
	ld.h	%r10,[%r0]
	mlt.w	%r12,%r10
	ld.w	%r11,%alr
	sra	%r11,0x8	; 	xsra	%r11,12
	sra	%r11,0x4
	jrgt	__LX129		; 	xjrgt	__L129
	ld.w	%r11,0x1	; 	xld.w	%r11,0x00000001		; 1
__LX129:				; __L129:
	ext	0x1		; 	xsub	%r10,%r12,1
	sub	%r10,%r12
	cmp	%r11,%r10
	jrle	__LX128		; 	xjrle	__L128
	ld.w	%r11,%r10
__LX128:				; __L128:
	ext	0x64		; 	xld.h	[%r0+100],%r11
	ld.h	[%r0],%r11
	popn	%r1
	ret
	.align	1
SeqNote2:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x58		; 	xld.w	%r11,[%r12+88]
	ld.w	%r11,[%r12]
	ext	0x1		; 	xadd	%r10,%r11,1
	add	%r10,%r11
	ext	0x58		; 	xld.w	[%r12+88],%r10
	ld.w	[%r12],%r10
	ld.ub	%r13,[%r11]	; 	xld.ub	%r13,[%r11]
	ext	0x1		; 	xcmp	%r13,127
	cmp	%r13,0x3f
	jrle	__LX132		; 	xjrle	__L132
	ext	0x1		; 	xsub	%r13,%r13,116
	sub	%r13,0x34
__LX132:				; __L132:
	call	SeqNote		; 	xcall	SeqNote
	ret
	.align	1
SeqDrums:
;	.frame	%sp,20,$31		# vars= 8, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	sub	%sp,0x2		; 	xsub	%sp,%sp,8
	ld.w	%r1,%r12
	ext	0x69		; 	xld.ub	%r0,[%r1+105]
	ld.ub	%r0,[%r1]
	sll	%r13,0x1	; 	xsll	%r13,1
	ext	drumsbase+0x0@ah	; 	xld.w	%r12,[drumsbase]
	ext	drumsbase+0x0@al
	ld.w	%r12,[%r8]
	add	%r12,%r13
	ext	getadrs@rm	; 	xcall	getadrs
	call	getadrs@rl
	ld.w	%r11,%r0
	sll	%r11,0x1	; 	xsll	%r11,1
	add	%r11,%r1
	ld.w	%r12,0x1	; 	xld.w	%r12,0x00000001		; 1
	ext	0x74		; 	xld.h	[%r11+116],%r12
	ld.h	[%r11],%r12
	add	%r0,0x1		; 	xadd	%r0,%r0,1
	ld.w	%r11,%r0
	sll	%r11,0x1	; 	xsll	%r11,1
	add	%r11,%r1
	ext	datatop+0x0@ah	; 	xld.w	%r13,[datatop]
	ext	datatop+0x0@al
	ld.w	%r13,[%r8]
	ext	0x58		; 	xld.uh	%r12,[%r1+88]
	ld.uh	%r12,[%r1]
	sub	%r12,%r13
	ext	0x74		; 	xld.h	[%r11+116],%r12
	ld.h	[%r11],%r12
	add	%r0,0x1		; 	xadd	%r0,%r0,1
	ld.w	%r11,%r0
	sll	%r11,0x1	; 	xsll	%r11,1
	add	%r11,%r1
	ext	0x74		; 	xld.h	[%r11+116],%r10
	ld.h	[%r11],%r10
	add	%r0,0x1		; 	xadd	%r0,%r0,1
	add	%r13,%r10
	ext	0x58		; 	xld.w	[%r1+88],%r13
	ld.w	[%r1],%r13
	ext	0x69		; 	xld.b	[%r1+105],%r0
	ld.b	[%r1],%r0
	add	%sp,0x2		; 	xadd	%sp,%sp,8
	popn	%r1
	ret
	.align	1
SeqRest:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ext	0x68		; 	xld.ub	%r10,[%r0+104]
	ld.ub	%r10,[%r0]
	cmp	%r10,0x2	; 	xcmp	%r10,2
	jrne	__LX135		; 	xjrne	__L135
	ext	NoteOff@rm	; 	xcall	NoteOff
	call	NoteOff@rl
	ld.w	%r10,0x1	; 	xld.w	%r10,0x00000001		; 1
	ext	0x68		; 	xld.b	[%r0+104],%r10
	ld.b	[%r0],%r10
__LX135:				; __L135:
	ext	0x62		; 	xld.uh	%r10,[%r0+98]
	ld.uh	%r10,[%r0]
	ext	0x60		; 	xld.h	[%r0+96],%r10
	ld.h	[%r0],%r10
	popn	%r0
	ret
	.align	1
SeqInst:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x58		; 	xld.w	%r11,[%r12+88]
	ld.w	%r11,[%r12]
	ext	0x1		; 	xadd	%r10,%r11,1
	add	%r10,%r11
	ext	0x58		; 	xld.w	[%r12+88],%r10
	ld.w	[%r12],%r10
	ld.ub	%r13,[%r11]	; 	xld.ub	%r13,[%r11]
	ext	SetInst@rm	; 	xcall	SetInst
	call	SetInst@rl
	ret
	.align	1
SeqTempo:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x58		; 	xld.w	%r11,[%r12+88]
	ld.w	%r11,[%r12]
	ext	0x1		; 	xadd	%r10,%r11,1
	add	%r10,%r11
	ext	0x58		; 	xld.w	[%r12+88],%r10
	ld.w	[%r12],%r10
	ld.ub	%r10,[%r11]	; 	xld.ub	%r10,[%r11]
	sll	%r10,0x4	; 	xsll	%r10,4
	ext	tempo+0x0@ah	; 	xld.h	[tempo],%r10
	ext	tempo+0x0@al
	ld.h	[%r8],%r10
	ret
	.align	1
SeqEnd:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x69		; 	xld.ub	%r14,[%r12+105]
	ld.ub	%r14,[%r12]
	cmp	%r14,0x0
	jrne	__LX139		; 	xjrne	__L139
	ld.w	%r15,0x0
	ext	0x68		; 	xld.b	[%r12+104],%r15
	ld.b	[%r12],%r15
	jp	__LX138		; 	xjp	__L138
__LX139:				; __L139:
	sub	%r14,0x3	; 	xsub	%r14,%r14,3
	ld.w	%r10,%r14
	sll	%r10,0x1	; 	xsll	%r10,1
	ld.w	%r13,%r10
	add	%r13,%r12
	ext	0x74		; 	xadd	%r11,%r13,116
	add	%r11,%r13
	ld.uh	%r10,[%r11]	; 	xld.uh	%r10,[%r11]
	sub	%r10,0x1	; 	xsub	%r10,%r10,1
	ld.h	[%r11],%r10	; 	xld.h	[%r11],%r10
	ld.uh	%r10,%r10
	cmp	%r10,0x0
	jreq	__LX140		; 	xjreq	__L140
	ext	0x78		; 	xld.uh	%r11,[%r13+120]
	ld.uh	%r11,[%r13]
	ext	datatop+0x0@ah	; 	xld.w	%r10,[datatop]
	ext	datatop+0x0@al
	ld.w	%r10,[%r8]
	add	%r10,%r11
	ext	0x58		; 	xld.w	[%r12+88],%r10
	ld.w	[%r12],%r10
	jp	__LX138		; 	xjp	__L138
__LX140:				; __L140:
	ext	0x76		; 	xld.uh	%r11,[%r13+118]
	ld.uh	%r11,[%r13]
	ext	datatop+0x0@ah	; 	xld.w	%r10,[datatop]
	ext	datatop+0x0@al
	ld.w	%r10,[%r8]
	add	%r10,%r11
	ext	0x58		; 	xld.w	[%r12+88],%r10
	ld.w	[%r12],%r10
	ext	0x69		; 	xld.b	[%r12+105],%r14
	ld.b	[%r12],%r14
__LX138:				; __L138:
	ret
	.align	1
SeqGate:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x58		; 	xld.w	%r11,[%r12+88]
	ld.w	%r11,[%r12]
	ext	0x1		; 	xadd	%r10,%r11,1
	add	%r10,%r11
	ext	0x58		; 	xld.w	[%r12+88],%r10
	ld.w	[%r12],%r10
	ld.ub	%r11,[%r11]	; 	xld.ub	%r11,[%r11]
	ext	0x1		; 	xld.w	%r10,0x00000064		; 100
	ld.w	%r10,0x24
	sub	%r10,%r11
	ext	0x0		; 	xld.w	%r11,0x00000029		; 41
	ld.w	%r11,0x29
	mlt.w	%r10,%r11
	ld.w	%r13,%alr
	ext	0x66		; 	xld.h	[%r12+102],%r13
	ld.h	[%r12],%r13
	ret
	.align	1
SeqJump:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ext	0x58		; 	xld.w	%r12,[%r0+88]
	ld.w	%r12,[%r0]
	ext	getadrs@rm	; 	xcall	getadrs
	call	getadrs@rl
	ext	datatop+0x0@ah	; 	xld.w	%r11,[datatop]
	ext	datatop+0x0@al
	ld.w	%r11,[%r8]
	add	%r11,%r10
	ext	0x58		; 	xld.w	[%r0+88],%r11
	ld.w	[%r0],%r11
	popn	%r0
	ret
	.align	1
SeqCall:
;	.frame	%sp,20,$31		# vars= 8, regs= 3/0, args= 0, extra= 0
;	.mask	0x80030000,-4
;	.fmask	0x00000000,0
	pushn	%r1
	sub	%sp,0x2		; 	xsub	%sp,%sp,8
	ld.w	%r1,%r12
	ext	0x69		; 	xld.ub	%r0,[%r1+105]
	ld.ub	%r0,[%r1]
	ext	0x58		; 	xld.w	%r12,[%r1+88]
	ld.w	%r12,[%r1]
	ext	getadrs@rm	; 	xcall	getadrs
	call	getadrs@rl
	ld.w	%r11,%r0
	sll	%r11,0x1	; 	xsll	%r11,1
	add	%r11,%r1
	ext	0x58		; 	xld.w	%r12,[%r1+88]
	ld.w	%r12,[%r1]
	ext	0x2		; 	xld.ub	%r12,[%r12+2]
	ld.ub	%r12,[%r12]
	ext	0x74		; 	xld.h	[%r11+116],%r12
	ld.h	[%r11],%r12
	add	%r0,0x1		; 	xadd	%r0,%r0,1
	ld.w	%r12,%r0
	sll	%r12,0x1	; 	xsll	%r12,1
	add	%r12,%r1
	ext	datatop+0x0@ah	; 	xld.w	%r13,[datatop]
	ext	datatop+0x0@al
	ld.w	%r13,[%r8]
	ext	0x3		; 	xsub	%r11,%r13,3
	sub	%r11,%r13
	ext	0x58		; 	xld.uh	%r14,[%r1+88]
	ld.uh	%r14,[%r1]
	sub	%r14,%r11
	ld.w	%r11,%r14
	ext	0x74		; 	xld.h	[%r12+116],%r11
	ld.h	[%r12],%r11
	add	%r0,0x1		; 	xadd	%r0,%r0,1
	ld.w	%r11,%r0
	sll	%r11,0x1	; 	xsll	%r11,1
	add	%r11,%r1
	ext	0x74		; 	xld.h	[%r11+116],%r10
	ld.h	[%r11],%r10
	add	%r0,0x1		; 	xadd	%r0,%r0,1
	add	%r13,%r10
	ext	0x58		; 	xld.w	[%r1+88],%r13
	ld.w	[%r1],%r13
	ext	0x69		; 	xld.b	[%r1+105],%r0
	ld.b	[%r1],%r0
	add	%sp,0x2		; 	xadd	%sp,%sp,8
	popn	%r1
	ret
	.align	1
SeqRept:
;	.frame	%sp,12,$31		# vars= 8, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	sub	%sp,0x2		; 	xsub	%sp,%sp,8
	ext	0x69		; 	xld.ub	%r13,[%r12+105]
	ld.ub	%r13,[%r12]
	ld.w	%r11,%r13
	sll	%r11,0x1	; 	xsll	%r11,1
	add	%r11,%r12
	ext	0x58		; 	xld.w	%r14,[%r12+88]
	ld.w	%r14,[%r12]
	ext	0x1		; 	xadd	%r10,%r14,1
	add	%r10,%r14
	ext	0x58		; 	xld.w	[%r12+88],%r10
	ld.w	[%r12],%r10
	ld.ub	%r10,[%r14]	; 	xld.ub	%r10,[%r14]
	ext	0x74		; 	xld.h	[%r11+116],%r10
	ld.h	[%r11],%r10
	add	%r13,0x1	; 	xadd	%r13,%r13,1
	ld.w	%r10,%r13
	sll	%r10,0x1	; 	xsll	%r10,1
	add	%r10,%r12
	ext	0x58		; 	xld.uh	%r11,[%r12+88]
	ld.uh	%r11,[%r12]
	ext	datatop+0x0@ah	; 	xld.uh	%r15,[datatop]
	ext	datatop+0x0@al
	ld.uh	%r15,[%r8]
	sub	%r11,%r15
	ext	0x74		; 	xld.h	[%r10+116],%r11
	ld.h	[%r10],%r11
	add	%r13,0x1	; 	xadd	%r13,%r13,1
	ld.w	%r10,%r13
	sll	%r10,0x1	; 	xsll	%r10,1
	add	%r10,%r12
	ld.w	%r15,0x0
	ext	0x74		; 	xld.h	[%r10+116],%r15
	ld.h	[%r10],%r15
	add	%r13,0x1	; 	xadd	%r13,%r13,1
	ext	0x69		; 	xld.b	[%r12+105],%r13
	ld.b	[%r12],%r13
	add	%sp,0x2		; 	xadd	%sp,%sp,8
	ret
	.align	1
SeqNext:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x69		; 	xld.ub	%r10,[%r12+105]
	ld.ub	%r10,[%r12]
	ext	0x3		; 	xsub	%r14,%r10,3
	sub	%r14,%r10
	ld.w	%r10,%r14
	sll	%r10,0x1	; 	xsll	%r10,1
	ld.w	%r13,%r10
	add	%r13,%r12
	ext	0x74		; 	xadd	%r11,%r13,116
	add	%r11,%r13
	ld.uh	%r10,[%r11]	; 	xld.uh	%r10,[%r11]
	sub	%r10,0x1	; 	xsub	%r10,%r10,1
	ld.h	[%r11],%r10	; 	xld.h	[%r11],%r10
	ld.uh	%r10,%r10
	cmp	%r10,0x0
	jreq	__LX147		; 	xjreq	__L147
	ext	datatop+0x0@ah	; 	xld.w	%r10,[datatop]
	ext	datatop+0x0@al
	ld.w	%r10,[%r8]
	ext	0x58		; 	xld.uh	%r11,[%r12+88]
	ld.uh	%r11,[%r12]
	sub	%r11,%r10
	ext	0x78		; 	xld.h	[%r13+120],%r11
	ld.h	[%r13],%r11
	ext	0x76		; 	xld.uh	%r11,[%r13+118]
	ld.uh	%r11,[%r13]
	add	%r10,%r11
	ext	0x58		; 	xld.w	[%r12+88],%r10
	ld.w	[%r12],%r10
	jp	__LX148		; 	xjp	__L148
__LX147:				; __L147:
	ext	0x69		; 	xld.b	[%r12+105],%r14
	ld.b	[%r12],%r14
__LX148:				; __L148:
	ret
	.align	1
SeqBreak:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x69		; 	xld.ub	%r10,[%r12+105]
	ld.ub	%r10,[%r12]
	ext	0x3		; 	xsub	%r13,%r10,3
	sub	%r13,%r10
	ld.w	%r10,%r13
	sll	%r10,0x1	; 	xsll	%r10,1
	ld.w	%r11,%r10
	add	%r11,%r12
	ext	0x74		; 	xld.uh	%r10,[%r11+116]
	ld.uh	%r10,[%r11]
	cmp	%r10,0x1	; 	xcmp	%r10,1
	jrne	__LX150		; 	xjrne	__L150
	ext	0x78		; 	xld.uh	%r11,[%r11+120]
	ld.uh	%r11,[%r11]
	ext	datatop+0x0@ah	; 	xld.w	%r10,[datatop]
	ext	datatop+0x0@al
	ld.w	%r10,[%r8]
	add	%r10,%r11
	ext	0x58		; 	xld.w	[%r12+88],%r10
	ld.w	[%r12],%r10
	ext	0x69		; 	xld.b	[%r12+105],%r13
	ld.b	[%r12],%r13
__LX150:				; __L150:
	ret
	.align	1
SeqTrs:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x58		; 	xld.w	%r11,[%r12+88]
	ld.w	%r11,[%r12]
	ext	0x1		; 	xadd	%r10,%r11,1
	add	%r10,%r11
	ext	0x58		; 	xld.w	[%r12+88],%r10
	ld.w	[%r12],%r10
	ld.ub	%r10,[%r11]	; 	xld.ub	%r10,[%r11]
	ext	0x6c		; 	xld.b	[%r12+108],%r10
	ld.b	[%r12],%r10
	ret
	.align	1
SeqEnv:
;	.frame	%sp,12,$31		# vars= 0, regs= 2/0, args= 4, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	sub	%sp,0x1		; 	xsub	%sp,%sp,4
	ld.w	%r0,%r12
	ext	0x58		; 	xld.w	%r10,[%r0+88]
	ld.w	%r10,[%r0]
	ld.ub	%r13,[%r10]	; 	xld.ub	%r13,[%r10]
	ext	0x1		; 	xld.ub	%r14,[%r10+1]
	ld.ub	%r14,[%r10]
	ext	0x2		; 	xld.ub	%r15,[%r10+2]
	ld.ub	%r15,[%r10]
	ext	0x3		; 	xld.ub	%r10,[%r10+3]
	ld.ub	%r10,[%r10]
	ld.w	[%sp+0x0],%r10	; 	xld.w	[%sp],%r10
	ext	SetEnv@rm	; 	xcall	SetEnv
	call	SetEnv@rl
	ext	0x58		; 	xld.w	%r10,[%r0+88]
	ld.w	%r10,[%r0]
	add	%r10,0x4	; 	xadd	%r10,%r10,4
	ext	0x58		; 	xld.w	[%r0+88],%r10
	ld.w	[%r0],%r10
	add	%sp,0x1		; 	xadd	%sp,%sp,4
	popn	%r0
	ret
	.align	1
SeqVol:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x58		; 	xld.w	%r11,[%r12+88]
	ld.w	%r11,[%r12]
	ext	0x1		; 	xadd	%r10,%r11,1
	add	%r10,%r11
	ext	0x58		; 	xld.w	[%r12+88],%r10
	ld.w	[%r12],%r10
	ld.ub	%r13,[%r11]	; 	xld.ub	%r13,[%r11]
	ext	SetVol@rm	; 	xcall	SetVol
	call	SetVol@rl
	ret
	.align	1
SeqDtn:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x58		; 	xld.w	%r11,[%r12+88]
	ld.w	%r11,[%r12]
	ext	0x1		; 	xadd	%r10,%r11,1
	add	%r10,%r11
	ext	0x58		; 	xld.w	[%r12+88],%r10
	ld.w	[%r12],%r10
	ld.ub	%r10,[%r11]	; 	xld.ub	%r10,[%r11]
	ext	0x6d		; 	xld.b	[%r12+109],%r10
	ld.b	[%r12],%r10
	ret
	.align	1
SeqPortaPara:
;	.frame	%sp,8,$31		# vars= 0, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	ld.w	%r0,%r12
	ext	0x58		; 	xld.w	%r11,[%r0+88]
	ld.w	%r11,[%r0]
	ext	0x1		; 	xadd	%r10,%r11,1
	add	%r10,%r11
	ext	0x58		; 	xld.w	[%r0+88],%r10
	ld.w	[%r0],%r10
	ld.ub	%r10,[%r11]	; 	xld.ub	%r10,[%r11]
	ext	0x6e		; 	xld.b	[%r0+110],%r10
	ld.b	[%r0],%r10
	ext	0x58		; 	xld.w	%r11,[%r0+88]
	ld.w	%r11,[%r0]
	ext	0x1		; 	xadd	%r10,%r11,1
	add	%r10,%r11
	ext	0x58		; 	xld.w	[%r0+88],%r10
	ld.w	[%r0],%r10
	ld.ub	%r11,[%r11]	; 	xld.ub	%r11,[%r11]
	ext	0x3		; 	xld.w	%r10,0x000000c0		; 192
	ld.w	%r10,0x0
	mlt.w	%r11,%r10
	ld.w	%r11,%alr
	ext	0x1		; 	xadd	%r12,%r11,15360
	ext	0x1c00
	add	%r12,%r11
	ext	gexp@rm		; 	xcall	gexp
	call	gexp@rl
	sll	%r10,0x8	; 	xsll	%r10,10
	sll	%r10,0x2
	ext	0x5c		; 	xld.w	[%r0+92],%r10
	ld.w	[%r0],%r10
	ext	tempo+0x0@ah	; 	xld.h	%r11,[tempo]
	ext	tempo+0x0@al
	ld.h	%r11,[%r8]
	mlt.w	%r10,%r11
	ld.w	%r10,%alr
	ext	0x5c		; 	xld.w	[%r0+92],%r10
	ld.w	[%r0],%r10
	ld.w	%r12,%r10
	ext	0x4e		; 	xld.w	%r13,0x00001388		; 5000
	ld.w	%r13,0x8
	ext	__divsi3@rm	; 	xcall	__divsi3
	call	__divsi3@rl
	ext	0x5c		; 	xld.w	[%r0+92],%r10
	ld.w	[%r0],%r10
	popn	%r0
	ret
	.align	1
SeqPortaOn:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x6b		; 	xbset	[%r12+107],0x0
	bset	[%r12],0x0
	ret
	.align	1
SeqPortaOff:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x6b		; 	xld.ub	%r10,[%r12+107]
	ld.ub	%r10,[%r12]
	ext	0x3		; 	xand	%r10,%r10,0x000000fc
	and	%r10,0x3c
	ext	0x6b		; 	xld.b	[%r12+107],%r10
	ld.b	[%r12],%r10
	ld.w	%r11,0x0
	ext	0x1c		; 	xld.w	[%r12+28],%r11
	ld.w	[%r12],%r11
	ret
	.align	1
SeqTatt:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x58		; 	xld.w	%r11,[%r12+88]
	ld.w	%r11,[%r12]
	ext	0x1		; 	xadd	%r10,%r11,1
	add	%r10,%r11
	ext	0x58		; 	xld.w	[%r12+88],%r10
	ld.w	[%r12],%r10
	ld.ub	%r10,[%r11]	; 	xld.ub	%r10,[%r11]
	ext	0x6a		; 	xld.b	[%r12+106],%r10
	ld.b	[%r12],%r10
	ret
	.align	1
SeqVibrato:
;	.frame	%sp,12,$31		# vars= 0, regs= 2/0, args= 4, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	sub	%sp,0x1		; 	xsub	%sp,%sp,4
	ld.w	%r0,%r12
	ext	0x58		; 	xld.w	%r10,[%r0+88]
	ld.w	%r10,[%r0]
	ld.ub	%r13,[%r10]	; 	xld.ub	%r13,[%r10]
	ext	0x1		; 	xld.ub	%r14,[%r10+1]
	ld.ub	%r14,[%r10]
	ext	0x2		; 	xld.ub	%r15,[%r10+2]
	ld.ub	%r15,[%r10]
	ext	0x3		; 	xld.ub	%r10,[%r10+3]
	ld.ub	%r10,[%r10]
	ld.w	[%sp+0x0],%r10	; 	xld.w	[%sp],%r10
	ext	SetVib@rm	; 	xcall	SetVib
	call	SetVib@rl
	ext	0x58		; 	xld.w	%r10,[%r0+88]
	ld.w	%r10,[%r0]
	add	%r10,0x4	; 	xadd	%r10,%r10,4
	ext	0x58		; 	xld.w	[%r0+88],%r10
	ld.w	[%r0],%r10
	add	%sp,0x1		; 	xadd	%sp,%sp,4
	popn	%r0
	ret
	.align	1
SeqLegOn:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x6b		; 	xld.ub	%r10,[%r12+107]
	ld.ub	%r10,[%r12]
	or	%r10,0xc	; 	xoor	%r10,%r10,0x0000000c
	ext	0x6b		; 	xld.b	[%r12+107],%r10
	ld.b	[%r12],%r10
	ret
	.align	1
SeqLegOff:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x6b		; 	xbclr	[%r12+107],0x2
	bclr	[%r12],0x2
	ret
	.align	1
SeqExp:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x58		; 	xld.w	%r11,[%r12+88]
	ld.w	%r11,[%r12]
	ext	0x1		; 	xadd	%r10,%r11,1
	add	%r10,%r11
	ext	0x58		; 	xld.w	[%r12+88],%r10
	ld.w	[%r12],%r10
	ld.ub	%r13,[%r11]	; 	xld.ub	%r13,[%r11]
	ext	SetExp@rm	; 	xcall	SetExp
	call	SetExp@rl
	ret
	.align	1
SeqExpRel:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ext	0x58		; 	xld.w	%r11,[%r12+88]
	ld.w	%r11,[%r12]
	ext	0x1		; 	xadd	%r10,%r11,1
	add	%r10,%r11
	ext	0x58		; 	xld.w	[%r12+88],%r10
	ld.w	[%r12],%r10
	ld.b	%r13,[%r11]	; 	xld.b	%r13,[%r11]
	ext	SetExpRel@rm	; 	xcall	SetExpRel
	call	SetExpRel@rl
	ret
	.code
	.align	2
SeqCmd:
	.word	SeqRest
	.word	SeqGate
	.word	SeqJump
	.word	SeqCall
	.word	SeqRept
	.word	SeqNext
	.word	SeqTrs
	.word	SeqTempo
	.word	SeqInst
	.word	SeqVol
	.word	SeqEnv
	.word	SeqDtn
	.word	SeqNote2
	.word	SeqPortaPara
	.word	SeqPortaOn
	.word	SeqPortaOff
	.word	SeqTatt
	.word	SeqVibrato
	.word	SeqNop1
	.word	SeqNop2
	.word	SeqNop2
	.word	SeqNop2
	.word	SeqBreak
	.word	SeqNop
	.word	SeqLegOn
	.word	SeqLegOff
	.word	SeqExp
	.word	SeqExpRel
	.word	SeqNop
	.word	SeqNop
	.word	SeqNop
	.word	SeqNop
	.code
	.align	1
ProcSeq:
;	.frame	%sp,20,$31		# vars= 0, regs= 5/0, args= 0, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	ld.w	%r1,0x0
__LX168:				; __L168:
	ext	0x2		; 	xld.w	%r10,0x000000a4		; 164
	ld.w	%r10,0x24
	mlt.w	%r1,%r10
	ext	seqwk+0x0@h	; 	xld.w	%r10,seqwk
	ext	seqwk+0x0@m
	ld.w	%r10,seqwk+0x0@l
	ld.w	%r12,%alr
	add	%r12,%r10
	ext	0x68		; 	xld.ub	%r10,[%r12+104]
	ld.ub	%r10,[%r12]
	cmp	%r10,0x0
	jreq	__LX167		; 	xjreq	__L167
	ext	0x6b		; 	xbtst	[%r12+107],0x1
	btst	[%r12],0x1
	jreq	__LX167		; 	xjreq	__L167
	ext	0x70		; 	xld.w	%r10,[%r12+112]
	ld.w	%r10,[%r12]
	call	%r10
__LX167:				; __L167:
	add	%r1,0x1		; 	xadd	%r1,%r1,1
	cmp	%r1,0x5		; 	xcmp	%r1,5
	jrle	__LX168		; 	xjrle	__L168
	ext	tempowk+0x0@ah	; 	xld.uh	%r11,[tempowk]
	ext	tempowk+0x0@al
	ld.uh	%r11,[%r8]
	ext	tempo+0x0@ah	; 	xld.uh	%r14,[tempo]
	ext	tempo+0x0@al
	ld.uh	%r14,[%r8]
	sub	%r11,%r14
	ld.w	%r10,%r11
	ext	tempowk+0x0@ah	; 	xld.h	[tempowk],%r10
	ext	tempowk+0x0@al
	ld.h	[%r8],%r10
	ld.h	%r10,%r10
	cmp	%r10,0x0
	jrge	__LX164		; 	xjrge	__L164
	ext	0x1388		; 	xadd	%r10,%r11,5000
	add	%r10,%r11
	ext	tempowk+0x0@ah	; 	xld.h	[tempowk],%r10
	ext	tempowk+0x0@al
	ld.h	[%r8],%r10
	ld.w	%r14,0x0
	ext	runf+0x0@ah	; 	xld.b	[runf],%r14
	ext	runf+0x0@al
	ld.b	[%r8],%r14
	ld.w	%r1,0x0
	ld.w	%r3,0x1		; 	xld.w	%r3,0x00000001		; 1
	ext	0x1		; 	xld.w	%r2,0x0000007f		; 127
	ld.w	%r2,0x3f
__LX176:				; __L176:
	ext	0x2		; 	xld.w	%r10,0x000000a4		; 164
	ld.w	%r10,0x24
	mlt.w	%r1,%r10
	ext	seqwk+0x0@h	; 	xld.w	%r10,seqwk
	ext	seqwk+0x0@m
	ld.w	%r10,seqwk+0x0@l
	ld.w	%r0,%alr
	add	%r0,%r10
	ext	0x68		; 	xld.ub	%r10,[%r0+104]
	ld.ub	%r10,[%r0]
	cmp	%r10,0x0
	jreq	__LX175		; 	xjreq	__L175
	ext	runf+0x0@ah	; 	xld.b	[runf],%r3
	ext	runf+0x0@al
	ld.b	[%r8],%r3
	ext	0x60		; 	xld.uh	%r10,[%r0+96]
	ld.uh	%r10,[%r0]
	sub	%r10,0x1	; 	xsub	%r10,%r10,1
	ext	0x60		; 	xld.h	[%r0+96],%r10
	ld.h	[%r0],%r10
	ld.h	%r11,%r10
	cmp	%r11,0x0
	jrgt	__LX178		; 	xjrgt	__L178
__LX179:				; __L179:
	ext	0x58		; 	xld.w	%r10,[%r0+88]
	ld.w	%r10,[%r0]
	ext	0x1		; 	xadd	%r11,%r10,1
	add	%r11,%r10
	ext	0x58		; 	xld.w	[%r0+88],%r11
	ld.w	[%r0],%r11
	ld.ub	%r13,[%r10]	; 	xld.ub	%r13,[%r10]
	cmp	%r13,0x0
	jrne	__LX182		; 	xjrne	__L182
	ld.w	%r12,%r0
	ext	SeqEnd@rm	; 	xcall	SeqEnd
	call	SeqEnd@rl
	ext	0x68		; 	xld.ub	%r10,[%r0+104]
	ld.ub	%r10,[%r0]
	cmp	%r10,0x0
	jreq	__LX175		; 	xjreq	__L175
	jp	__LX181		; 	xjp	__L181
__LX182:				; __L182:
	cmp	%r13,%r2
	jrgt	__LX185		; 	xjrgt	__L185
	jrne	__LX186		; 	xjrne	__L186
	add	%r10,0x2	; 	xadd	%r10,%r10,2
	ext	0x58		; 	xld.w	[%r0+88],%r10
	ld.w	[%r0],%r10
	ld.ub	%r13,[%r11]	; 	xld.ub	%r13,[%r11]
	ext	0x1		; 	xcmp	%r13,126
	cmp	%r13,0x3e
	jrgt	__LX186		; 	xjrgt	__L186
	ext	0x4		; 	xadd	%r13,%r13,256
	add	%r13,0x0
__LX186:				; __L186:
	ext	0x62		; 	xld.h	[%r0+98],%r13
	ld.h	[%r0],%r13
	jp	__LX181		; 	xjp	__L181
__LX185:				; __L185:
	ext	0x3		; 	xcmp	%r13,223
	cmp	%r13,0x1f
	jrgt	__LX189		; 	xjrgt	__L189
	ext	0x6a		; 	xbtst	[%r0+106],0x0
	btst	[%r0],0x0
	jreq	__LX190		; 	xjreq	__L190
	ld.w	%r12,%r0
	ext	0x2		; 	xsub	%r13,%r13,128
	sub	%r13,0x0
	ext	SeqDrums@rm	; 	xcall	SeqDrums
	call	SeqDrums@rl
	jp	__LX181		; 	xjp	__L181
__LX190:				; __L190:
	ld.w	%r12,%r0
	ext	0x1		; 	xsub	%r13,%r13,116
	sub	%r13,0x34
	ext	SeqNote@rm	; 	xcall	SeqNote
	call	SeqNote@rl
	jp	__LX181		; 	xjp	__L181
__LX189:				; __L189:
	ld.w	%r10,%r13
	sll	%r10,0x2	; 	xsll	%r10,2
	ext	SeqCmd-0x380@h	; 	xld.w	%r10,[%r10+SeqCmd-896]
	ext	SeqCmd-0x380@m
	ld.w	%r9,SeqCmd-0x380@l
	add	%r9,%r10
	ld.w	%r10,[%r9]
	ld.w	%r12,%r0
	call	%r10
__LX181:				; __L181:
	ext	0x60		; 	xld.h	%r10,[%r0+96]
	ld.h	%r10,[%r0]
	cmp	%r10,0x0
	jrle	__LX179		; 	xjrle	__L179
	jp	__LX175		; 	xjp	__L175
__LX178:				; __L178:
	ext	0x68		; 	xld.ub	%r10,[%r0+104]
	ld.ub	%r10,[%r0]
	cmp	%r10,0x2	; 	xcmp	%r10,2
	jrne	__LX175		; 	xjrne	__L175
	ext	0x64		; 	xld.h	%r10,[%r0+100]
	ld.h	%r10,[%r0]
	cmp	%r11,%r10
	jrgt	__LX175		; 	xjrgt	__L175
	ext	0x6b		; 	xbtst	[%r0+107],0x2
	btst	[%r0],0x2
	jrne	__LX175		; 	xjrne	__L175
	ld.w	%r12,%r0
	ext	NoteOff@rm	; 	xcall	NoteOff
	call	NoteOff@rl
	ext	0x68		; 	xld.b	[%r0+104],%r3
	ld.b	[%r0],%r3
__LX175:				; __L175:
	add	%r1,0x1		; 	xadd	%r1,%r1,1
	cmp	%r1,0x5		; 	xcmp	%r1,5
	jrle	__LX176		; 	xjrle	__L176
__LX164:				; __L164:
	popn	%r3
	ret
; APP
	
		.code
		.align		1
		.global		BuffFree_Mix2
BuffFree_Mix2:
		;//-------------------------------------------------------------;//
		;//%r12 = wbuff
		;//%r13 = mixbuf
	ext	0x2		; 		xld.w		%r4, 128					;//%r4     := i = BLKS
	ld.w	%r4,0x0
	ext	0x1ff		; 		xld.w		%r5, 32767					;//%r5     := SHRT_MAX
	ld.w	%r5,0x3f
		not		%r6, %r5					;//%r6     := SHRT_MIN
BuffFree_Mix2_L1:								;//do {
		ld.w		%r7, [%r13]+					;//%r7     := x  =  *mixbuf++
		sla		%r7, 2						;//%r7     := x <<= 2			//EhlX()
		cmp		%r7, %r5					;//%psr    := x <=> SHRT_MAX
		jrle.d		3						;//if(        x   > SHRT_MAX) {
		 cmp		%r7, %r6					;//%psr    := x <=> SHRT_MIN				*delay*
		 ld.w		%r7, %r5					;//  %r7   := x  =  SHRT_MAX  }		@
		jrge.d		3						;//if(        x <   SHRT_MIN) {		
		 sub		%r4, 1						;//%r4     := i--					*delay*
		 ld.w		%r7, %r6					;//  %r7   := x  =  SHRT_MIN  }		@
		ld.h		[%r12]+, %r7					;//*wbuff++ = x				@
		jrne		BuffFree_Mix2_L1				;//} while(   i)			
		;//-------------------------------------------------------------;//
		ret

; NO_APP
	.align	1
BuffFree:
;	.frame	%sp,528,$31		# vars= 512, regs= 4/0, args= 0, extra= 0
;	.mask	0x80070000,-4
;	.fmask	0x00000000,0
	pushn	%r2
	sub	%sp,0x80	; 	xsub	%sp,%sp,512
	ld.w	%r2,%r12
	ld.w	%r12,%sp
	ld.w	%r13,0x0
	ext	0x8		; 	xld.w	%r14,0x00000200		; 512
	ld.w	%r14,0x0
	ext	memset@rm	; 	xcall	memset
	call	memset@rl
	ext	ProcSeq@rm	; 	xcall	ProcSeq
	call	ProcSeq@rl
	ld.w	%r1,0x0
__LX201:				; __L201:
	ext	0x2		; 	xld.w	%r10,0x000000a4		; 164
	ld.w	%r10,0x24
	mlt.w	%r1,%r10
	ext	seqwk+0x0@h	; 	xld.w	%r10,seqwk
	ext	seqwk+0x0@m
	ld.w	%r10,seqwk+0x0@l
	ld.w	%r12,%alr
	add	%r12,%r10
	ext	0x68		; 	xld.ub	%r10,[%r12+104]
	ld.ub	%r10,[%r12]
	cmp	%r10,0x0
	jreq	__LX200		; 	xjreq	__L200
	ld.w	%r0,%r12
	ext	0x4		; 	xld.w	%r10,[%r0+4]
	ld.w	%r10,[%r0]
	cmp	%r10,0x0
	jreq	__LX200		; 	xjreq	__L200
	ext	0x54		; 	xld.w	%r10,[%r0+84]
	ld.w	%r10,[%r0]
	call	%r10
	ext	0x1c		; 	xld.w	%r10,[%r0+28]
	ld.w	%r10,[%r0]
	sra	%r10,0x8	; 	xsra	%r10,10
	sra	%r10,0x2
	ext	0x18		; 	xld.w	%r11,[%r0+24]
	ld.w	%r11,[%r0]
	add	%r11,%r10
	ext	0x20		; 	xld.w	%r12,[%r0+32]
	ld.w	%r12,[%r0]
	sra	%r12,0x8	; 	xsra	%r12,14
	sra	%r12,0x6
	add	%r11,%r12
	ld.w	%r12,%r11
	ext	gexp@rm		; 	xcall	gexp
	call	gexp@rl
	ext	0x4		; 	xld.w	[%r0+4],%r10
	ld.w	[%r0],%r10
	ext	0x50		; 	xld.w	%r10,[%r0+80]
	ld.w	%r10,[%r0]
	ld.w	%r12,%r0
	call	%r10
	ext	0x38		; 	xld.w	%r11,[%r0+56]
	ld.w	%r11,[%r0]
	ext	0x3c		; 	xld.w	%r10,[%r0+60]
	ld.w	%r10,[%r0]
	add	%r11,%r10
	ext	0x24		; 	xld.w	%r10,[%r0+36]
	ld.w	%r10,[%r0]
	ld.w	%r14,%r11
	add	%r14,%r10
	cmp	%r14,0xb	; 	xcmp	%r14,11
	jrgt	__LX204		; 	xjrgt	__L204
	ld.w	%r14,0x0
	jp	__LX205		; 	xjp	__L205
__LX204:				; __L204:
	ld.w	%r12,%r14
	ext	gexp@rm		; 	xcall	gexp
	call	gexp@rl
	ld.w	%r14,%r10
__LX205:				; __L205:
	ext	0x4c		; 	xld.w	%r10,[%r0+76]
	ld.w	%r10,[%r0]
	ld.w	%r12,%r0
	ld.w	%r13,%sp
	ext	0x2		; 	xld.w	%r15,0x00000080		; 128
	ld.w	%r15,0x0
	call	%r10
__LX200:				; __L200:
	add	%r1,0x1		; 	xadd	%r1,%r1,1
	cmp	%r1,0x5		; 	xcmp	%r1,5
	jrle	__LX201		; 	xjrle	__L201
	ext	0x4		; 	xld.w	%r12,[%r2+4]
	ld.w	%r12,[%r2]
	ld.w	%r13,%sp
	call	BuffFree_Mix2	; 	xcall	BuffFree_Mix2
	add	%sp,0x80	; 	xadd	%sp,%sp,512
	popn	%r2
	ret
	.align	1
	.global	InitMusic
InitMusic:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r12,0x0
	ld.w	%r15,0x14	; 	xld.w	%r15,0x00000014		; 20
	ext	waveinfo+0x0@h	; 	xld.w	%r14,waveinfo
	ext	waveinfo+0x0@m
	ld.w	%r14,waveinfo+0x0@l
	ld.w	%r4,0x1		; 	xld.w	%r4,0x00000001		; 1
__LX211:				; __L211:
	mlt.w	%r12,%r15
	ld.w	%r13,%alr
	add	%r13,%r14
	ext	0x1		; 	xld.b	[%r13+1],%r4
	ld.b	[%r13],%r4
	ld.w	%r10,%r12
	sll	%r10,0x8	; 	xsll	%r10,8
	ext	wavebuff+0x0@h	; 	xld.w	%r11,wavebuff
	ext	wavebuff+0x0@m
	ld.w	%r11,wavebuff+0x0@l
	add	%r10,%r11
	ext	0x4		; 	xld.w	[%r13+4],%r10
	ld.w	[%r13],%r10
	ext	0x2		; 	xld.w	%r10,0x00000080		; 128
	ld.w	%r10,0x0
	ext	0x8		; 	xld.w	[%r13+8],%r10
	ld.w	[%r13],%r10
	ext	0x1		; 	xadd	%r11,%r12,1
	add	%r11,%r12
	ld.w	%r10,%r11
	jrge	__LX212		; 	xjrge	__L212
	ext	0x4		; 	xadd	%r10,%r12,4
	add	%r10,%r12
__LX212:				; __L212:
	and	%r10,0x3c	; 	xand	%r10,%r10,0xfffffffc
	ld.w	%r5,%r11
	sub	%r5,%r10
	ld.w	%r10,%r5
	mlt.w	%r10,%r15
	ld.w	%r10,%alr
	add	%r10,%r14
	ext	0xc		; 	xld.w	[%r13+12],%r10
	ld.w	[%r13],%r10
	ext	BuffFree+0x0@h	; 	xld.w	%r10,BuffFree
	ext	BuffFree+0x0@m
	ld.w	%r10,BuffFree+0x0@l
	ext	0x10		; 	xld.w	[%r13+16],%r10
	ld.w	[%r13],%r10
	ld.w	%r12,%r11
	cmp	%r12,0x3	; 	xcmp	%r12,3
	jrle	__LX211		; 	xjrle	__L211
	ret
	.align	1
	.global	PlayMusic
PlayMusic:
;	.frame	%sp,12,$31		# vars= 4, regs= 2/0, args= 0, extra= 0
;	.mask	0x80010000,-4
;	.fmask	0x00000000,0
	pushn	%r0
	sub	%sp,0x1		; 	xsub	%sp,%sp,4
	ld.w	%r0,%r12
	ld.w	%r12,%sp
	ext	pceSyncEnterCriticalSection@rm	; 	xcall	pceSyncEnterCriticalSection
	call	pceSyncEnterCriticalSection@rl
	call	StopMusic	; 	xcall	StopMusic
	ld.w	%r12,%r0
	ext	StartSeq@rm	; 	xcall	StartSeq
	call	StartSeq@rl
	ext	music_wch+0x0@ah	; 	xld.ub	%r12,[music_wch]
	ext	music_wch+0x0@al
	ld.ub	%r12,[%r8]
	ext	waveinfo+0x0@h	; 	xld.w	%r13,waveinfo
	ext	waveinfo+0x0@m
	ld.w	%r13,waveinfo+0x0@l
	ext	pceWaveDataOut@rm	; 	xcall	pceWaveDataOut
	call	pceWaveDataOut@rl
	ext	music_wch+0x0@ah	; 	xld.ub	%r10,[music_wch]
	ext	music_wch+0x0@al
	ld.ub	%r10,[%r8]
	ext	using_wch+0x0@ah	; 	xld.b	[using_wch],%r10
	ext	using_wch+0x0@al
	ld.b	[%r8],%r10
	ld.w	%r12,%sp
	ext	pceSyncLeaveCriticalSection@rm	; 	xcall	pceSyncLeaveCriticalSection
	call	pceSyncLeaveCriticalSection@rl
	add	%sp,0x1		; 	xadd	%sp,%sp,4
	popn	%r0
	ret
	.align	1
	.global	StopMusic
StopMusic:
;	.frame	%sp,8,$31		# vars= 4, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	sub	%sp,0x1		; 	xsub	%sp,%sp,4
	ld.w	%r12,%sp
	ext	pceSyncEnterCriticalSection@rm	; 	xcall	pceSyncEnterCriticalSection
	call	pceSyncEnterCriticalSection@rl
	ext	using_wch+0x0@ah	; 	xld.b	%r12,[using_wch]
	ext	using_wch+0x0@al
	ld.b	%r12,[%r8]
	cmp	%r12,0x0
	jrlt	__LX223		; 	xjrlt	__L223
	ext	pceWaveAbort@rm	; 	xcall	pceWaveAbort
	call	pceWaveAbort@rl
	ld.w	%r10,0x3f	; 	xld.w	%r10,-1			; 0xffffffff
	ext	using_wch+0x0@ah	; 	xld.b	[using_wch],%r10
	ext	using_wch+0x0@al
	ld.b	[%r8],%r10
__LX223:				; __L223:
	ext	seqwk+0x0@h	; 	xld.w	%r12,seqwk
	ext	seqwk+0x0@m
	ld.w	%r12,seqwk+0x0@l
	ld.w	%r13,0x0
	ext	0xf		; 	xld.w	%r14,0x000003d8		; 984
	ld.w	%r14,0x18
	ext	memset@rm	; 	xcall	memset
	call	memset@rl
	ld.w	%r11,0x0
	ext	runf+0x0@ah	; 	xld.b	[runf],%r11
	ext	runf+0x0@al
	ld.b	[%r8],%r11
	ld.w	%r12,%sp
	ext	pceSyncLeaveCriticalSection@rm	; 	xcall	pceSyncLeaveCriticalSection
	call	pceSyncLeaveCriticalSection@rl
	add	%sp,0x1		; 	xadd	%sp,%sp,4
	ret
	.align	1
	.global	MusicCheck
MusicCheck:
;	.frame	%sp,4,$31		# vars= 0, regs= 1/0, args= 0, extra= 0
;	.mask	0x80000000,-4
;	.fmask	0x00000000,0
	ld.w	%r11,0x0
	ext	runf+0x0@ah	; 	xld.b	%r10,[runf]
	ext	runf+0x0@al
	ld.b	%r10,[%r8]
	cmp	%r10,0x0
	jrne	__LX226		; 	xjrne	__L226
	ld.w	%r11,0x1	; 	xld.w	%r11,0x00000001		; 1
__LX226:				; __L226:
	ld.w	%r10,%r11
	ret

	.lcomm	datatop 4

	.lcomm	drumsbase 4

	.lcomm	tempo 2

	.lcomm	tempowk 2

	.lcomm	runf 1

	.lcomm	seqwk 984

	.lcomm	waveinfo 80

	.lcomm	wavebuff 1024

