/*	
 *	clipmp3r.h
 *
 *	P/ECE MP3 Driver (TEST PROGRAM)
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2003 Naoyuki Sawa
 *
 *	* Tue Nov 05 06:00:00 JST 2003 Naoyuki Sawa
 *	- 쐬Jn
 */
#ifndef __CLIP_MP3R_H__
#define __CLIP_MP3R_H__

/****************************************************************************
 *	tʎq
 ****************************************************************************/

void mp3r_requantize_long(const MP3FRAMEHEADER* frame, const MP3GRANULEINFO* granule, const MP3SCALEFACTOR* scale, const short* in/*[MP3_SUBBAND_COUNT][MP3_SUBBAND_SIZE]*/, double* out/*[MP3_SUBBAND_COUNT][MP3_SUBBAND_SIZE]*/, int count);
void mp3r_requantize_short(const MP3FRAMEHEADER* frame, const MP3GRANULEINFO* granule, const MP3SCALEFACTOR* scale, const short* in/*[MP3_SUBBAND_COUNT][MP3_SUBBAND_SIZE]*/, double* out/*[MP3_SUBBAND_COUNT][MP3_SUBBAND_SIZE]*/);
//TODO: void mp3r_requantize_mixed(const MP3FRAMEHEADER* frame, const MP3GRANULEINFO* granule, const MP3SCALEFACTOR* scale, const short* in/*[MP3_SUBBAND_COUNT][MP3_SUBBAND_SIZE]*/, double* out/*[MP3_SUBBAND_COUNT][MP3_SUBBAND_SIZE]*/);

/****************************************************************************
 *	GAVO팸
 ****************************************************************************/

void mp3r_antialias(double* in_out, int subband_count);

/****************************************************************************
 *	IMDCT
 ****************************************************************************/

void mp3r_imdct_long(const double* in/*[MP3_SUBBAND_COUNT][MP3_SUBBAND_SIZE]*/, double* out/*[MP3_SUBBAND_SIZE][MP3_SUBBAND_COUNT]*/, double* save/*[MP3_SUBBAND_COUNT][MP3_SUBBAND_SIZE]*/, int subband_count);
void mp3r_imdct_short(const double* in/*[MP3_SUBBAND_COUNT][MP3_SUBBAND_SIZE]*/, double* out/*[MP3_SUBBAND_SIZE][MP3_SUBBAND_COUNT]*/, double* save/*[MP3_SUBBAND_COUNT][MP3_SUBBAND_SIZE]*/);
//TODO: void mp3r_imdct_mixed(const double* in/*[MP3_SUBBAND_COUNT][MP3_SUBBAND_SIZE]*/, double* out/*[MP3_SUBBAND_SIZE][MP3_SUBBAND_COUNT]*/, double* save/*[MP3_SUBBAND_COUNT][MP3_SUBBAND_SIZE]*/);

/****************************************************************************
 *	Tuoh
 ****************************************************************************/

int mp3r_subband_synthesys(const double* in/*[MP3_SUBBAND_SIZE][MP3_SUBBAND_COUNT]*/, short* out/*[upto MP3_GRANULE_SIZE]*/, double* save/*[16][MP3_SUBBAND_COUNT_2]*/, int offset, const MP3SAMPLINGFREQUENCYCONVERTTABLE* convert);

/****************************************************************************
 *	MP3hCo
 ****************************************************************************/

typedef struct _MP3RDRIVER {
	const unsigned char* pos;
	const unsigned char* end;
	/* TvOgϊpobt@ */
	int sampling_frequency;					/* fbufff[^̃TvOg */
	int c_fbuff;						/* fbufff[^ */
	int i_fbuff;						/* TvOgϊpDDAp^ */
	int e_fbuff;						/* TvOgϊpDDAp^ */
	short fbuff[MP3_FRAME_SIZE];
	/* t[ԂŕۑKv̂obt@ */
	unsigned char main_save[4096];				/* Cf[^̃rbg~ϗpB_4096+1441oCg܂ŗL蓾܂Aۂ4KBΏ[͂łB */
	int main_save_size;					/* () */
	double imdct_save[MP3_GRANULE_SIZE];			/* IMDCTp */
	double subband_synthesys_save[16][MP3_SUBBAND_COUNT_2];	/* Tuohp */
	int subband_synthesys_offset;				/* () */
} MP3RDRIVER;

int mp3r_init(MP3RDRIVER* mp3, const void* data, int len);
int mp3r_decode_frame(MP3RDRIVER* mp3);

#endif /*__CLIP_MP3R_H__*/

