/*
 *	joytoy.h
 *
 *	JoyToyC^v^
 *
 *	* Sun Jan 01 00:00:00 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 *	* Tue Jan 31 00:00:00 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 *	* Tue Nov 07 13:20:17 JST 2006 Naoyuki Sawa
 *	- SW[ɂāAclipmisc.hARRAYLISTOύXɒǏ]܂B
 */
#ifndef __JOYTOY_H__
#define __JOYTOY_H__

/*****************************************************************************
 *	
 *****************************************************************************/

/* NOTE: INTERFACE_MAP[]̒`AstaticzłȂO[ozƂĂ闝R:
 *
 *	Visual C++ 6.0́AstaticzOQƂ邽߂́Az錾ł܂B
 *
 *		<> --- GCCOKAVisual C++ 6.0̓G[ ---
 *			static int array[]; // 錾
 *			void foo() {
 *				// array[]g
 *			}
 *			static int array[] = { ... }; // `
 *
 *	̃R[h́AP/ECEJGCCȂΖȂRpCł̂łA
 *	Visual C++ 6.0ł́AG[ɂȂĂ܂܂B
 *
 *	Visual C++ 6.0ŁAstaticz錾sɂ́A錾"static"w肹A
 *	`ɂ̂"static"w肷Ηǂ݂łB()
 *
 *		<> --- Visual C++ 6.0OKAGCC̓G[ ---
 *			int array[]; // 錾
 *			void foo() {
 *				// array[]g
 *			}
 *			static int array[] = { ... }; // `
 *
 *	A̕@́AGCCŃG[ɂȂĂ܂܂B
 *
 *	ǁAVisual C++ 6,0GCĆÃRpCŃRpC邽߂ɂ́A
 *	staticzłȂAO[ozp@݂łB
 *
 *		<> --- GCCAVisual C++ 6.0AǂłOK ---
 *			extern int array[]; // 錾
 *			void foo() {
 *				// array[]g
 *			}
 *			int array[] = { ... }; // `
 */
#define IMPLEMENT_UNKNOWN_INTERFACE_METHODS(CC, cc, II, ii)		\
static void* ii##_query_interface(II##_INTERFACE** intf, int id) {	\
	CC##* this = CONTAINING_RECORD(intf, CC, ii##_interface);	\
	          extern const INTERFACE_MAP cc##_interface_map[];	\
	return query_interface_map(this, id, cc##_interface_map);	\
}									\
static void ii##_addref(II##_INTERFACE** intf) {			\
	CC##* this = CONTAINING_RECORD(intf, CC, ii##_interface);	\
	this->refcnt++;							\
}									\
static void ii##_release(II##_INTERFACE** intf) {			\
	CC##* this = CONTAINING_RECORD(intf, CC, ii##_interface);	\
	if(!--this->refcnt) { static void cc##_delete(CC* this);	\
	                                  cc##_delete(    this); }	\
}

/* XgƁA}bv̂Agppx̍̂AʂŒ`邱Ƃɂ܂B
 * gppx̒Ⴂ̂́A̓sxA`ĂB
 */
extern const LIST_INFO ptr_list_info;			/* LIST<void*> */
extern const LIST_INFO jtcode_list_info;		/* LIST<JTCODE_INTERFACE**> */
extern const LIST_INFO jtsymbol_list_info;		/* LIST<JTSYMBOL_INTERFACE**> */
extern const MAP_INFO str_to_int_map_info;		/* MAP<char*,int> */
extern const MAP_INFO jtsymbol_to_jtcode_map_info;	/* MAP<JTSYMBOL_INTERFACE**,JTCODE_INTERFACE**> */

/*****************************************************************************
 *	STRING_BUFFER
 *****************************************************************************/

/* ύX\ȕ\C^[tFCXłB
 */
DEFINE_INTERFACE(STRING_BUFFER_INTERFACE, 1134015322/*2005/12/08 13:15:22*/,

	/* obt@̕ɂ܂B
	 */
	void (*empty)(STRING_BUFFER_INTERFACE** intf);

	/* obt@ɕǉ܂B
	 * [in]
	 *	str		ǉ镶B
	 */
	void (*append_char)(STRING_BUFFER_INTERFACE** intf, int c);

	/* obt@ɕǉ܂B
	 * [in]
	 *	str		ǉ镶B
	 */
	void (*append_string)(STRING_BUFFER_INTERFACE** intf, const char* str);

	/* obt@̒ڑJn܂B
	 * [in]
	 *	min_len		obt@̍ŏ̒()BI[(nul)͊܂݂܂B
	 * [out]
	 *	߂l		obt@ւ̃|C^B
	 * [note]
	 *	* ݂̕񒷂min_len̑召ɂAȉ̂悤ȓs܂B
	 *	- ݂̕񒷂min_lenȏ̏ꍇ́A݂̕obt@̂܂ܕԂ܂B
	 *	- ݂̕񒷂min_len̏ꍇ́Aobt@(min_len+1)Ɋg܂B
	 *	  ̌AĂяoɁAgobt@Ԃ܂B
	 *	  gobt@̐擪́A(݂̕e+'\0')ێĂ܂B
	 *	* obt@̒ڑ삪Aunlock()ĂяoĕύXm肵ĂB
	 *	  obt@̓eύXȂꍇɌAunlock()̌Ăяoȗł܂B
	 *	  obt@̎QƂ̂߂ɖ{֐Ăяoꍇ́Amin_len=0ƂĂB
	 */
	char* (*lock)(STRING_BUFFER_INTERFACE** intf, int min_len);

	/* obt@̒ڑI܂B
	 * [in]
	 *	new_len		obt@̒̕()BI[(nul)͊܂݂܂B
	 *			nulŏIꍇ́A-1w肷ƁAۂ̒p܂B
	 * [note]
	 *	* obt@̕nulŏIȂꍇ́Anew_len𖾎Kv܂B
	 *	* unlock()ĂяoƁAOlock()œ|C^ɂȂ܂B
	 */
	void (*unlock)(STRING_BUFFER_INTERFACE** intf, int new_len);
);

#define IMPLEMENT_STRING_BUFFER_INTERFACE(CC, cc)						\
IMPLEMENT_UNKNOWN_INTERFACE_METHODS(CC, cc, STRING_BUFFER, string_buffer)			\
static void string_buffer_empty(STRING_BUFFER_INTERFACE** intf);				\
static void string_buffer_append_char(STRING_BUFFER_INTERFACE** intf, int c);			\
static void string_buffer_append_string(STRING_BUFFER_INTERFACE** intf, const char* str);	\
static char* string_buffer_lock(STRING_BUFFER_INTERFACE** intf, int min_len);			\
static void string_buffer_unlock(STRING_BUFFER_INTERFACE** intf, int new_len);			\
static STRING_BUFFER_INTERFACE string_buffer_interface = {					\
	string_buffer_query_interface,								\
	string_buffer_addref,									\
	string_buffer_release,									\
	string_buffer_empty,									\
	string_buffer_append_char,								\
	string_buffer_append_string,								\
	string_buffer_lock,									\
	string_buffer_unlock,									\
};

/*--------------------------------------------------------------------------*/

/* obt@IuWFNg쐬܂B
 * [note]
 *	* obt@IuWFNg̏Ԃ́A̕łB
 */
STRING_BUFFER_INTERFACE** string_buffer_create();

/*****************************************************************************
 *	JTCODE
 *****************************************************************************/

/* \͊(Parser)ǂݍށAR[h\C^[tFCXłB
 */
DEFINE_INTERFACE(JTCODE_INTERFACE, 1133690556/*2005/12/04 19:02:36*/,

	/* R[hs܂B
	 * [out]
	 *	߂l		R[h̎sʂ\lB
	 *			sʂ̖R[h́ANULLԂꍇ܂B
	 * [note]
	 *	* C^v^̓́ATˁAȉ̂悤ɂȂ܂B
	 *	  1 . ParservÖꕔǂݍ݁A̕ɑΉR[h쐬B
	 *	  2a. ʓIȕ̏ꍇ́Aɂ̃R[hsB
	 *	  2b. ܂́Aif()while()BodyɑR[h̏ꍇ́Aɏ]ĎsB
	 *	  2c. ܂́A֐BodyɑR[h̏ꍇ́A֐Ă΂ꂽƂɎsB
	 */
	JTCODE_INTERFACE** (*run)(JTCODE_INTERFACE** intf);
);

#define IMPLEMENT_JTCODE_INTERFACE(CC, cc)			\
IMPLEMENT_UNKNOWN_INTERFACE_METHODS(CC, cc, JTCODE, jtcode)	\
static JTCODE_INTERFACE** jtcode_run(JTCODE_INTERFACE** intf);	\
static JTCODE_INTERFACE jtcode_interface = {			\
	jtcode_query_interface,					\
	jtcode_addref,						\
	jtcode_release,						\
	jtcode_run,						\
};

/*****************************************************************************
 *	TOKEN
 *****************************************************************************/

/* TOKEN_INTERFACE::get_type()ŕԂAg[Ñ^Cv\lłB
 * - \V{e[úAjoytoy.c̒init_reserved()ō쐬Ă܂B
 */
enum {
	/* 0`255 */		/* a,+,<,etc...	code = NULL, type = R[h */
	/*    256 */		/* () */
	TOKEN_TYPE_INT = 257,	/* 123		code = jtint_create() */
	TOKEN_TYPE_STRING,	/* "abc"	code = jtstring_create() */
	TOKEN_TYPE_SYMBOL,	/* abc		code = jtsymbol_intern() */
	TOKEN_TYPE_TRUE,	/* true		code = NULL */
	TOKEN_TYPE_FALSE,	/* false	code = NULL */
	TOKEN_TYPE_EQ,		/* ==		code = NULL */
	TOKEN_TYPE_NE,		/* !=		code = NULL */
	TOKEN_TYPE_LE,		/* <=		code = NULL */
	TOKEN_TYPE_GE,		/* >=		code = NULL */
	TOKEN_TYPE_AND,		/* &&		code = NULL */
	TOKEN_TYPE_OR,		/* ||		code = NULL */
	TOKEN_TYPE_IF,		/* if		code = NULL */
	TOKEN_TYPE_ELSE,	/* else		code = NULL */
	TOKEN_TYPE_WHILE,	/* while	code = NULL */
	TOKEN_TYPE_FUN,		/* fun		code = NULL */
	TOKEN_TYPE_VAR,		/* var		code = NULL */
	TOKEN_TYPE_OBJECT,	/* object	code = NULL */
	TOKEN_TYPE_NEW,		/* new		code = NULL */
	/* TODO: g[Ñ^CvAɒǉĂB */
};

/* ͊(Lexer)ǂݍށAg[N\C^[tFCXłB
 */
DEFINE_INTERFACE(TOKEN_INTERFACE, 1133640193/*2005/12/04 05:03:13*/,

	/* g[Ñ^Cv擾܂B
	 * [out]
	 *	߂l		g[Ñ^Cv\lB
	 *			R[hA܂́ATOKEN_TYPE_*萔łB
	 */
	int (*get_type)(TOKEN_INTERFACE** intf);

	/* g[N̒l擾܂B
	 * [out]
	 *	߂l		g[N̒l\R[hB
	 *			R[hȂ^Cv̏ꍇ́ANULLƂȂ܂B
	 */
	JTCODE_INTERFACE** (*get_code)(TOKEN_INTERFACE** intf);
);

#define IMPLEMENT_TOKEN_INTERFACE(CC, cc)				\
IMPLEMENT_UNKNOWN_INTERFACE_METHODS(CC, cc, TOKEN, token)		\
static int token_get_type(TOKEN_INTERFACE** intf);			\
static JTCODE_INTERFACE** token_get_code(TOKEN_INTERFACE** intf);	\
static TOKEN_INTERFACE token_interface = {				\
	token_query_interface,						\
	token_addref,							\
	token_release,							\
	token_get_type,							\
	token_get_code,							\
};

/*--------------------------------------------------------------------------*/

/* g[NIuWFNg쐬܂B
 * [in]
 *	type		g[Ñ^Cv\lB
 *	code		g[N̒l\R[hB
 * [note]
 *	* typecode̎(܂NULL)̑gݍ킹́ATOKEN_TYPE_*萔̃Rgɏ]ĂB
 *	  token_create()֐́Atypecodȇgݍ킹ۂAĂ܂B
 */
TOKEN_INTERFACE** token_create(int type, JTCODE_INTERFACE** code);

/*****************************************************************************
 *	LEXER
 *****************************************************************************/

/* ͊(Lexer)\C^[tFCXłB
 */
DEFINE_INTERFACE(LEXER_INTERFACE, 1133678182/*2005/12/04 15:36:22*/,

	/* ܂łɓǂݍ񂾍s擾܂B
	 * [out]
	 *	߂l		sB
	 */
	int (*get_line)(LEXER_INTERFACE** intf);

	/* ̃g[Nǂݍ݂܂B
	 * [out]
	 *	߂l		ǂݍ񂾃g[NB
	 *			t@CI[ɒBANULLԂ܂B
	 */
	TOKEN_INTERFACE** (*get_token)(LEXER_INTERFACE** intf);

	/* ǂݍ񂾃g[NA߂܂B
	 * [in]
	 *	token		߂g[NB
	 * [note]
	 *	* t@CI[ӖANULL߂Ƃ͂ł܂B
	 *	  NULLw肵unget_token()ĂяoƁAAT[g܂B
	 *	* Aē̃g[N߂Ƃ͂ł܂B
	 *	  Aunget_token()ĂяoA͕Kget_token()ĂԕKv܂B
	 *	  AēAunget_token()ĂяoƁAAT[g܂B
	 */
	void (*unget_token)(LEXER_INTERFACE** intf, TOKEN_INTERFACE** token);
);

#define IMPLEMENT_LEXER_INTERFACE(CC, cc)					\
IMPLEMENT_UNKNOWN_INTERFACE_METHODS(CC, cc, LEXER, lexer)			\
static int lexer_get_line(LEXER_INTERFACE** intf);				\
static TOKEN_INTERFACE** lexer_get_token(LEXER_INTERFACE** intf);		\
static void lexer_unget_token(LEXER_INTERFACE** intf, TOKEN_INTERFACE** token);	\
static LEXER_INTERFACE lexer_interface = {					\
	lexer_query_interface,							\
	lexer_addref,								\
	lexer_release,								\
	lexer_get_line,								\
	lexer_get_token,							\
	lexer_unget_token,							\
};

/*--------------------------------------------------------------------------*/

/* ͊IuWFNg쐬܂B
 * [in]
 *	in		̓Xg[B
 */
LEXER_INTERFACE** lexer_create(FILE* in);

/*****************************************************************************
 *	ARITHMETIC
 *****************************************************************************/

/* ZpZ̋@\\C^[tFCXłB
 */
DEFINE_INTERFACE(ARITHMETIC_INTERFACE, 1134194844/*2005/12/10 15:07:24*/,
	JTCODE_INTERFACE** (*neg)(ARITHMETIC_INTERFACE** intf);
	JTCODE_INTERFACE** (*add)(ARITHMETIC_INTERFACE** intf, JTCODE_INTERFACE** code);
	JTCODE_INTERFACE** (*sub)(ARITHMETIC_INTERFACE** intf, JTCODE_INTERFACE** code);
	JTCODE_INTERFACE** (*mul)(ARITHMETIC_INTERFACE** intf, JTCODE_INTERFACE** code);
	JTCODE_INTERFACE** (*div)(ARITHMETIC_INTERFACE** intf, JTCODE_INTERFACE** code);
);

#define IMPLEMENT_ARITHMETIC_INTERFACE(CC, cc)							\
IMPLEMENT_UNKNOWN_INTERFACE_METHODS(CC, cc, ARITHMETIC, arithmetic)				\
static JTCODE_INTERFACE** arithmetic_neg(ARITHMETIC_INTERFACE** intf);				\
static JTCODE_INTERFACE** arithmetic_add(ARITHMETIC_INTERFACE** intf, JTCODE_INTERFACE** code);	\
static JTCODE_INTERFACE** arithmetic_sub(ARITHMETIC_INTERFACE** intf, JTCODE_INTERFACE** code);	\
static JTCODE_INTERFACE** arithmetic_mul(ARITHMETIC_INTERFACE** intf, JTCODE_INTERFACE** code);	\
static JTCODE_INTERFACE** arithmetic_div(ARITHMETIC_INTERFACE** intf, JTCODE_INTERFACE** code);	\
static ARITHMETIC_INTERFACE arithmetic_interface = {						\
	arithmetic_query_interface,								\
	arithmetic_addref,									\
	arithmetic_release,									\
	arithmetic_neg,										\
	arithmetic_add,										\
	arithmetic_sub,										\
	arithmetic_mul,										\
	arithmetic_div,										\
};

/*****************************************************************************
 *	LOGICAL
 *****************************************************************************/

/* _Z̋@\\C^[tFCXłB
 */
DEFINE_INTERFACE(LOGICAL_INTERFACE, 1134462480/*2005/12/13 17:28:00*/,
	JTCODE_INTERFACE** (*not)(LOGICAL_INTERFACE** intf);
	JTCODE_INTERFACE** (*or)(LOGICAL_INTERFACE** intf, JTCODE_INTERFACE** code);
	JTCODE_INTERFACE** (*and)(LOGICAL_INTERFACE** intf, JTCODE_INTERFACE** code);
);

#define IMPLEMENT_LOGICAL_INTERFACE(CC, cc)							\
IMPLEMENT_UNKNOWN_INTERFACE_METHODS(CC, cc, LOGICAL, logical)					\
static JTCODE_INTERFACE** logical_not(LOGICAL_INTERFACE** intf);				\
static JTCODE_INTERFACE** logical_or(LOGICAL_INTERFACE** intf, JTCODE_INTERFACE** code);	\
static JTCODE_INTERFACE** logical_and(LOGICAL_INTERFACE** intf, JTCODE_INTERFACE** code);	\
static LOGICAL_INTERFACE logical_interface = {							\
	logical_query_interface,								\
	logical_addref,										\
	logical_release,									\
	logical_not,										\
	logical_or,										\
	logical_and,										\
};

/*****************************************************************************
 *	COMPARE
 *****************************************************************************/

/* rZ̋@\\C^[tFCXłB
 */
DEFINE_INTERFACE(COMPARE_INTERFACE, 1134194992/*2005/12/10 15:09:52*/,

	/* ƁÃR[hr܂B
	 * [in]
	 *	code		̃R[hB
	 * [out]
	 *	߂l		̃R[h΁AlԂ܂B
	 *			̃R[h傫΁AlԂ܂B
	 *			Ђ΁A[Ԃ܂B
	 * [note]
	 *	* ƁÃR[hr\ǂ́AˑłB
	 *	  2006/01/11݁Ar\ȃIuWFNg̑gݍ킹́Aȉ̂ƂłB
	 *	  E = JTINT   A = JTINT
	 *	  E = JTSTRINGA = JTSTRING
	 *	* JTBOOL͔rs\ł邱ƂɒӂĂB
	 *	  IWiJoyToýA^Ulm̔r\ȎdlƂȂĂ܂A
	 *	  ^Ulm̎ZpŕA{AӖƎv̂ŁAdl܂B
	 */
	int (*compare)(COMPARE_INTERFACE** intf, JTCODE_INTERFACE** code);
);

#define IMPLEMENT_COMPARE_INTERFACE(CC, cc)					\
IMPLEMENT_UNKNOWN_INTERFACE_METHODS(CC, cc, COMPARE, compare)			\
static int compare_compare(COMPARE_INTERFACE** intf, JTCODE_INTERFACE** code);	\
static COMPARE_INTERFACE compare_interface = {					\
	compare_query_interface,						\
	compare_addref,								\
	compare_release,							\
	compare_compare,							\
};

/*****************************************************************************
 *	JTINT
 *****************************************************************************/

/* l̋@\\C^[tFCXłB
 */
DEFINE_INTERFACE(JTINT_INTERFACE, 1133695426/*2005/12/04 20:23:46*/,

	/* l擾܂B
	 * [out]
	 *	߂l		lB
	 */
	int (*get_value)(JTINT_INTERFACE** intf);
);

#define IMPLEMENT_JTINT_INTERFACE(CC, cc)			\
IMPLEMENT_UNKNOWN_INTERFACE_METHODS(CC, cc, JTINT, jtint)	\
static int jtint_get_value(JTINT_INTERFACE** intf);		\
static JTINT_INTERFACE jtint_interface = {			\
	jtint_query_interface,					\
	jtint_addref,						\
	jtint_release,						\
	jtint_get_value,					\
};

/*--------------------------------------------------------------------------*/

/* lR[h쐬܂B
 * [in]
 *	value		lB
 * [note]
 *	* lR[h(JTINT_INTERFACE)́Al(int)AR[hƂĈ߂̃bp[łB
 *	  AύXs\ȐlƌȂ܂B
 */
JTCODE_INTERFACE** jtint_create(int value);

/*****************************************************************************
 *	JTSTRING
 *****************************************************************************/

/* ̋@\\C^[tFCXłB
 */
DEFINE_INTERFACE(JTSTRING_INTERFACE, 1134500258/*2005/12/14 03:57:38*/,

	/* AsciiZ擾܂B
	 * [out]
	 *	߂l		AsciiZւ̃|C^B
	 * [note]
	 *	* ߂l̃|C^́AIuWFNgAsciiZ𒼐ڎQƂĂ܂B
	 *	  IuWFNgłƁA߂l̃|C^AƂȂ܂B
	 *	  ߂l̃|C^ۑāAŎg肵Ȃ悤AӂĂB
	 */
	const char* (*get_string)(JTSTRING_INTERFACE** intf);
);

#define IMPLEMENT_JTSTRING_INTERFACE(CC, cc)				\
IMPLEMENT_UNKNOWN_INTERFACE_METHODS(CC, cc, JTSTRING, jtstring)		\
static const char* jtstring_get_string(JTSTRING_INTERFACE** intf);	\
static JTSTRING_INTERFACE jtstring_interface = {			\
	jtstring_query_interface,					\
	jtstring_addref,						\
	jtstring_release,						\
	jtstring_get_string,						\
};

/*--------------------------------------------------------------------------*/

/* R[h쐬܂B
 * [in]
 *	str		AsciiZւ̃|C^B
 * [note]
 *	* jtstring_create()́Aw肳ꂽAsciiZ𕡐Ai[܂B
 *	  ֐ԂAĂт́AAsciiZč\܂B
 */
JTCODE_INTERFACE** jtstring_create(const char* str);

/*****************************************************************************
 *	JTSYMBOL
 *****************************************************************************/

/* V{̋@\\C^[tFCXłB
 */
DEFINE_INTERFACE(JTSYMBOL_INTERFACE, 1133695749/*2005/12/04 20:29:09*/,

	/* V{̖O擾܂B
	 * [out]
	 *	߂l		O\AsciiZւ̃|C^B
	 * [note]
	 *	* ߂l̃|C^́AIuWFNgAsciiZ𒼐ڎQƂĂ܂B
	 *	  IuWFNgłƁA߂l̃|C^AƂȂ܂B
	 *	  ߂l̃|C^ۑāAŎg肵Ȃ悤AӂĂB
	 */
	const char* (*get_name)(JTSYMBOL_INTERFACE** intf);
);

#define IMPLEMENT_JTSYMBOL_INTERFACE(CC, cc)				\
IMPLEMENT_UNKNOWN_INTERFACE_METHODS(CC, cc, JTSYMBOL, jtsymbol)		\
static const char* jtsymbol_get_name(JTSYMBOL_INTERFACE** intf);	\
static JTSYMBOL_INTERFACE jtsymbol_interface = {			\
	jtsymbol_query_interface,					\
	jtsymbol_addref,						\
	jtsymbol_release,						\
	jtsymbol_get_name,						\
};

/*--------------------------------------------------------------------------*/

/* V{R[h쐬܂B
 * [in]
 *	name		OB
 * [note]
 *	* ɓ̃V{R[h݂ꍇ́AIuWFNgL܂B
 *	  ]āA̃V{R[h̓́A|C^rɂčs܂B
 */
JTCODE_INTERFACE** jtsymbol_intern(const char* name);

/*****************************************************************************
 *	JTBOOL
 *****************************************************************************/

/* ^Ul̋@\\C^[tFCXłB
 */
DEFINE_INTERFACE(JTBOOL_INTERFACE, 1134564980/*2005/12/14 21:56:20*/,

	/* ^Ul擾܂B
	 * [out]
	 *	߂l		^Ȃ0ȊO̒lԂ܂B
	 *			UȂ0Ԃ܂B
	 */
	int (*get_value)(JTBOOL_INTERFACE** intf);
);

#define IMPLEMENT_JTBOOL_INTERFACE(CC, cc)			\
IMPLEMENT_UNKNOWN_INTERFACE_METHODS(CC, cc, JTBOOL, jtbool)	\
static int jtbool_get_value(JTBOOL_INTERFACE** intf);		\
static JTBOOL_INTERFACE jtbool_interface = {			\
	jtbool_query_interface,					\
	jtbool_addref,						\
	jtbool_release,						\
	jtbool_get_value,					\
};

/*--------------------------------------------------------------------------*/

/* ^UlR[h쐬܂B
 * [in]
 *	value		0ȊO̒lw肷ƁA^\^UlR[h쐬܂B
 *			0        w肷ƁAU\^UlR[h쐬܂B
 * [note]
 *	* ^AсAU\^UlR[h́AC^v^ŜŗBłB
 *	  jtbool_create(0ȊO̒l)́AɁAC^[tFCX|C^Ԃ܂B
 *	  jtbool_create(0        )́AɁAC^[tFCX|C^Ԃ܂B
 */
JTCODE_INTERFACE** jtbool_create(int value);

/*****************************************************************************
 *	JTUNEXPR
 *****************************************************************************/

/* PZR[h쐬܂B
 * [in]
 *	op		ZqB
 *	code		lB
 * [note]
 *	*  2006/01/12݁Aw\ȉZq́Aȉ̂ƂłB
 *
 *		Zq		codeɕKvȲ̪	ڰ
 *		------		--------------------	--------
 *		'-'		ARITHMETIC_INTERFACE	neg()
 *		'!'		LOGICAL_INTERFACE	not()
 */
JTCODE_INTERFACE** jtunexpr_create(int op, JTCODE_INTERFACE** code);

/*****************************************************************************
 *	JTBINEXPR
 *****************************************************************************/

/* 񍀉ZR[h쐬܂B
 * [in]
 *	op		ZqB
 *	code1		ӒlB
 *	code2		EӒlB
 * [note]
 *	*  2006/01/12݁Aw\ȉZq́Aȉ̂ƂłB
 *
 *		Zq		codeɕKvȲ̪	ڰ
 *		------		--------------------	--------
 *		'+'		ARITHMETIC_INTERFACE	add()
 *		'-'		ARITHMETIC_INTERFACE	sub()
 *		'*'		ARITHMETIC_INTERFACE	mul()
 *		'/'		ARITHMETIC_INTERFACE	div()
 *		TOKEN_TYPE_OR	LOGICAL_INTERFACE	or()
 *		TOKEN_TYPE_AND	LOGICAL_INTERFACE	and()
 *		TOKEN_TYPE_EQ	COMPARE_INTERFACE	compare()
 *		TOKEN_TYPE_NE	COMPARE_INTERFACE	compare()
 *		TOKEN_TYPE_LE	COMPARE_INTERFACE	compare()
 *		TOKEN_TYPE_GE	COMPARE_INTERFACE	compare()
 *		'<'		COMPARE_INTERFACE	compare()
 *		'>'		COMPARE_INTERFACE	compare()
 *		'='		JTSYMBOL_INTERFACE	joytoy_set_symbol_value
 */
JTCODE_INTERFACE** jtbinexpr_create(int op, JTCODE_INTERFACE** code1, JTCODE_INTERFACE** code2);

/*****************************************************************************
 *	JTDOTEXPR
 *****************************************************************************/

/* IuWFNg̃tB[hϐ̒l擾AR[h쐬܂B
 * [in]
 *	code		IuWFNgB
 *	symbol		tB[hϐ\V{B
 */
JTCODE_INTERFACE** jtdotexpr_create(JTCODE_INTERFACE** code, JTSYMBOL_INTERFACE** symbol);

/*****************************************************************************
 *	JTDOTASSIGN
 *****************************************************************************/

/* IuWFNg̃tB[hϐ̒lݒ肷AR[h쐬܂B
 * [in]
 *	code		IuWFNgB
 *	symbol		tB[hϐ\V{B
 *	value		tB[hϐɐݒ肷lB
 */
JTCODE_INTERFACE** jtdotassign_create(JTCODE_INTERFACE** code, JTSYMBOL_INTERFACE** symbol, JTCODE_INTERFACE** value);

/*****************************************************************************
 *	JTDOTCALL
 *****************************************************************************/

/* IuWFNg̃\bhĂяoAR[h쐬܂B
 * [in]
 *	code		IuWFNgB
 *	symbol		\bh\V{B
 *	args_list	XgB
 *			(JTCODE_INTERFACE**)XgvfƂAz񃊃XgłB
 *			ulist_create(&jtcode_list_info);vŁA쐬ĂB
 */
JTCODE_INTERFACE** jtdotcall_create(JTCODE_INTERFACE** code, JTSYMBOL_INTERFACE** symbol, LIST/*<JTCODE_INTERFACE**>*/ * args_list);

/*****************************************************************************
 *	JTNEW
 *****************************************************************************/

/* IuWFNg𕡐AR[h쐬܂B
 * [in]
 *	symbol		̃IuWFNg\V{B
 *	body		ubNB
 *			ubNꍇ́ANULLw肵ĂB
 */
JTCODE_INTERFACE** jtnew_create(JTSYMBOL_INTERFACE** symbol, JTCODE_INTERFACE** body);

/*****************************************************************************
 *	JTIF
 *****************************************************************************/

/* ifR[h쐬܂B
 * [in]
 *	cond		B
 *	then_body;	^̂ƂɎs镶B
 *	else_body;	ÛƂɎs镶B
 *			elseubN̖if̏ꍇ́Aelse_bodyNULLw肵ĂB
 */
JTCODE_INTERFACE** jtif_create(JTCODE_INTERFACE** cond, JTCODE_INTERFACE** then_body, JTCODE_INTERFACE** else_body);

/*****************************************************************************
 *	JTWHILE
 *****************************************************************************/

/* whileR[h쐬܂B
 * [in]M
 *	cond		B
 *	body		^̊ԁAs镶B
 */
JTCODE_INTERFACE** jtwhile_create(JTCODE_INTERFACE** cond, JTCODE_INTERFACE** body);

/*****************************************************************************
 *	JTBLOCK
 *****************************************************************************/

/* ubNR[h쐬܂B
 * [in]
 *	stmt_list	XgB
 *			(JTCODE_INTERFACE**)XgvfƂAz񃊃XgłB
 *			ulist_create(&jtcode_list_info);vŁA쐬ĂB
 * [note]
 *	- jtblock_create()́AXg𕡐āAێ܂B
 *	  jtblock_create()ԂAĂяóAXgč\܂B
 */
JTCODE_INTERFACE** jtblock_create(LIST/*<JTCODE_INTERFACE**>*/ * stmt_list);

/****************************************************************************
 *	JTOBJECT
 ****************************************************************************/

/* IuWFNg̋@\\C^[tFCXłB
 */
DEFINE_INTERFACE(JTOBJECT_INTERFACE, 1137559251/*2006/01/18 13:40:51*/,

	/* tB[hϐ̒l擾܂B
	 * [in]
	 *	symbol		tB[hϐ\V{B
	 * [out]
	 *	߂l		tB[hϐ̒lB
	 * [note]
	 *	* tB[hϐ`ĂȂ΁ANULLԂ܂B
	 */
	JTCODE_INTERFACE** (*get_field_value)(JTOBJECT_INTERFACE** intf, JTSYMBOL_INTERFACE** symbol);

	/* tB[hϐ̒lݒ肵܂B
	 * [in]
	 *	symbol		tB[hϐ\V{B
	 *	value		tB[hϐ̒lB
	 * [note]
	 *	* tB[hϐ`ĂȂ΁AAT[g܂B
	 */
	void (*set_field_value)(JTOBJECT_INTERFACE** intf, JTSYMBOL_INTERFACE** symbol, JTCODE_INTERFACE** value);
);

#define IMPLEMENT_JTOBJECT_INTERFACE(CC, cc)										\
IMPLEMENT_UNKNOWN_INTERFACE_METHODS(CC, cc, JTOBJECT, jtobject)								\
static JTCODE_INTERFACE** jtobject_get_field_value(JTOBJECT_INTERFACE** intf, JTSYMBOL_INTERFACE** symbol);		\
static void jtobject_set_field_value(JTOBJECT_INTERFACE** intf, JTSYMBOL_INTERFACE** symbol, JTCODE_INTERFACE** value);	\
static JTOBJECT_INTERFACE jtobject_interface = {									\
	jtobject_query_interface,											\
	jtobject_addref,												\
	jtobject_release,												\
	jtobject_get_field_value,											\
	jtobject_set_field_value,											\
};

/*--------------------------------------------------------------------------*/

/* IuWFNg쐬܂B
 * [in]
 *	slots_table		Xbge[uB
 *				Xbge[uɂ́AtB[hϐ`A܂́A\bh`o^ĂĂB
 *				tB[hϐ`\R[h́AJTVAR_INTERFACET|[gĂKv܂B(jtvar_create()ɂč쐬)
 *				\bh      `\R[h́AJTFUN_INTERFACET|[gĂKv܂B(jtfun_create()ɂč쐬)
 * [note]
 *	* uXbgvƂ́AutB[hϐ`vƁu\bh`v̑̂łB
 *	- 2006/01/27݁AvÕRgLqAuXbgvƁutB[hϐv̋ʂ܂Ȃ܂܂Ȃ̂ŁAӂĂB
 *	  utB[hϐvƂtAutB[hϐvƁu\bhv̗҂\ړIŁAgĂ܂Ă肵܂B
 *	  (IuWFNgg猩ƁAtB[hϐƃ\bh̋ʂ͖A擾ɂāAϐƂĈ֐ƂĈ̈Ⴂł)
 */
JTCODE_INTERFACE** jtobject_create(MAP/*<JTSYMBOL_INTERFACE**,JTCODE_INTERFACE**>*/ * slots_table);

/* IuWFNg𕡐܂B
 * [in]
 *	object			̃IuWFNgB
 * [out]
 *	߂l			IuWFNgB
 * [note]
 *	* "obj_dst = new obj_src { ... };"s邽߂ɗp܂B
 *	* ̃IuWFNg1́ASẴXbgAVIuWFNg쐬܂B
 *	  Xbg̒ĺAg󂢃Rs[hs܂B
 *	* objectɎwł̂́Ajtobject_create()ԂJTCODE_INTERFACEɑ΂āAQueryInterface邱ƂœꂽJTOBJECT_INTERFACEłB
 *	  2006/01/29݁AJTOBJECT_INTERFACEC^[tFCXT|[gĂ̂́Ajtobject_create()Ȃ̂ŁA̓_𒍈ӂKv͂܂񂪁A
 *	  AA̕@JTOBJECT_INTERFACET|[gIuWFNgł悤ɕύXꍇɁA
 *	  ̂悤ȃIuWFNg̕쐬邽߂ɁA{֐𗘗p邱Ƃ͂łȂ̂ŁAӂĂB
 */
JTCODE_INTERFACE** jtobject_clone(JTOBJECT_INTERFACE** object);

/* IuWFNg܂B
 * [in]
 *	object1			̃IuWFNg1B
 *	object2			̃IuWFNg2B
 * [out]
 *	߂l			IuWFNgB
 * [note]
 *	* "obj_dst = obj_src1 + obj_src2;"s邽߂ɗp܂B
 *	* ̃IuWFNg1ƃIuWFNg2́ASẴXbgAVIuWFNg쐬܂B
 *	  Xbg̒ĺAg󂢃Rs[hs܂B
 *	- ̃IuWFNg1ƃIuWFNg2ɁAÕXbg݂ꍇAIuWFNg2̃XbgD悵܂B
 *	* objectɎwł̂́Ajtobject_create()ԂJTCODE_INTERFACEɑ΂āAQueryInterface邱ƂœꂽJTOBJECT_INTERFACEłB
 *	  2006/01/29݁AJTOBJECT_INTERFACEC^[tFCXT|[gĂ̂́Ajtobject_create()Ȃ̂ŁA̓_𒍈ӂKv͂܂񂪁A
 *	  AA̕@JTOBJECT_INTERFACET|[gIuWFNgł悤ɕύXꍇɁA
 *	  ̂悤ȃIuWFNg̍쐬邽߂ɁA{֐𗘗p邱Ƃ͂łȂ̂ŁAӂĂB
 */
JTCODE_INTERFACE** jtobject_merge(JTOBJECT_INTERFACE** object1, JTOBJECT_INTERFACE** object2);

/*****************************************************************************
 *	JTVAR
 *****************************************************************************/

/* ϐ`̋@\\C^[tFCXłB
 */
DEFINE_INTERFACE(JTVAR_INTERFACE, 1137548428/*2006/01/18 10:40:28*/,

	/* ϐ\V{擾܂B
	 * [out]
	 *	߂l		ϐ\V{B
	 */
	JTSYMBOL_INTERFACE** (*get_name)(JTVAR_INTERFACE** intf);

	/* ϐ̏l擾܂B
	 * [out]
	 *	߂l		ϐ̏lB
	 */
	JTCODE_INTERFACE** (*get_code)(JTVAR_INTERFACE** intf);
);

#define IMPLEMENT_JTVAR_INTERFACE(CC, cc)				\
IMPLEMENT_UNKNOWN_INTERFACE_METHODS(CC, cc, JTVAR, jtvar)		\
static JTSYMBOL_INTERFACE** jtvar_get_name(JTVAR_INTERFACE** intf);	\
static JTCODE_INTERFACE** jtvar_get_code(JTVAR_INTERFACE** intf);	\
static JTVAR_INTERFACE jtvar_interface = {				\
	jtvar_query_interface,						\
	jtvar_addref,							\
	jtvar_release,							\
	jtvar_get_name,							\
	jtvar_get_code,							\
};

/*--------------------------------------------------------------------------*/
/* ϐ`R[h쐬܂B
 * [in]
 *	name		ϐ\V{B
 *	code		ϐ̏lB
 */
JTCODE_INTERFACE** jtvar_create(JTSYMBOL_INTERFACE** name, JTCODE_INTERFACE** code);

/****************************************************************************
 *	JTFUN
 ****************************************************************************/

/* ֐̋@\\C^[tFCXłB
 */
DEFINE_INTERFACE(JTFUN_INTERFACE, 1135529565/*2005/12/26 01:52:45*/,

	/* ֐\V{擾܂B
	 * [out]
	 *	߂l		֐\V{B
	 */
	JTSYMBOL_INTERFACE** (*get_name)(JTFUN_INTERFACE** intf);

	/* ֐s܂B
	 * [in]
	 *	args_list	XgB
	 *			֐ĂяoÕ^C~OŁA炩ߎ]ĂĂB
	 *			ۂɂ́Ȁ́AJTFUNCALL_INTERFACE::run()ŝŁAɈӎKv͂܂B
	 *	object		\bh̎sΏۂƂȂIuWFNgB
	 *			\bhȂ΁AwK{łBNULLw肷ƃAT[g܂B
	 *			ʏ̊֐Ȃ΁A܂Bw肵Ă\܂B
	 */
	JTCODE_INTERFACE** (*call)(JTFUN_INTERFACE** intf, LIST/*<JTCODE_INTERFACE**>*/ * args_list, JTOBJECT_INTERFACE** object);
);

#define IMPLEMENT_JTFUN_INTERFACE(CC, cc)												\
IMPLEMENT_UNKNOWN_INTERFACE_METHODS(CC, cc, JTFUN, jtfun)										\
static JTSYMBOL_INTERFACE** jtfun_get_name(JTFUN_INTERFACE** intf);									\
static JTCODE_INTERFACE** jtfun_call(JTFUN_INTERFACE** intf, LIST/*<JTCODE_INTERFACE**>*/ * args_list, JTOBJECT_INTERFACE** object);	\
static JTFUN_INTERFACE jtfun_interface = {												\
	jtfun_query_interface,														\
	jtfun_addref,															\
	jtfun_release,															\
	jtfun_get_name,															\
	jtfun_call,															\
};

/*--------------------------------------------------------------------------*/

/* ֐`쐬܂B
 * [in]
 *	name		֐\V{B
 *	params_list	XgB
 *			(JTSYMBOL_INTERFACE**)XgvfƂAz񃊃XgłB
 *			ulist_create(&jtsymbol_list_info);vŁA쐬ĂB
 *	body		֐̖{́B
 *	method		ʏ̊֐Ȃ΁A0w肵ĂB
 *			\bhȂ΁A0ȊO̒lw肵ĂB
 * [note]
 *	- jtfun_create()́AXg𕡐āAێ܂B
 *	  jtfun_create()ԂAĂяóAXgč\܂B
 */
JTCODE_INTERFACE** jtfun_create(JTSYMBOL_INTERFACE** name, LIST/*<JTSYMBOL_INTERFACE**>*/ * params_list, JTCODE_INTERFACE** body, int method);

/*--------------------------------------------------------------------------*/

/* gݍ݊֐쐬܂B
 * [in]
 *	name		gݍ݊֐\V{B
 *	call		gݍ݊֐̏s֐B
 * [note]
 *	* jtprim_`_craete()Ă΂܂B(gp)
 */
JTCODE_INTERFACE** jtprim_create(const char* name, JTCODE_INTERFACE** (*call)(LIST/*<JTCODE_INTERFACE**>*/ * args_list));

/* \Agݍ݊֐쐬܂B
 * [note]
 *	* prim_init()AxĂ΂܂B(gp)
 */
JTCODE_INTERFACE** jtprim_print_create();

/* ől߂Agݍ݊֐쐬܂B
 * [note]
 *	* prim_init()AxĂ΂܂B(gp)
 */
JTCODE_INTERFACE** jtprim_max_create();

/* TODO: gݍ݊֐AɒǉĂB */

/*****************************************************************************
 *	JTFUNCALL
 *****************************************************************************/

/* ֐ĂяoR[h쐬܂B
 * [in]
 *	symbol		֐\V{B
 *	args_list	XgB
 *			(JTCODE_INTERFACE**)XgvfƂAz񃊃XgłB
 *			ulist_create(&jtcode_list_info);vŁA쐬ĂB
 * [note]
 *	- jtfuncall_create()́AXg𕡐āAێ܂B
 *	  jtfuncall_create()ԂAĂяóAXgč\܂B
 */
JTCODE_INTERFACE** jtfuncall_create(JTSYMBOL_INTERFACE** symbol, LIST/*<JTCODE_INTERFACE**>*/ * args_list);

/****************************************************************************
 *	PARSER
 ****************************************************************************/

/* \͊(Parser)\C^[tFCXłB
 */
DEFINE_INTERFACE(PARSER_INTERFACE, 1133770284/*2005/12/05 17:11:24*/,

	/* ̃R[hǂݍ݂܂B
	 * [out]
	 *	߂l		ǂݍ񂾃R[hB
	 */
	JTCODE_INTERFACE** (*parse)(PARSER_INTERFACE** intf);
);

#define IMPLEMENT_PARSER_INTERFACE(CC, cc)				\
IMPLEMENT_UNKNOWN_INTERFACE_METHODS(CC, cc, PARSER, parser)		\
static JTCODE_INTERFACE** parser_parse(PARSER_INTERFACE** intf);	\
static PARSER_INTERFACE parser_interface = {				\
	parser_query_interface,						\
	parser_addref,							\
	parser_release,							\
	parser_parse,							\
};

/*--------------------------------------------------------------------------*/

/* \͊IuWFNg쐬܂B
 * [in]
 *	lexer		\͊ւ̓͂ƂȂA͊B
 */
PARSER_INTERFACE** parser_create(LEXER_INTERFACE** lexer);

/****************************************************************************
 *	JOYTOY
 ****************************************************************************/

/* JoyToyC^v^s܂B
 * [in]
 *	in		̓Xg[B
 * [out]
 *	
 */
void joytoy_main(FILE* in);

/* R[h̓e\܂B
 * [in]
 *	code		R[hB
 * [note]
 *	* gݍ݊֐printĂAjtprim_print.c痘pĂ܂B
 *	  NXʂ̏ꍇAjoytoy.cɏW邽߂ɁA𕪗܂B
 *	- ɂȀ̓eXgIȂ̂łA
 *	  {́AeNXɕ񉻃C^[tFCXׂłB
 */
void joytoy_print(JTCODE_INTERFACE** code);

/* \e[u܂B
 * [in]
 *	name		\ꖼB
 * [out]
 *	߂l		w肳ꂽO̗\ꂪL΁A\̃^CvԂ܂B
 *			Ȃ΁AlԂ܂B
 */
int joytoy_get_reserved(const char* name);

/* ֐t[ɓ܂B
 */
void joytoy_enter();

/* ֐t[𔲂܂B
 */
void joytoy_leave();

/* ݂̊֐t[́AsΏۃIuWFNg擾܂B
 * [out]
 *	߂l		\bhsȂ΁AsΏۃIuWFNgԂ܂B
 *			O[oA܂́Aʏ̊֐sȂ΁ANULLԂ܂B
 */
JTOBJECT_INTERFACE** joytoy_get_object();

/* ݂̊֐t[́AsΏۃIuWFNgݒ肵܂B
 * [in]
 *	object		sΏۃIuWFNgB
 */
void joytoy_set_object(JTOBJECT_INTERFACE** object);

/* ϐ̒l擾܂B
 * [in]
 *	symbol		ϐ\V{B
 * [out]
 *	߂l		ϐ̒lB
 * [note]
 *	* ʏ̊֐A܂́A\bhsłA[Jϐ`ĂA[Jϐ̒l擾܂B
 *	  \bhsłAtB[hϐ`ĂAtB[hϐ̒l擾܂B
 *	  O[oϐ`ĂAO[oϐ̒l擾܂B
 *	  ɂYȂ΁ANULLԂ܂B
 */
JTCODE_INTERFACE** joytoy_get_symbol_value(JTSYMBOL_INTERFACE** symbol);

/* ϐ̒lݒ肵܂B
 * [in]
 *	symbol		ϐ\V{B
 *	value		ϐ̒lB
 * [note]
 *	* ʏ̊֐A܂́A\bhsłA[Jϐ`ĂA[Jϐ̒lݒ肵܂B
 *	  \bhsłAtB[hϐ`ĂAtB[hϐ̒lݒ肵܂B
 *	  O[oϐ`ĂAO[oϐ̒lݒ肵܂B
 *	  ɂYȂ΁AAT[g܂B
 */
void joytoy_set_symbol_value(JTSYMBOL_INTERFACE** symbol, JTCODE_INTERFACE** value);

/* Vϐ`܂B
 * [in]
 *	symbol		ϐ\V{B
 *	value		ϐ̏lB
 * [note]
 *	* ʏ̊֐A܂́A\bhsȂ΁A[Jϐ`܂B
 *	  Ȃ΁AO[oϐ`܂B
 *	  ̏ꍇAɓ̕ϐ`ĂAAT[g܂B
 */
void joytoy_def_symbol_value(JTSYMBOL_INTERFACE** symbol, JTCODE_INTERFACE** value);

#endif /*__JOYTOY_H__*/
