%{
/*{{^R[h:y.tab.y(錾,%{`%})======================================*/
#ifdef  PIECE
#include "app.h"
#else //PIECE
#include "winapp.h"
#endif//PIECE
/* p[T[X^bN̏l`܂B
 * sizeof(YYSTYPE)*YYINITDEPTH) X^bNɊmۂ܂B
 * ftHgł200ƒ`ĂAP/ECEɂ͑傫܂B
 * P/ECEɓK؂ȁAȃTCY(16)ɁAĒ`܂B
 * p[T[X^bNsꍇ́AIɊĝŁA肠܂B
 */
#define YYINITDEPTH 16
/*}}^R[h:y.tab.y(錾,%{`%})======================================*/
%}

%union {
	int   v_num;
	char* v_lab;
	char* v_str;
	//
	ST_KeyBody*   v_keyBody;
	ST_Key*       v_key;
	ST_NameRow*   v_nameRow;
	ST_ValueRow*  v_valueRow;
	ST_StringRow* v_stringRow;
}
%token T_END
%token <v_num> T_NUM
%token <v_lab> T_LAB
%token <v_str> T_STR
%token T_EOL

%left '|'
%left '^'
%left '&'
%left '<' '>'
%left '+' '-'
%left '*' '/'
%nonassoc T_UPL T_UMI
%type <v_keyBody>   keyBody
%type <v_key>       key
%type <v_nameRow>   nameRow
%type <v_valueRow>  valueRow
%type <v_stringRow> stringRow
%type <v_num>       name
%type <v_num>       data
%type <v_num>       expr
%type <v_str>       string

%%

all
		: keyBody			{ add_keyBody($1); }
		;
keyBody		: /* empty */			{ $$ = KeyBody_new(); }
		| keyBody T_EOL			/* use default action */
		| keyBody key			{ $$ = KeyBody_addKey($1, $2);       yyerrok; }	//errorL̈ʒuɂāwhttp://www.pwv.co.jp/~take/TakeWiki/index.php?CRpC݌v(yaccElex̉p)/4́@G[EJo#dbd8d417x́yoptional sequencezQlɂB
		| keyBody valueRow		{ $$ = KeyBody_addValueRow($1, $2);  yyerrok; }	//errorL̈ʒuɂāwhttp://www.pwv.co.jp/~take/TakeWiki/index.php?CRpC݌v(yaccElex̉p)/4́@G[EJo#dbd8d417x́yoptional sequencezQlɂB
		| keyBody stringRow		{ $$ = KeyBody_addStringRow($1, $2); yyerrok; }	//errorL̈ʒuɂāwhttp://www.pwv.co.jp/~take/TakeWiki/index.php?CRpC݌v(yaccElex̉p)/4́@G[EJo#dbd8d417x́yoptional sequencezQlɂB
		| keyBody error									//SẴV^NXG[񍐂邽߂ɌpB
		;
key
		: nameRow keyBody endRow	{ $$ = Key_new($1, $2); }
		;
nameRow
		: name T_EOL			{ $$ = NameRow_new($1); }
		;
valueRow
		: name '=' data T_EOL		{ $$ = ValueRow_new($1, $3); }
		;
stringRow
		: name '=' string T_EOL		{ $$ = StringRow_new($1, $3); }
		;
endRow
		: T_END T_EOL			/* no action */
		;
name
		: expr				{ $$ = Name_newExpr($1); }
		| T_LAB				{ $$ = Name_newLabel($1); }
		;
data
		: expr				{ $$ = Data_newExpr($1); }
		| T_LAB				{ $$ = Data_newLabel($1); }
		;
string
		: T_STR				{ $$ = String_intern($1); }
		;
expr
		: T_NUM
		| '(' expr ')'			{ $$ =  $2; }
		| '+' expr %prec T_UPL		{ $$ =  $2; }
		| '-' expr %prec T_UMI		{ $$ = -$2; }
		| expr '+' expr			{ $$ = $1 + $3; }
		| expr '-' expr			{ $$ = $1 - $3; }
		| expr '*' expr			{ $$ = $1 * $3; }
		| expr '/' expr			{ $$ = $1 / $3; }
		| expr '&' expr			{ $$ = $1 & $3; }
		| expr '^' expr			{ $$ = $1 ^ $3; }
		| expr '|' expr			{ $$ = $1 | $3; }
		| expr '<' expr			{ $$ = $1 << $3; }
		| expr '>' expr			{ $$ = $1 >> $3; }
		;

%%
