;	
;	framtiaa.s
;
;	P/ECE TIA (Television Interface Adapter) Emulator
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2005 Naoyuki Sawa
;
;	* Fri Mar 11 03:00:00 JST 2005 Naoyuki Sawa
;	- 쐬JnB
;
#define TIA_DEFINE_OFFSET
#include "cliptiaa.h"
#ifdef TIA_ASM

	.code
	.align	1

;****************************************************************************
;	
;****************************************************************************

;
;	int tia_write(int now, int addr, int data)
;
	.global	tia_write
tia_write:
	xcall.d	tia_scan_progress	; tia_scan_progress(now) (tia_scan_progress()̃AZúA%r13-15j󂵂܂)
	 sll	%r13, 2			; *delay* <----------------------+
	;				;                                |
	xcmp	%r13, 0x2c*4		; if(addr*4 > 0x2c*4) goto EXIT  |
	xjrgt	tia_write_EXIT		;                                |
	;				;                                |
	;sll	%r13, 2			; -------------------------------+
	ext	tia_write_table@ah	; return tia_write_table[addr](data)
	ext	tia_write_table@al
	ld.w	%r13, [%r13]
	ld.w	%r12, %r14		; *anti-interlock*
	jp	%r13			; (jp.dCPUoOɂgps!!)
	;
tia_write_EXIT:
	ret.d				; return 0
	ld.w	%r10, 0

;****************************************************************************
;	
;****************************************************************************

;
;	void tia_scan_progress(int now)
;
; [in]
;	%r12		now
; [use]
;	%r4-7,%r12
; [note]
;	* %r10-11,%r13-15j󂵂܂B
;	- tia_write()tia_read()̃AZúAtia_scan_progress()̃AZu
;	  %r13-15j󂵂ȂƂOƂčĂ܂B(2005/03/22)
;	- Atia_scan_progress()̃AZuύXꍇ́A
;	  %r10-11j󂵂Ă\܂񂪁A%r13-15j󂷂悤ȕύX͂ȂłB
;
	.global	tia_scan_progress
tia_scan_progress:
	xld.w	%r4, tia			; %r4 = p_tia = &tia
	xld.w	%r5, 68+160			; %r5 = 68/*Hblank*/ + 160
	;
	xld.w	%r6, [%r4+SCAN_X]		; %r6 = scan_x = p_tia->scan_x /* o */
	;
	xld.w	%r7, [%r4+NOW]			; %r7 = p_tia->now
	xld.w	[%r4+NOW], %r12			; p_tia->now = now (Ɋi[Ă܂) *anti-interlock*
	sub	%r12, %r7			; %r12 = (now - p_tia->now)
	ld.w	%r7, %r12			; %r7  = (now - p_tia->now)
	add	%r7, %r7			; %r7  = (now - p_tia->now) * 2
	add	%r7, %r12			; %r7  = (now - p_tia->now) * 3 = clock
	;
	xcmp	%r7, TIA_CLOCK/60		; if(clock > TIA_CLOCK / 60) {
	xjrule	tia_scan_progress_NO_SAFETY
	xld.w	%r7, TIA_CLOCK/60		;   clock = TIA_CLOCK / 60
tia_scan_progress_NO_SAFETY:			; }
	;
	add	%r6, %r7			; scan_x += clock
	cmp	%r6, %r5			; if(scan_x >= 68/*Hblank*/ + 160) {
	xjrlt	tia_scan_progress_NO_HSYNC
	;
	xld.w	%r7, [%r4+SCAN_Y]		;   %r7 = scan_y = p_tia->scan_y; /* o */
	;
tia_scan_progress_DO_HSYNC:			;   do {
	sub	%r6, %r5			;     scan_x -= 68/*Hblank*/ + 160
	cmp	%r6, %r5			;   } while(scan_x >= 68/*Hblank*/ + 160)
	xjrge.d	tia_scan_progress_DO_HSYNC
	add	%r7, 1				;     scan_y++ *delay*
	;
	xbtst	[%r4+VSYNC], 1			;   if((p_tia->VSYNC & (1<<1)) &&
	xjreq	tia_scan_progress_NO_VSYNC
	xcmp	%r7, 3+37			;      (scan_y >= (3/*Vsync*/ + 37/*Vblank*/)) {
	xjrlt	tia_scan_progress_NO_VSYNC
	xld.w	%r7, 0				;              scan_y = 0
	xld.w	[%r4+LAST_X], %r7		;       p_tia->last_x = 0
	xld.w	[%r4+LAST_Y], %r7		;       p_tia->last_y = 0
tia_scan_progress_NO_VSYNC:			;   }
	;
	xld.w	[%r4+SCAN_Y], %r7		;   p_tia->scan_y = scan_y; /* ߂ */
	;
tia_scan_progress_NO_HSYNC:			; }
	;
	xld.w	[%r4+SCAN_X], %r6		; p_tia->scan_x = scan_x /* ߂ */
	;
	ret

;****************************************************************************
;	
;****************************************************************************

;
;	void tia_partial_update()
;
	.global	tia_partial_update
tia_partial_update:
	pushn	%r3
	;
	xld.w	%r0, tia			; %r0 = p_tia = &tia
	xld.w	%r1, [%r0+SCAN_X]		; %r1 = scan_x = p_tia->scan_x
	xld.w	%r2, [%r0+SCAN_Y]		; %r2 = scan_y = p_tia->scan_y
	;
	xbtst	[%r0+VBLANK], 1			; if(!(p_tia->VBLANK & (1<<1))) { /* Vblank=Off */
	xjrne	tia_partial_update_VBLANK
	;---------------------------------------;
	xld.w	%r13, [%r0+LAST_X]		; %r13 = last_x = p_tia->last_x
	xld.w	%r3 , [%r0+LAST_Y]		; %r3  = last_y = p_tia->last_y
	;
	xjp	tia_partial_update_L20		; if(last_y < scan_y) {
tia_partial_update_L10:				;   do {
	xld.w	%r14, 68+160
	xcall.d	tia_line_update			;     tia_line_update(last_y, last_x, 68/*Hblank*/ + 160)
	ld.w	%r12, %r3			;     *delay*
	xld.w	%r13, 0				;     last_x = 0
	xadd	%r3, %r3, 1			;     last_y++
tia_partial_update_L20:
	cmp	%r3, %r2			;   } while(last_y < scan_y)
	xjrlt	tia_partial_update_L10		; }
	;
	ld.w	%r14, %r1
	xcall.d	tia_line_update			; tia_line_update(last_y, last_x, scan_x)
	ld.w	%r12, %r3			; *delay*
	;---------------------------------------;
tia_partial_update_VBLANK:
	;
	xld.w	[%r0+LAST_X], %r1		; p_tia->last_x = scan_x
	xld.w	[%r0+LAST_Y], %r2		; p_tia->last_y = scan_y
	;
	popn	%r3
	ret

;****************************************************************************
;	
;****************************************************************************

;
;	void tia_line_update(unsigned y, unsigned x1, unsigned x2)
;
;	%r12	y
;	%r13	x1
;	%r14	x2
;
	.global	tia_line_update
tia_line_update:
	xsub	%r12, %r12, (3+37)		; y -= (3/*Vsync*/ + 37/*Vblank*/)
	xcmp	%r12, 191			; if(y > 191) return
	xjrugt	tia_line_update_EXIT
	;
	xsub	%r13, %r13, 68			; x1 -= 68/*Hblank*/
	jruge	2				; if(Carry) x1 = 0
	ld.w	%r13, 0				; (skip?)
	xsub	%r14, %r14, 68			; x2 -= 68/*Hblank*/
	jruge	2				; if(Carry) x2 = 0
	ld.w	%r14, 0				; (skip?)
	cmp	%r13, %r14			; if(x1 >= x2) return
	xjruge	tia_line_update_EXIT
	;---------------------------------------;
	pushn	%r3
	xsub	%sp, %sp, 16			; [%sp+ 0].w  = switch(player[0].size)
	;					; [%sp+ 4].w  = switch(player[1].size)
	;					; [%sp+ 8].ub = player[0].position
	;					; [%sp+ 9].ub = player[1].position
	;					; [%sp+10].ub = missile[0].position
	;					; [%sp+11].ub = missile[0].size
	;					; [%sp+12].ub = missile[1].position
	;					; [%sp+13].ub = missile[1].size
	;					; [%sp+14].ub = ball.position
	;					; [%sp+15].ub = ball.size
	;
	xld.w	%r0, tia			; %r0 = p_tia = &tia
	;
	xld.w	%r1, [%r0+VBUFF]		; %r1 = vbuff = p_tia->vbuff
	xsll	%r12, 5				; vbuff += y *  32 ---+
	add	%r1, %r12			;                     |
	xsll	%r12, (7-5)			; vbuff += y * 128 ---+-- y * 160 + x
	add	%r1, %r12			;                     |
	add	%r1, %r13			; vbuff += x *delay* -+
	xld.ub	%r12, [%r0+CTRLPF]		; %r12 = CTRLPF (00xx 0xxx)
	xand	%r9, %r12, (1<<2)
	xsll	%r9, (6-2)
	ext	tia_priority_table@ah		; %r2 = priority = tia_priority_table[CTRLPF[2:PFP]]
	ext	tia_priority_table@al
	add	%r2, %r9
	xand	%r12, %r12, (1<<1)		; %r12 = CTRLPF[1:SCORE] ? 2 : -1
	xcmp	%r12, 1				; -+
	sbc	%r12, %r8			; -+- 2s"if(%r12==0) %r12--;"̏łB
	;
	xld.uh	%r3, [%r0+COLLISION]		; %r3 = collision = p_tia->collision /* o */
	;
	xld.ub	%r4, [%r0+PLAYER0_DELAY]	; %r4[7:0] = g = player[0].graphics[player[0].delay]
	add	%r4, %r0
	xld.ub	%r4, [%r4+PLAYER0_GRAPHICS]
	xcmp	%r4, 0				; if(g) {
	xjreq	tia_line_update_NO_PLAYER0
	xld.ub	%r9,  [%r0+PLAYER0_POSITION]	;   %r9  = player[0].position
	xld.ub	%r10, [%r0+PLAYER0_SIZE]	;   %r10 = player[0].size
	xbtst	[%r0+PLAYER0_REFLECT], 0	;   if(!player[0].reflect) {
	jrne.d	3				;     g = mirror(g)
	sll	%r10, 2				;     *delay*
	mirror	%r4, %r4			;   } (skip?)
	ext	tia_line_update_PLAYER0_SWITCH@ah
	ext	tia_line_update_PLAYER0_SWITCH@al
	ld.w	%r10, [%r10]
	xld.b	[%sp+8], %r9			;   [%sp+8] = player[0].position
	xld.w	[%sp+0], %r10			;   [%sp+0] = switch(player[0].size)
tia_line_update_NO_PLAYER0:			; }
	;
	xbtst	[%r0+MISSILE0_GRAPHICS], 0	; %r4[31:8] = g = missile[0].graphics && !missile[0].reset
	xjreq	tia_line_update_NO_MISSILE0
	xbtst	[%r0+MISSILE0_RESET], 0
	xjrne	tia_line_update_NO_MISSILE0	; if(g) {
	xoor	%r4, %r4, ~((1<<8)-1)
	xld.ub	%r9,  [%r0+MISSILE0_POSITION]	;   [%sp+10] = missile[0].position
	xld.ub	%r10, [%r0+MISSILE0_SIZE]	;   [%sp+11] = missile[0].size
	xld.b	[%sp+10], %r9
	xld.b	[%sp+11], %r10
tia_line_update_NO_MISSILE0:			; }
	;
	xld.ub	%r5, [%r0+PLAYER1_DELAY]	; %r5[7:0] = g = player[1].graphics[player[1].delay]
	add	%r5, %r0
	xld.ub	%r5, [%r5+PLAYER1_GRAPHICS]
	xcmp	%r5, 0				; if(g) {
	xjreq	tia_line_update_NO_PLAYER1
	xld.ub	%r9,  [%r0+PLAYER1_POSITION]	;   %r9  = player[1].position
	xld.ub	%r10, [%r0+PLAYER1_SIZE]	;   %r10 = player[1].size
	xbtst	[%r0+PLAYER1_REFLECT], 0	;   if(!player[1].reflect) {
	jrne.d	3				;     g = mirror(g)
	sll	%r10, 2				;     *delay*
	mirror	%r5, %r5			;   } (skip?)
	ext	tia_line_update_PLAYER1_SWITCH@ah
	ext	tia_line_update_PLAYER1_SWITCH@al
	ld.w	%r10, [%r10]
	xld.b	[%sp+9], %r9			;   [%sp+9] = player[1].position
	xld.w	[%sp+4], %r10			;   [%sp+4] = switch(player[1].size)
tia_line_update_NO_PLAYER1:			; }
	;
	xbtst	[%r0+MISSILE1_GRAPHICS], 0	; %r5[31:8] = g = missile[1].graphics && !missile[1].reset
	xjreq	tia_line_update_NO_MISSILE1
	xbtst	[%r0+MISSILE1_RESET], 0
	xjrne	tia_line_update_NO_MISSILE1	; if(g) {
	xoor	%r5, %r5, ~((1<<8)-1)
	xld.ub	%r9,  [%r0+MISSILE1_POSITION]	;   [%sp+12] = missile[1].position
	xld.ub	%r10, [%r0+MISSILE1_SIZE]	;   [%sp+13] = missile[1].size
	xld.b	[%sp+12], %r9
	xld.b	[%sp+13], %r10
tia_line_update_NO_MISSILE1:			; }
	;
	xld.ub	%r6, [%r0+BALL_DELAY]		; %r6 = g = ball.graphics[ball.delay]
	add	%r6, %r0
	xld.ub	%r6, [%r6+BALL_GRAPHICS]
	xcmp	%r6, 0				; if(g) {
	xjreq	tia_line_update_NO_BALL
	xld.ub	%r9,  [%r0+BALL_POSITION]	;   [%sp+14] = ball.position
	xld.ub	%r10, [%r0+BALL_SIZE]		;   [%sp+15] = ball.size
	xld.b	[%sp+14], %r9
	xld.b	[%sp+15], %r10
tia_line_update_NO_BALL:			; }
	;
	xld.w	%r7, [%r0+PLAYFIELD_GRAPHICS]	; %r7[19: 0] = playfield.graphics
	xbtst	[%r0+PLAYFIELD_REFLECT], 0	; %r7[31:20] = playfield.reflect
	xjreq	tia_line_update_NO_PF_REFLECT
	xoor	%r7, %r7, ~((1<<20)-1)
tia_line_update_NO_PF_REFLECT:
	;
	sub	%r14, %r13			; i = x2 - x1
tia_line_update_DO:				; do {
	;---------------------------------------;
	;	Player0
	;---------------------------------------;
	xand	%r10, %r4, (1<<8)-1		;   %r10 = g = player[0].graphics
	xjreq.d	tia_line_update_PLAYER0_EXIT	;   if(g) {
	ld.w	%r15, 0				;     %r15 = 0 *delay*
	;
	xld.ub	%r9, [%sp+8]			;     %r11 = x = x1 - player[0].position
	ld.w	%r11, %r13
	sub	%r11, %r9
	 xld.w	%r9, [%sp+0]			;     <-------------------+
	xjruge	tia_line_update_PLAYER0_L10	;     if(Carry) x += 160  |
	xadd	%r11, %r11, 160			;                         |
tia_line_update_PLAYER0_L10:			;                         |
	;					;                         |
	;xld.w	%r9, [%sp+0]			;     ֈړ -----------+
	jp	%r9				;     switch(player[0].size) {
	;
	.align	2 ;(Kv!!)
tia_line_update_PLAYER0_SWITCH:
	.word	tia_line_update_PLAYER0_SIZE0
	.word	tia_line_update_PLAYER0_SIZE1
	.word	tia_line_update_PLAYER0_SIZE2
	.word	tia_line_update_PLAYER0_SIZE3
	.word	tia_line_update_PLAYER0_SIZE4
	.word	tia_line_update_PLAYER0_SIZE5
	.word	tia_line_update_PLAYER0_SIZE6
	.word	tia_line_update_PLAYER0_SIZE7
	;
tia_line_update_PLAYER0_SIZE7:			;     case 7:
	xsrl	%r11, 1
	; FALLTHRU
tia_line_update_PLAYER0_SIZE5:			;     case 5:
	xcmp	%r11, 16
	xjruge	tia_line_update_PLAYER0_EXIT
	xjp.d	tia_line_update_PLAYER0_L20
	srl	%r11, 1				;     *delay*
	;
tia_line_update_PLAYER0_SIZE4:			;     case 4:
	xcmp	%r11, 8
	xjrult	tia_line_update_PLAYER0_L20
	xsub	%r11, %r11, 64
	xjp	tia_line_update_PLAYER0_SIZE0
	;
tia_line_update_PLAYER0_SIZE6:			;     case 6:
	xcmp	%r11, 8
	xjrult	tia_line_update_PLAYER0_L20
	xsub	%r11, %r11, 32
	; FALLTHRU
tia_line_update_PLAYER0_SIZE2:			;     case 2:
	xcmp	%r11, 8
	xjrult	tia_line_update_PLAYER0_L20
	xjp.d	tia_line_update_PLAYER0_SIZE0
	sub	%r11, 32			;     *delay*
	;
tia_line_update_PLAYER0_SIZE3:			;     case 3:
	xcmp	%r11, 8
	xjrult	tia_line_update_PLAYER0_L20
	xsub	%r11, %r11, 16
	; FALLTHRU
tia_line_update_PLAYER0_SIZE1:			;     case 1:
	xcmp	%r11, 8
	xjrult	tia_line_update_PLAYER0_L20
	xsub	%r11, %r11, 16
	; FALLTHRU
tia_line_update_PLAYER0_SIZE0:			;     case 0:
	xcmp	%r11, 8
	xjruge	tia_line_update_PLAYER0_EXIT
	; FALLTHRU
tia_line_update_PLAYER0_L20:			;     }
	;
	srl	%r10, %r11			;     %r15 |= (g >> x) & 1 (%r11=0..7Ȃ̂ŁAsrlŏ[)
	xand	%r10, %r10, 1
	or	%r15, %r10
	;
tia_line_update_PLAYER0_EXIT:			;   }
	;---------------------------------------;
	;	Missile0
	;---------------------------------------;
	xcmp	%r4, 0				;   if(%r4[31:8]) {
	xjrge.d	tia_line_update_MISSILE0_EXIT
	sll	%r15, 1				;     %r15 <<= 1 *delay*
	;
	xld.ub	%r9,  [%sp+10]			;     %r9  = missile[0].position
	xld.ub	%r10, [%sp+11]			;     %r10 = missile[0].size
	;
	ld.w	%r11, %r13			;     %r11 = x = x1 - missile[0].position
	sub	%r11, %r9
	xjruge	tia_line_update_MISSILE0_L10	;     if(Carry) x += 160
	xadd	%r11, %r11, 160
tia_line_update_MISSILE0_L10:
	;
	srl	%r11, %r10			;     %r15 |= !(x >> missile[0].size) (%r10=0..3Ȃ̂ŁAsrlŏ[)
	xjrne	tia_line_update_MISSILE0_EXIT
	xoor	%r15, %r15, 1
	;
tia_line_update_MISSILE0_EXIT:			;   }
	;---------------------------------------;
	;	Player1
	;---------------------------------------;
	xand	%r10, %r5, (1<<8)-1		;   %r10 = g = player[1].graphics
	xjreq.d	tia_line_update_PLAYER1_EXIT	;   if(g) {
	sll	%r15, 1				;     %r15 <<= 1 *delay*
	;
	xld.ub	%r9, [%sp+9]			;     %r11 = x = x1 - player[1].position
	ld.w	%r11, %r13
	sub	%r11, %r9
	 xld.w	%r9, [%sp+4]			;     <-------------------+
	xjruge	tia_line_update_PLAYER1_L10	;     if(Carry) x += 160  |
	xadd	%r11, %r11, 160			;                         |
tia_line_update_PLAYER1_L10:			;                         |
	;					;                         |
	;xld.w	%r9, [%sp+4]			;     ֈړ -----------+
	jp	%r9				;     switch(player[1].size) {
	;
	.align	2 ;(Kv!!)
tia_line_update_PLAYER1_SWITCH:
	.word	tia_line_update_PLAYER1_SIZE0
	.word	tia_line_update_PLAYER1_SIZE1
	.word	tia_line_update_PLAYER1_SIZE2
	.word	tia_line_update_PLAYER1_SIZE3
	.word	tia_line_update_PLAYER1_SIZE4
	.word	tia_line_update_PLAYER1_SIZE5
	.word	tia_line_update_PLAYER1_SIZE6
	.word	tia_line_update_PLAYER1_SIZE7
	;
tia_line_update_PLAYER1_SIZE7:			;     case 7:
	xsrl	%r11, 1
	; FALLTHRU
tia_line_update_PLAYER1_SIZE5:			;     case 5:
	xcmp	%r11, 16
	xjruge	tia_line_update_PLAYER1_EXIT
	xjp.d	tia_line_update_PLAYER1_L20
	srl	%r11, 1				;     *delay*
	;
tia_line_update_PLAYER1_SIZE4:			;     case 4:
	xcmp	%r11, 8
	xjrult	tia_line_update_PLAYER1_L20
	xsub	%r11, %r11, 64
	xjp	tia_line_update_PLAYER1_SIZE0
	;
tia_line_update_PLAYER1_SIZE6:			;     case 6:
	xcmp	%r11, 8
	xjrult	tia_line_update_PLAYER1_L20
	xsub	%r11, %r11, 32
	; FALLTHRU
tia_line_update_PLAYER1_SIZE2:			;     case 2:
	xcmp	%r11, 8
	xjrult	tia_line_update_PLAYER1_L20
	xjp.d	tia_line_update_PLAYER1_SIZE0
	sub	%r11, 32			;     *delay*
	;
tia_line_update_PLAYER1_SIZE3:			;     case 3:
	xcmp	%r11, 8
	xjrult	tia_line_update_PLAYER1_L20
	xsub	%r11, %r11, 16
	; FALLTHRU
tia_line_update_PLAYER1_SIZE1:			;     case 1:
	xcmp	%r11, 8
	xjrult	tia_line_update_PLAYER1_L20
	xsub	%r11, %r11, 16
	; FALLTHRU
tia_line_update_PLAYER1_SIZE0:			;     case 0:
	xcmp	%r11, 8
	xjruge	tia_line_update_PLAYER1_EXIT
	; FALLTHRU
tia_line_update_PLAYER1_L20:			;     }
	;
	srl	%r10, %r11			;     %r15 |= (g >> x) & 1 (%r11=0..7Ȃ̂ŁAsrlŏ[)
	xand	%r10, %r10, 1
	or	%r15, %r10
	;
tia_line_update_PLAYER1_EXIT:			;   }
	;---------------------------------------;
	;	Missile1
	;---------------------------------------;
	xcmp	%r5, 0				;   if(%r5[31:8]) {
	xjrge.d	tia_line_update_MISSILE1_EXIT
	sll	%r15, 1				;     %r15 <<= 1 *delay*
	;
	xld.ub	%r9,  [%sp+12]			;     %r9  = missile[1].position
	xld.ub	%r10, [%sp+13]			;     %r10 = missile[1].size
	;
	ld.w	%r11, %r13			;     %r11 = x = x1 - missile[1].position
	sub	%r11, %r9
	xjruge	tia_line_update_MISSILE1_L10	;     if(Carry) x += 160
	xadd	%r11, %r11, 160
tia_line_update_MISSILE1_L10:
	;
	srl	%r11, %r10			;     %r15 |= !(x >> missile[1].size) (%r10=0..3Ȃ̂ŁAsrlŏ[)
	xjrne	tia_line_update_MISSILE1_EXIT
	xoor	%r15, %r15, 1
	;
tia_line_update_MISSILE1_EXIT:			;   }
	;---------------------------------------;
	;	Ball
	;---------------------------------------;
	xcmp	%r6, 0				;   if(%r6) {
	xjreq.d	tia_line_update_BALL_EXIT
	sll	%r15, 1				;     %r15 <<= 1 *delay*
	;
	xld.ub	%r9,  [%sp+14]			;     %r9  = ball.position
	xld.ub	%r10, [%sp+15]			;     %r10 = ball.size
	;
	ld.w	%r11, %r13			;     %r11 = x = x1 - ball.position
	sub	%r11, %r9
	xjruge	tia_line_update_BALL_L10	;     if(Carry) x += 160
	xadd	%r11, %r11, 160
tia_line_update_BALL_L10:
	;
	srl	%r11, %r10			;     %r15 |= !(x >> ball.size) (%r10=0..3Ȃ̂ŁAsrlŏ[)
	xjrne	tia_line_update_BALL_EXIT
	xoor	%r15, %r15, 1
	;
tia_line_update_BALL_EXIT:			;   }
	;---------------------------------------;
	;	Playfield
	;---------------------------------------;
	xand	%r10, %r7, (1<<20)-1		;   %r10 = g = playfield.graphics
	xjreq.d	tia_line_update_PLAYFIELD_EXIT	;   if(g) {
	sll	%r15, 1				;     %r15 <<= 1 *delay*
	;
	ld.w	%r11, %r13			;     %r11 = x = x1 >> 2
	xsrl	%r11, 2
	;
	xsub	%r11, %r11, 20			;     x -= 20
	xjrult	tia_line_update_PLAYFIELD_L10	;     if(Carry) x = 19-(x+20) = -1-x = -(x+ 1) = ~(x+ 1)+1 = ~((x+ 1)-1) = ~(x   )
	xcmp	%r7, 0				;     if(!playfield.reflect) {
	xjrlt	tia_line_update_PLAYFIELD_L20	;               x = 39-(x+20) = 19-x = -(x-19) = ~(x-19)+1 = ~((x-19)-1) = ~(x-20)
	xsub	%r11, %r11, 20			;     }
tia_line_update_PLAYFIELD_L10:
	not	%r11, %r11
tia_line_update_PLAYFIELD_L20:
	;
	;xsrl	%r10, %r11			;     %r15 |= (g >> x) & 1 (%r11=0..19Ȃ̂ŁAxsrlKv!!)
	;* "xsrl %rd,%rs"ext33̎WJɔCƁA璷ŒxR[hɓWJĂ܂܂B
	;  %rd%rsʃWX^ŁA%rsj\ŁA%rs0..23͈̔͂ł邱Ƃ킩ĂȂ΁A
	;  Ƃňȉ̂悤ɓWJ邱ƂɂAext33̎WJR[hł܂B
	;- ̏ꏊł́A%r11͈̔͂0..19ł邱Ƃ킩Ă̂ŁA̕@Kp\łB
	;  Ȃȉ̂悤ɓWJł邩ɂẮAq̐QƂĂB
	;- - - - - - - - - - - - - - - - - - - -;
	cmp	%r11, 8				;
	jrle.d	6				; --------+
	srl	%r10, %r11			; *delay* |
	sub	%r11, 8				; (skip?) |
	srl	%r10, %r11			; (skip?) |
	and	%r11, 8				; (skip?) |
	srl	%r10, %r11			; (skip?) V
	;- - - - - - - - - - - - - - - - - - - -;
	xand	%r10, %r10, 1
	or	%r15, %r10
	;
tia_line_update_PLAYFIELD_EXIT:			;   }
	;---------------------------------------;
	ld.w	%r9, %r15			;   collision |= tia_collision_table[v]
	xsll	%r9, 1
	;ext	tia_collision_table@ah		;   ֈړ܂ ------------------+
	;ext	tia_collision_table@al		;   ֈړ܂ ------------------+
	;xld.uh	%r9, [%r9]			;   ֈړ܂ ------------------+
	;or	%r3, %r9			;   ֈړ܂ ------------------|--+
	;					;                                      |  |
	add	%r15, %r2			;   v = priority[v]                    |  |
	ld.ub	%r15, [%r15]			;                                      |  |
	 ext	tia_collision_table@ah		;   *anti-interlock* <-----------------+  |
	 ext	tia_collision_table@al		;   *anti-interlock* <-----------------+  |
	 xld.uh	%r9, [%r9]			;   *anti-interlock* <-----------------+  |
	cmp	%r15, %r12			;   if(CTRLPF[1:SCORE] && (v == 2)) {     |
	xjrne.d	tia_line_update_NO_SCORE	;                                         |
	 or	%r3, %r9			;     *delay* <---------------------------+
	xcmp	%r13, 80			;     v = (x1 < 80) ? 0 : 1
	xld.w	%r15, 1
	sbc	%r15, %r8
tia_line_update_NO_SCORE:			;   }
	ext	tia+CLUT@ah			;   *vbuff++ = p_tia->clut[v]
	ext	tia+CLUT@al
	ld.ub	%r15, [%r15]
	 xsub	%r14, %r14, 1			;   *anti-interlock* <------------+
	ld.b	[%r1]+, %r15			;                                 |
	;---------------------------------------;                                 |
	;xsub	%r14, %r14, 1			; } while(--i) ֈړ܂ --+
	xjrne.d	tia_line_update_DO
	add	%r13, 1				; x1++ *delay*
	;
	xld.h	[%r0+COLLISION], %r3		; p_tia->collision = collision /* ߂ */
	;
	xadd	%sp, %sp, 16
	popn	%r3
	;---------------------------------------;
tia_line_update_EXIT:
	ret

;****************************************************************************
;	
;****************************************************************************

	.global	tia_reduce
tia_reduce:
	xld.w	%r9, tia_div3_table		; ̃[`ŁA%r9j󂷂g߂gȂ悤AӂĂ!!
	;
	xld.w	%r10, 8				; z = 8
tia_reduce_DO_Z:				; do {
	;
	xld.w	%r11, 11			;   y = 11
	xld.w	%r15, 4				;   i = 4
tia_reduce_DO_Y:				;   do {
	;
	xld.w	%r14, 32			;     x = 32
	xsub	%r15, %r15, 1			;     if(!--i) {
	xjrne	tia_reduce_DO_X1
	;---------------------------------------;
tia_reduce_DO_X0:				;       do {
	xld.ub	%r4, [%r13+320]			;         %r4    =                                      src[320]
	xld.ub	%r5, [%r13+160]			;         %r5    =                           src[160]
	 ld.ub	%r6, [%r13]+			;         %r6    =                  src[0]
	add	%r4, %r5			;         %r4    =                           src[160] + src[320]
	add	%r4, %r6			;         %r4    =                  src[0] + src[160] + src[320]
	add	%r4, %r9			;         %r4    = &tia_div3_table[(src[0] + src[160] + src[320])];
	ld.ub	%r4, [%r4]			;         %r4    =  tia_div3_table[(src[0] + src[160] + src[320])];
	ld.b	[%r12]+, %r4			;         dst[0] =  tia_div3_table[(src[0] + src[160] + src[320])];
	;
	xld.ub	%r4, [%r13+320]			;         %r4    =                                      src[321]
	xld.ub	%r5, [%r13+160]			;         %r5    =                           src[161]
	 ld.ub	%r6, [%r13]+			;         %r6    =                  src[1]
	add	%r4, %r5			;         %r4    =                           src[161] + src[321]
	add	%r4, %r6			;         %r4    =                  src[1] + src[161] + src[321]
	add	%r4, %r9			;         %r4    = &tia_div3_table[(src[1] + src[161] + src[321])];
	ld.ub	%r4, [%r4]			;         %r4    =  tia_div3_table[(src[1] + src[161] + src[321])];
	ld.b	[%r12]+, %r4			;         dst[1] =  tia_div3_table[(src[1] + src[161] + src[321])];
	;
	xld.ub	%r4, [%r13+320]			;         %r4    =                                      src[322]
	xld.ub	%r5, [%r13+160]			;         %r5    =                           src[162]
	 ld.ub	%r6, [%r13]+			;         %r6    =                  src[2]
	add	%r4, %r5			;         %r4    =                           src[162] + src[322]
	add	%r4, %r6			;         %r4    =                  src[2] + src[162] + src[322]
	add	%r4, %r9			;         %r4    = &tia_div3_table[(src[2] + src[162] + src[322])];
	ld.ub	%r4, [%r4]			;         %r4    =  tia_div3_table[(src[2] + src[162] + src[322])];
	ld.b	[%r12]+, %r4			;         dst[2] =  tia_div3_table[(src[2] + src[162] + src[322])];
	;
	xld.ub	%r4, [%r13+320]			;         %r4    =                                      src[323]
	xld.ub	%r5, [%r13+160]			;         %r5    =                           src[163]
	 ld.ub	%r6, [%r13]+			;         %r6    =                  src[3]
	add	%r4, %r5			;         %r4    =                           src[163] + src[323]
	add	%r4, %r6			;         %r4    =                  src[3] + src[163] + src[323]
	xld.ub	%r5, [%r13+320]			;         %r5    =                                                                     src[324]
	xld.ub	%r6, [%r13+160]			;         %r6    =                                                          src[164]
	 ld.ub	%r7, [%r13]+			;         %r7    =                                                 src[4]
	add	%r4, %r5			;         %r4    =                  src[3] + src[163] + src[323] +                     src[324]
	add	%r4, %r6			;         %r4    =                  src[3] + src[163] + src[323] +          src[164] + src[324]
	add	%r4, %r7			;         %r4    =                  src[3] + src[163] + src[323] + src[4] + src[164] + src[324]
	xsrl	%r4, 1				;         %r4    =                 (src[3] + src[163] + src[323] + src[4] + src[164] + src[324]) >> 1
	add	%r4, %r9			;         %r4    = &tia_div3_table[(src[3] + src[163] + src[323] + src[4] + src[164] + src[324]) >> 1]
	ld.ub	%r4, [%r4]			;         %r4    =  tia_div3_table[(src[3] + src[163] + src[323] + src[4] + src[164] + src[324]) >> 1]
	ld.b	[%r12]+, %r4			;         dst[3] =  tia_div3_table[(src[3] + src[163] + src[323] + src[4] + src[164] + src[324]) >> 1]
	;
	xsub	%r14, %r14, 1			;       } while(x)
	xjrne	tia_reduce_DO_X0
	xadd	%r13, %r13, 320			;       src += 320
	xjp.d	tia_reduce_LOOP_Y
	ld.w	%r15, 4				;       i = 4 *delay*
	;---------------------------------------;     } else {
tia_reduce_DO_X1:				;       do {
	xld.ub	%r4, [%r13+160]			;         %r4    =           src[160]
	 ld.ub	%r5, [%r13]+			;         %r5    =  src[0]
	add	%r4, %r5			;         %r4    =  src[0] + src[160]
	xsrl	%r4, 1				;         %r4    = (src[0] + src[160]) >> 1
	ld.b	[%r12]+, %r4			;         dst[0] = (src[0] + src[160]) >> 1
	;
	xld.ub	%r4, [%r13+160]			;         %r4    =           src[161]
	 ld.ub	%r5, [%r13]+			;         %r5    =  src[1]
	add	%r4, %r5			;         %r4    =  src[1] + src[161]
	xsrl	%r4, 1				;         %r4    = (src[1] + src[161]) >> 1
	ld.b	[%r12]+, %r4			;         dst[1] = (src[1] + src[161]) >> 1
	;
	xld.ub	%r4, [%r13+160]			;         %r4    =           src[162]
	 ld.ub	%r5, [%r13]+			;         %r5    =  src[2]
	add	%r4, %r5			;         %r4    =  src[2] + src[162]
	xsrl	%r4, 1				;         %r4    = (src[2] + src[162]) >> 1
	ld.b	[%r12]+, %r4			;         dst[2] = (src[2] + src[162]) >> 1
	;
	xld.ub	%r4, [%r13+160]			;         %r4    =           src[163]
	 ld.ub	%r5, [%r13]+			;         %r5    =  src[3]
	xld.ub	%r6, [%r13+160]			;         %r4    =                               src[164]
	 ld.ub	%r7, [%r13]+			;         %r5    =                      src[4]
	add	%r4, %r5			;         %r4    =  src[3] + src[163]
	add	%r4, %r6			;         %r4    =  src[3] + src[163]          + src[164]
	add	%r4, %r7			;         %r4    =  src[3] + src[163] + src[4] + src[164]
	xsrl	%r4, 2				;         %r4    = (src[3] + src[163] + src[4] + src[164]) >> 2
	ld.b	[%r12]+, %r4			;         dst[3] = (src[3] + src[163] + src[4] + src[164]) >> 2
	;
	xsub	%r14, %r14, 1			;       } while(x)
	xjrne	tia_reduce_DO_X1
	xadd	%r13, %r13, 160			;       src += 160
	;---------------------------------------;     }
tia_reduce_LOOP_Y:
	xsub	%r11, %r11, 1			;   } while(y)
	xjrne	tia_reduce_DO_Y
	;
	xsub	%r10, %r10, 1			; } while(z)
	xjrne	tia_reduce_DO_Z
	ret

;****************************************************************************
;	
;****************************************************************************

;------------------------------------------------------------------------------------------------------------------------
;
;	========================================================
;	"xsrl %rd,%rs"̍ɂ (2005/03/22 Naoyuki Sawa)
;	========================================================
;
;	1. %rd%rsWX^łȂƁB(ʏA肦Ȃ͂)
;	2. xsrlɁA%rs̒lςĂĂ\ȂƁB
;	3. %rs͈̔͂0..23ł邱Ƃ炩߂킩Ă邱ƁB
;
;	ȏ3̏𖞂ꍇAȉ̂悤ɓWJčł܂B
;
;		cmp	%rs, 8
;		jrle.d	7		; ------------------+
;		srl	%rd, %rs	; *delay*           |
;		sub	%rs, 8		; (skip?)           |
;		cmp	%rs, 8		; (skip?)           |
;		jrlt.d	3		; (skip?) --------+ |
;		srl	%rd, %rs	; (skip?) *delay* | |
;		srl	%rd, %rs	; (skip?) (skip?) V V
;
;	̕@́Asrl߂̎VtgA%rs[3:0]̃rbgp^[ɂĂ̂݌肳邱Ƃ𗘗pĂ܂B
;
;		%rs[3:0]	Vtg
;		--------	--------
;		  0000		   0
;		  0001		   1
;		  0010		   2
;		  0011		   3
;		  0100		   4
;		  0101		   5
;		  0110		   6
;		  0111		   7
;		  1xxx		   8		(%rs[3]=1Ȃ΁A%rs[2:0]̃p^[ɂ炸8rbgVtg)
;		--------	--------
;
;	Oq̓WJR[hɂāA%rs̏l0..23ɑΉ鏈̗́Â悤ɂȂ܂B
;
;	=========================================================================================
;	%rs	l	1ڂ		8ϲŽ	8ϲŽ	2ڂ		3ڂ
;	l	ޯ	Đ	̒l	ޯ	Đ	Đ
;	=========================================================================================
;	 0	00000000	>>0
;	 1	00000001	>>1
;	 2	00000010	>>2
;	 3	00000011	>>3
;	 4	00000100	>>4
;	 5	00000101	>>5
;	 6	00000110	>>6
;	 7	00000111	>>7
;	 8	00001000	>>8
;	-----------------------------------------------------------------------------------------
;	 9	00001001	>>8		 1	00000001	>>1
;	10	00001010	>>8		 2	00000010	>>2
;	11	00001011	>>8		 3	00000011	>>3
;	12	00001100	>>8		 4	00000100	>>4
;	13	00001101	>>8		 5	00000101	>>5
;	14	00001110	>>8		 6	00000110	>>6
;	15	00001111	>>8		 7	00000111	>>7
;	-----------------------------------------------------------------------------------------
;	16	00010000	>>0		 8	00001000	>>8		>>8
;	17	00010001	>>1		 9	00001001	>>8		>>8
;	18	00010010	>>2		10	00001010	>>8		>>8
;	19	00010011	>>3		11	00001011	>>8		>>8
;	20	00010100	>>4		12	00001100	>>8		>>8
;	21	00010101	>>5		13	00001101	>>8		>>8
;	22	00010110	>>6		14	00001110	>>8		>>8
;	23	00010111	>>7		15	00001111	>>8		>>8
;	=========================================================================================
;
;	%rs͈̔͂15̏ꍇA31̏ꍇAR[hύXāA̍Z@KpłƎv܂B
;
;------------------------------------------------------------------------------------------------------------------------
;2005/03/23 ǋL: Ɨǂ@܂B
;------------------------------------------------------------------------------------------------------------------------
;
;	========================================================
;	"xsrl %rd,%rs"̍ɂ (2005/03/23 Naoyuki Sawa)
;	========================================================
;
;	1. %rd%rsWX^łȂƁB(ʏA肦Ȃ͂)
;	2. xsrlɁA%rs̒lςĂĂ\ȂƁB
;	3. %rs͈̔͂0..23ł邱Ƃ炩߂킩Ă邱ƁB
;
;	ȏ3̏𖞂ꍇAȉ̂悤ɓWJčł܂B
;
;		cmp	%rs, 8
;		jrle.d	6		; --------+
;		srl	%rd, %rs	; *delay* |
;		sub	%rs, 8		; (skip?) |
;		srl	%rd, %rs	; (skip?) |
;		and	%rs, 8		; (skip?) |
;		srl	%rd, %rs	; (skip?) V
;
;	̕@́Asrl߂̎VtgA%rs[3:0]̃rbgp^[ɂĂ̂݌肳邱Ƃ𗘗pĂ܂B
;
;		%rs[3:0]	Vtg
;		--------	--------
;		  0000		   0
;		  0001		   1
;		  0010		   2
;		  0011		   3
;		  0100		   4
;		  0101		   5
;		  0110		   6
;		  0111		   7
;		  1xxx		   8		(%rs[3]=1Ȃ΁A%rs[2:0]̃p^[ɂ炸8rbgVtg)
;		--------	--------
;
;	Oq̓WJR[hɂāA%rs̏l0..23ɑΉ鏈̗́Â悤ɂȂ܂B
;
;	=================================================================================================================
;	%rs	l	1ڂ		8ϲŽ	8ϲŽ	2ڂ		And8	And8	3ڂ
;	l	ޯ	Đ	̒l	ޯ	Đ	̒l	ޯ	Đ
;	=================================================================================================================
;	 0	00000000	>>0
;	 1	00000001	>>1
;	 2	00000010	>>2
;	 3	00000011	>>3
;	 4	00000100	>>4
;	 5	00000101	>>5
;	 6	00000110	>>6
;	 7	00000111	>>7
;	 8	00001000	>>8
;	-----------------------------------------------------------------------------------------------------------------
;	 9	00001001	>>8		 1	00000001	>>1		0	00000000	>>0
;	10	00001010	>>8		 2	00000010	>>2		0	00000000	>>0
;	11	00001011	>>8		 3	00000011	>>3		0	00000000	>>0
;	12	00001100	>>8		 4	00000100	>>4		0	00000000	>>0
;	13	00001101	>>8		 5	00000101	>>5		0	00000000	>>0
;	14	00001110	>>8		 6	00000110	>>6		0	00000000	>>0
;	15	00001111	>>8		 7	00000111	>>7		0	00000000	>>0
;	-----------------------------------------------------------------------------------------------------------------
;	16	00010000	>>0		 8	00001000	>>8		8	00001000	>>8
;	17	00010001	>>1		 9	00001001	>>8		8	00001000	>>8
;	18	00010010	>>2		10	00001010	>>8		8	00001000	>>8
;	19	00010011	>>3		11	00001011	>>8		8	00001000	>>8
;	20	00010100	>>4		12	00001100	>>8		8	00001000	>>8
;	21	00010101	>>5		13	00001101	>>8		8	00001000	>>8
;	22	00010110	>>6		14	00001110	>>8		8	00001000	>>8
;	23	00010111	>>7		15	00001111	>>8		8	00001000	>>8
;	=================================================================================================================
;
;------------------------------------------------------------------------------------------------------------------------

;****************************************************************************
;	
;****************************************************************************

	.global tia_volume_shift
tia_volume_shift:
	; %r12 = wbuff
	xld.w %r13, TIABUFLEN
	xld.w %r4, 32767
	not %r5, %r4			; -32768
tia_volume_shift_DO:
	ld.h %r6, [%r12]
	xsll %r6, TIA_VOLUME_SHIFT 
	cmp %r6, %r4
	jrle.d 3
	cmp %r6, %r5			; *delay*
	ld.w %r6, %r4			; (skip?)
	jrge.d 3
	sub %r13, 1			; *delay*
	ld.w %r6, %r5			; (skip?)
	ld.h [%r12]+, %r6
	xjrne tia_volume_shift_DO
	ret

;****************************************************************************
;	
;****************************************************************************

#endif /*TIA_ASM*/
