/*	
 *	clipudp.h
 *
 *	UDPvgRhCo
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Wed Sep 07 03:55:00 JST 2005 Naoyuki Sawa
 *	- 1st [XB
 *	* Tue Sep 20 19:51:00 JST 2005 Naoyuki Sawa
 *	- udp_open()local_port=0Ȃ΁AGtF|[g蓖Ă悤ύX܂B
 *	* Fri Sep 23 02:34:00 JST 2005 Naoyuki Sawa
 *	- udp_socket_open()̎ML[eʂAȂƂ1480oCgȏɐ؂グ悤ύX܂B
 */
#ifndef __CLIP_UDP_H__
#define __CLIP_UDP_H__

/****************************************************************************
 *	UDPvgRhCo
 ****************************************************************************/

typedef struct _UDPCLIENT UDPCLIENT;

/* UDPCLIENT.recv : MR[obÑvg^Cv */
typedef void UDPRECV(UDPCLIENT* client,
	int remote_ip_address,			/* MIPAhX */
	int remote_port,			/* M|[g */
	const unsigned char* data/*[length]*/,	/* UDPf[^Õf[^ */
	int length);				/* UDPf[^Õf[^ */

/* NCAgo^p̍\ */
/*typedef*/ struct _UDPCLIENT {

	/*------------------------------------------------------------------------------*
	 *	udp_open()ĂяoOɁAAvP[VɂĐݒ肵ĂtB[hB	*
	 *	udp_open()ĂяóAύXĂ͂ȂB			*
	 *------------------------------------------------------------------------------*/

	int local_port;		/* [J|[g (ȗ=0)
				 * ȗƁAIɃGtF|[g蓖Ă܂B
				 */

	UDPRECV* recv;		/* MR[obN (NULL:) */

	/*------------------------------------------------------------------------------*
	 *	UDPvgRhCoAŎgptB[hB			*
	 *	AvP[V́Aȉ̃tB[hɃANZXĂ͂ȂB		*
	 *------------------------------------------------------------------------------*/

	LIST_ENTRY list_entry;	/* NCAgXg */

} /*UDPCLIENT*/;

/*--------------------------------------------------------------------------*/

/* UDPvgRhCoJn܂B
 * [note]
 *	* udp_start()ĂяoAvP[V́AIOɕKAudp_stop()ĂяoĂB
 *	  udp_stop()ĂяoɃAvP[VIƁAP/ECEVXeُ퓮N܂B
 *	* udp_open()ĂяoăNCAgo^OɁAKAudp_start()ĂяoĂB
 * [interrupt]
 *	ʏ폈		荞݋Ԃł̌Ăяo	
 *	ʏ폈		荞݋֎~Ԃł̌Ăяo	
 *	荞ݏ		荞݋֎~Ԃł̌Ăяo	~
 */
void udp_start();

/* UDPvgRhCo~܂B
 * [note]
 *	* udp_stop()́AɈSɌĂяo\łB
 *	  udp_start()ĂяoĂȂĂAłAłAudp_stop()Ăяoč\܂B
 *	* udp_stop()ĂяoƁAo^ĂNCAǵAIɂׂēo^܂B
 *	  udp_stop()ĂяoOɁAX̃NCAgAIɓo^Kv͂܂B
 *	  ܂Audp_stop()ĂяoɁAudp_close()ĂяoĂ͂܂B
 * [interrupt]
 *	ʏ폈		荞݋Ԃł̌Ăяo	
 *	ʏ폈		荞݋֎~Ԃł̌Ăяo	
 *	荞ݏ		荞݋֎~Ԃł̌Ăяo	~
 */
void udp_stop();

/* ̃|[gANCAgo^܂B
 * [in]
 *	client			ĂяoɂĊmۂANCAgo^p̍\́B
 *				etB[hA炩ߓK؂ɏĂĂB
 * [note]
 *	* |[gNCAgAɓȏo^悤ƂƁAG[I܂B
 *	* NCAgo^p̍\̂́AUDPvgRhCõXgɃN܂B
 *	  udp_close()Ăяoēo^܂ŁA\̂JĂ͂܂B
 * [interrupt]
 *	ʏ폈		荞݋Ԃł̌Ăяo	
 *	ʏ폈		荞݋֎~Ԃł̌Ăяo	
 *	荞ݏ		荞݋֎~Ԃł̌Ăяo	@\AȂ
 */
void udp_open(UDPCLIENT* client);

/* o^ς݃NCAgAo^܂B
 * [in]
 *	client			o^ς݃NCAg̍\́B
 * [note]
 *	* o^̃NCAgo^悤ƂƁAG[I܂B
 * [interrupt]
 *	ʏ폈		荞݋Ԃł̌Ăяo	
 *	ʏ폈		荞݋֎~Ԃł̌Ăяo	
 *	荞ݏ		荞݋֎~Ԃł̌Ăяo	@\AȂ
 */
void udp_close(UDPCLIENT* client);

/* UDPf[^O𑗐M܂B
 * [in]
 *	client			o^ς݃NCAg̍\́A܂́ANULLB
 *				NULLw肵ꍇAM|[g=0(w)őM܂B
 *	remote_ip_address	ĐIPAhXB
 *	remote_port		Đ|[gB
 *	data			UDPf[^Õf[^B(0oCgȏ)
 *	length			UDPf[^Õf[^B  (0      ȏ)
 * [out]
 *	߂l			Ȃ΁Af[^(length̒l)̂܂ܕԂ܂B(0A܂́A)
 *				ML[ςőMłȂꍇAԂ܂B
 * [note]
 *	* 0oCg̃f[^𑗐M邱Ƃ\łB(UDPwb_ŁAf[^̖pPbg)
 *	  ߂lu0v́AӖ邱ƂɒӂĂB
 *	* ubLOAmubLŐɂẮAip_send()̃RgQƂĂB
 * [interrupt]
 *	ʏ폈		荞݋Ԃł̌Ăяo	
 *	ʏ폈		荞݋֎~Ԃł̌Ăяo	
 *	荞ݏ		荞݋֎~Ԃł̌Ăяo	
 */
int udp_send(UDPCLIENT* client, int remote_ip_address, int remote_port, const void* data/*[length]*/, int length);

/****************************************************************************
 *	UDP\Pbg
 ****************************************************************************/

/* UDP\Pbg\ */
typedef struct _UDPSOCKET {
	UDPCLIENT udp_client;	/* UDPNCAgo^p */
	QUEUE* rxque;		/* ML[ */
} UDPSOCKET;

/*--------------------------------------------------------------------------*/

/* UDP\PbgJ܂B
 * [in]
 *	local_port		[J|[gB(ȗ=0)
 *				ȗƁAIɃGtF|[g蓖Ă܂B
 *	rxque_capacity		ML[eʁB
 *				rxque_capacity1480w肳ꂽꍇA1480ɐ؂グĊmۂ܂B
 *				EthernetɂAUDPf[^O̍ő咷́A1480oCgłB
 *				(IPf[^OtOgȂꍇBUDPwb_8oCg܂ށB)
 *				    Ethernetڰ(1514) - Ethernetͯ(14) - IPͯ(20) = 1480
 *				2005/09/23݁AIPf[^ÕtOgɑΉĂȂ߁A
 *				q̎dlƂ܂ȂΉɂA\܂B
 * [out]
 *	߂l			UDP\PbgB
 * [interrupt]
 *	ʏ폈		荞݋Ԃł̌Ăяo	
 *	ʏ폈		荞݋֎~Ԃł̌Ăяo	
 *	荞ݏ		荞݋֎~Ԃł̌Ăяo	~
 */
UDPSOCKET* udp_socket_open(int local_port, int rxque_capacity);

/* UDP\Pbg܂B
 * [in]
 *	udp_socket		UDP\PbgB
 * [interrupt]
 *	ʏ폈		荞݋Ԃł̌Ăяo	
 *	ʏ폈		荞݋֎~Ԃł̌Ăяo	
 *	荞ݏ		荞݋֎~Ԃł̌Ăяo	~
 */
void udp_socket_close(UDPSOCKET* udp_socket);

/* ML[AMς݃pPbg̃f[^o܂B
 * [in]
 *	udp_socket		UDP\PbgB
 *	remote_ip_address	ɁAMIPAhXi[ϐւ̃|C^B
 *				NULLȂ΁AMIPAhXi[܂B
 *	remote_port		ɁAM|[gi[ϐւ̃|C^B
 *				NULLȂ΁AM|[gi[܂B
 *	data			ɁAMf[^i[obt@ւ̃|C^B
 *	length			Mf[^i[obt@eʁB
 * [out]
 *	߂l			Ȃ΁AۂɎMf[^Ԃ܂B(0A܂́A)
 *				ML[A܂́Aobt@eʕsȂ΁AԂ܂B
 * [note]
 *	* 0oCg̃f[^M邱ƂL蓾܂B(UDPwb_ŁAf[^̖pPbg)
 *	  ߂lu0v́AӖ邱ƂɒӂĂB
 * [interrupt]
 *	ʏ폈		荞݋Ԃł̌Ăяo	
 *	ʏ폈		荞݋֎~Ԃł̌Ăяo	
 *	荞ݏ		荞݋֎~Ԃł̌Ăяo	~
 */
int udp_socket_recv(UDPSOCKET* udp_socket, int* remote_ip_address, int* remote_port, void* data/*[length]*/, int length);

/* f[^𑗐M܂B
 * [in]
 *	udp_socket		UDP\PbgB
 *				NULLw肵ꍇAM|[g=0(w)őM܂B
 *	remote_ip_address	ĐIPAhXB
 *	remote_port		Đ|[gB
 *	data			Mf[^B
 *	length			Mf[^B
 * [out]
 *	߂l			Ȃ΁Af[^(length̒l)̂܂ܕԂ܂B(0A܂́A)
 *				ML[ςőMłȂꍇAԂ܂B
 * [note]
 *	* 0oCg̃f[^𑗐M邱Ƃ\łB(UDPwb_ŁAf[^̖pPbg)
 *	  ߂lu0v́AӖ邱ƂɒӂĂB
 * [interrupt]
 *	ʏ폈		荞݋Ԃł̌Ăяo	
 *	ʏ폈		荞݋֎~Ԃł̌Ăяo	
 *	荞ݏ		荞݋֎~Ԃł̌Ăяo	~
 */
int udp_socket_send(UDPSOCKET* udp_socket, int remote_ip_address, int remote_port, const void* data/*[length]*/, int length);

#endif /*__CLIP_UDP_H__*/
