/*	
 *	clipptp.h
 *
 *	USB PTP Responder (Picture Transfer Protocol), USB MTP Responder (Media Transfer Protocol)
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2014 Naoyuki Sawa
 *
 *	* Fri Sep 05 21:36:08 JST 2014 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Sep 06 23:41:20 JST 2014 Naoyuki Sawa
 *	- Xg[ŃG[ʒḿAł悤ɂȂ܂B
 *	  ڍׂ́AuG[̕@ɂāv́u2014/09/06ǋLvQƂĂB
 *	* Sun Sep 14 02:44:46 JST 2014 Naoyuki Sawa
 *	- fnCXf[^Zbg(DeviceInfo Dataset)ImageFormatsɁAUndefinedǉ܂B
 *	  ̕ύXɂAWindows7P/ECE֏ނƂAx\Ă肪܂B
 *	- IuWFNgf[^ZbgObjectFormatAVendorDefinedUndefinedɕύX܂B
 *	  Cӂ̊gqꍇ́AVendorDefinedUndefined̕K؂̂悤łB
 *	  IuWFNgf[^ZbgObjectFormat͂ǂłe悤łAm̂߂VendorDefinedUndefinedɕύXĂƂɂ܂B
 *	- PTP_Start()ɈbMTPǉAMTPfoCXƂēł悤ɂ܂B
 *	 ܂AWindowsMTPfoCXƂĔF悤ɂŁAMTPL͉̓Ă܂B
 *	- MTP Extension format codesǉ܂B
 *	  fnCXf[^Zbg(DeviceInfo Dataset)ImageFormatsɁAMTP Extension format codesǉ܂B
 *	  ̕ύXɂA*.xls*.docނƂɂAx\ȂȂ܂B(܂*.exe͌xo܂B)
 *	  MTP Extension format codeśAMTPłȂPTPƂē삵Ă鎞LłB
 *	* Mon Sep 15 02:07:06 JST 2014 Naoyuki Sawa
 *	- MTP Extension operation codes,MTP Extension response codes,MTP Extension event codes,MTP Extension device properties,MTP Extension protection statusesǉ܂B
 *	- ObjectPropertyǉ܂B
 *	* Mon Sep 15 19:28:40 JST 2014 Naoyuki Sawa
 *	- Get/Set,FormFlag,MTP Extension form flagsǉ܂B
 *	* Mon Sep 15 21:24:52 JST 2014 Naoyuki Sawa
 *	- MTP̃Iy[V(GetObjectPropsSupported,GetObjectPropDesc,GetObjectPropValue)܂B
 *	  V{USE_MTP_OPERATION`ƁA샂[h(PTP/MTP)Ɋ֌WÃIy[VLɂȂ܂B
 *	  V{USE_MTP_OPERATION`Ȃ΁A샂[h(PTP/MTP)Ɋ֌WÃIy[VɂȂ܂B
 *	  '샂[h(PTP/MTP)Ɋ֌W'Ƃ́AWindows7́APTPƂĔFfoCXłĂAMTP̃Iy[VΉĂ΁AMTP̃Iy[Vgpē삷悤łB
 *	  '샂[h(PTP/MTP)Ɋ֌W'Ƃ́AWindows7́AMTPƂĔFfoCXłĂAMTP̃Iy[VΉĂȂ΁APTP̃Iy[V݂̂œ삷悤łB
 *	* Sat Sep 20 08:44:17 JST 2014 Naoyuki Sawa
 *	- FRAM4̈ޔp1ɂAŜ狤pł悤ɂȂ܂B
 *	  ڍׂ́Aclippce.ćut@C݌n֐̔rṽRgƁuFRAM4̈̑ޔ𕜌vQƂĂB
 */
#ifndef __CLIP_PTP_H__
#define __CLIP_PTP_H__

/****************************************************************************
 *	v_NgID
 ****************************************************************************/
//ydvzPTPMTPID𓯂ɂĂ͂ȂB
//WindowśAUSBfoCXŏɐڑꂽAMS OS String Descriptor擾ł邩ǂ݁Aʂ[HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\usbflags]ɕۑB
//ȍ~̐ڑł́AMS OS String DescriptorĎ擾Ȃ悤B
//PTPMTPłMS OS String Descriptor̋قȂ邪AIDŔFꂽɓIDŋςĂWindowsFȂB
//̖邽߂ɁAPTPMTPIDʂɂKvLB
//AMTPƂĔFꂽ́A[HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\USB\VID_0E19&PID_1019\`\CompatibleIDs]ɁuUSB\MS_COMP_MTPv܂܂Ă邩ǂΔB
#define PTP_PRODUCT_ID	(PCE_PRODUCT_ID+0x18)	/* d֎~!! */
#define MTP_PRODUCT_ID	(PCE_PRODUCT_ID+0x19)	/* d֎~!! */

/****************************************************************************
 *	PTPdlɌW`
 ****************************************************************************/
/* QƎ:uPIMA 15740:2000 Approved 2000-07-05 FIRST EDITIONv(pima15740-2000.pdf) */
/*--------------------------------------------------------------------------*/
/* ContainerType */
#define PTP_ContainerType_Undefined				0
#define PTP_ContainerType_CommandBlock				1
#define PTP_ContainerType_DataBlock				2
#define PTP_ContainerType_ResponseBlock				3
#define PTP_ContainerType_EventBlock				4
/*--------------------------------------------------------------------------*/
/* D.7.1.1 Generic Container Structure
 * The generic structure of the containers used by a PIMA15740 compatible Still Image Capture Device follows. */
typedef struct _PTP_GenericContainerStructure {
	uint32_t ContainerLength;	//+ 0,4 This field encodes as an unsigned integer the number of bytes in this container. A Still Image Capture Device uses this field to determine the size of the container.
	uint16_t ContainerType;		//+ 4,2 This field describes the type of the container: 0 undefined 1 Command Block 2 Data Block 3 Response Block 4 Event Block otherwise reserved
	uint16_t Code;			//+ 6,2 This field contains the PIMA15740 OperationCode, ResponseCode, or EventCode. The Data Block will use the OperationCode from the Command Block
	uint32_t TransactionID;		//+ 8,4 This is a host generated number that associates all phases of an PIMA15740 operation.
	uint8_t  Payload[0];		//+12,? The contents of this field depend on the operation and phase of the PIMA15740 operation.
} PTP_GenericContainerStructure;	//=12+?
/*--------------------------------------------------------------------------*/
/* OperationCode */
#define PTP_OperationCode_Undefined				0x1000
#define PTP_OperationCode_GetDeviceInfo				0x1001
#define PTP_OperationCode_OpenSession				0x1002
#define PTP_OperationCode_CloseSession				0x1003
#define PTP_OperationCode_GetStorageIDs				0x1004
#define PTP_OperationCode_GetStorageInfo			0x1005
#define PTP_OperationCode_GetNumObjects				0x1006
#define PTP_OperationCode_GetObjectHandles			0x1007
#define PTP_OperationCode_GetObjectInfo				0x1008
#define PTP_OperationCode_GetObject				0x1009
#define PTP_OperationCode_GetThumb				0x100A
#define PTP_OperationCode_DeleteObject				0x100B
#define PTP_OperationCode_SendObjectInfo			0x100C
#define PTP_OperationCode_SendObject				0x100D
#define PTP_OperationCode_InitiateCapture			0x100E
#define PTP_OperationCode_FormatStore				0x100F
#define PTP_OperationCode_ResetDevice				0x1010
#define PTP_OperationCode_SelfTest				0x1011
#define PTP_OperationCode_SetObjectProtection			0x1012
#define PTP_OperationCode_PowerDown				0x1013
#define PTP_OperationCode_GetDevicePropDesc			0x1014
#define PTP_OperationCode_GetDevicePropValue			0x1015
#define PTP_OperationCode_SetDevicePropValue			0x1016
#define PTP_OperationCode_ResetDevicePropValue			0x1017
#define PTP_OperationCode_TerminateOpenCapture			0x1018
#define PTP_OperationCode_MoveObject				0x1019
#define PTP_OperationCode_CopyObject				0x101A
#define PTP_OperationCode_GetPartialObject			0x101B
#define PTP_OperationCode_InitiateOpenCapture			0x101C
//#define PTP_OperationCode_Reserved				0x1000/*+?*/	//All other codes with MSN of 0001
#define PTP_OperationCode_VendorExtended			0x9000/*+?*/	//All codes with MSN of 1001
/*--- MTP Extension operation codes ---*/
#define MTP_OperationCode_GetObjectPropsSupported		0x9801
#define MTP_OperationCode_GetObjectPropDesc			0x9802
#define MTP_OperationCode_GetObjectPropValue			0x9803
#define MTP_OperationCode_SetObjectPropValue			0x9804
#define MTP_OperationCode_GetObjectPropList			0x9805		//Enhanced Operation
#define MTP_OperationCode_SetObjectPropList			0x9806		//Enhanced Operation
#define MTP_OperationCode_GetInterdependentPropDesc		0x9807		//Enhanced Operation
#define MTP_OperationCode_SendObjectPropList			0x9808		//Enhanced Operation
#define MTP_OperationCode_GetObjectReferences			0x9810
#define MTP_OperationCode_SetObjectReferences			0x9811
#define MTP_OperationCode_Skip					0x9820
/*--------------------------------------------------------------------------*/
/* 9.3.2 Operation Request Phase
 * The operation request phase consists of the transport-specific transmission of a 30-byte operation dataset from the Initiator to the Responder.
 * The following table describes the fields that must be accounted for by the Responder in order for the OperationRequest phase to be considered complete: */
typedef struct _PTP_OperationRequestDataset {
	uint16_t OperationCode;		//The code indicating which operation is being initiated. For a list of these codes and their usages, refer to Clause 10.2.
//sv	uint32_t SessionID;		//The identifier for the session within which this operation is being initiated. This value is assigned by the Initiator using the OpenSession operation. This field should be set to 0x00000000 for operations that do not occur within a session, and for the OpenSession OperationRequest dataset. Refer to Clause 9.2.1 for a description of SessionIDs.
//sv	uint32_t TransactionID;		//The identifier of this particular transaction. This value shall be a value that is unique within a particular session, and shall increment by one for each subsequent transaction. Refer to Clause 9.3.1 for a description of transaction identifiers. This field should be set to 0x00000000 for the OpenSession operation.
	uint32_t Parameter[5];		//This field holds the operation-specific nth parameter. Operations may have at most five parameters. The interpretation of any parameter is dependent upon the OperationCode. Any unused parameter fields should be set to 0x00000000. If a parameter holds a value that is less than 32 bits, the lowest significant bits shall be used to store the value, with the most significant bits being set to zeros.
} PTP_OperationRequestDataset;
/*--------------------------------------------------------------------------*/
/* ResponseCode */
#define PTP_ResponseCode_Undefined				0x2000
#define PTP_ResponseCode_OK					0x2001
#define PTP_ResponseCode_GeneralError				0x2002
#define PTP_ResponseCode_SessionNotOpen				0x2003
#define PTP_ResponseCode_InvalidTransactionID			0x2004
#define PTP_ResponseCode_OperationNotSupported			0x2005
#define PTP_ResponseCode_ParameterNotSupported			0x2006
#define PTP_ResponseCode_IncompleteTransfer			0x2007
#define PTP_ResponseCode_InvalidStorageID			0x2008
#define PTP_ResponseCode_InvalidObjectHandle			0x2009
#define PTP_ResponseCode_DevicePropNotSupported			0x200A
#define PTP_ResponseCode_InvalidObjectFormatCode		0x200B
#define PTP_ResponseCode_StoreFull				0x200C
#define PTP_ResponseCode_ObjectWriteProtected			0x200D
#define PTP_ResponseCode_StoreRead_Only				0x200E
#define PTP_ResponseCode_AccessDenied				0x200F
#define PTP_ResponseCode_NoThumbnailPresent			0x2010
#define PTP_ResponseCode_SelfTestFailed				0x2011
#define PTP_ResponseCode_PartialDeletion			0x2012
#define PTP_ResponseCode_StoreNotAvailable			0x2013
#define PTP_ResponseCode_SpecificationByFormatUnsupported	0x2014
#define PTP_ResponseCode_NoValidObjectInfo			0x2015
#define PTP_ResponseCode_InvalidCodeFormat			0x2016
#define PTP_ResponseCode_UnknownVendorCode			0x2017
#define PTP_ResponseCode_CaptureAlreadyTerminated		0x2018
#define PTP_ResponseCode_DeviceBusy				0x2019
#define PTP_ResponseCode_InvalidParentObject			0x201A
#define PTP_ResponseCode_InvalidDevicePropFormat		0x201B
#define PTP_ResponseCode_InvalidDevicePropValue			0x201C
#define PTP_ResponseCode_InvalidParameter			0x201D
#define PTP_ResponseCode_SessionAlreadyOpen			0x201E
#define PTP_ResponseCode_TransactionCancelled			0x201F
#define PTP_ResponseCode_SpecificationofDestinationUnsupported	0x2020
//#define PTP_ResponseCode_Reserved				0x2000/*+?*/	//All other codes with MSN of 0010
#define PTP_ResponseCode_VendorExtended				0xA000/*+?*/	//All codes with MSN of 1010
/*--- MTP Extension response codes ---*/
#define MTP_ResponseCode_InvalidObjectPropCode			0xA801
#define MTP_ResponseCode_InvalidObjectPropFormat		0xA802
#define MTP_ResponseCode_InvalidObjectPropValue			0xA803
#define MTP_ResponseCode_InvalidObjectReference			0xA804
#define MTP_ResponseCode_GroupNotSupported			0xA805
#define MTP_ResponseCode_InvalidDataset				0xA806
#define MTP_ResponseCode_SpecificationByGroupUnsupported	0xA807
#define MTP_ResponseCode_SpecificationByDepthUnsupported	0xA808
#define MTP_ResponseCode_ObjectTooLarge				0xA809
#define MTP_ResponseCode_ObjectPropNotSupported			0xA80A
/*--------------------------------------------------------------------------*/
/* 9.3.4 Response Phase
 * The response phase consists of the transport-specific transmission of a 30-byte response dataset from the Responder to the Initiator.
 * The following table describes the fields that are required to be accounted for as part of the response phase: */
typedef struct _PTP_ResponseDataset {
	uint16_t ResponseCode;		//Indicates the interpretation of the response as defined in the ResponseCode section in Clause 11.2.
//sv	uint32_t SessionID;		//The identifier for the session within which this operation is being responded to. This value is assigned by the Initiator using the OpenSession operation, and should be copied from the OperationRequest dataset that is received by the Responder prior to responding.
//sv	uint32_t TransactionID;		//The identifier of the particular transaction. This field should be copied from the OperationRequest dataset that is received by the Responder prior to responding.
	uint32_t Parameter[5];		//This field holds the operation-specific nth response parameter. Response datasets may have at most five parameters. The interpretation of any parameter is dependent upon the OperationCode for which the response has been generated, and secondarily may be a function of the particular ResponseCode itself. Any unused parameter fields should be set to 0x00000000. If a parameter holds a value that is less than 32 bits, the lowest significant bits shall be used to store the value, with the most significant bits being set to zeros.
} PTP_ResponseDataset;
/*--------------------------------------------------------------------------*/
/* EventCode */
#define PTP_EventCode_Undefined					0x4000
#define PTP_EventCode_CancelTransaction				0x4001
#define PTP_EventCode_ObjectAdded				0x4002
#define PTP_EventCode_ObjectRemoved				0x4003
#define PTP_EventCode_StoreAdded				0x4004
#define PTP_EventCode_StoreRemoved				0x4005
#define PTP_EventCode_DevicePropChanged				0x4006
#define PTP_EventCode_ObjectInfoChanged				0x4007
#define PTP_EventCode_DeviceInfoChanged				0x4008
#define PTP_EventCode_RequestObjectTransfer			0x4009
#define PTP_EventCode_StoreFull					0x400A
#define PTP_EventCode_DeviceReset				0x400B
#define PTP_EventCode_StorageInfoChanged			0x400C
#define PTP_EventCode_CaptureComplete				0x400D
#define PTP_EventCode_UnreportedStatus				0x400E
//#define PTP_EventCode_Reserved				0x4000/*+?*/	//All other codes with MSN of 0100
#define PTP_EventCode_VendorExtended				0xC000/*+?*/	//All codes with MSN of 1100
/*--- MTP Extension event codes ---*/
#define MTP_EventCode_ObjectPropChanged				0xC801
#define MTP_EventCode_ObjectPropDescChanged			0xC802
#define MTP_EventCode_ObjectReferencesChanged			0xC803
/*--------------------------------------------------------------------------*/
/* 12.2 Event Dataset
 * Events are described using the Event Dataset, which consists of the minimal information that is required for qualified notification.
 * Fully qualified events will need to send only this dataset in order to fully describe the event and obtain post-event synchronization.
 * In different transport implementations, the fulfillment of all the fields of this dataset may or may not happen atomically, and therefore may require a lightweight event notification mechanism separate from the operation of actually requesting the dataset fields.
 * Some events, by the very nature of the information that they convey, will infer the need for the event-receiving device to perform an operation to re-synchronize inter-device state. */
typedef struct _PTP_EventDataset {
	uint16_t EventCode;		//Indicates the interpretation of the response as defined in the ResponseCode section in Clause 11.2.
//sv	uint32_t SessionID;		//The identifier for the session within which this operation is being responded to. This value is assigned by the Initiator using the OpenSession operation, and should be copied from the OperationRequest dataset that is received by the Responder prior to responding.
//sv	uint32_t TransactionID;		//The identifier of the particular transaction. This field should be copied from the OperationRequest dataset that is received by the Responder prior to responding.
	uint32_t Parameter[3];		//This field holds the operation-specific nth response parameter. Response datasets may have at most five parameters. The interpretation of any parameter is dependent upon the OperationCode for which the response has been generated, and secondarily may be a function of the particular ResponseCode itself. Any unused parameter fields should be set to 0x00000000. If a parameter holds a value that is less than 32 bits, the lowest significant bits shall be used to store the value, with the most significant bits being set to zeros.
} PTP_EventDataset;
/*--------------------------------------------------------------------------*/
/* DataType */
#define PTP_DataType_Undefined					0x0000		//Undefined
#define PTP_DataType_INT8					0x0001		//Signed 8 bit integer
#define PTP_DataType_UINT8					0x0002		//Unsigned 8 bit integer
#define PTP_DataType_INT16					0x0003		//Signed 16 bit integer
#define PTP_DataType_UINT16					0x0004		//Unsigned 16 bit integer
#define PTP_DataType_INT32					0x0005		//Signed 32 bit integer
#define PTP_DataType_UINT32					0x0006		//Unsigned 32 bit integer
#define PTP_DataType_INT64					0x0007		//Signed 64 bit integer
#define PTP_DataType_UINT64					0x0008		//Unsigned 64 bit integer
#define PTP_DataType_INT128					0x0009		//Signed 128 bit integer
#define PTP_DataType_UINT128					0x000A		//Unsigned 128 bit integer
#define PTP_DataType_AINT8					0x4001		//Array of Signed 8 bit integers
#define PTP_DataType_AUINT8					0x4002		//Array of Unsigned 8 bit integers
#define PTP_DataType_AINT16					0x4003		//Array of Signed 16 bit integers
#define PTP_DataType_AUINT16					0x4004		//Array of Unsigned 16 bit integers
#define PTP_DataType_AINT32					0x4005		//Array of Signed 32 bit integers
#define PTP_DataType_AUINT32					0x4006		//Array of Unsigned 32 bit integers
#define PTP_DataType_AINT64					0x4007		//Array of Signed 64 bit integers
#define PTP_DataType_AUINT64					0x4008		//Array of Unsigned 64 bit integers
#define PTP_DataType_AINT128					0x4009		//Array of Signed 128 bit integers
#define PTP_DataType_AUINT128					0x400A		//Array of Unsigned 128 bit integers
#define PTP_DataType_STR					0xFFFF		//Variable-length Unicode String
//#define PTP_DataType_Reserved					0x????		//Reserved	All other values
/*--------------------------------------------------------------------------*/
/* StorageType */
#define PTP_StorageType_Undefined				0x0000
#define PTP_StorageType_FixedROM				0x0001
#define PTP_StorageType_RemovableROM				0x0002
#define PTP_StorageType_FixedRAM				0x0003
#define PTP_StorageType_RemovableRAM				0x0004
//#define PTP_StorageType_Reserved				0x????		//All other values
/*--------------------------------------------------------------------------*/
/* FilesystemType */
#define PTP_FilesystemType_Undefined				0x0000
#define PTP_FilesystemType_GenericFlat				0x0001
#define PTP_FilesystemType_GenericHierarchical			0x0002
#define PTP_FilesystemType_DCF					0x0003
//#define PTP_FilesystemType_Reserved				0x0000/*+?*/	//All other values with Bit 15 set to 0
#define PTP_FilesystemType_VendorDefined			0x8000/*+?*/	//All values with Bit 15 set to 1
/*--------------------------------------------------------------------------*/
/* AccessCapability */
#define PTP_AccessCapability_ReadWrite				0x0000
#define PTP_AccessCapability_ReadOnlyWithoutObjectDeletion	0x0001
#define PTP_AccessCapability_ReadOnlyWithObjectDeletion		0x0002
//#define PTP_AccessCapability_Reserved				0x????		//All other values
/*--------------------------------------------------------------------------*/
/* ObjectFormat */
#define PTP_ObjectFormat_Undefined				0x3000		//Undefined non-image object
#define PTP_ObjectFormat_Association				0x3001		//Association (e.g. folder)
#define PTP_ObjectFormat_Script					0x3002		//Device-model-specific script
#define PTP_ObjectFormat_Executable				0x3003		//Device-model-specific binary executable
#define PTP_ObjectFormat_Text					0x3004		//Text file
#define PTP_ObjectFormat_HTML					0x3005		//HyperText Markup Language file (text)
#define PTP_ObjectFormat_DPOF					0x3006		//Digital Print Order Format file (text)
#define PTP_ObjectFormat_AIFF					0x3007		//Audio clip
#define PTP_ObjectFormat_WAV					0x3008		//Audio clip
#define PTP_ObjectFormat_MP3					0x3009		//Audio clip
#define PTP_ObjectFormat_AVI					0x300A		//Video clip
#define PTP_ObjectFormat_MPEG					0x300B		//Video clip
#define PTP_ObjectFormat_ASF					0x300C		//Microsoft Advanced Streaming Format (video)
#define PTP_ObjectFormat_UnknownImageObject			0x3800		//Unknown image object
#define PTP_ObjectFormat_EXIF_JPEG				0x3801		//Exchangeable File Format, JEIDA standard
#define PTP_ObjectFormat_TIFF_EP				0x3802		//Tag Image File Format for Electronic Photography
#define PTP_ObjectFormat_FlashPix				0x3803		//Structured Storage Image Format
#define PTP_ObjectFormat_BMP					0x3804		//Microsoft Windows Bitmap file
#define PTP_ObjectFormat_CIFF					0x3805		//Canon Camera Image File Format
#define PTP_ObjectFormat_Reserved_0x3806			0x3806		//Reserved
#define PTP_ObjectFormat_GIF					0x3807		//Graphics Interchange Format
#define PTP_ObjectFormat_JFIF					0x3808		//JPEG File Interchange Format
#define PTP_ObjectFormat_PCD					0x3809		//PhotoCD Image Pac
#define PTP_ObjectFormat_PICT					0x380A		//Quickdraw Image Format
#define PTP_ObjectFormat_PNG					0x380B		//Portable Network Graphics
#define PTP_ObjectFormat_Reserved_0x380C			0x380C		//Reserved
#define PTP_ObjectFormat_TIFF					0x380D		//Tag Image File Format
#define PTP_ObjectFormat_TIFF_IT				0x380E		//Tag Image File Format for Information Technology (graphic arts)
#define PTP_ObjectFormat_JP2					0x380F		//JPEG2000 Baseline File Format
#define PTP_ObjectFormat_JPX					0x3810		//JPEG2000 Extended File Format
//#define PTP_ObjectFormat_Reserved				0x3000/*+?*/	//Reserved for future use	All other codes with MSN of 0011
#define PTP_ObjectFormat_VendorDefined				0xB000/*+?*/	//Vendor-Defined		All other codes with MSN of 1011
/*--- MTP Extension format codes ---*/
#define MTP_ObjectFormat_UndefinedFirmware			0xB802
#define MTP_ObjectFormat_WBMP 					0xB803		//Wireless Application Protocol Bitmap Format (.wbmp). image/vnd.wap.wbmp http://www.wapforum.org/what/technical/SPEC-WAESpec-19990524.pdf
#define MTP_ObjectFormat_JPEG_XR 				0xB804		//JPEG XR, also known as HD Photo (.hdp,.jxr,.wpd). image/vnd.ms-photo. ISO/IEC 29199-2:2009 http://www.iso.org/iso/iso_catalogue/catalogue_tc/catalogue_detail.htm?csnumber=51609
#define MTP_ObjectFormat_WindowsImageFormat			0xB881
#define MTP_ObjectFormat_UndefinedAudio				0xB900		//Undefined audio object
#define MTP_ObjectFormat_WMA					0xB901		//Windows Media Audio
#define MTP_ObjectFormat_OGG					0xB902
#define MTP_ObjectFormat_AAC					0xB903		//Advanced Audio Coding (.aac). audio/aac. MPEG-4 AAC.
#define MTP_ObjectFormat_Audible				0xB904
#define MTP_ObjectFormat_FLAC					0xB906		//Free Lossless Audio Codec
#define MTP_ObjectFormat_QCELP					0xB907		//Qualcomm Code Excited Linear Prediction (.qcp). audio/qcelp
#define MTP_ObjectFormat_AMR					0xB908		//Adaptive Multi-Rate audio codec (.amr). audio/amr
#define MTP_ObjectFormat_UndefinedVideo				0xB980		//Undefined video object
#define MTP_ObjectFormat_WMV					0xB981		//Windows Media Video
#define MTP_ObjectFormat_MP4Container				0xB982		//ISO 14496-1
#define MTP_ObjectFormat_MP2					0xB983		//MPEG-1 Layer II audio (ISO/IEC 13818-3)
#define MTP_ObjectFormat_3GPContainer				0xB984		//3GPP file format. Details: http://www.3gpp.org/ftp/Specs/html-info/26244.htm (page title - "Transparent end-to-end packet switched streaming service, 3GPP file format").
#define MTP_ObjectFormat_3G2					0xB985		//3GPP2 format (.3g2). video/3gpp2, audio/3gpp2 http://www.3gpp2.org/Public_html/specs/C.S0050-B_v1.0_070521.pdf
#define MTP_ObjectFormat_AVCHD					0xB986		//MPEG-4 AVC video and Dolby Digital audio within an MPEG-2 Transport Stream as constrained by the AVCHD format specification http://www.avchd-info.org/
#define MTP_ObjectFormat_ATSC_TS				0xB987		//MPEG-2 video and AC-3 audio within an ATSC-compliant MPEG-2 Transport Stream
#define MTP_ObjectFormat_DVB_TS					0xB988		//MPEG-2 video and MPEG-1 Layer II or AC-3 audio within a DVB-compliant MPEG-2 Transport Stream
#define MTP_ObjectFormat_UndefinedCollection			0xBA00
#define MTP_ObjectFormat_AbstractMultimediaAlbum		0xBA01
#define MTP_ObjectFormat_AbstractImageAlbum			0xBA02
#define MTP_ObjectFormat_AbstractAudioAlbum			0xBA03
#define MTP_ObjectFormat_AbstractVideoAlbum			0xBA04
#define MTP_ObjectFormat_AbstractAudioVideoPlaylist		0xBA05
#define MTP_ObjectFormat_AbstractContactGroup			0xBA06
#define MTP_ObjectFormat_AbstractMessageFolder			0xBA07
#define MTP_ObjectFormat_AbstractChapteredProduction		0xBA08
#define MTP_ObjectFormat_AbstractAudioPlaylist			0xBA09
#define MTP_ObjectFormat_AbstractVideoPlaylist			0xBA0A
#define MTP_ObjectFormat_AbstractMediacast			0xBA0B		//For use with mediacasts; references multimedia enclosures of RSS feeds or episodic content
#define MTP_ObjectFormat_WPLPlaylist				0xBA10
#define MTP_ObjectFormat_M3UPlaylist				0xBA11
#define MTP_ObjectFormat_MPLPlaylist				0xBA12
#define MTP_ObjectFormat_ASXPlaylist				0xBA13
#define MTP_ObjectFormat_PLSPlaylist				0xBA14
#define MTP_ObjectFormat_UndefinedDocument			0xBA80
#define MTP_ObjectFormat_AbstractDocument			0xBA81
#define MTP_ObjectFormat_XMLDocument				0xBA82
#define MTP_ObjectFormat_MicrosoftWordDocument			0xBA83
#define MTP_ObjectFormat_MHTCompiledHTMLDocument		0xBA84
#define MTP_ObjectFormat_MicrosoftExcelSpreadsheet		0xBA85
#define MTP_ObjectFormat_MicrosoftPowerpointDocument		0xBA86
#define MTP_ObjectFormat_UndefinedMessage			0xBB00
#define MTP_ObjectFormat_AbstractMessage			0xBB01
#define MTP_ObjectFormat_UndefinedBookmark			0xBB10
#define MTP_ObjectFormat_AbstractBookmark			0xBB11
#define MTP_ObjectFormat_UndefinedAppointment			0xBB20
#define MTP_ObjectFormat_AbstractAppointment			0xBB21
#define MTP_ObjectFormat_vCalendar1_0				0xBE22		//(vmF:0xBE220xBE02̂ǂ炪̂s)
#define MTP_ObjectFormat_UndefinedTask				0xBB40
#define MTP_ObjectFormat_AbstractTask				0xBB41
#define MTP_ObjectFormat_iCalendar				0xBB42
#define MTP_ObjectFormat_UndefinedNote				0xBB60
#define MTP_ObjectFormat_AbstractNote				0xBB61
#define MTP_ObjectFormat_UndefinedContact			0xBB80
#define MTP_ObjectFormat_AbstractContact			0xBB81
#define MTP_ObjectFormat_vCard2					0xBB82
#define MTP_ObjectFormat_vCard3					0xBB83
#define MTP_ObjectFormat_UndefinedCalendarItem			0xBE00
#define MTP_ObjectFormat_AbstractCalendarItem			0xBE01
#define MTP_ObjectFormat_vCalendar1				0xBE02		//(vmF:0xBE220xBE02̂ǂ炪̂s)
#define MTP_ObjectFormat_vCalendar2				0xBE03
#define MTP_ObjectFormat_UndefinedWindowsExecutable		0xBE80
/*--------------------------------------------------------------------------*/
/* DeviceProp */
#define PTP_DeviceProp_Undefined				0x5000
#define PTP_DeviceProp_BatteryLevel				0x5001
#define PTP_DeviceProp_FunctionalMode				0x5002
#define PTP_DeviceProp_ImageSize				0x5003
#define PTP_DeviceProp_CompressionSetting			0x5004
#define PTP_DeviceProp_WhiteBalance				0x5005
#define PTP_DeviceProp_RGBGain					0x5006
#define PTP_DeviceProp_F_Number					0x5007
#define PTP_DeviceProp_FocalLength				0x5008
#define PTP_DeviceProp_FocusDistance				0x5009
#define PTP_DeviceProp_FocusMode				0x500A
#define PTP_DeviceProp_ExposureMeteringMode			0x500B
#define PTP_DeviceProp_FlashMode				0x500C
#define PTP_DeviceProp_ExposureTime				0x500D
#define PTP_DeviceProp_ExposureProgramMode			0x500E
#define PTP_DeviceProp_ExposureIndex				0x500F
#define PTP_DeviceProp_ExposureBiasCompensation			0x5010
#define PTP_DeviceProp_DateTime					0x5011
#define PTP_DeviceProp_CaptureDelay				0x5012
#define PTP_DeviceProp_StillCaptureMode				0x5013
#define PTP_DeviceProp_Contrast					0x5014
#define PTP_DeviceProp_Sharpness				0x5015
#define PTP_DeviceProp_DigitalZoom				0x5016
#define PTP_DeviceProp_EffectMode				0x5017
#define PTP_DeviceProp_BurstNumber				0x5018
#define PTP_DeviceProp_BurstInterval				0x5019
#define PTP_DeviceProp_TimelapseNumber				0x501A
#define PTP_DeviceProp_TimelapseInterval			0x501B
#define PTP_DeviceProp_FocusMeteringMode			0x501C
#define PTP_DeviceProp_UploadURL				0x501D
#define PTP_DeviceProp_Artist					0x501E
#define PTP_DeviceProp_CopyrightInfo				0x501F
//#define PTP_DeviceProp_Reserved				0x5000/*+?*/	//All other codes with MSN of 0101
#define PTP_DeviceProp_VendorExtended				0xD000/*+?*/	//All codes with MSN of 1101
/*--- MTP Extension device properties ---*/
#define MTP_DeviceProp_SynchronizationPartner			0xD401
#define MTP_DeviceProp_DeviceFriendlyName			0xD402
#define MTP_DeviceProp_Volume					0xD403
#define MTP_DeviceProp_SupportedFormatsOrdered			0xD404
#define MTP_DeviceProp_DeviceIcon				0xD405
#define MTP_DeviceProp_PlaybackRate				0xD410
#define MTP_DeviceProp_PlaybackObject				0xD411
#define MTP_DeviceProp_PlaybackContainerIndex			0xD412
#define MTP_DeviceProp_SessionInitiatorVersionInfo		0xD406
#define MTP_DeviceProp_PerceivedDeviceType			0xD407
/*--------------------------------------------------------------------------*/
/* ProtectionStatus */
#define PTP_ProtectionStatus_NoProtection			0x0000
#define PTP_ProtectionStatus_ReadOnly				0x0001
//#define PTP_ProtectionStatus_Reserved				0x????		//All other values
/*--- MTP Extension protection statuses ---*/
#define MTP_ProtectionStatus_ReadOnlyData			0x8002
#define MTP_ProtectionStatus_NonTransferableData		0x8003
/*--------------------------------------------------------------------------*/
/* AssociationType */
#define PTP_AssociationType_Undefined				0x0000
#define PTP_AssociationType_GenericFolder			0x0001
#define PTP_AssociationType_Album				0x0002
#define PTP_AssociationType_TimeSequence			0x0003
#define PTP_AssociationType_HorizontalPanoramic			0x0004
#define PTP_AssociationType_VerticalPanoramic			0x0005
#define PTP_AssociationType_2DPanoramic				0x0006
#define PTP_AssociationType_AncillaryData			0x0007
//#define PTP_AssociationType_Reserved				0x0000/*+?*/	//All other values with Bit 15 set to 0
#define PTP_AssociationType_VendorDefined			0x8000/*+?*/	//All values with bit 15 set to 1
/*--------------------------------------------------------------------------*/
/* ObjectProperty */
#define MTP_ObjectProperty_StorageID				0xDC01
#define MTP_ObjectProperty_ObjectFormat				0xDC02
#define MTP_ObjectProperty_ProtectionStatus			0xDC03
#define MTP_ObjectProperty_ObjectSize				0xDC04
#define MTP_ObjectProperty_AssociationType			0xDC05
#define MTP_ObjectProperty_AssociationDesc			0xDC06
#define MTP_ObjectProperty_ObjectFileName			0xDC07
#define MTP_ObjectProperty_DateCreated				0xDC08
#define MTP_ObjectProperty_DateModified				0xDC09
#define MTP_ObjectProperty_Keywords				0xDC0A
#define MTP_ObjectProperty_ParentObject				0xDC0B
#define MTP_ObjectProperty_AllowedFolderContents		0xDC0C
#define MTP_ObjectProperty_Hidden				0xDC0D
#define MTP_ObjectProperty_SystemObject				0xDC0E
#define MTP_ObjectProperty_PersistentUniqueObjectIdentifier	0xDC41
#define MTP_ObjectProperty_SyncID				0xDC42
#define MTP_ObjectProperty_PropertyBag				0xDC43
#define MTP_ObjectProperty_Name					0xDC44
#define MTP_ObjectProperty_CreatedBy				0xDC45
#define MTP_ObjectProperty_Artist				0xDC46
#define MTP_ObjectProperty_DateAuthored				0xDC47
#define MTP_ObjectProperty_Description				0xDC48
#define MTP_ObjectProperty_URLReference				0xDC49
#define MTP_ObjectProperty_LanguageLocale			0xDC4A
#define MTP_ObjectProperty_CopyrightInformation			0xDC4B
#define MTP_ObjectProperty_Source				0xDC4C
#define MTP_ObjectProperty_OriginLocation			0xDC4D
#define MTP_ObjectProperty_DateAdded				0xDC4E
#define MTP_ObjectProperty_NonConsumable			0xDC4F
#define MTP_ObjectProperty_CorruptUnplayable			0xDC50
#define MTP_ObjectProperty_ProducerSerialNumber			0xDC51
#define MTP_ObjectProperty_RepresentativeSampleFormat		0xDC81
#define MTP_ObjectProperty_RepresentativeSampleSize		0xDC82
#define MTP_ObjectProperty_RepresentativeSampleHeight		0xDC83
#define MTP_ObjectProperty_RepresentativeSampleWidth		0xDC84
#define MTP_ObjectProperty_RepresentativeSampleDuration		0xDC85
#define MTP_ObjectProperty_RepresentativeSampleData		0xDC86
#define MTP_ObjectProperty_Width				0xDC87
#define MTP_ObjectProperty_Height				0xDC88
#define MTP_ObjectProperty_Duration				0xDC89
#define MTP_ObjectProperty_Rating				0xDC8A
#define MTP_ObjectProperty_Track				0xDC8B
#define MTP_ObjectProperty_Genre				0xDC8C
#define MTP_ObjectProperty_Credits				0xDC8D
#define MTP_ObjectProperty_Lyrics				0xDC8E
#define MTP_ObjectProperty_SubscriptionContentID		0xDC8F
#define MTP_ObjectProperty_ProducedBy				0xDC90
#define MTP_ObjectProperty_UseCount				0xDC91
#define MTP_ObjectProperty_SkipCount				0xDC92
#define MTP_ObjectProperty_LastAccessed				0xDC93
#define MTP_ObjectProperty_ParentalRating			0xDC94
#define MTP_ObjectProperty_MetaGenre				0xDC95
#define MTP_ObjectProperty_Composer				0xDC96
#define MTP_ObjectProperty_EffectiveRating			0xDC97
#define MTP_ObjectProperty_Subtitle				0xDC98
#define MTP_ObjectProperty_OriginalReleaseDate			0xDC99
#define MTP_ObjectProperty_AlbumName				0xDC9A
#define MTP_ObjectProperty_AlbumArtist				0xDC9B
#define MTP_ObjectProperty_Mood					0xDC9C
#define MTP_ObjectProperty_DRMStatus				0xDC9D
#define MTP_ObjectProperty_SubDescription			0xDC9E
#define MTP_ObjectProperty_IsCropped				0xDCD1
#define MTP_ObjectProperty_IsColourCorrected			0xDCD2
#define MTP_ObjectProperty_ImageBitDepth			0xDCD3
#define MTP_ObjectProperty_Fnumber				0xDCD4
#define MTP_ObjectProperty_ExposureTime				0xDCD5
#define MTP_ObjectProperty_ExposureIndex			0xDCD6
#define MTP_ObjectProperty_TotalBitRate				0xDE91
#define MTP_ObjectProperty_BitrateType				0xDE92
#define MTP_ObjectProperty_SampleRate				0xDE93
#define MTP_ObjectProperty_NumberOfChannels			0xDE94
#define MTP_ObjectProperty_AudioBitDepth			0xDE95
#define MTP_ObjectProperty_ScanType				0xDE97
#define MTP_ObjectProperty_AudioWAVECodec			0xDE99
#define MTP_ObjectProperty_AudioBitRate				0xDE9A
#define MTP_ObjectProperty_VideoFourCCCodec			0xDE9B
#define MTP_ObjectProperty_VideoBitRate				0xDE9C
#define MTP_ObjectProperty_FramesPerThousandSeconds		0xDE9D
#define MTP_ObjectProperty_KeyFrameDistance			0xDE9E
#define MTP_ObjectProperty_BufferSize				0xDE9F
#define MTP_ObjectProperty_EncodingQuality			0xDEA0
#define MTP_ObjectProperty_EncodingProfile			0xDEA1
#define MTP_ObjectProperty_DisplayName				0xDCE0
#define MTP_ObjectProperty_BodyText				0xDCE1
#define MTP_ObjectProperty_Subject				0xDCE2
#define MTP_ObjectProperty_Priority				0xDCE3
#define MTP_ObjectProperty_GivenName				0xDD00
#define MTP_ObjectProperty_MiddleNames				0xDD01
#define MTP_ObjectProperty_FamilyName				0xDD02
#define MTP_ObjectProperty_Prefix				0xDD03
#define MTP_ObjectProperty_Suffix				0xDD04
#define MTP_ObjectProperty_PhoneticGivenName			0xDD05
#define MTP_ObjectProperty_PhoneticFamilyName			0xDD06
#define MTP_ObjectProperty_EmailPrimary				0xDD07
#define MTP_ObjectProperty_EmailPersonal1			0xDD08
#define MTP_ObjectProperty_EmailPersonal2			0xDD09
#define MTP_ObjectProperty_EmailBusiness1			0xDD0A
#define MTP_ObjectProperty_EmailBusiness2			0xDD0B
#define MTP_ObjectProperty_EmailOthers				0xDD0C
#define MTP_ObjectProperty_PhoneNumberPrimary			0xDD0D
#define MTP_ObjectProperty_PhoneNumberPersonal			0xDD0E
#define MTP_ObjectProperty_PhoneNumberPersonal2			0xDD0F
#define MTP_ObjectProperty_PhoneNumberBusiness			0xDD10
#define MTP_ObjectProperty_PhoneNumberBusiness2			0xDD11
#define MTP_ObjectProperty_PhoneNumberMobile			0xDD12
#define MTP_ObjectProperty_PhoneNumberMobile2			0xDD13
#define MTP_ObjectProperty_FaxNumberPrimary			0xDD14
#define MTP_ObjectProperty_FaxNumberPersonal			0xDD15
#define MTP_ObjectProperty_FaxNumberBusiness			0xDD16
#define MTP_ObjectProperty_PagerNumber				0xDD17
#define MTP_ObjectProperty_PhoneNumberOthers			0xDD18
#define MTP_ObjectProperty_PrimaryWebAddress			0xDD19
#define MTP_ObjectProperty_PersonalWebAddress			0xDD1A
#define MTP_ObjectProperty_BusinessWebAddress			0xDD1B
#define MTP_ObjectProperty_InstantMessengerAddress		0xDD1C
#define MTP_ObjectProperty_InstantMessengerAddress2		0xDD1D
#define MTP_ObjectProperty_InstantMessengerAddress3		0xDD1E
#define MTP_ObjectProperty_PostalAddressPersonalFull		0xDD1F
#define MTP_ObjectProperty_PostalAddressPersonalLine1		0xDD20
#define MTP_ObjectProperty_PostalAddressPersonalLine2		0xDD21
#define MTP_ObjectProperty_PostalAddressPersonalCity		0xDD22
#define MTP_ObjectProperty_PostalAddressPersonalRegion		0xDD23
#define MTP_ObjectProperty_PostalAddressPersonalPostalCode	0xDD24
#define MTP_ObjectProperty_PostalAddressPersonalCountry		0xDD25
#define MTP_ObjectProperty_PostalAddressBusinessFull		0xDD26
#define MTP_ObjectProperty_PostalAddressBusinessLine1		0xDD27
#define MTP_ObjectProperty_PostalAddressBusinessLine2		0xDD28
#define MTP_ObjectProperty_PostalAddressBusinessCity		0xDD29
#define MTP_ObjectProperty_PostalAddressBusinessRegion		0xDD2A
#define MTP_ObjectProperty_PostalAddressBusinessPostalCode	0xDD2B
#define MTP_ObjectProperty_PostalAddressBusinessCountry		0xDD2C
#define MTP_ObjectProperty_PostalAddressOtherFull		0xDD2D
#define MTP_ObjectProperty_PostalAddressOtherLine1		0xDD2E
#define MTP_ObjectProperty_PostalAddressOtherLine2		0xDD2F
#define MTP_ObjectProperty_PostalAddressOtherCity		0xDD30
#define MTP_ObjectProperty_PostalAddressOtherRegion		0xDD31
#define MTP_ObjectProperty_PostalAddressOtherPostalCode		0xDD32
#define MTP_ObjectProperty_PostalAddressOtherCountry		0xDD33
#define MTP_ObjectProperty_OrganizationName			0xDD34
#define MTP_ObjectProperty_PhoneticOrganizationName		0xDD35
#define MTP_ObjectProperty_Role					0xDD36
#define MTP_ObjectProperty_Birthdate				0xDD37
#define MTP_ObjectProperty_MessageTo				0xDD40
#define MTP_ObjectProperty_MessageCC				0xDD41
#define MTP_ObjectProperty_MessageBCC				0xDD42
#define MTP_ObjectProperty_MessageRead				0xDD43
#define MTP_ObjectProperty_MessageReceivedTime			0xDD44
#define MTP_ObjectProperty_MessageSender			0xDD45
#define MTP_ObjectProperty_ActivityBeginTime			0xDD50
#define MTP_ObjectProperty_ActivityEndTime			0xDD51
#define MTP_ObjectProperty_ActivityLocation			0xDD52
#define MTP_ObjectProperty_ActivityRequiredAttendees		0xDD54
#define MTP_ObjectProperty_ActivityOptionalAttendees		0xDD55
#define MTP_ObjectProperty_ActivityResources			0xDD56
#define MTP_ObjectProperty_ActivityAccepted			0xDD57
#define MTP_ObjectProperty_ActivityTentative			0xDD58
#define MTP_ObjectProperty_ActivityDeclined			0xDD59
#define MTP_ObjectProperty_ActivityReminderTime			0xDD5A
#define MTP_ObjectProperty_ActivityOwner			0xDD5B
#define MTP_ObjectProperty_ActivityStatus			0xDD5C
#define MTP_ObjectProperty_Owner				0xDD5D
#define MTP_ObjectProperty_Editor				0xDD5E
#define MTP_ObjectProperty_Webmaster				0xDD5F
#define MTP_ObjectProperty_URLSource				0xDD60
#define MTP_ObjectProperty_URLDestination			0xDD61
#define MTP_ObjectProperty_TimeBookmark				0xDD62
#define MTP_ObjectProperty_ObjectBookmark			0xDD63
#define MTP_ObjectProperty_ByteBookmark				0xDD64
#define MTP_ObjectProperty_LastBuildDate			0xDD70
#define MTP_ObjectProperty_TimetoLive				0xDD71
#define MTP_ObjectProperty_MediaGUID				0xDD72
/*--------------------------------------------------------------------------*/
/* Get/Set */
#define PTP_GetSet_Get						0x00
#define PTP_GetSet_GetSet					0x01
/*--------------------------------------------------------------------------*/
/* FormFlag */
#define PTP_FormFlag_None					0x00
#define PTP_FormFlag_RangeForm					0x01
#define PTP_FormFlag_EnumerationForm				0x02
/*--- MTP Extension form flags ---*/
#define MTP_FormFlag_DateTimeForm				0x03
#define MTP_FormFlag_FixedlengthArrayForm			0x04
#define MTP_FormFlag_RegularExpressionForm			0x05
#define MTP_FormFlag_ByteArrayForm				0x06
#define MTP_FormFlag_LongStringForm				0xFF

/****************************************************************************
 *	萔A\
 ****************************************************************************/
/* ST_PTP.Phase */
enum {
	PTP_Phase_Command,		//InitiatorResponder
	PTP_Phase_DataOut,		//InitiatorResponder
	PTP_Phase_DataIn,		//ResponderInitiator
	PTP_Phase_Response,		//ResponderInitiator
};
/*--------------------------------------------------------------------------*/
//{{2014/09/20폜:FRAM4̈ޔp1ɂAŜ狤pł悤ɂȂ܂B
////{{clip.hclipptp.hclippce.hɃCN[ĥŏd`Ă
//#define FRAM4_SIZE	0x0200		//FRAM4̈TCY
////}}clip.hclipptp.hclippce.hɃCN[ĥŏd`Ă
//}}2014/09/20폜:FRAM4̈ޔp1ɂAŜ狤pł悤ɂȂ܂B
typedef struct _ST_PTP {
	int				Phase;				//tF[Y				PTP_Phase_*
	int				SessionID;			//ZVID				OpenSessionŃZbgBCloseSessionŃNAB
	int				TransactionID;			//gUNVID			R}hubNMɃZbgB
	PTP_OperationRequestDataset	OperationRequestDataset;	//Iy[VNGXgf[^Zbg	R}hubNMɃZbgB
	PTP_ResponseDataset		ResponseDataset;		//X|Xf[^Zbg		R}hŃZbgB
	PTP_EventDataset		EventDataset;			//Cxgf[^Zbg			
	int				ObjectHandle;			//IuWFNgnh			SendObjectInfoSendObjectւ̈np		SendObjectParameterɂObjectHandlew肳ȂBOɎsSendObjectInfoObjectHandlegBsRꂪPTP̎dlłB
	int				DataLen;			//f[^Mp			R}hŃZbgB
	int				DataPos;			//f[^ʒu			R}hŃNABf[^ubNMɕωB
	void*				DataPtr;			//f[^|C^			R}hŃZbgBf[^|C^gpȂꍇ̓NAB
	uint8_t				WorkBuf[BLOCKSIZE];		//[Nobt@
    //{{2014/09/20폜:FRAM4̈ޔp1ɂAŜ狤pł悤ɂȂ܂B
    //	uint8_t				save_FRAM4[FRAM4_SIZE];		//FRAM4̈ޔp			pceFileCreate(),pceFileDelete(),pceFileWriteSct()ĂяoOɑޔAĂяoɕBȂƁA荞݊OpceLCDTrans()ȂǂFRAM4gpɁAFRAM4j󂳂Ė\܂B
    //}}2014/09/20폜:FRAM4̈ޔp1ɂAŜ狤pł悤ɂȂ܂B
	const char* 			pProtectedFilenames;		//veNgt@C̃Xg	̃t@C'\0'ŋ؂Ďw肷BI["\0','\0'ƂB(Windows APIGetOpenFileNameOPENFILENAME.lpstrFilterƓl̎w@łB)
	int				bMTP;				//샂[h				0=PTP,1=MTP
} ST_PTP;
extern ST_PTP stPTP;

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* USB PTPJn܂B
 * [in]
 *	pProtectedFilenames	veNgt@C̃Xg
 *				veNgt@Cꍇ́A"",,NULLw肵ĂB
 *	bMTP			샂[h(0=PTP,1=MTP)
 * [note]
 *	- ֐́ApProtectedFilenamesRs[A|C^ێ܂B
 *	  PTP_Start()ĂяoAvP[V́APTP_Stop()Ăяo܂ł̊ԁApProtectedFilenameswAJύXĂ͂܂B
 *	- PTP_Start()ĂяoAvP[V́AIOɕKAPTP_Stop()ĂяoĂB
 *	  PTP_Stop()ĂяoɏIƁAP/ECEVXeُ퓮ƂȂ܂B
 * [gp]
 *	- startup.pex,ptpresp.pex,readme.txtveNgꍇ:
 *	  PTP_Start("startup.pex\0ptpresp.pex\0readme.txt\0");	//Ō\0̌ɈÖق\0t̂ŁA\[XR[h\0\0ƏKv͖
 *	- veNgt@Cꍇ:
 *	  PTP_Start("");  PTP_Start(NULL);
 */
void PTP_Start(const char* pProtectedFilenames, int bMTP);

/* USB PTPI܂B
 * [note]
 *	- PTP_Stop()́AɈSɌĂяoƂł܂B
 *	  PTP_Start()ĂяoĂȂĂAPTP_Stop()ĂяoĂ\܂B
 */
void PTP_Stop();

#endif /*__CLIP_PTP_H__*/
