/*	
 *	clipgbs.h
 *
 *	P/ECE GBS Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Thu Jan 15 20:09:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#ifndef __CLIP_GBS_H__
#define __CLIP_GBS_H__

/****************************************************************************
 *	GBSt@Cdl
 ****************************************************************************/

/* * GBSHEADER\̂̓gGfBAŁAtB[hACgĂ܂B
 *   ]āAɋCƂȂÂ܂܃tB[hlǂݍővłB
 */

/* GBSt@Cwb_ */
typedef struct _GBSHEADER {
	         char  signature[3];		/* +0x00, 3: Identifier string ("GBS") */
	unsigned char  version;			/* +0x03, 1: Version (1) */
	unsigned char  num_songs;		/* +0x04, 1: Number of songs (1-255) */
	unsigned char  first_song;		/* +0x05, 1: First song (usually 1) */
	unsigned short load_addr;		/* +0x06, 2: Load address ($400-$7fff) */
	unsigned short init_addr;		/* +0x08, 2: Init address ($400-$7fff) */
	unsigned short play_addr;		/* +0x0a, 2: Play address ($400-$7fff) */
	unsigned short stack_ptr;		/* +0x0c, 2: Stack pointer */
	unsigned char  timer_mod;		/* +0x0e, 1: Timer modulo */
	unsigned char  timer_ctl;		/* +0x0f, 1: Timer control */
	         char  title[32];		/* +0x10,32: Title string */
	         char  author[32];		/* +0x30,32: Author string */
	         char  copyright[32];		/* +0x50,32: Copyright string */
} GBSHEADER;					/* =0x70,??: Code and Data */

/****************************************************************************
 *	GBShCo
 ****************************************************************************/

#define GBSBUFLEN	320	/* = 16000/50 c 1[tick](=1/50[sec])̃Tv */

#define GBS_CLOCK	4194304	/* DMG-CPU/Sound ̓NbN (=2^22)*/

/*
 *	GBShCo
 */
typedef struct _GBSDRIVER {
	/*{{DMGRAREADO֐g߁ACAEgŒ*/
	DMG dmg;			/* DMG-CPU */
	unsigned char mem[0x10000];	/* C */
	/*}}DMGRAREADO֐g߁ACAEgŒ*/
	DMGSOUND ds;			/* DMG-Sound */
	//
	GBSHEADER* header;		/* gbs_init()ɓnꂽGBSHEADERAhX */
	const unsigned char* bank1;	/* ROM Bank1 擪AhX */
	int length;			/* bank1ȍ~̗Lf[^oCg */
	int rom1_bank;			/* ROM Area1(0x4000-0x7fff)̃oNI */
	//
	int interrupt_interval;		/* 荞ݎ[TCN] */
	int interrupt_progress;		/* 荞ݐisJE^ */
} GBSDRIVER;

/*
 *	DMGG~[VpO֐
 */
//unsigned char gbs_dmg_read(DMG* dmg, unsigned short addr);
void gbs_dmg_write(DMG* dmg, unsigned short addr, unsigned char data);
//unsigned char gbs_dmg_in(DMG* dmg, unsigned char addr);
void gbs_dmg_out(DMG* dmg, unsigned char addr, unsigned char data);

/*
 *	GBShCo֐
 */
void gbs_dmg_setup(GBSDRIVER* gbs, int a, int pc);
int gbs_init(GBSDRIVER* gbs, const void* data, int len, int i_song);
void gbs_rom1_bank(GBSDRIVER* gbs, int i_bank);
int gbs_mix(GBSDRIVER* gbs, short wbuff[/*GBSBUFLEN*/]);
int gbs_stream_callback(short* wbuff, int param);

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* GBSt@C̍ĐJn܂B
 * [in]
 *	data		GBSf[^̐擪AhXB
 *	len		GBSf[^̃oCgB
 *	i_song		gbNԍB(0`)
 *			-1w肷ƁAGBSt@C̊JnȔԍƂȂ܂B
 * [out]
 *	߂l		ĐJnɐA 0Ԃ܂B
 *			ĐJnłȂ΁A-1Ԃ܂B
 * [note]
 *	* ̊֐͓stream_play()ĂяoĂ܂B
 *	* stream_play()ĂԂƁATEh荞݃xN^tbN܂B
 *	  vOIOɕKgbs_stop()ĂŁAxN^𕜌ĂB
 */
int gbs_play(const void* data, int len, int i_song);

/* GBSt@C̍Đ~܂B
 * [note]
 *	* ĐłȂ΁Å֐͉܂B
 */
void gbs_stop();

#endif /*__CLIP_GBS_H__*/
