/*
 *	clipdirs.c
 *
 *	oV[PT
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2015 Naoyuki Sawa
 *
 *	* Sun Feb 08 19:01:54 JST 2015 Naoyuki Sawa
 *	- 1st [XB
 *	* Thu Apr 23 21:42:53 JST 2015 Naoyuki Sawa
 *	- DirSeq_Stop(),DirSeqCh_Stop()ǉ܂B
 *	  oe[uNAɁAݎs̉oV[PX~ꍇɎgp܂B
 *	  Ⴆ΁A'gK'??b'\'s悤ȉoV[PXJnɁA炩̏ł̗\ꍇłB
 *	* Tue May 05 17:15:43 JST 2015 Naoyuki Sawa
 *	- DirSeqCh_SetTblNo()ǉ܂B
 */
#include "clip.h"
/****************************************************************************
 *	[Jϐ
 ****************************************************************************/
static ST_DirSeq stDirSeq;
/****************************************************************************
 *	[J֐錾
 ****************************************************************************/
static void _DirSeq_SetActBuf(void (*fn)(), int arg1, int arg2);
static void _DirSeq_AddActBuf(int ActNo);
static void _DirSeq_GetActBuf(int bOverFlow);
static void _DirSeqCh_Start(int iCh, const uint8_t* p);
static void _DirSeq_Exec();
static void _DirSeqCh_Exec1(int iCh, int bStop);
static void _DirSeqCh_Exec2(int iCh, int bUnlock);
static void _DirSeq_ClrTbl();
static void _DirSeqCh_SetTbl(int iCh, const uint8_t* pDirTbl/*NULL=NA*/);
static void _DirSeq_SendTrig(int iTrig);
static void _DirSeqCh_SendTrig(int iCh, int iTrig);
static void _DirSeq_Unlock();
static void _DirSeqCh_Unlock(int iCh);
static void _DirSeq_Stop();
static void _DirSeqCh_Stop(int iCh);
/****************************************************************************
 *	
 ****************************************************************************/
void DirSeq_Init(void (*fnAct)(int ActNo/*[31]=I[o[t[,[30:24]=`,[23:0]=oԍ*/)) {
	//\̂NAB
	memset(&stDirSeq, 0, sizeof stDirSeq);
	//os֐i[B
	stDirSeq.fnAct = fnAct;
}
/****************************************************************************
 *	
 ****************************************************************************/
static void _DirSeq_SetActBuf(void (*fn)(), int arg1, int arg2) {
	uint8_t ActBuf[DirSeq_ActBufSize][3];	//_DirSeq_SetActBuf()ɂăX^bNɊmۂobt@̃|C^obt@LȊԒ̂ST_DirSeq.pActBufɐݒ肷B[ȃTCY,,X^bNȂ悤DirSeq_ActBufSize𒲐B
	if(stDirSeq.pActBuf) { DIE(); }		//oO
	//oԍobt@ݒ肷B
	stDirSeq.pActBuf = ActBuf;
	//Ŏw肳ꂽ֐sB
	(*fn)(arg1, arg2);
	//oԍSđoB
	while(stDirSeq.ActBufCnt) {
		_DirSeq_GetActBuf(0/*bOverFlow*/);	//ʏ̑oł邱ƂB
	}
	//oԍobt@NAB
	stDirSeq.pActBuf = NULL;
}
/****************************************************************************
 *	
 ****************************************************************************/
static void _DirSeq_AddActBuf(int ActNo) {
	int i;
	if(!stDirSeq.pActBuf) { DIE(); }	//oO
	//oԍobt@ɋ󂫂΁c
	if(stDirSeq.ActBufCnt >= DirSeq_ActBufSize) {
		//oԍoċ󂫂mۂB
		_DirSeq_GetActBuf(1/*bOverFlow*/);	//I[o[t[̑oł邱ƂB
		if(stDirSeq.ActBufCnt >= DirSeq_ActBufSize) { DIE(); }	//oO
	}
	//oԍoԍobt@ɒǉB
	i = stDirSeq.ActBufCnt + stDirSeq.ActBufPos;
	if(i >= DirSeq_ActBufSize) { i -= DirSeq_ActBufSize; }
	stDirSeq.pActBuf[i][0] = ActNo; ActNo >>= 8;
	stDirSeq.pActBuf[i][1] = ActNo; ActNo >>= 8;
	stDirSeq.pActBuf[i][2] = ActNo;
	stDirSeq.ActBufCnt++;
}
/****************************************************************************
 *	
 ****************************************************************************/
static void _DirSeq_GetActBuf(int bOverFlow) {
	int ActNo;
	if(!stDirSeq.pActBuf ||
	   !stDirSeq.ActBufCnt) { DIE(); }	//oO
	//oԍoB
	ActNo  = stDirSeq.pActBuf[stDirSeq.ActBufPos][0];	//
	ActNo |= stDirSeq.pActBuf[stDirSeq.ActBufPos][1] <<  8;	//[23:0]=oԍ
	ActNo |= stDirSeq.pActBuf[stDirSeq.ActBufPos][2] << 16;	//
	ActNo |= bOverFlow                               << 31;	//[31]=I[o[t[,[30:24]=`
	stDirSeq.ActBufCnt--;
	if(++stDirSeq.ActBufPos >= DirSeq_ActBufSize) { stDirSeq.ActBufPos = 0; }
	(*stDirSeq.fnAct)(ActNo);
}
/****************************************************************************
 *	
 ****************************************************************************/
static void _DirSeqCh_Start(int iCh, const uint8_t* p) {
	ST_DirSeqCh* pDirSeqCh;
	int c1, c2;
	//oV[PT`l擾B
	if((unsigned)iCh > (unsigned)DirSeqCh_Max) { DIE(); }	//oO
	pDirSeqCh = &stDirSeq.TBL_DirSeqCh[iCh];
	//s̉oV[PXLΒ~B
	_DirSeqCh_Stop(iCh);
	//ΈʒuƃbNԂ擾B
	c1  =         *p++;
	c1 |=         *p++ <<  8;
	c1 |= (int8_t)*p++ << 16;	//gAYꂸ!!
	c2  =         *p++;
	c2 |=         *p++ <<  8;
	//߈ʒuƃbNԂݒ肷B
	pDirSeqCh->pDirSeq = p + c1;
	pDirSeqCh->LockCnt =     c2;
	//oV[PX̊JnƓɁAoV[PX1t[sB
	_DirSeqCh_Exec1(iCh, 0/*bStop*/);
}
/****************************************************************************
 *	
 ****************************************************************************/
void DirSeq_Exec() {
	if(stDirSeq.pActBuf) {
		_DirSeq_Exec();
	} else {
		_DirSeq_SetActBuf(_DirSeq_Exec, 0/*dummy*/, 0/*dummy*/);
	}
}
/*--------------------------------------------------------------------------*/
static void _DirSeq_Exec() {
	int iCh;
	for(iCh = 0; iCh <= DirSeqCh_Max; iCh++) {
		//oV[PXsB
		_DirSeqCh_Exec1(iCh, 0/*bStop*/);
		//bNobt@sB
		_DirSeqCh_Exec2(iCh, 0/*bUnlock*/);
	}
}
/*--------------------------------------------------------------------------*/
static void _DirSeqCh_Exec1(int iCh, int bStop) {
	ST_DirSeqCh* pDirSeqCh;
	int c1, c2;
	//oV[PT`l擾B
	if((unsigned)iCh > (unsigned)DirSeqCh_Max) { DIE(); }	//oO
	pDirSeqCh = &stDirSeq.TBL_DirSeqCh[iCh];
	//~ɂȂ܂Łc
	while(pDirSeqCh->pDirSeq) {
		//~̏łȂ΁c
		if(!bStop) {
			//҂ԂcĂAB
			if(pDirSeqCh->WaitCnt) { break; }
		//~̏Ȃ΁c
		} else {
			//҂ԂNAB
			pDirSeqCh->WaitCnt = 0;
		}
		//1oCgڂ擾B
		c1 = *pDirSeqCh->pDirSeq++;
		switch(c1) {
		case 0x00://end
			//X^bNL΁c
			if(pDirSeqCh->StackLev) {
				//X^bN炷B
				pDirSeqCh->StackLev--;
				//RepeatX^bNȂ΁c
				if(pDirSeqCh->TBL_StackRep[pDirSeqCh->StackLev]) {
					//~̏łȂ΁c
					if(!bStop) {
						//JԂ񐔂(255),,JԂ񐔂1炵Ă܂cĂc
						if((  pDirSeqCh->TBL_StackRep[pDirSeqCh->StackLev] == 255/**/) ||
						   (--pDirSeqCh->TBL_StackRep[pDirSeqCh->StackLev] != 0)) {
							//߈ʒuݒ肷B
							pDirSeqCh->pDirSeq = pDirSeqCh->TBL_StackRet[pDirSeqCh->StackLev];
							//X^bN𑝂₷B
							pDirSeqCh->StackLev++;
						}
					}
				//CallX^bNȂ΁c
				} else {
					//߈ʒuݒ肷B
					pDirSeqCh->pDirSeq = pDirSeqCh->TBL_StackRet[pDirSeqCh->StackLev];
				}
			//X^bN΁c
			} else {
				//~ɂB
				pDirSeqCh->pDirSeq = NULL;
			}
			break;
		case 0x01://repeat
			//JԂ񐔂擾B
			c2 = *pDirSeqCh->pDirSeq++;
			if(!c2) { DIE(); }	//f[^oO
			//JԂ񐔂Ɩ߈ʒui[B
			if(pDirSeqCh->StackLev >= DirSeqCh_StackSize) { DIE(); }	//X^bN
			pDirSeqCh->TBL_StackRep[pDirSeqCh->StackLev] = c2;
			pDirSeqCh->TBL_StackRet[pDirSeqCh->StackLev] = pDirSeqCh->pDirSeq;
			//X^bN𑝂₷B
			pDirSeqCh->StackLev++;
			break;
		case 0x02://wait
			//҂Ԃ擾B
			c2  = *pDirSeqCh->pDirSeq++;
			c2 |= *pDirSeqCh->pDirSeq++ << 8;
			if(!c2) { DIE(); }	//f[^oO
			//҂Ԃi[B
			pDirSeqCh->WaitCnt = c2;
			break;
		case 0x03://call
			//Έʒu擾B
			c2  =         *pDirSeqCh->pDirSeq++;
			c2 |=         *pDirSeqCh->pDirSeq++ <<  8;
			c2 |= (int8_t)*pDirSeqCh->pDirSeq++ << 16;	//gAYꂸ!!
			//JԂ(0=CallX^bN)Ɩ߈ʒui[B
			if(pDirSeqCh->StackLev >= DirSeqCh_StackSize) { DIE(); }	//X^bN
			pDirSeqCh->TBL_StackRep[pDirSeqCh->StackLev] = 0;
			pDirSeqCh->TBL_StackRet[pDirSeqCh->StackLev] = pDirSeqCh->pDirSeq;
			//X^bN𑝂₷B
			pDirSeqCh->StackLev++;
			//߈ʒuݒ肷B
			pDirSeqCh->pDirSeq += c2;
			break;
		case 0x04://act
		case 0x05://act flush
			//oԍ擾B
			c2 =  *pDirSeqCh->pDirSeq++;
			c2 |= *pDirSeqCh->pDirSeq++ <<  8;
			c2 |= *pDirSeqCh->pDirSeq++ << 16;
			//~̏łȂ,,~ɂs閽(act flush)Ȃ΁c
			if(!bStop || (c1 == 0x05/*act flush*/)) {
				//oԍoԍobt@ɒǉB
				_DirSeq_AddActBuf(c2);
			}
			break;
		default:DIE();
		}
	}
	//~̏łȂ΁c
	if(!bStop) {
		//̂߂ɑ҂Ԃ炷B
		if(pDirSeqCh->WaitCnt) { pDirSeqCh->WaitCnt--; }
	//~̏Ȃ΁c
	} else {
		//҂ԂNAB
		pDirSeqCh->WaitCnt = 0;
	}
}
/*--------------------------------------------------------------------------*/
static void _DirSeqCh_Exec2(int iCh, int bUnlock) {
	ST_DirSeqCh* pDirSeqCh;
	const uint8_t* p;
	//oV[PT`l擾B
	if((unsigned)iCh > (unsigned)DirSeqCh_Max) { DIE(); }	//oO
	pDirSeqCh = &stDirSeq.TBL_DirSeqCh[iCh];
	//bNobt@ɂȂ܂Łc
	while((p = pDirSeqCh->TBL_LockBuf[0])) {
		//bN̏łȂ΁c
		if(!bUnlock) { 
			//bNԂcĂAB
			if(pDirSeqCh->LockCnt) { break; }
		//bN̏Ȃ΁c
		} else { 
			//bNԂNAB
			pDirSeqCh->LockCnt = 0;
		}
		//bNobt@̐擪vf폜B
//{{memmove()̎g͑Sɂ炸VC++6.0ł͌xôňꎞIɌx}ĉB
#ifdef  _MSC_VER
#pragma warning(disable:4090)	//'function' : 'const' Cq͈قȂ܂B
#pragma warning(disable:4022)	//'memmove' : 1 Ԗڂ߲̎̌^Ǎ߲^ƈقȂ܂B
#endif//_MSC_VER
		memmove(&pDirSeqCh->TBL_LockBuf[0],
		        &pDirSeqCh->TBL_LockBuf[1],
		 (sizeof pDirSeqCh->TBL_LockBuf[0]) * (DirSeqCh_LockBufSize - 1));
#ifdef  _MSC_VER
#pragma warning(default:4090)	//'function' : 'const' Cq͈قȂ܂B
#pragma warning(default:4022)	//'memmove' : 1 Ԗڂ߲̎̌^Ǎ߲^ƈقȂ܂B
#endif//_MSC_VER
//}}memmove()̎g͑Sɂ炸VC++6.0ł͌xôňꎞIɌx}ĉB
		         pDirSeqCh->TBL_LockBuf[      (DirSeqCh_LockBufSize - 1)] = NULL;
		//oV[PXJnB
		_DirSeqCh_Start(iCh, p);
	}
	//bN̏łȂ΁c
	if(!bUnlock) { 
		//̂߂ɃbNԂ炷B
		if(pDirSeqCh->LockCnt) { pDirSeqCh->LockCnt--; }
	//bN̏Ȃ΁c
	} else { 
		//bNԂNAB
		pDirSeqCh->LockCnt = 0;
	}
}
/****************************************************************************
 *	
 ****************************************************************************/
void DirSeq_ClrTbl() {
	if(stDirSeq.pActBuf) {
		_DirSeq_ClrTbl();
	} else {
		_DirSeq_SetActBuf(_DirSeq_ClrTbl, 0/*dummy*/, 0/*dummy*/);
	}
}
/*--------------------------------------------------------------------------*/
void _DirSeq_ClrTbl() {
	int iCh;
	for(iCh = 0; iCh <= DirSeqCh_Max; iCh++) {
		DirSeqCh_SetTbl(iCh, NULL);
	}
}
/****************************************************************************
 *	
 ****************************************************************************/
void DirSeqCh_SetTbl(int iCh, const uint8_t* pDirTbl/*NULL=NA*/) {
	if(stDirSeq.pActBuf) {
		_DirSeqCh_SetTbl(iCh, pDirTbl);
	} else {
		_DirSeq_SetActBuf(_DirSeqCh_SetTbl, iCh, (int)pDirTbl);
	}
}
/*--------------------------------------------------------------------------*/
void _DirSeqCh_SetTbl(int iCh, const uint8_t* pDirTbl/*NULL=NA*/) {
	ST_DirSeqCh* pDirSeqCh;
	//oV[PT`l擾B
	if((unsigned)iCh > (unsigned)DirSeqCh_Max) { DIE(); }	//oO
	pDirSeqCh = &stDirSeq.TBL_DirSeqCh[iCh];
	//'clr'gK𑗐MB
	DirSeqCh_SendTrig(iCh, 255/*clr*/);
	//oe[uݒ肷B
	pDirSeqCh->pDirTbl = pDirTbl;
	//'set'gK𑗐MB
	DirSeqCh_SendTrig(iCh,   0/*set*/);
}
/****************************************************************************
 *	
 ****************************************************************************/
void DirSeq_SendTrig(int iTrig) {
	if(stDirSeq.pActBuf) {
		_DirSeq_SendTrig(iTrig);
	} else {
		_DirSeq_SetActBuf(_DirSeq_SendTrig, iTrig, 0/*dummy*/);
	}
}
/*--------------------------------------------------------------------------*/
static void _DirSeq_SendTrig(int iTrig) {
	int iCh;
	for(iCh = 0; iCh <= DirSeqCh_Max; iCh++) {
		DirSeqCh_SendTrig(iCh, iTrig);
	}
}
/****************************************************************************
 *	
 ****************************************************************************/
void DirSeqCh_SendTrig(int iCh, int iTrig) {
	if(stDirSeq.pActBuf) {
		_DirSeqCh_SendTrig(iCh, iTrig);
	} else {
		_DirSeq_SetActBuf(_DirSeqCh_SendTrig, iCh, iTrig);
	}
}
/*--------------------------------------------------------------------------*/
static void _DirSeqCh_SendTrig(int iCh, int iTrig) {
	ST_DirSeqCh* pDirSeqCh;
	const uint8_t* p;
	int i, c1, c2;
	//oV[PT`l擾B
	if((unsigned)iCh > (unsigned)DirSeqCh_Max) { DIE(); }	//oO
	pDirSeqCh = &stDirSeq.TBL_DirSeqCh[iCh];
	//oe[u𑖍āc
	p = pDirSeqCh->pDirTbl;
	while(p) {
		//1oCgڂ擾B
		c1 = *p++;
		switch(c1) {
		case 0x00://end
			p = NULL;
			break;
		case 0x06://on
		case 0x07://on unlock
			//gKԍ擾B
			c2 = *p++;
			//gKԍvc
			if(c2 == iTrig) {
				//bN閽(on unlock)Ȃ΁c
				if(c1 == 0x07/*on unlock*/) {
					//bNB
					DirSeqCh_Unlock(iCh);
				}
				//bNobt@ɋ󂫂΁c
				if(pDirSeqCh->TBL_LockBuf[(DirSeqCh_LockBufSize - 1)]) {
					//݂̃bNԂIɃNAB
					pDirSeqCh->LockCnt = 0;
					//Œȏ̉oV[PXJnA󂫂mۂB
					_DirSeqCh_Exec2(iCh, 0/*bUnlock*/);
					if(pDirSeqCh->TBL_LockBuf[(DirSeqCh_LockBufSize - 1)]) { DIE(); }	//oO
				}
				//bNobt@łȂ΁c
				if(pDirSeqCh->TBL_LockBuf[0]) {
					//bNobt@̍ŏ̋󂫗vf̈ʒuB
					//̏ŋ󂫂mۍς݂Ȃ̂ŁAȂƂŏIvf󂫂łB
					for(i = 0; i < DirSeqCh_LockBufSize - 1/*LRgQ*/; i++) {
						if(!pDirSeqCh->TBL_LockBuf[i]) { break; }
					}
					//bNobt@̍ŏ̋󂫗vf̈ʒuɉoV[PXi[B
					pDirSeqCh->TBL_LockBuf[i] = p;
				//bNobt@Ȃ΁c
				} else {
					//bNԂcĂc
					if(pDirSeqCh->LockCnt) {
						//bNobt@̐擪ɉoV[PXi[B
						pDirSeqCh->TBL_LockBuf[0] = p;
					//bNԂcĂȂ΁c
					} else {
						//oV[PXJnB
						_DirSeqCh_Start(iCh, p);
					}
				}
			}
			//ΈʒuƃbNԂǂݔ΂B
			p += (3/*Έʒu*/ + 2/*bN*/);
			break;
		default:DIE();
		}
	}
}
/****************************************************************************
 *	
 ****************************************************************************/
void DirSeq_Unlock() {
	if(stDirSeq.pActBuf) {
		_DirSeq_Unlock();
	} else {
		_DirSeq_SetActBuf(_DirSeq_Unlock, 0/*dummy*/, 0/*dummy*/);
	}
}
/*--------------------------------------------------------------------------*/
static void _DirSeq_Unlock() {
	int iCh;
	for(iCh = 0; iCh <= DirSeqCh_Max; iCh++) {
		DirSeqCh_Unlock(iCh);
	}
}
/****************************************************************************
 *	
 ****************************************************************************/
void DirSeqCh_Unlock(int iCh) {
	if(stDirSeq.pActBuf) {
		_DirSeqCh_Unlock(iCh);
	} else {
		_DirSeq_SetActBuf(_DirSeqCh_Unlock, iCh, 0/*dummy*/);
	}
}
/*--------------------------------------------------------------------------*/
static void _DirSeqCh_Unlock(int iCh) {
	_DirSeqCh_Exec2(iCh, 1/*bUnlock*/);
}
/****************************************************************************
 *	
 ****************************************************************************/
void DirSeq_Stop() {
	if(stDirSeq.pActBuf) {
		_DirSeq_Stop();
	} else {
		_DirSeq_SetActBuf(_DirSeq_Stop, 0/*dummy*/, 0/*dummy*/);
	}
}
/*--------------------------------------------------------------------------*/
static void _DirSeq_Stop() {
	int iCh;
	for(iCh = 0; iCh <= DirSeqCh_Max; iCh++) {
		DirSeqCh_Stop(iCh);
	}
}
/****************************************************************************
 *	
 ****************************************************************************/
void DirSeqCh_Stop(int iCh) {
	if(stDirSeq.pActBuf) {
		_DirSeqCh_Stop(iCh);
	} else {
		_DirSeq_SetActBuf(_DirSeqCh_Stop, iCh, 0/*dummy*/);
	}
}
/*--------------------------------------------------------------------------*/
static void _DirSeqCh_Stop(int iCh) {
	_DirSeqCh_Exec1(iCh, 1/*bStop*/);
}
/****************************************************************************
 *	dDirSeqC.exeo͂oCi`߂̃[eBeB֐
 ****************************************************************************/
#ifdef  USE_DIRSEQ_BIN
void DirSeqCh_SetTblNo(int iCh, const void* pDirSeqBin, int iDirTblNo) {
	const int* const TBL_DirTblNo = pDirSeqBin;						//oCi̐擪ɃAhXe[uLBAhX̓f[^{(BYTEz)̃CfNXłB
	const int nDirTblNo = TBL_DirTblNo[0];							//AhXe[u̐擪[0]ɗvfĂBvf͂ꎩg([0])܂ށB
	const unsigned char* const TBL_DirSeq = (const unsigned char*)&TBL_DirTblNo[nDirTblNo];	//AhXe[u̒ォf[^{(BYTEz)JnB
	if((iDirTblNo <= 0) || (iDirTblNo >= nDirTblNo)) { DIE(); }
	DirSeqCh_SetTbl(iCh, &TBL_DirSeq[TBL_DirTblNo[iDirTblNo]]);
}
#endif//USE_DIRSEQ_BIN
