/*
 *	main.c
 *
 *	^[OXL[ǂ
 *
 *	* Sat Feb 06 13:09:42 JST 2010 Naoyuki Sawa
 *	- 1st [XB
 */
#include "app.h"

/****************************************************************************
 *	
 ****************************************************************************/

#ifdef USE_MUSIC
#include "instdef2.c"
#endif /*USE_MUSIC*/

#ifdef USE_SOUND
const void* sound_table[SOUND_COUNT];
#endif /*USE_SOUND*/

#ifdef USE_TEXTURE
TEXTURE texture_table[TEXTURE_COUNT];
#endif /*USE_TEXTURE*/

#ifdef USE_SPRITE
#define SPRITE_ SPRITE_INIT2
const SPRITE sprite_table[SPRITE_COUNT] = {
#include "sprite.h"
};
#undef SPRITE_
#endif /*USE_SPRITE*/

#define extern
#include "work.h"
#undef extern

/****************************************************************************
 *	main
 ****************************************************************************/

int
main()
{
	/* B */
	app_init();

	/* C[vB */
	for(;;) {
		if(demo_main() < 0) {
			break;
		}
		game_main();
	}

	return 0;
}

/****************************************************************************
 *	app_init
 ****************************************************************************/

void
app_init()
{
	/* ʓIȏB */
	pceAppSetProcPeriod(1000 / FPS);
#ifdef V_SCREEN
	pceLCDSetBuffer(_def_vbuff);
#else /*V_SCREEN*/
	pceLCDSetBuffer(vbuff);
#endif /*V_SCREEN*/
	pceLCDDispStart();
#ifdef REPEAT_PAD
	pad_set_repeat(REPEAT_PAD, REPEAT_DELAY, REPEAT_INTERVAL);
#endif /*REPEAT_PAD*/

	/* `B */
	surface.w = DISP_X;
	surface.h = DISP_Y;
	surface.vbuff = vbuff;
#ifdef USE_3D
	surface.zbuff = zbuff;
	render_init_3d(&render, &surface, 0, 0, 0, 0, FRONT, BACK, FOVY);
#else /*USE_3D*/
	render_init_2d(&render, &surface, 0, 0, 0, 0);
#endif /*USE_3D*/
#ifdef USE_RENDF
	surface.zbuff = zbuff;
	rendf_init(&rendf, &surface, 0, 0, 0, 0, FRONT, BACK, FOVY);
#endif /*USE_RENDF*/

#if defined(TRACE_ON) && (TRACE_ON)
	/* WG[o͂J܂B */
	stderr_open(9/*WG[o̓j^ڑ҂()*/);
#endif /*TRACE_ON*/

#ifdef USE_UFE
	/* USBt@CVXeG~[VJn܂B */
	ufe_setup(9/*PCt@CT[oڑ҂()*/);
#endif /*USE_UFE*/

#ifdef RESOURCE_FNAME
	/* pext@CYt\[X擾܂B */
	resource = resource_address(RESOURCE_FNAME);
#endif /*RESOURCE_FNAME*/

#ifdef TURBO
	/* NbNEEFCgؑւ܂B */
	turbo(TURBO);
#endif /*TURBO*/

#ifdef USE_DBG
	/* DBGjbgݒ肵܂B */
	dbg_init();
#endif /*USE_DBG*/

#ifdef USE_GC
	/* K[x[WRN^[܂B */
	gc_init();
#endif /*USE_GC*/

#ifdef USE_TCPIP
	/* TCP/IPvgRXC[gJn܂B */
	tcpip_start(0/*EthernethCoMobt@TCY()*/);
#endif /*USE_TCPIP*/

#ifdef LDIRECT_INTERVAL
	/* ؑցE16K\܂B */
	ldirect_init(LDIRECT_INTERVAL);
#endif /*LDIRECT_INTERVAL*/

#ifdef USE_MUSIC
	/* yCu܂B */
	music_loudness(1);
	loadInst(); /* uRandomism Zone(http://www8.plala.or.jp/randomism/)v́whFLbgver.2.10xgp */
	InitMusic();
#endif /*USE_MUSIC*/

	/* N[Abv֐o^B */
	atexit(app_exit);

#ifdef USE_2BIT_ADPCM
	/* 2-bit ADPCM DecoderN܂B */
	adpcm_init(ADPCM_CHANNELS);
#endif /*USE_2BIT_ADPCM*/

	/* TEh܂B */
#ifdef USE_SOUND
	{
#define SOUND_(name) { extern const unsigned char name[]; sound_table[SND_##name] = name; }
#define SOUND_RESOURCE_(name,fname) { sound_table[SND_##name] = fpk_address(resource, fname, NULL); }
#include "sound.h"
#undef SOUND_
#undef SOUND_RESOURCE_
	}
#endif /*USE_SOUND*/

	/* eNX`܂B */
#ifdef USE_TEXTURE
	{
#define TEXTURE_(name) extern const unsigned char name[];
#define TEXTURE_RESOURCE_(name,fname) const void* const name = fpk_address(resource, fname, NULL);
#include "texture.h"
#undef TEXTURE_
#undef TEXTURE_RESOURCE_
		texture_table_init(texture_table, TEXTURE_COUNT,
#define TEXTURE_(name) name,
#define TEXTURE_RESOURCE_(name,fname) name,
#include "texture.h"
#undef TEXTURE_
#undef TEXTURE_RESOURCE_
		NULL/*Ō','z邽߂̃_~[Btexture_table_init()ɑ΂Ă͖ӖłB*/);
	}
#endif /*USE_TEXTURE*/

#ifdef USE_SPRITE
	/* ȈՃXvCghCo܂B */
	sprite_init(&render, sprite_table, SPRITE_COUNT, texture_table, TEXTURE_COUNT);
#endif /*USE_SPRITE*/

#ifdef USE_VIDREC
	/* ʏo͂܂B */
	yield(); /* runŎsꍇ̎smFɉ邽߁AUSB@\̐؂ւ͂ɒx点 */
#ifdef LDIRECT_INTERVAL
	cdcacm_start(0, sizeof vbuff / 2, NULL, NULL);
#else /*LDIRECT_INTERVAL*/
	cdcacm_start(0, sizeof vbuff / 4, NULL, NULL);
#endif /*LDIRECT_INTERVAL*/
#endif /*USE_VIDREC*/

/*{{AvP[VL̏*/
	srand(pceTimerGetCount());

	/* t̕`B
	 * tp̉zVRAMʂɗpӂāA`悵Ăʏ̉zVRAMɃRs[*̂ł͂Ȃ*A
	 * ʏ̉zVRAM̉t_ƂNbsÖݒ肵āAڕ`悷悤ɂ܂B
	 */
	lsurf.w = DISP_X;
	lsurf.h = DISP_Y;
	lsurf.vbuff = &vbuff[DISP_X * LCD_Y + LCD_X];
	render_init_2d(&lrend, &lsurf, 0, 0, LCD_W, LCD_H);

	/* XvCg͉tɕ`悷B */
	sprite_driver.render = &lrend;

	/* P[Xƃ{^render_object()ŕ`悷B */
	render.context->texture = &texture_table[TEX_CASE];

	/* TEh */
	stream_play(320, stream_callback, 0, 0);
/*}}AvP[VL̏*/
}

/****************************************************************************
 *	app_exit
 ****************************************************************************/

void
app_exit()
{
/*{{AvP[VL̃N[Abv*/
	/** no job **/
/*}}AvP[VL̃N[Abv*/

#ifdef USE_VIDREC
	/* ʏo͂I܂B */
	cdcacm_stop();
#endif /*USE_VIDREC*/

#ifdef USE_MUSIC
	/* mɉyt~܂B
	 * TEh̒~̓CupceAppExit()ōsĂ̂ŁA
	 * ł͕Kv܂B
	 */
	StopMusic();
	music_loudness(0);
#endif /*USE_MUSIC*/

#ifdef LDIRECT_INTERVAL
	/* ؑցE16K\܂B */
	ldirect_free();
#endif /*LDIRECT_INTERVAL*/

#ifdef USE_TCPIP
	/* TCP/IPvgRXC[gI܂B */
	tcpip_stop();
#endif /*USE_TCPIP*/

#ifdef USE_GC
	/* K[x[WRN^[܂B */
	gc_free();
#endif /*USE_GC*/

#ifdef USE_DBG
	/* DBGjbg̐ݒ܂B */
	dbg_free();
#endif /*USE_DBG*/

#ifdef USE_UFE
	/* USBt@CVXeG~[VI܂B */
	ufe_stop();
#endif /*USE_UFE*/
}

/****************************************************************************
 *	update
 ****************************************************************************/

/* * Mon Mar 10 13:29:56 JST 2008 Naoyuki Sawa
 * - update()AʍXV𕪗A܂B
 */
#ifdef V_SCREEN
/* vbuff(c)_def_vbuff()ϊ */
//static void rotate_screen() {
//	unsigned char *src = &vbuff[88 - 1];	/* ]̉ʂ͍ォ瑖Jn܂ */
//	unsigned char *dst = &_def_vbuff[0];	/* ]̏cʂ͉Eォ瑖Jn܂ */
//	int x = 88;
//	do {
//		int y = 128;
//		do {
//			*dst++ = *src;		/* ʂEɑ܂ */
//			src += 88;		/* cʂɑ܂ */
//		} while(--y);
//						/* ʂ͊Ɏ̍sֈړĂ܂ */
//		src -= 88 * 128 + 1;		/* cʂ̗̈ԏֈړ܂ */
//	} while(--x);
//}
// (C = 9.2ms/1call  ASM = 3.2ms/1call)
/*static*/ void rotate_screen();
asm("
	.code
	.align	1
rotate_screen:
	xld.w	%r12, 0x0e00			; %r12 := FRAM4_START
	xld.w	%r13, rotate_screen_DOX		; %r13 := DOY
	xld.w	%r14, rotate_screen_END		; %r14 := END
	xcall.d	memcpy				; %r10 := FRAM4_START = memcpy(FRAM4_START, DOX, END - DOX)
	sub	%r14, %r13			; %r14 := END - DOY			*delay*
	xld.w	%r4, vbuff+87			; %r4  := src = &vbuff[88 - 1]
	xld.w	%r5, _def_vbuff			; %r5  := dst = &_def_vbuff[0]
	xld.w	%r6, 88				; %r6  := 88
	xld.w	%r7, 128			; %r7  := 128
	xld.w	%r11, 11265			; %r11 := 88 * 128 + 1
	ld.w	%r12, %r6			; %r12 := x = 88
	jp	%r10				; goto FRAM4_START			(jp.d͕s!!)
;//{{FRAM4̈֓]
rotate_screen_DOX:				; do {
	ld.w	%r13, %r7			;   %r13 := y = 128
rotate_screen_DOY:				;   do {
	ld.ub	%r9, [%r4]			;     %r9  := c = *src
	sub	%r13, 1				;     %r13 := --y			*anti-interlock*
	ld.b	[%r5]+, %r9			;     %r5  := *dst++ = c
	jrne.d	rotate_screen_DOY		;   } while(--y)
	add	%r4, %r6			;     %r4  := src += 88			*delay*
	sub	%r12, 1				;   %r12 := --x
	jrne.d	rotate_screen_DOX		; } while(--x)
	sub	%r4, %r11			;   %r4  := src -= 88 * 128 + 1		*delay*
	ret
rotate_screen_END:
;//}}܂FRAM4̈֓]
");
#endif /*V_SCREEN*/

/* * Mon Nov 06 17:37:17 JST 2006 Naoyuki Sawa
 * - schedule()AʍXV𕪗܂B
 *   t[҂ʍXVsꍇ́Å֐ĂяoĂB
 */
void
update()
{
#ifdef V_SCREEN
	rotate_screen();
#endif /*V_SCREEN*/

	/* ʓ] */
	pceLCDTrans();
}

/****************************************************************************
 *	vidrec
 ****************************************************************************/

#ifdef USE_VIDREC
static void
vidrec()
{
#ifdef LDIRECT_INTERVAL
	static const unsigned char hdr[4] = { DISP_X,DISP_Y,4/*[bpp]*/,FPS };
#else /*LDIRECT_INTERVAL*/
	static const unsigned char hdr[4] = { DISP_X,DISP_Y,2/*[bpp]*/,FPS };
#endif /*LDIRECT_INTERVAL*/
	static int active;
	//
	unsigned char buf[128/**/]; /* (sizeof vbuff)/ÑTCYƂ邱 */
	const unsigned char* src;
	unsigned char* dst;

	if(cdcacm_recv(buf, 1) > 0) {
		switch(buf[0]) {
		case 0:
			active = 0; /* ʏo͒~ */
			break;
		case 1:
			active = 1; /* ʏo͊Jn */
			src = hdr;
			do {
				if(pcePadGetDirect() & PAD_SELECT) {
					exit(0); /* M҂Ɋ荞ŋI */
				}
				src += cdcacm_send(src, &hdr[sizeof hdr] - src);
			} while(src < &hdr[sizeof hdr]);
			break;
		}
	}
	if(active) {
		src = vbuff;
		do {
			dst = buf;
			do {
#ifdef LDIRECT_INTERVAL
				*dst++ = src[0]|(src[1]<<4); 
				src += 2;
#else /*LDIRECT_INTERVAL*/
				*dst++ = src[0]|(src[1]<<2)|(src[2]<<4)|(src[3]<<6);
				src += 4;
#endif /*LDIRECT_INTERVAL*/
			} while(dst < &buf[sizeof buf]);
			dst = buf;
			do {
				if(pcePadGetDirect() & PAD_SELECT) {
					exit(0); /* M҂Ɋ荞ŋI */
				}
				dst += cdcacm_send(dst, &buf[sizeof buf] - dst);
			} while(dst < &buf[sizeof buf]);
		} while(src < &vbuff[sizeof vbuff]);
	}
}
#endif /*USE_VIDREC*/

/****************************************************************************
 *	schedule
 ****************************************************************************/

/* * Fri Dec 15 00:49:15 JST 2006 Naoyuki Sawa
 * - schedule()֐ɁATEh|[YΉR[hǉ܂B
 *   ł͏肭삵Ă悤łAX[v̕Aɖ肪NȂmFłB
 * - A|[YԂ̂܂܁AȂ킿ATEh|[YԂ̂܂܂ŃAvP[VIĂ܂ꍇɂA
 *   CLiPCupceAppExit()pceWaveStop(1)ĂяoĂATEhԂZbĝŁAvłB
 */

void
schedule()
{
#ifdef USE_PAUSE
	{
		/* PAUSEbZ[Ẅ̃C[Wޔpobt@́A324oCgKvłB
		 * X^bNɎ̂͊댯łAstaticɎ̖̂ʂłB
		 * ŁAPAUSEɂ̂݃q[vmۂ邱Ƃɂ܂B
		 */
		//unsigned char save[PAUSE_H][PAUSE_W];
		unsigned char (*save)[PAUSE_W] = NULL/*x}*/;
		int pause = 0;
		/*{{2006/12/15:TEh|[YΉ*/
		int sound_pause = 0/*x}*/;
		/*}}2006/12/15:TEh|[YΉ*/
		int x, y;
		for(;;) {
#endif /*USE_PAUSE*/
			/* ʍXVB */
			update();
#ifdef USE_VIDREC
			/* ʏóB */
			vidrec();
#endif /*USE_VIDREC*/
			/* VXeB */
#ifdef USE_IDLE
			idle_yield();
#else /*USE_IDLE*/
			yield();
#endif /*USE_IDLE*/
			/* pbhԍXVB */
			joy = pad_get();
#ifdef V_SCREEN
			joy = (joy & ~(PAD_LF | PAD_RI | PAD_UP | PAD_DN | /* cʗp͕ϊ */
				       TRG_LF | TRG_RI | TRG_UP | TRG_DN))
				| (joy & PAD_LF ? PAD_UP : 0)
				| (joy & PAD_RI ? PAD_DN : 0)
				| (joy & PAD_UP ? PAD_RI : 0)
				| (joy & PAD_DN ? PAD_LF : 0)
				| (joy & TRG_LF ? TRG_UP : 0)
				| (joy & TRG_RI ? TRG_DN : 0)
				| (joy & TRG_UP ? TRG_RI : 0)
				| (joy & TRG_DN ? TRG_LF : 0);
#endif /*V_SCREEN*/

#ifdef USE_PAUSE
			/* PAUSEB */
			if(joy & TRG_START) {
				pause = !pause;	/* PAUSEԐ؂ւ */
				if(pause) {	/* PAUSE IN */
					/*{{2006/12/15:TEh|[YΉ*/
					ENTER_CS;
					sound_pause = fINT_EDMA.EHDM1;
					if(sound_pause) {
						fINT_EDMA.EHDM1 = 0;
					}
					LEAVE_CS;
					/*}}2006/12/15:TEh|[YΉ*/
					/* PAUSEbZ[W\̃C[WޔB */
					save = (unsigned char (*)[PAUSE_W])malloc(PAUSE_W * PAUSE_H); /* C[Wޔpobt@m */
					if(save == NULL) DIE();
					for(y = 0; y < PAUSE_H; y++) {
						for(x = 0; x < PAUSE_W; x++) {
							save[y][x] = vbuff[DISP_X * (PAUSE_Y + y) + (PAUSE_X + x)];
						}
					}
				} else {	/* PAUSE OUT */
					/*{{2006/12/15:TEh|[YΉ*/
					ENTER_CS;
					if(sound_pause) {
						fINT_EDMA.EHDM1 = 1;
					}
					LEAVE_CS;
					/*}}2006/12/15:TEh|[YΉ*/
					/* PAUSEbZ[W\̃C[W𕜋AB */
					for(y = 0; y < PAUSE_H; y++) {
						for(x = 0; x < PAUSE_W; x++) {
							vbuff[DISP_X * (PAUSE_Y + y) + (PAUSE_X + x)] = save[y][x];
						}
					}
					free(save); /* C[Wޔpobt@J */
				}
			}
			if(!pause) break;

			/* PAUSEbZ[W_ŕ\B */
			if(pceTimerGetCount() % 1000 < 750) {
				render_string_framed(&render, PAUSE_X, PAUSE_Y, PAUSE_STR, PAUSE_FONT, PAUSE_COLOR);
			} else {
				for(y = 0; y < PAUSE_H; y++) {
					for(x = 0; x < PAUSE_W; x++) {
						vbuff[DISP_X * (PAUSE_Y + y) + (PAUSE_X + x)] = save[y][x];
					}
				}
			}
		}
	}
#endif /*USE_PAUSE*/

	now++;	/* O[o^C}XV */
}

/****************************************************************************
 *	demo_main
 ****************************************************************************/

void bg_draw() {
	/* P[X */
	render_object(&render, 0, 0, 0, 0, 128, 88, 0);

	/* {^ */
	if(joy & (PAD_LF | PAD_B)) {
		render_object(&render, LEFT_X, LEFT_Y, BUTTON_X, BUTTON_Y, BUTTON_W, BUTTON_H, 0);
	}

	/* E{^ */
	if(joy & (PAD_RI | PAD_A)) {
		render_object(&render, RIGHT_X, RIGHT_Y, BUTTON_X, BUTTON_Y, BUTTON_W, BUTTON_H, 0);
	}

	/* twi */
	sprite_draw(0, 0, SPR_BG, 0);
}

int demo_main() {
	int i;
	int x;
	int y;

	i = game.score;
	memset(&game, 0, sizeof game);
	game.score = i;

	for(;;) {
		schedule();

		/* wi` */
		bg_draw();

		/* r` */
		for(i = 0; i < 5; i++) {
			bild_draw(i);
		}

		/* ^Cg` */
		x = 19;
		y = 4;
		sprite_draw(x, y, SPR_TITLE_W, 0);
		sprite_draw(x, y, SPR_TITLE_B, 0);

		/* XRA` */
		score_draw();

		if(joy & TRG_AB) {
			return 0; /* Q[Jn */
		}
		if(joy & TRG_SELECT) {
			return -1; /* I */
		}
	}
}

/****************************************************************************
 *	game_main
 ****************************************************************************/

void game_main() {
	int t1 = 0;
	int t2 = 0;
	int i;

	game_init();
	snd_set(1);

	for(;;) {
		schedule();

		/* ANV */
		for(i = 0; i < 5; i++) {
			bild_action(i);
		}
		heli_action();
		if(!game.miss) {
			man_gen();
		}

		/* ` */
		bg_draw();
		for(i = 0; i < 5; i++) {
			bild_draw(i);
		}
		heli_draw();
		efct_draw();
		if(game.miss || game.score_cnt) {
			game.score_cnt--;
			score_draw();
		}

		if(!game.miss) {
			if(t1++ < SEC(1.5)) {
				sprite_draw(19, 8, SPR_GETREADY_B, 0);
				sprite_draw(19, 8, SPR_GETREADY_W, 0);
			}
		} else {
			if(!t2) {
				snd_set(2);
			}
			if(t2++ > SEC(1.5)) {
				sprite_draw(19, 8, SPR_GAMEOVER_B, 0);
				sprite_draw(19, 8, SPR_GAMEOVER_W, 0);
				if(joy & TRG_AB) {
					return; /* ^Cg֖߂ */
				}
			}
		}
		if(joy & TRG_SELECT) {
			return; /* ^Cg֖߂ */
		}
	}
}

/****************************************************************************
 *	game_init
 ****************************************************************************/

void game_init() {
	memset(&game, 0, sizeof game);

	game.score_cnt = SEC(3);

	game.gen_itv = SEC(5) * 100;
	game.gen_cnt = SEC(2) * 100;

	game.heli_col = 4;
}

/****************************************************************************
 *	lo
 ****************************************************************************/

/* lo */
void man_gen() {
	BILD* bild;
	int i;

	/* ܂^CAEgĂȂ΁Alo҂JEg炷 (100Pʂł邱Ƃɒ) */
	if(game.gen_cnt > 0) {
		game.gen_cnt -= 100;
	}
	/* lo҂JEgA^CAEgc */
	if(game.gen_cnt <= 0) {
		/* oIB܃w͏O */
		do {
			i = RND32_RANGE(seed, 0, 4);
		} while(i == game.heli_col);
		bild = &game.bild[i];
		/* ̗̃rɐlȂ΁Ao */
		if(!bild->stat) {
			bild->stat = 1;
			bild->cnt = 0;
			snd_set(3);
			{
				long tmp; /* 16bit CPU ΍ */
				/* C^[o炷 */
				tmp = game.gen_itv;
				tmp *= (long)GEN_ITV_RATE;
				tmp /= (long)100;
				game.gen_itv = tmp;
				/* ̑҂Ԃ߂ */
				tmp *= (long)RND32_RANGE(seed, 50, 100); /* (C^[o~50`100%ŗh炷Ƃɂ) */
				tmp /= (long)100;
				game.gen_cnt = tmp;
			}
		}
	}
}

/****************************************************************************
 *	XRA
 ****************************************************************************/

void score_add(int n) {
	game.score += n;
	if(game.score > 999) {
		game.score = 999;
	}
	game.score_cnt = SEC(3);
}

void score_draw() {
	int n = game.score;
	int x = 72 - 5;
	int y = 32 - 7;
	int i;

	do {
		i = n % 10;
		sprite_draw(x, y, SPR_NUM0_B + i, 0);
		sprite_draw(x, y, SPR_NUM0_W + i, 0);

		x -= 4;
		n /= 10;
	} while(n);
}

/****************************************************************************
 *	w
 ****************************************************************************/

/* wANV */
void heli_action() {
	BILD* bild;
	EFCT* efct;
	int i;
	int n;
	float d1;
	float d2;

	switch(game.heli_stat) {
	case 0: /* ʏ */
		if(game.miss) {
			return;
		}
		/* {^ꂽAֈړJnB
		 * ÖړĂȂ΁Äʒuł̋~΂B
		 */
		if(joy & (TRG_LF | TRG_B)) {
			game.heli_col--;
			if(game.heli_col == -1) { /* NbV */
				game.miss = 1;
				game.heli_stat = 3;
				game.heli_cnt = 0;
				goto L_CRASH;
			}
			game.heli_cnt = 3;
		/* E{^ꂽAEֈړJnB
		 * ÖړĂȂ΁Äʒuł̋~΂B
		 */
		} else if(joy & (TRG_RI | TRG_A)) {
			game.heli_col++;
			if(game.heli_col == 5) { /* ENbV */
				game.miss = 1;
				game.heli_stat = 3;
				game.heli_cnt = 0;
				goto L_CRASH;
			}
			game.heli_cnt = -3;
		/* EĂȂ΁c */
		} else {
			/* ړȂ΁Aړp */
			if(game.heli_cnt < 0) {
				game.heli_cnt++;
			} else if(game.heli_cnt > 0) {
				game.heli_cnt--;
			/* ړĂc */
			} else {
				bild = &game.bild[game.heli_col];
				/* ЊQȑȂ΁c */
				if((game.heli_col >= 0) && (game.heli_col <= 3)) {
					/* l2l݂邵ĂȂ΁c */
					if(game.heli_man < 2) {
						/* lc */
						if((bild->stat == 1) && (bild->cnt >= 5)) {
							game.heli_stat = 1; /* ~Jn */
							//game.heli_cnt = 0;  0ł
							goto L_ROPE;
						}
					}
				/* ȑȂ΁c */
				} else if(game.heli_col == 4) {
					/* l݂邵Ăc */
					if(game.heli_man) {
						game.heli_stat = 2; /* Jn */
						//game.heli_cnt = 0;  0
						goto L_ESCP;
					}
				}
			}
		}
		break;

	case 1: /* ~ */
		if(game.miss) {
			return;
		}
		game.heli_cnt++;
L_ROPE:
		bild = &game.bild[game.heli_col];
		switch(game.heli_col) {
		case 1: /* 1i */
			if(game.heli_man == 0) { /* 1l */
				if(!((game.heli_cnt - 4) & 3)) {
					snd_set(4);
				}
				if(game.heli_cnt == 4) {
					/* rhoĂ(oroĂ)~oƁAeNjJ{[iX */
					if(bild->cnt >= WARN_TIME) {
						score_add(1);
					}
					/* rl */
					bild->stat = 0;
				} else if(game.heli_cnt == 7) {
					/* ݂グ */
					game.heli_stat = 0;
					game.heli_cnt = 0;
					game.heli_man++;
					return; /* ܂ */
				}
			} else { /* 2l */
				if(!((game.heli_cnt - 0) & 3)) {
					snd_set(4);
				}
				if(game.heli_cnt == 0) {
					/* rhoĂ(oroĂ)~oƁAeNjJ{[iX */
					if(bild->cnt >= WARN_TIME) {
						score_add(1);
					}
					/* rl */
					bild->stat = 0;
				} else if(game.heli_cnt == 3) {
					/* ݂グ */
					game.heli_stat = 0;
					game.heli_cnt = 0;
					game.heli_man++;
					return; /* ܂ */
				}
			}
			break;
		case 2: /* 3i */
			if(game.heli_man == 0) { /* 1l */
				if(!((game.heli_cnt - 12) & 3)) {
					snd_set(4);
				}
				if(game.heli_cnt == 12) {
					/* rhoĂ(oroĂ)~oƁAeNjJ{[iX */
					if(bild->cnt >= WARN_TIME) {
						score_add(1);
					}
					/* rl */
					bild->stat = 0;
				} else if(game.heli_cnt == 23) {
					/* ݂グ */
					game.heli_stat = 0;
					game.heli_cnt = 0;
					game.heli_man++;
					return; /* ܂ */
				}
			} else { /* 2l */
				if(!((game.heli_cnt - 7) & 3)) {
					snd_set(4);
				}
				if(game.heli_cnt == 7) {
					/* rhoĂ(oroĂ)~oƁAeNjJ{[iX */
					if(bild->cnt >= WARN_TIME) {
						score_add(1);
					}
					/* rl */
					bild->stat = 0;
				} else if(game.heli_cnt == 18) {
					/* ݂グ */
					game.heli_stat = 0;
					game.heli_cnt = 0;
					game.heli_man++;
					return; /* ܂ */
				}
			}
			break;
		default/*0,3*/: /* 2i */
			if(game.heli_man == 0) { /* 1l */
				if(!((game.heli_cnt - 8) & 3)) {
					snd_set(4);
				}
				if(game.heli_cnt == 8) {
					/* rhoĂ(oroĂ)~oƁAeNjJ{[iX */
					if(bild->cnt >= WARN_TIME) {
						score_add(1);
					}
					/* rl */
					bild->stat = 0;
				} else if(game.heli_cnt == 15) {
					/* ݂グ */
					game.heli_stat = 0;
					game.heli_cnt = 0;
					game.heli_man++;
					return; /* ܂ */
				}
			} else { /* 2l */
				if(!((game.heli_cnt - 3) & 3)) {
					snd_set(4);
				}
				if(game.heli_cnt == 3) {
					/* rhoĂ(oroĂ)~oƁAeNjJ{[iX */
					if(bild->cnt >= WARN_TIME) {
						score_add(1);
					}
					/* rl */
					bild->stat = 0;
				} else if(game.heli_cnt == 10) {
					/* ݂グ */
					game.heli_stat = 0;
					game.heli_cnt = 0;
					game.heli_man++;
					return; /* ܂ */
				}
			}
			break;
		}
		break;

	case 2: /*  */
		if(game.miss) {
			return;
		}
		game.heli_cnt++;
L_ESCP:
		bild = &game.bild[game.heli_col];
		if(game.heli_cnt == 3) {
			/* rɐlu */
			bild->stat = game.heli_man;
			bild->cnt = 0;
			/* XRAZB
			 * lÂĂAlÂĂA1_Ƃ邱Ƃɂ܂B
			 * lÂAẅړZăXN܂ɁA_B
			 */
			score_add(1);
		} else if(game.heli_cnt == 4) {
			/*  */
			game.heli_stat = 0;
			game.heli_cnt = 0;
			game.heli_man = 0;
			return;
		}
		break;

	case 3: /* NbV */
		game.heli_cnt++;
L_CRASH:
		/* jА */
		if(game.heli_cnt == 1) {
			n = 0;
			for(i = 0; i < EFCT_MAX; i++) {
				efct = &game.efct[i];
				if(!efct->type) {
					efct->type = 3; /* j */
					d1 = RNDF_RANGE(seed, -M_PI / 4, M_PI / 4);
					d2 = RNDF_RANGE(seed, 1 << 8, 4 << 8);
					efct->vx = cosf(d1) * d2;
					efct->vy = sinf(d1) * d2;
					if(game.heli_col == -1) {
						efct->x = 1 << 8;
						efct->y = 6 << 8;
					} else {
						efct->x = 68 << 8;
						efct->y =  6 << 8;
						efct->vx = -efct->vx;
					}
					if(++n == 12) {
						break;
					}
				}
			}
		}
		break;

	default:
		DIE();
	}
}

/* w` */
void heli_draw() {
	static const unsigned char ofs_tbl[4/*heli_cnt*/] = { 0,1,3,7 };

	int x;
	int spr;

	switch(game.heli_stat) {
	case 0: /* ʏ */
		/* wWvZ */
		x = CELL_X + (CELL_W * game.heli_col);
		if(game.heli_cnt < 0) {
			x -= ofs_tbl[-game.heli_cnt];
		} else if(game.heli_cnt > 0) {
			x += ofs_tbl[game.heli_cnt];
		}
		/* w{̕` */
		spr = SPR_HELIN_00 + (now & 3);
		sprite_draw(x, HELI_Y, spr, 0);
		/* ݂` */
		if(game.heli_man == 1) {
			spr = SPR_HANG1;
			sprite_draw(x, HELI_Y, spr, 0);
		} else if(game.heli_man == 2) {
			spr = SPR_HANG2;
			sprite_draw(x, HELI_Y, spr, 0);
		}
		break;

	case 1: /* ~ */
		/* wWvZ */
		x = CELL_X + (CELL_W * game.heli_col);
		/* w{̕` */
		spr = SPR_HELIN_00 + (now & 3);
		sprite_draw(x, HELI_Y, spr, 0);
		/* [v` */
		switch(game.heli_col) {
		case 1: /* 1i */
			if(game.heli_man == 0) { /* 1l */
				spr = SPR_ROPE11_00;
			} else { /* 2l */
				spr = SPR_ROPE12_00;
			}
			break;
		case 2: /* 3i */
			if(game.heli_man == 0) { /* 1l */
				spr = SPR_ROPE31_00;
			} else { /* 2l */
				spr = SPR_ROPE32_00;
			}
			break;
		default/*0,3*/: /* 2i */
			if(game.heli_man == 0) { /* 1l */
				spr = SPR_ROPE21_00;
			} else { /* 2l */
				spr = SPR_ROPE22_00;
			}
			break;
		}
		spr += game.heli_cnt;
		sprite_draw(x, HELI_Y, spr, 0);
		break;

	case 2: /*  */
		/* wWvZ */
		x = CELL_X + (CELL_W * game.heli_col);
		/* w{̕` */
		spr = SPR_HELIN_00 + (now & 3);
		sprite_draw(x, HELI_Y, spr, 0);
		/* [v` */
		if(game.heli_man == 1) { /* 1l */
			spr = SPR_RELS1_00;
		} else { /* 2l */
			spr = SPR_RELS2_00;
		}
		spr += game.heli_cnt;
		sprite_draw(x, HELI_Y, spr, 0);
		break;

	case 3: /* NbV */
		/* wWvZ */
		x = CELL_X + (CELL_W * game.heli_col);
		/* w{̕` */
		spr = (game.heli_col == -1) ? SPR_HELICL_00 : SPR_HELICR_00;
		spr += (game.heli_cnt <= 3) ? game.heli_cnt : 3;
		sprite_draw(x, HELI_Y, spr, 0);
		break;

	default:
		DIE();
	}
}

/****************************************************************************
 *	r
 ****************************************************************************/

/* rANV */
void bild_action(int i_bild) {
	BILD* bild = &game.bild[i_bild];
	EFCT* efct;
	int i;

	switch(bild->stat) {
	case 0: /* ʏ */
		/** no job **/
		break;

	case 1: /* l */
	case 2: /* l(r̂) */
		switch(i_bild) {
		case 0: /* ЊQr (΍, 2i) */
			/*  */
			if(bild->cnt >= WARN_TIME) {
				for(i = 0; i < EFCT_MAX; i++) {
					efct = &game.efct[i];
					if(!efct->type) {
						efct->type = 1; /*  */
						efct->cnt = 0;
						efct->x = CELL_X + CELL_W * i_bild;
						efct->y = 20;
						efct->x += RND32_RANGE(seed, 0, 11);
						efct->y += RND32_RANGE(seed, 0, 12);
						break;
					}
				}
			}
			/* FALLTHRU */
		case 1: /* ЊQr (nk, 3i) */
		case 2: /* ЊQr (nk, 1i) */
		case 3: /* ЊQr (nk, 2i) */
			bild->cnt++;
			if(bild->cnt >= MISS_TIME) {
				if(!game.miss) {
					game.miss = 1;
					bild->stat = 3; /*  */
				}
			}
			break;
		case 4: /* r */
			bild->cnt++;
			if(bild->cnt >= (4 * 2 * 2/*U*/) + (11 - 4)) {
				bild->stat = 0;
			}
			break;
		default:
			DIE();
		}
		break;

	case 3: /* (ЊQr̂) */
		switch(i_bild) {
		case 0: /* ЊQr (΍, 2i) */
			/*  */
			for(i = 0; i < EFCT_MAX; i++) {
				efct = &game.efct[i];
				if(!efct->type) {
					efct->type = 2; /*  */
					efct->cnt = 0;
					efct->x = CELL_X + CELL_W * i_bild;
					efct->y = 20;
					efct->x += RND32_RANGE(seed, 0, 11);
					efct->y += RND32_RANGE(seed, 0, 12);
					break;
				}
			}
			/* FALLTHRU */
		case 1: /* ЊQr (nk, 3i) */
		case 2: /* ЊQr (nk, 1i) */
		case 3: /* ЊQr (nk, 2i) */
			bild->cnt++;
			break;
		default:
			DIE();
		}
		break;

	default:
		DIE();
	}
}

/* r` */
void bild_draw(int i_bild) {
	BILD* bild = &game.bild[i_bild];
	int i;
	int x;
	int spr;

	x = CELL_X + CELL_W * i_bild;

	switch(bild->stat) {
	case 0: /* ʏ */
		switch(i_bild) {
		case 0: /* ЊQr (΍, 2i) */
			/** no job **/
			break;
		case 1: /* ЊQr (nk, 3i) */
			/* r */
			spr = SPR_BILD3_00;
			sprite_draw(x, BILD_Y, spr, 0);
			break;
		case 2: /* ЊQr (nk, 1i) */
			/* r */
			spr = SPR_BILD1_00;
			sprite_draw(x, BILD_Y, spr, 0);
			break;
		case 3: /* ЊQr (nk, 2i) */
			/* r */
			spr = SPR_BILD2_00;
			sprite_draw(x, BILD_Y, spr, 0);
			break;
		case 4: /* r */
			/** no job **/
			break;
		default:
			DIE();
		}
		break;

	case 1: /* l */
	case 2: /* l(r̂) */
		switch(i_bild) {
		case 0: /* ЊQr (΍, 2i) */
			/* l */
			spr = SPR_HELP2_00;
			if(bild->cnt < 5) {
				spr += bild->cnt;
			} else {
				spr += (((bild->cnt - 5) / 2) & 3) + 5;
			}
			sprite_draw(x, HELI_Y, spr, 0);
			break;
		case 1: /* ЊQr (nk, 3i) */
			if(bild->cnt >= WARN_TIME) {
				x += UPDOWN_MOTION(bild->cnt, 3) - 1;
			}
			/* r */
			spr = SPR_BILD3_00;
			sprite_draw(x, BILD_Y, spr, 0);
			/* l */
			spr = SPR_HELP3_00;
			if(bild->cnt < 5) {
				spr += bild->cnt;
			} else {
				spr += (((bild->cnt - 5) / 2) & 3) + 5;
			}
			sprite_draw(x, HELI_Y, spr, 0);
			break;
		case 2: /* ЊQr (nk, 1i) */
			if(bild->cnt >= WARN_TIME) {
				x += UPDOWN_MOTION(bild->cnt, 3) - 1;
			}
			/* r */
			spr = SPR_BILD1_00;
			sprite_draw(x, BILD_Y, spr, 0);
			/* l */
			spr = SPR_HELP1_00;
			if(bild->cnt < 5) {
				spr += bild->cnt;
			} else {
				spr += (((bild->cnt - 5) / 2) & 3) + 5;
			}
			sprite_draw(x, HELI_Y, spr, 0);
			break;
		case 3: /* ЊQr (nk, 2i) */
			if(bild->cnt >= WARN_TIME) {
				x += UPDOWN_MOTION(bild->cnt, 3) - 1;
			}
			/* r */
			spr = SPR_BILD2_00;
			sprite_draw(x, BILD_Y, spr, 0);
			/* l */
			spr = SPR_HELP2_00;
			if(bild->cnt < 5) {
				spr += bild->cnt;
			} else {
				spr += (((bild->cnt - 5) / 2) & 3) + 5;
			}
			sprite_draw(x, HELI_Y, spr, 0);
			break;
		case 4: /* r */
			spr = (bild->stat == 1) ? SPR_ESCP1_00 : SPR_ESCP2_00;
			if(bild->cnt < (4 * 2 * 2/*U*/)) {
				spr += (bild->cnt / 2) & 3;
			} else {
				spr += bild->cnt - (4 * 2 * 2/*U*/) + 4;
			}
			sprite_draw(x, HELI_Y, spr, 0);
			break;
		default:
			DIE();
		}
		break;

	case 3: /* (ЊQr̂) */
		switch(i_bild) {
		case 0: /* ЊQr (΍, 2i) */
			/* l */
			spr = SPR_HELP2_00;
			spr += ((bild->cnt / 2) & 3) + 5;
			sprite_draw(x, HELI_Y, spr, 0);
			break;
		case 1: /* ЊQr (nk, 3i) */
			if(bild->cnt >= WARN_TIME) {
				x += UPDOWN_MOTION(bild->cnt, 3) - 1;
			}
			i = bild->cnt - MISS_TIME;
			/* r */
			spr = SPR_BILD3_00 + (i <= 16 ? i : 16);
			sprite_draw(x, BILD_Y, spr, 0);
			/* l */
			spr = SPR_HELP3_00;
			spr += ((bild->cnt / 2) & 3) + 5;
			sprite_draw(x, HELI_Y + i, spr, 0);
			break;
		case 2: /* ЊQr (nk, 1i) */
			if(bild->cnt >= WARN_TIME) {
				x += UPDOWN_MOTION(bild->cnt, 3) - 1;
			}
			i = bild->cnt - MISS_TIME;
			/* r */
			spr = SPR_BILD1_00 + (i <= 8 ? i : 8);
			sprite_draw(x, BILD_Y, spr, 0);
			/* l */
			spr = SPR_HELP1_00;
			spr += ((bild->cnt / 2) & 3) + 5;
			sprite_draw(x, HELI_Y + i, spr, 0);
			break;
		case 3: /* ЊQr (nk, 2i) */
			if(bild->cnt >= WARN_TIME) {
				x += UPDOWN_MOTION(bild->cnt, 3) - 1;
			}
			i = bild->cnt - MISS_TIME;
			/* r */
			spr = SPR_BILD2_00 + (i <= 12 ? i : 12);
			sprite_draw(x, BILD_Y, spr, 0);
			/* l */
			spr = SPR_HELP2_00;
			spr += ((bild->cnt / 2) & 3) + 5;
			sprite_draw(x, HELI_Y + i, spr, 0);
			break;
		default:
			DIE();
		}
		break;

	default:
		DIE();
	}
}

/****************************************************************************
 *	GtFNg
 ****************************************************************************/

/* GtFNg` */
void efct_draw() {
	EFCT* efct;
	int i;
	int x;
	int y;
	int spr;

	for(i = 0; i < EFCT_MAX; i++) {
		efct = &game.efct[i];
		switch(efct->type) {
		case 1: /*  */
			x = efct->x;
			y = efct->y;
			spr = SPR_SMOK_00 + efct->cnt;
			sprite_draw(x, y, spr, 0);
			efct->cnt++;
			if(efct->cnt >= 4) {
				efct->type = 0;
			}
			break;
		case 2: /*  */
			x = efct->x;
			y = efct->y;
			spr = SPR_FIRE_00 + efct->cnt;
			sprite_draw(x, y, spr, 0);
			efct->cnt++;
			if(efct->cnt >= 6) {
				efct->type = 0;
			}
			break;
		case 3: /* j */
			x = efct->x >> 8;
			y = efct->y >> 8;
			render_point(&lrend, x, y, 3);
			efct->x += efct->vx;
			efct->y += efct->vy;
			efct->vx = (efct->vx * 7) >> 3;
			efct->vy = (efct->vy * 7) >> 3;
//			if(!(abs(efct->vx) >> 6) && !(abs(efct->vy) >> 6)) {	//yRpC̃oOzŌ㔼abssȂ!!
			if((abs(efct->vx) < 64) && (abs(efct->vy) < 64)) {
				efct->type = 0;
			}
			break;
		}
	}
}

/****************************************************************************
 *	TEh
 ****************************************************************************/

static const unsigned char snd_ptn_tbl[][16] = {
	{ 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0 },	/* 0 =  */
	{ 1,0,1,0, 1,0,1,0, 1,0,1,0, 1,0,1,0 },	/* 1 = Q[X^[g */
	{ 1,1,1,1, 1,1,1,1, 1,1,1,1, 1,1,1,1 },	/* 2 = Q[I[o[ */
	{ 1,0,1,0, 0,0,0,0, 0,0,0,0, 0,0,0,0 },	/* 3 = lo */
	{ 1,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0 },	/* 4 = [v */
};

void snd_set(int ptn) {
ENTER_CS;
	game.snd_ptn = ptn;
	game.snd_cnt = 0;
LEAVE_CS;
}

int stream_callback(short wbuff[/*320*/], int param) {
	int cnt = game.snd_cnt++ / 3;
	if(cnt < 16) {
		if(snd_ptn_tbl[game.snd_ptn][cnt]) {
			int* p = (int*)wbuff;
			int i = 320 / 2 / 4;
			do {
				*p++ = 0x80008000;	/* 16KHz/8 = 2KHz */
				*p++ = 0x80008000;
				*p++ = 0x7FFF7FFF;
				*p++ = 0x7FFF7FFF;
			} while(--i);
			return 0; /*  */
		}
	}
	return 1; /*  */
}
