/*
 *	jtnew.c
 *
 *	JoyToyC^v^
 *
 *	* Sun Jan 01 00:00:00 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 *	* Tue Jan 31 00:00:00 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Jun 17 05:26:02 JST 2006 Naoyuki Sawa
 *	- FIELD_OFFSET()offsetof()ɕύXB
 */
#include "app.h"

/*****************************************************************************
 *	JTNEW
 *****************************************************************************/

typedef struct _JTNEW {
	int refcnt;
	JTCODE_INTERFACE* jtcode_interface;
	//
	JTSYMBOL_INTERFACE** symbol;	/* ̃IuWFNg\V{ */
	JTCODE_INTERFACE** body;	/* ubNA܂́ANULL */
} JTNEW;

IMPLEMENT_JTCODE_INTERFACE(JTNEW, jtnew)

const INTERFACE_MAP jtnew_interface_map[] = {
	{ JTCODE_INTERFACE_ID, offsetof(JTNEW, jtcode_interface), &jtcode_interface },
	{ 0/*I[*/ },
};

JTCODE_INTERFACE**
jtnew_create(JTSYMBOL_INTERFACE** symbol, JTCODE_INTERFACE** body)
{
	JTNEW* this = calloc(1, sizeof(JTNEW));
	if(!this) {
		DIE(); /* s */
	}
	this->refcnt = 1;
	apply_interface_map(this, jtnew_interface_map);

	/* ̃IuWFNg\V{AubNi[܂B */
	safe_assign(this->symbol, symbol);
	safe_assign(this->body, body);

	return &this->jtcode_interface;
}

static void
jtnew_delete(JTNEW* this)
{
	/* ̃IuWFNg\V{AubN܂B */
	safe_release(this->symbol);
	safe_release(this->body);

	free(this);
}

/*****************************************************************************
 *	JTCODE_INTERFACE
 *****************************************************************************/

static JTCODE_INTERFACE**
jtcode_run(JTCODE_INTERFACE** intf)
{
	JTNEW* this = CONTAINING_RECORD(intf, JTNEW, jtcode_interface);
	//
	JTCODE_INTERFACE** code = NULL;
	JTOBJECT_INTERFACE** object = NULL;

	/* V{ɑΉAIuWFNg擾܂B */
	safe_attach(code, joytoy_get_symbol_value(this->symbol));
	if(!code) {
		DIE(); /* ` (ǂݍ񂾃vÕG[) */
	}
	safe_assign_interface(object, code, JTOBJECT_INTERFACE);
	if(!object) {
		DIE(); /* ֐łȂ (ǂݍ񂾃vÕG[) */
	}

	/* IuWFNg𕡐܂B */
	safe_attach(code, jtobject_clone(object));
	safe_assign_interface(object, code, JTOBJECT_INTERFACE);
	if(!object) {
		DIE(); /* L蓾Ȃ */
	}

	/* ubNL΁As܂B */
	if(this->body) {
		JTCODE_INTERFACE** tmp = NULL;

		/* ֐t[ɓ܂B */
		joytoy_enter();

		/* ̃IuWFNgAsΏۂƂ܂B */
		joytoy_set_object(object);

		/* ubNs܂B */
		safe_attach(tmp, (*this->body)->run(this->body));

		/* ֐t[𔲂܂B */
		joytoy_leave();

		/* svɂȂC^[tFCX܂B */
		safe_release(tmp);
	}

	/* svɂȂC^[tFCX܂B */
	safe_release(object);

	return code;
}

