/*	
 *	clipt18i.h
 *
 *	P/ECE TMS9918(A) Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Tue Jan 4 20:23:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 */

/****************************************************************************
 *
 ****************************************************************************/

#ifdef TMS9918_SPRITE_IMPLEMENT

/* * XvCg`惋[`̋ʂ̒`łB
 * - XvCg`惋[` {8x8WA8x8gA16x16WA16x16g} ̎lނ܂Ae͂قƂǓłB
 *   ǗȒPɂ邽߂ɁÃCN[ht@Cŋʂ̒`sACN[hĕ邱Ƃɂ܂B
 * - clipt18.c܂framt18.cCN[hĎg܂B
 *   قƂǂ̃Q[16x16W[h𗘗pĂ̂ŁARAMɓ]̂16x16WłłƎv܂B
 *   16x16Wł̒`̂framt18.cɃCN[hȂ3ނclipt18.cɃCN[hĂB
 */

#define SIZE_MAG (SIZE * MAG)
#if(MAG == 1)
#define PSET do { *p = c; } while(0)
#else /*MAG == 1*/
#define PSET do { p[0] = p[1] = p[256] = p[257] = c; } while(0)
#endif /*MAG == 1*/

	unsigned char* reg  = tms9918->reg;
	unsigned char* vram = tms9918->vram;
	//
	int sprite;
	int x;
	int y;
	int code;
	int c;
	int side; /* SIZE=16̂ݗL */
	int line;
	int i;
	int v;
	const unsigned char* attribute_table;
	const unsigned char* pattern_generator;
	const unsigned char* pattern;
	unsigned char* p;

	/* e[uAhX擾܂B */
	attribute_table   = &vram[(reg[5] & 0x7f) <<  7]; /* 128BEɐ */
	pattern_generator = &vram[(reg[6] & 0x07) << 11]; /*  2KBEɐ */

	/* 32̃XvCgɂ... */
	for(sprite = 0; sprite < 32; sprite++) {

		/* XWAYWAp^[ԍAEarlyClockƃJ[R[h擾܂B */
		y    = *attribute_table++;
		x    = *attribute_table++;
		code = *attribute_table++;
		c    = *attribute_table++;

		/* YWʉɊOĂ... */
		if(y >= 192) {
			if(y > 256 - SIZE_MAG) {
				/* ʏ[܂`łB */
				y -= 256;
			} else if(y == 208/*dl*/) {
				/* ȍ~̃XvCg\܂B */
				break;
			} else {
				/* SɉʊOłB */
				continue;
			}
		}

		/* EarlyClockƃJ[R[hȊOmɃNA܂B */
		c &= 0x8f;

		/* EarlyClock=1Ȃ΁A32sNZւ炵܂B */
		if(c > 15) {
			c &= 15;
			x -= 32;
			if(x <= 0 - SIZE_MAG) {
				/* SɉʊOłB */
				continue;
			}
		}

		/* J[R[h0:Fɂ`͖ӖȂ̂Ŕ΂܂B */
		if(!c) {
			continue;
		}

#ifdef TMS9918_GRAYSCALE
		/* OCXP[́AJ[OCXP[ɕϊ܂B */
		c = tms9918_grayscale_table[c];
#endif /*TMS9918_GRAYSCALE*/

#if(SIZE == 16)
		/* Size1[hł́AJnp^[ԍ4̔{ɐ񂵂܂B */
		code &= ~3;
#endif /*SIZE == 16*/

		/* p^[f[^̐擪AhX߂܂B */
		pattern = pattern_generator + code * 8;

		/* ]`̍㌴_AhX߂܂B */
		p = vbuff + y * 256 + x;

		if((x >= 0) && (x <= 256 - SIZE_MAG) && (y >= 0) && (y <= 192 - SIZE_MAG)) {
			/* NbsOsvB */
			for(side = 0; side < SIZE; side += 8) { /* SIZE=16̂ݗL */
				for(line = 0; line < SIZE; line++) {
					v = *pattern++;
					if(v & 0x80) PSET; p += MAG;
					if(v & 0x40) PSET; p += MAG;
					if(v & 0x20) PSET; p += MAG;
					if(v & 0x10) PSET; p += MAG;
					if(v & 0x08) PSET; p += MAG;
					if(v & 0x04) PSET; p += MAG;
					if(v & 0x02) PSET; p += MAG;
					if(v & 0x01) PSET; p += MAG;
					p += (256 - 8) * MAG;
				}
				p -= (256 * SIZE - 8) * MAG;
			}
		} else {
			/* NbsOKvB */
			for(side = 0; side < SIZE; side += 8) { /* SIZE=16̂ݗL */
				for(line = 0; line < SIZE; line++) {
					v = *pattern++;
					for(i = 0; i < 8; i++) {
						if((v & 0x80) && (x >= 0) && (x <= 255) && (y >= 0) && (y <= 191)) {
							PSET;
						}
						v <<= 1;
						x += MAG;
						p += MAG;
					}
					x -= 8 * MAG;
					y += 1 * MAG;
					p += (256 - 8) * MAG;
				}
				x +=    8 * MAG;
				y -= SIZE * MAG;
				p -= (256 * SIZE - 8) * MAG;
			}
		}
	}

#undef SIZE_MAG
#undef PSET

#endif /*TMS9918_SPRITE_IMPLEMENT*/

/****************************************************************************
 *
 ****************************************************************************/
