/*	
 *	clipsp2d.c
 *
 *	P/ECE SPC Driver V2
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Sun Oct 10 16:18:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

/****************************************************************************
 *	SPC2DSP
 ****************************************************************************/

/* P/ECEo̓Tv[16KHz]~64Tv4[ms]ɁAENVXXV܂B
 * ]āAGx[ve[u̒ĺA4[ms]ENVXωʂƂ܂B
 * ENVX̕ῶ͈́A0`127~Œ菬16bitłB
 */
const int spc2dsp_attack_rate_table[16/*AR*/] = {
	(128 << 16) * 4 / 4100,
	(128 << 16) * 4 / 2600,
	(128 << 16) * 4 / 1500,
	(128 << 16) * 4 / 1000,
	(128 << 16) * 4 /  640,
	(128 << 16) * 4 /  380,
	(128 << 16) * 4 /  260,
	(128 << 16) * 4 /  160,
	(128 << 16) * 4 /   96,
	(128 << 16) * 4 /   64,
	(128 << 16) * 4 /   40,
	(128 << 16) * 4 /   24,
	(128 << 16) * 4 /   16,
	(128 << 16) * 4 /   10,
	(128 << 16) * 4 /    6,
      /*(128 << 16) * 4 /    0*/(128 << 16),
};
const int spc2dsp_decay_rate_table[8/*SL*/][8/*DR*/] = {
	{ (128 << 16) * 7 / 8 * 4 / 1200,
	  (128 << 16) * 7 / 8 * 4 /  740,
	  (128 << 16) * 7 / 8 * 4 /  440,
	  (128 << 16) * 7 / 8 * 4 /  290,
	  (128 << 16) * 7 / 8 * 4 /  180,
	  (128 << 16) * 7 / 8 * 4 /  110,
	  (128 << 16) * 7 / 8 * 4 /   74,
	  (128 << 16) * 7 / 8 * 4 /   37 },
	{ (128 << 16) * 6 / 8 * 4 / 1200,
	  (128 << 16) * 6 / 8 * 4 /  740,
	  (128 << 16) * 6 / 8 * 4 /  440,
	  (128 << 16) * 6 / 8 * 4 /  290,
	  (128 << 16) * 6 / 8 * 4 /  180,
	  (128 << 16) * 6 / 8 * 4 /  110,
	  (128 << 16) * 6 / 8 * 4 /   74,
	  (128 << 16) * 6 / 8 * 4 /   37 },
	{ (128 << 16) * 5 / 8 * 4 / 1200,
	  (128 << 16) * 5 / 8 * 4 /  740,
	  (128 << 16) * 5 / 8 * 4 /  440,
	  (128 << 16) * 5 / 8 * 4 /  290,
	  (128 << 16) * 5 / 8 * 4 /  180,
	  (128 << 16) * 5 / 8 * 4 /  110,
	  (128 << 16) * 5 / 8 * 4 /   74,
	  (128 << 16) * 5 / 8 * 4 /   37 },
	{ (128 << 16) * 4 / 8 * 4 / 1200,
	  (128 << 16) * 4 / 8 * 4 /  740,
	  (128 << 16) * 4 / 8 * 4 /  440,
	  (128 << 16) * 4 / 8 * 4 /  290,
	  (128 << 16) * 4 / 8 * 4 /  180,
	  (128 << 16) * 4 / 8 * 4 /  110,
	  (128 << 16) * 4 / 8 * 4 /   74,
	  (128 << 16) * 4 / 8 * 4 /   37 },
	{ (128 << 16) * 3 / 8 * 4 / 1200,
	  (128 << 16) * 3 / 8 * 4 /  740,
	  (128 << 16) * 3 / 8 * 4 /  440,
	  (128 << 16) * 3 / 8 * 4 /  290,
	  (128 << 16) * 3 / 8 * 4 /  180,
	  (128 << 16) * 3 / 8 * 4 /  110,
	  (128 << 16) * 3 / 8 * 4 /   74,
	  (128 << 16) * 3 / 8 * 4 /   37 },
	{ (128 << 16) * 2 / 8 * 4 / 1200,
	  (128 << 16) * 2 / 8 * 4 /  740,
	  (128 << 16) * 2 / 8 * 4 /  440,
	  (128 << 16) * 2 / 8 * 4 /  290,
	  (128 << 16) * 2 / 8 * 4 /  180,
	  (128 << 16) * 2 / 8 * 4 /  110,
	  (128 << 16) * 2 / 8 * 4 /   74,
	  (128 << 16) * 2 / 8 * 4 /   37 },
	{ (128 << 16) * 1 / 8 * 4 / 1200,
	  (128 << 16) * 1 / 8 * 4 /  740,
	  (128 << 16) * 1 / 8 * 4 /  440,
	  (128 << 16) * 1 / 8 * 4 /  290,
	  (128 << 16) * 1 / 8 * 4 /  180,
	  (128 << 16) * 1 / 8 * 4 /  110,
	  (128 << 16) * 1 / 8 * 4 /   74,
	  (128 << 16) * 1 / 8 * 4 /   37 },
	{ (128 << 16) * 0 / 8 * 4 / 1200,
	  (128 << 16) * 0 / 8 * 4 /  740,
	  (128 << 16) * 0 / 8 * 4 /  440,
	  (128 << 16) * 0 / 8 * 4 /  290,
	  (128 << 16) * 0 / 8 * 4 /  180,
	  (128 << 16) * 0 / 8 * 4 /  110,
	  (128 << 16) * 0 / 8 * 4 /   74,
	  (128 << 16) * 0 / 8 * 4 /   37 },
};
const int spc2dsp_sustain_rate_table[32/*SR*/] = {
      /*(128 << 16) * 4 /   INF*/0,
	(128 << 16) * 4 / 38000,
	(128 << 16) * 4 / 28000,
	(128 << 16) * 4 / 24000,
	(128 << 16) * 4 / 19000,
	(128 << 16) * 4 / 14000,
	(128 << 16) * 4 / 12000,
	(128 << 16) * 4 /  9400,
	(128 << 16) * 4 /  7100,
	(128 << 16) * 4 /  5900,
	(128 << 16) * 4 /  4700,
	(128 << 16) * 4 /  3500,
	(128 << 16) * 4 /  2900,
	(128 << 16) * 4 /  2400,
	(128 << 16) * 4 /  1800,
	(128 << 16) * 4 /  1500,
	(128 << 16) * 4 /  1200,
	(128 << 16) * 4 /   880,
	(128 << 16) * 4 /   740,
	(128 << 16) * 4 /   590,
	(128 << 16) * 4 /   440,
	(128 << 16) * 4 /   370,
	(128 << 16) * 4 /   290,
	(128 << 16) * 4 /   220,
	(128 << 16) * 4 /   180,
	(128 << 16) * 4 /   150,
	(128 << 16) * 4 /   110,
	(128 << 16) * 4 /    92,
	(128 << 16) * 4 /    74,
	(128 << 16) * 4 /    55,
	(128 << 16) * 4 /    37,
	(128 << 16) * 4 /    18,
};
const int spc2dsp_sustain_level_table[8/*SL*/] = {
	(128 << 16) * 1 / 8 - 1,
	(128 << 16) * 2 / 8 - 1,
	(128 << 16) * 3 / 8 - 1,
	(128 << 16) * 4 / 8 - 1,
	(128 << 16) * 5 / 8 - 1,
	(128 << 16) * 6 / 8 - 1,
	(128 << 16) * 7 / 8 - 1,
	(128 << 16) * 8 / 8 - 1,
};
const int spc2dsp_increase_linear_table[32] = {
      /*(128 << 16) * 4 /  INF*/0,
	(128 << 16) * 4 / 4100,
	(128 << 16) * 4 / 3100,
	(128 << 16) * 4 / 2600,
	(128 << 16) * 4 / 2000,
	(128 << 16) * 4 / 1500,
	(128 << 16) * 4 / 1300,
	(128 << 16) * 4 / 1000,
	(128 << 16) * 4 /  770,
	(128 << 16) * 4 /  640,
	(128 << 16) * 4 /  510,
	(128 << 16) * 4 /  380,
	(128 << 16) * 4 /  320,
	(128 << 16) * 4 /  260,
	(128 << 16) * 4 /  190,
	(128 << 16) * 4 /  160,
	(128 << 16) * 4 /  130,
	(128 << 16) * 4 /   96,
	(128 << 16) * 4 /   80,
	(128 << 16) * 4 /   64,
	(128 << 16) * 4 /   48,
	(128 << 16) * 4 /   40,
	(128 << 16) * 4 /   32,
	(128 << 16) * 4 /   24,
	(128 << 16) * 4 /   20,
	(128 << 16) * 4 /   16,
	(128 << 16) * 4 /   12,
	(128 << 16) * 4 /   10,
	(128 << 16) * 4 /    8,
	(128 << 16) * 4 /    6,
	(128 << 16) * 4 /    4,
	(128 << 16) * 4 /    2,
};
const int spc2dsp_increase_bentline_table[32] = {
      /*(128 << 16) * 4 /  INF*/0,
	(128 << 16) * 4 / 7200,
	(128 << 16) * 4 / 5400,
	(128 << 16) * 4 / 4600,
	(128 << 16) * 4 / 3500,
	(128 << 16) * 4 / 2600,
	(128 << 16) * 4 / 2300,
	(128 << 16) * 4 / 1800,
	(128 << 16) * 4 / 1300,
	(128 << 16) * 4 / 1100,
	(128 << 16) * 4 /  900,
	(128 << 16) * 4 /  670,
	(128 << 16) * 4 /  580,
	(128 << 16) * 4 /  450,
	(128 << 16) * 4 /  340,
	(128 << 16) * 4 /  280,
	(128 << 16) * 4 /  220,
	(128 << 16) * 4 /  170,
	(128 << 16) * 4 /  140,
	(128 << 16) * 4 /  110,
	(128 << 16) * 4 /   84,
	(128 << 16) * 4 /   70,
	(128 << 16) * 4 /   56,
	(128 << 16) * 4 /   42,
	(128 << 16) * 4 /   35,
	(128 << 16) * 4 /   28,
	(128 << 16) * 4 /   21,
	(128 << 16) * 4 /   18,
	(128 << 16) * 4 /   14,
	(128 << 16) * 4 /   11,
	(128 << 16) * 4 /    7,
      /*(128 << 16) * 4 /  3.5*/(128 << 16) * 2 / 7,
};

const short spc2dsp_filter_table[4][2] = {
    {              0,             0 },
    { /* 15/16=*/240,             0 },
    { /* 61/32=*/488, /*15/16=*/240 },
    { /*115/64=*/460, /*13/16=*/208 },
};

/****************************************************************************/

void
spc2dsp_init()
{
	SPC2DSP* dsp = &spc2dsp;

	memset(dsp, 0, sizeof(SPC2DSP));
}

int
spc2dsp_read(int addr)
{
	///SPC2DSP* dsp = &spc2dsp;

#ifdef SP2_DEBUG
	if(addr < 0 || addr > 0x7f) DIE();
#endif /*SP2_DEBUG*/

	//return dsp->reg[addr];
	//B̂߂ɏ0ԂƂɂB
	return 0;
}

void
spc2dsp_write(int addr, int data)
{
	SPC2DSP* dsp = &spc2dsp;
	int addr_lo = addr & 0xf;
	int addr_hi = addr >> 4;
	//
	int lf;
	int ri;
	int ar;
	int dr;
	int sr;
	int sl;
	int gain;
	int sdir;
	SPC2VCE* vce;
	unsigned char* reg;
	unsigned char* memp;

#ifdef SP2_DEBUG
	if(addr < 0 || addr > 0x7f) DIE();
	if(data < 0 || data > 0xff) DIE();
#endif /*SP2_DEBUG*/

	/* ܂i[B */
	dsp->reg[addr] = data;

	if(addr_lo <= 9) {
		/* 0x?0`0x?9: Voice-? ݒ背WX^ */
		vce = &dsp->vce[addr_hi];
		switch(addr_lo) {
		case 0: /* 0x?0: VOL(L) */
		case 1: /* 0x?1: VOL(R) */
			lf = (char)dsp->reg[addr & ~1/*VOL(L)*/];
			ri = (char)dsp->reg[addr |  1/*VOL(R)*/];
			if(lf < 0) lf = -(lf + 1); /* t:-1`-128 => :0`127 */
			if(ri < 0) lf = -(ri + 1); /* t:-1`-128 => :0`127 */
			vce->vol = lf >= ri ? lf : ri;
			break;
		case 2: /* 0x?2: P(L) */
		case 3: /* 0x?3: P(H) */
			vce->p = (dsp->reg[addr & ~1/*P(L)*/] |
				  dsp->reg[addr |  1/*P(R)*/] << 8) & 0x3fff;
			break;
		//case 4: /* 0x?4: SRCN */
		//case 5: /* 0x?5: ADSR(1) */
		//case 6: /* 0x?6: ADSR(2) */
		//case 7: /* 0x?7: GAIN */
		//case 8: /* 0x?8: ENVX */ READ ONLY?
		//case 9: /* 0x?9: OUTX */ READ ONLY?
		}
	} else {
		/* 0x?c,0x?d,0x?f: ʐݒ背WX^ */
		switch(addr_lo) {
		case 0xc:
			switch(addr_hi) {
			case 0: /* 0x0c: MVOL(L) */
			case 1: /* 0x1c: MVOL(R) */
				lf = (char)dsp->reg[addr & ~0x10/*MVOL(L)*/];
				ri = (char)dsp->reg[addr |  0x10/*MVOL(R)*/];
				if(lf < 0) lf = -(lf + 1); /* t:-1`-128 => :0`127 */
				if(ri < 0) lf = -(ri + 1); /* t:-1`-128 => :0`127 */
				dsp->mvol = lf >= ri ? lf : ri;
				break;
			//case 2: /* 0x2c: EVOL(L) */
			//case 3: /* 0x3c: EVOL(R) */
			case 4: /* 0x4c: KON */
				vce = dsp->vce;
				reg = dsp->reg;
				while(data) {
					if(data & 1) {
						if(reg[5/*ADSR(1)*/] & 0x80) { /* ADSR */
							vce->state = SPC2VCE_ATTACK;
							ar =  reg[5/*ADSR(1)*/]       & 15;
							dr = (reg[5/*ADSR(1)*/] >> 4) &  7;
							sr =  reg[6/*ADSR(2)*/]       & 31;
							sl = (reg[6/*ADSR(2)*/] >> 5) &  7;
							vce->ar = spc2dsp_attack_rate_table[ar];
							vce->dr = spc2dsp_decay_rate_table[sl][dr]; /* [sl][dr]tɂȂ悤!! */
							vce->sr = spc2dsp_sustain_rate_table[sr];
							vce->sl = spc2dsp_sustain_level_table[sl];
							vce->envx = 0;
						} else { /* GAIN */
							gain = reg[7/*GAIN*/];
							if(!(gain & 0x80)) {
								/* 0??????? */
								vce->state = SPC2VCE_DIRECT;
								vce->gain = (gain & 127) << 16;
								vce->envx = vce->gain;
							} else {
								if(gain & 0x40) {
									vce->state = SPC2VCE_INCREASE;
									if(!(gain & 0x20)) {
										/* 110????? */
										vce->gain = spc2dsp_increase_linear_table[gain & 31];
									} else {
										/* 111????? */
										vce->gain = spc2dsp_increase_bentline_table[gain & 31];
									}
									vce->envx = 0;
								} else {
									vce->state = SPC2VCE_DECREASE;
									if(!(gain & 0x20)) {
										/* 100????? */
										vce->gain = spc2dsp_decrease_linear_table[gain & 31];
									} else {
										/* 101????? */
										vce->gain = spc2dsp_decrease_exponential_table[gain & 31];
									}
									vce->envx = (128 << 16) - 1;
								}
							}
						}
						/*  Source Directory = DIR~0x100 + SRCN~4 ꂪB
						 * ~ Source Directory = DIR~0x100 | SRCN~4 ͌BC!!
						 */
						sdir = (dsp->reg[0x5d/*DIR*/] << 8) + (reg[4/*SRCN*/] << 2);
#ifdef SP2_DEBUG
						if(sdir + 2/*SA*/ + 2/*LSA*/ > 0x10000) DIE();
#endif /*SP2_DEBUG*/
						memp = &spc2ram[sdir];
						vce->brr_addr = memp[0] | memp[1] << 8;	/*  SA: Source      Start Address */
						vce->lsa      = memp[2] | memp[3] << 8;	/* LSA: Source Loop Start Address */
						vce->sample[14] = vce->sample[15] = 0;	/* fR[ĥ߂ɗvNA!! */
						spc2vce_decode_brr(vce);
						vce->progress = 0;
					}
					vce++;
					reg += 0x10;
					data >>= 1;
				}
				break;
			case 5: /* 0x5c: KOF */
				vce = dsp->vce;
				while(data) {
					if(data & 1) {
						if(vce->state) {
							vce->state = SPC2VCE_RELEASE;
						}
					}
					vce++;
					data >>= 1;
				}
				break;
			//case 6: /* 0x6c: FLG */
			//case 7: /* 0x7c: ENDX */ READ ONLY?
			}
			break;
		case 0xd:
			switch(addr_hi) {
			//case 0: /* 0x0d: EFB */
			//case 1: /* 0x1d: (Not Used) */
			//case 2: /* 0x2d: PMON */
			//case 3: /* 0x3d: NON */
			//case 4: /* 0x4d: EON */
			//case 5: /* 0x5d: DIR */
			//case 6: /* 0x6d: ESA */
			//case 7: /* 0x7d: EDL */
			}
			break;
		//case 0xe: /* 0x?e: (Not Used) */
		//case 0xf: /* 0x?f: C0-7 */
		}
	}
}

void
spc2dsp_mix(short wbuff[/*64*/])
{
	static int mixbuf[64]; /* ~LVOobt@Ars`shbłI */
	//
	SPC2DSP* dsp = &spc2dsp;
	//
	SPC2VCE* vce;
	int i_vce;
	int i_buf;
	int value;
	int* src;

	/* ~LVOobt@NAB */
	memset(mixbuf, 0, sizeof mixbuf);

	/* Voice-0`7̏o͂Z܂B */
	value = 0;
	for(i_vce = 0, vce = dsp->vce; i_vce < 8; i_vce++, vce++) {
		if(spc2vce_env(vce)) {
			spc2vce_mix(vce, mixbuf); /* +=t24bit */
		}
	}
	/* t24bit~8 => t27bit */

	/* ~LVOʂ𐳋KAo̓obt@֊i[܂B */
	src = mixbuf;
	for(i_buf = 0; i_buf < 64; i_buf++) {
		value = *src++;
		/* 2004/10/16݁Arbg4rbgĂ܂B
		 * Ȃ킿A_̍ő剹ʂ16{(!)ɑĂ܂B
		 * Ɍ܂Aꂮ炢傤ǂłB
		 * `l{[Ȃ菬߂ɐݒ肳Ăꍇ݂łB
		 */
		value >>= (27 - 16) - 4/**/; /* t27bit => t(16+)bit */
		if(value < -0x7fff) value = -0x7fff;
		if(value >  0x7fff) value =  0x7fff;
		*wbuff++ = value;
	}
}

int
spc2vce_env(SPC2VCE* vce)
{
	switch(vce->state) {
	case SPC2VCE_ATTACK: /* ADSR */
		vce->envx += vce->ar;
		if(vce->envx >= (128 << 16) - 1) {
			vce->envx = (128 << 16) - 1;
			vce->state = SPC2VCE_DECAY;
		}
		break;

	case SPC2VCE_DECAY: /* ADSR */
		vce->envx -= vce->dr;
		if(vce->envx <= vce->sl) {
			vce->envx = vce->sl;
			vce->state = SPC2VCE_SUSTAIN;
		}
		break;

	case SPC2VCE_SUSTAIN: /* ADSR */
		vce->envx -= vce->sr;
		if(vce->envx <= 0) {
			vce->state = 0;
		}
		break;

	case SPC2VCE_RELEASE: /* ADSR/GAIN */
		vce->envx -= (128 << 16) * 4 / 8; /* ReleaseRate8[ms]Œł */
		if(vce->envx <= 0) {
			vce->state = 0;
		}
		break;

	case SPC2VCE_DIRECT: /* GAIN */
		vce->envx = vce->gain;
		break;

	case SPC2VCE_INCREASE: /* GAIN */
		vce->envx += vce->gain;
		if(vce->envx >= (128 << 16) - 1) {
			vce->envx = (128 << 16) - 1;
		}
		break;

	case SPC2VCE_DECREASE: /* GAIN */
		vce->envx -= vce->gain;
		if(vce->envx <= 0) {
			vce->state = 0;
		}
		break;
	}

	return vce->state;
}

#ifndef SPC2_ASM

void
spc2vce_mix(SPC2VCE* vce, int mixbuf[/*64*/])
{
	SPC2DSP* dsp = &spc2dsp;
	//
	int i;
	int vol;
	int progress;
	int p;
	short* sample;

	/* C{[~`l{[~Gx[v߂܂B */
	vol =  (dsp->mvol    * vce->vol     * (vce->envx >> 16)) >> 13;
	//      ~~~~~~~~~      ~~~~~~~~       ~~~~~~~~~~~~~~~~~
	//     (7bit * 7bit * 7bit     ) >> 13 = 8bit

	if(!vol) return; /* {[0AقƂǃ[ */

	/* ̂߁ApɂɎgtB[hoĂ܂B */
	progress = vce->progress;
	p = vce->p;
	sample = vce->sample;

	for(i = 0; i < 64; i++) {
		progress += p;
		while(progress >= 16 << 11) {
			progress -= 16 << 11;
			/* dv
			 * [vF̏ꍇAŏIubNłȂSẴubNɂLoop=1łB
			 * r̃ubN(Last=0)Loop=1oă[vs肵Ȃ悤ӂĂB
			 * Ă̂悤ɏƁA[vF͍ŏ̃ubNŃ[vĂ܂܂B
			 */
			if(vce->last_loop & 1) { /* ŏIubN */
				if(!(vce->last_loop & 2)) { /* [vȂF */
					/* ReleaseŒɏB */
					vce->state = 0;
					return;
				} else { /* [vF */
					/* BRRubNAhX[vʒu֖߂܂B */
					vce->brr_addr = vce->lsa;
					/* [v́gsample[14]=sample[15]=0h͕svłB */
					/* FALLTHRU */
				}
			}
			spc2vce_decode_brr(vce);
		}

		//            ++++++++++++++++++++++----------- ~t16bit
		//            ||||||||||||||||||||||   +++----- ~ 8bit
		*mixbuf++ += (sample[progress >> 11] * vol); // t24bit
	}

	/* isJE^߂BYȂ!! */
	vce->progress = progress;
}

void
spc2vce_decode_brr(SPC2VCE* vce)
{
	const unsigned char* src;
	      short* dst;
	const short* f;
	int i;
	int header;
	int range;
	int prev1;
	int prev2;
	int data1;
	int data2;
	int f1;
	int f2;

#ifdef SP2_DEBUG
	if(vce->brr_addr > 0x10000 - 9) DIE();
#endif /*SP2_DEBUG*/

	/* kf[^AWJobt@|C^擾B */
	dst = vce->sample;
	src = &spc2ram[vce->brr_addr];

	/* wb_ǂݏoAi[B */
	header = *src++;
	vce->last_loop = header;

	/* XP[OW擾B */
	range = header >> 4;

	/* tB^W擾B */
	f = spc2dsp_filter_table[(header >> 2) & 3];
	f1 = f[0];
	f2 = f[1];

	prev1 = dst[16 - 1]; /* 1ÕTv */
	prev2 = dst[16 - 2]; /* 2ÕTv */
	for(i = 0; i < 8; i++) {
		data2 = *src++;
		data1 = (char)(data2     ) >> 4; /* ʃju */
		data2 = (char)(data2 << 4) >> 4; /* ʃju */

		/* AZuƂ́A"prev1*f1","prev2*f2"short~shortōĂB */

		/* sTv𕜍B */
		data1 = (data1 << range) + (((prev1 * f1) - (prev2 * f2)) >> 8);
		if(data1 < -0x7fff) data1 = -0x7fff;
		if(data1 >  0x7fff) data1 =  0x7fff;
		*dst++ = data1;
		prev2 = prev1;
		prev1 = data1;

		/* 㑱Tv𕜍B */
		data2 = (data2 << range) + (((prev1 * f1) - (prev2 * f2)) >> 8);
		if(data2 < -0x7fff) data2 = -0x7fff;
		if(data2 >  0x7fff) data2 =  0x7fff;
		*dst++ = data2;
		prev2 = prev1;
		prev1 = data2;
	}

	/* ̂߂ɁABRRubNAhXi߂܂B */
	vce->brr_addr += 9;
}

#endif /*SPC2_ASM*/
