/*	
 *	clipmus.c
 *
 *	P/ECEWyCu ⏕[`
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Mon May 24 06:00:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

static int (*old_WaveDataOut)(int ch, PCEWAVEINFO* pwi);

static int new_WaveDataOut(int ch, PCEWAVEINFO* pwi)
{
	short* p;
	int i;
	int v;
	int len;

	/* P/ECEWyCu̎gp`lւ̏o͂Ȃ΁Aʑ܂B
	 * Ô߁A16bit PCM`ł邱ƂmFĂ܂B
	 * P/ECEWyCȕo͂́A16bit PCM`ł͂łB
	 */
	if((ch == music_wch) && (pwi->type & PW_TYPE_16BITPCM)) {
		p = (short*)pwi->pData;
		len = pwi->len;
		for(i = 0; i < len; i++) {
			v = *p << 2; /* BłA4{ȏɂƉ悤ł */
			     if(v < -32767) v = -32767;
			else if(v >  32767) v =  32767;
			*p++ = v;
		}
	}

	return old_WaveDataOut(ch, pwi);
}

void
music_loudness(int enable)
{
	if(enable) {
		if(old_WaveDataOut) return; /* ɃtbNĂA܂ */
		old_WaveDataOut = pceVectorSetKs(KSNO_WaveDataOut, new_WaveDataOut);
	} else {
		if(!old_WaveDataOut) return; /* ܂tbNĂȂ΁A܂ */
		pceVectorSetKs(KSNO_WaveDataOut, old_WaveDataOut);
		old_WaveDataOut = NULL; /* tbNƂ}[NAYȂ!! */
	}
}

