/*
 *	jtunexpr.c
 *
 *	JoyToyC^v^
 *
 *	* Sun Jan 01 00:00:00 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 *	* Tue Jan 31 00:00:00 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Jun 17 05:26:02 JST 2006 Naoyuki Sawa
 *	- FIELD_OFFSET()offsetof()ɕύXB
 */
#include "app.h"

/*****************************************************************************
 *	JTUNEXPR
 *****************************************************************************/

typedef struct _JTUNEXPR {
	int refcnt;
	JTCODE_INTERFACE* jtcode_interface;
	//
	int op;				/* Zq */
	JTCODE_INTERFACE** code;	/* l */
} JTUNEXPR;

IMPLEMENT_JTCODE_INTERFACE(JTUNEXPR, jtunexpr)

const INTERFACE_MAP jtunexpr_interface_map[] = {
	{ JTCODE_INTERFACE_ID, offsetof(JTUNEXPR, jtcode_interface), &jtcode_interface },
	{ 0/*I[*/ },
};

JTCODE_INTERFACE**
jtunexpr_create(int op, JTCODE_INTERFACE** code)
{
	JTUNEXPR* this = calloc(1, sizeof(JTUNEXPR));
	if(!this) {
		DIE(); /* s */
	}
	this->refcnt = 1;
	apply_interface_map(this, jtunexpr_interface_map);

	/* ZqAli[܂B */
	this->op = op;
	safe_assign(this->code, code);

	return &this->jtcode_interface;
}

static void
jtunexpr_delete(JTUNEXPR* this)
{
	/* l܂B */
	safe_release(this->code);

	free(this);
}

/*****************************************************************************
 *	JTCODE_INTERFACE
 *****************************************************************************/

static JTCODE_INTERFACE**
jtcode_run(JTCODE_INTERFACE** intf)
{
	JTUNEXPR* this = CONTAINING_RECORD(intf, JTUNEXPR, jtcode_interface);
	//
	JTCODE_INTERFACE** code = NULL;
	ARITHMETIC_INTERFACE** arithmetic = NULL;
	LOGICAL_INTERFACE** logical = NULL;

	/* l܂B */
	safe_attach(code, (*this->code)->run(this->code));

	/* Zqɂ... */
	switch(this->op) {
	case '-':
		safe_assign_interface(arithmetic, code, ARITHMETIC_INTERFACE);
		if(!arithmetic) {
			DIE(); /* ZpZs */
		}
		safe_attach(code, (*arithmetic)->neg(arithmetic));
		break;

	case '!':
		safe_assign_interface(logical, code, LOGICAL_INTERFACE);
		if(!logical) {
			DIE(); /* _Zs */
		}
		safe_attach(code, (*logical)->not(logical));
		break;

	default:
		DIE(); /* sȉZq */
	}

	/* svɂȂC^[tFCX܂B */
	safe_release(arithmetic);
	safe_release(logical);

	return code;
}

