/*
 *	jtprim.c
 *
 *	JoyToyC^v^
 *
 *	* Sun Jan 01 00:00:00 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 *	* Tue Jan 31 00:00:00 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Jun 17 05:26:02 JST 2006 Naoyuki Sawa
 *	- FIELD_OFFSET()offsetof()ɕύXB
 */
#include "app.h"

/*****************************************************************************
 *	JTPRIM
 *****************************************************************************/

/* gݍ݊֐̎ȒPɂ邽߂́AʊNXɑ܂B */

typedef struct _JTPRIM {
	int refcnt;
	JTCODE_INTERFACE* jtcode_interface;
	JTFUN_INTERFACE* jtfun_interface;
	//
	JTSYMBOL_INTERFACE** name;						/* gݍ݊֐\V{ */
	JTCODE_INTERFACE** (*call)(LIST/*<JTCODE_INTERFACE**>*/ * args_list);	/* gݍ݊֐̏s֐ */
} JTPRIM;

IMPLEMENT_JTCODE_INTERFACE(JTPRIM, jtprim)
IMPLEMENT_JTFUN_INTERFACE(JTPRIM, jtprim)

const INTERFACE_MAP jtprim_interface_map[] = {
	{ JTCODE_INTERFACE_ID, offsetof(JTPRIM, jtcode_interface), &jtcode_interface },
	{ JTFUN_INTERFACE_ID, offsetof(JTPRIM, jtfun_interface), &jtfun_interface },
	{ 0/*I[*/ },
};

JTCODE_INTERFACE**
jtprim_create(const char* name, JTCODE_INTERFACE** (*call)(LIST/*<JTCODE_INTERFACE**>*/ * args_list))
{
	JTPRIM* this = calloc(1, sizeof(JTPRIM));
	if(!this) {
		DIE(); /* s */
	}
	this->refcnt = 1;
	apply_interface_map(this, jtprim_interface_map);

	/* gݍ݊֐\V{쐬Ai[܂B */
	{
		JTCODE_INTERFACE** code = NULL;
		JTSYMBOL_INTERFACE** symbol = NULL;
		//
		safe_attach(code, jtsymbol_intern(name));
		safe_assign_interface(symbol, code, JTSYMBOL_INTERFACE);
		if(!symbol) {
			DIE(); /* L蓾Ȃ */
		}
		safe_assign(this->name, symbol);
		//
		safe_release(code);
		safe_release(symbol);
	}

	/* gݍ݊֐̏s֐i[܂B */
	this->call = call;

	return &this->jtcode_interface;
}

static void
jtprim_delete(JTPRIM* this)
{
	/* gݍ݊֐\V{J܂B */
	safe_release(this->name);

	free(this);
}

/*****************************************************************************
 *	JTCODE_INTERFACE
 *****************************************************************************/

static JTCODE_INTERFACE**
jtcode_run(JTCODE_INTERFACE** intf)
{
	JTPRIM* this = CONTAINING_RECORD(intf, JTPRIM, jtcode_interface);

	/* [Jϐe[uA܂́AO[oϐe[uɁAgݍ݊֐o^܂B */
	joytoy_def_symbol_value(this->name, intf);

	return safe_addref(intf); /* Ăяô߂+1 */
}

/*****************************************************************************
 *	JTFUN_INTERFACE
 *****************************************************************************/

static JTSYMBOL_INTERFACE**
jtfun_get_name(JTFUN_INTERFACE** intf)
{
	JTPRIM* this = CONTAINING_RECORD(intf, JTPRIM, jtfun_interface);

	/* gݍ݊֐\V{Ԃ܂B */
	return safe_addref(this->name); /* Ăяô߂+1 */
}

static JTCODE_INTERFACE**
jtfun_call(JTFUN_INTERFACE** intf, LIST/*<JTCODE_INTERFACE**>*/ * args_list, JTOBJECT_INTERFACE** object)
{
	JTPRIM* this = CONTAINING_RECORD(intf, JTPRIM, jtfun_interface);

	/* gݍ݊֐̏s֐s܂B */
	return this->call(args_list);
}

