/*
 *	jtdotexpr.c
 *
 *	JoyToyC^v^
 *
 *	* Sun Jan 01 00:00:00 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 *	* Tue Jan 31 00:00:00 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Jun 17 05:26:02 JST 2006 Naoyuki Sawa
 *	- FIELD_OFFSET()offsetof()ɕύXB
 */
#include "app.h"

/*****************************************************************************
 *	JTDOTEXPR
 *****************************************************************************/

typedef struct _JTDOTEXPR {
	int refcnt;
	JTCODE_INTERFACE* jtcode_interface;
	//
	JTCODE_INTERFACE** code;	/* IuWFNg */
	JTSYMBOL_INTERFACE** symbol;	/* tB[hϐ\V{ */
} JTDOTEXPR;

IMPLEMENT_JTCODE_INTERFACE(JTDOTEXPR, jtdotexpr)

const INTERFACE_MAP jtdotexpr_interface_map[] = {
	{ JTCODE_INTERFACE_ID, offsetof(JTDOTEXPR, jtcode_interface), &jtcode_interface },
	{ 0/*I[*/ },
};

JTCODE_INTERFACE**
jtdotexpr_create(JTCODE_INTERFACE** code, JTSYMBOL_INTERFACE** symbol)
{
	JTDOTEXPR* this = calloc(1, sizeof(JTDOTEXPR));
	if(!this) {
		DIE(); /* s */
	}
	this->refcnt = 1;
	apply_interface_map(this, jtdotexpr_interface_map);

	/* IuWFNgAtB[hϐ\V{i[܂B */
	safe_assign(this->code, code);
	safe_assign(this->symbol, symbol);

	return &this->jtcode_interface;
}

static void
jtdotexpr_delete(JTDOTEXPR* this)
{
	/* IuWFNgAtB[hϐ\V{܂B */
	safe_release(this->code);
	safe_release(this->symbol);

	free(this);
}

/*****************************************************************************
 *	JTCODE_INTERFACE
 *****************************************************************************/

static JTCODE_INTERFACE**
jtcode_run(JTCODE_INTERFACE** intf)
{
	JTDOTEXPR* this = CONTAINING_RECORD(intf, JTDOTEXPR, jtcode_interface);
	//
	JTCODE_INTERFACE** code = NULL;
	JTOBJECT_INTERFACE** object = NULL;

	/* tB[hϐ̒l擾钼Õ^C~OŁAIuWFNg]܂B */
	safe_attach(code, (*this->code)->run(this->code)); /* V{āAIuWFNg擾鏈Ȃ */
	safe_assign_interface(object, code, JTOBJECT_INTERFACE);
	if(!object) {
		DIE(); /* IuWFNgłȂ (ǂݍ񂾃vÕG[) */
	}

	/* tB[hϐ̒l擾܂B */
	safe_attach(code, (*object)->get_field_value(object, this->symbol));
	if(!code) {
		DIE(); /* tB[hϐ`ĂȂ */
	}

	/* svɂȂC^[tFCX܂B */
	safe_release(object);

	return code;
}

