/*	
 *	clippsid.c
 *
 *	P/ECE PSID Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2003 Naoyuki Sawa
 *
 *	* Sat Dec 27 06:00:00 JST 2003 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

/****************************************************************************
 *	M6502G~[VpO֐
 ****************************************************************************/

void
psid_m6502_out(M6502* m6502, unsigned short addr, unsigned char data)
{
	PSIDDRIVER* psid = (PSIDDRIVER*)m6502;
	int regno;

	/* SID */
	if(addr >= 0xd400 && addr <= 0xd7ff) {
		regno = addr & 0x1f;
		if(regno <= 0x1c) {
			/* Real SID Chip */
			sid_write(&psid->sid, regno, data);
		} else {
			/* PlaySID Extended SID */
			psid_xsid_write(psid, addr, data);
		}
		return;
	}

	/* CIA#1 Timer A */
	if(addr >= 0xdc00 && addr <= 0xdcff) {
		if(!psid->speed) return; /* 0:PAL(1/50[b])Œ => ^C~OύXs */
		regno = addr & 0xf;
		switch(regno) {
		case 0x4:
			((unsigned char*)&psid->cia_timer)[0] = data;
			break;
		case 0x5:
			((unsigned char*)&psid->cia_timer)[1] = data;
			break;
		}
		return;
	}
}

/****************************************************************************
 *	gSID֐
 ****************************************************************************/

void
psid_xsid_write(PSIDDRIVER* psid, unsigned short addr, unsigned char data)
{
	XSID* xsid = &psid->xsid;
	unsigned char* reg = xsid->reg;
	int regno = addr - 0xd400;

	switch(regno) {
	case 0x1d: /* Galway-Noise(START) / Sample(START/STOP) */
		switch(data) {
		case 0xfd: /* Sample(STOP) */
			xsid->state = 0;
			break;
		case 0xfc: /* Sample(START) Vol=1/4 */
		case 0xfe: /* Sample(START) Vol=1/2 */
		case 0xff: /* Sample(START) Vol=1/1 */
			psid_xsid_sample_start(psid, data);
			break;
		default: /* Galway-Noise(START) */
			psid_xsid_galway_noise_start(psid, data);
			break;
		}
		break;
	case 0x1e: /* Galway-Noise(ToneData addr Lo) / Sample(SampleData addr Lo) */
	case 0x1f: /* Galway-Noise(ToneData addr Hi) / Sample(SampleData addr Hi) */
	case 0x3d: /* Galway-Noise(Tonelength) / Sample(SampleData end addr Lo) */
	case 0x3e: /* Galway-Noise(Volume) / Sample(SampleData end addr Hi) */
	case 0x3f: /* Galway-Noise(Period for each value) / Sample(Repeat) */
	case 0x5d: /* Galway-Noise(Period for value 0) / Sample(Period Lo) */
	case 0x5e: /* Sample(Period Hi) */
	case 0x5f: /* Sample(Number of bytes to add after Reading one nibble) */
	case 0x7d: /* Sample(Sampleorder) */
	case 0x7e: /* Sample(SampleData repeat addr Lo) */
	case 0x7f: /* Sample(SampleData repeat addr Hi) */
		reg[regno] = data;
		break;
	default:
		DIE();
	}
}

void
psid_xsid_galway_noise_start(PSIDDRIVER* psid, unsigned char data)
{
	XSID* xsid = &psid->xsid;
	unsigned char* reg = xsid->reg;
	XSIDGN* gn = &xsid->context.gn;
	unsigned char* mem = psid->mem;

	xsid->state = XSID_GALWAY_NOISE;
	gn->tones	= data;				/* data`0܂ł̃_EJE^ */
	gn->addr	=  reg[0x1e] |			/* mem[addr+tones]`mem[addr+0]̏Ɏg܂ */
			   reg[0x1f] << 8;
	gn->len		=  reg[0x3d];			/* eToněpNbN */
	gn->vol		= (reg[0x3e] & 0xf) * 3;	/* Ȃ5.5bit (o͂17.5bitɂȂ悤ɒ) */
	gn->period1	=  reg[0x3f];			/* period = addr[tones] * period1 + period0 */
	gn->period0	=  reg[0x5d];

	/* p^̃`FbNB */
	if(!gn->vol || !gn->len || !gn->period1 || !gn->period0) {
		xsid->state = 0; /* LZ */
		return;
	}

	/* ŏ̃g[ݒB */
	gn->progress = 0;
	gn->period = mem[gn->addr + gn->tones] * gn->period1 + gn->period0;
	gn->count = gn->len;
}

void
psid_xsid_sample_start(PSIDDRIVER* psid, unsigned char data)
{
	XSID* xsid = &psid->xsid;
	unsigned char* reg = xsid->reg;
	XSIDSM* sm = &xsid->context.sm;

	xsid->state = XSID_SAMPLE;
	switch(data) { /* Volume=1/1ɏo͂t17.5bit(=16bit~3)ɂȂ悤ɐݒ */
	case 0xfc:        sm->vol = (1 << (16 - 4/*SampleData*/)) * 3 >> 2; break;
	case 0xfe:        sm->vol = (1 << (16 - 4/*SampleData*/)) * 3 >> 1; break;
	default: /*0xff*/ sm->vol = (1 << (16 - 4/*SampleData*/)) * 3 >> 0; break;
	}
	sm->addr	=     (reg[0x1e] |
			       reg[0x1f] << 8) << 1/*Nibble addr*/;
	sm->addr_end	=     (reg[0x3d] |
			       reg[0x3e] << 8) << 1/*Nibble addr*/;
	sm->rep_cnt	=      reg[0x3f];
	sm->period	=      reg[0x5d] |
			       reg[0x5e] << 8;
	sm->stride	= 1 << reg[0x5f];
	sm->order	=      reg[0x7d];
	sm->addr_rep	=     (reg[0x7e] |
			       reg[0x7f] << 8) << 1/*Nibble addr*/;
	sm->dda_d	= -sm->period;
}

int
psid_xsid_process(PSIDDRIVER* psid, int step)
{
	XSID* xsid = &psid->xsid;
	int value;

	switch(xsid->state) {
	case XSID_GALWAY_NOISE:
		value = psid_xsid_galway_noise_process(psid, step);
		break;
	case XSID_SAMPLE:
		value = psid_xsid_sample_process(psid, step);
		break;
	default:
		value = 0;
		break;
	}

	return value;
}

int
psid_xsid_galway_noise_process(PSIDDRIVER* psid, int step)
{
	int value;
	XSID* xsid = &psid->xsid;
	unsigned char* mem = psid->mem;
	XSIDGN* gn = &xsid->context.gn;

	/* NbNi߂܂B */
	gn->progress += step;
	while(gn->progress >= gn->period) { /* 1g`I? */
		gn->progress -= gn->period;
		gn->count--;
		if(!gn->count) { /* g[I? */
			if(!gn->tones) { /* I? */
				xsid->state = 0;
				return 0;
			}
			gn->tones--;
			/* ̃g[ݒB */
			/* (progress͌p) */
			gn->period = mem[gn->addr + gn->tones] * gn->period1 + gn->period0;
			gn->count = gn->len;
		}
	}

	/* Galway-Noise̔g`̓mRMgŒ݂łB(Ԃ) */
	/* period1<>0,period0<>0Ȃ̂ŁAperiod<>0ۏ؂Ă܂BZ͈SłB*/
	/* ܂gppxȂ1`lȂAZgĂ܂ȁH */
	value = ((gn->progress << 12) / gn->period - (1 << 11))	/*   12  bit */
	        * gn->vol;					/* ~Ȃ 5.5bit */
								/* 17.5bit */
	return value;
}

int
psid_xsid_sample_process(PSIDDRIVER* psid, int step)
{
	int value;
	XSID* xsid = &psid->xsid;
	unsigned char* mem = psid->mem;
	XSIDSM* sm = &xsid->context.sm;

	/* o̓Tv߂܂B */
	value = mem[sm->addr >> 1];
	if((sm->addr & 1) & sm->order) {
		/* {Lo,Hi}[1] or {Hi,Lo}[0] */
		value >>= 4;
	} else {
		/* {Lo,Hi}[0] or {Hi,Lo}[1] */
		value &= 0xf;
	}
	value = (value - 8)	/* 0`15 => -8`7 */
	        * sm->vol;	/* -8`7 => t17.5bit */

	/* Tvf[^AhXi߂܂B */
	sm->dda_d += step;
	while(sm->dda_d >= 0) {
		sm->dda_d -= sm->period;
		sm->addr += sm->stride;
	}
	while(sm->addr >= sm->addr_end) {
		if(sm->rep_cnt == 0) {
			xsid->state = 0;
			return 0;
		}
		if(sm->rep_cnt != 0xff/**/) {
			sm->rep_cnt--;
		}
		sm->addr -= sm->addr_end - sm->addr_rep;
	}

	return value;
}

/****************************************************************************
 *	PSIDhCo֐
 ****************************************************************************/

/* [`/t[`̌ĂяovO */
static const unsigned char psid_program[] = {
	'\x20',		/* +0: JSR Absolute */
	'\x00',		/* +1: ɌĂяoAhX̉ʃoCgZbg */
	'\x00',		/* +2: ɌĂяoAhX̏ʃoCgZbg */
	'\xcb',		/* +3: WAI */
};			/* =4 */
/* ĂяovO]AhX
 * Kernel ROM area (0xe000`0xffff) ̐^񒆂gȂƉ肵āA0xf000`ɒuƂɂ܂B
 * 2003/12/25
 * oNؑ֎0xe000`0xffffRAMɂȂA0xf000`ӂ܂Ń[U[vO[h\̂ŁA
 * Ŝ߂ɂƌAxN^e[u(0xfffa`0xffff)̒O߂ւ炷Ƃɂ܂B
 */
#define PSID_PROGRAM_ADDRESS	0xfff0 /*  */
/* Ăяo([`/t[`)AhXZbgAhX
 * ĂяovÓuJSR Absolutev߂̃IyhƂȂ܂B
 */
#define PSID_RUN_PC_ADDRESS	(PSID_PROGRAM_ADDRESS + 1)

void
psid_m6502_setup(PSIDDRIVER* psid, int a, int pc)
{
	M6502* m6502 = &psid->m6502;
	unsigned char* mem = psid->mem;

	/* ĂяovOoRŁAĂяovOĂяo܂B */
	mem[PSID_RUN_PC_ADDRESS + 0] = pc & 0xff;
	mem[PSID_RUN_PC_ADDRESS + 1] = pc >> 8;
	m6502->a = a;
	m6502->pc = PSID_PROGRAM_ADDRESS;
	m6502->sp = 0xff;
	m6502->wait = 0;  /* Kv!! */
	m6502->cycle = 0; /* Kv!! */
}

int
psid_init(PSIDDRIVER* psid, const void* _data, int len, int i_song)
{
	M6502* m6502 = &psid->m6502;
	unsigned char* mem = psid->mem;
	SID* sid = &psid->sid;
	//
	unsigned char* data = (unsigned char*)_data;
	PSIDHEADER* header = (PSIDHEADER*)_data;
	int data_offset;
	int load_addr;
	int init_addr;
	int play_addr;
	int songs;
	int start_song;
	int speed;
	//
	int n1, n2;

	/* ܂NA܂B */
	memset(psid, 0, sizeof(PSIDDRIVER));

	/* C܂B */
	memset(&mem[0x0000], 0x00, 0xe000);
	memset(&mem[0xe000], 0x40, 0x2000);	/* BASIC/Kernal ROM <= 0x40:RTI */
	mem[0x0001] = 7;			/* 6510 On-chip I/O Register <= 7 (Bank-sel) */
	mem[0x02a6] = 1;			/* 0:NTSC/1:PAL (Ă鉉t[`͂Ȃ悤ȋC邪c) */
	/* SIDvC[(SIDPlayerȂ)ɕāAxN^AhX̏li[Ă܂B
	 *   A̍ƂɈӖƂ͎v܂B
	 *   āÃxN^AhX̐Ɋ荞ݏ[`͂Ȃ̂łEEE
	 *   Ă܂ĂƎv̂łAÔ߂ɈꉞcĂ܂B
	 */
	mem[0x0314] = 0x31;			/* IRQ Interrupt Address <= 0xea31 (Default) */
	mem[0x0315] = 0xea;
	mem[0x0316] = 0x66;			/* BRK Interrupt Address <= 0xfe66 (Default) */
	mem[0x0317] = 0xfe;
	mem[0x0318] = 0x47;			/* NMI Interrupt Address <= 0xfe66 (Default) */
	mem[0x0319] = 0xfe;

	/* [`/t[`ĂяovO]܂B */
	memcpy(&mem[PSID_PROGRAM_ADDRESS], psid_program, sizeof psid_program);

	/* t@Cwb_͂܂B */
	if(memcmp(header->signature, "PSID", 4) != 0) return -1; /* VOl` */
	/* version͎g܂B */
	data_offset = PSID_HALF(header->data_offset);
	load_addr = PSID_HALF(header->load_addr);
	init_addr = PSID_HALF(header->init_addr);
	play_addr = PSID_HALF(header->play_addr);
	songs = PSID_HALF(header->songs);
	start_song = PSID_HALF(header->start_song);
	speed = PSID_WORD(header->speed);
	/* name͎g܂B */
	/* author͎g܂B */
	/* copyright͎g܂B */
	/* flags͎g܂B */
	/* reserved͎g܂B */

	/* tȔԍ肵܂B */
	if(!songs) songs = 1;			/* Ȑ0 => Ȑ1Ɖ߂dl */
	if(start_song) start_song--;		/* PSIDHEADER.start_song(1x[X) => init_addr(0x[X) */
	if(i_song < 0) i_song = start_song;	/* ɂȔԍw薳(i_song<0)ȂAstart_songgp */
	if(i_song < 0 || songs - 1 < i_song) return -1;

	/* C[Wǂݍ݂܂B */
	if(!load_addr) {
		/* load_addr=NULL̏ꍇ́AC[W̍ŏɃ[hAhXLĂ܂B */
		load_addr = data[data_offset + 0] | data[data_offset + 1] << 8; /* Little-endian! */
		data_offset += 2;
	}
	n1 = len - data_offset;			/* C[WTCY */
	n2 = PSID_PROGRAM_ADDRESS - load_addr;	/* [h\ȃTCY */
	if(n1 > n2) return -1;
	memcpy(&mem[load_addr], &data[data_offset], n1);

	/* SIDZbgB */
	sid_reset(sid, PSID_C64_CLOCK);
	/* gSID̓ZbgsvłB */

	/* CIA#1 Timer A lݒB
	 * * SIDt@CspeedtB[h̒lɂāAݒlς܂B
	 * - speedtB[ḧӖ͎̒ʂłB
	 *	bit 0:  1Ȗڂ̉t^C~O= 0:PALŒ / 1:CIA#1 Timer A 
	 *	bit 1:  2Ȗڂ̉t^C~O= 0:PALŒ / 1:CIA#1 Timer A 
	 *	...
	 *	bit31: 32Ȗڂ̉t^C~O= 0:PALŒ / 1:CIA#1 Timer A 
	 * - SIDt@C̎dlł́APAL^C~OCIAg킸1/50[b]Ԋuŉt[`ĂԂƂɂȂĂ܂A
	 *   {vO͊ȗ̂߂ɁAPAL/CIAǂ̏ꍇCIAgĉt[`Ăяo^C~O𐧌䂵Ă܂B
	 * - PAL^C~ȌꍇCIA1/50[b]ɐݒ肵A/t[`CIAĐݒ𖳌ɂĂ܂B
	 *   邱ƂɂA1/50[b]Œ^C~Oŉt[`Ă΂܂B
	 * - SID^C~Ȍꍇ́ACIȀl1/60[b]łB(C64VXePALNTSCɊ֌WȂ1/60[b]ł!!dv!!)
	 *   /t[`CIAĐݒ肵A̕ύX󂯓܂B
	 *   邱ƂɂAl1/60[b]܂͉σ^C~Oŉt[`Ă΂܂B
	 */
	psid->speed = (speed >> i_song) & 1;
	if(!psid->speed) {
		psid->cia_timer = PSID_C64_CLOCK / 50;	/* PAL(1/50[b])Œ */
	} else {
		psid->cia_timer = PSID_C64_CLOCK / 60;	/* CIA(1/60[b]) */
	}
	/* psid_mix()̏񃋁[vIRQ悤ɁAcia_count̏l0ƂĂ܂B(memsetŃNAς) */

	/* CPUZbgB */
	//m6502_reset(m6502, psid_m6502_read, psid_m6502_write);
	//I/O READ ȗ
	m6502_reset(m6502, NULL, psid_m6502_write);

	/* [`sB */
	if(!init_addr) {
		/* init_addr=NULL̏ꍇ́AC[W̐擪ɏ[`܂B */
		init_addr = load_addr;
	}
	psid_m6502_setup(psid, i_song, init_addr);
	m6502_run(m6502, PSID_C64_CLOCK);	/* 1bȓɊƉ  */
	if(!m6502->wait) return -1;		/* Ȃ΃G[ */

	/* t[`AhXB */
	if(!play_addr) {
		/* play_addr=NULL̏ꍇ́A[`荞݃xN^ݒ肵Ă܂B */
		if(mem[0x0001] & 2) {	/* Kernal ROM switched in */
			play_addr = mem[0x0314] | mem[0x0315] << 8; /* $0314: IRQ Hook   (Software) */
		} else {		/* Kernal ROM switched out */
			play_addr = mem[0xfffe] | mem[0xffff] << 8; /* $fffe: IRQ Vector (Hardware) */
		}
	}
	psid->play_addr = play_addr;

	return 0;
}

int
psid_stream_callback(short* wbuff, int param)
{
	return psid_mix((PSIDDRIVER*)param, wbuff);
}

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

int
psid_play(const void* data, int len, int i_song)
{
	static PSIDDRIVER psid; /* STATICł! */

	/* ܂mɒ~܂B */
	psid_stop();

	/* PSIDhCo܂B */
	if(psid_init(&psid, data, len, i_song) != 0) return -1;

	/* Xg[ĐJn܂B */
	stream_play(PSIDBUFLEN, psid_stream_callback, (int)&psid, 1/*X^bN؊gp*/);

	return 0;
}

void
psid_stop()
{
	/* Xg[Đ~܂B */
	stream_stop();

	/* PSIDhCõN[Abv͕svłB */
}

