/*	
 *	clipprnt.c
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2006 Naoyuki Sawa
 *
 *	* Tue May 20 06:00:00 JST 2003 Naoyuki Sawa
 *	- http://minix.technoir.org/src/lib/stdio/doprnt.cɉ܂B
 *	* Thu Jul 13 06:12:00 JST 2006 Naoyuki Sawa
 *	- snprintf(),vsnprintf()ǉ܂B
 *	- snprintf(),vsnprintf()Ή̂߂ɁAdoprnt()܂B
 *	  doprnt()sprintf(),vsprintf()pĂTu[`ŁAp܂B
 *	  sprintf(),vsprintf()ɉeoȂ悤CłA΂炭̊Ԃ͗vӂłB
 */
#include "clip.h"

/****************************************************************************
 *
 ****************************************************************************/

					// Ӗ		၁
#define FL_LJUST	(1 <<  0)	// l		%-5d
#define FL_ZEROFILL	(1 <<  1)	// 0l		%05d
#define FL_SIGN		(1 <<  2)	// +/-\		%+5d
#define FL_SPACE	(1 <<  3)	// /-\		% 5d
#define FL_ALT		(1 <<  4)	// 0/0x/0X\		%#x
#define FL_SHORT	(1 <<  5)	// n[t[h	%hd
#define FL_PRECSPEC	(1 <<  6)	// xw肠		%9.5f
#define FL_SIGNEDCONV	(1 <<  7)	// 		%d
#define FL_NOMORE	(1 << 31)	// igpj

/* widthprecision擾܂B */
static const char*
gnum(const char* fmt, int* ip, va_list* app)
{
	int i, c;

	if(*fmt == '*') {
		*ip = va_arg(*app, int);
		fmt++;
	} else {
		i = 0;
		for(;;) {
			c = *fmt;
			if(c < '0' || '9' < c) break;
			i = i * 10 + (c - '0');
			fmt++;
		}
		*ip = i;
	}

	return fmt;
}

/* l\܂B */
static char*
i_compute(unsigned val, int base, char* s, int precision)
{
	int c;

	c = val % base;
	val /= base;
	if(val || precision > 1) s = i_compute(val, base, s, precision - 1);
	*s++ = c < 10 ? '0' + c : 'a' + (c - 10);

	return s;
}

/* \܂B */
static char*
o_print(char* s, int flags, int nrdigits, int c, va_list* app)
{
	unsigned val;
	int base;
	char *old_s = s;

	/* l擾B */
	val = va_arg(*app, unsigned);
	if(flags & FL_SHORT) {
		if(flags & FL_SIGNEDCONV) {
			val = (         short)val;
		} else {
			val = (unsigned short)val;
		}
	}

	/* \B */
	if(flags & FL_SIGNEDCONV) {
		if((int)val < 0) {
			*s++ = '-';
			val = -(int)val;
		} else if(flags & FL_SIGN) {
			*s++ = '+';
		} else if(flags & FL_SPACE) {
			*s++ = ' ';
		}
	}

	/* \B */
	if(flags & FL_ALT) {
		switch(c) {
		case 'o': *s++ = '0';             break;
		case 'p':
		case 'x':
		case 'X': *s++ = '0'; *s++ = 'x'; break;
		}
	}

	/* l\B */
	switch(c) {
	case 'b': base =  2; break;
	case 'o': base =  8; break;
	case 'd':
	case 'i':
	case 'u': base = 10; break;
	case 'p':
	case 'x':
	case 'X': base = 16; break;
	default : base = -1; DIE();
	}
	s = i_compute(val, base, s, nrdigits);
	if(c == 'X') {
		while(old_s != s) {
			*old_s = toupper(*old_s);
			old_s++;
		}
	}

	return s;
}

/* \܂B */
static char*
f_print(char* s, int flags, int precision, va_list* app)
{
	double val;
	int c;

	/* l擾B */
	val = va_arg(*app, double);

	/* \B */
	if(val < 0) {
		*s++ = '-';
		val = -val;
	} else if(flags & FL_SIGN) {
		*s++ = '+';
	} else if(flags & FL_SPACE) {
		*s++ = ' ';
	}

	/* ľܓp+0.5or0.05or0.005... */
	val += pow(10, -precision) / 2;

	/* \B */
	c = (int)val;
	val -= c;
	s = i_compute(c, 10, s, 1);

	/* \B */
	if(precision) {
		*s++ = '.';
		do {
			val *= 10;
			c = (int)val;
			val -= c;
			*s++ = '0' + c;
		} while(--precision);
	}

	return s;
}

static int
//doprnt(char* out, const char* fmt, va_list ap)
//2006/07/13 snprintf(),vsnprintf()Ή
//
//- snprintf(),vsnprintf()ΉɂāAdoprnt()̈Ƀobt@TCY(cnt)ǉ̂łȂAobt@̃|C^(end)ǉ悤݌vŔA
//  Avsprintf()̗pɁAobt@\̂eՂłB(obt@̖̃|C^́A((char*)-1)ƕ\܂B)
//  ܂Adoprnt()̎ɂĂAcobt@TCYǗȀo͈ʒu(out)obt@(end)𒴂ĂȂȒPłB
//
//- snprintf()ȉ̂悤ɌĂяoꍇA
//
//	char buf[10];
//	snprintf(buf, 10, fmt, ...);
//
//  doprnt()ւ̈out,end́A}̂悤ȈʒuwĂ܂B
//
//	buf[0][1][2][3][4][5][6][7][8][9]
//	    |                          |
//	   out                        end
//
//  end(obt@̖)łA(obt@̖+1)ł͂ȂƂɒӂĂB
//  I[nul܂܂ȂALȕi[ł̂́A(out`end-1)͈̔͂ƂȂ܂B
//
//- I[nul܂܂ȂLȕ(out`end-1)͈̔͂Ɏ܂ꍇAnuli[Anul܂܂ȂԂ܂B
//  I[nul܂܂ȂLȕ(end-1)𒴂ꍇA(end-1)ȍ~؂̂Ă(end)nuli[A(-1)Ԃ܂B
//
//- Asnprintf()obt@TCY0ŌĂяoꍇA
//
//	snprintf(buf, 0, fmt, ...);
//
//  doprnt()ւ̈out,end́AendoutOwĂ܂B
//
//	buf[-1][0]
//	    |   |
//	   end out
//
//  ̏ꍇAI[nuli[ɁA(-1)Ԃ܂B
//
doprnt(char* out, char* end, const char* fmt, va_list ap)
{
/*{{2006/07/13 snprintf(),vsnprintf()Ή*/
#define OUT(C)				\
	do {				\
		char __c__ = (C);	\
		if(out < end) {		\
			*out = __c__;	\
		}			\
		out++;			\
	} while(0)
/*}}2006/07/13 snprintf(),vsnprintf()Ή*/

	int c, pad, len, flags, width, precision, zfill;
	char buf[256];	/* l̏o͕␸x̃TCY𒴂ƈُ퓮삵܂B */
	char *s, *old_s;
	char *old_out = out;

	/* 𑖍āc */
	while((c = *fmt++) != '\0') {
		/* w%[flags][width][.precision][h|l]typexłȂ΂̂܂ܕ\B */
		if(c != '%') {
			//*out++ = c;
			//2006/07/13 snprintf(),vsnprintf()Ή
			OUT(c);
			continue;
		}

		/* [flags]擾B */
		flags = 0;
		do {
			switch(*fmt) {
			case '-': flags |= FL_LJUST;    break;	/* l */
			case '0': flags |= FL_ZEROFILL; break;	/* 0l */
			case '+': flags |= FL_SIGN;     break;	/* +/-\ */
			case ' ': flags |= FL_SPACE;    break;	/* /-\ */
			case '#': flags |= FL_ALT;      break;	/* 0/0x/0X\ */
			default : flags |= FL_NOMORE;   continue;
			}
			fmt++;
		} while(!(flags & FL_NOMORE));
		if((flags & FL_LJUST) && (flags & FL_ZEROFILL)) DIE();
		if((flags & FL_SIGN ) && (flags & FL_SPACE   )) DIE();

		/* [width]擾B */
		fmt = gnum(fmt, &width, &ap);
		if(*fmt == '.') {
			fmt++;
			fmt = gnum(fmt, &precision, &ap);
			flags |= FL_PRECSPEC;
		}

		/* [h|l]擾B */
		switch(*fmt) {
		case 'h': flags |= FL_SHORT; fmt++; break;
		case 'l': /* intƓł */fmt++; break;
		case 'L': DIE(); /* long double ͖Ή */
		}

		s = old_s = buf;
		switch(c = *fmt++) {
		default:
			//*out++ = c;
			//2006/07/13 snprintf(),vsnprintf()Ή
			OUT(c);
			continue;
		case 'n':
			if(flags & FL_SHORT) {
				*va_arg(ap, short*) = (short)(out - old_out);
			} else {
				*va_arg(ap, int  *) = (int  )(out - old_out);
			}
			continue;
		case 'c':
			*s++ = va_arg(ap, int);
			break;
		case 's':
			old_s = va_arg(ap, char*);
			if(old_s == NULL) old_s = "(null)";
			s = old_s;
			while(*s != '\0') {
				if(flags & FL_PRECSPEC) {
					if(!precision) break;
					precision--;
				}
				s++;
			}
			break;
		case 'b':
		case 'o':
		case 'u':
		case 'p':
		case 'x':
		case 'X':
			if(!(flags & FL_PRECSPEC)) precision = 1;
			s = o_print(s, flags, precision, c, &ap);
			break;
		case 'd':
		case 'i':
			flags |= FL_SIGNEDCONV;
			if(!(flags & FL_PRECSPEC)) precision = 1;
			s = o_print(s, flags, precision, c, &ap);
			break;
		case 'f':
		case 'e': /* 1.2e3`͖ΉB'f'ƓƂ܂B */
		case 'E': /* 1.2e3`͖ΉB'f'ƓƂ܂B */
		case 'g': /* 1.2e3`͖ΉB'f'ƓƂ܂B */
		case 'G': /* 1.2e3`͖ΉB'f'ƓƂ܂B */
			flags |= FL_SIGNEDCONV;
			if(!(flags & FL_PRECSPEC)) precision = 6;
			s = f_print(s, flags, precision, &ap);
			break;
		}

		zfill = (flags & FL_ZEROFILL) ? '0' : ' ';
		len = s - old_s;
		pad = width - len;
		if(pad > 0) {
			if(!(flags & FL_LJUST)) {
				/* (+/-/)Ɗ(0/0x/0X)0l߂ɐs܂B */
				if(flags & FL_ZEROFILL) {
					if(flags & FL_SIGNEDCONV) {
						switch(*old_s) {
						case '+':
						case '-':
						case ' ':
							//*out++ = *old_s++;
							//2006/07/13 snprintf(),vsnprintf()Ή
							OUT(*old_s++);
							len--;
							break;
						}
					}
					if(flags & FL_ALT) {
						//switch(c) {
						//case 'o':
						//	*out++ = *old_s++;
						//	len--;
						//	break;
						//case 'p':
						//case 'x':
						//case 'X':
						//	*out++ = *old_s++;
						//	*out++ = *old_s++;
						//	len -= 2;
						//	break;
						//}
						//2006/07/13 snprintf(),vsnprintf()Ή
						switch(c) {
						case 'p':
						case 'x':
						case 'X':
							OUT(*old_s++);
							len--;
							/* FALLTHRU */
						case 'o':
							OUT(*old_s++);
							len--;
							break;
						}
					}
				}
				/* 󔒂܂0l߁B */
				while(pad > 0) {
					//*out++ = zfill;
					//2006/07/13 snprintf(),vsnprintf()Ή
					OUT(zfill);
					pad--;
				}
			}
		}
		while(len > 0) {
			//*out++ = *old_s++;
			//2006/07/13 snprintf(),vsnprintf()Ή
			OUT(*old_s++);
			len--;
		}
		while(pad > 0) {
			//*out++ = zfill;
			//2006/07/13 snprintf(),vsnprintf()Ή
			OUT(zfill);
			pad--;
		}
	}

	//*out = '\0'; /* I[NULYꂸ! */
	//return out - old_out;
	//2006/07/13 snprintf(),vsnprintf()Ή
	if(out <= end) {
		*out = '\0';
		return out - old_out;
	} else {
		if(end >= old_out) {
			*end = '\0';
		} else {
			/* obt@TCY0ȉ̏ꍇ́Anuli[ȂB */
		}
		return -1;
	}

/*{{2006/07/13 snprintf(),vsnprintf()Ή*/
#undef OUT
/*}}2006/07/13 snprintf(),vsnprintf()Ή*/
}

/****************************************************************************
 *
 ****************************************************************************/

/* u#include <piece.h>v̑OɁu#define NOPCESPRINTFvYꂸɁI */

/* P/ECEJ[l܂EPSONCů֐u܂B */
int
vsprintf(char* out, const char* fmt, va_list ap)
{
	//return doprnt(out, fmt, ap);
	//2006/07/13 snprintf(),vsnprintf()Ή
	return doprnt(out, (char*)-1/*obt@̖*/, fmt, ap);
}

/* P/ECEJ[l܂EPSONCů֐u܂B */
int
sprintf(char* out, const char* fmt, ...)
{
	int n;
	va_list ap;
	va_start(ap, fmt);
	n = vsprintf(out, fmt, ap);
	va_end(ap);
	return n;
}

/*{{2006/07/13 snprintf(),vsnprintf()Ή*/

/* * Thu Jul 13 06:12:00 JST 2006 Naoyuki Sawa
 * - vsnprintf()ǉ܂B
 *   P/ECEJ̃Cuɂ́Avsnprintf()܂܂Ă܂B
 * - vsnprintf()́AC99ɂĐɒǉꂽ֐łB
 *   C99ɏĂȂRpCł́Avsnprintf()T|[gĂȂAĂꍇ܂B
 *   ƂVC++6.0_vsnprintf()́Ao͕(n-1)𒴂ꍇ̋Ă܂B
 *   o͕(n-1)𒴂ꍇAC99̎dlł́A(n-1)܂ŕo͂A(n)ڂnuli[܂B
 *   ɑ΂VC++6.0̎dlł́A(n)܂ŕo͂Anuli[܂B(strncpy()ɎłB)
 *   C99̎dl̕Ao͕񂪊mnulI[̂ŁAgՂƎv܂B
 *   ̎́AC99̎dlɏ]܂B
 * - C99VC++6.0̋̈ႢTvR[hAȉɎ܂B
 *   ȉ̃TvR[hsnprintf()̗łAvsnprintf()lłB
 *
 *	main() {
 *	    char buf[] = "0123456789";
 *	    snprintf(buf, 5, "ABCDEFG");     // C99̋c
 *	    printf("<%s>\n", buf);           //   ʁuABCDv
 *	    _snprintf(buf, 5, "ABCDEFG");    // VC++6.0̋c
 *	    printf("<%s>\n", buf);           //   ʁuABCDE56789v
 *	}
 *
 * - QluvO~O C ̐V@\ (http://seclan.dll.jp/c99d/c99d08.htm#dt19991115)v
 *	
 *	O	int vsnprintf(char * restrict s, size_t n, const char * restrict format, va_list arg);		
 *	
 *	wb_stdio.h												
 *	
 *		s      : o͐obt@										
 *		n      : o͐obt@̕									
 *		format : 												
 *		arg    : va_start ŏl									
 *	
 *	߂lo͂BI[̃k͊܂܂ȂBG[͕̒lB						
 *	
 *		vsprintf  o͕ΉŁBformat ɏ] s ɍő n - 1 o͂B		
 *		n - 1 ȏo͂ꂽꍇ͔jBs ̏I[ɂ̓ktB				
 *		Ql : wchar_t 󂯕t֐ vswprintf A̓obt@włdlɂȂĂB	
 *	
 */
int
vsnprintf(char* out, int cnt, const char* fmt, va_list ap)
{
	return doprnt(out, out + cnt - 1/*obt@̖*/, fmt, ap);
}

/* * Thu Jul 13 06:12:00 JST 2006 Naoyuki Sawa
 * - snprintf()ǉ܂B
 *   P/ECEJ̃Cuɂ́Asnprintf()܂܂Ă܂B
 * - VC++6.0_snprintf()Ƃ̋̈ႢɂẮAvsnprintf()ƓlłB
 *   vsnprintf()̃RgQƂĂB
 *
 * - QluvO~O C ̐V@\ (http://seclan.dll.jp/c99d/c99d08.htm#dt19991115)v
 *	
 *	O	int snprintf(char * restrict s, size_t n, const char * restrict format, ...);				
 *	
 *	wb_stdio.h												
 *	
 *		s      : o͐obt@										
 *		n      : o͐obt@̕									
 *		format : 												
 *		...    : Ŏw肵l										
 *	
 *	߂lo͂BI[̃k͊܂܂ȂBG[͕̒lB						
 *	
 *		sprintf ̏o͕wŁBformat ɏ] s ɍő n - 1 o͂B		
 *		n - 1 ȏo͂ꂽꍇ͔jBs ̏I[ɂ̓ktB				
 *		Ql : wchar_t 󂯕t֐ swprintf A̓obt@włdlɂȂĂB	
 *	
 */
int
snprintf(char* out, int cnt, const char* fmt, ...)
{
	int n;
	va_list ap;
	va_start(ap, fmt);
	n = vsnprintf(out, cnt, fmt, ap);
	va_end(ap);
	return n;
}
/*}}2006/07/13 snprintf(),vsnprintf()Ή*/

