/*	
 *	clipfnt8.c
 *
 *	8hbgtHg`惋[``܂B
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2008 Naoyuki Sawa
 *
 *	* Sat Mar 08 22:02:58 JST 2008 Naoyuki Sawa
 *	- 1st [XB
 */
#include "clip.h"

/*****************************************************************************
 *	
 *****************************************************************************/

unsigned char font8_w = 8; /* Ԋu() */
unsigned char font8_h = 8; /* Ԋu(c) */

/* * P/ECE HANDBOOK Vol.2 CD-ROMt́Afreedata/cg/W.bmpɂč쐬܂B
 * - W.bmp͊e8x8sNZłAẻE[sNZ͕K̂ŁA
 *   TCYߖ񂷂邽߂ɁAẻE[sNZāAe7x8sNZƂ܂B
 *   ύX摜́Akeep/clipfnt8_font8-1.7zɕۑĂ܂B
 * - قƂǂ́̕A5x7sNZȓɎ܂Ă܂B
 *   łAfont8_w=6,font8_h=8Ɛݒ肵ĕ`ƁAYɊԂl܂Č܂B
 *   5x7sNZ𒴂Ă镶́Aȉ̕łB
 *	u,vug]ujv	5x8sNZ
 *	uv		6x7sNZ
 *	u'\xff'v	7x8sNZ
 *   font8_w=6,font8_h=8̐ݒł́A̕Ɨׂ̊̕ԊuȂĂ܂܂B
 *   AقƂǋCɂȂȂƎv܂B
 *   mɁAׂ荇̊Ԋumۂɂ́Afont8_w=8,font8_h=9Ɛݒ肵ĂB
 */
static const unsigned font8_texture[] = {
	0x50424d50,			/* TEXTURE.header.head */
	0x00000634,			/* TEXTURE.header.fsize */
	0x00700001,			/* TEXTURE.header.bpp,mask,w */
	0x00000070,			/* TEXTURE.header.h,(pad) */
	0x00000620,			/* TEXTURE.buf_size */
	(unsigned)&font8_texture[7],	/* TEXTURE.buf */
	0x00000000,			/* TEXTURE.mask */
	0x02606300,0x10301808,0x00008180,0x63000000,0x24958762,0xa1422030,0x04000000,
	0xca476200,0x4020140a,0x0000c121,0x60000800,0x2a048702,0x87204000,0x10001fc0,
	0x82026000,0x4000248a,0x0000c121,0x00002000,0x2215cf07,0xa1422000,0x40180006,
	0x82026000,0x10001c02,0x00068180,0x00000018,0x00000000,0x00000000,0x00000004,
	0x83c34170,0x707c1c1f,0x000100e0,0xc2883810,0x22104524,0xc1108944,0x44080082,
	0x49204098,0x8904201e,0x1f84c110,0x41a80404,0x3c0189c1,0x00f07008,0x08020008,
	0x4f0042c8,0x88102281,0x1f84c110,0x42881004,0x22114104,0xc1108910,0x00080082,
	0x81e3e370,0x70101c0e,0x000103e0,0x00001010,0x00000000,0x00000000,0x00000000,
	0x8fc3e370,0x88383e1f,0x11484440,0x12893822,0x20904824,0x44408844,0x44321b88,
	0x082412e9,0x88402090,0x15084540,0xf3b9442a,0x3c9e08c4,0x4640f85c,0x44261108,
	0x082412d9,0x88442090,0x11084540,0x12894422,0x20904824,0x44428844,0x44221188,
	0x8fc31371,0x8838201f,0x914f8441,0x00003822,0x00000000,0x00000000,0x00000000,
	0x8fc3e3f0,0x89442291,0x0e80e313,0x12890008,0x22114224,0x22108944,0x00140208,
	0x02241289,0x51442211,0x02044210,0x13f10022,0x221182c3,0x82a02044,0x00000202,
	0x4220d281,0x50542211,0x02010241,0x22810000,0x14114224,0x0242886c,0x00008200,
	0x8223d280,0x8844080e,0x0e80e343,0x00007c00,0x00000000,0x00000000,0x00000000,
	0x00000260,0x80000480,0x00060400,0x02600000,0x08800000,0xe4e08000,0x00000002,
	0x87c3e320,0xf03c088e,0x1ac20400,0x1200383c,0x3e914824,0x45408844,0x44221502,
	0x0824f200,0x8844089f,0x15024640,0x12014422,0x08904824,0x4540883c,0x44221502,
	0x87c3f300,0x8804088e,0x15c24442,0x00003822,0x00000000,0x80010038,0x00000000,
	0x02000000,0x00000000,0x0c820100,0x00000012,0x00000200,0x02000000,0x002a0202,
	0x8fc3f2f0,0x89442291,0x0202e213,0x13890024,0x22110224,0x46105144,0x00000300,
	0x82031289,0x21542211,0x02028210,0xf2f00000,0x14114200,0x02f1506c,0x00000202,
	0x81071280,0x8844088e,0x0c82e113,0x10800000,0x00000000,0x00e00100,0x00000000,
	0x00000000,0x00001000,0x00000000,0xa1200000,0x3e0000c1,0x81c10010,0x00080808,
	0x87c3f171,0x907c100e,0x16c54720,0xf3f9380e,0x0c9fc8e7,0xe1e38810,0x44089d46,
	0x88e3f3d9,0x8934149f,0x158c4310,0xe020041c,0x209f0881,0x8511905c,0x082a1644,
	0x07c04170,0x403c1e0e,0x044263e2,0x00003010,0x00000000,0x00000000,0x00000000,
	0x06034100,0x18200a04,0x0208c1a1,0xf2014414,0x1e1f8140,0x2722217c,0x28141fc8,
	0x8f234200,0x41102b85,0x06884070,0xd2007c3e,0x138e4024,0x0320817c,0x20140a89,
	0x43206201,0x41301215,0x86080421,0x72014010,0x04154584,0x24222144,0x44129248,
	0x8803d100,0x1938188d,0x0c87c341,0x0000380c,0x00000000,0x00000000,0x00000000,
	0x00e00100,0x00003e00,0x00000000,0x01000000,0x02000000,0x00400000,0x00000084,
	0x80000100,0x197c1e04,0x8ecfe7f3,0xc100543e,0x020e8000,0x81102104,0x54028284,
	0x8c002101,0xe1180404,0x82848210,0x2001543e,0x08008600,0x82102010,0x04020285,
	0x8607c000,0x20203000,0x1f84e4e3,0x0000783c,0x00000000,0x00000000,0x00000000,
	0x0021f001,0x38200802,0x00800280,0x10000010,0x3e9fcf47,0xe7f3487c,0x443e9fce,
	0x42841000,0x88101202,0x818022a0,0x53704412,0x22064280,0x2220097c,0x2414828e,
	0x42806088,0x1008220a,0x84802020,0x40000410,0x04128284,0x24202104,0x48120a89,
	0x0f838001,0xc0041892,0x1106e3c3,0x0000300c,0x00000000,0x00000000,0x00000000,
	0xc4873238,0x20000004,0x00008400,0xc2490008,0x1c1f04a0,0x4410f87c,0x7c3e84cf,
	0xc6a742a8,0x10040004,0x8a004711,0xf2190408,0x000405a1,0x24212028,0x04088a00,
	0x04214008,0x70100084,0x91002442,0x4011282a,0x00040421,0x2482a828,0x102a1109,
	0x04c68360,0x21443e18,0x01c62302,0x0000082a,0x00000000,0x00000000,0x00000000,
	0xc40720e0,0x88380000,0x00000021,0x40183028,0x3e8e0f22,0x03a18800,0x48149d8f,
	0x04228040,0x887c0282,0x814804a1,0x2139480a,0x3e82c447,0x24a18804,0x30008148,
	0x05821001,0x08040202,0x814024a1,0x31e10000,0x02020442,0x44219144,0x00000249,
	0xc421d219,0x61383e1f,0x1c868330,0x00000000,0x00000000,0x00000000,0x00000000,
	0xc8c74140,0x40481084,0x00044401,0xf2f9101e,0x261f0521,0xe2625028,0x7c240cc2,
	0x02228040,0xe838280a,0x128042d2,0xe058102e,0x200b0424,0x4452496c,0x7c241242,
	0x08241080,0x495c2016,0x1149c452,0x12a1302c,0x289b4844,0x4253d95c,0x58349149,
	0x8783e198,0x583c1604,0x818ea192,0x0000342a,0x00000000,0x00000000,0x00000000,
	0x094142c0,0x51180808,0x08c407f1,0xf1297f00,0x0e16c547,0x40118844,0x7f000845,
	0x06c28128,0x8840089d,0x888ea163,0x93797f00,0x0895cc67,0x20218838,0x7f008c84,
	0x05a282a9,0x08041c15,0x94442091,0x92a87f00,0x2a0644a2,0x44539144,0x7f00954c,
	0x84a16168,0x60381a08,0x128523e1,0x00007f00,0x00000000,0x00000000,0x7f000000,
};

/*****************************************************************************
 *	
 *****************************************************************************/

int
render_font8(RENDER* render, int x, int y, int code, int color)
{
	TEXTURE* texture_save;

	if((code -= 32) <=  0) goto L_EXIT; /* ̂ߋ󔒂͕`܂ */
	if( code        > 223) goto L_EXIT;

	texture_save = render->context->texture;
	render->context->texture = (TEXTURE*)font8_texture;
	render_object(render,
		x, y,
		(code &  15) *  7,
		(code & ~15) >> 1,
		7, 8,
		DRW_CLR(color, COLOR_MASK));
	render->context->texture = texture_save;
L_EXIT:
	return 7 | 8 << 8;
}

int
render_string8(RENDER* render, int x, int y, const char* _str, int color)
{
	const unsigned char* str = (const unsigned char*)_str;
	int xmin = x;
	int xmax = x - 7;
	int ymin = y;
	int ymax = y - 8;
	int s = 0;
	int c;

	while((c = *str++) != '\0') {
		switch(c) {
		case '\xe': /* SO -> J^Ji */
		case '\xf': /* SI -> Ђ炪 */
			s = (c & 1) << 5;
			break;
		case '\n':
			x = xmin;
			y += font8_h;
			break;
		default:
			if((c >= (unsigned char)'') &&
			   (c <= (unsigned char)'')) {
				c ^= s;
			}
			render_font8(render, x, y, c, color);
			if(x > xmax) xmax = x;
			if(y > ymax) ymax = y;
			x += font8_w;
			break;
		}
	}

	return ((xmax + 7) - xmin) | ((ymax + 8) - ymin) << 16;
}

int
render_printf8(RENDER* render, int x, int y, int color, const char* fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
	vsprintf(_def_vbuff, fmt, ap);
	va_end(ap);

	return render_string8(render, x, y, _def_vbuff, color);
}

int
render_font8_framed(RENDER* render, int x, int y, int code, int color)
{
	int c;

	c = (color >> 8) & 15; render_font8(render, x + 0, y + 0, code, c);
	                       render_font8(render, x + 2, y + 0, code, c);
	                       render_font8(render, x + 0, y + 2, code, c);
	                       render_font8(render, x + 2, y + 2, code, c);
	c = (color >> 4) & 15; render_font8(render, x + 1, y + 0, code, c);
	                       render_font8(render, x + 0, y + 1, code, c);
	                       render_font8(render, x + 2, y + 1, code, c);
	                       render_font8(render, x + 1, y + 2, code, c);
	c = (color >> 0) & 15; render_font8(render, x + 1, y + 1, code, c);

	return (7 + 2) | (8 + 2) << 8;
}

int
render_string8_framed(RENDER* render, int x, int y, const char* str, int color)
{
	int c;

	c = (color >> 8) & 15;    if(!render_string8(render, x + 0, y + 0, str, c)) return 0;
	                              render_string8(render, x + 2, y + 0, str, c);
	                              render_string8(render, x + 0, y + 2, str, c);
	                              render_string8(render, x + 2, y + 2, str, c);
	c = (color >> 4) & 15;        render_string8(render, x + 1, y + 0, str, c);
	                              render_string8(render, x + 0, y + 1, str, c);
	                              render_string8(render, x + 2, y + 1, str, c);
	                              render_string8(render, x + 1, y + 2, str, c);
	c = (color >> 0) & 15; return render_string8(render, x + 1, y + 1, str, c) + (2 | 2 << 16);
}

int
render_printf8_framed(RENDER* render, int x, int y, int color, const char* fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
	vsprintf(_def_vbuff, fmt, ap);
	va_end(ap);

	return render_string8_framed(render, x, y, _def_vbuff, color);
}
