
;  GNU C 2.7.2 [AL 1.1, MM 40] RISC NEWS-OS compiled by CC

;  Cc1 defaults:
;  -mmemcpy

;  Cc1 arguments (-G value = 0, Cpu = 3000, ISA = 1):
;  -quiet -dumpbase -O2 -Wall -o

gcc2_compiled.:
__gnu_compiled_c:
; APP
	
		.code
		.align		1
		.global		vec3f_intersection_p_l
vec3f_intersection_p_l:
		;// %r12     := ߂li[B
		;// %r13     := p
		;// %r14     := n
		;// %r15     := a
		;// [%sp+0]  := retp
		;// [%sp+4]  := v
	sub	%sp,0x6		; 		xsub		%sp, %sp, 24
		;//
	ld.w	[%sp+0x3],%r12	; 		xld.w		[%sp+12], %r12			;// [%sp+12] := ߂li[B
	ld.w	[%sp+0x4],%r14	; 		xld.w		[%sp+16], %r14			;// [%sp+16] := n
	ld.w	[%sp+0x5],%r15	; 		xld.w		[%sp+20], %r15			;// [%sp+20] := a
		;//
		ld.w		%r12, %sp			;// %r12     :=        &q
	ext	memcpy@rm	; 		xcall.d		memcpy				;// %r10     := memcpy(&q, p, sizeof(vec3f)) -+
	call.d	memcpy@rl
		ld.w		%r14, 12			;// %r14     :=               sizeof(vec3f)   |			*delay*
		;//						;//                                           |
	ld.w	%r13,[%sp+0x5]	; 		xld.w		%r13, [%sp+20]			;// %r13     :=               a               |
	ext	vec3f_sub@rm	; 		xcall.d		vec3f_sub			;//             vec3f_sub(&q, a)              |
	call.d	vec3f_sub@rl
		ld.w		%r12, %r10			;// %r12     :=           &q <----------------+			*delay*
		;//
		ld.w		%r12, %sp			;// %r12     :=               &a
	ld.w	%r13,[%sp+0x4]	; 		xld.w		%r13, [%sp+16]			;// %r13     :=                   n
	ext	vec3f_dot@rm	; 		xcall		vec3f_dot			;// %r10     :=     vec3f_dot(&q, n)
	call	vec3f_dot@rl
	ld.w	[%sp+0x0],%r10	; 		xld.w		[%sp+0], %r10			;// [%sp+0]  :=     vec3f_dot(&q, n)
		;//
	ld.w	%r12,[%sp+0x7]	; 		xld.w		%r12, [%sp+28]			;// %r12     :=                                  v
	ld.w	%r13,[%sp+0x4]	; 		xld.w		%r13, [%sp+16]			;// %r13     :=                                     n
	ext	vec3f_dot@rm	; 		xcall		vec3f_dot			;// %r10     :=                        vec3f_dot(v, n) --+
	call	vec3f_dot@rl
		;//						;//                                                      |
	ld.w	%r12,[%sp+0x0]	; 		xld.w		%r12, [%sp+0]			;// %r12     :=     vec3f_dot(&q, n)                     |
	ext	__divsf3@rm	; 		xcall.d		__divsf3			;// %r10     := f = vec3f_dot(&q, n) / vec3f_dot(v, n)   |
	call.d	__divsf3@rl
		ld.w		%r13, %r10			;// %r13     :=                        vec3f_dot(v, n) <-+	*delay*
		;//
	ld.w	[%sp+0x0],%r10	; 		xld.w		[%sp+0], %r10			;// [%sp+0]  := q.x = f
	ld.w	[%sp+0x1],%r10	; 		xld.w		[%sp+4], %r10			;// [%sp+4]  := q.y = f
	ld.w	[%sp+0x2],%r10	; 		xld.w		[%sp+8], %r10			;// [%sp+8]  := q.z = f
		ld.w		%r12, %sp			;// %r12     :=           &q
	ld.w	%r13,[%sp+0x7]	; 		xld.w		%r13, [%sp+28]			;// %r13     :=               v
	ext	vec3f_mul@rm	; 		xcall		vec3f_mul			;//             vec3f_mul(&q, v)
	call	vec3f_mul@rl
		;//
		ld.w		%r12, %sp			;// %r12     :=           &q
	ld.w	%r13,[%sp+0x5]	; 		xld.w		%r13, [%sp+20]			;// %r13     :=               a
	ext	vec3f_add@rm	; 		xcall		vec3f_add			;//             vec3f_add(&q, a)
	call	vec3f_add@rl
		;//
	ld.w	%r12,[%sp+0x3]	; 		xld.w		%r12, [%sp+12]			;// %r12     := ߂li[B
		ld.w		%r13, %sp			;// %r13     :=                &q
	ext	memcpy@rm	; 		xcall.d		memcpy				;// %r10     := memcpy(߂l, &q, sizeof(vec3f))
	call.d	memcpy@rl
		ld.w		%r14, 12			;// %r14     :=                    sizeof(vec3f)		*delay*
		;//
	add	%sp,0x6		; 		xadd		%sp, %sp, 24
		ret						;// %r10     := ߂li[B (S1C33 ABIdlɂK{)

	
		.code
		.align		1
		.global		vec2f_distance_l_p
vec2f_distance_l_p:
	sub	%sp,0x5		; 		xsub		%sp, %sp, 20
		;//
		ld.w		%r4, [%r12]+		;// %r4      := a->x
		ld.w		%r5, [%r12]		;// %r5      := a->y
	ld.w	[%sp+0x0],%r4	; 		xld.w		[%sp+0], %r4		;// [%sp+0]  := v1.x = a->x
	ld.w	[%sp+0x1],%r5	; 		xld.w		[%sp+4], %r5		;// [%sp+4]  := v1.y = a->y
	ld.w	[%sp+0x2],%r4	; 		xld.w		[%sp+8], %r4		;// [%sp+8]  := v2.x = a->x
	ld.w	[%sp+0x3],%r5	; 		xld.w		[%sp+12], %r5		;// [%sp+12] := v2.y = a->y
	ld.w	[%sp+0x4],%r14	; 		xld.w		[%sp+16], %r14		;// [%sp+16] := c
		;//
		ld.w		%r12, %sp		;// %r12     :=           &v1
	ext	vec2f_sub@rm	; 		xcall		vec2f_sub		;//             vec2f_sub(&v1, b)
	call	vec2f_sub@rl
		;//
	ld.w	%r13,[%sp+0x4]	; 		xld.w		%r13, [%sp+16]		;// %r13     :=                c
;//		xadd		%r12, %sp, 8		;// %r12     :=           &v2 ----+
		ld.w		%r12, %sp		;// <-----------------------------+
	ext	vec2f_sub@rm	; 		xcall.d		vec2f_sub		;//             vec2f_sub(&v2, c) |
	call.d	vec2f_sub@rl
		add		%r12, 8			;// <-----------------------------+						*delay*
		;//
		ld.w		%r12, %sp		;// %r12     :=             &v1							*delay*
;//		xadd		%r13, %sp, 8		;// %r12     :=                  &v2 ---+
		ld.w		%r13, %sp		;// <-----------------------------------+
	ext	vec2f_cross@rm	; 		xcall.d		vec2f_cross		;// %r10     := vec2f_cross(&v1, &v2) --|-+
	call.d	vec2f_cross@rl
		add		%r13, 8			;// <-----------------------------------+ |					*delay*
	ld.w	[%sp+0x4],%r10	; 		xld.w		[%sp+16], %r10		;// [%sp+16] := vec2f_cross(&v1, &v2) <---+
		;//
		ld.w		%r12, %sp		;// %r12     :=           &v1
	ext	vec2f_mag@rm	; 		xcall		vec2f_mag		;//             vec2f_mag(&v1) --------------------------+
	call	vec2f_mag@rl
		;//					;//                                                      |
	ld.w	%r12,[%sp+0x4]	; 		xld.w		%r12, [%sp+16]		;// %r12     := vec2f_cross(&v1, &v2)                    |
	ext	__divsf3@rm	; 		xcall.d		__divsf3		;// %r10     := vec2f_cross(&v1, &v2) / vec2f_mag(&v1) --|-----+
	call.d	__divsf3@rl
		ld.w		%r13, %r10		;// %r13     :=                         vec2f_mag(&v1) <-+     |		*delay*
		;//					;//                                                            |
	add	%sp,0x5		; 		xadd		%sp, %sp, 20		;//                                                            |
		;//					;//                                                            |
	ext	fabsf@rm	; 		xjp.d		fabsf			;// %r10     := fabsf(vec2f_cross(&v1, &v2) / vec2f_mag(&v1))  |
	jp.d	fabsf@rl
		ld.w		%r12, %r10		;// %r12     :=       vec2f_cross(&v1, &v2) / vec2f_mag(&v1) <-+		*delay*

	
		.code
		.align		1
		.global		vec2f_intersection_l_p
vec2f_intersection_l_p:
	sub	%sp,0x9		; 		xsub		%sp, %sp, 36
		;//
	ld.w	[%sp+0x1],%r12	; 		xld.w		[%sp+4], %r12		;// [%sp+4]  := ߂li[B
	ld.w	[%sp+0x2],%r13	; 		xld.w		[%sp+8], %r13		;// [%sp+8]  := a
	ld.w	[%sp+0x3],%r14	; 		xld.w		[%sp+12], %r14		;// [%sp+12] := b
	ld.w	[%sp+0x4],%r15	; 		xld.w		[%sp+16], %r15		;// [%sp+16] := c
		;//
		ld.w		%r4, [%r13]+		;// %r4      := a->x
		ld.w		%r5, [%r13]		;// %r5      := a->y
		ld.w		%r6, [%r14]+		;// %r6      := b->x
		ld.w		%r7, [%r14]		;// %r7      := b->y
	ld.w	[%sp+0x5],%r5	; 		xld.w		[%sp+20], %r5		;// [%sp+20] := d.x = a->y
	ld.w	[%sp+0x6],%r6	; 		xld.w		[%sp+24], %r6		;// [%sp+24] := d.y = b->x
	ld.w	[%sp+0x7],%r7	; 		xld.w		[%sp+28], %r7		;// [%sp+28] := b->y
	ld.w	[%sp+0x8],%r4	; 		xld.w		[%sp+32], %r4		;// [%sp+32] := a->x
		;//
	ld.w	%r12,%sp	; 		xadd		%r12, %sp, 20		;// %r12     := &d
	add	%r12,0x14
	ld.w	[%sp+0x0],%r12	; 		xld.w		[%sp+0], %r12		;// [%sp+0]  := &d ---------------------------------+
;//		xadd		%r13, %sp, 28		;// %r13     :=     { b->y, a->x } --+              |
		ld.w		%r13, %sp		;// <--------------------------------+              |
	ext	vec2f_sub@rm	; 		xcall.d		vec2f_sub		;//   vec2f_sub(&d, { b->y, a->x })  |              |
	call.d	vec2f_sub@rl
		add		%r13, 28		;// <--------------------------------+              |	*delay*
		;//					;//                                                 |
	ld.w	%r12,[%sp+0x0]	; 		xld.w		%r12, [%sp+0]		;// %r12     := &d                                  |
	ld.w	%r13,[%sp+0x4]	; 		xld.w		%r13, [%sp+16]		;// %r13     :=     { c->x, c->y }                  |
	ext	vec2f_add@rm	; 		xcall		vec2f_add		;//   vec2f_add(&d, { c->x, c->y })                 |
	call	vec2f_add@rl
		;//					;//                                                 |
	ld.w	%r12,[%sp+0x1]	; 		xld.w		%r12, [%sp+4]		;// %r12     := ߂li[B            |
	ld.w	%r13,[%sp+0x2]	; 		xld.w		%r13, [%sp+8]		;// %r13     :=                      a              |
	ld.w	%r14,[%sp+0x3]	; 		xld.w		%r14, [%sp+12]		;// %r14     :=                         b           |
	ld.w	%r15,[%sp+0x4]	; 		xld.w		%r15, [%sp+16]		;// %r15     :=                            c        |
	call	vec2f_intersection_l	; 		xcall		vec2f_intersection_l	;// %r10     := vec2f_intersection_l(a, b, c, &d) <-+
		;//
	add	%sp,0x9		; 		xadd		%sp, %sp, 36
		ret					;// %r10     := ߂li[B (S1C33 ABIdlɂK{)

	
		.code
		.align		1
		.global		vec2f_intersection_l
vec2f_intersection_l:
	sub	%sp,0x8		; 		xsub		%sp, %sp, 32
		;//
	ld.w	[%sp+0x6],%r12	; 		xld.w		[%sp+24], %r12		;// [%sp+24] := ߂li[B
		;//
		ld.w		%r4, [%r14]+		;// %r4      := a2->x
		ld.w		%r5, [%r14]		;// %r5      := a2->y
	ld.w	[%sp+0x0],%r4	; 		xld.w		[%sp+0], %r4		;// [%sp+0]  := a.x = a2->x
	ld.w	[%sp+0x1],%r5	; 		xld.w		[%sp+4], %r5		;// [%sp+4]  := a.y = a2->y
		;//
		ld.w		%r4, [%r13]+		;// %r4      := a1->x, %r13 := a1 + 4 --+
		ld.w		%r5, [%r13]		;// %r5      := a1->y			|
	ld.w	[%sp+0x2],%r4	; 		xld.w		[%sp+8], %r4		;// [%sp+8]  := b.x = a1->x		|
	ld.w	[%sp+0x3],%r5	; 		xld.w		[%sp+12], %r5		;// [%sp+12] := b.y = a1->y		|
		;//					;//					|
		ld.w		%r4, [%r15]+		;// %r4      := b1->x			|
		ld.w		%r5, [%r15]		;// %r5      := b1->y			|
	ld.w	[%sp+0x4],%r4	; 		xld.w		[%sp+16], %r4		;// [%sp+16] := c.x = b1->x		|
	ld.w	[%sp+0x5],%r5	; 		xld.w		[%sp+20], %r5		;// [%sp+20] := c.y = b1->y		|
		;//					;//					|
		ld.w		%r12, %sp		;// %r12     :=           &a		|
	ext	vec2f_sub@rm	; 		xcall.d		vec2f_sub		;//             vec2f_sub(&a, a1)	|
	call.d	vec2f_sub@rl
		sub		%r13, 4			;// %r13     :=               a1 <------+				*delay*
		;//
	ld.w	%r13,[%sp+0x9]	; 		xld.w		%r13, [%sp+36]		;// %r13     :=               b2
;//		xadd		%r12, %sp, 8		;// %r12     :=           &b -----+
		ld.w		%r12, %sp		;// <-----------------------------+
	ext	vec2f_sub@rm	; 		xcall.d		vec2f_sub		;//             vec2f_sub(&b, b2) |
	call.d	vec2f_sub@rl
		add		%r12, 8			;// <-----------------------------+					*delay*
		;//
	ld.w	%r13,[%sp+0x9]	; 		xld.w		%r13, [%sp+36]		;// %r13     :=               b2
;//		xadd		%r12, %sp, 16		;// %r12     :=           &c -----+
		ld.w		%r12, %sp		;// <-----------------------------+
	ext	vec2f_sub@rm	; 		xcall.d		vec2f_sub		;//             vec2f_sub(&c, b2) |
	call.d	vec2f_sub@rl
		add		%r12, 16		;// <-----------------------------+					*delay*
		;//
		ld.w		%r12, %sp		;// %r12     :=             &a
;//		xadd		%r13, %sp, 8		;// %r13     :=                 &b -+
		ld.w		%r13, %sp		;// <-------------------------------+
	ext	vec2f_cross@rm	; 		xcall.d		vec2f_cross		;// %r10     := vec2f_cross(&a, &b) |
	call.d	vec2f_cross@rl
		add		%r13, 8			;// <-------------------------------+					*delay*
	ld.w	[%sp+0x7],%r10	; 		xld.w		[%sp+28], %r10		;// [%sp+28] := vec2f_cross(&a, &b)
		;//
		ld.w		%r12, %sp		;// %r12     :=             &a
;//		xadd		%r13, %sp, 16		;// %r13     :=                 &c -+
		ld.w		%r13, %sp		;// <-------------------------------+
	ext	vec2f_cross@rm	; 		xcall.d		vec2f_cross		;// %r10     := vec2f_cross(&a, &c) |
	call.d	vec2f_cross@rl
		add		%r13, 16		;// <-------------------------------+					*delay*
		;//
	ld.w	%r12,[%sp+0x7]	; 		xld.w		%r12, [%sp+28]		;// %r12     :=     vec2f_cross(&a, &b)
	ext	__divsf3@rm	; 		xcall.d		__divsf3		;// %r10     := f = vec2f_cross(&a, &b) / vec2f_cross(&a, &c)
	call.d	__divsf3@rl
		ld.w		%r13, %r10		;// %r13     :=                           vec2f_cross(&a, &c)		*delay*
		;//
	ld.w	[%sp+0x0],%r10	; 		xld.w		[%sp+0], %r10		;// [%sp+0]  := a.x = f
	ld.w	[%sp+0x1],%r10	; 		xld.w		[%sp+4], %r10		;// [%sp+4]  := a.y = f
		ld.w		%r12, %sp		;// %r12     :=           &a
;//		xadd		%r13, %sp, 16		;// %r13     :=               &c -+
		ld.w		%r13, %sp		;// <-----------------------------+
	ext	vec2f_mul@rm	; 		xcall.d		vec2f_mul		;//             vec2f_mul(&a, &c) |
	call.d	vec2f_mul@rl
		add		%r13, 16		;// <-----------------------------+					*delay*
		;//
		ld.w		%r12, %sp		;// %r12     :=           &a
	ld.w	%r13,[%sp+0x9]	; 		xld.w		%r13, [%sp+36]		;// %r13     :=               b2
	ext	vec2f_add@rm	; 		xcall		vec2f_add		;//             vec2f_add(&a, b2)
	call	vec2f_add@rl
		;//
	ld.w	%r10,[%sp+0x6]	; 		xld.w		%r10, [%sp+24]		;// %r10     := ߂li[B
	ld.w	%r4,[%sp+0x0]	; 		xld.w		%r4, [%sp+0]		;// %r4      := a.x
	ld.w	%r5,[%sp+0x1]	; 		xld.w		%r5, [%sp+4]		;// %r5      := a.y
		ld.w		[%r10]+, %r4		;// ߂l.x := a.x, %r10 := ߂li[B + 4
		ld.w		[%r10], %r5		;// ߂l.y := a.y
		;//
	add	%sp,0x8		; 		xadd		%sp, %sp, 32
		ret.d
		sub		%r10, 4			;// %r10     := ߂li[B (S1C33 ABIdlɂK{)	*delay*

	
		.code
		.align		1
		.global		vec2f_is_intersected_ls
vec2f_is_intersected_ls:
		pushn		%r3
		;//
		ld.w		%r0, %r12			;// %r0  := a1
		ld.w		%r1, %r13			;// %r1  := a2
		ld.w		%r2, %r14			;// %r2  := b1
;//		ld.w		%r3, %r15			;// %r3  := b2 ---------------------+
		call.d		vec2f_is_intersected_ls_SUB	;// %r10 := sign((v1~v2)*(v1~v3)) |
		ld.w		%r3, %r15			;// <-------------------------------+					*delay*
		jreq		vec2f_is_intersected_ls_RET	;// if(!sign) return sign
		;//
		ld.w		%r12, %r0
		ld.w		%r13, %r1
		ld.w		%r14, %r2
		ld.w		%r15, %r3
		ld.w		%r0, %r14			;// %r0  := b1
		ld.w		%r1, %r15			;// %r1  := b2
		ld.w		%r2, %r12			;// %r2  := a1
;//		ld.w		%r3, %r13			;// %r3  := a2 ---------------------+
		call.d		vec2f_is_intersected_ls_SUB	;// %r10 := sign((v1~v2)*(v1~v3)) |
		ld.w		%r3, %r13			;// <-------------------------------+					*delay*
		;//
vec2f_is_intersected_ls_RET:
		popn		%r3
		ret
		;//---------------------------------------------;//
vec2f_is_intersected_ls_SUB:
	sub	%sp,0x7		; 		xsub		%sp, %sp, 28
		;//
		ld.w		%r4, [%r0]			;// %r4      := a1->x
	ext	0x4		; 		xld.w		%r5, [%r0+4]			;// %r5      := a1->y
	ld.w	%r5,[%r0]
	ld.w	[%sp+0x0],%r4	; 		xld.w		[%sp+0], %r4			;// v1.x     := a1->x
	ld.w	[%sp+0x1],%r5	; 		xld.w		[%sp+4], %r5			;// v1.y     := a1->y
	ld.w	[%sp+0x2],%r4	; 		xld.w		[%sp+8], %r4			;// v2.x     := a1->x
	ld.w	[%sp+0x3],%r5	; 		xld.w		[%sp+12], %r5			;// v2.y     := a1->y
	ld.w	[%sp+0x4],%r4	; 		xld.w		[%sp+16], %r4			;// v3.x     := a1->x
	ld.w	[%sp+0x5],%r5	; 		xld.w		[%sp+20], %r5			;// v3.y     := a1->y
		;//
		ld.w		%r12, %sp			;// %r12     :=           &v1
	ext	vec2f_sub@rm	; 		xcall.d		vec2f_sub			;//             vec2f_sub(&v1, a2)
	call.d	vec2f_sub@rl
		ld.w		%r13, %r1			;// %r13     :=                a2					*delay*
		;//
	ld.w	%r12,%sp	; 		xadd		%r12, %sp, 8			;// %r12     :=           &v2
	add	%r12,0x8
	ext	vec2f_sub@rm	; 		xcall.d		vec2f_sub			;//             vec2f_sub(&v2, b1)
	call.d	vec2f_sub@rl
		ld.w		%r13, %r2			;// %r13     :=                b1					*delay*
		;//
	ld.w	%r12,%sp	; 		xadd		%r12, %sp, 16			;// %r12     :=           &v3
	add	%r12,0x10
	ext	vec2f_sub@rm	; 		xcall.d		vec2f_sub			;//             vec2f_sub(&v3, b2)
	call.d	vec2f_sub@rl
		ld.w		%r13, %r3			;// %r13     :=                b2					*delay*
		;//
		ld.w		%r12, %sp			;// %r12     :=             &v1
;//		xadd		%r13, %sp, 8			;// %r13     :=                  &v2 ---+
		ld.w		%r13, %sp			;// <-----------------------------------+
	ext	vec2f_cross@rm	; 		xcall.d		vec2f_cross			;// %r10     := vec2f_cross(&v1, &v2) --|-+
	call.d	vec2f_cross@rl
		add		%r13, 8				;// <-----------------------------------+ |				*delay*
	ld.w	[%sp+0x6],%r10	; 		xld.w		[%sp+24], %r10			;// [%sp+24] := vec2f_cross(&v1, &v2) <---+
		;//
		ld.w		%r12, %sp			;// %r12     :=             &v1
;//		xadd		%r13, %sp, 16			;// %r13     :=                  &v3 ---+
		ld.w		%r13, %sp			;// <-----------------------------------+
	ext	vec2f_cross@rm	; 		xcall.d		vec2f_cross			;// %r10     := vec2f_cross(&v1, &v3) --|-----------------------+
	call.d	vec2f_cross@rl
		add		%r13, 16			;// <-----------------------------------+                       |	*delay*
		;//						;//                                                             |
	ld.w	%r12,[%sp+0x6]	; 		xld.w		%r12, [%sp+24]			;// %r12     := vec2f_cross(&v1, &v2)                           |
	ext	__mulsf3@rm	; 		xcall.d		__mulsf3			;// %r10     := vec2f_cross(&v1, &v2) * vec2f_cross(&v1, &v3)   |
	call.d	__mulsf3@rl
		ld.w		%r13, %r10			;// %r13     :=                         vec2f_cross(&v1, &v3) <-+	*delay*
		;//
	add	%sp,0x7		; 		xadd		%sp, %sp, 28
		;//
		rl		%r10, 1				;// %r10     := eeeeeeee mmmmmmmm mmmmmmmm mmmmmmms
		ret.d
		and		%r10, 1				;// %r10     := 00000000 00000000 00000000 0000000s, %psr(Z) := !s	*delay*

	
		.code
		.align		1
		.global		vec2f_is_point_in_convex
vec2f_is_point_in_convex:
		pushn		%r3
	sub	%sp,0x4		; 		xsub		%sp, %sp, 16
		;//
		ld.w		%r0, %r12			;// %r0  := p
		ld.w		%r1, %r13			;// %r1  := v
		ld.w		%r2, %r14			;// %r2  := nv
		ld.w		%r3, 0				;// %r3  := f = 0.0f
		;//
		sub		%r14, 1				;// %r14 :=        (nv - 1)
		sla		%r14, 3				;// %r14 :=        (nv - 1) * sizeof(vec2f)
		add		%r13, %r14			;// %r13 :=      &v[nv - 1]
		ld.w		%r4, [%r13]+			;// %r4  := a.x = v[nv - 1].x
		ld.w		%r5, [%r13]			;// %r5  := a.y = v[nv - 1].y
		;//
vec2f_is_point_in_convex_LOOP:
	ld.w	[%sp+0x0],%r4	; 		xld.w		[%sp+0], %r4			;// b.x  := a.x
	ld.w	[%sp+0x1],%r5	; 		xld.w		[%sp+4], %r5			;// b.y  := a.y
	ld.w	[%sp+0x2],%r4	; 		xld.w		[%sp+8], %r4			;// c.x  := a.x
	ld.w	[%sp+0x3],%r5	; 		xld.w		[%sp+12], %r5			;// c.y  := a.y
		;//
		ld.w		%r12, %sp			;// %r12 :=           &b
	ext	vec2f_sub@rm	; 		xcall.d		vec2f_sub			;//         vec2f_sub(&b, p)
	call.d	vec2f_sub@rl
		ld.w		%r13, %r0			;// %r13 ;=               p			*delay*
		;//
	ld.w	%r12,%sp	; 		xadd		%r12, %sp, 8			;// %r12 :=           &c
	add	%r12,0x8
	ext	vec2f_sub@rm	; 		xcall.d		vec2f_sub			;//         vec2f_sub(&c, v)
	call.d	vec2f_sub@rl
		ld.w		%r13, %r1			;// %r13 :=               v			*delay*
		;//
		ld.w		%r12, %sp			;// %r12 :=                 &b
;//		xadd		%r13, %sp, 8			;// %r13 :=                     &c ---+
		ld.w		%r13, %sp			;// <---------------------------------+
	ext	vec2f_cross@rm	; 		xcall.d		vec2f_cross			;// %r10 := g = vec2f_cross(&b, &c) --|-+
	call.d	vec2f_cross@rl
		add		%r13, 8				;// <---------------------------------+ |	*delay*
		;//						;//                                     |
		cmp		%r10, 0				;// if(g) <-----------------------------+
		jreq		vec2f_is_point_in_convex_NEXT
		cmp		%r3, 0				;//   if(f)
		jreq		4
		 xor		%r3, %r10			;//     %r3  := (f ^ g)
		 cmp		%r3, 0				;//     if((f ^ g)[31]) return 0
		 jrlt		vec2f_is_point_in_convex_RET0
		ld.w		%r3, %r10			;//   %r3  := f = g
vec2f_is_point_in_convex_NEXT:
		ld.w		%r4, [%r1]+			;// %r4  := a.x = v->x
		ld.w		%r5, [%r1]+			;// %r5  := a.y = v->y, %r1  := v++
		sub		%r2, 1				;// %r2  := nv--
		jrne		vec2f_is_point_in_convex_LOOP
		;//
		ld.w		%r10, 1				;// return 1
	add	%sp,0x4		; 		xadd		%sp, %sp, 16			;// <-+
		popn		%r3				;//   |
		ret						;//   |
vec2f_is_point_in_convex_RET0:					;//   |
		jp.d		-3				;// --+
		ld.w		%r10, 0				;// return 0					*delay*

	
		.code
		.align		1
		.global		vec2f_is_point_in_concave
vec2f_is_point_in_concave:
		pushn		%r3
	sub	%sp,0x8		; 		xsub		%sp, %sp, 32
		;// %r12     := p
		;// %r13     := v
		;// %r14     := nv
		;//-----------------------------------------------------;
		ld.w		%r4, [%r12]+				;// %r4      := p->x
		ld.w		%r5, [%r12]				;// %r5      := p->y
	ld.w	[%sp+0x4],%r4	; 		xld.w		[%sp+16], %r4				;// [%sp+16] := p->x
	ld.w	[%sp+0x5],%r5	; 		xld.w		[%sp+20], %r5				;// [%sp+20] := p->y
	ld.w	[%sp+0x6],%r13	; 		xld.w		[%sp+24], %r13				;// [%sp+24] := v
	ld.w	[%sp+0x7],%r14	; 		xld.w		[%sp+28], %r14				;// [%sp+28] := nv
		;//
		ld.w		%r0, %r14				;// %r0      := i = nv
		ld.w		%r1, %r14				;// %r1      := j = nv
		ld.w		%r2, %r13				;// %r2      := vi = v
		ld.w		%r3, %r13				;// %r3      := vj = v
		ld.w		%r4, [%r3]+				;// %r4      := xmin = vj->x
		ld.w		%r5, %r4				;// %r5      := xmax = vj->x
		ld.w		%r6, [%r3]+				;// %r6      := ymin = vj->y, %r3  := vj++
		ld.w		%r7, %r6				;// %r7      := ymax = vj->y
		sub		%r1, 1					;// %r1      := j--
		;// %r0      := i
		;// %r1      := j
		;// %r2      := vi
		;// %r3      := vj
		;// %r4      := xmin
		;// %r5      := xmax
		;// %r6      := ymin
		;// %r7      := ymax
		;// [%sp+16] := p->x
		;// [%sp+20] := p->y
		;// [%sp+24] := v
		;// [%sp+28] := nv
vec2f_is_point_in_concave_LOOP1:
		ld.w		%r12, [%r3]				;// %r12     := vj->x
	ext	__fcmps@rm	; 		xcall.d		__fcmps					;// %psr     := vj->x - xmin
	call.d	__fcmps@rl
		ld.w		%r13, %r4				;// %r13     :=         xmin			*delay*
		jrge		2					;// if(vj->x < xmin)
		 ld.w		%r4, [%r3]				;//   %r4      := xmin = vj->x
		;//
		ld.w		%r12, [%r3]				;// %r12     := vj->x
	ext	__fcmps@rm	; 		xcall.d		__fcmps					;// %psr     := vj->x - xmax
	call.d	__fcmps@rl
		ld.w		%r13, %r5				;// %r13     :=         xmax			*delay*
		jrle		2					;// if(vj->x > xmax)
		 ld.w		%r5, [%r3]				;//   %r5      := xmax = vj->x
		;//
		add		%r3, 4					;// %r3      := &vj->y
		;//
		ld.w		%r12, [%r3]				;// %r12     := vj->y
	ext	__fcmps@rm	; 		xcall.d		__fcmps					;// %psr     := vj->y - ymin
	call.d	__fcmps@rl
		ld.w		%r13, %r6				;// %r13     :=         ymin			*delay*
		jrge		5					;// if(vj->y < ymin)
		 ld.w		%r6, [%r3]				;//   %r6      := ymin = vj->y
		 ld.w		%r0, %r1				;//   %r0      := i = j
		 ld.w		%r2, %r3				;//   %r2      :=      &vj->y
		 sub		%r2, 4					;//   %r2      := vi = &vj->x
		;//
		ld.w		%r12, [%r3]				;// %r12     := vj->y
	ext	__fcmps@rm	; 		xcall.d		__fcmps					;// %psr     := vj->y - ymax
	call.d	__fcmps@rl
		ld.w		%r13, %r7				;// %r13     :=         ymax			*delay*
		jrle		2					;// if(vj->y > ymax)
		 ld.w		%r7, [%r3]				;//   %r7      := ymax = vj->y
		;//
		sub		%r1, 1					;// %r1      := j--
		jrne.d		vec2f_is_point_in_concave_LOOP1
		add		%r3, 4					;// %r3      := &(vj + 1)->x			*delay*
		;//
	ld.w	%r12,[%sp+0x4]	; 		xld.w		%r12, [%sp+16]				;// %r12     := p->x
	ext	__fcmps@rm	; 		xcall.d		__fcmps					;// %psr     := p->x - xmin
	call.d	__fcmps@rl
		ld.w		%r13, %r4				;// %r13     :=        xmin			*delay*
		jrlt		vec2f_is_point_in_concave_RET0		;// if(p->x < xmin) return 0
		;//
	ld.w	%r12,[%sp+0x4]	; 		xld.w		%r12, [%sp+16]				;// %r12     := p->x
	ext	__fcmps@rm	; 		xcall.d		__fcmps					;// %psr     := p->x - xmax
	call.d	__fcmps@rl
		ld.w		%r13, %r5				;// %r13     :=        xmax			*delay*
		jrgt		vec2f_is_point_in_concave_RET0		;// if(p->x > xmax) return 0
		;//
	ld.w	%r12,[%sp+0x5]	; 		xld.w		%r12, [%sp+20]				;// %r12     := p->y
	ext	__fcmps@rm	; 		xcall.d		__fcmps					;// %psr     := p->y - ymin
	call.d	__fcmps@rl
		ld.w		%r13, %r6				;// %r13     :=        ymin			*delay*
		jrlt		vec2f_is_point_in_concave_RET0		;// if(p->y < ymin) return 0
		;//
	ld.w	%r12,[%sp+0x5]	; 		xld.w		%r12, [%sp+20]				;// %r12     := p->y
	ext	__fcmps@rm	; 		xcall.d		__fcmps					;// %psr     := p->y - ymax
	call.d	__fcmps@rl
		ld.w		%r13, %r7				;// %r13     :=        ymax			*delay*
		jrgt		vec2f_is_point_in_concave_RET0		;// if(p->y > ymax) return 0
		;// %r0      := i
		;// %r2      := vi
		;// [%sp+16] := p->x
		;// [%sp+20] := p->y
		;// [%sp+24] := v
		;// [%sp+28] := nv
		;//-----------------------------------------------------;
	ld.w	%r1,[%sp+0x7]	; 		xld.w		%r1, [%sp+28]				;// %r1      := j = nv
		ld.w		%r3, 0					;// %r3      := prev = 0.0f
	ld.w	[%sp+0x7],%r3	; 		xld.w		[%sp+28], %r3				;// [%sp+28] := n = 0
		;// %r0      := i
		;// %r1      := j
		;// %r2      := vi
		;// %r3      := prev
		;// [%sp+16] := p->x
		;// [%sp+20] := p->y
		;// [%sp+24] := v
		;// [%sp+28] := n
vec2f_is_point_in_concave_LOOP2:
		ld.w		%r4, [%r2]+				;// %r4      := vi->x
		ld.w		%r5, [%r2]+				;// %r5      := vi->y, %r2  := vi++
	ld.w	[%sp+0x0],%r4	; 		xld.w		[%sp+0], %r4				;// [%sp+0]  := v0.x = vi->x
	ld.w	[%sp+0x1],%r5	; 		xld.w		[%sp+4], %r5				;// [%sp+4]  := v0.y = vi->y
	ld.w	[%sp+0x2],%r4	; 		xld.w		[%sp+8], %r4				;// [%sp+8]  := v1.x = vi->x
	ld.w	[%sp+0x3],%r5	; 		xld.w		[%sp+12], %r5				;// [%sp+12] := v1.y = vi->y
		;// %r0      := i
		;// %r1      := j
		;// %r2      := vi
		;// %r3      := prev
		;// [%sp+0]  := v0.x
		;// [%sp+4]  := v0.y
		;// [%sp+8]  := v1.x
		;// [%sp+12] := v1.y
		;// [%sp+16] := p->x
		;// [%sp+20] := p->y
		;// [%sp+24] := v
		;// [%sp+28] := n
		sub		%r0, 1					;// %r0      := i--
		jrne		2					;// if(!i)
	ld.w	%r2,[%sp+0x6]	; 		 xld.w		%r2, [%sp+24]				;//   %r2      := vi = v
		;//
		ld.w		%r12, %sp				;// %r12     :=           &v0
;//		xadd		%r13, %sp, 16				;// %r13     :=                p --+
		ld.w		%r13, %sp				;// <------------------------------+
	ext	vec2f_sub@rm	; 		xcall.d		vec2f_sub				;//             vec2f_sub(&v0, p)  |
	call.d	vec2f_sub@rl
		add		%r13, 16				;// <------------------------------+		*delay*
		;//
	ld.w	%r12,%sp	; 		xadd		%r12, %sp, 8				;// %r12     :=           &v1
	add	%r12,0x8
	ext	vec2f_sub@rm	; 		xcall.d		vec2f_sub				;//             vec2f_sub(&v1, vi)
	call.d	vec2f_sub@rl
		ld.w		%r13, %r2				;// %r13     :=                vi		*delay*
		;//
		ld.w		%r12, %sp				;// %r12     :=                 &v0
;//		xadd		%r13, %sp, 8				;// %r13     :=                      &vi --+
		ld.w		%r13, %sp				;// <--------------------------------------+
	ext	vec2f_cross@rm	; 		xcall.d		vec2f_cross				;// %r10     := f = vec2f_cross(&v0, &v1)  |
	call.d	vec2f_cross@rl
		add		%r13, 8					;// <--------------------------------------+	*delay*
		;//- - - - - - - - - - - - - - - - - - - - - - - - - - -;
		cmp		%r10, 0					;// %psr     := f - 0.0f
		jrne.d		vec2f_is_point_in_concave_NOT_ON_LS	;// if(!f)
		ld.w		%r4, %psr				;// %r4      := f - 0.0f ------------------+	*delay*
	ld.w	%r12,[%sp+0x0]	; 		xld.w		%r12, [%sp+0]				;//   %r12     := v0.x			   |
	ld.w	%r13,[%sp+0x2]	; 		xld.w		%r13, [%sp+8]				;//   %r13     := v1.x			   |
		cmp		%r12, 0					;//   if(v0.x)				   |
		jreq		vec2f_is_point_in_concave_X_ON_LS	;//					   |
		jrgt		vec2f_is_point_in_concave_V0X_GT_0	;//     if(v0.x < 0.0f)			   |
	ext	__fcmps@rm	; 		xcall		__fcmps					;//       %psr     := v0.x - v1.x	   |
	call	__fcmps@rl
		jrlt		vec2f_is_point_in_concave_NOT_ON_LS	;//       if(v0.x < v1.x) goto NOT_ON_LS   |
		jp		vec2f_is_point_in_concave_X_ON_LS	;//					   |
vec2f_is_point_in_concave_V0X_GT_0:					;//					   |
	ext	__fcmps@rm	; 		xcall		__fcmps					;//       %psr     := v0.x - v1.x	   |
	call	__fcmps@rl
		jrgt		vec2f_is_point_in_concave_NOT_ON_LS	;//       if(v0.x > v1.x) goto NOT_ON_LS   |
vec2f_is_point_in_concave_X_ON_LS:					;//					   |
	ld.w	%r12,[%sp+0x1]	; 		xld.w		%r12, [%sp+4]				;//   %r12     := v0.y			   |
	ld.w	%r13,[%sp+0x3]	; 		xld.w		%r13, [%sp+12]				;//   %r13     := v1.y			   |
		cmp		%r12, 0					;//   if(v0.y)				   |
		jreq		vec2f_is_point_in_concave_RET1		;//					   |
		jrgt		vec2f_is_point_in_concave_V0Y_GT_0	;//     if(v0.y < 0.0f)			   |
	ext	__fcmps@rm	; 		xcall		__fcmps					;//       %psr     := v0.y - v1.y	   |
	call	__fcmps@rl
		jrlt		vec2f_is_point_in_concave_NOT_ON_LS	;//       if(v0.y < v1.y) goto NOT_ON_LS   |
		jp		vec2f_is_point_in_concave_RET1		;//					   |
vec2f_is_point_in_concave_V0Y_GT_0:					;//					   |
	ext	__fcmps@rm	; 		xcall		__fcmps					;//       %psr     := v0.y - v1.y	   |
	call	__fcmps@rl
		jrgt		vec2f_is_point_in_concave_NOT_ON_LS	;//       if(v0.y > v1.y) goto NOT_ON_LS   |
		jp		vec2f_is_point_in_concave_RET1		;//   return 1				   |
vec2f_is_point_in_concave_NOT_ON_LS:					;//					   |
		;//- - - - - - - - - - - - - - - - - - - - - - - - - - -;//					   |
	ld.w	%r12,[%sp+0x3]	; 		xld.w		%r12, [%sp+12]				;// %r12     := v1.y -------------------+  |
	ld.w	%r13,[%sp+0x1]	; 		xld.w		%r13, [%sp+4]				;// %r13     := v0.y -------------------+  |
		cmp		%r12, 0					;// if(v1.y)				|  |
		jreq		vec2f_is_point_in_concave_NEXT		;//					|  |
		jrgt.d		vec2f_is_point_in_concave_V1Y_GT_0	;//					|  |
		ld.w		%psr, %r4				;//   %psr     := f - 0.0f -------------|--+	*delay*
		;//							;//					|  |
;//vec2f_is_point_in_concave_V1Y_LT_0:					;//   if(v1.y < 0.0f)			|  |
		jrge		vec2f_is_point_in_concave_PREV_V1Y	;//     if((f < 0.0f) <-----------------|--+
	ext	__fcmps@rm	; 		xcall		__fcmps					;//     %psr     := v1.y - v0.y <-------+  |
	call	__fcmps@rl
		jrgt		vec2f_is_point_in_concave_PREV_V1Y	;//     && (v1.y <= v0.y))		|  |
		;//							;//					|  |
		cmp		%r3, 0					;//       %psr     := prev - 0.0f	|  |
	ld.w	%r4,[%sp+0x1]	; 		xld.w		%r4, [%sp+4]				;//       %r4      := v0.y		|  |
		jrge.d		4					;//       if(prev < 0.0f)		|  |
		cmp		%r4, 0					;//       %psr     := v0.y - 0.0f	|  |	*delay*
		 jrge		vec2f_is_point_in_concave_PREV_V1Y	;//         if(v0.y < 0.0f)		|  |
		 jp		vec2f_is_point_in_concave_N_INC		;//           n++			|  |
		jrgt		vec2f_is_point_in_concave_PREV_V1Y	;//         if(v0.y <= 0.0f)		|  |
		jp		vec2f_is_point_in_concave_N_INC		;//           n++			|  |
		;//							;//					|  |
vec2f_is_point_in_concave_V1Y_GT_0:					;//   else /* if(v1.y > 0.0f) */	|  |
		jrle		vec2f_is_point_in_concave_PREV_V1Y	;//     if((f > 0.0f) <-----------------|--+
	ext	__fcmps@rm	; 		xcall		__fcmps					;//     %psr     := v1.y - v0.y <-------+
	call	__fcmps@rl
		jrlt		vec2f_is_point_in_concave_PREV_V1Y	;//     && (v1.y >= v0.y))
		;//
		cmp		%r3, 0					;//       %psr     := prev - 0.0f
	ld.w	%r4,[%sp+0x1]	; 		xld.w		%r4, [%sp+4]				;//       %r4      := v0.y
		jrle.d		4					;//       if(prev > 0.0f)
		cmp		%r4, 0					;//       %psr     := v0.y - 0.0f		*delay*
		 jrle		vec2f_is_point_in_concave_PREV_V1Y	;//         if(v0.y > 0.0f)
		 jp		vec2f_is_point_in_concave_N_INC		;//           n++
		jrlt		vec2f_is_point_in_concave_PREV_V1Y	;//         if(v0.y >= 0.0f)
;//		jp		vec2f_is_point_in_concave_N_INC		;//           n++
		;//
vec2f_is_point_in_concave_N_INC:
	ld.w	%r4,[%sp+0x7]	; 		xld.w		%r4, [%sp+28]				;//           %r4      := n
		add		%r4, 1					;//           %r4      := n++
	ld.w	[%sp+0x7],%r4	; 		xld.w		[%sp+28], %r4				;//           [%sp+28] := n
		;//
vec2f_is_point_in_concave_PREV_V1Y:
	ld.w	%r3,[%sp+0x3]	; 		xld.w		%r3, [%sp+12]				;//   %r3      := prev = v1.y
		;// %r0      := i
		;// %r1      := j
		;// %r2      := vi
		;// %r3      := prev
		;// [%sp+16] := p->x
		;// [%sp+20] := p->y
		;// [%sp+24] := v
		;// [%sp+28] := n
vec2f_is_point_in_concave_NEXT:
		sub		%r1, 1					;// %r1      := j--
		jrne		vec2f_is_point_in_concave_LOOP2
		;//-----------------------------------------------------;
	ld.w	%r10,[%sp+0x7]	; 		xld.w		%r10, [%sp+28]				;// %r10     := n
vec2f_is_point_in_concave_RET:
	add	%sp,0x8		; 		xadd		%sp, %sp, 32
		popn		%r3
		ret.d
		and		%r10, 1					;// %r10     := n & 1				*delay*
vec2f_is_point_in_concave_RET0:
		jp.d		vec2f_is_point_in_concave_RET
		ld.w		%r10, 0					;// %r10     := n = 0				*delay*
vec2f_is_point_in_concave_RET1:
		jp.d		vec2f_is_point_in_concave_RET
		ld.w		%r10, 1					;// %r10     := n = 1				*delay*

	
		.code
		.align		1
		.global		vec2f_is_intersected_p
vec2f_is_intersected_p:
		pushn		%r3
	sub	%sp,0x8		; 		xsub		%sp, %sp, 32
		;//
	ld.w	[%sp+0x0],%r12	; 		xld.w		[%sp+0], %r12				;// [%sp+0]  := a
	ld.w	[%sp+0x1],%r13	; 		xld.w		[%sp+4], %r13				;// [%sp+4]  := na
	ld.w	[%sp+0x2],%r14	; 		xld.w		[%sp+8], %r14				;// [%sp+8]  := b
	ld.w	[%sp+0x3],%r15	; 		xld.w		[%sp+12], %r15				;// [%sp+12] := nb
		;// %r12     := a
		;// %r13     := na
		;// [%sp+0]  := a
		;// [%sp+4]  := na
		;// [%sp+8]  := b
		;// [%sp+12] := nb
		;//-----------------------------------------------------;
		ld.w		%r0, %r12				;// %r0      := a1 = a
		ld.w		%r1, %r13				;// %r1      := ia = na
		ld.w		%r4, [%r0]+				;// %r4      := axmin = a1->x
		ld.w		%r5, %r4				;// %r5      := axmax = a1->x
		ld.w		%r6, [%r0]+				;// %r6      := aymin = a1->y, %r0  := a1++
		ld.w		%r7, %r6				;// %r7      := aymax = a1->y
		sub		%r1, 1					;// %r1      := ia--
		;// %r0      := a1
		;// %r1      := ia
		;// %r4      := axmin
		;// %r5      := axmax
		;// %r6      := aymin
		;// %r7      := aymax
		;// [%sp+0]  := a
		;// [%sp+4]  := na
		;// [%sp+8]  := b
		;// [%sp+12] := nb
vec2f_is_intersected_p_LOOP1A:
		ld.w		%r12, [%r0]				;// %r12     := a1->x
	ext	__fcmps@rm	; 		xcall.d		__fcmps					;// %psr     := a1->x - axmin
	call.d	__fcmps@rl
		ld.w		%r13, %r4				;// %r13     :=         axmin			*delay*
		jrge		2					;// if(a1->x < axmin)
		 ld.w		%r4, [%r0]				;//   %r4      := axmin = a1->x
		;//
		ld.w		%r12, [%r0]				;// %r12     := a1->x
	ext	__fcmps@rm	; 		xcall.d		__fcmps					;// %psr     := a1->x - axmax
	call.d	__fcmps@rl
		ld.w		%r13, %r5				;// %r13     :=         axmax			*delay*
		jrle		2					;// if(a1->x > axmax)
		 ld.w		%r5, [%r0]				;//   %r5      := axmax = a1->x
		;//
		add		%r0, 4					;// %r0      := &a1->y
		;//
		ld.w		%r12, [%r0]				;// %r12     := a1->y
	ext	__fcmps@rm	; 		xcall.d		__fcmps					;// %psr     := a1->y - aymax
	call.d	__fcmps@rl
		ld.w		%r13, %r6				;// %r13     :=         aymax			*delay*
		jrge		2					;// if(a1->y < aymax)
		 ld.w		%r6, [%r0]				;//   %r6      := aymax = a1->y
		;//
		ld.w		%r12, [%r0]				;// %r12     := a1->y
	ext	__fcmps@rm	; 		xcall.d		__fcmps					;// %psr     := a1->y - aymax
	call.d	__fcmps@rl
		ld.w		%r13, %r7				;// %r13     :=         aymax			*delay*
		jrle		2					;// if(a1->y > aymax)
		 ld.w		%r7, [%r0]				;//   %r7      := aymax = a1->y
		;//
		sub		%r1, 1					;// %r1      := ia--
		jrne.d		vec2f_is_intersected_p_LOOP1A
		add		%r0, 4					;// %r0      := &(a1 + 1)->x			*delay*
		;// %r0      := a1 = &a[na]
		;// %r4      := axmin
		;// %r5      := axmax
		;// %r6      := aymin
		;// %r7      := aymax
		;// [%sp+0]  := a
		;// [%sp+4]  := na
		;// [%sp+8]  := b
		;// [%sp+12] := nb
		;//- - - - - - - - - - - - - - - - - - - - - - - - - - -;
	ld.w	[%sp+0x4],%r4	; 		xld.w		[%sp+16], %r4				;// [%sp+16] := axmin
	ld.w	[%sp+0x5],%r5	; 		xld.w		[%sp+20], %r5				;// [%sp+20] := axmax
	ld.w	[%sp+0x6],%r6	; 		xld.w		[%sp+24], %r6				;// [%sp+24] := aymin
	ld.w	[%sp+0x7],%r7	; 		xld.w		[%sp+28], %r7				;// [%sp+28] := aymax
		;// %r0      := a1 = &a[na]
		;// [%sp+0]  := a
		;// [%sp+4]  := na
		;// [%sp+8]  := b
		;// [%sp+12] := nb
		;// [%sp+16] := axmin
		;// [%sp+20] := axmax
		;// [%sp+24] := aymin
		;// [%sp+28] := aymax
		;//- - - - - - - - - - - - - - - - - - - - - - - - - - -;
	ld.w	%r2,[%sp+0x2]	; 		xld.w		%r2, [%sp+8]				;// %r2      := b1 = b
	ld.w	%r3,[%sp+0x3]	; 		xld.w		%r3, [%sp+12]				;// %r3      := ib = nb
		ld.w		%r4, [%r2]+				;// %r4      := bxmin = b1->x
		ld.w		%r5, %r4				;// %r5      := bxmax = b1->x
		ld.w		%r6, [%r2]+				;// %r6      := bymin = b1->y, %r2  := b1++
		ld.w		%r7, %r6				;// %r7      := bymax = b1->y
		sub		%r3, 1					;// %r3      := ib--
		;// %r0      := a1 = &a[na]
		;// %r2      := b1
		;// %r3      := ib
		;// %r4      := bxmin
		;// %r5      := bxmax
		;// %r6      := bymin
		;// %r7      := bymax
		;// [%sp+0]  := a
		;// [%sp+4]  := na
		;// [%sp+8]  := b
		;// [%sp+12] := nb
		;// [%sp+16] := axmin
		;// [%sp+20] := axmax
		;// [%sp+24] := aymin
		;// [%sp+28] := aymax
vec2f_is_intersected_p_LOOP1B:
		ld.w		%r12, [%r2]				;// %r12     := b1->x
	ext	__fcmps@rm	; 		xcall.d		__fcmps					;// %psr     := b1->x - bxmin
	call.d	__fcmps@rl
		ld.w		%r13, %r4				;// %r13     :=         bxmin			*delay*
		jrge		2					;// if(b1->x < bxmin)
		 ld.w		%r4, [%r2]				;//   %r4      := bxmin = b1->x
		;//
		ld.w		%r12, [%r2]				;// %r12     := b1->x
	ext	__fcmps@rm	; 		xcall.d		__fcmps					;// %psr     := b1->x - bxmax
	call.d	__fcmps@rl
		ld.w		%r13, %r5				;// %r13     :=         bxmax			*delay*
		jrle		2					;// if(b1->x > bxmax)
		 ld.w		%r5, [%r2]				;//   %r5      := bxmax = b1->x
		;//
		add		%r2, 4					;// %r2      := &b1->y
		;//
		ld.w		%r12, [%r2]				;// %r12     := b1->y
	ext	__fcmps@rm	; 		xcall.d		__fcmps					;// %psr     := b1->y - bymax
	call.d	__fcmps@rl
		ld.w		%r13, %r6				;// %r13     :=         bymax			*delay*
		jrge		2					;// if(b1->y < bymax)
		 ld.w		%r6, [%r2]				;//   %r6      := bymax = b1->y
		;//
		ld.w		%r12, [%r2]				;// %r12     := b1->y
	ext	__fcmps@rm	; 		xcall.d		__fcmps					;// %psr     := b1->y - bymax
	call.d	__fcmps@rl
		ld.w		%r13, %r7				;// %r13     :=         bymax			*delay*
		jrle		2					;// if(b1->y > bymax)
		 ld.w		%r7, [%r2]				;//   %r7      := bymax = b1->y
		;//
		sub		%r3, 1					;// %r3      := ib--
		jrne.d		vec2f_is_intersected_p_LOOP1B
		add		%r2, 4					;// %r2      := &(b1 + 1)->x			*delay*
		;// %r0      := a1 = &a[na]
		;// %r2      := b1 = &b[nb]
		;// %r4      := bxmin
		;// %r5      := bxmax
		;// %r6      := bymin
		;// %r7      := bymax
		;// [%sp+0]  := a
		;// [%sp+4]  := na
		;// [%sp+8]  := b
		;// [%sp+12] := nb
		;// [%sp+16] := axmin
		;// [%sp+20] := axmax
		;// [%sp+24] := aymin
		;// [%sp+28] := aymax
		;//- - - - - - - - - - - - - - - - - - - - - - - - - - -;
	ld.w	%r12,[%sp+0x4]	; 		xld.w		%r12, [%sp+16]				;// %r12     := axmin
	ext	__fcmps@rm	; 		xcall.d		__fcmps					;// %psr     := axmin - bxmax
	call.d	__fcmps@rl
		ld.w		%r13, %r5				;// %r13     :=         bxmax			*delay*
		jrgt		vec2f_is_intersected_p_RET0		;// if(axmin > bxmax) return 0
		;//
	ld.w	%r12,[%sp+0x5]	; 		xld.w		%r12, [%sp+20]				;// %r12     := axmax
	ext	__fcmps@rm	; 		xcall.d		__fcmps					;// %psr     := axmax - bxmin
	call.d	__fcmps@rl
		ld.w		%r13, %r4				;// %r13     :=         bxmin			*delay*
		jrlt		vec2f_is_intersected_p_RET0		;// if(axmax < bxmin) return 0
		;//
	ld.w	%r12,[%sp+0x6]	; 		xld.w		%r12, [%sp+24]				;// %r12     := aymin
	ext	__fcmps@rm	; 		xcall.d		__fcmps					;// %psr     := aymin - bymax
	call.d	__fcmps@rl
		ld.w		%r13, %r7				;// %r13     :=         bymax			*delay*
		jrgt		vec2f_is_intersected_p_RET0		;// if(aymin > bymax) return 0
		;//
	ld.w	%r12,[%sp+0x7]	; 		xld.w		%r12, [%sp+28]				;// %r12     := aymax
	ext	__fcmps@rm	; 		xcall.d		__fcmps					;// %psr     := aymax - bymin
	call.d	__fcmps@rl
		ld.w		%r13, %r6				;// %r13     :=         bymin			*delay*
		jrlt		vec2f_is_intersected_p_RET0		;// if(aymax < bymin) return 0
		;// %r0      := a1 = &a[na]
		;// %r2      := b1 = &b[nb]
		;// [%sp+0]  := a
		;// [%sp+4]  := na
		;// [%sp+8]  := b
		;// [%sp+12] := nb
		;//-----------------------------------------------------;
		sub		%r0, 8					;// %r0      := a1-- = &a[na - 1]
	ld.w	[%sp+0x4],%r0	; 		xld.w		[%sp+16], %r0				;// [%sp+16] := a1
		sub		%r2, 8					;// %r2      := b1-- = &b[nb - 1]
	ld.w	[%sp+0x5],%r2	; 		xld.w		[%sp+20], %r2				;// [%sp+20] := b1
		;//
	ld.w	%r0,[%sp+0x0]	; 		xld.w		%r0, [%sp+0]				;// %r0      := a2 = a
	ld.w	%r1,[%sp+0x1]	; 		xld.w		%r1, [%sp+4]				;// %r1      := ia = na
		;// %r0      := a2
		;// %r1      := ia
		;// [%sp+0]  := a
		;// [%sp+4]  := na
		;// [%sp+8]  := b
		;// [%sp+12] := nb
		;// [%sp+16] := a1
		;// [%sp+20] := b1
vec2f_is_intersected_p_LOOP2A:
		;//- - - - - - - - - - - - - - - - - - - - - - - - - - -;
	ld.w	%r2,[%sp+0x2]	; 		xld.w		%r2, [%sp+8]				;// %r2      := b2 = b
	ld.w	%r3,[%sp+0x3]	; 		xld.w		%r3, [%sp+12]				;// %r3      := ib = nb
		;// %r0      := a2
		;// %r1      := ia
		;// %r2      := b2
		;// %r3      := ib
		;// [%sp+0]  := a
		;// [%sp+4]  := na
		;// [%sp+8]  := b
		;// [%sp+12] := nb
		;// [%sp+16] := a1
		;// [%sp+20] := b1
vec2f_is_intersected_p_LOOP2B:
	ld.w	%r12,[%sp+0x4]	; 		xld.w		%r12, [%sp+16]				;// %r12     :=                         a1
		ld.w		%r13, %r0				;// %r13     :=                             a2
	ld.w	%r14,[%sp+0x5]	; 		xld.w		%r14, [%sp+20]				;// %r14     :=                                 b1
	ext	vec2f_is_intersected_ls@rm	; 		xcall.d		vec2f_is_intersected_ls			;// %r10     := vec2f_is_intersected_ls(a1, a2, b1, b2)
	call.d	vec2f_is_intersected_ls@rl
		ld.w		%r15, %r2				;// %r15     :=                                     b2		*delay*
		cmp		%r10, 0					;// if(vec2f_is_intersected_ls(a1, a2, b1, b2))
		jrne		vec2f_is_intersected_p_RET		;//   return 1
		;//
	ld.w	[%sp+0x5],%r2	; 		xld.w		[%sp+20], %r2				;// [%sp+b1] := b1 = b2
		sub		%r3, 1					;// %r3      := ib--
		jrne.d		vec2f_is_intersected_p_LOOP2B
		add		%r2, 8					;// %r2      := b2++						*delay*
		;//- - - - - - - - - - - - - - - - - - - - - - - - - - -;
	ld.w	[%sp+0x4],%r0	; 		xld.w		[%sp+16], %r0				;// [%sp+a1] := a1 = a2
		sub		%r1, 1					;// %r1      := ia--
		jrne.d		vec2f_is_intersected_p_LOOP2A
		add		%r0, 8					;// %r0      := a2++						*delay*
		;// [%sp+0]  := a
		;// [%sp+4]  := na
		;// [%sp+8]  := b
		;// [%sp+12] := nb
		;//-----------------------------------------------------;
	ld.w	%r12,[%sp+0x0]	; 		xld.w		%r12, [%sp+0]				;// %r12    :=                           a
	ld.w	%r13,[%sp+0x2]	; 		xld.w		%r13, [%sp+8]				;// %r13    :=                              b
	ld.w	%r14,[%sp+0x3]	; 		xld.w		%r14, [%sp+12]				;// %r14    :=                                 nb
	ext	vec2f_is_point_in_concave@rm	; 		xcall		vec2f_is_point_in_concave		;// %r10    := vec2f_is_point_in_concave(a, b, nb)
	call	vec2f_is_point_in_concave@rl
		cmp		%r10, 0					;// if(vec2f_is_point_in_concave(a, b, nb))
		jrne		vec2f_is_intersected_p_RET		;//   return 1
		;//
	ld.w	%r12,[%sp+0x2]	; 		xld.w		%r12, [%sp+8]				;// %r12    :=                           b
	ld.w	%r13,[%sp+0x0]	; 		xld.w		%r13, [%sp+0]				;// %r13    :=                              a
	ld.w	%r14,[%sp+0x1]	; 		xld.w		%r14, [%sp+4]				;// %r14    :=                                 na
	ext	vec2f_is_point_in_concave@rm	; 		xcall		vec2f_is_point_in_concave		;// %r10    := vec2f_is_point_in_concave(b, a, na)
	call	vec2f_is_point_in_concave@rl
vec2f_is_intersected_p_RET:
	add	%sp,0x8		; 		xadd		%sp, %sp, 32
		popn		%r3
		ret
vec2f_is_intersected_p_RET0:
		jp.d		vec2f_is_intersected_p_RET
		ld.w		%r10, 0					;// %r10    := 0						*delay*

