/*	
 *	clippsg.h
 *
 *	P/ECE PSG(AY-3-8910) Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2003 Naoyuki Sawa
 *
 *	* Sat Nov 22 06:00:00 JST 2003 Naoyuki Sawa
 *	- 쐬JnB
 */
#ifndef __CLIP_PSG_H__
#define __CLIP_PSG_H__

/****************************************************************************
 *
 ****************************************************************************/

#define PSGBUFLEN 320 /* = 16000/50 c 1[tick](=1/50[sec])̃Tv */

/*
 *	PSGRA
 */
typedef struct _PSG {
	unsigned char reg[16];		/* + 0,16: WX^Zbg */
	int regno;			/* +16, 4: WX^I */
	int clock;			/* +20, 4: ̓NbN[Hz] */
	/* g[ */
	int tone_progress[3/*CH*/];	/* +24,12: g[g`isJE^ */
	int tone_dda_d[3/*CH*/];	/* +36,12: g[DDA[ */
	/* mCY */
	int noise_progress;		/* +48, 4: mCYg`isJE^ */
	int noise_dda_d;		/* +52, 4: mCYDDA[ */
	/* Gx[v */
	int envelope_progress;		/* +56, 4: Gx[visJE^ */
	int envelope_dda_d;		/* +60, 4: Gx[vDDA[ */
} PSG;					/* =64 */

/*
 *	PSGWX^̉(gp)
 */
typedef struct _PSGCHANNEL {
	unsigned short tone_noise_enable;	/* + 0, 2 (bit0:tone/bit1:noise) */
	unsigned short amplitude_mode;		/* + 2, 2 */
	unsigned short amplitude_level;		/* + 4, 2 */
	unsigned short tone_period;		/* + 6, 2 */
} PSGCHANNEL;					/* = 8    */
typedef struct _PSGINFO {
	PSGCHANNEL channel[3];			/* + 0,24 */
	unsigned short noise_period;		/* +24, 2 */
	unsigned short envelope_period;		/* +26, 2 */
	unsigned short envelope_shape_cycle;	/* +28, 2 */
	unsigned short _reserved;		/* +30, 2 */
} PSGINFO;					/* +32    */

/****************************************************************************
 *
 ****************************************************************************/

extern const char psg_noise_table[256];	/* mCYWFl[^e[u */

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* PSGRAZbg܂B
 * [in]
 *	psg		PSG\́B
 *	clock		̓NbNB
 * [note]
 *	* AvP[VvÓAȂƂŏɈxÅ֐ĂяoĂB
 *	  ̌́APSGZbgsꍇɁAKvɉČĂяoĂB
 */
void psg_reset(PSG* psg, int clock);

/* ̓ǂݏWX^I܂B
 * [in]
 *	psg		PSG\́B
 *	regno		WX^ԍB(0`15)
 */
void psg_reg(PSG* psg, unsigned char regno);

/* WX^lǂݍ݂܂B
 * [in]
 *	psg		PSG\́B
 * [out]
 *	߂l		WX^lB
 * [note]
 *	* ǂݍރWX^ԍ́A炩psg_reg()ɂĐݒ肵ĂĂB
 */
unsigned char psg_read(PSG* psg);

/* WX^l݂܂B
 * [in]
 *	psg		PSG\́B
 *	data		WX^lB
 * [note]
 *	* ރWX^ԍ́A炩psg_reg()ɂĐݒ肵ĂĂB
 */
void psg_write(PSG* psg, unsigned char data);

/* 1/50b̃~LVOs܂B
 * [in]
 *	psg		PSG\́B
 *	wbuff		o̓Tvobt@B
 */
void psg_mix(PSG* psg, short wbuff[/*PSGBUFLEN*/]);

#endif /*__CLIP_PSG_H__*/
