/*
 *	ptenshi - main.c
 *
 *	uVĝȂ12(DVD)vPGDRo[^
 *	Copyright (C) 2003 Naoyuki Sawa
 *
 *	* Fri Oct 3 00:00:00 JST 2003 Naoyuki Sawa
 *	- 쐬JnB
 */
#define STRICT
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <assert.h>

/****************************************************************************
 *	}NE萔
 ****************************************************************************/

#define VERSION		"20031004"

#define REG_KEY		"Software\\Leaf\\VĝȂPQ(DVD)"
#define REG_VALUE	"InstallDir"

#define ORIGINAL_WIDTH	800

/********** A[JCu` **********/
/* t@C ".a" */

#define ARC_SIG		0xaf1e
typedef struct _ARC_HEAD {
	unsigned short sig;	/* VOl` */
	unsigned short cnt;	/* t@C */
} ARC_HEAD;

typedef struct _ARC_FILE {
	char fname[23];		/* t@C */
	unsigned char type;	/* kEÍ^Cv */
	int len;		/* t@CTCY */
	int ofs;		/* t@Ce[uォ̃ItZbg */
} ARC_FILE;

/* Ǘp */
typedef struct _ARC {
	FILE* fp;		/* t@C|C^ */
	int cnt;		/* t@C */
	ARC_FILE* file;		/* t@Ce[u */
} ARC;

/********** wi摜` **********/
/* egbg.at@C "*.px" */

typedef struct _BG_HEAD {
	int w;			/*   [sNZ] */
	int h;			/* [sNZ] */
	int unk2;
	int unk3;
	int unk4;
	int unk5;
	int unk6;
	int unk7;
} BG_HEAD;

/********** L摜` **********/
/* char.at@C "*.px" */

typedef struct _CHR_HEAD {
	int cnt;		/* Z */
	int unk1;
	int unk2;
	int unk3;
	int unk4;
	int unk5;
	int unk6;
	int unk7;
} CHR_HEAD;

typedef struct _CELL_HEAD {
	int w;			/*   [sNZ] */
	int h;			/* [sNZ] */
	int x;			/* 摜ł̃Z_X */
	int y;			/* 摜ł̃Z_Y */
	int unk4;
	int unk5;
	int unk6;
	int unk7;
} CELL_HEAD;

/****************************************************************************
 *	O[oϐ
 ****************************************************************************/

/* 摜܂܂ĂA[JCuXg */
const char* const arc_list[] = {
	"egbg",
	"char",
};
#define ARC_LIST_COUNT	(sizeof arc_list / sizeof *arc_list)

char app_dir[_MAX_PATH];	/* uVĝȂ12(DVD)ṽtH_ */
char file_name[_MAX_PATH];	/* ot@C("toh101"Ȃ)A܂͑SWJ("*") */

int opt_bmp;			/* BMPo(eXgp) */
int opt_chr;			/* G[h(؂) */
int opt_all;			/* ot@C"*"w肳ꂽ1ɂȂ܂ */

/****************************************************************************
 *	֐錾
 ****************************************************************************/

void err(const char* fmt, ...);
void usage();
void extract();
ARC* arc_open(const char* fname);
void arc_close(ARC* arc);
int expand(unsigned char** ppbuf);
void decode(unsigned char* eax, unsigned edx);
unsigned char* bmp32to8(unsigned char* in_buf);
unsigned char* reduce(unsigned char* in_buf);
unsigned char* make_bg(unsigned char* src, int size);
unsigned char* make_chr(unsigned char* src, int size);

/****************************************************************************
 *	err
 ****************************************************************************/

void
err(const char* fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
	vfprintf(stderr, fmt, ap);
	va_end(ap);

	exit(1);
}

/****************************************************************************
 *	usage
 ****************************************************************************/

void
usage()
{
	fprintf(stderr, "ptenshi - uVĝȂ12(DVD)(Leaf/AQUAPLUS)vPGDRo[^(%s)\n", VERSION);
	fprintf(stderr, "Copyright (C) 2003 Naoyuki Sawa\n");
	fprintf(stderr, "gF\n");
	fprintf(stderr, "  ptenshi [options] <file-name>\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "  t@CɁu*vƎw肷ƁAo\ȑSẴt@C𒊏o܂B\n");
	fprintf(stderr, "  <> ptenshi -b *\n");
	fprintf(stderr, "       SẴt@CBMPt@CƂĒo܂B\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "IvVF\n");
	fprintf(stderr, "  -b        -b2ƓłB\n");
	fprintf(stderr, "  -b1       rbg}bvt@Ĉ܂܏o͂܂B\n");
	fprintf(stderr, "  -b2       rbg}bvt@Ckďo͂܂B\n");
	fprintf(stderr, "  -b3       rbg}bvt@CkEFďo͂܂B\n");
	fprintf(stderr, "  -b/-b1/-b2/-b3̂ǂw肵Ȃ΁APGDt@Co͂܂B\n");
	fprintf(stderr, "  -c        kAcɂ͂ݏoꍇ́A؂܂B\n");
	fprintf(stderr, "  -d<path>  VĝȂ12(DVD)tH_w(l=WXg擾)\n");
	exit(1);
}

/****************************************************************************
 *	main
 ****************************************************************************/

int
main(int argc, char* argv[])
{
	int retval, i, n;
	char* p;
	HKEY hKey;

	/* R}hĆB */
	for(i = 1; i < argc; i++) {
		p = argv[i];
		if(p[0] == '-') { /* IvV */
			switch(p[1]) {
			case 'b': /* BMPo */
				if(opt_bmp) usage(); /* dw */
				if(p[2]) {
					opt_bmp = p[2] - '0';
				} else {
					opt_bmp = 2; /* -b݂̂Ȃ2 */
				}
				if(opt_bmp < 1 || 3 < opt_bmp) usage();
				break;
			case 'c': /* G[h */
				if(opt_chr) usage(); /* dw */
				opt_chr = 1;
				break;
			case 'd': /* uVĝȂ12(DVD)vCXg[tH_w */
				if(strlen(app_dir) != 0) usage(); /* dw */
				strncpy(app_dir, &p[2], sizeof app_dir);
				break;
			default:
				usage();
			}
		} else {
			/* ot@C */
			if(strlen(file_name) != 0) usage(); /* dw */
			strncpy(file_name, p, sizeof file_name);
		}
	}

	/* ot@CB */
	if(strlen(file_name) == 0) usage();
	if(strcmp(file_name, "*") == 0) opt_all = 1; /* SWJ? */

	/* uVĝȂ12(DVD)vCXg[tH_𒲂ׂ܂B */
	if(strlen(app_dir) == 0) {
		retval = RegOpenKeyEx(HKEY_CURRENT_USER, REG_KEY, 0, KEY_QUERY_VALUE, &hKey);
		if(retval == 0) {
			n = sizeof app_dir;
			retval = RegQueryValueEx(hKey, REG_VALUE, 0, NULL, (unsigned char*)app_dir, (unsigned long*)&n);
			RegCloseKey(hKey);
		}
		if(retval != 0) err("uVĝȂ12(DVD)vCXg[ĂȂ悤łB");
	}

	/* t@CWJB */
	extract();

	return 0;
}

/****************************************************************************
 *	extract
 ****************************************************************************/

/* type-1 => 0:k / 1:kȂACfbNXOkȂ */
const unsigned char expand_type[0x89] = {
	0,1,0,1,0,1,1,1, 1,1,1,1,1,1,1,1,	/* type-1 = 00`0f */
	1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,	/* type-1 = 10`1f */
	1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,	/* type-1 = 20`2f */
	1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,	/* type-1 = 30`3f */
	1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,	/* type-1 = 40`4f */
	1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,	/* type-1 = 50`5f */
	1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,	/* type-1 = 60`6f */
	1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,0,	/* type-1 = 70`7f */
	0,0,0,0,0,0,0,0, 0,			/* type-1 = 80`88 */
};
#define EXPAND_TYPE_SIZE	(sizeof expand_type / sizeof *expand_type)

/* type-3 => 0`2:Í^Cv0`2(2̂ݎ) / 3:ÍȂACfbNXOÍȂ */
const unsigned char decode_type[0x87] = {
	0,3,1,3,3,3,3,3, 3,3,3,3,3,3,3,3,	/* flag-3 = 00`0f */
	3,3,3,3,3,3,3,3, 3,3,3,3,3,3,3,3,	/* flag-3 = 10`1f */
	3,3,3,3,3,3,3,3, 3,3,3,3,3,3,3,3,	/* flag-3 = 20`2f */
	3,3,3,3,3,3,3,3, 3,3,3,3,3,3,3,3,	/* flag-3 = 30`3f */
	3,3,3,3,3,3,3,3, 3,3,3,3,3,3,3,3,	/* flag-3 = 40`4f */
	3,3,3,3,3,3,3,3, 3,3,3,3,3,3,3,3,	/* flag-3 = 50`5f */
	3,3,3,3,3,3,3,3, 3,3,3,3,3,3,3,3,	/* flag-3 = 60`6f */
	3,3,3,3,3,3,3,3, 3,3,3,3,3,2,2,2,	/* flag-3 = 70`7f */
	2,2,2,2,2,2,2				/* flag-3 = 80`86 */
};
#define DECODE_TYPE_SIZE	(sizeof decode_type / sizeof *decode_type)

void
extract()
{
	int retval;
	int done;
	int i_arc;
	int i_file;
	int type;
	int size;
	ARC* arc;
	ARC_FILE* file;
	unsigned char* buf;
	FILE* fp;
	char path[_MAX_PATH];
	char fname[_MAX_FNAME];
	char cmd[_MAX_PATH];
	BITMAPFILEHEADER* bf;

	done = 0; /* PƓWJAwt@CWJ1ɂȂ܂ */

	/* eA[JCuɂ... */
	for(i_arc = 0; !done && i_arc < ARC_LIST_COUNT; i_arc++) {
		/* A[JCuJ܂B */
		arc = arc_open(arc_list[i_arc]);

		/* et@Cɂ... */
		for(i_file = 0; !done && i_file < arc->cnt; i_file++) {
			file = &arc->file[i_file];

			/* SWJA܂͎wt@CɈv... */
			_splitpath(file->fname, NULL, NULL, fname, NULL);
			if(opt_all || strcmpi(fname, file_name) == 0) {
				/* SWJȂÃt@C\B */
				if(opt_all) printf("%s(%3d): %s\n", arc_list[i_arc], i_file, file->fname);

				/* SȊĴ߂ɁANULLɏĂ܂B */
				buf = NULL;

				/* obt@mۂ܂B */
				buf = (unsigned char*)calloc(file->len, 1);
				if(buf == NULL) err("%s: słB", file->fname);

				/* t@Cǂݍ݂܂B */
				fseek(arc->fp, sizeof(ARC_HEAD) + sizeof(ARC_FILE) * arc->cnt + file->ofs, SEEK_SET);
				size = file->len;
				retval = fread(buf, 1, size, arc->fp);
				if(retval != size) err("%s: t@Cǂ߂܂B", file->fname);

				/* 𓀂܂B */
				type = file->type - 1;
				if(0 <= type && type <= EXPAND_TYPE_SIZE - 1) {
					type = expand_type[type];
					switch(type) {
					case 0:
						/* kB */
						size = expand(&buf); /* 𓀌̃obt@ŒuāATCY擾 */
						break;
					case 1:
						/* kȂB */
						break;
					default:
						abort(); /* 肦Ȃ */
					}
				}

				/* ܂B(ł̓TCY͕ς܂) */
				type = file->type - 3;
				if(0 <= type && type <= DECODE_TYPE_SIZE - 1) {
					type = decode_type[type];
					switch(type) {
					case 2:
						if(((BG_HEAD*)buf)->unk4 == 0x200001) {
							/* ÍB */
							decode(buf, file->type & 0x0f); /* 3Otypẻ4rbg𕜍L[ƂĎgp */
							break;
						}
						// FALL THRU */
					case 0:
					case 1:
						/* Ή̈Í`B */
						if(opt_all) { /* SWJȂXLbv */
							fprintf(stderr, "%s: Ή̈Í^CvłB\n", file->fname);
							goto SKIP;
						} else { /* PƓWJȂG[ */
							err("%s: Ή̈Í^CvłB", file->fname);
						}
					default:
						abort(); /* 肦Ȃ */
					}
				}

				/* rbg}bv쐬B */
				switch(i_arc) {
				case 0: /* egbg.a */
					if(((BG_HEAD*)buf)->unk4 != 0x200001) {
						if(opt_all) { /* SWJȂXLbv */
							fprintf(stderr, "%s: Ή̉摜`łB\n", file->fname);
							goto SKIP;
						} else { /* PƓWJȂG[ */
							err("%s: Ή̉摜`łB", file->fname);
						}
					}
					buf = make_bg(buf, size);
					break;
				case 1: /* char.a */
					if((((CHR_HEAD*)buf)->unk4 & 0xff) != 0x40) {
						if(opt_all) { /* SWJȂXLbv */
							fprintf(stderr, "%s: Ή̉摜`łB\n", file->fname);
							goto SKIP;
						} else { /* PƓWJȂG[ */
							err("%s: Ή̉摜`łB", file->fname);
						}
					}
					buf = make_chr(buf, size);
					break;
				default:
					abort(); /* 肦Ȃ */
				}

				if(opt_bmp == 1) goto L10;	/* BMPo͂ */

				/* kB */
				buf = reduce(buf);

				if(opt_bmp == 2) goto L10;	/* BMPo͂ */

				/* OCXP[ϊB */
				buf = bmp32to8(buf);
L10:
				/* rbg}bvo͂܂B */
				_splitpath(file->fname, NULL, NULL, fname, NULL);
				_makepath(path, NULL, NULL, fname, ".bmp");
				fp = fopen(path, "wb");
				bf = (BITMAPFILEHEADER*)buf;
				retval = fwrite(buf, 1, bf->bfSize, fp);
				if(retval != (int)bf->bfSize) err("%s: rbg}bvo͂Ɏs܂B", file->fname);
				fclose(fp);

				/* PGDϊB */
				if(opt_bmp == 0) {
					switch(i_arc) {
					case 0: /* egbg.a: 2bit}XNȂ */
						sprintf(cmd, "dpbmpcnv -q -b -f2  \"%s\"", path); /* -qKv! */
						break;
					case 1: /* char.a: 2bit}XN */
						sprintf(cmd, "dpbmpcnv -q -b -f2m \"%s\"", path); /* -qKv! */
						break;
					default:
						abort(); /* 肦Ȃ */
					}
					if(system(cmd) != 0) err("PGDϊɎs܂B");
					remove(path);	/* BMP͂Ȃ̂ō폜 */
				}

				/* PƓWJȂA}[NB */
				if(!opt_all) done = 1;
SKIP:
				/* obt@J܂B */
				free(buf);
			}
		}

		/* A[JCu܂B */
		arc_close(arc);
	}

	/* PƓWJŁAw肳ꂽGgȂ΁AG[B */
	if(!opt_all && !done) err("%s܂B", file_name);
}

/****************************************************************************
 *	arc_open
 ****************************************************************************/

ARC*
arc_open(const char* fname)
{
	int retval;
	char path[_MAX_PATH];
	ARC* arc;
	ARC_HEAD head;

	/* ARC\̂mۂ܂B */
	arc = (ARC*)calloc(1, sizeof(ARC));
	if(arc == NULL) err("%s: słB", fname);

	/* A[JCuJ܂B */
	_makepath(path, NULL, app_dir, fname, "a");
	arc->fp = fopen(path, "rb");
	if(arc->fp == NULL) err("%s: t@CJ܂B", fname);

	/* wb_ǂݍ݂܂B */
	retval = fread(&head, sizeof(ARC_HEAD), 1, arc->fp);
	if(retval != 1) err("%s: wb_ǂ߂܂B", fname);

	/* VOl`܂B */
	if(head.sig != ARC_SIG) err("%s: VOl`słB", fname);

	/* t@Ce[uǂݍނ߂̃mۂ܂B */
	arc->cnt = head.cnt;
	arc->file = (ARC_FILE*)calloc(arc->cnt, sizeof(ARC_FILE));
	if(arc->file == NULL) err("%s: słB", fname);

	/* t@Ce[uǂݍ݂܂B */
	retval = fread(arc->file, sizeof(ARC_FILE), arc->cnt, arc->fp);
	if(retval != arc->cnt) err("%s: t@Ce[uǂ߂܂B", fname);

	return arc;
}

/****************************************************************************
 *	arc_close
 ****************************************************************************/

void
arc_close(ARC* arc)
{
	fclose(arc->fp);
	free(arc->file);
	free(arc);
}

/****************************************************************************
 *	expand
 ****************************************************************************/

int
expand(unsigned char** ppbuf)
{
#define	N	4096
#define	F	18
static unsigned char tmp_buf[N + F];

	unsigned char *src, *src_save;
	unsigned char *dst, *dst_save;
	int i, j, k, r;
	int size, flags, pos, len;

	/* ̓obt@擾B */
	src = src_save = *ppbuf;

	/* o̓TCY擾B */
	size = *(unsigned int*)src;
	src += 4;

	/* o̓obt@mہB */
	dst = dst_save = (unsigned char*)calloc(size, 1);
	if(dst == NULL) err("słB");

	/* XChobt@B */
	memset(tmp_buf, 0, sizeof tmp_buf);
	r = N - F; /* ʒu͌̕H */

	/* JE^o̓TCYɒB܂... */
	i = 0;
	while(i < size) {
		/* `N1oCgڂ̓tOB */
		flags = *(src++);
		for(j = 0; j < 8; j++) { /* tObit0`70:k/1:kɑΉ */
			if(i >= size) break;
			if(flags & 1) { /* Ń}Ƃ͈ႤI */
				/* 0:k */
				*(tmp_buf + r++) = *(dst++) = *(src++);
				r &= (N - 1);
				i++;
			} else {
				/* 1:k */
				pos = *(src++);	/* pppp_pppp: p=XChʒubit 7`0           */
				len = *(src++);	/* pppp_llll: p=XChʒubit11`8Al=-2 */
				pos |= ((len & 0xf0) << 4);
				len = (len & 0x0f) + 2;
				for(k = 0; k <= len; k++) {
					if(i >= size) break;
					*(tmp_buf + r++) = *(dst++) = *(tmp_buf + ((pos + k) & (N - 1)));
					r &= (N - 1);
					i++;
				}
			}
			flags >>= 1; /* Ń}Ƃ͈ႤI */
		}
	}

	/* ̓obt@JB */
	free(src_save);

	/* o̓obt@i[B */
	*ppbuf = dst_save;

	return size;

#undef N
#undef F
}

/****************************************************************************
 *	decode
 ****************************************************************************/

void
decode(unsigned char* eax, unsigned edx)
{
	unsigned size, I0h, ecx, Och;
	unsigned char O8h[4];
	unsigned char bl;

	size = *(int*)&eax[0] * *(int*)&eax[4];
	eax += 32;

	I0h= edx;			// IWiL[ۑ
	ecx = 0;			// ÕsNZ
	Och = 0;			// ÕsNZ
	memset(O8h, 0, sizeof O8h);	// RGBA

	while(size) {
	/* mov bl,[eax]			*/	bl = eax[0];
	/* sub bl,dl			*/	bl -= edx;
	/* add bl,[eax+003h]		*/	bl += eax[3];
	/* mov dl,[eax+001h]		*/	*(unsigned char*)&edx = eax[1];
	/* add bl,cl			*/	bl += ecx;
	/* mov cl,[eax+002h]		*/	*(unsigned char*)&ecx = eax[2];
	/* mov [esp+008h],bl		*/	O8h[0] = bl;
	/* sub dl,[esp+010h]		*/	*(unsigned char*)&edx -= I0h;
	/* mov bl,[eax+003h]		*/	bl = eax[3];
	/* add dl,bl			*/	*(unsigned char*)&edx += bl;
	/* add dl,ch			*/	*(unsigned char*)&edx += ecx >> 8;
	/* mov [esp+009h],dl		*/	O8h[1] = edx;
	/* mov edx,dword [esp+010h]	*/	edx = I0h;
	/* sub cl,dl			*/	*(unsigned char*)&ecx -= edx;
	/* add cl,bl			*/	*(unsigned char*)&ecx += bl;
	/* add cl,[esp+00eh]		*/	*(unsigned char*)&ecx += Och >> 16;
	/* mov [esp+00ah],cl		*/	O8h[2] = ecx;
	/* mov ecx,dword [esp+008h]	*/	ecx = *(unsigned*)&O8h[0];
	/* mov dword [eax],ecx		*/	*(unsigned*)&eax[0] = ecx;
	/* add eax,byte +004h		*/	eax += 4;
	/* dec esi			*/	size--;
	/* mov dword [esp+00ch],ecx	*/	Och = ecx;
	}
}

/****************************************************************************
 *	bmp32to8
 ****************************************************************************/

const int DITHER[8][8] = {
         0,32, 8,40, 2,34,10,42,
        48,16,56,24,50,18,58,26,
        12,44, 4,36,14,46, 6,38,
        60,28,52,20,62,30,54,22,
         3,35,11,43, 1,33, 9,41,
        51,19,59,27,49,17,57,25,
        15,47, 7,39,13,45, 5,37,
        63,31,55,23,61,29,53,21,
};

unsigned char*
bmp32to8(unsigned char* in_buf)
{
	int w, h, x, y, r, g, b, a, c;

	BITMAPFILEHEADER* bf_in;
	BITMAPINFOHEADER* bi_in;
	int stride_in;
	unsigned char *bits_in, *pin;

	int out_size;
	unsigned char* out_buf;
	BITMAPFILEHEADER* bf_out;
	BITMAPINFOHEADER* bi_out;
	RGBQUAD* rgb_out;
	int stride_out;
	unsigned char *bits_out, *pout;

	/* ̓rbg}bv擾B */
	bf_in   = (BITMAPFILEHEADER*)(in_buf);
	bi_in   = (BITMAPINFOHEADER*)(in_buf + sizeof(BITMAPFILEHEADER));
	bits_in = (unsigned char   *)(in_buf + bf_in->bfOffBits);
	w = bi_in->biWidth;
	h = bi_in->biHeight;
	stride_in = 4 * w;

	/* o̓rbg}bv쐬B */
	stride_out = (w + 3) & ~3;
	out_size = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * 256 + stride_out * h;
	out_buf = (unsigned char*)calloc(out_size, 1);
	if(out_buf == NULL) err("rbg}bvϊpobt@mۂł܂B");
	bf_out   = (BITMAPFILEHEADER*)(out_buf);
	bi_out   = (BITMAPINFOHEADER*)(out_buf + sizeof(BITMAPFILEHEADER));
	rgb_out  = (RGBQUAD         *)(out_buf + sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER));
	bits_out = (unsigned char   *)(out_buf + sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * 256);

	bf_out->bfType = 'MB';
	bf_out->bfSize = out_size;
	bf_out->bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * 256;

	bi_out->biSize = sizeof(BITMAPINFOHEADER);
	bi_out->biWidth = w;
	bi_out->biHeight = h;
	bi_out->biPlanes = 1;
	bi_out->biBitCount = 8;

	for(c = 0; c < 4; c++) {
		rgb_out[c].rgbRed       = 85 * (3 - c);
		rgb_out[c].rgbGreen     = 85 * (3 - c);
		rgb_out[c].rgbBlue      = 85 * (3 - c);
		rgb_out[c].rgbReserved  = 0;
	}
	for(c = 4; c < 256; c++) {
		rgb_out[c].rgbRed       = 0;
		rgb_out[c].rgbGreen     = 255;
		rgb_out[c].rgbBlue      = 0;
		rgb_out[c].rgbReserved  = 0;
	}

	for(y = 0; y < h; y++) {
		for(x = 0; x < w; x++) {
			pin  = bits_in  + stride_in  * (h - 1 - y) + 4 * x;
			pout = bits_out + stride_out * (h - 1 - y) + 1 * x;
			;
			b = *pin++;
			g = *pin++;
			r = *pin++;
			a = *pin++;
			;
			if(a) {
				c = (r * 3 + g * 5 + b * 2) / 10;
				c = (c + DITHER[y & 7][x & 7] + (85 - 63) / 2) / 85;
				if(c > 3) c = 3;
				c = 3 - c;
			} else {
				c = 4;
			}
			;
			*pout++ = c;
		}
	}

	/* ̓rbg}bvJAɏo̓rbg}bvԂ܂B */
	free(in_buf);
	return out_buf;
}

/****************************************************************************
 *	reduce
 ****************************************************************************/

#define WIDTH_LIMIT	128
#define HEIGHT_LIMIT	 88

unsigned char*
reduce(unsigned char* in_buf)
{
	int x_in, y_in, x_out, y_out, r, g, b, a, n, x_base, y_base;
	double REDUCE_LEVEL;

	int w_in;
	int h_in;
	BITMAPFILEHEADER* bf_in;
	BITMAPINFOHEADER* bi_in;
	int stride_in;
	unsigned char *bits_in, *pin;

	int out_size;
	int w_out;
	int h_out;
	unsigned char* out_buf;
	BITMAPFILEHEADER* bf_out;
	BITMAPINFOHEADER* bi_out;
	int stride_out;
	unsigned char *bits_out, *pout;

	/* ̓rbg}bv擾B */
	bf_in   = (BITMAPFILEHEADER*)(in_buf);
	bi_in   = (BITMAPINFOHEADER*)(in_buf + sizeof(BITMAPFILEHEADER));
	bits_in = (unsigned char   *)(in_buf + bf_in->bfOffBits);
	w_in = bi_in->biWidth;
	h_in = bi_in->biHeight;
	stride_in = 4 * w_in;

	/* G[h͔䗦ŒB */
	if(opt_chr) {
		REDUCE_LEVEL = (float)ORIGINAL_WIDTH / WIDTH_LIMIT;
	/* wi[h͔䗦ρB */
	} else {
		double rl1 = (double)w_in / WIDTH_LIMIT;
		double rl2 = (double)h_in / HEIGHT_LIMIT;
		REDUCE_LEVEL = rl1 <= rl2 ? rl1 : rl2; /* ʂςɂȂ悤 */
	}

	/* o̓rbg}bv쐬B */
	w_out = (int)(w_in / REDUCE_LEVEL);
	h_out = (int)(h_in / REDUCE_LEVEL);
	x_base = 0;
	y_base = 0;
	if(w_out > WIDTH_LIMIT) {
		x_base = (int)((w_out - WIDTH_LIMIT) / 2 * REDUCE_LEVEL);
		w_out = WIDTH_LIMIT;
	}
	if(h_out > HEIGHT_LIMIT) {
		if(!opt_chr) y_base = (int)((h_out - HEIGHT_LIMIT) / 2 * REDUCE_LEVEL);
		h_out = HEIGHT_LIMIT;
	}
	stride_out = 4 * w_out;
	out_size = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + stride_out * h_out;
	out_buf = (unsigned char*)calloc(out_size, 1);
	if(out_buf == NULL) err("rbg}bvϊpobt@mۂł܂B");
	bf_out   = (BITMAPFILEHEADER*)(out_buf);
	bi_out   = (BITMAPINFOHEADER*)(out_buf + sizeof(BITMAPFILEHEADER));
	bits_out = (unsigned char   *)(out_buf + sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER));

	bf_out->bfType = 'MB';
	bf_out->bfSize = out_size;
	bf_out->bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER);

	bi_out->biSize = sizeof(BITMAPINFOHEADER);
	bi_out->biWidth = w_out;
	bi_out->biHeight = h_out;
	bi_out->biPlanes = 1;
	bi_out->biBitCount = 32;

	/* kB */
	for(y_out = 0; y_out < h_out; y_out++) {
		for(x_out = 0; x_out < w_out; x_out++) {
			/* k̃sNZZB */
			r = 0;
			g = 0;
			b = 0;
			a = 0;
			n = 0;
			for(y_in = y_base + (int)(y_out * REDUCE_LEVEL); y_in < y_base + (int)((y_out + 1) * REDUCE_LEVEL); y_in++) {
				if(y_in < 0 || h_in - 1 < y_in) continue;
				for(x_in = x_base + (int)(x_out * REDUCE_LEVEL); x_in < x_base + (int)((x_out + 1) * REDUCE_LEVEL); x_in++) {
					if(x_in < 0 || w_in - 1 < x_in) continue;
					pin  = bits_in  + stride_in  * (h_in - 1 - y_in) + 4 * x_in;
					b += *pin++;
					g += *pin++;
					r += *pin++;
					a += *pin++;
					n++;
				}
			}
			/* ςďk̃sNZցB */
			pout  = bits_out + stride_out  * (h_out - 1 - y_out) + 4 * x_out;
			if(n != 0) {
				r = (r + n / 2) / n;
				g = (g + n / 2) / n;
				b = (b + n / 2) / n;
				a = (a + n / 2) / n;
			}
			*pout++ = b;
			*pout++ = g;
			*pout++ = r;
			*pout++ = a;
		}
	}

	/* ̓rbg}bvJAɏo̓rbg}bvԂ܂B */
	free(in_buf);
	return out_buf;
}

/****************************************************************************
 *	reduce
 ****************************************************************************/

unsigned char*
make_bg(unsigned char* src, int size)
{
	int x;
	int y;
	int width;
	int height;
	BG_HEAD* head;

	unsigned char* dst;
	BITMAPFILEHEADER* bf;
	BITMAPINFOHEADER* bi;
	unsigned* src_bits;
	unsigned* dst_bits;

	/* 摜wb_擾B */
	head = (BG_HEAD*)src;
	width = head->w;
	height = head->h;
	src_bits = (unsigned*)(head + 1);

	/* rbg}bv쐬pmۂ܂B */
	dst = (unsigned char*)calloc(
		sizeof(BITMAPFILEHEADER) +
		sizeof(BITMAPINFOHEADER) +
		4 * width * height,
		1);
	if(dst == NULL) err("słB");
	bf = (BITMAPFILEHEADER*)dst;
	bi = (BITMAPINFOHEADER*)(bf + 1);
	dst_bits = (unsigned*)(bi + 1);

	/* rbg}bvt@Cwb_쐬B */
	bf->bfType    = 'MB';
	bf->bfSize    = sizeof(BITMAPFILEHEADER) +
			sizeof(BITMAPINFOHEADER) +
			4 * width * height;
	bf->bfOffBits = sizeof(BITMAPFILEHEADER) +
			sizeof(BITMAPINFOHEADER);

	/* rbg}bvwb_쐬B */
	bi->biSize = sizeof(BITMAPINFOHEADER);
	bi->biWidth = width;
	bi->biHeight = height;
	bi->biPlanes = 1;
	bi->biBitCount = 32;

	/* sNZf[^Rs[B(Windows BMPȂ̂ŏ㉺]) */
	for(y = 0; y < height; y++) {
		for(x = 0; x < width; x++) {
			*(dst_bits + width * (height - 1 - y) + x) =
			*(src_bits + width *               y  + x) | 0xff000000;
		}
	}

	/* ̓obt@jArbg}bvԂ܂B */
	free(src);
	return dst;
}

/****************************************************************************
 *	make_chr
 ****************************************************************************/

unsigned char*
make_chr(unsigned char* src, int size)
{
#define IMAGE_SIZE	1024
static unsigned image[IMAGE_SIZE][IMAGE_SIZE];

	int i_cell;
	int x;
	int y;
	int width;
	int height;
	int cnt;
	CHR_HEAD* chr;
	int* table;
	unsigned char* base;
	CELL_HEAD* cell;
	unsigned* p;

	unsigned char* dst;
	BITMAPFILEHEADER* bf;
	BITMAPINFOHEADER* bi;
	unsigned* src_bits;
	unsigned* dst_bits;

	/********** Z` **********/

	/* ܂摜NAB */
	int x_min = INT_MAX;
	int x_max = INT_MIN;
	int y_min = INT_MAX;
	int y_max = INT_MIN;
	for(y = 0; y < IMAGE_SIZE; y++) {
		for(x = 0; x < IMAGE_SIZE; x++) {
			image[y][x] = 0x0000ff00;
		}
	}

	/* 摜wb_擾B */
	chr = (CHR_HEAD*)src;

	/* ZItZbge[u擾B */
	table = (int*)(chr + 1);

	/* ZItZbgx[X擾B */
	base = (unsigned char*)(table + chr->cnt);

	/* eZɂ... */
	for(i_cell = 0; i_cell < chr->cnt; i_cell++) {
		cell = (CELL_HEAD*)(base + table[i_cell]);

		/* Z_擾B */
		x = cell->x;
		y = cell->y;

		p = (unsigned*)(cell + 1);
		for(;;) {
			/* [vB */
			while(*p < 0xfffffffe) {
				p++;
				x += (short)(*p >> 16);
				y += (short)(*p >>  0);
				p++;
				cnt = *p;
				p++;
				do {
					if(x < 0 || IMAGE_SIZE - 1 < x) abort();
					if(y < 0 || IMAGE_SIZE - 1 < y) abort();
					if(x < x_min) x_min = x;
					if(x > x_max) x_max = x;
					if(y < y_min) y_min = y;
					if(y > y_max) y_max = y;
					if(*p & 0x80000000) abort(); /* 0`7fł邱ƂmF */
					image[y][x] = (*p & 0x00ffffff) | (*p & 0xff000000) << 1; /* 0`7fȂ̂2{ */
					//`FbN鎞́A̍sLɂĂB
					//image[y][x] = (image[y][x] & 0xff000000) | (image[y][x] & 0xff000000) >> 8 | (image[y][x] & 0xff000000) >> 16 | (image[y][x] & 0xff000000) >> 24;
					x++;
					p++;
				} while(--cnt);
			}
			if(*p == 0xffffffff) break;
			p++;
			/* s[vB */
			while(*p < 0xfffffffe) {
				p++;
				x += (short)(*p >> 16);
				y += (short)(*p >>  0);
				p++;
				cnt = *p;
				p++;
				do {
					if(x < 0 || IMAGE_SIZE - 1 < x) abort();
					if(y < 0 || IMAGE_SIZE - 1 < y) abort();
					if(x < x_min) x_min = x;
					if(x > x_max) x_max = x;
					if(y < y_min) y_min = y;
					if(y > y_max) y_max = y;
					image[y][x] = *p | 0xff000000; /* s[vł̓Iffɒu(t@Cł00Ŋi[Ă) */
					//`FbN鎞́A̍sLɂĂB
					//image[y][x] = (image[y][x] & 0xff000000) | (image[y][x] & 0xff000000) >> 8 | (image[y][x] & 0xff000000) >> 16 | (image[y][x] & 0xff000000) >> 24;
					x++;
					p++;
				} while(--cnt);
			}
			if(*p == 0xffffffff) break;
			p++;
		}
	}

	/********** rbg}bv쐬 **********/

	width = x_max - x_min + 1;
	height = y_max - y_min + 1;
	src_bits = &image[y_min][x_min];

	/* rbg}bv쐬pmۂ܂B */
	dst = (unsigned char*)calloc(
		sizeof(BITMAPFILEHEADER) +
		sizeof(BITMAPINFOHEADER) +
		4 * width * height,
		1);
	if(dst == NULL) err("słB");
	bf = (BITMAPFILEHEADER*)dst;
	bi = (BITMAPINFOHEADER*)(bf + 1);
	dst_bits = (unsigned*)(bi + 1);

	/* rbg}bvt@Cwb_쐬B */
	bf->bfType    = 'MB';
	bf->bfSize    = sizeof(BITMAPFILEHEADER) +
			sizeof(BITMAPINFOHEADER) +
			4 * width * height;
	bf->bfOffBits = sizeof(BITMAPFILEHEADER) +
			sizeof(BITMAPINFOHEADER);

	/* rbg}bvwb_쐬B */
	bi->biSize = sizeof(BITMAPINFOHEADER);
	bi->biWidth = width;
	bi->biHeight = height;
	bi->biPlanes = 1;
	bi->biBitCount = 32;

	/* sNZf[^Rs[B(Windows BMPȂ̂ŏ㉺]) */
	for(y = 0; y < height; y++) {
		for(x = 0; x < width; x++) {
			*((unsigned*)dst_bits + width      * (height - 1 - y) + x) =
			*((unsigned*)src_bits + IMAGE_SIZE *               y  + x);
		}
	}

	/* ̓obt@jArbg}bvԂ܂B */
	free(src);
	return dst;

#undef IMAGE_SIZE
}
