/*
 *	main.c
 *
 *	dppcmcnv - WAV to PPD Ro[^
 *	Copyright (C) 2002-2006 Naoyuki Sawa
 *
 *	* Sun Jul 21 04:37:00 JST 2002 Naoyuki Sawa
 *	- 쐬JnB
 *	* Mon Jul 17 22:43:46 JST 2006 Naoyuki Sawa
 *	- ȉ̃oOC܂B
 *	  - ϊwavt@C傫ꍇɁAsppdt@Co͂邱ƂB
 *	    ̓Iɂ́Aϊwavt@C\bȏ̒ŁAo͌`ώgADPCM`̏ꍇA
 *	    o͂ppdt@CPCEWAVEINFO.lentB[hAă}CiXɂȂ邱Ƃ܂B
 *	  ̏CɂÃoO͖Ȃ܂B
 *	* Tue Dec 19 18:05:32 JST 2006 Naoyuki Sawa
 *	- 2bitADPCMώg(Ǝg)ǉ܂B
 *	  CLiPCuōĐ܂B
 */
#include "app.h"

/****************************************************************************
 *
 ****************************************************************************/

/* bZ[Wo */
#define NULDEV	"NUL"
FILE* msg = stdout;

/* o̓t@C` */
#define TYPE_TEXT	0
#define TYPE_BINARY	1
char* out_type_desc[] = {
	"TEXT",
	"BINARY",
};
int out_type = -1;

/* o̓f[^` */
#define FMT_PCM		0
#define FMT_ADPCM	1
#define FMT_ADPCM_V	2
#define FMT_ADPCM_X	3	/*{{2006/12/19ǉ: 2bitADPCMώg(Ǝg)}}*/
char* out_fmt_desc[] = {
	"PCM",
	"ADPCM",
	"ADPCM_V",
	"ADPCM_X",		/*{{2006/12/19ǉ: 2bitADPCMώg(Ǝg)}}*/
};
int out_fmt = -1;

/* TvTCY(PCM̂)
 * -1: ̓t@CƓ
 *  8:  8rbg
 * 16: 16rbg
 */
int out_smpl = -1;

/* ϊ[g(ADPCMώĝ)
 *       -1: ̓t@CƓ
 * 1`16000: gw
 */
#define RATE_MIN	1
#define RATE_MAX	16000
#define RATE_DEFAULT	RATE_MAX
int out_rate = -1;

/* o̓t@C */
char in_path[_MAX_PATH];
char out_path[_MAX_PATH];
char drive[_MAX_DRIVE];
char dir[_MAX_DIR];
char fname[_MAX_FNAME];
char ext[_MAX_EXT];

/* o̓x */
char out_label[32];
char out_prefix[32];

/* eLXgo͎AsɉoCgo͂邩H */
#define LINEBYTES	32

/****************************************************************************
 *	main
 ****************************************************************************/

int
main(int argc, char* argv[])
{
	int retval, c_fmt;
	WAV *wav1, *wav2;
	FILE* fp;

	/* R}hC͂܂B */
	cmdline(argc, argv);

	/* tH[}bg̍őTCY擾Ă܂B */
	retval = acmMetrics(NULL, ACM_METRIC_MAX_SIZE_FORMAT, &c_fmt);
	if(retval != 0) die("acmMetrics()s܂B");

	/* WAVf[^ǂݍ݂܂B */
	wav1 = wav_load(in_path);

	/* ꎞIPCM`ɕϊ܂B
	 * ӁI
	 *   ϊWAVE_FORMAT_PCM̏ꍇA
	 *   WAVE_FORMAT_PCMWAVE_FORMAT_PCMւ̕ϊiӖjw肵acmFormatSuggest()ĂԂƁA
	 *   acmFormatSuggest()̒ŗ悤łBiWin2K+SP2ŊmFj
	 *   h߂ɁAϊWAVE_FORMAT_PCMłȂꍇ̂݁A
	 *   ꎞIPCM`ւ̕ϊsƂɂ܂B
	 */
	if(wav1->fmt->wFormatTag != WAVE_FORMAT_PCM) {
		wav2 = wav_new();
		wav2->fmt = (WAVEFORMATEX*)calloc(1, c_fmt);
		if(wav2->fmt == NULL) die("słB");
		wav2->fmt->wFormatTag = WAVE_FORMAT_PCM; /* jAPCM */
		retval = acmFormatSuggest(NULL, wav1->fmt, wav2->fmt, c_fmt, ACM_FORMATSUGGESTF_WFORMATTAG);
		if(retval != 0) die("acmFormatSuggest()s܂B");
		wav_to_wav(wav1, wav2);
		wav_free(wav1); /* ϊWAVJ             */
		wav1 = wav2;    /* ϊWAV̕ϊɐݒ */
	}

	/* ŏIIPCM`̃TvTCYEϊ[g肵܂B */
	switch(out_fmt) {
	case FMT_PCM:
		/* TvTCYw肳ĂȂ΁AWAVt@CƓɂ܂B */
		if(out_smpl == -1) {
			out_smpl = wav1->fmt->wBitsPerSample;
			if(out_smpl != 8 && out_smpl != 16) { /* 肦ȂƂ͎v... */
				/* 8/16bitȊOȂA߂̃TvTCYɍ킹܂B */
				out_smpl = out_smpl < 12 ? 8 : 16;
			}
		}
		/* ϊ[g16000[Hz]ŒłB */
		out_rate = RATE_DEFAULT;
		break;
	case FMT_ADPCM:
		/* TvTCY16rbgŒłB */
		out_smpl = 16;
		/* ϊ[g16000[Hz]ŒłB */
		out_rate = RATE_DEFAULT;
		break;
	case FMT_ADPCM_V:
	case FMT_ADPCM_X:	/*{{2006/12/19ǉ: 2bitADPCMώg(Ǝg)}}*/
		/* TvTCY16rbgŒłB */
		out_smpl = 16;
		/* ϊ[gw肳ĂȂ΁AWAVt@CƓɂ܂B */
		if(out_rate == -1) {
			out_rate = wav1->fmt->nSamplesPerSec;
			if(out_rate < RATE_MIN) out_rate = RATE_MIN; /* ؂l */
			if(out_rate > RATE_MAX) out_rate = RATE_MAX; /* ؂l */
		}
		break;
	}
	fprintf(msg, "OUT SMPL : %d\n", out_smpl);
	fprintf(msg, "OUT RATE : %d\n", out_rate);

	/* ŏIIPCM`ɕϊ܂B */
#define CHANNELS 1
	wav2 = wav_new();
	wav2->fmt = (WAVEFORMATEX*)calloc(1, c_fmt);
	if(wav2->fmt == NULL) die("słB");
	wav2->fmt->wFormatTag = WAVE_FORMAT_PCM;
	wav2->fmt->nChannels = CHANNELS;
	wav2->fmt->nSamplesPerSec = out_rate;
	wav2->fmt->nAvgBytesPerSec = out_rate * (out_smpl / 8);
	wav2->fmt->nBlockAlign = (out_smpl / 8) * CHANNELS;
	wav2->fmt->wBitsPerSample = out_smpl;
	wav_to_wav(wav1, wav2);
	wav_free(wav1); /* ϊWAVJ             */
	wav1 = wav2;    /* ϊWAV̕ϊɐݒ */
#undef CHANNELS

	/* o̓t@C쐬܂B */
	switch(out_type) {
	case TYPE_TEXT:
		fp = fopen(out_path, "wt");
		break;
	case TYPE_BINARY:
		fp = fopen(out_path, "wb");
		break;
	default:
		abort();
	}
	if(fp == NULL) die("%s쐬ł܂B", out_path);

	/* Cz̊JnB */
	if(out_type == TYPE_TEXT) {
		fprintf(fp, "const unsigned char %s[] = {\n", out_label);
	}

	/* f[^o͂܂B */
	switch(out_fmt) {
	case FMT_PCM:
		writepcm(fp, wav1);
		break;
	case FMT_ADPCM:
	case FMT_ADPCM_V:
		writeadpcm(fp, wav1);
		break;
	/*{{2006/12/19ǉ: 2bitADPCMώg(Ǝg)*/
	case FMT_ADPCM_X:
		writeadpcm2(fp, wav1);
		break;
	/*}}2006/12/19ǉ: 2bitADPCMώg(Ǝg)*/
	default:
		abort();
	}

	/* Cz̏IB */
	if(out_type == TYPE_TEXT) {
		fprintf(fp, "};\n");
	}

	/* o̓t@C܂B */
	fclose(fp);

	/* WAV\̂J܂B */
	wav_free(wav1);

	return 0;
}

/****************************************************************************
 *	usage
 ****************************************************************************/

void
usage()
{
	fprintf(stderr, "dppcmcnv - WAV to PPD converter (%s)\n", VERSION);
	fprintf(stderr, "Copyright (C) 2002-2006 Naoyuki Sawa\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "USAGE:\n");
	fprintf(stderr, "    dppcmcnv [options] <filename.wav>\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "TYPE OPTIONS:\n");
	fprintf(stderr, "    -t         eLXg\n");
	fprintf(stderr, "  * -b         oCi\n");
	fprintf(stderr, "FORMAT OPTIONS:                               --[bit]--  ---[gz]---\n");
	fprintf(stderr, "  * -fp[smpl]  PCM                            16or8        16000Œ\n");
	fprintf(stderr, "    -fa        ADPCM                          16->4Œ    16000Œ\n");
	fprintf(stderr, "    -fv[rate]  ADPCMώg                16->4Œ  1-16000\n");
	fprintf(stderr, "    -fx[rate]  2bitADPCMώg(Ǝg)  16->2Œ  1-16000\n");	/*{{2006/12/19ǉ: 2bitADPCMώg(Ǝg)}}*/
	fprintf(stderr, "    smplErateȗ́A̓t@CƓlɂȂ܂B\n");
	fprintf(stderr, "OTHER OPTIONS:\n");
	fprintf(stderr, "    -o<fname>  o̓t@C\n");
	fprintf(stderr, "    -l<label>  xieLXĝ݁j\n");
	fprintf(stderr, "    -p<prefix> xvtBNXieLXĝ݁j\n");
	fprintf(stderr, "    -q         bZ[W}\n");
	fprintf(stderr, "i* lj\n");
	exit(1);
}

/****************************************************************************
 *	die
 ****************************************************************************/

void
die(const char* fmt, ...)
{
	va_list ap;
	va_start(ap, fmt);
	 fprintf(stderr, "\n### ");
	vfprintf(stderr, fmt, ap);
	 fprintf(stderr, "\n");
	va_end(ap);
	exit(1);
}

/****************************************************************************
 *	cmdline
 ****************************************************************************/

void
cmdline(int argc, char* argv[])
{
	int i;
	char *opt, *p;

	for(i = 1; i < argc; i++) {
		opt = argv[i];
		if(opt[0] != '-') {
			/* ̓t@C */
			if(strlen(in_path) != 0) usage();
			strcpy(in_path, opt);
		} else {
			switch(opt[1]) {
			/* o̓t@C` */
			case 't':
				if(out_type != -1) usage();
				out_type = TYPE_TEXT;
				break;
			case 'b':
				if(out_type != -1) usage();
				out_type = TYPE_BINARY;
				break;
			/* o̓f[^` */
			case 'f':
				switch(opt[2]) {
				case 'p':
					if(out_fmt != -1) usage();
					out_fmt = FMT_PCM;
					/* ǉp[^=TvTCY */
					p = &opt[3];
					if(*p != '\0') {
						if(out_smpl != -1) usage();
						out_smpl = strtol(p, &p, 10);
						if(*p != '\0') usage();
						if(out_smpl != 8 && out_smpl != 16) usage();
					}
					break;
				case 'a':
					if(out_fmt != -1) usage();
					out_fmt = FMT_ADPCM;
					/* ǉp[^=Ȃ */
					p = &opt[3];
					if(*p != '\0') usage();
					break;
				case 'v':
					if(out_fmt != -1) usage();
					out_fmt = FMT_ADPCM_V;
					/* ǉp[^=g */
					p = &opt[3];
					if(*p != '\0') {
						if(out_rate != -1) usage();
						out_rate = strtol(p, &p, 10);
						if(*p != '\0') usage();
						if(out_rate < RATE_MIN || RATE_MAX < out_rate) usage();
					}
					break;
				/*{{2006/12/19ǉ: 2bitADPCMώg(Ǝg)*/
				case 'x':
					if(out_fmt != -1) usage();
					out_fmt = FMT_ADPCM_X;
					/* ǉp[^=g */
					p = &opt[3];
					if(*p != '\0') {
						if(out_rate != -1) usage();
						out_rate = strtol(p, &p, 10);
						if(*p != '\0') usage();
						if(out_rate < RATE_MIN || RATE_MAX < out_rate) usage();
					}
					break;
				/*}}2006/12/19ǉ: 2bitADPCMώg(Ǝg)*/
				default:
					usage();
				}
				break;
			/* o̓t@C */
			case 'o':
				if(strlen(out_path) != 0) usage();
				strcpy(out_path, &opt[2]);
				break;
			/* o̓x */
			case 'l':
				if(strlen(out_label) != 0) usage();
				strcpy(out_label, &opt[2]);
				break;
			case 'p':
				if(strlen(out_prefix) != 0) usage();
				strcpy(out_prefix, &opt[2]);
				break;
			/* bZ[W} */
			case 'q':
				if(msg != stdout) usage();
				msg = fopen(NULDEV, "wt");
				break;
			default:
				usage();
			}
		}
	}

	/* ̓t@C͕K{łB */
	if(strlen(in_path) == 0) usage();

	/* ̓t@C̊gqȗĂAu.wavvƂ܂B */
	_splitpath(in_path, drive, dir, fname, ext);
	if(strlen(ext) == 0) {
		_makepath(in_path, drive, dir, fname, ".wav");
	}

	/* o̓t@C`w肳ĂȂ΁AftHglݒ肵܂B */
	if(out_type == -1) out_type = TYPE_BINARY;

	/* o̓f[^`w肳ĂȂ΁AftHglݒ肵܂B */
	if(out_fmt == -1) out_fmt = FMT_PCM;

	/* o̓t@CȗĂA̓t@C琶܂B */
	if(strlen(out_path) == 0) {
		_splitpath(in_path, drive, dir, fname, ext);
		switch(out_type) {
		case TYPE_TEXT:
			_makepath(out_path, drive, dir, fname, ".c");
			break;
		case TYPE_BINARY:
			_makepath(out_path, drive, dir, fname, ".ppd");
			break;
		default:
			abort();
		}
	}

	/* o̓xȗĂA̓t@C琶܂B */
	if(strlen(out_label) == 0) {
		_splitpath(out_path, drive, dir, fname, ext);
		for(i = 0; fname[i] != '\0'; i++) {
			out_label[i] = toupper(fname[i]);
		}
	}
	if(strlen(out_prefix) != 0) {
		strcat(out_prefix, out_label); /* out_prefix͔j󂳂܂BgȂ̂őv */
		strcpy(out_label, out_prefix);
	}

	fprintf(msg, "IN  FILE : %s\n", in_path);
	fprintf(msg, "OUT FILE : %s\n", out_path);
	fprintf(msg, "OUT TYPE : %s\n", out_type_desc[out_type]);
	fprintf(msg, "OUT FMT  : %s", out_fmt_desc[out_fmt]);
	if(out_smpl != -1) fprintf(msg, "(%d)", out_smpl);
	if(out_rate != -1) fprintf(msg, "(%d)", out_rate);
	fprintf(msg, "\n");
	fprintf(msg, "OUT LABEL: %s\n", out_label);
	/* TvTCYƎg͓̓t@Cǂނ܂Ō܂Ȃ̂ŁAŕ\܂B */
}

/****************************************************************************
 *	writepcm
 ****************************************************************************/

/* eLXǵAĂ΂ꂽPʂŉŝŁAsƂɌĂяoĂB */
void
writedata(FILE* fp, void* data, int len)
{
	int i;
	unsigned char* p;

	switch(out_type) {
	case TYPE_TEXT:
		p = (unsigned char*)data;
		for(i = 0; i < len; i++) {
			fprintf(fp, "0x%02x,", *p++);
		}
		fprintf(fp, "\n");
		break;
	case TYPE_BINARY:
		fwrite(data, 1, len, fp);
		break;
	default:
		abort();
	}
}

/****************************************************************************
 *	writepcm
 ****************************************************************************/

void
writepcm(FILE* fp, WAV* wav)
{
	int ofs, len;
	PPDHDR hdr;
	PCEWAVEINFO info;

	/* wb_óB */
	if(out_type == TYPE_TEXT) fprintf(fp, "/*PPCM*/\n");
	memset(&hdr, 0, sizeof hdr);
	hdr.sig = PPDSIG;
	hdr.len = sizeof(PCEWAVEINFO) + wav->c_data;
	writedata(fp, &hdr, sizeof hdr);

	/* WAVEóB */
	if(out_type == TYPE_TEXT) fprintf(fp, "/*info*/\n");
	memset(&info, 0, sizeof info);
	info.stat = PW_STAT_START;
	switch(out_smpl) {
	case 8:
		info.type = PW_TYPE_8BITPCM;
		info.len = wav->c_data;
		break;
	case 16:
		info.type = PW_TYPE_16BITPCM;
		info.len = wav->c_data / 2;
		break;
	default:
		abort();
	}
	writedata(fp, &info, sizeof info);

	/* f[^óB */
	if(out_type == TYPE_TEXT) fprintf(fp, "/*data*/\n");
	ofs = 0;
	while(ofs < wav->c_data) {
		len = wav->c_data - ofs;
		if(len > LINEBYTES) len = LINEBYTES;
		writedata(fp, &wav->data[ofs], len);
		ofs += len;
	}
}

/****************************************************************************
 *	writeadpcm
 ****************************************************************************/

void
writeadpcm(FILE* fp, WAV* wav)
{
	int c_smpl, ofs, len;
	unsigned char* adp;
	PPDHDR hdr;
	PCEWAVEINFO info;

	/* ADPCM2TvPʂŕϊ̂ŁATv2TvPʂɐ؂グ܂B */
	c_smpl = wav->c_data / sizeof(short); /* ̃Tv */
	if(c_smpl & 1) { /* TvȂ... */
		c_smpl++; /* TvPʂɐ؂グ */
		wav->c_data = sizeof(short) * c_smpl; /* pfBOǉ */
		wav->data = (char*)realloc(wav->data, wav->c_data);
		if(wav->data == NULL) die("słB");
		((short*)wav->data)[c_smpl - 1] = 0; /* pfBONA */
	}

	/* ADPCMϊB */
	adp = (unsigned char*)malloc(c_smpl / 2);
	if(adp == NULL) die("słB");
	encode(adp, (short*)wav->data, wav->c_data);

	/* wb_óB */
	if(out_type == TYPE_TEXT) fprintf(fp, "/*PPCM*/\n");
	memset(&hdr, 0, sizeof hdr);
	hdr.sig = PPDSIG;
	hdr.len = sizeof(PCEWAVEINFO) + c_smpl / 2;
	writedata(fp, &hdr, sizeof hdr);

	/* WAVEóB */
	if(out_type == TYPE_TEXT) fprintf(fp, "/*info*/\n");
	memset(&info, 0, sizeof info);
	info.stat = PW_STAT_START;
	switch(out_fmt) {
	case FMT_ADPCM:
		info.type = PW_TYPE_ADPCM;
		info.len = c_smpl;
		break;
	case FMT_ADPCM_V:
		info.type = PW_TYPE_ADPCM_V;
		info.resv = out_rate; /* ώĝݐݒ */
		/* dvI
		 * ADPCMώglenݒ́ATvł͂܂I
		 * 16000HzZł̃TviĐb*16000jłI
		 * iC:\usr\PIECE\app\adpcm\hello.c 53sڂQƁj
		 */
		//info.len = c_smpl * RATE_DEFAULT / out_rate;
		//2006/07/17 oOC (I[o[t[)
		info.len = (int)((__int64)c_smpl * RATE_DEFAULT / out_rate);
		break;
	default:
		abort();
	}
	writedata(fp, &info, sizeof info);

	/* f[^óB */
	if(out_type == TYPE_TEXT) fprintf(fp, "/*data*/\n");
	ofs = 0;
	while(ofs < c_smpl / 2) {
		len = c_smpl / 2 - ofs;
		if(len > LINEBYTES) len = LINEBYTES;
		writedata(fp, &adp[ofs], len);
		ofs += len;
	}

	/* ADPCMf[^JB */
	free(adp);
}

/*{{2006/12/19ǉ: 2bitADPCMώg(Ǝg)*/

/****************************************************************************
 *	writeadpcm2
 ****************************************************************************/

void
writeadpcm2(FILE* fp, WAV* wav)
{
	int c_smpl, ofs, len;
	unsigned char* adp;
	PPDHDR hdr;
	PCEWAVEINFO info;

	/* 2bitADPCM4TvPʂŕϊ̂ŁATv4TvPʂɐ؂グ܂B */
	c_smpl = wav->c_data / sizeof(short); /* ̃Tv */
	while(c_smpl & 3) { /* Tv4̔{ɂȂ܂... */
		c_smpl++;   /* Tv1Â */
		wav->c_data = sizeof(short) * c_smpl; /* pfBOǉ */
		wav->data = (char*)realloc(wav->data, wav->c_data);
		if(wav->data == NULL) die("słB");
		((short*)wav->data)[c_smpl - 1] = 0; /* pfBONA */
	}

	/* ADPCMϊB */
	adp = (unsigned char*)malloc(c_smpl / 4);
	if(adp == NULL) die("słB");
	encode2(adp, (short*)wav->data, wav->c_data);

	/* wb_óB */
	if(out_type == TYPE_TEXT) fprintf(fp, "/*PPCM*/\n");
	memset(&hdr, 0, sizeof hdr);
	hdr.sig = PPDSIG;
	hdr.len = sizeof(PCEWAVEINFO) + c_smpl / 4;
	writedata(fp, &hdr, sizeof hdr);

	/* WAVEóB */
	if(out_type == TYPE_TEXT) fprintf(fp, "/*info*/\n");
	memset(&info, 0, sizeof info);
	info.stat = PW_STAT_START;
	switch(out_fmt) {
	case FMT_ADPCM_X:
		info.type = PW_TYPE_ADPCM_X;
		info.resv = out_rate;
		info.len = (int)((__int64)c_smpl * RATE_DEFAULT / out_rate);
		break;
	default:
		abort();
	}
	writedata(fp, &info, sizeof info);

	/* f[^óB */
	if(out_type == TYPE_TEXT) fprintf(fp, "/*data*/\n");
	ofs = 0;
	while(ofs < c_smpl / 4) {
		len = c_smpl / 4 - ofs;
		if(len > LINEBYTES) len = LINEBYTES;
		writedata(fp, &adp[ofs], len);
		ofs += len;
	}

	/* ADPCMf[^JB */
	free(adp);
}

/*}}2006/12/19ǉ: 2bitADPCMώg(Ǝg)*/
