/*
 *	jtsymbol.c
 *
 *	JoyToyC^v^
 *
 *	* Sun Jan 01 00:00:00 JST 2006 Naoyuki Sawa
 *	- 쐬JnB
 *	* Tue Jan 31 00:00:00 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 *	* Sat Jun 17 05:26:02 JST 2006 Naoyuki Sawa
 *	- FIELD_OFFSET()offsetof()ɕύXB
 */
#include "app.h"

/*****************************************************************************
 *	JTSYMBOL
 *****************************************************************************/

typedef struct _JTSYMBOL {
	int refcnt;
	JTCODE_INTERFACE* jtcode_interface;
	JTSYMBOL_INTERFACE* jtsymbol_interface;
	//
	char* name;	/*  */
} JTSYMBOL;

IMPLEMENT_JTCODE_INTERFACE(JTSYMBOL, jtsymbol)
IMPLEMENT_JTSYMBOL_INTERFACE(JTSYMBOL, jtsymbol)

const INTERFACE_MAP jtsymbol_interface_map[] = {
	{ JTCODE_INTERFACE_ID, offsetof(JTSYMBOL, jtcode_interface), &jtcode_interface },
	{ JTSYMBOL_INTERFACE_ID, offsetof(JTSYMBOL, jtsymbol_interface), &jtsymbol_interface },
	{ 0/*I[*/ },
};

/* V{Xg
 * C^v^ɑ݂V{̐A01ɕωƂɁAXg쐬܂B
 * C^v^ɑ݂V{̐A10ɕωƂɁAXg폜܂B
 */
static LIST/*<JTSYMBOL*>*/ * symbol_list;

JTCODE_INTERFACE**
jtsymbol_intern(const char* name)
{
	JTSYMBOL* this;
	//
	int i;
	int count;

	/* V{Xg쐬ς݂Ȃ... */
	if(symbol_list) {

		/* w肳ꂽOɑΉV{Aɑ݂Ȃ΁AԂ܂B
		 * Ă΁AJTSYMBOL_INTERFACE̓́A|C^rōs܂B
		 */
		count = list_size(symbol_list);
		if(!count) {
			DIE(); /* L蓾Ȃ */
		}
		for(i = 0; i < count; i++) {
			this = list_get(symbol_list, i);
			if(strcmp(this->name, name) == 0) {
				return safe_addref(&this->jtcode_interface); /* Ăяô߂+1 */
			}
		}

	/* V{Xg쐬Ȃ... */
	} else {

		/* V{Xg쐬܂B */
		symbol_list = list_create(&ptr_list_info);
	}

	/* w肳ꂽOɑΉV{AVK쐬܂B */
	this = calloc(1, sizeof(JTSYMBOL));
	if(!this) {
		DIE(); /* s */
	}
	this->refcnt = 1;
	apply_interface_map(this, jtsymbol_interface_map);

	/* O𕡐āAi[܂B */
	this->name = strdup(name);
	if(!this->name) {
		DIE(); /* s */
	}

	/* V{Xgɓo^܂B */
	list_add(symbol_list, this);

	return &this->jtcode_interface;
}

static void
jtsymbol_delete(JTSYMBOL* this)
{
	int i;
	int count;

	/* 폜V{AV{Xg猟... */
	if(!symbol_list) {
		DIE(); /* L蓾Ȃ */
	}
	count = list_size(symbol_list);
	if(!count) {
		DIE(); /* L蓾Ȃ */
	}
	for(i = 0; i < count; i++) {
		if(list_get(symbol_list, i) == this) {

			/* V{Xgo^܂B */
			list_remove(symbol_list, i);

			/* O܂B */
			free(this->name);

			free(this);

			/* Ō̈̃V{Ȃ΁AV{Xg폜܂B */
			if(count == 1) {
				list_delete(symbol_list);
				symbol_list = NULL; /* YȂ!! */
			}

			return;
		}
	}

	DIE(); /* L蓾Ȃ */
}

/*****************************************************************************
 *	JTCODE_INTERFACE
 *****************************************************************************/

static JTCODE_INTERFACE**
jtcode_run(JTCODE_INTERFACE** intf)
{
	JTSYMBOL* this = CONTAINING_RECORD(intf, JTSYMBOL, jtcode_interface);
	//
	JTCODE_INTERFACE** code = NULL;

	/* ̃V{ɑΉAϐ̒l擾܂B */
	safe_attach(code, joytoy_get_symbol_value(&this->jtsymbol_interface));
	if(!code) {
		DIE(); /* ` (ǂݍ񂾃vÕG[) */
	}

	return code;
}

/*****************************************************************************
 *	JTSYMBOL_INTERFACE
 *****************************************************************************/

static const char*
jtsymbol_get_name(JTSYMBOL_INTERFACE** intf)
{
	JTSYMBOL* this = CONTAINING_RECORD(intf, JTSYMBOL, jtsymbol_interface);

	/* OԂ܂B */
	return this->name;
}

