
;  GNU C 2.7.2 [AL 1.1, MM 40] RISC NEWS-OS compiled by CC

;  Cc1 defaults:
;  -mmemcpy

;  Cc1 arguments (-G value = 0, Cpu = 3000, ISA = 1):
;  -quiet -dumpbase -O2 -Wall -o

gcc2_compiled.:
__gnu_compiled_c:
; APP
	
		.code
		.align		1
		.global		sqrtf
sqrtf:
		sll		%r12, 1				; %r12 := eeeeeeee mmmmmmmm mmmmmmmm mmmmmmm0
		rl		%r12, 8				; %r12 := mmmmmmmm mmmmmmmm mmmmmmm0 eeeeeeee
	ext	0xff		; 		xand		%r10, %r12, 255			; %r10 := 00000000 00000000 00000000 eeeeeeee = exp
	and	%r10,%r12
		jreq		sqrtf_ret			; if(!exp) return 0 (rr %r10,1̓_~[ɂȂ)
		;//
		xor		%r12, %r10			; %r12 := mmmmmmmm mmmmmmmm mmmmmmm0 00000000
		or		%r12, 1				; %r12 := mmmmmmmm mmmmmmmm mmmmmmm0 00000001
		rr		%r12, 8				; %r12 := 00000001 mmmmmmmm mmmmmmmm mmmmmmm0 = HI(man1)
		;//
	ext	0x1		; 		xsub		%r10, %r10, 127			; %r10 := exp -= bias
	sub	%r10,0x3f
	ext	0x1		; 		xand		%r15, %r10, 1			; if(exp & 1)
	and	%r15,%r10
		rl		%r12, %r15			;   %r12 := 0000001m mmmmmmmm mmmmmmmm mmmmmm00 = HI(man1)
		sra		%r10, 1				; %r10 := exp >>= 1
	ext	0x1		; 		xadd		%r10, %r10, 127			; %r10 := exp += bias
	add	%r10,0x3f
		;//
		ld.w		%r11, 1				; %r11 := 00010000 00000000 00000000 00000000 = man2
		rr		%r11, 4
		ld.w		%r13, %r11			; %r13 := 00010000 00000000 00000000 00000000 = bit * 2
		ld.w		%r14, 23			; %r14 := i = 23
sqrtf_loop:							; do {
		mltu.w		%r11, %r11			;   {%alr,%ahr} := man2 ^ 2
		ld.w		%r15, %ahr			;   %r15 := HI(man2 ^ 2)
		cmp		%r15, %r12
		jrult		sqrtf_ult			;   if(man2 ^ 2 < man1) man2 += bit
		jrugt		sqrtf_ugt			;   if(man2 ^ 2 > man1) man2 -= bit
		ld.w		%r15, %alr			;   %r15 := LO(man2 ^ 2)
		cmp		%r15, 0
		jreq		sqrtf_exit			;   if(man2 ^ 2 == man1) break
sqrtf_ugt:
		sub		%r11, %r13			;   %r11 := man2 - bit * 2 (őE(man2 - bit)ɂȂ܂)
sqrtf_ult:
		rr		%r13, 1				;   %r13 := bit * 1
		sub		%r14, 1				; } while(--i)
		jrne.d		sqrtf_loop
		add		%r11, %r13			; %r11 := man2 + bit						*delay*
sqrtf_exit:
		sll		%r11, 4				; %r11 := mmmmmmmm mmmmmmmm mmmmmmm0 00000000
		or		%r10, %r11			; %r10 := mmmmmmmm mmmmmmmm mmmmmmm0 eeeeeeee
		rr		%r10, 8				; %r10 := eeeeeeee mmmmmmmm mmmmmmmm mmmmmmm0
sqrtf_ret:
		ret.d
		rr		%r10, 1				; %r10 := 0eeeeeee emmmmmmm mmmmmmmm mmmmmmmm			*delay*

	
		.code
		.align		1
		.global		modff
modff:
		;// %r12 := xval
		;// %r13 := intptr
		ld.w		%r10, %r12				; %r10 := x = xval
;//		ld.w		%r11, 0					; %r11 := y = 0 ----------------------------------+
		;// %r10 := x = xval					;                                                 |
		;// %r11 := y = 0					;                                                 |
		;// %r12 := xval					;                                                 |
		;// %r13 := intptr					;                                                 |
		rl		%r12, 1					; %r12 := eeeeeeee mmmmmmmm mmmmmmmm mmmmmmms     |
	ext	0x1		; 		xand		%r4, %r12, 1				; %r4  := 00000000 00000000 00000000 0000000s = s |
	and	%r4,%r12
		rl		%r12, 8					; %r12 := mmmmmmmm mmmmmmmm mmmmmmms eeeeeeee     |
	ext	0xff		; 		xand		%r5, %r12, 255				; %r5  := 00000000 00000000 00000000 eeeeeeee = e |
	and	%r5,%r12
	ext	0x1		; 		xcmp		%r5, 127				; if(e < 127) return [x, 0]                       |
	cmp	%r5,0x3f
		jrlt.d		modff_ret				;                                                 |
		ld.w		%r11, 0					; <-----------------------------------------------+		*delay*
		;// %r4  := s (0 or 1)
		;// %r5  := e (min = 127, max = 255)
		;// %r10 := x = xval
		;// %r11 := y = 0
		;// %r12 := mmmmmmmm mmmmmmmm mmmmmmms eeeeeeee
		;// %r13 := intptr
		ld.w		%r11, %r10				; %r11 := y = xval
;//		ld.w		%r10, 0					; %r10 := x = 0 -----------+
		;// %r4  := s (0 or 1)					;                          |
		;// %r5  := e (min = 127, max = 255)			;                          |
		;// %r10 := x = 0					;                          |
		;// %r11 := y = xval					;                          |
		;// %r12 := mmmmmmmm mmmmmmmm mmmmmmms eeeeeeee		;                          |
		;// %r13 := intptr					;                          |
	ext	0x2		; 		xld.w		%r6, 150				; %r6  := i = 150 - e      |
	ld.w	%r6,0x16
		sub		%r6, %r5				;                          |
		jrle.d		modff_ret				; if(i <= 0) return [0, x] |
		ld.w		%r10, 0					; <------------------------+					*delay*
		;// %r4  := s (0 or 1)
		;// %r5  := e (min = 127, max = 149)
		;// %r6  := i (min =   1, max =  23)
		;// %r10 := x = 0
		;// %r11 := y = xval
		;// %r12 := mmmmmmmm mmmmmmmm mmmmmmms eeeeeeee
		;// %r13 := intptr
		ld.w		%r7, -1					; %r7  := 11111111 11111111 11111111 11111111 = mask
		;//{{VARSHIFT
		cmp		%r6, 8					; %r6  := mask <<= i
		jrle		4
		sll		%r7, 8
		jp.d		-3
		sub		%r6, 8					;								*delay*
		sll		%r7, %r6
		;//}}VARSHIFT
		not		%r6, %r7				; %r6  := ~mask << 9
	sll	%r6,0x8		; 		xsll		%r6, 9
	sll	%r6,0x1
		;// %r4  := s (0 or 1)
		;// %r5  := e (min = 127, max = 149)
		;// %r6  := 00000000 00000000 00000010 00000000 (i =  1)
		;//         00000000 00000000 00000110 00000000 (i =  2)
		;//         00000000 00000000 00001110 00000000 (i =  3)
		;//                          .
		;//                          .
		;//                          .
		;//         00111111 11111111 11111110 00000000 (i = 21)
		;//         01111111 11111111 11111110 00000000 (i = 22)
		;//         11111111 11111111 11111110 00000000 (i = 23)
		;// %r7  := 11111111 11111111 11111111 11111110 (i =  1)
		;//         11111111 11111111 11111111 11111100 (i =  2)
		;//         11111111 11111111 11111111 11111000 (i =  3)
		;//                          .
		;//                          .
		;//                          .
		;//         11111111 11100000 00000000 00000000 (i = 21)
		;//         11111111 11000000 00000000 00000000 (i = 22)
		;//         11111111 10000000 00000000 00000000 (i = 23)
		;// %r10 := x = 0
		;// %r11 := y
		;// %r12 := mmmmmmmm mmmmmmmm mmmmmmms eeeeeeee
		;// %r13 := intptr
		and		%r12, %r6				; %r12 := mmmmmmmm mmmmmmmm mmmmmmms eeeeeeee & (~mask << 9)
		jreq.d		modff_ret				; if(!m) return [0, y]
		and		%r11, %r7				; %r11 := y = x & mask						*delay*
		;// %r4  := s (0 or 1)
		;// %r5  := e (min = 127, max = 149)
		;// %r10 := x = 0
		;// %r11 := y
		;// %r12 := mmmmmmmm mmmmmmmm mmmmmmm0 00000000
		;// %r13 := intptr
		;//{{VARSCAN
		scan1		%r6, %r12
		sll		%r12, %r6
		jrult.d		-2
		sub		%r5, %r6				;								*delay*
		;//}}VARSCAN
		;// %r4  := s (0 or 1)
		;// %r5  := e (min = 127 - 22, max = 149 - 0)
		;// %r10 := x = 0
		;// %r11 := y
		;// %r12 := 1mmmmmmm mmmmmmmm mmmmmmm0 00000000
		;// %r13 := intptr
		sub		%r5, 1					; %r5  := e-- (min = 127 - 23, max = 149 - 1)
		sll		%r12, 1					; %r12 := mmmmmmmm mmmmmmmm mmmmmm00 00000000
		or		%r12, %r5				; %r12 := mmmmmmmm mmmmmmmm mmmmmm00 eeeeeeee
		rr		%r12, 8					; %r12 := eeeeeeee mmmmmmmm mmmmmmmm mmmmmm00
		or		%r12, %r4				; %r12 := eeeeeeee mmmmmmmm mmmmmmmm mmmmmm0s
		rr		%r12, 1					; %r12 := seeeeeee emmmmmmm mmmmmmmm mmmmmmm0
		ld.w		%r10, %r12				; %r10 := seeeeeee emmmmmmm mmmmmmmm mmmmmmm0
modff_ret:
		;// %r10 := x
		;// %r11 := y
		;// %r13 := intptr
		ld.w		[%r13], %r11				; *intptr = y
		ret

	
		.code
		.align		1
		.global		fmodf
fmodf:
		;// %r12    := x
		;// %r13    := y
		;//-----------------------------------------------------;
		ld.w		%r10, %r12				; %r10 :=  x
		ld.w		%r11, %r13				; %r11 :=  y
		sll		%r10, 1					; %r10 := |x| << 1
		sll		%r11, 1					; %r11 := |y| << 1
		sub		%r10, %r11				; if(|x| >  |y|) goto ugt
		jrugt		fmodf_ugt
		;//-----------------------------------------------------;
		jreq		fmodf_ret				; if(|x| == |y|) return 0 (%r10͊0ł)
		;//-----------------------------------------------------;
		jp.d		fmodf_ret				; if(|x| <  |y|) return x
		ld.w		%r10, %r12				; %r10 := x							*delay*
fmodf_ugt:	;//-----------------------------------------------------;
	sub	%sp,0x2		; 		xsub		%sp, %sp, 8
	ld.w	[%sp+0x1],%r13	; 		xld.w		[%sp+4], %r13				; [%sp+4] := y
		;// %r12    := x
		;// %r13    := y
		;// [%sp+4] := y
	ext	__divsf3@rm	; 		xcall		__divsf3				; %r10 :=      x / y
	call	__divsf3@rl
		;// %r10    := x / y
		;// [%sp+4] := y
		ld.w		%r13, %sp				; %r13 :=             &dummy
	call.d	modff		; 		xcall.d		modff					; %r10 := modf(x / y, &dummy)
		ld.w		%r12, %r10				; %r12 :=      x / y						*delay*
		;// %r10    := modf(x / y, &dummy)
		;// [%sp+0] := dummy
		;// [%sp+4] := y
	ld.w	%r12,[%sp+0x1]	; 		xld.w		%r12, [%sp+4]				; %r12 :=                       y
	ext	__mulsf3@rm	; 		xcall.d		__mulsf3				; %r10 := modf(x / y, &dummy) * y
	call.d	__mulsf3@rl
		ld.w		%r13, %r10				; %r13 := modf(x / y, &dummy)					*delay*
		;// %r10    := modf(x / y, &dummy) * y
	add	%sp,0x2		; 		xadd		%sp, %sp, 8
fmodf_ret:	;//-----------------------------------------------------;
		ret

	
		.code
		.align		1
		.global		cosf
		.global		sinf
		.global		tanf
tanf:		;//-------------------------------------;
		pushn		%r0
		call.d		sinf			; %r10 := sinf(x)
		ld.w		%r0, %r12		; %r0  :=                x			*delay*
		ld.w		%r12, %r0		; %r12 :=                x
		call.d		cosf			; %r10 :=           cosf(x)
		ld.w		%r0, %r10		; %r0  := sinf(x)				*delay*
		ld.w		%r12, %r0		; %r12 := sinf(x)
		popn		%r0
	ext	__divsf3@rm	; 		xjp.d		__divsf3		; %r10 := sinf(x) / cosf(x)
	jp.d	__divsf3@rl
		ld.w		%r13, %r10		; %r13 :=           cosf(x)			*delay*
cosf:		;//-------------------------------------;
		jp.d		cosf_sinf
		ld.w		%r4, 0			; %r4  := d = cos_sin = 0			*delay*
sinf:		;//-------------------------------------;
		ld.w		%r4, 1			; %r4  := d = cos_sin = 1
cosf_sinf:	;//-------------------------------------;
		pushn		%r0
		;// %r4  := d
		;// %r12 := x
	ext	0x819		; 		xld.w		%r13,0x40c90fdb		; %r10 := x = fmodf(x, 6.283185307179586476925286766559f)
	ext	0x43f
	ld.w	%r13,0x1b
	call.d	fmodf		; 		xcall.d		fmodf
		ld.w		%r0, %r4		; %r0  := d					*delay*
		;// %r0  := d
		;// %r10 := x
		ld.w		%r4, 0			; %r4  := a = 0.0f
	ext	0x7f0		; 		xld.w		%r5, 0x3f800000		; %r5  := c = 1.0f
	ext	0x0
	ld.w	%r5,0x0
		cmp		%r0, 0			; if(d)
		jreq.d		3
		 ld.w		%r6, %r5		; %r6  := b = 1.0f				*delay*
		 ld.w		%r6, %r10		;   %r6  := b = x
		;// %r0  := d
		;// %r4  := a
		;// %r5  := c
		;// %r6  := b
		;// %r10 := x
		ld.w		%r12, %r10		; %r10 := x *= x
	ext	__mulsf3@rm	; 		xcall.d		__mulsf3
	call.d	__mulsf3@rl
		ld.w		%r13, %r10		;						*delay*
		ld.w		%r7, %r10		; %r7  := x
		;// %r0  := d
		;// %r4  := a
		;// %r5  := c
		;// %r6  := b
		;// %r7  := x
cosf_sinf_loop:
		;// %r0  := d
		;// %r4  := a
		;// %r5  := c
		;// %r6  := b
		;// %r7  := x
		ld.w		%r12, %r6		; %r10 := b / c
	ext	__divsf3@rm	; 		xcall.d		__divsf3
	call.d	__divsf3@rl
		ld.w		%r13, %r5		;						*delay*
		;// %r0  := d
		;// %r4  := a
		;// %r5  := c
		;// %r6  := b
		;// %r7  := x
		;// %r10 := b / c
		ld.w		%r12, %r4		; %r4  := a -> aa
	ext	__addsf3@rm	; 		xcall.d		__addsf3		; %r10 := a += b / c
	call.d	__addsf3@rl
		ld.w		%r13, %r10		;						*delay*
		;// %r0  := d
		;// %r4  := aa
		;// %r5  := c
		;// %r6  := b
		;// %r7  := x
		;// %r10 := a
		cmp		%r10, %r4		; if(a == aa) break
		jreq		cosf_sinf_ret
		;//
		ld.w		%r4, %r10		; %r4  := a
		;// %r0  := d
		;// %r4  := a
		;// %r5  := c
		;// %r6  := b
		;// %r7  := x
		ld.w		%r12, %r6		; %r10 := b *= x
	ext	__mulsf3@rm	; 		xcall.d		__mulsf3
	call.d	__mulsf3@rl
		ld.w		%r13, %r7		;						*delay*
		ld.w		%r6, %r10		; %r6  := b
		;//
		not		%r12, %r0		; %r12 := ~d =   - (d + 1)
		add		%r0, 2			; %r0  :=  d =               (d + 2)
		mlt.h		%r12, %r0		; %alr :=        -((d + 1) * (d + 2))
	ext	__floatsisf@rm	; 		xcall.d		__floatsisf		; %r10 := (float)-((d + 1) * (d + 2))
	call.d	__floatsisf@rl
		ld.w		%r12, %alr		;						*delay*
		;//
		ld.w		%r12, %r5		; %r10 := c *= (float)-((d + 1) * (d + 2))
	ext	__mulsf3@rm	; 		xcall.d		__mulsf3
	call.d	__mulsf3@rl
		ld.w		%r13, %r10		;						*delay*
		;//
		jp.d		cosf_sinf_loop
		ld.w		%r5, %r10		; %r5  := c					*delay*
cosf_sinf_ret:
		;// %r10 := a
		popn		%r0
		ret

	
		.code
		.align		1
		.global		atanf
atanf:
		pushn		%r0
		ld.w		%r10, %r12		; %r10 := seeeeeee emmmmmmm mmmmmmmm mmmmmmmm = x
		;//
		rl		%r10, 1			; %r10 := eeeeeeee mmmmmmmm mmmmmmmm mmmmmmms
		ld.w		%r0, %r10		; %r0  := eeeeeeee mmmmmmmm mmmmmmmm mmmmmmms
		srl		%r10, 1			; %r10 := 0eeeeeee emmmmmmm mmmmmmmm mmmmmmmm = x = |x|
		;//
	ext	0x7f0		; 		xld.w		%r12, 0x3f800000	; %r12 := 1.0f
	ext	0x0
	ld.w	%r12,0x0
		cmp		%r10, %r12		; if(x > 1.0f)
		jrle.d		atanf_L1
		 and		%r0, 1			; %r0  := 00000000 00000000 00000000 0000000s		*delay*
		 or		%r0, 2			;   %r0  := 00000000 00000000 00000000 000000ts
	ext	__divsf3@rm	; 		 xcall.d	__divsf3		;   %r10 := x = 1.0f / x
	call.d	__divsf3@rl
		 ld.w		%r13, %r10		;							*delay*
atanf_L1:
		;//
	call.d	atanf_sub	; 		xcall.d		atanf_sub		; %r10 := x = atanf_sub(x)
		ld.w		%r12, %r10		;							*delay*
		;//
		rr		%r0, 2			; %r0  := ts000000 00000000 00000000 00000000
		add		%r0, %r0		; %r0  := s0000000 00000000 00000000 00000000, C = t
		jruge		atanf_L2		; if(t)
	ext	0x7f9		; 		 xld.w		%r12, 0x3fc90fdb	;   %r10 := x = /2 - x
	ext	0x43f
	ld.w	%r12,0x1b
	ext	__subsf3@rm	; 		 xcall.d	__subsf3
	call.d	__subsf3@rl
		 ld.w		%r13, %r10		;							*delay*
atanf_L2:
		;//
		xor		%r10, %r0		; if(s) x = -x
		popn		%r0
		ret

	
		.code
		.align		1
		.global		atan2f
atan2f:
		pushn		%r0
		;//
		add		%r13, %r13		; %r13 := eeeeeeee mmmmmmmm mmmmmmmm mmmmmmm0 = (|x| << 1), C = s
		adc		%r0, %r0		; %r0  := ???????? ???????? ???????? ???????x (x = revx)
		srl		%r13, 1			; %r13 := 0eeeeeee emmmmmmm mmmmmmmm mmmmmmmm = |x|
		;//
		add		%r12, %r12		; %r12 := eeeeeeee mmmmmmmm mmmmmmmm mmmmmmm0 = (|y| << 1), C = s
		adc		%r0, %r0		; %r0  := ???????? ???????? ???????? ??????xy (y = revy)
		srl		%r12, 1			; %r12 := 0eeeeeee emmmmmmm mmmmmmmm mmmmmmmm = |y|
		;//
		cmp		%r12, %r13		; if(|y| > |x|) {
		jrule.d		6
		 and		%r0, 3			; %r13 := 00000000 00000000 00000000 000000xy				*delay*
		 or		%r0, 4			;   %r13 := 00000000 00000000 00000000 00000zxy (z = xchg)
		 xor		%r12, %r13
		 xor		%r13, %r12		;   %r13 := |y|
		 xor		%r12, %r13		;   %r12 := |x|
		;---------------------------------------;
;//{{__divsf3́A0/0=0Ԃ悤ɍĂ̂ŁA̔ȗČpĂʂ܂B
;//		cmp		%r13, 0			; if(|x| == 0.0f) return 0.0f
;//		jreq.d		atan2f_ret
;//		ld.w		%r10, 0			; 򂵂ȂƂ̓_~[B						*delay*
;//}}__divsf3́A0/0=0Ԃ悤ɍĂ̂ŁA̔ȗČpĂʂ܂B
		;//
	ext	__divsf3@rm	; 		xcall.d		__divsf3		; %r10 := tan() = |y| / |x| (0.0f <= tan() <= 1.0f)
	call.d	__divsf3@rl
		rr		%r0, 3			; %r0  := zxy00000 00000000 00000000 00000000				*delay*
		;//
	call.d	atanf_sub	; 		xcall.d		atanf_sub		; %r10 :=  (0.0f <=  <= /4)
		ld.w		%r12, %r10		;									*delay*
		;---------------------------------------;
		add		%r0, %r0		; %r0  := xy000000 00000000 00000000 00000000, C = xchg
		jruge		atan2f_L1		; if(xchg)
	ext	0x7f9		; 		 xld.w		%r12, 0x3fc90fdb	;   %r10 :=  = /2 -  (0.0f <=  <= /2)
	ext	0x43f
	ld.w	%r12,0x1b
	ext	__subsf3@rm	; 		 xcall.d	__subsf3
	call.d	__subsf3@rl
		 ld.w		%r13, %r10		;									*delay*
atan2f_L1:
		;//
		add		%r0, %r0		; %r0  := y0000000 00000000 00000000 00000000, C = revx
		jruge		atan2f_L2		; if(revx)
	ext	0x809		; 		 xld.w		%r12, 0x40490fdb	;   %r10 :=  =  -  (0.0f <=  <= )
	ext	0x43f
	ld.w	%r12,0x1b
	ext	__subsf3@rm	; 		 xcall.d	__subsf3
	call.d	__subsf3@rl
		 ld.w		%r13, %r10		;									*delay*
atan2f_L2:
		;//
		xor		%r10, %r0		; if(revy)  = - (- <=  <= )
;//atan2f_ret:
		popn		%r0
		ret

	
		.code
		.align		1
atanf_sub:
	ext	0x7da		; 		xld.w		%r4, 0x3ed413cd			; %r4  := 2-1
	ext	0x104f
	ld.w	%r4,0xd
		;// %r4  := 2-1
		ld.w		%r5, %r12			; %r5  := x
	ext	__subsf3@rm	; 		xcall.d		__subsf3			; %r10 := x - (2-1)
	call.d	__subsf3@rl
		ld.w		%r13, %r4			;						*delay*
		;// %r4  := 2-1
		;// %r5  := x
		;// %r10 := x - (2-1)
		ld.w		%r12, %r5			; %r10 := x * (2-1)
		ld.w		%r5, %r10			; %r5  := x - (2-1)
	ext	__mulsf3@rm	; 		xcall.d		__mulsf3
	call.d	__mulsf3@rl
		ld.w		%r13, %r4			;						*delay*
		;// %r5  := x - (2-1)
		;// %r10 := x * (2-1)
	ext	0x7f0		; 		xld.w		%r13, 0x3f800000		; %r10 := x * (2-1) + 1
	ext	0x0
	ld.w	%r13,0x0
	ext	__addsf3@rm	; 		xcall.d		__addsf3
	call.d	__addsf3@rl
		ld.w		%r12, %r10			;						*delay*
		;// %r5  := x - (2-1)
		;// %r10 := x * (2-1) + 1
		ld.w		%r12, %r5			; %r10 := x = (x - (2-1)) / (x * (2-1) + 1)
	ext	__divsf3@rm	; 		xcall.d		__divsf3
	call.d	__divsf3@rl
		ld.w		%r13, %r10			;						*delay*
		;// %r10 := x
		ld.w		%r4, %r10			; %r4  := a = x
		ld.w		%r5, %r10			; %r5  := b = x
		ld.w		%r6, 1				; %r6  := c = 1
		ld.w		%r12, %r10			; %r7  := x = -(x * x)
	ext	__mulsf3@rm	; 		xcall.d		__mulsf3
	call.d	__mulsf3@rl
		ld.w		%r13, %r10			;						*delay*
	ld.w	%r7,%r10	; 		xxor		%r7, %r10, 0x80000000
	ext	0x1000
	ext	0x0
	xor	%r7,0x0
		;// %r4  := a
		;// %r5  := b
		;// %r6  := c
		;// %r7  := x
atanf_sub_loop:
		ld.w		%r12, %r5			; %r5  := b *= x
	ext	__mulsf3@rm	; 		xcall.d		__mulsf3
	call.d	__mulsf3@rl
		ld.w		%r13, %r7			;						*delay*
		ld.w		%r5, %r10
		;// %r4  := a
		;// %r5  := b
		;// %r6  := c
		;// %r7  := x
		add		%r6, 2				; %r6  := c += 2
	ext	__floatsisf@rm	; 		xcall.d		__floatsisf			; %r10 := (float)c
	call.d	__floatsisf@rl
		ld.w		%r12, %r6			;						*delay*
		;// %r4  := a
		;// %r5  := b
		;// %r6  := c
		;// %r7  := x
		;// %r10 := (float)c
		ld.w		%r12, %r5			; %r10 := b / (float)c
	ext	__divsf3@rm	; 		xcall.d		__divsf3
	call.d	__divsf3@rl
		ld.w		%r13, %r10			;						*delay*
		;// %r4  := a
		;// %r5  := b
		;// %r6  := c
		;// %r7  := x
		;// %r10 := b / (float)c
		ld.w		%r12, %r4			; %r4  := a -> aa
	ext	__addsf3@rm	; 		xcall.d		__addsf3			; %r10 := a += b / (float)c
	call.d	__addsf3@rl
		ld.w		%r13, %r10			;						*delay*
		;// %r4  := aa
		;// %r5  := b
		;// %r6  := c
		;// %r7  := x
		;// %r10 := a
		cmp		%r10, %r4			; if(a == aa) break
		jrne.d		atanf_sub_loop
		ld.w		%r4, %r10			; %r4  := a					*delay*
		;// %r4  := a
	ext	0x7d9		; 		xld.w		%r13, 0x3ec90fdb		; %r10 := a + /8
	ext	0x43f
	ld.w	%r13,0x1b
	ext	__addsf3@rm	; 		xjp.d		__addsf3
	jp.d	__addsf3@rl
		ld.w		%r12, %r4			;						*delay*

	
		.code
		.align		1
		.global		expf
expf:
		pushn		%r1
		;// %r12 := x
	ext	0x7f7		; 		xld.w		%r13, 0x3fb8aa3b	; %r10 := x *= 1.4426950408889634073599247e0f
	ext	0x2a8
	ld.w	%r13,0x3b
	ext	__mulsf3@rm	; 		xcall		__mulsf3
	call	__mulsf3@rl
		ld.w		%r4, %r10		; %r4  := x
		;// %r4  := x
	ext	__fixsfsi@rm	; 		xcall.d		__fixsfsi		; %r10 := y = (int)x
	call.d	__fixsfsi@rl
		ld.w		%r12, %r4		;							*delay*
		ld.w		%r5, %r10		; %r5  := y
		;// %r4  := x
		;// %r5  := y
	ext	__floatsisf@rm	; 		xcall.d		__floatsisf		; %r10 :=      (float)y
	call.d	__floatsisf@rl
		ld.w		%r12, %r5		;							*delay*
		;// %r4  := x
		;// %r5  := y
		;// %r10 := (float)y
		ld.w		%r12, %r4		; %r10 := x -= (float)y
	ext	__subsf3@rm	; 		xcall.d		__subsf3
	call.d	__subsf3@rl
		ld.w		%r13, %r10		;							*delay*
		;// %r5  := y
		;// %r10 := x
	ext	0x7e6		; 		xld.w		%r13, 0x3f317218	; %r10 := x *= 6.93147180559945309417e-1f
	ext	0x5c8
	ld.w	%r13,0x18
	ext	__mulsf3@rm	; 		xcall.d		__mulsf3
	call.d	__mulsf3@rl
		ld.w		%r12, %r10		;							*delay*
		ld.w		%r4, %r10		; %r4  := x
		;// %r4  := x
		;// %r5  := y
	ext	0x7f0		; 		xld.w		%r6, 0x3f800000		; %r6  := a = 1.0f
	ext	0x0
	ld.w	%r6,0x0
		ld.w		%r7, %r6		; %r7  := b = 1.0f
		ld.w		%r0, 1			; %r0  := c = 1
		ld.w		%r1, 1			; %r1  := d = 1
		;// %r0  := c
		;// %r1  := d
		;// %r4  := x
		;// %r5  := y
		;// %r6  := a
		;// %r7  := b
expf_loop:
		;// %r0  := c
		;// %r1  := d
		;// %r4  := x
		;// %r5  := y
		;// %r6  := a
		;// %r7  := b
		ld.w		%r13, %r4		; %r10 := b *= x
	ext	__mulsf3@rm	; 		xcall.d		__mulsf3
	call.d	__mulsf3@rl
		ld.w		%r12, %r7		;							*delay*
		ld.w		%r7, %r10		; %r7  := b
		;//
		mlt.w		%r0, %r1		; %r0  := c *= d	(mlt.hł͌sɂȂ̂Ń_)
		ld.w		%r0, %alr
		;//
	ext	__floatsisf@rm	; 		xcall.d		__floatsisf		; %r10 :=          (float)c
	call.d	__floatsisf@rl
		ld.w		%r12, %r0		;							*delay*
		;// %r0  := c
		;// %r1  := d
		;// %r4  := x
		;// %r5  := y
		;// %r6  := a
		;// %r7  := b
		;// %r10 := (float)c
		ld.w		%r12, %r7		; %r10 :=      b / (float)c
	ext	__divsf3@rm	; 		xcall.d		__divsf3
	call.d	__divsf3@rl
		ld.w		%r13, %r10		;							*delay*
		;// %r0  := c
		;// %r1  := d
		;// %r4  := x
		;// %r5  := y
		;// %r6  := a
		;// %r7  := b
		;// %r10 := b / (float)c
		ld.w		%r12, %r6		; %r6  := a -> aa
	ext	__addsf3@rm	; 		xcall.d		__addsf3		; %r10 := a += b / (float)c
	call.d	__addsf3@rl
		ld.w		%r13, %r10		;							*delay*
		;// %r0  := c
		;// %r1  := d
		;// %r4  := x
		;// %r5  := y
		;// %r6  := aa
		;// %r7  := b
		;// %r10 := a
		cmp		%r10, %r6		; if(a != aa) goto loop
		ld.w		%r6, %r10		; %r6  := a
		jrne.d		expf_loop
		add		%r1, 1			; %r1  := d++						*delay*
		;// %r5  := y
		;// %r6  := a
		popn		%r1
		;//
		ld.w		%r12, %r6		; %r10 := ldexpf(a, y)
	jp.d	ldexpf		; 		xjp.d		ldexpf
		ld.w		%r13, %r5		;							*delay*

	
		.code
		.align		1
		.global		ldexpf
ldexpf:
	rl	%r12,0x8	; 		xrl		%r12, 9			; %r12 := mmmmmmmm mmmmmmmm mmmmmmms eeeeeeee
	rl	%r12,0x1
	ext	0xff		; 		xand		%r10, %r12, 255		; %r10 := 00000000 00000000 00000000 eeeeeeee = e
	and	%r10,%r12
		jreq		ldexpf_ret0		; if(!e) return 0.0f
		xor		%r12, %r10		; %r12 := mmmmmmmm mmmmmmmm mmmmmmms 00000000
		add		%r10, %r13		; %r10 := e += exp
		jrle		ldexpf_ret0		; if(e <= 0) return 0.0f
		or		%r10, %r12		; %r12 := mmmmmmmm mmmmmmmm mmmmmmms eeeeeeee
		rr		%r10, 8			; %r10 := eeeeeeee mmmmmmmm mmmmmmmm mmmmmmms
		ret.d
		rr		%r10, 1			; %r10 := seeeeeee emmmmmmm mmmmmmmm mmmmmmmm		*delay*
ldexpf_ret0:
		ret.d
		ld.w		%r10, 0			;							*delay*

	
		.code
		.align		1
		.global		frexpf
frexpf:
	rl	%r12,0x8	; 		xrl		%r12, 9			; %r12 := mmmmmmmm mmmmmmmm mmmmmmms eeeeeeee (e = bias + exp)
	rl	%r12,0x1
		ld.ub		%r10, %r12		; %r10 := e = bias + exp
		sub		%r10, 1			; %r10 := e = bias + exp - 1
		jrle		frexpf_ret0		; if(e <= 0) return 0
	ext	0x1		; 		xsub		%r10, %r10, 125		; %r10 := e = exp + 1
	sub	%r10,0x3d
		ld.w		[%r13], %r10		; [%r13] := *expptr = exp + 1
		sub		%r12, %r10		; %r12 := mmmmmmmm mmmmmmmm mmmmmmms eeeeeeee (e = bias - 1)
	rr	%r12,0x8	; 		xrr		%r12, 9			; %r12 := seeeeeee emmmmmmm mmmmmmmm mmmmmmmm
	rr	%r12,0x1
		ret.d
		ld.w		%r10, %r12		; %r10 := seeeeeee emmmmmmm mmmmmmmm mmmmmmmm			*delay*
frexpf_ret0:
		ld.w		[%r13], %r8		; [%r13] := *expptr = 0
		ret.d
		ld.w		%r10, 0			; %r10 := return 0						*delay*

	
		.code
		.align		1
		.global		logf
logf:
	sub	%sp,0x1		; 		xsub		%sp, %sp, 4
		;// %r12 := x
		ld.w		%r13, %sp			; %r10 := x = frexpf(x, &y)
	call	frexpf		; 		xcall		frexpf
		ld.w		%r4, %r10			; %r4  := x
		;// %r4   := x
		;// [%sp] := y
	ext	0x7e0		; 		xld.w		%r13, 0x3f000000		; if(x < 0.5f) return 0
	ext	0x0
	ld.w	%r13,0x0
	ext	__fcmps@rm	; 		xcall.d		__fcmps
	call.d	__fcmps@rl
		ld.w		%r12, %r4			;					*delay*
		jrlt		logf_ret0
		;//
	ext	0x7e6		; 		xld.w		%r13, 0x3f3504f3		; if(x < 1/22)
	ext	0x1413
	ld.w	%r13,0x33
	ext	__fcmps@rm	; 		xcall.d		__fcmps
	call.d	__fcmps@rl
		ld.w		%r12, %r4			;					*delay*
	ld.w	%r12,[%sp+0x0]	; 		xld.w		%r12, [%sp]			; %r12 := y
		jrge		logf_L1
	ext	0x10		; 		 xadd		%r4, %r4, 0x00800000		;   %r4  := x *= 2.0f
	ext	0x0
	add	%r4,0x0
		 sub		%r12, 1				;   %r12 := y--
logf_L1:
		;// %r4  := x
		;// %r12 := y
	ext	__floatsisf@rm	; 		xcall		__floatsisf			; %r10 := (float)y
	call	__floatsisf@rl
		;// %r4  := x
		;// %r10 := (float)y
	ext	0x7e6		; 		xld.w		%r12, 0x3f317218		; %r10 := a = ln(2) * (float)y
	ext	0x5c8
	ld.w	%r12,0x18
	ext	__mulsf3@rm	; 		xcall.d		__mulsf3
	call.d	__mulsf3@rl
		ld.w		%r13, %r10			;					*delay*
		ld.w		%r5, %r10			; %r5  := a
		;// %r4  := x
		;// %r5  := a
	ext	0x7f0		; 		xld.w		%r6, 0x3f800000			; %r6  :=          1.0f
	ext	0x0
	ld.w	%r6,0x0
		ld.w		%r12, %r4			; %r10 :=     (x - 1.0f)
	ext	__subsf3@rm	; 		xcall.d		__subsf3
	call.d	__subsf3@rl
		ld.w		%r13, %r6			;					*delay*
		;// %r4  := x
		;// %r5  := a
		;// %r6  := 1.0f
		;// %r10 := (x - 1.0f)
		ld.w		%r12, %r4			; %r10 :=                  (x + 1.0f)
		ld.w		%r4, %r10			; %r4  :=     (x - 1.0f)
	ext	__addsf3@rm	; 		xcall.d		__addsf3
	call.d	__addsf3@rl
		ld.w		%r13, %r6			;					*delay*
		;// %r4  := (x - 1.0f)
		;// %r5  := a
		;// %r10 := (x + 1.0f)
		ld.w		%r12, %r4			; %r10 := x = (x - 1.0f) / (x + 1.0f)
	ext	__divsf3@rm	; 		xcall.d		__divsf3
	call.d	__divsf3@rl
		ld.w		%r13, %r10			;					*delay*
		;// %r5  := a
		;// %r10 := x
	ext	0x400		; 		xadd		%r6, %r10, 0x00800000		; %r6  := b = x * 2.0f
	ext	0x0
	add	%r6,%r10
		;// %r5  := a
		;// %r6  := b
		;// %r10 := x
		ld.w		%r12, %r10			; %r10 := x *= x
	ext	__mulsf3@rm	; 		xcall.d		__mulsf3
	call.d	__mulsf3@rl
		ld.w		%r13, %r10			;					*delay*
		ld.w		%r4, %r10			; %r4  := x
		;// %r4  := x
		;// %r5  := a
		;// %r6  := b
		ld.w		%r7, 1				; %r7  := c = 1
		;// %r4  := x
		;// %r5  := a
		;// %r6  := b
		;// %r7  := c
logf_loop:
	ext	__floatsisf@rm	; 		xcall.d		__floatsisf			; %r10 := (float)c
	call.d	__floatsisf@rl
		ld.w		%r12, %r7			;					*delay*
		;// %r4  := x
		;// %r5  := a
		;// %r6  := b
		;// %r7  := c
		;// %r10 := (float)c
		ld.w		%r12, %r6			; %r10 := b / (float)c
	ext	__divsf3@rm	; 		xcall.d		__divsf3
	call.d	__divsf3@rl
		ld.w		%r13, %r10			;					*delay*
		;// %r4  := x
		;// %r5  := a
		;// %r6  := b
		;// %r7  := c
		;// %r10 := b / (float)c
		ld.w		%r12, %r5			; %r5  := a -> aa
	ext	__addsf3@rm	; 		xcall.d		__addsf3			; %r10 := a += b / (float)c
	call.d	__addsf3@rl
		ld.w		%r13, %r10			;					*delay*
		;// %r4  := x
		;// %r5  := aa
		;// %r6  := b
		;// %r7  := c
		;// %r10 := a
		cmp		%r10, %r5			; if(a == aa) break
		jreq		logf_ret
		ld.w		%r5, %r10			; %r5  := a
		;// %r4  := x
		;// %r5  := a
		;// %r6  := b
		;// %r7  := c
		ld.w		%r12, %r6			; %r10 := b *= x
	ext	__mulsf3@rm	; 		xcall.d		__mulsf3
	call.d	__mulsf3@rl
		ld.w		%r13, %r4			;					*delay*
		ld.w		%r6, %r10			; %r6  := b
		;//
		jp.d		logf_loop
		add		%r7, 2				; %r7  := c += 2			*delay*
		;//
logf_ret0:
		ld.w		%r10, 0				; %r10 := a = 0
logf_ret:
		;// %r10 := a
	add	%sp,0x1		; 		xadd		%sp, %sp, 4
		ret

	
		.code
		.align		1
		.global		floorf
floorf:
	sub	%sp,0x1		; 		xsub		%sp, %sp, 4
		ld.w		%r13, %sp		; %r10 := x = modff(x, &y)
	ext	modff@rm	; 		xcall		modff
	call	modff@rl
		cmp		%r10, 0			; %psr := x < 0.0f
	ld.w	%r10,[%sp+0x0]	; 		xld.w		%r10, [%sp]		; %r10 := y
	add	%sp,0x1		; 		xadd		%sp, %sp, 4
		;//
		jrlt		2			; if(x >= 0.0f) return y
		 ret
	ext	0x7f0		; 		xld.w		%r13, 0x3f800000	; return y - 1.0f
	ext	0x0
	ld.w	%r13,0x0
	ext	__subsf3@rm	; 		xjp.d		__subsf3
	jp.d	__subsf3@rl
		ld.w		%r12, %r10		;				*delay*

	
		.align		1
		.global		ceilf
ceilf:
		rl		%r12, 1			; %r10 := floorf(-x)
		xor		%r12, 1
	call.d	floorf		; 		xcall.d		floorf
		rr		%r12, 1			;				*delay*
		;//
		rl		%r10, 1			; return -floorf(-x)
		xor		%r10, 1
		ret.d
		rr		%r10, 1			;				*delay*

	
		.code
		.align		1
		.global		fabsf

fabsf:
		sll		%r12, 1			; %r12 := eeeeeeee mmmmmmmm mmmmmmmm mmmmmmm0
		srl		%r12, 1			; %r12 := 0eeeeeee emmmmmmm mmmmmmmm mmmmmmmm
		ret.d
		ld.w		%r10, %r12		; %r10 := 0eeeeeee emmmmmmm mmmmmmmm mmmmmmmm	*delay*

