/*	
 *	cliprend.h
 *
 *	`惉Cu`܂B
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2008 Naoyuki Sawa
 *
 *	* Wed Feb 13 06:00:00 JST 2002 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Jun 28 00:56:31 JST 2006 Naoyuki Sawa
 *	- mesh_load()̐錾ǉ܂B
 *	* Wed Jan 10 14:39:19 JST 2007 Naoyuki Sawa
 *	- surface_stretch()ǉ܂B
 *	* Mon Mar 12 00:13:49 JST 2007 Naoyuki Sawa
 *	- render_rectangle_dark()render_rectangle_shadow()ɖOύX܂B
 *	* Sun Jul 15 23:00:19 JST 2007 Naoyuki Sawa
 *	- render_rectangle_shadow()̃RgԈĂ̂C܂B
 *	  R[hɂ͕ύX܂B
 *	* Thu Sep 27 16:44:15 JST 2007 Naoyuki Sawa
 *	- RENDER\̂RENDERCONTEXT\̂̑ŜCAEgŒƂRgǋL܂B
 *	  R[hɂ͕ύX܂B
 *	* Wed Oct 17 12:30:13 JST 2007 Naoyuki Sawa
 *	- surface_stretch()ASM܂B
 *	  gp@̒ӓ_́AFRAM4̈gpĂAPI(pceLCDTrans(),pceFileWriteSct())ƓlłB
 *	  ڍׂ́AASMsurface_stretch()̃R[h̃RgQƂĂB
 *	* Mon Nov 05 15:54:07 JST 2007 Naoyuki Sawa
 *	- soft_focus()ǉ܂B
 *	* Fri Dec 28 20:39:14 JST 2007 Naoyuki Sawa
 *	- render_rectangle_clip()ǉ܂B
 *	* Tue Jan 01 21:17:37 JST 2008 Naoyuki Sawa
 *	- DSLPARAM\̂́Afore_colorback_coloȑւ܂B
 *	* Sun Jan 13 13:34:20 JST 2008 Naoyuki Sawa
 *	- draw_primitive_wz()framdp1.cցAdraw_primitive_woz()framdp2.cցAړ܂B
 *	  draw_primitive_wz()draw_primitive_woz()AAAZu邽߂̏łB
 *	- ̕ύXɔAׂ̍ȕύXs܂B
 *	  ύXӏ́Acliprend.hclipren3.cAu2008/01/13vŌĂB
 *	* Mon Jan 14 23:18:06 JST 2008 Naoyuki Sawa
 *	- draw_primitive_woz()p~Adraw_primitive_wz()ɓA֐draw_primitive()ɕύX܂B
 *	  ڂ́Aframdprm.c̃RgQƂĂB
 *	* Wed Jul 30 22:07:23 JST 2008 Naoyuki Sawa
 *	  CLIPVERTEX̒`Acliprend.hclipren3.cֈړ܂B
 *	  clipren3.c̓łgĂȂ̂ŁÃW[ւ̉e͗L܂B
 *	  A_ŕ`惂W[쐬\ŁA̍ہA_ŕ`惂W[ł́A
 *	  CLIPVERTEXƂOŁA_̃NbsOp_\̂`\łB
 *	  ɔāAŒ菬łCLIPVERTEXclipren3.c[JƂĂ߂ɁAړs܂B
 *	* Sun Aug 10 21:42:25 JST 2008 Naoyuki Sawa
 *	- tool/ExportPieceClipA<vector>vfŒ菬_łȂ_ŏo͂悤ύXƂɒǏ]A
 *	  mesh_load()wire_load()ɁA_̂܂ܓǂݍނAŒ菬_ɕϊ邩̑Iǉ܂B
 */
#ifndef __CLIP_REND_H__
#define __CLIP_REND_H__

/* REND_NOASM`C[`A`Ȃasm[`g܂B */
#undef REND_NOASM	/* ܂mɖ`ɂŁc */
//#define REND_NOASM	/* KvɉĒ`Ăi`ƒxȂ܂j */

/*****************************************************************************
 *	
 *****************************************************************************/

#ifdef PIECE
typedef PBMP_FILEHEADER	TEXTUREHEADER;
typedef PIECE_BMP	TEXTURE;
#else /*PIECE*/
typedef struct _TEXTUREHEADER {		/* PBMP_FILEHEADERɃoCi݊ */
	unsigned long head;		/* + 0,4 VOl`'PBMP'        */
	unsigned long fsize;		/* + 4,4 t@CTCY          */
	unsigned char bpp;		/* + 8,1 rbg[x              */
	unsigned char mask;		/* + 9,1 }XN[x              */
	short w;			/* +10,2                       */
	short h;			/* +12,2                     */
					/* +14,2 pfBO              */
	unsigned long buf_size;		/* +16,4 f[^TCY            */
					/* =20                           */
} TEXTUREHEADER;
typedef struct _TEXTURE {		/* PIECE_BMPɃoCi݊ */
	TEXTUREHEADER header;		/* + 0,20 wb_           */
	unsigned char* buf;		/* +20, 4 rbgf[^     */
	unsigned char* mask;		/* +24, 4 }XNf[^     */
					/* =28                     */
} TEXTURE;
#endif /*PIECE*/

/* SURFACE\̂́APIECE_VRAM\̂̏ʃoCi݊łB
 * PIECE_VRAMւ̃|C^v֐ɁASURFACEւ̃|C^n܂B
 */
typedef struct _SURFACE {		/* `T[tFCX   */
	short w;			/* + 0,2              */
	short h;			/* + 2,2            */
	unsigned char* vbuff;		/* + 4,4 J[obt@ */
	/* ܂PIECE_VRAM݊Bȍ~͊głB */
	unsigned char* zbuff;		/* + 8,4 yobt@     */
					/* =12                  */
} SURFACE;

typedef struct _VERTEX {		/* |S_          */
	short x;			/* +0,2 sNZW */
	short y;			/* +2,2 sNZW */
	unsigned char s;		/* +4,1 eNZW */
	unsigned char t;		/* +5,1 eNZW */
} VERTEX;				/* =6                    */

typedef struct _TCOORD {		/* eNX`W */
	unsigned char s;		/* +0,1 W  */
	unsigned char t;		/* +1,1 W  */
					/* =2             */
} TCOORD;

typedef struct _FACEVERTEX {		/* tFCX_                  */
	unsigned char iv;		/* +0,1 _WCfNX       */
	unsigned char ic;		/* +1,1 eNX`WCfNX */
} FACEVERTEX;

typedef struct _FACE {			/* tFCX                      */
	unsigned char nfv;		/* +0,1    _̐              */
	unsigned char c;		/* +1,1    J[                */
	/*FACEVERTEX fv[nfv];*/		/* +2,2nfv tFCX_Xg    */
					/* =2+2nfv                       */
} FACE;

typedef struct _MESH {			/* bV                             */
	unsigned char nv;		/* +0,1            _W̐         */
	unsigned char nc;		/* +1,1            eNX`W̐   */
	unsigned char nf;		/* +2,1            tFCX̐         */
	unsigned char reserved;		/* +3,1            (\)               */
	/*vector v[nv];*/		/* +4,12nv         _WXg       */
	/*TCOORD c[nc];*/		/* +4+12nv,2nc     eNX`WXg */
	/*FACE f[nf];*/			/* +4+12nv+2nc,(?) tFCXXg       */
					/* =4+12nv+2nc+(?)                      */
} MESH;

/*****************************************************************************
 *	gp
 *****************************************************************************/

//{{2008/07/30:clipren3.cֈړ
///* NbsOp_ */
//typedef struct _CLIPVERTEX {
//	fixed x, y, z;		/* + 0,12 _W       */
//	fixed s, t;		/* +12, 8 eNX`W */
//				/* =20                   */
//} CLIPVERTEX;
//}}2008/07/30:clipren3.cֈړ

/* `p_ */
typedef struct _RENDVERTEX {
	unsigned short x, y;	/* + 0,4 _W               */
	unsigned short z;	/* + 4,2 yl(8.8bit)           */
	unsigned short s, t;	/* + 6,4 eNX`W(8.8bit) */
				/* =10                          */
} RENDVERTEX;

///* DDA */
//typedef struct _DDA {
//	int n;			/* + 0,4 [̑     */
//	int d;			/* + 4,4 [             */
//	int u;			/* + 8,4 ̕ω     */
//	int v;			/* +12,4 Jグ̕ω */
//				/* =16                    */
//} DDA;
//2003/12/28: ̃W[łgƂ̂ŁAclipmisc.hֈړ܂B

/* draw_scanline_*_*()ֈnp[^̍\̂łB
 * draw_scanline_*_*()̓AZuō̂ŁAmɃItZbgŒƂ邽߂ɁA̍\̂pӂ܂B
 */
typedef struct _DSLPARAM {
	/* T[tFCX */
	unsigned short surface_w;			/*  0, 2:  */
	unsigned short surface_h;			/*  2, 2:  */
	unsigned char* surface_vbuff;			/*  4, 4: J[obt@ */
	unsigned char* surface_zbuff;			/*  8, 4: yobt@ */
	/* eNX` */
	unsigned short texture_w;			/* 12, 2:  */
	unsigned short texture_h;			/* 14, 2:  */
	unsigned char* texture_buf;			/* 16, 4: C[W */
	unsigned char* texture_mask;			/* 20, 4: }XN */
	/* J[ */
//{{2008/01/01:ύX
//	unsigned char back_color;			/* 24, 1: wiF */
//	unsigned char fore_color;			/* 25, 1: OiF */
// * Tue Jan 01 21:17:37 JST 2008 Naoyuki Sawa
// - DSLPARAM\̂́Afore_colorback_coloȑւ܂B
//   K{ł͗L܂񂪁ADRW_CLR()̃p[^ƈvāAՂ邽߂łB
// - _ŁÃtB[hQƂĂW[́Aȉ̂ƂłB
//	framds11.c c XLC`֐iyrEeNX`Ȃj
//	framds12.c c XLC`֐iyrE1biteNX`j
//	framds13.c c XLC`֐iyrE1bitmaskeNX`j
//	framds21.c c XLC`֐iyrȂEeNX`Ȃj
//	framds22.c c XLC`֐iyrȂE1biteNX`j
//	framds23.c c XLC`֐iyrȂE1bitmaskeNX`j
//   framds11.cAframds21.c͊ɃAZuĂ̂ŁAItZbgC܂B
//   framds12.cAframds13.cAframds22.cAframds23.c͂܂AZuĂȂ̂ŁA
//   ̕ύXɔC͕Kv܂łB
	unsigned char fore_color;			/* 24, 1: OiF */
	unsigned char back_color;			/* 25, 1: wiF */
//}}2008/01/01:ύX
} DSLPARAM;

/* XLC`֐̖{̂łBAvP[V璼ڗpȂŉB */
typedef void (*DSLPROC)(const RENDVERTEX* v0, const RENDVERTEX* v1, DSLPARAM* param);
void draw_primitive(RENDVERTEX vertices[/*n_vertices*/], int n_vertices, DSLPARAM* param, DSLPROC draw_scanline); /* framdprm.c {{2008/01/14:ǉ}} */ 
/* (yRyA) */
//void draw_primitive_wz(RENDVERTEX vertices[/*n_vertices*/], int n_vertices, DSLPARAM* param, DSLPROC draw_scanline);	/* framdp1.c {{2008/01/13:ǉ}} */ /* {{2008/01/14:폜}} */
void draw_scanline_wz_color(const RENDVERTEX* v0, const RENDVERTEX* v1, DSLPARAM* param);	/* framds11.c */
void draw_scanline_wz_1bit(const RENDVERTEX* v0, const RENDVERTEX* v1, DSLPARAM* param);	/* framds12.c */
void draw_scanline_wz_1bitmask(const RENDVERTEX* v0, const RENDVERTEX* v1, DSLPARAM* param);	/* framds13.c */
void draw_scanline_wz_2bit(const RENDVERTEX* v0, const RENDVERTEX* v1, DSLPARAM* param);	/* framds14.c */
void draw_scanline_wz_2bitmask(const RENDVERTEX* v0, const RENDVERTEX* v1, DSLPARAM* param);	/* framds15.c */
/* (yRyAȂ) */
//void draw_primitive_woz(RENDVERTEX vertices[/*n_vertices*/], int n_vertices, DSLPARAM* param, DSLPROC draw_scanline);	/* framdp2.c {{2008/01/13:ǉ}} */ /* {{2008/01/14:폜}} */
void draw_scanline_woz_color(const RENDVERTEX* v0, const RENDVERTEX* v1, DSLPARAM* param);	/* framds21.c */
void draw_scanline_woz_1bit(const RENDVERTEX* v0, const RENDVERTEX* v1, DSLPARAM* param);	/* framds22.c */
void draw_scanline_woz_1bitmask(const RENDVERTEX* v0, const RENDVERTEX* v1, DSLPARAM* param);	/* framds23.c */
void draw_scanline_woz_2bit(const RENDVERTEX* v0, const RENDVERTEX* v1, DSLPARAM* param);	/* framds24.c */
void draw_scanline_woz_2bitmask(const RENDVERTEX* v0, const RENDVERTEX* v1, DSLPARAM* param);	/* framds25.c */

/****************************************************************************
 *	XLC`֐p}N`
 ****************************************************************************/

/* draw_primitive_*()p DDAZbgAbv */
#define DRAW_PRIMITIVE_SETUP(i) \
	side->cur.i = v0->i; \
	if(v0->i <= v1->i) { \
		side->i.n = (v1->i - v0->i) % side->ny; \
		side->i.d = -side->ny; \
		side->i.u = (v1->i - v0->i) / side->ny; \
		side->i.v = 1; \
	} else { \
		side->i.n = (v0->i - v1->i) % side->ny; \
		side->i.d = -side->ny; \
		side->i.u = -((v0->i - v1->i) / side->ny); \
		side->i.v = -1; \
	}

/* draw_primitive_*()p DDAXebvs */
#define DRAW_PRIMITIVE_STEP(i) \
	side->cur.i += side->i.u; \
	side->i.d += side->i.n * 2; \
	if(side->i.d >= 0) { \
		side->cur.i += side->i.v; \
		side->i.d -= side->ny * 2; \
	}

/* draw_scanline_*_*()p DDAZbgAbv */
#define DRAW_SCANLINE_SETUP(i) \
	cur.i = v0->i; \
	if(v0->i <= v1->i) { \
		i.n = (v1->i - v0->i) % nx; \
		i.d = -nx; \
		i.u = (v1->i - v0->i) / nx; \
		i.v = 1; \
	} else { \
		i.n = (v0->i - v1->i) % nx; \
		i.d = -nx; \
		i.u = -((v0->i - v1->i) / nx); \
		i.v = -1; \
	}

/* draw_scanline_*_*()p DDAXebvs */
#define DRAW_SCANLINE_STEP(i) \
	cur.i += i.u; \
	i.d += i.n * 2; \
	if(i.d >= 0) { \
		cur.i += i.v; \
		i.d -= nx * 2; \
	}

/*****************************************************************************
 *	
 *****************************************************************************/

/* eNX`\̂܂B
 * [in]
 *	texture		eNX`\́B
 *	data		PBMPt@CC[W̐擪AhXB
 * [out]
 *	߂l		texture̒l̂܂ܕԂ܂B
 * [note]
 *	* TEXTURE\̂PIECE_BMP\̂Ɠ(typedef)Ȃ̂ŁA
 *	  ̊֐PIECE_BMP\̂̏ɂpł܂B
 */
TEXTURE* texture_init(TEXTURE* texture, const void* data);

/* eNX`\̔z܂B
 * [in]
 *	texture		eNX`\̔z̐擪AhXB
 *	texture_count	eNX`\̔z̗vfB
 *	...		PBMPt@CC[W̐擪AhX񋓂ĂB
 *			񋓐texture_countŎw肵ƓłȂ΂܂B
 * [note]
 *	* ̃eNX`𗘗pAvP[V̂߂̃[eBeB֐łB
 *	  ̗̂悤ɎgĂB
 *
 *		extern const unsigned char PAT0[];
 *		extern const unsigned char PAT1[];
 *		TEXTURE texture_table[2];
 *		void init() {
 *			texture_table_init(texture_table, 2, PAT0, PAT1);
 *			// texture_table[0]PAT0gď܂B
 *			// texture_table[1]PAT1gď܂B
 *		}
 */
void texture_table_init(TEXTURE texture[], int texture_count, ...);

/* T[tFCXNA܂B
 * [in]
 *	surface		T[tFCX\́B
 *	color		wiFB
 * [note]
 *	* J[obt@(vbuff)NULLłȂ΁AwiFŃNA܂B
 *	* yobt@(zbuff)NULLłȂ΁A0xFFŃNA܂B
 */
void surface_clear(SURFACE* surface, int color);

/* sNZJ[擾܂B
 * [in]
 *	surface		T[tFCX\́B
 *	x,y		sNZWB
 * [out]
 *	߂l		sNZJ[B
 *			T[tFCXÕsNZWȂA-1Ԃ܂B
 * [note]
 *	* ̊֐́Arender_point()Ƒ΂𐬂܂B
 */
int surface_point(SURFACE* surface, int x, int y);

/* ]T[tFCXŜA]T[tFCXŜցAԃRs[܂B
 * [in]
 *	dst		]T[tFCXB
 *	src		]T[tFCXB
 * [note]
 *	* ]A]̃T[tFCXTCY͔CӂłB
 *	  Ƃ΁AgAk̂悤ȏꍇłA薳ł܂B
 *	* ʏ4F\łAؑ16F\łpł܂B
 *	  jAԂƉdς̃ASYȂ̂ŁA{֐͊KӎĂ܂B
 *	* gEkɓASYgpĂ܂B
 *	  g͈ʓIȃjAԂłAk͔͈͓SsNZ̉dςƂȂ܂B
 *	  ɁAkׂ̂̕ŁAӂĂB
 *	* {֐́AgkᑬŁAA^CQ[ɗp邱Ƃ͓łB
 *	  ȉɁAeXgʂL^Ă܂B
 *	----------------------------------------------------------------------------------------------------------------------------
 *	* eXg
 *	  X^bN SRAM
 *	  R[h SRAM
 *	  TURBO ON 48MHz
 *	  16K\ OFF
 *	* eXg
 *	   63x 43 -> 128x88 (g) 0.16b
 *	  128x 88 -> 128x88 ({) 0.12b
 *	  255x255 -> 128x88 (k) 0.53b
 *	* l@
 *	- {֐́A܂͂č܂łB
 *	  AAłƂĂAA^CQ[Ŗt[Xgb`sł鑬xɂ́AقǉƍlłB
 *	- X^bNRAMɔzuAR[hRAMɔzu΁AxPł܂A{xłAsłB
 *	  ܂AXgb`ʓIɎgɂ́A16K\Ƃ̕pKvłȀꍇAؑւׂ̕ŁAɑxxȂ܂B
 *	- ȏ̗RɂA߂āAPȎێ邱Ƃɂ܂B
 *	  {֐́AÓIȉ摜`悵CӃTCỸT[tFCXACT[tFCXɃXgb`悤ȗprɗpĂB
 *	- Ӂ{֐̎Ƃ͒ڊ֌W܂񂪁A255~255𒴂T[tFCX̗pɂ͒ӂĂB
 *	  render_object()pceLCDDrawObject()𗘗pĂApceLCDDrawObject()RECTP̐̂߁A255~255𒴂ȂłB
 *	----------------------------------------------------------------------------------------------------------------------------
 *	* Wed Oct 17 12:30:13 JST 2007 Naoyuki Sawa
 *	- surface_stretch()ASM܂B
 *	  gp@̒ӓ_́AFRAM4̈gpĂAPI(pceLCDTrans(),pceFileWriteSct())ƓlłB
 *	  ڍׂ́AASMsurface_stretch()̃R[h̃RgQƂĂB
 */
void surface_stretch(SURFACE* dst, SURFACE* src);

/* T[tFCXŜɁA\tgtH[JX܂B
 * [in]
 *	surface		\tgtH[JXT[tFCXB
 *			\tgtH[JX̂߂̒ԃobt@ƂāA_def_vbuff𗘗pĂ܂B
 *			̂߁A11264(=128*88)sNZȏ̃T[tFCXw肷邱Ƃ͂ł܂B
 *			{֐̌ĂяoɂāA_def_vbuff̓e͔j󂳂܂B
 *	x		̃\tgtH[JX̓xB
 *	y		̃\tgtH[JX̓xB
 *			\tgtH[JX̓x́uʖ:1.00.0:őʁvłB
 *			1.0߁A܂́A0.0w肵ꍇ́A͈̔͂ɐ؂l߂܂B
 * [note]
 *	- surface_stretch()̉płB
 *	  T[tFCXkAēxAg傷邱ƂŁA\tgtH[JXʂ܂B
 *	- \tgtH[JX̓x́A(x)A(y)AƗɎwł悤ɂ܂B
 *	  Е1.0(ʖ)ɌŒ肵܂܁A1.00.0ɕωƁAʔʂ܂B
 *	  ʏ̃\tgtH[JXsꍇ́Aɓlw肵ĂB
 *	- x̃p[^(x,y)fixedƂAdoubleƂŔAȉ̂ƂłB
 *	  @clipfixframfixW[AʂɃN̂h߂łB
 *	    2007/11/05݁Aclippceclipren2̕K{W[́Aclipfixframfix𗘗pĂ܂B
 *	    AvP[VvOŌŒ菬g킸AAclipren3̃W[gȂ΁A
 *	    clipfixframfixW[Nɍς݂܂B
 *	    Asoft_focus()Œ菬gĂ܂ƁAsoft_focus()͕K{W[łclipren2
 *	    ܂܂Ă̂ŁAclipfixframfixW[KNĂ܂AʂłB
 *	    ̂悤Ȗʂ邽߂ɁAŒ菬̎gp܂B
 *	    ̑ɁAadddf3muldf3̕W[QƂ܂A
 *	    ͊ɕK{W[łclipprntQƂĂA񑝉킯ł͂܂B
 *	  Asoft_focus()̎sԂ[ɒAZ̃I[p[wbhł邩łB
 *	    soft_focus()̎sԂ́Ap[^ɂ܂A悻100`200~bxƐ܂B
 *	    ́Asoft_focus()ŕZ߂鎞ԂAAvP[Vsoft_focus()ւ
 *	    p[^vẐ߂ɕZv鎞Ԃ[ɒłB
 *	    ]āAp[^ZłĂAI[p[wbh͖łƍl܂B
 *	- <gp>
 *		int i = UPDOWN_MOTION(now, 30);	// 0,1,2,...,27,28,29,28,27,...,2,1,0,1,2,...
 *		double t = i / 29.0;		// 0.01.00.01.0...
 *		t = pow(t, 2.0);		// ʂn(1.0t)̕ω𑁂߂܂B()
 *		soft_focus(&surface, t, t);	// \tgtH[JX܂B
 */
void soft_focus(SURFACE* surface, double x, double y);

/*****************************************************************************
 *	RENDER
 *****************************************************************************/

#define RENDER_CONTEXT_STACK_SIZE	16			/* ReLXgX^bNTCY */

/* _render_object()ASMłItZbgŒŒڈ߁AŜCAEgŒƂ܂B (2007/09/27ǋL) */
typedef struct _RENDERCONTEXT {
	matrix matrix;						/* + 0,48: ϊs              */
	TEXTURE* texture;					/* +48, 4: eNX`(NULL:Ȃ) */
} RENDERCONTEXT;						/* +52 */

/* _render_object()ASMłItZbgŒŒڈ߁AŜCAEgŒƂ܂B (2007/09/27ǋL) */
typedef struct _RENDER {
	SURFACE* surface;					/* + 0, 4: `T[tFCX                 */
	short left;						/* + 4, 2: r[|[g`(ObhWn) */
	short top;						/* + 6, 2:                                  */
	short right;						/* + 8, 2:                                  */
	short bottom;						/* +10, 2:                                  */
	/* なrender_line()AZuł璼ڈ߁ACAEgŒłB (2004/12/20) */
	/* render_font()ASMłAItZbgŒŎQƂ悤ɂȂ܂B        (2007/09/19ǋL) */
	/* 艺𒼐ڈAZuŊ֐͂܂̂ŁACAEgύX\łB(2004/12/20)  _render_object()ASMłAItZbgŒŎQƂ悤ɂȂ܂B(2007/09/27ǋL) */
	fixed front;						/* +12, 4: NbsO(3D`p)     */
	fixed back;						/* +16, 4:                                  */
	RENDERCONTEXT* context;					/* +20, 4: ReLXgX^bNgbv       */
	/* な_render_object()ASMł璼ڈ߁ACAEgŒłB   (2007/09/27ǋL) */
	RENDERCONTEXT context_stack[RENDER_CONTEXT_STACK_SIZE];	/* +24, ?: ReLXgX^bN             */
} RENDER;

/* t[܂B
 * [in]
 *	render		_[ւ̃|C^B
 *	surface		`T[tFCXB
 *	x,y		r[|[g_B
 *	width,height	r[|[gTCYB
 *	front,back	NbsOB
 *	fovy		pxB
 * [note]
 *	* width,height0w肷ƁAT[tFCX̕AƓƌȂ܂B
 *	  ]āAT[tFCXŜr[|[g̈ƂĎw肷ɂ́A
 *	  x,y,width,height0,0,0,0Ǝw肷̂ȒPłB
 *	* 3D`sȂꍇ́Afront,back,fovyɑS0w肵ĂB
 *	  front,back,fovyɑS0w肵ꍇAϊs͏܂B
 *	* ̊֐́AT[tFCX̃NAs܂B
 *	  J[obt@тyobt@̃NÁAĂяoōsĂB
 *	* 2003/09/14: 2Dp3Dpɏ֐𕪂܂B
 *	  2DpƂďꍇ́Afront/back/fovy0w肷Kv͂܂B
 */
void render_init_2d(RENDER* render, SURFACE* surface, int x, int y, int width, int height);
void render_init_3d(RENDER* render, SURFACE* surface, int x, int y, int width, int height, fixed front, fixed back, fixed fovy);

/* ReLXgޔ܂B
 * [in]
 *	render		_[ւ̃|C^B
 */
void render_save(RENDER* render);

/* ReLXg𕜌܂B
 * [in]
 *	render		_[ւ̃|C^B
 */
void render_restore(RENDER* render);

/* _`܂B
 * [in]
 *	render		_[ւ̃|C^B
 *	x,y		_̍WB
 *	color		J[B
 * [note]
 *	* ̊֐́Asurface_point()Ƒ΂𐬂܂B
 */
void render_point(RENDER* render, int x, int y, int color);

/* F͈̔͂hԂ܂B
 * [in]
 *	render		_[ւ̃|C^B
 *	x0,y0		hԂJn_B
 *	color		J[B
 * [out]
 *	߂l		hsNZ̐B
 * [note]
 *	* (x0,y0)̐F͈͂AcolorœhԂ܂B
 *	  (x0,y0)̐FcolorƓȂA܂B
 *	* (x0,y0)r[|[gOȂA܂B
 */
int render_paint(RENDER* render, int x0, int y0, int color);

/* `܂B
 * [in]
 *	render		_[ւ̃|C^B
 *	x0,y0		n_WB
 *	x1,y1		I_WB
 *	color		J[B
 * [note]
 *	* p``߂ɁAAČĂяo邱Ƃz肵Ă܂B
 *	  āAI_sNZ(x1,y1)͕`܂B
 *	* ̓sANbsOꂽ̏I_`Ȃ̂ŁA
 *	  ʓʊOւ̐`ƂƁAʒ[1sNZ
 *	  ԂłĂ܂܂BvCB
 *	* Fri Mar  8 07:00:00 JST 2002 Naoyuki Sawa
 *	  C܂B
 */
void render_line(RENDER* render, int x0, int y0, int x1, int y1, int color);

/* j`܂B
 * [in]
 *	render		_[ւ̃|C^B
 *	x0,y0		n_WB
 *	x1,y1		I_WB
 *	i_pat		jp^[̊JnCfbNXB
 *	pat		//jp^[B(J[l̔zBl4ȏ͓)
 *			//* Tue May 16 17:10:00 JST 2006 Naoyuki Sawa
 *			//- render_dashes()16K[hłpł悤AF̒`ύX܂B
 *			//  ܂ł4ȏ𓧖FƂĈĂ܂A16ȏ𓧖FƂ܂B
 *			jp^[B(J[l̔zBl16ȏ͓)
 *	n_pat		jp^[̗vfB(1ȏ)
 * [out]
 *	߂l		jp^[̏ICfbNX{PB
 *			A`Ƃ́A̖߂lrender_dashes()Ăяoi_patɓn΁A
 *			jp^[܂Ȃ܂B
 * [note]
 *	* n_pat0w肷ƁA[ZG[܂B
 *	* i_pat>=n_patł\܂BK؂ȌJԂʒuJn܂B
 */
int render_dashes(RENDER* render, int x0, int y0, int x1, int y1, unsigned i_pat, const unsigned char* pat, unsigned n_pat);

/* ``܂B
 * [in]
 *	render		_[ւ̃|C^B
 *	x,y		㌴_WB
 *	w,h		`̃TCYB
 *	color		J[B
 * [note]
 *	* WƃTCY̓ObhWnŎw肵ĂB(Windows GDIƓlł)
 */
void render_rectangle(RENDER* render, int x, int y, int w, int h, int color);

/* `W̐KƃNbsOs܂B
 * [in]
 *	(px,py,pw,ph)		ύXO̍Wlւ̃|C^B
 * [out]
 *	߂l			0 = SɉʊOB
 *				    `sKv͂܂B
 *				    (*px,*py,*pw,*ph)͕ύX܂B
 *				1 = ȂƂꕔʓB
 *				    `sKv܂B
 *				    (*px,*py,*pw,*ph)͕ύX܂B
 *	(*px,*py,*pw,*ph)	ύX̍Wli[܂B
 *				߂l0̏ꍇ́Ai[܂B
 */
int render_rectangle_clip(RENDER* render, int* px, int* py, int* pw, int* ph);

/* `hԂ܂B
 * [in]
 *	render		_[ւ̃|C^B
 *	x,y		㌴_WB
 *	w,h		`̃TCYB
 *	color		J[B
 * [note]
 *	* WƃTCY̓ObhWnŎw肵ĂB(Windows GDIƓlł)
 */
void render_rectangle_fill(RENDER* render, int x, int y, int w, int h, int color);

/* `̈̃sNZl𑝌܂B
 * [in]
 *	render		_[ւ̃|C^B
 *	x,y		㌴_WB
 *	w,h		`̃TCYB
 *	adjust		sNZlʁA܂́AsNZlʁB
 *			(adjust<0)̏ꍇAsNZl܂B
 *			(adjust>0)̏ꍇAsNZl𑝉܂B
 *			(adjust=0)̏ꍇA܂B
 *	limit		sNZlA܂́AsNZlB
 *			(adjust<0)̏ꍇA(limit=sNZl)ƌȂ܂B
 *			  sNZlʁAlimitAlimitɕ␳܂B
 *			  ʏ́A0w肵ĂB
 *			  0ȊO̒lw肷邱Ƃ\łB
 *			(adjust>0)̏ꍇA(limit=sNZl)ƌȂ܂B
 *			  sNZl𑝉ʁAlimitAlimitɕ␳܂B
 *			  ʏ́A3(4K\)A܂́A15(16K\)w肵ĂB
 *			  3A܂́A15ȊO̒lw肷邱Ƃ\łB
 *			(adjust=0)̏ꍇAlimit͈Ӗ܂B
 * [note]
 *	* WƃTCY̓ObhWnŎw肵ĂB(Windows GDIƓlł)
 */
void render_rectangle_shadow(RENDER* render, int x, int y, int w, int h, int adjust, int limit);

/* ȉ~`܂B
 * [in]
 *	render		_[ւ̃|C^B
 *	x,y		ȉ~ɊOڂ`̍㌴_WB
 *	w,h		ȉ~ɊOڂ`̃TCYB
 *	color		J[B
 * [note]
 *	* WƃTCY̓ObhWnŎw肵ĂB(Windows GDIƓlł)
 */
void render_ellipse(RENDER* render, int x, int y, int w, int h, int color);

/* ȉ~hԂ܂B
 * [in]
 *	render		_[ւ̃|C^B
 *	x,y		ȉ~ɊOڂ`̍㌴_WB
 *	w,h		ȉ~ɊOڂ`̃TCYB
 *	color		J[B
 * [note]
 *	* WƃTCY̓ObhWnŎw肵ĂB(Windows GDIƓlł)
 */
void render_ellipse_fill(RENDER* render, int x, int y, int w, int h, int color);

/* |S`܂B
 * [in]
 *	render		_[ւ̃|C^B
 *	vertices	_XgB
 *	n_vertices	_̐B
 *	color		J[B
 */
void render_polygon(RENDER* render, const VERTEX* vertices, int n_vertices, int color);

/* bV`܂B
 * [in]
 *	render		_[ւ̃|C^B
 *	mesh		`悳郁bVB
 */
void render_mesh(RENDER* render, const MESH* mesh);

/* bVt@C[h܂B
 * [in]
 *	filename	bVt@CB
 *	//{{2008/08/10:ǉ
 *	convert_fixed	0 = <vector>vf𕂓_̂܂܂ŁA_MESHƂB
 *			1 = <vector>vfŒ菬_ɕϊAŒ菬_MESHƂB
 *	//}}2008/08/10:ǉ
 * [out]
 *	߂l		bV\̂̃ubNB
 *			svɂȂAfree()ĂяoĉĂB
 * [note]
 *	* t@CȂAǂݍ݃G[ꍇ́ADIE()ɂĒ~܂B
 *	  {֐sNULLԂƂ͖̂ŁAĂяoɂĖ߂lKv͂܂B
 *	* bVt@C`ɂẮAtool/ExportPieceClipQƂĂB
 *	  Ǝ`XML`bVo͂AMetasequoiap̎vOCłB
 */
//{{2008/08/10:ύX
//MESH* mesh_load(const char* filename); /*  clipobj3.c */
//2008/08/10:ύX
MESH* mesh_load(const char* filename, int convert_fixed); /*  clipobj3.c */
//}}2008/08/10:ύX

#endif /*__CLIP_REND_H__*/
