/*	
 *	clipjpeg.h
 *
 *	JPEG Decoder
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2009 Naoyuki Sawa
 *
 *	* Fri Feb 06 22:32:46 JST 2009 Naoyuki Sawa
 *	- 쐬JnB
 *	* Mon Feb 09 23:11:25 JST 2009 Naoyuki Sawa
 *	- 1st [XB
 */
#ifndef __CLIP_JPEG_H__
#define __CLIP_JPEG_H__

/****************************************************************************
 *	
 ****************************************************************************/

/* JPEGf[^fR[h܂B
 * [in]
 *	data_ptr		JPEGf[^̐擪AhXB
 *	size_proc		EʒmR[obNB(NULL)
 *	draw_proc		sNZ`R[obNB(NULL)
 *	user_data		Cӂ̃[U[f[^B
 * [out]
 *	߂l			JPEGf[^̏I[AhXB
 *				IɁA[VJPEGɑΉ邽߂̖߂lłB
 *				[VJPEGɂĖ̂߁Aۂɖ𗧂ǂ킩܂B
 * [note]
 *	* fR[h\JPEGf[^́ABaseline DCT`(SOF0)݂̂łB
 *	  Baseline DCT`̎ɂ悭gAProgressive DCT`(SOF2)̓fR[hł܂B
 *	  Progressive DCT`܂߂āǍ`JPEGf[^w肵ꍇ͖̓`łB
 *	* size_procAdraw_proc̗w肵ꍇAKsize_procAdraw_proc̏ɃR[obN܂B
 *	  ]āAsize_procŕEɉWJobt@āAdraw_procŊi[邱Ƃł܂B
 *	  ܂́Adraw_procŒځAʂɕ`sƂł܂B
 *	* ׂẴsNZɑ΂draw_procR[obN邽߁A傫ȉ摜̃fR[hɂ͎Ԃ܂B
 *	  {֐́AfR[hrŒ~@\Ă܂񂪁AsetjmpAlongjmp𗘗pĒ~\łB
 *	  draw_proc̒ŁApcePadGetDirectȂǂgĒ~𔻒fAlongjmpŌĂяo֖߂ĂB
 *	  {֐́AŃ\[XĂsĂ܂̂ŁAlongjmpŒ~Ă\[XR͔܂B
 * [example]
 *	jmp_buf jb;
 *	int width;
 *	int height;
 *	static void my_size_proc(int w, int h, void* user_data) {
 *		width = w;
 *		height = h;
 *	}
 *	static void my_draw_proc(int x, int y, int c, void* user_data) {
 *		render_point(&render, x, y, (c >> 4) ^ 15);
 *		if(pcePadGetDirect()) {
 *			longjmp(jb, 1);
 *		}
 *	}
 *	void example() {
 *		if(!setjmp(jb)) {
 *			jpeg_decode(JPEG_DATA, my_size_proc, my_draw_proc, NULL);
 *		}
 *		render_printf(&render, 0, 0, 0, 15, "%d x %d", width, height);
 *	}
 */
const void* jpeg_decode(const void* data_ptr,
	void (*size_proc)(int w, int h, void* user_data),
	void (*draw_proc)(int x, int y, int c, void* user_data),
	void* user_data);

#endif /*__CLIP_JPEG_H__*/

