/*	
 *	clipdms.h
 *
 *	P/ECE DMG-Sound Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Thu Jan 15 20:09:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#ifndef __CLIP_DMS_H__
#define __CLIP_DMS_H__

/****************************************************************************
 *
 ****************************************************************************/

#define DMGSOUNDBUFLEN 320 /* = 16000/50 c 1[tick](=1/50[sec])̃Tv */

/*
 *	g[`l (Ch#1-2)
 */
typedef struct _DMGSOUNDTONE {
	/* Sound Length */
	int sound_length;		/* TEho͎ (0:~/>0:cTCN/<0:INFINITE) */
	/* Sweep (Ch#1̂) */
	int sweep_time;			/* XC[vXV */
	int sweep_up_down;		/* XC[v (0:/1:) */
	int sweep_shift;		/* XC[vω */
	int sweep_progress;		/* XC[visJE^ */
	/* Envelope */
	int envelope;			/* Gx[vݒl */
	int envelope_time;		/* Gx[vXV */
	int envelope_up_down;		/* Gx[v (0:/1:) */
	int envelope_progress;		/* Gx[visJE^ */
	/* Wave Pattern */
	int wave_pattern;		/* g`p^[ݒl (0`7) */
	int wave_pattern_duty;		/* g`p^[f[eB[ (1/2/4/6) */
	/* Frequency */
	int frequency;			/* gݒl */
	int frequency_progress;		/* gisJE^ */
} DMGSOUNDTONE;

/*
 *	PCM`l (Ch#3)
 */
typedef struct _DMGSOUNDPCM {
	/* Sound ON/OFF */
	int sound_on_off;		/* TEho (0:OFF/1:ON) */
	/* Sound Length */
	int sound_length;		/* TEho͎ (0:~/>0:cTCN/<0:INFINITE) */
	/* Output Level */
	int output_level;		/* TEho̓x (0`3) */
	/* Wave Pattern */
	int wave_pattern;		/* g`p^[ݒl (0`31) */
	char wave_pattern_ram[32];	/* g`(-15`+15) */
	/* Frequency */
	int frequency;			/* gݒl */
	int frequency_progress;		/* gisJE^ */
} DMGSOUNDPCM;

/*
 *	mCY`l (Ch#4)
 */
typedef struct _DMGSOUNDNOISE {
	/* Sound Length */
	int sound_length;		/* TEho͎ (0:~/>0:cTCN/<0:INFINITE) */
	/* Envelope */
	int envelope;			/* Gx[vݒl */
	int envelope_time;		/* Gx[vXV */
	int envelope_up_down;		/* Gx[v (0:/1:) */
	int envelope_progress;		/* Gx[visJE^ */
	/* LFSR */
	int lfsr;			/* Linear Feedback Shift Register */
	int lfsr_bits;			/* LFSRrbg (0:15bit/1:7bit) */
	/* Frequency */
	int frequency;			/* gݒl */
	int frequency_progress;		/* gisJE^ */
} DMGSOUNDNOISE;

/*
 *	DMG-SoundRA
 */
typedef struct _DMGSOUND {
	DDA progress;			/* NbNisDDA */
	//
	unsigned char* reg;		/* WX^(O) */
	//
	int all_sound_on_off;		/* 1:ON/0:OFF */
					/* OFF̏ꍇAPɉoOFFł͂ȂAH~܂B */
	int sound_output;		/* bit0: Ch#1 Left  1:ON/0:OFF */
					/* bit1: Ch#2 Left  1:ON/0:OFF */
					/* bit2: Ch#3 Left  1:ON/0:OFF */
					/* bit3: Ch#4 Left  1:ON/0:OFF */
					/* bit4: Ch#1 Right 1:ON/0:OFF */
					/* bit5: Ch#2 Right 1:ON/0:OFF */
					/* bit6: Ch#3 Right 1:ON/0:OFF */
					/* bit7: Ch#4 Right 1:ON/0:OFF */
	int volume[2];			/* }X^{[ [0:Left/1:Right] */
	//
	DMGSOUNDTONE  ch1;		/* Ch#1: g[(XC[vL) */
	DMGSOUNDTONE  ch2;		/* Ch#2: g[(XC[v) */
	DMGSOUNDPCM   ch3;		/* Ch#3: PCM */
	DMGSOUNDNOISE ch4;		/* Ch#4: mCY */
} DMGSOUND;

int dmgsound_process(DMGSOUND* ds, int cycle);				/* t11bit */
int dmgsound_tone_process(DMGSOUND* ds, DMGSOUNDTONE* ch, int cycle);	/* t5bit{-15`15} */
int dmgsound_pcm_process(DMGSOUND* ds, DMGSOUNDPCM* ch, int cycle);	/* t5bit{-15`15} */
int dmgsound_noise_process(DMGSOUND* ds, DMGSOUNDNOISE* ch, int cycle);	/* t5bit{-15`15} */

/****************************************************************************
 *
 ****************************************************************************/

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* DMG-SoundRAZbg܂B
 * [in]
 *	ds		DMGSOUND\́B
 *	reg		WX^(O)
 *			* ȂƂ0x40oCg̃WX^KvłB
 *			  GBSvC[ł́ADMG-CPU̘_AhX0xff00-0xff3fLĂB
 *			* dmgsound_reset()ĂяoAO烁eĂ͂܂B
 *			  Kdmgsound_write()oRĂB
 *			* WX^lǂݏoꍇ́AWX^̒l𒼐ړǂݏoĂB
 *			  2004/01/18݁Aǂݏo\WX^l̍XV͖łB
 *			  2005/02/25ύX
 *			  dmgsound_read()֐ǉ܂B
 *			  ́AWX^̓ǂݏóAdmgsound_read()֐ĂяoĂB
 *			  ACLKv͖m܂B
 *			  Ď̋@΁AC̋L߂Ǝv܂B
 *	clock		̓NbNB
 * [note]
 *	* AvP[VvÓAȂƂŏɈxÅ֐ĂяoĂB
 *	  ̌́ADMG-SoundZbgsꍇɁAKvɉČĂяoĂB
 */
void dmgsound_reset(DMGSOUND* ds, unsigned char* reg, int clock);

/* DMG-Sound̃WX^ɏ݂܂B
 * [in]
 *	ds		DMGSOUND\́B
 *	addr		WX^AhXB
 *			CPU_AhX̉ʃoCgŎw肵ĂB
 *				NR10: 0xff10 => 0x10
 *				NR11: 0xff11 => 0x11
 *				NR12: 0xff12 => 0x12
 *				NR13: 0xff13 => 0x13
 *				NR14: 0xff14 => 0x14
 *				NR21: 0xff16 => 0x16
 *				NR22: 0xff17 => 0x17
 *				NR23: 0xff18 => 0x18
 *				NR24: 0xff19 => 0x19
 *				NR30: 0xff1a => 0x1a
 *				NR31: 0xff1b => 0x1b
 *				NR32: 0xff1c => 0x1c
 *				NR33: 0xff1d => 0x1d
 *				NR34: 0xff1e => 0x1e
 *				NR41: 0xff20 => 0x20
 *				NR42: 0xff21 => 0x21
 *				NR43: 0xff22 => 0x22
 *				NR44: 0xff23 => 0x23
 *				NR50: 0xff24 => 0x24
 *				NR51: 0xff25 => 0x25
 *				NR52: 0xff26 => 0x26
 *				AUD3W: 0xff30-0xff3f => 0x30-0x3f
 *	data		ރf[^B
 * [note]
 *	* sȃWX^AhXw肳ꂽꍇ́AɋA܂B
 */
void dmgsound_write(DMGSOUND* ds, unsigned char addr, unsigned char data);

/* DMG-Sound̃WX^ǂݏo܂B(2005/02/25ǉ)
 * [in]
 *	ds		DMGSOUND\́B
 *	addr		WX^AhXB
 *			CPU_AhX̉ʃoCgŎw肵ĂB
 *			ڂ́Admgsound_write()̐QƂĂB
 * [out]
 *	߂l		ǂݏof[^B
 */
unsigned char dmgsound_read(DMGSOUND* ds, unsigned char addr);

/* o̓TvO[g=SPEAKER_OUTPUT[Hz]ŁAw肳ꂽTṽ~LVOs܂B
 * [in]
 *	ds		DMGSOUND\́B
 *	wbuff		o̓Tvobt@B
 *	count		o̓TvB
 */
void dmgsound_mix(DMGSOUND* ds, short wbuff[/*count*/], int count);

#endif /*__CLIP_DMS_H__*/
