/*	
 *	clipc62i.c
 *
 *	P/ECE HuC6280 Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Mon Feb 23 04:28:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"
#include "clipc62i.h"	/*HuC6280G~[^p}N*/

/****************************************************************************
 *
 ****************************************************************************/

/* ߂܂B
 */
HUC6280FN_(ILL_IMP)
{
	DIE();
}

/****************************************************************************
 *
 ****************************************************************************/

#ifndef HUC6280_ASM

int huc6280_ADC(HUC6280* huc6280, int a, int b) {
	int c = P & 1;
	int tmp = a + b + c;
	P = (P & ~0xe3) |				/* T */
	    (tmp & 0x80) |				/* N */
	    ((~(a ^ b) & (a ^ tmp) & 0x80) >> 1) |	/* V */
	    (!(tmp & 0xff) << 1) |			/* Z */
	    ((tmp >> 8) & 1);				/* C */
	return tmp & 0xff;
}

int huc6280_SBC(HUC6280* huc6280, int a, int b) {
	int c = ~P & 1;
	int tmp = a - b - c;
	P = (P & ~0xe3) |				/* T */
	    (tmp & 0x80) |				/* N */
	    (((a ^ b) & (a ^ tmp) & 0x80) >> 1) |	/* V */
	    (!(tmp & 0xff) << 1) |			/* Z */
	    (~(tmp >> 8) & 1);				/* C */
	return tmp & 0xff;
}

void huc6280_CMP(HUC6280* huc6280, int a, int b) {
	int tmp = a - b;
	P = (P & ~0xa3) |				/* T */
	    (tmp & 0x80) |				/* N */
	    (!tmp << 1) |				/* Z */
	    (~(tmp >> 8) & 1);				/* C */
}

int huc6280_AND(HUC6280* huc6280, int a, int b) {
	a &= b;
	TEST(a);					/* T,N,Z */
	return a;
}

int huc6280_ORA(HUC6280* huc6280, int a, int b) {
	a |= b;
	TEST(a);					/* T,N,Z */
	return a;
}

int huc6280_EOR(HUC6280* huc6280, int a, int b) {
	a ^= b;
	TEST(a);					/* T,N,Z */
	return a;
}

void huc6280_BIT(HUC6280* huc6280, int a, int b) {
	P = (P & ~0xe2) |				/* T */
	    (b & 0xc0) |				/* N,V=b[7:6](dl) */
	    (!(a & b) << 1);				/* Z */
}

int huc6280_INC(HUC6280* huc6280, int a) {
	a++;
	TEST(a);					/* T,N,Z */
	return a;
}

int huc6280_DEC(HUC6280* huc6280, int a) {
	a--;
	TEST(a);					/* T,N,Z */
	return a;
}

#endif /*HUC6280_ASM*/

int huc6280_ASL(HUC6280* huc6280, int a) {
	int tmp = (a << 1) & 0xff;
	P = (P & ~0xa3) |				/* T */
	    (tmp & 0x80) |				/* N */
	    (!tmp << 1) |				/* Z */
	    ((a >> 7) & 1);				/* C */
	return tmp;
}

int huc6280_LSR(HUC6280* huc6280, int a) {
	int tmp = a >> 1;
	P = (P & ~0xa3) |				/* T */
							/* N */
	    (!tmp << 1) |				/* Z */
	    (a & 1);					/* C */
	return tmp;
}

int huc6280_ROL(HUC6280* huc6280, int a) {
	int tmp = ((a << 1) | (P & 1)) & 0xff;
	P = (P & ~0xa3) |				/* T */
	    (tmp & 0x80) |				/* N */
	    (!tmp << 1) |				/* Z */
	    (a >> 7);					/* C */
	return tmp;
}

int huc6280_ROR(HUC6280* huc6280, int a) {
	int tmp = ((a >> 1) | (P << 7)) & 0xff;
	P = (P & ~0xa3) |				/* T */
	    (tmp & 0x80) |				/* N */
	    (!tmp << 1) |				/* Z */
	    (a & 1);					/* C */
	return tmp;
}

/*  */
int huc6280_ADCD(HUC6280* huc6280, int a, int b) {
	int c = P & 1;
	int lo = (a & 0x0f) + (b & 0x0f) + c;
	int hi = (a & 0xf0) + (b & 0xf0);
	if(lo > 0x09) {
		lo += 0x06;
		hi += 0x10;
	}
	P = (P & ~0xe3) |				/* T */
	    (hi & 0x80) |				/* N */
	    ((~(a ^ b) & (a ^ hi) & 0x80) >> 1);	/* V */
	if(hi > 0x90) hi += 0x60;
	a = (lo & 0x0f) | (hi & 0xf0);
	P |= (!a << 1) |				/* Z */
	     ((hi >> 8) & 1);				/* C */
	return a;
}

/*  */
int huc6280_SBCD(HUC6280* huc6280, int a, int b) {
	int c = ~P & 1;
	int lo = (a & 0x0f) - (b & 0x0f) - c;
	int hi = (a & 0xf0) - (b & 0xf0);
	if(lo > 0x09) {
		lo -= 0x06;
		hi -= 0x10;
	}
	P = (P & ~0xe3) |				/* T */
	    (hi & 0x80) |				/* N */
	    (((a ^ b) & (a ^ hi) & 0x80) >> 1);		/* V */
	if(hi > 0x90) hi -= 0x60;
	a = (lo & 0x0f) | (hi & 0xf0);
	P |= (!a << 1) |				/* Z */
	     (~(hi >> 8) & 1);				/* C */
	return a;
}

/****************************************************************************
 *	f[^]
 ****************************************************************************/

#ifndef HUC6280_ASM

HUC6280FN_(LDA_IMM) { A = arg1; TEST(A); }
HUC6280FN_(LDX_IMM) { X = arg1; TEST(X); }
HUC6280FN_(LDY_IMM) { Y = arg1; TEST(Y); }
HUC6280FN_(LDA_MEM) { A = READ(arg1); TEST(A); }
HUC6280FN_(LDX_MEM) { X = READ(arg1); TEST(X); }
HUC6280FN_(LDY_MEM) { Y = READ(arg1); TEST(Y); }

HUC6280FN_(STA_MEM) { WRITE(arg1, A); CLT; }
HUC6280FN_(STX_MEM) { WRITE(arg1, X); CLT; }
HUC6280FN_(STY_MEM) { WRITE(arg1, Y); CLT; }

HUC6280FN_(CLA_IMP) { A = 0; CLT; }
HUC6280FN_(CLX_IMP) { X = 0; CLT; }
HUC6280FN_(CLY_IMP) { Y = 0; CLT; }

HUC6280FN_(TXA_IMP) { A = X; TEST(A); }
HUC6280FN_(TYA_IMP) { A = Y; TEST(A); }
HUC6280FN_(TAX_IMP) { X = A; TEST(X); }
HUC6280FN_(TAY_IMP) { Y = A; TEST(Y); }
HUC6280FN_(TSX_IMP) { X = S; TEST(X); }

HUC6280FN_(SAX_IMP) { unsigned char tmp = A; A = X; X = tmp; CLT; }
HUC6280FN_(SAY_IMP) { unsigned char tmp = A; A = Y; Y = tmp; CLT; }
HUC6280FN_(SXY_IMP) { unsigned char tmp = X; X = Y; Y = tmp; CLT; }

HUC6280FN_(PHA_IMP) { PUSH(A); CLT; }
HUC6280FN_(PHX_IMP) { PUSH(X); CLT; }
HUC6280FN_(PHY_IMP) { PUSH(Y); CLT; }
HUC6280FN_(PHP_IMP) { PUSH(P); CLT; }

HUC6280FN_(PLA_IMP) { PULL(A); TEST(A); }
HUC6280FN_(PLX_IMP) { PULL(X); TEST(X); }
HUC6280FN_(PLY_IMP) { PULL(Y); TEST(Y); }

#endif /*HUC6280_ASM*/

HUC6280FN_(STZ_MEM) { WRITE(arg1, 0); CLT; }
HUC6280FN_(TXS_IMP) { S = X; CLT; } /* P(N,Z)͕ω܂ */
HUC6280FN_(PLP_IMP) { PULL(P); huc6280_check_pending(huc6280); }

/****************************************************************************
 *	ZpZ
 ****************************************************************************/

/* P(T)Ή */
HUC6280FN_(ADC_IMM) { if(!(P & 8)) { A = ADC(A, arg1);       } else { A = ADCD(A, arg1);       CYCLE--; } }
HUC6280FN_(ADC_MEM) { if(!(P & 8)) { A = ADC(A, READ(arg1)); } else { A = ADCD(A, READ(arg1)); CYCLE--; } }

/* P(T)êADC,AND,ORA,EORŁASBCɂ͉eȂdlłBsvcȎdlłc */
HUC6280FN_(SBC_IMM) { if(!(P & 8)) { A = SBC(A, arg1);       } else { A = SBCD(A, arg1);       CYCLE--; } }
HUC6280FN_(SBC_MEM) { if(!(P & 8)) { A = SBC(A, READ(arg1)); } else { A = SBCD(A, READ(arg1)); CYCLE--; } }

#ifndef HUC6280_ASM

HUC6280FN_(CMP_IMM) { CMP(A, arg1); }
HUC6280FN_(CPX_IMM) { CMP(X, arg1); }
HUC6280FN_(CPY_IMM) { CMP(Y, arg1); }
HUC6280FN_(CMP_MEM) { CMP(A, READ(arg1)); }
HUC6280FN_(CPX_MEM) { CMP(X, READ(arg1)); }
HUC6280FN_(CPY_MEM) { CMP(Y, READ(arg1)); }

HUC6280FN_(INC_ACC) { A = INC(A); }
HUC6280FN_(INX_IMP) { X = INC(X); }
HUC6280FN_(INY_IMP) { Y = INC(Y); }
HUC6280FN_(INC_MEM) { WRITE(arg1, INC(READ(arg1))); }

HUC6280FN_(DEC_ACC) { A = DEC(A); }
HUC6280FN_(DEX_IMP) { X = DEC(X); }
HUC6280FN_(DEY_IMP) { Y = DEC(Y); }
HUC6280FN_(DEC_MEM) { WRITE(arg1, DEC(READ(arg1))); }

#endif /*HUC6280_ASM*/

/****************************************************************************
 *	_Z
 ****************************************************************************/

#ifndef HUC6280_ASM

/* P(T)Ή */
HUC6280FN_(AND_IMM) { A = AND(A, arg1); }
HUC6280FN_(AND_MEM) { A = AND(A, READ(arg1)); }

/* P(T)Ή */
HUC6280FN_(ORA_IMM) { A = ORA(A, arg1); }
HUC6280FN_(ORA_MEM) { A = ORA(A, READ(arg1)); }

/* P(T)Ή */
HUC6280FN_(EOR_IMM) { A = EOR(A, arg1); }
HUC6280FN_(EOR_MEM) { A = EOR(A, READ(arg1)); }

HUC6280FN_(BIT_IMM) { BIT(A, arg1); }
HUC6280FN_(BIT_MEM) { BIT(A, READ(arg1)); }

#endif /*HUC6280_ASM*/

HUC6280FN_(TST_IMM_MEM) { BIT(arg1, READ(arg2)); } /*vmF*/

/****************************************************************************
 *	VtgE[e[g
 ****************************************************************************/

#ifndef HUC6280_ASM

HUC6280FN_(ASL_ACC) { A = ASL(A); }
HUC6280FN_(ASL_MEM) { WRITE(arg1, ASL(READ(arg1))); }

HUC6280FN_(LSR_ACC) { A = LSR(A); }
HUC6280FN_(LSR_MEM) { WRITE(arg1, LSR(READ(arg1))); }

HUC6280FN_(ROL_ACC) { A = ROL(A); }
HUC6280FN_(ROL_MEM) { WRITE(arg1, ROL(READ(arg1))); }

HUC6280FN_(ROR_ACC) { A = ROR(A); }
HUC6280FN_(ROR_MEM) { WRITE(arg1, ROR(READ(arg1))); }

#endif /*HUC6280_ASM*/

/****************************************************************************
 *	t[
 ****************************************************************************/

#ifndef HUC6280_ASM

HUC6280FN_(BRA_MEM) { PC = arg1; CLT; }
HUC6280FN_(BSR_MEM) { PC--/*dl*/; PUSHW(PC); PC = arg1; CLT; }
HUC6280FN_(RTS_IMP) { PULLW(PC); PC++/*dl*/; CLT; }

HUC6280FN_(BCC_MEM) { if(!(P &    1)) { PC = arg1; CYCLE--; } CLT; }
HUC6280FN_(BCS_MEM) { if( (P &    1)) { PC = arg1; CYCLE--; } CLT; }
HUC6280FN_(BNE_MEM) { if(!(P &    2)) { PC = arg1; CYCLE--; } CLT; }
HUC6280FN_(BEQ_MEM) { if( (P &    2)) { PC = arg1; CYCLE--; } CLT; }
HUC6280FN_(BVC_MEM) { if(!(P & 0x40)) { PC = arg1; CYCLE--; } CLT; }
HUC6280FN_(BVS_MEM) { if( (P & 0x40)) { PC = arg1; CYCLE--; } CLT; }
HUC6280FN_(BPL_MEM) { if(!(P & 0x80)) { PC = arg1; CYCLE--; } CLT; }
HUC6280FN_(BMI_MEM) { if( (P & 0x80)) { PC = arg1; CYCLE--; } CLT; }

#endif /*HUC6280_ASM*/

HUC6280FN_(BRK_IMP) { PC++/*dl*/; huc6280_int(huc6280, HUC6280_IRQ2_VECTOR, 1); CLT; }
HUC6280FN_(RTI_IMP) { huc6280_rti(huc6280); }

HUC6280FN_(BBR0_MEM_MEM) { if(!(READ(arg1) & (1 << 0))) { PC = arg2; CYCLE--; } CLT; }
HUC6280FN_(BBR1_MEM_MEM) { if(!(READ(arg1) & (1 << 1))) { PC = arg2; CYCLE--; } CLT; }
HUC6280FN_(BBR2_MEM_MEM) { if(!(READ(arg1) & (1 << 2))) { PC = arg2; CYCLE--; } CLT; }
HUC6280FN_(BBR3_MEM_MEM) { if(!(READ(arg1) & (1 << 3))) { PC = arg2; CYCLE--; } CLT; }
HUC6280FN_(BBR4_MEM_MEM) { if(!(READ(arg1) & (1 << 4))) { PC = arg2; CYCLE--; } CLT; }
HUC6280FN_(BBR5_MEM_MEM) { if(!(READ(arg1) & (1 << 5))) { PC = arg2; CYCLE--; } CLT; }
HUC6280FN_(BBR6_MEM_MEM) { if(!(READ(arg1) & (1 << 6))) { PC = arg2; CYCLE--; } CLT; }
HUC6280FN_(BBR7_MEM_MEM) { if(!(READ(arg1) & (1 << 7))) { PC = arg2; CYCLE--; } CLT; }

HUC6280FN_(BBS0_MEM_MEM) { if(READ(arg1) & (1 << 0)) { PC = arg2; CYCLE--; } CLT; }
HUC6280FN_(BBS1_MEM_MEM) { if(READ(arg1) & (1 << 1)) { PC = arg2; CYCLE--; } CLT; }
HUC6280FN_(BBS2_MEM_MEM) { if(READ(arg1) & (1 << 2)) { PC = arg2; CYCLE--; } CLT; }
HUC6280FN_(BBS3_MEM_MEM) { if(READ(arg1) & (1 << 3)) { PC = arg2; CYCLE--; } CLT; }
HUC6280FN_(BBS4_MEM_MEM) { if(READ(arg1) & (1 << 4)) { PC = arg2; CYCLE--; } CLT; }
HUC6280FN_(BBS5_MEM_MEM) { if(READ(arg1) & (1 << 5)) { PC = arg2; CYCLE--; } CLT; }
HUC6280FN_(BBS6_MEM_MEM) { if(READ(arg1) & (1 << 6)) { PC = arg2; CYCLE--; } CLT; }
HUC6280FN_(BBS7_MEM_MEM) { if(READ(arg1) & (1 << 7)) { PC = arg2; CYCLE--; } CLT; }

/****************************************************************************
 *	rbg
 ****************************************************************************/

HUC6280FN_(RMB0_MEM) { WRITE(arg1, READ(arg1) & ~(1 << 0)); CLT; }
HUC6280FN_(RMB1_MEM) { WRITE(arg1, READ(arg1) & ~(1 << 1)); CLT; }
HUC6280FN_(RMB2_MEM) { WRITE(arg1, READ(arg1) & ~(1 << 2)); CLT; }
HUC6280FN_(RMB3_MEM) { WRITE(arg1, READ(arg1) & ~(1 << 3)); CLT; }
HUC6280FN_(RMB4_MEM) { WRITE(arg1, READ(arg1) & ~(1 << 4)); CLT; }
HUC6280FN_(RMB5_MEM) { WRITE(arg1, READ(arg1) & ~(1 << 5)); CLT; }
HUC6280FN_(RMB6_MEM) { WRITE(arg1, READ(arg1) & ~(1 << 6)); CLT; }
HUC6280FN_(RMB7_MEM) { WRITE(arg1, READ(arg1) & ~(1 << 7)); CLT; }

HUC6280FN_(SMB0_MEM) { WRITE(arg1, READ(arg1) | (1 << 0)); CLT; }
HUC6280FN_(SMB1_MEM) { WRITE(arg1, READ(arg1) | (1 << 1)); CLT; }
HUC6280FN_(SMB2_MEM) { WRITE(arg1, READ(arg1) | (1 << 2)); CLT; }
HUC6280FN_(SMB3_MEM) { WRITE(arg1, READ(arg1) | (1 << 3)); CLT; }
HUC6280FN_(SMB4_MEM) { WRITE(arg1, READ(arg1) | (1 << 4)); CLT; }
HUC6280FN_(SMB5_MEM) { WRITE(arg1, READ(arg1) | (1 << 5)); CLT; }
HUC6280FN_(SMB6_MEM) { WRITE(arg1, READ(arg1) | (1 << 6)); CLT; }
HUC6280FN_(SMB7_MEM) { WRITE(arg1, READ(arg1) | (1 << 7)); CLT; }

HUC6280FN_(TRB_MEM) { unsigned char tmp = READ(arg1); BIT(A, tmp); WRITE(arg1, tmp & ~A); } /*vmF*/
HUC6280FN_(TSB_MEM) { unsigned char tmp = READ(arg1); BIT(A, tmp); WRITE(arg1, tmp |  A); } /*vmF*/

/****************************************************************************
 *	tO
 ****************************************************************************/

HUC6280FN_(CLC_IMP) { P &= ~   1; CLT; }
HUC6280FN_(CLI_IMP) { P &= ~   4; CLT; }
HUC6280FN_(CLD_IMP) { P &= ~   8; CLT; }
HUC6280FN_(CLV_IMP) { P &= ~0x40; CLT; }

HUC6280FN_(SEC_IMP) { P |=    1; CLT; }
HUC6280FN_(SEI_IMP) { P |=    4; CLT; }
HUC6280FN_(SED_IMP) { P |=    8; CLT; }
//HUC6280FN_(SET_IMP) { P |= 0x20; }
//ADC,AND,ORA,EORP(T)ɑΉ܂ł̓G[Ƃ܂B
HUC6280FN_(SET_IMP) { DIE(); }

/****************************************************************************
 *	ubN]
 ****************************************************************************/

/* * len̏l0Ȃ΁A]TCY64KBƂȂ܂B(dl)
 *   Ȃ킿Aw\ȓ]TCY1B`64KBłB
 *
 * * TAI/TIAɂāA]/]AhX +1/-1 ̏ŕω܂B(dl)
 *   rbg0𔽓]̂ł́܂!!
 *	<> TAI $0011,$0020,$0004
 *		[$0011] => [$0020]
 *		[$0012] => [$0021]
 *		[$0011] => [$0022]
 *		[$0012] => [$0023]
 */

HUC6280FN_(TIN_MEM_MEM_IMM) {
	unsigned short src = arg1;
	unsigned short dst = arg2;
	unsigned short len = arg3;
	do {
		WRITE(dst, READ(src));
		src++;
		len--;
		CYCLE -= 6;
	} while(len);
	CLT;
}
HUC6280FN_(TII_MEM_MEM_IMM) {
	unsigned short src = arg1;
	unsigned short dst = arg2;
	unsigned short len = arg3;
	do {
		WRITE(dst, READ(src));
		src++;
		dst++;
		len--;
		CYCLE -= 6;
	} while(len);
	CLT;
}
HUC6280FN_(TDD_MEM_MEM_IMM) {
	unsigned short src = arg1;
	unsigned short dst = arg2;
	unsigned short len = arg3;
	do {
		WRITE(dst, READ(src));
		src--;
		dst--;
		len--;
		CYCLE -= 6;
	} while(len);
	CLT;
}
HUC6280FN_(TAI_MEM_MEM_IMM) {
	unsigned short src = arg1;
	unsigned short dst = arg2;
	unsigned short len = arg3;
	unsigned short ofs = 0;
	do {
		WRITE(dst, READ((src + ofs) & 0xffff));
		dst++;
		len--;
		ofs ^= 1;
		CYCLE -= 6;
	} while(len);
	CLT;
}
HUC6280FN_(TIA_MEM_MEM_IMM) {
	unsigned short src = arg1;
	unsigned short dst = arg2;
	unsigned short len = arg3;
	unsigned short ofs = 0;
	do {
		WRITE((dst + ofs) & 0xffff, READ(src));
		src++;
		len--;
		ofs ^= 1;
		CYCLE -= 6;
	} while(len);
	CLT;
}

/****************************************************************************
 *	̑
 ****************************************************************************/

HUC6280FN_(NOP_IMP) { /** no job **/ CLT; }

HUC6280FN_(CSH_IMP) { /** no job **/ CLT; }
HUC6280FN_(CSL_IMP) { /** no job **/ CLT; }

HUC6280FN_(TAM_IMM) {
	/* rbgw肳ĂAꂼɓlݒB(dl) */
	if(arg1 & (1 << 0)) huc6280_mpr_set(huc6280, 0, A);
	if(arg1 & (1 << 1)) huc6280_mpr_set(huc6280, 1, A);
	if(arg1 & (1 << 2)) huc6280_mpr_set(huc6280, 2, A);
	if(arg1 & (1 << 3)) huc6280_mpr_set(huc6280, 3, A);
	if(arg1 & (1 << 4)) huc6280_mpr_set(huc6280, 4, A);
	if(arg1 & (1 << 5)) huc6280_mpr_set(huc6280, 5, A);
	if(arg1 & (1 << 6)) huc6280_mpr_set(huc6280, 6, A);
	if(arg1 & (1 << 7)) huc6280_mpr_set(huc6280, 7, A);
	CLT;
}
HUC6280FN_(TMA_IMM) {
	/* rbgw肳ĂAʃrbgDŏ㏑B(dl) */
	if(arg1 & (1 << 0)) A = MPR[0];
	if(arg1 & (1 << 1)) A = MPR[1];
	if(arg1 & (1 << 2)) A = MPR[2];
	if(arg1 & (1 << 3)) A = MPR[3];
	if(arg1 & (1 << 4)) A = MPR[4];
	if(arg1 & (1 << 5)) A = MPR[5];
	if(arg1 & (1 << 6)) A = MPR[6];
	if(arg1 & (1 << 7)) A = MPR[7];
	CLT;
}

HUC6280FN_(ST0_IMM) { huc6280->vdcout(huc6280, 0, (unsigned char)arg1); CLT; }
HUC6280FN_(ST1_IMM) { huc6280->vdcout(huc6280, 1, (unsigned char)arg1); CLT; }
HUC6280FN_(ST2_IMM) { huc6280->vdcout(huc6280, 2, (unsigned char)arg1); CLT; }

