%{
/*{{^R[h:y.tab.y(錾,%{`%})======================================*/
#ifdef  PIECE
#include "app.h"
#else //PIECE
#include "winapp.h"
#endif//PIECE
/* p[T[X^bN̏l`܂B
 * sizeof(YYSTYPE)*YYINITDEPTH) X^bNɊmۂ܂B
 * ftHgł200ƒ`ĂAP/ECEɂ͑傫܂B
 * P/ECEɓK؂ȁAȃTCY(16)ɁAĒ`܂B
 * p[T[X^bNsꍇ́AIɊĝŁA肠܂B
 */
#define YYINITDEPTH 16
/* G[񍐊֐`܂B */
void yyerror(const char* fmt, ...) {
  fprintf(stderr, "### error at line %d : ", yylineno);
  { va_list ap; va_start(ap, fmt); vfprintf(stderr, fmt, ap); va_end(ap); }
  fputc('\n', stderr); }
/*}}^R[h:y.tab.y(錾,%{`%})======================================*/
%}

%union {
	int   v_num;
	char* v_lab;
}
%token T_DEF
%token T_END
%token T_GOTO
%token T_CALL
%token T_REPEAT
%token T_SPEED
%token T_MOVE
%token T_WAIT
%token T_INIT
%token T_STOP
%token T_REL
%token T_ABS
%token T_USER
%token <v_num> T_NUM
%token <v_lab> T_LAB
%token T_EOL

%left '+' '-'
%left '*' '/'
%nonassoc T_UPL T_UMI
%type <v_num> expr

%%

all
	: /* empty */
	| all line
	;
line
	:       T_EOL
	| inst  T_EOL
	| error T_EOL		{ yyerrok; }		/* SẴV^NXG[񍐂邽߂Ɍp */
	;
inst
	: T_DEF T_LAB		{ inst_def($2); }
	|       T_LAB		{ inst_def($1); }	/* ȗL@ */
	//
	| T_END			{ inst_end(); }
	//
	| T_GOTO T_LAB		{ inst_goto($2); }
	//
	| T_CALL T_LAB		{ inst_call($2); }
	//
	| T_REPEAT expr		{ inst_repeat($2); }
	| T_REPEAT		{ inst_repeat(0); }	/*  */
	//
	| T_SPEED expr		{ inst_speed($2); }
	//
	| T_MOVE T_INIT		{ inst_move_init(); }
	|        T_INIT		{ inst_move_init(); }	/* ȗL@ */
	//
	| T_MOVE T_REL expr	{ inst_move_rel($3); }
	//
	| T_MOVE T_ABS expr	{ inst_move_abs($3); }
	| T_MOVE       expr	{ inst_move_abs($2); }	/* ȗL@ */
	//
	| T_MOVE T_STOP		{ inst_move_stop(); }
	|        T_STOP		{ inst_move_stop(); }	/* ȗL@ */
	//
	| T_WAIT T_REL expr	{ inst_wait_rel($3); }
	| T_WAIT       expr	{ inst_wait_rel($2); }	/* ȗL@ */
	//
	| T_WAIT T_ABS expr	{ inst_wait_abs($3); }
	//
	| T_WAIT T_STOP		{ inst_wait_stop(); }
	| T_WAIT		{ inst_wait_stop(); }	/* ȗL@ */
	//
	| T_USER expr		{ inst_user($2); }
	;
expr
	: T_NUM
	| '(' expr ')'		{ $$ =  $2; }
	| '+' expr %prec T_UPL	{ $$ =  $2; }
	| '-' expr %prec T_UMI	{ $$ = -$2; }
	| expr '+' expr		{ $$ = $1 + $3; }
	| expr '-' expr		{ $$ = $1 - $3; }
	| expr '*' expr		{ $$ = $1 * $3; }
	| expr '/' expr		{ $$ = $1 / $3; }
	;

%%
