#include <piece.h>
#include <string.h>
#include <musdef.h>

#define SECTOR_SIZE 4096		// PZN^̃TCY

#define RAW_FILE_NAME "drum.bin"	// Ff[^t@C
#define RAW_FILE_SIZE 39758		// Ff[^t@C̃TCY
#define ARCHIVE_FILE_NAME "drum.arc"	// kFf[^t@C
#define ARCHIVE_FILE_SIZE 29433		// kFf[^t@C̃TCY

// eFf[^̃TCY
#define SIZE_BD909    2641
#define SIZE_CYMBD    9795
#define SIZE_HANDCLAP 2153
#define SIZE_HC909    1427
#define SIZE_HO909    5665
#define SIZE_SD909    2254
#define SIZE_SDGATE   5823
#define SIZE_TOMH1    2360
#define SIZE_TOML1    4524
#define SIZE_TOMM1    3116

////////////////////////////////////////////////////////////////////////////////

// hȊỎF͂̂܂܎gp
extern INST i_square0;
extern INST i_saw0;
extern INST i_triangle0;
extern INST i_square;
extern INST i_saw;
extern INST i_triangle;

// hF
INST i_BD909    = {0, 0, 0, 0, PITCH16K, PITCH_C4, 0, 0, SIZE_BD909    << 14};
INST i_CYMBD    = {0, 0, 0, 0, PITCH16K, PITCH_C4, 0, 0, SIZE_CYMBD    << 14};
INST i_HANDCLAP = {0, 0, 0, 0, PITCH16K, PITCH_C4, 0, 0, SIZE_HANDCLAP << 14};
INST i_HC909    = {0, 0, 0, 0, PITCH16K, PITCH_C4, 0, 0, SIZE_HC909    << 14};
INST i_HO909    = {0, 0, 0, 0, PITCH16K, PITCH_C4, 0, 0, SIZE_HO909    << 14};
INST i_SD909    = {0, 0, 0, 0, PITCH16K, PITCH_C4, 0, 0, SIZE_SD909    << 14};
INST i_SDGATE   = {0, 0, 0, 0, PITCH16K, PITCH_C4, 0, 0, SIZE_SDGATE   << 14};
INST i_TOMH1    = {0, 0, 0, 0, PITCH16K, PITCH_C4, 0, 0, SIZE_TOMH1    << 14};
INST i_TOML1    = {0, 0, 0, 0, PITCH16K, PITCH_C4, 0, 0, SIZE_TOML1    << 14};
INST i_TOMM1    = {0, 0, 0, 0, PITCH16K, PITCH_C4, 0, 0, SIZE_TOMM1    << 14};

// Fe[u
INST *inst[] = {
  &i_square0,
  &i_saw0,
  &i_triangle0,
  &i_square,
  &i_saw,
  &i_triangle,
  &i_BD909,
  &i_SDGATE,
  &i_SD909,
  &i_HO909,
  &i_HC909,
  &i_CYMBD,
  &i_CYMBD,
  &i_TOMH1,
  &i_TOMM1,
  &i_TOML1,
  &i_HANDCLAP
};

// Ff[^pobt@
static signed char instBuffer[RAW_FILE_SIZE];

////////////////////////////////////////////////////////////////////////////////

// t@C̓ǂݍ
static BOOL readFile(char *fileName, void *buffer){
  FILEACC facc;
  int i, sectors;

  if(pceFileOpen(&facc, fileName, FOMD_RD) == 0){

    sectors = (facc.fsize + SECTOR_SIZE - 1) / SECTOR_SIZE;

    for(i = 0; i < sectors; i++){
      pceFileReadSct(&facc, buffer + i * SECTOR_SIZE, i, SECTOR_SIZE);
    }

    pceFileClose(&facc);

    return TRUE;
  }

  else{
    return FALSE;
  }
}

// t@C1oCgǂ
static int getNextByte(FILEACC *facc){
  static int offset = 0;

  if(offset < facc->fsize){
    if(offset % SECTOR_SIZE == 0){
      pceFileReadSct(facc, NULL, offset / SECTOR_SIZE, 0);
    }

    return facc->aptr[offset++ % SECTOR_SIZE];
  }
  else{
    return -1;
  }
}

////////////////////////////////////////////////////////////////////////////////

#define CHAR_SIZE 0x100
#define NODE_SIZE (2 * CHAR_SIZE + 2)

// nt}̃m[h
typedef struct {
  unsigned short count;		// qm[h̏opx̘a
  unsigned short parent;	// em[h
  unsigned short left;		// ̎qm[h
  unsigned short right;		// E̎qm[h
} NODE;

// f[^̓WJ
static BOOL decode(char *inputFileName, unsigned char *outputBuffer, int outputSize){
  FILEACC facc;
  NODE *node;
  int i, j, k, c, min1, min2, freeNode, root, parent, previous;
  unsigned char bit1[8] = {128, 64, 32, 16, 8, 4, 2, 1};

  // t@C̓ǂݍ
  if(pceFileOpen(&facc, inputFileName, FOMD_RD) == 1){
    return FALSE;
  }

  // nt}ؗp̗̈m
  //if((node = (NODE *)pceHeapAlloc(NODE_SIZE * sizeof(NODE))) == NULL){
  //2004/04/24 N.SAWA
  if((node = (NODE *)malloc(NODE_SIZE * sizeof(NODE))) == NULL){
    return FALSE;
  }

  // ȅopxZbg
  for(i = 0; i < NODE_SIZE; i++){
    node[i].count = 0;
  }
  for(i = 0; i < CHAR_SIZE; i++){
    if((c = getNextByte(&facc)) == -1){
      return FALSE;
    }
    node[i].count = 0x100 * c;

    if((c = getNextByte(&facc)) == -1){
      return FALSE;
    }
    node[i].count += c;
  }

  // EOF
  node[CHAR_SIZE].count = 1;

  // ԕ
  node[NODE_SIZE - 1].count = 0xffff;

  // nt}؂
  for(freeNode = CHAR_SIZE + 1; freeNode < NODE_SIZE - 1; freeNode++){
    min1 = NODE_SIZE - 1;
    min2 = NODE_SIZE - 1;

    for(i = 0; i < NODE_SIZE - 1; i++){
      if(node[i].count > 0){
        if(node[i].count < node[min1].count){
          min2 = min1;
          min1 = i;
        }
        else if(node[i].count < node[min2].count){
          min2 = i;
        }
      }
    }

    if(min2 == NODE_SIZE - 1){
      break;
    }

    node[freeNode].left = min1;
    node[freeNode].right = min2;
    node[freeNode].count = node[min1].count + node[min2].count;
    node[min1].parent = freeNode;
    node[min2].parent = freeNode;
    node[min1].count = 0;
    node[min2].count = 0;
  }
  root = min1;

  j = 0;
  previous = 0;

  if((c = getNextByte(&facc)) == -1){
    return FALSE;
  }

  // 
  for(i = 0; i < outputSize + 1; i++){

    // ɑΉ镶m[h𓾂
    k = root;
    do{
      parent = k;
      k = (c & bit1[j]) ? node[k].right : node[k].left;

      // 蓾Ȃ
      if(k >= parent){
        return FALSE;
      }

      // 8rbgǂ񂾂玟̃oCg
      j++;
      if(j == 8){
        j = 0;

        if((c = getNextByte(&facc)) == -1){
          return FALSE;
        }
      }

    }while (k > CHAR_SIZE);

    // EOF
    if(k == CHAR_SIZE){
      break;
    }

    // eoCg̍̃f[^ɖ߂
    previous = (k + previous) % 0x100;
    *outputBuffer = previous;
    outputBuffer++;
  }

  // nt}ؗp̗̈
  //pceHeapFree(node);
  //2004/04/24 N.SAWA
  free(node);

  return TRUE;
}

////////////////////////////////////////////////////////////////////////////////

int loadInst(void){
  int result;
  signed char *p;

  // kFf[^t@CΓWJēǂݍ
  if(decode(ARCHIVE_FILE_NAME, instBuffer, RAW_FILE_SIZE)){
    result = 0;
  }

  // Ff[^t@CΓǂݍ
  else if(readFile(RAW_FILE_NAME, instBuffer)){
    result = 0;
  }

  // Ff[^t@CȂΉFf[^0Ŗ߂
  else{
    memset(instBuffer, 0, RAW_FILE_SIZE);
    result = 1;
  }

  p = instBuffer;
  i_BD909.pData = p;

  p += SIZE_BD909;
  i_CYMBD.pData = p;

  p += SIZE_CYMBD;
  i_HANDCLAP.pData = p;

  p += SIZE_HANDCLAP;
  i_HC909.pData = p;

  p += SIZE_HC909;
  i_HO909.pData = p;

  p += SIZE_HO909;
  i_SD909.pData = p;

  p += SIZE_SD909;
  i_SDGATE.pData = p;

  p += SIZE_SDGATE;
  i_TOMH1.pData = p;

  p += SIZE_TOMH1;
  i_TOML1.pData = p;

  p += SIZE_TOML1;
  i_TOMM1.pData = p;

  return result;
}
