/********************************************************
 *
 *         Copyright (C), 1994  SEIKO EPSON Corp.
 *         ALL RIGHTS RESERVED
 *
 *      file name : time.h
 *
 *	This is include file for time functions.
 *
 *      Revision history
 *      	93/12/17  1.st release		S.Akaiwa
 *              94/02/07  modify for SMC88	M.Kudo
 *		97/03/25  modify for SMC33	M.Kudo
 *		06/02/22  modify for P/ECE	Naoyuki Sawa
 *			* /usr/PIECE/include ɂt@CÃt@CD悳悤A
 *			  clip.mkɂāACN[hpXݒ肵Ă܂B
 *			* RpCɈ^邽߁A֐錾K&RANSIɕύX܂B
 *			  ύXɂẮAwMSDN Cu Visual Studio 6.0xQlɂ܂B
 *		11/01/05  modify for P/ECE	Naoyuki Sawa
 *			* strftime()̊֐錾ǉ܂B
 *
 ********************************************************/

#ifndef _TIME_H
#define _TIME_H

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned long   size_t;     /* size of type */
#endif

typedef long            clock_t;    /* clock type */

typedef long            time_t;     /* time type */

#if !defined(NULL)
#  define NULL          ((void *)0L)/* null pointer */
#endif

struct  tm {                        /* time structure */
    int tm_sec;                     /* seconds (0-59) */
    int tm_min;                     /* minutes (0-59) */
    int tm_hour;                    /* hours (0-23) */
    int tm_mday;                    /* days (1-31) */
    int tm_mon;                     /* months (0-11) */
    int tm_year;                    /* year -1900 */
    int tm_wday;                    /* day of week (sun = 0) */
    int tm_yday;                    /* day of year (0 - 365) */
    int tm_isdst;                   /* non-zero if DST */
};

#define CLOCKS_PER_SEC  1000000     /* 1000000 cycles is 1 sec */

/* prototype definition */

extern time_t time(time_t* timer);			// extern  time_t      time( /* time_t * */ );
extern time_t mktime(struct tm* timeptr);		// extern  time_t      mktime( /* struct tm * */ );
extern struct tm* gmtime(const time_t* timer);		// extern  struct tm   *gmtime( /* time_t * */ );

extern double difftime(time_t timer1, time_t timer0);	// extern  double      difftime(/* time_t, time_t */);
extern clock_t clock();					// extern  clock_t     clock(/* void */);
extern struct tm* localtime(const time_t* timer);	// extern  struct tm   *localtime(/* const time_t * */);
extern char* asctime(const struct tm* timeptr);		// extern  char        *asctime(/* const struct tm * */);
extern char* ctime(const time_t* timer);		// extern  char        *ctime(/* const time_t * */);

extern size_t strftime(char* string, size_t maxsize, const char* format, const struct tm* timeptr);	/* 2011/01/05 ֐錾ǉ܂ */

#endif  /* _TIME_H */

