/*
 *	getopt.c
 *
 *	IvV
 *
 *	* Sun Mar 10 19:53:04 JST 2013 Naoyuki Sawa
 *	- 1st [XB
 *	- POSIXWgetopt()݊֐܂B
 *	- GNUggetopt_long()getopt_long_only()́A錾̂ݍs܂B
 *	  ́AłBAKvɉĎ\łB
 *	- UNIXł́Agetopt()<unistd.h>,getopt_long()getopt_long_only()<getopt.h>Ő錾Ă܂B
 *	  AP/ECEWindowsɂ<unistd.h>̂ŁAׂ͂<getopt.h>Ő錾邱Ƃɂ܂B
 *	- getopt()AP/ECẼAvP[VŎgp邱Ƃ́AقږƎv܂B
 *	  ɁAWindows̃c[vOgpړIŁApӂ܂B
 */
#include "clip.h"

/****************************************************************************
 *	O[oϐ
 ****************************************************************************/

char* optarg;
int   optind = 1;
int   optopt;
int   opterr = 1;
int   optreset;

/****************************************************************************
 *	getopt
 ****************************************************************************/

//uGETOPT(3)v(http://www.unix.com/man-page/FreeBSD/3/getopt/)p:
//The getopt() function incrementally parses a command line argument list argv and returns the next known option character.
//An option character is known if it has been specified in the string of accepted option characters, optstring.
//
//The option string optstring may contain the following elements:
// individual characters, and characters followed by a colon to indicate an option argument is to follow.
//For example, an option string "x" recognizes an option "-x", and an option string "x:" recognizes an option and argument "-x argument".
//It does not matter to getopt() if a following argument has leading white space.
//
//On return from getopt(), optarg points to an option argument, if it is anticipated,
// and the variable optind contains the index to the next argv argument for a subsequent call to getopt().
//The variable optopt saves the last known option character returned by getopt().
//
//The variables opterr and optind are both initialized to 1.
//The optind variable may be set to another value before a set of calls to getopt() in order to skip over more or less argv entries.
//
//In order to use getopt() to evaluate multiple sets of arguments, or to evaluate a single set of arguments multiple times,
// the variable optreset must be set to 1 before the second and each additional set of calls to getopt(), and the variable optind must be reinitialized.
//
//The getopt() function returns -1 when the argument list is exhausted.
//The interpretation of options in the argument list may be cancelled by the option '--' (double dash)
// which causes getopt() to signal the end of argument processing and return -1.
//When all options have been processed (i.e., up to the first non-option argument), getopt() returns -1.

int getopt(int argc, char* const argv[], const char* optstring) {
	static char* scanptr = ""; /* |C^ */
	//
	int optstring_first_character; /* optstring̐擪 */
	/* optstring̐擪擾Aꂪ':'Ȃ΁Aoptstring':'̌w悤ɂ܂B */
	if((optstring_first_character = *optstring) == ':') { optstring++; }
	/* optresetZbgĂc */
	if(optreset != 0) {
		/* optresetNA܂B */
		optreset = 0;
		/* |C^܂B */
		scanptr = "";
	}
	for(;;) {
		/* IvV擾܂B */
		optopt = *scanptr++;
		/* IvVL΁A܂ */
		if(optopt != '\0') { break; }
		/* optindXg𒴂ĂAIvV͂I܂B */
		if((unsigned)optind >= (unsigned)argc) { goto L_END; }
		/* |C^擾܂B */
		scanptr = argv[optind];
		/* vf1ڂ'-'łȂ΁AIvV͂I܂B */
		if(*scanptr++ != '-') { goto L_END; }
		/* |C^I[Ȃ΁Aoptind֐i߂Ă܂B(P"-"𖳎A[v邽) */
		if(*scanptr == '\0') { optind++; }
	}
	/* "--"ɑIvVwȂ΁c */
	if(optopt == '-') {
		/* optind֐i߂܂B */
		optind++;
		/* IvV͂I܂B */
		goto L_END;
	}
	/* |C^I[Ȃ΁Aoptind֐i߂Ă܂B */
	if(*scanptr == '\0') { optind++; }
	/* optstringAIvV܂B */
	optstring = strchr(optstring, optopt);
	/* optstring̒ɁAIvV΁c */
	if(optstring == NULL) {
		/* opterrZbgĂAG[bZ[W\܂B */
		if(opterr != 0) { die("illegal option '%c'", optopt); }
		/* '?'Ԃ܂B */
		return '?';
	}
	/* IvVKvȃIvVȂ΁c */
	if(*(optstring + 1) == ':') {
		/* |C^I[Ȃ΁c */
		if(*scanptr == '\0') {
			/* optindXg𒴂Ăc */
			if((unsigned)optind >= (unsigned)argc) {
				/* optstring̐擪':'Ȃ΁AG[bZ[W\':'Ԃ܂B */
				if(optstring_first_character == ':') { return ':'; }
				/* opterrZbgĂAG[bZ[W\܂B */
				if(opterr != 0) { die("option '%c' requires an argument", optopt); }
				/* '?'Ԃ܂B */
				return '?';
			}
			/* |C^擾܂B */
			scanptr = argv[optind];
		}
		/* vf̎c蕶AIvVƂ܂B */
		optarg = scanptr;
		/* optind֐i߂܂B */
		optind++;
		/* |C^܂B */
		scanptr = "";
	}
	/* IvVԂ܂B */
	return optopt;
L_END:
	/* |C^܂B */
	scanptr = "";
	/* -1Ԃ܂B */
	return -1;
}

/*---------------------------------------------------------------------------*/
#if 0
/* getopt()̃eXg */
static void test(const char* cmdline, const char* optstring) {
	int c;
	int argc = 0;
	char* argv[10];
	char* tmp = strdup(cmdline);
	char* ptr = strtok(tmp, " ");
	while(ptr != NULL) { argv[argc++] = ptr; ptr = strtok(NULL, " "); }
	printf("--- %s ---\n", argv[0]);
	while((c = getopt(argc, argv, optstring)) != -1) {
		ptr = strchr(optstring, c);
		printf("%c %c %s\n", c, optopt, ((ptr != NULL) && (*(ptr + 1) == ':')) ? optarg : "");
	}
	while(optind < argc) { printf("[%d] %s\n", optind, argv[optind]); optind++; }
	free(tmp);
	optreset = optind = 1; //̈Zbg̕]̂߂ɁAďwĂ
}
int main() {
	//IvVʂɎw肷ၬ
	test("test1 -a -b one two", "ab");
	//
	//a a
	//b b
	//[3] one
	//[4] two
	//IvV܂Ƃ߂Ďw肷ၬ
	test("test2 -ab one two", "ab");
	//
	//a a
	//b b
	//[2] one
	//[3] two
	//"--"ŃIvV͂Iၬ
	test("test3 -a -- -b one two", "ab");
	//
	//a a
	//[3] -b
	//[4] one
	//[5] two
	//󔒖ŃIvVt^ၬ
	test("test4 -a -barg one two", "ab:");
	//
	//a a
	//b b arg
	//[3] one
	//[4] two
	//󔒗LŃIvVt^ၬ
	test("test5 -a -b arg one two", "ab:");
	//
	//a a
	//b b arg
	//[4] one
	//[5] two
	//IvVsĂ鎞̓(1)
	test("test6 -a", "a:");
	//
	//option 'a' requires an argument
	//? a
	//IvVsĂ鎞̓(2)
	test("test7 -a", ":a:");
	//
	//: a
	return 0;
}
#endif

/****************************************************************************
 *	getopt_long
 ****************************************************************************/

int getopt_long(int argc, char* const argv[], const char* optstring, const struct option* longopts, int* longindex); /*  */

/****************************************************************************
 *	getopt_long_only
 ****************************************************************************/

int getopt_long_only(int argc, char* const argv[], const char* optstring, const struct option* longopts, int* longindex); /*  */
