/*	
 *	clipzip.h
 *
 *	P/ECE Zlib
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Sat Mar 13 13:00:00 JST 2004 Naoyuki Sawa
 *	- 1st release.
 *	* Sun Dec 19 20:21:00 JST 2004 Naoyuki Sawa
 *	- clippzl.hclipzip.h֖OύX܂B
 *	- ֐̃vtBNXp`zlib`֕ύX܂B
 *	  ֐̃vtBNXpunzip`zip`֕ύX܂B
 *	  \̖̃vtBNXP`ZLIB`֕ύX܂B
 *	  \̖̃vtBNXPUNZIP`ZIP`֕ύX܂B
 *	  ܂ŁA{ZlibƂ̖OՓ˂p`̖OtĂ̂łA
 *	  L̂悤ɖOύXĂA{ZlibƂ̖OՓ˂͋NȂ悤Ȃ̂ŁA
 *	  킩₷D悵zlib`Azip`̖OɕύX邱Ƃɂ܂B
 */
#ifndef __CLIP_ZIP_H__
#define __CLIP_ZIP_H__

/****************************************************************************
 *	oCgXg[ (o)
 ****************************************************************************/

typedef struct _ZLIBBYTESTREAM {
	unsigned char* buffer;	/* obt@擪AhX */
	int len;		/* obt@TCY (byteP) */
	int pos;		/* ݈ʒu   (byteP) */
} ZLIBBYTESTREAM;

/* oCgXg[܂B
 * [in]
 *	out		ZLIBBYTESTREAM\́B
 *	buffer		obt@擪AhXB
 *	len		obt@TCYB(oCgP)
 * [out]
 *	߂l		Ȃ΁A0Ԃ܂B
 *			sȂ΁A̒lԂ܂B
 */
int zlib_bytestream_init(ZLIBBYTESTREAM* out, void* buffer, int len);

/* oCgXg[1oCg݂܂B
 * [in]
 *	out		ZLIBBYTESTREAM\́B
 *	value		ރoCglB[7:0]
 *			[31:8]͎̂Ă܂B
 * [out]
 *	߂l		Ȃ΁A񂾃oCg(=1)Ԃ܂B
 *			sȂ΁A̒lԂ܂B
 */
int zlib_bytestream_put(ZLIBBYTESTREAM* out, int value);

/****************************************************************************
 *	rbgXg[ ()
 ****************************************************************************/

typedef struct _ZLIBBITSTREAM {
	const unsigned char* data;	/* f[^擪AhX */
	int len;			/* f[^TCY (bitP) */
	int pos;			/* ǂݍ݈ʒu (bitP) */
} ZLIBBITSTREAM;

/* rbgXg[܂B
 * [in]
 *	in		ZLIBBITSTREAM\́B
 *	data		f[^擪AhXB
 *	len		f[^TCYB(oCgP)
 * [out]
 *	߂l		Ȃ΁A0Ԃ܂B
 *			sȂ΁A̒lԂ܂B
 */
int zlib_bitstream_init(ZLIBBITSTREAM* in, const void* data, int len);

/* rbgXg[rbgǂݍ݂܂B
 * [in]
 *	in		ZLIBBITSTREAM\́B
 *	out		ǂݍ񂾃rbgi[ϐւ̃|C^B
 *			NULLw肷ƁAǂݍ񂾃rbĝ͎Ă܂B
 *	bits		ǂݍރrbgB(1`32)
 * [out]
 *	߂l		Ȃ΁Aǂݍ񂾃rbg(=bits)Ԃ܂B
 *			sȂ΁A̒lԂ܂B
 *	*out		ǂݍ񂾃rbgi[܂B
 *			NULLw肷ƁAǂݍ񂾃rbĝ͎Ă܂B
 */
int zlib_bitstream_get(ZLIBBITSTREAM* in, int* out, int bits);

/* ǂݍ݈ʒuwrbg̋E܂Ői߂܂B
 * [in]
 *	in		ZLIBBITSTREAM\́B
 *	bits		rbgB(1`)
 * [out]
 *	߂l		Ȃ΁A0Ԃ܂B
 *			sȂ΁A̒lԂ܂B
 * [note]
 *	* ǂݍ݈ʒu      oCgE܂Ői߂ɂ́Abits 8w肵܂B
 *	  ǂݍ݈ʒun[t[hE܂Ői߂ɂ́Abits16w肵܂B
 *	  ǂݍ݈ʒu      [hE܂Ői߂ɂ́Abits32w肵܂B
 *	* bits>8w肵ꍇAposlen𒴂ꍇ܂A肠܂B
 *	  pos>=lenȂ΁Aɂ掟zlib_bitstream_get()͎s0Ԃ܂B
 */
int zlib_bitstream_align(ZLIBBITSTREAM* in, int bits);

/****************************************************************************
 *	nt}
 ****************************************************************************/

#define ZLIBHUFFTREE_MAX_BITS	 15	/* ̍őrbg(dl) */
#define ZLIBHUFFTREE_MAX_VALUE	287	/* 蓖Ăl̍ől(dl)A286,287͖l */

typedef struct _ZLIBHUFFTREE {
	unsigned short next[2];	/* [0]:bit=0̒T / [1]:bit=1̒T */
} ZLIBHUFFTREE;

/* ZLIBHUFFTREE.next[bit] */
#define ZLIBHUFFTREE_BLANK	((1 << 16) - 1)	/* ZLIBHUFFTREE.next[bit]󂫂ł邱Ƃ܂B */
#define ZLIBHUFFTREE_LEAF	(1 << (16 - 1))	/* ZLIBHUFFTREE.next[bit]̍ŏʃrbg1Ȃ΁AȊÕrbgl܂B */
						/* ZLIBHUFFTREE.next[bit]̍ŏʃrbg0Ȃ΁Ãm[hCfNX܂B */

/* 0`values-1̒lɕ蓖āAnt}؂{Al}̃yAǉ܂B
 * [in]
 *	pht		ZLIBHUFFTREEzB
 *	len		ZLIBHUFFTREEz̗vfB
 *	code_bits	0`values-1̒lɑΉ镄̃rbgw肷zB(0`PHUFFCODE_MAX_BITS)
 *	values		code_bitsz̗vfB(0`PHUFFCODE_MAX_VALUE+1)
 * [out]
 *	߂l		gpZLIBHUFFTREEz̗vfԂ܂B
 *			sȂ΁A̒lԂ܂B
 * [note]
 *	* ĂяoɂāAcode_bitsz̓eݒ肵ĂĂB
 */
int zlib_hufftree_init(ZLIBHUFFTREE pht[/*len*/], int len, const unsigned char code_bits[/*values*/], int values);

/* nt}؂{Al}̃yAǉ܂B
 * [in]
 *	pht		ZLIBHUFFTREEzB
 *	len		ZLIBHUFFTREEz̗vfB
 *	code		B
 *	code_bits	rbgB(1`ZLIBHUFFTREE_MAX_BITS)
 *	value		lB(0`ZLIBHUFFTREE_INVALID_VALUE-1)
 * [out]
 *	߂l		ǉȂ΁Ali[m[h̃CfNXԂ܂B(0`len-1)
 *			ǉsȂ΁A̒lԂ܂B
 * [note]
 *	* zlib_hufftree_build()痘p܂B
 *	  ̑̊֐AvP[VvO璼ڌĂяoƂ͂܂B
 */
int zlib_hufftree_add(ZLIBHUFFTREE pht[/*len*/], int len, int code, int code_bits, int value);

/* nt}؂畄ɑΉl܂B
 * [in]
 *	pht		ZLIBHUFFTREEzB
 *	len		ZLIBHUFFTREEz̗vfB
 *	in		ǂݍރrbgXg[B
 * [out]
 *	߂l		Ȃ΁AlԂ܂B(0`INVALID_VALUE-1)
 *			ȂȂ΁A̒lԂ܂B
 */
int zlib_hufftree_lookup(ZLIBHUFFTREE pht[/*len*/], int len, ZLIBBITSTREAM* in);

/****************************************************************************
 *	Deflate`
 ****************************************************************************/

/* Deflate`̈kf[^WJ܂B
 * [in]
 *	out		oCgXg[B(o)
 *	in		rbgXg[B()
 * [out]
 *	߂l		WJȂ΁Ao̓f[^TCYԂ܂B(oCgP)
 *			WJsȂ΁A̒lԂ܂B
 */
int zlib_deflate_uncompress(ZLIBBYTESTREAM* out, ZLIBBITSTREAM* in);

/****************************************************************************
 *	Zlib`
 ****************************************************************************/

/* Zlib`̈kf[^WJ܂B
 * [in]
 *	outbuf		o̓obt@B
 *	outlen		o̓obt@TCYB(oCgP)
 *	inbuf		̓f[^B
 *	inlen		̓f[^TCYB(oCgP)
 * [out]
 *	߂l		WJȂ΁Ao̓f[^TCYԂ܂B(oCgP)
 *			WJsȂ΁A̒lԂ܂B
 */
int zlib_uncompress(void* outbuf, int outlen, const void* inbuf, int inlen);

/* Adler-32`FbNTvZ܂B
 * [in]
 *	data		f[^擪AhXB
 *	len		f[^TCYB(oCgP)
 * [out]
 *	߂l		Adler-32`FbNTԂ܂B
 * [note]
 *	* zlib_uncompress()痘p܂B
 *	  AvP[VvOPƂŗp\łB
 */
int zlib_adler32(const void* data, int len);

/****************************************************************************
 *	Zip`
 ****************************************************************************/

/*{{ZIPt@Cdl*/
#define ZIPLOCALFILEHEADER_SIGNATURE	0x04034b50
typedef struct _ZIPLOCALFILEHEADER {
	unsigned char local_file_header_signature[4];	/* + 0,4 */
	unsigned char version_needed_to_extract[2];	/* + 4,2 */
	unsigned char general_purpose_bit_flag[2];	/* + 6,2 */
	unsigned char compression_method[2];		/* + 8,2 */
	unsigned char last_mod_file_time[2];		/* +10,2 */
	unsigned char last_mod_file_date[2];		/* +12,2 */
	unsigned char crc32[4];				/* +14,4 */
	unsigned char compressed_size[4];		/* +18,4 */
	unsigned char uncompressed_size[4];		/* +22,4 */
	unsigned char filename_length[2];		/* +26,2 */
	unsigned char extra_field_length[2];		/* +28,2 */
	//filename[/*filename_length*/];
	//extra_field[/*extra_field_length*/];
	//file_data[/*compressed_size*/];
} ZIPLOCALFILEHEADER;				/* =30+n */
/*}}ZIPt@Cdl*/

typedef struct _ZIP {
	const unsigned char* data;	/* Zipf[^擪AhX */
	int len;			/* Zipf[^TCY */
	/* zip_dir() */
	int dir_pos;			/* t@C񑖍ʒu */
} ZIP;

/* ZIPLOCALFILEHEADERAKvȕo܂B */
typedef struct _ZIPDIR {
	char filename[128];		/* t@C */
	int compression_method;		/* k` */
	int compressed_size;		/* kf[^TCY */
	int uncompressed_size;		/* WJf[^TCY */
	int crc32;			/* CRC-32 */
	const void* file_data;		/* kf[^AhX */
} ZIPDIR;

/* Zipf[^J܂B
 * [in]
 *	zip		ZIP\́B
 *	data		Zipf[^擪AhXB
 *	len		Zipf[^TCYB(oCgP)
 * [out]
 *	߂l		Ȃ΁A0Ԃ܂B
 *			sȂ΁A̒lԂ܂B
 */
int zip_init(ZIP* zip, const void* data, int len);

/* t@Cǂݍ݂܂B
 * [in]
 *	zip		ZIP\́B
 *	dir		NULLw肷ƁAt@C񑖍ʒu擪֖߂܂B
 *			NULLȊOw肷ƁAt@CǂݍŊi[Aʒu֐i߂܂B
 * [out]
 *	߂l		dirNULLw肵ꍇA0Ԃ܂B
 *			dirNULLȊOw肵ꍇAt@CǂݍݐȂ΁A0Ԃ܂B
 *			                             t@CǂݍݎsȂ΁A̒lԂ܂B
 * [note]
 *	* t@Cꗗ\vO܂B
 *		zip_init(&zip, data, len);
 *		zip_dir(&zip, NULL);
 *		while(zip_dir(&zip, &dir) == 0) {
 *			puts(dir.filename);
 *		}
 */
int zip_dir(ZIP* zip, ZIPDIR* dir);

/* wt@CɈvt@Cǂݍ݂܂B
 * [in]
 *	zip		ZIP\́B
 *	filename	t@CB
 *	dir		t@Ci[邽߂̕ϐւ̃|C^B
 * [out]
 *	߂l		wt@CɈvt@C񂪌A0Ԃ܂B
 *			wt@CɈvt@C񂪌Ȃ΁A̒lԂ܂B
 * [note]
 *	* t@C̑啶Ə͋ʂ܂B
 *	  ܂ApX"/""\"͋ʂ܂B
 */
int zip_find(ZIP* zip, const char* filename, ZIPDIR* dir);

/* wt@CɈvt@CWJ܂B
 * [in]
 *	zip		ZIP\́B
 *	filename	t@CB
 *	outbuf		o̓obt@B
 *	outlen		o̓obt@TCYB(oCgP)
 * [out]
 *	߂l		Ȃ΁Ao̓oCgԂ܂B
 *			sȂ΁A̒lԂ܂B
 * [note]
 *	* s̗v́Â悤Ȃ̂܂B
 *	  Ewt@CɈvt@CȂB
 *	  Eo̓obt@TCYsĂB
 *	  EWJf[^CRCvȂB(Zipf[^jĂ)
 */
int zip_uncompress(ZIP* zip, const char* filename, void* outbuf, int outlen);

/* CRC-32vZ܂B
 * [in]
 *	data		f[^擪AhXB
 *	len		f[^TCYB(oCgP)
 * [out]
 *	߂l		CRC-32Ԃ܂B
 * [note]
 *	* zip_uncompress()痘p܂B
 *	  AvP[VvOPƂŗp\łB
 */
int zip_crc32(const void* data, int len);

#endif /*__CLIP_ZIP_H__*/

