/*
 *	cliptcl.h
 *
 *	TclC^v^
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2014 Naoyuki Sawa
 *
 *	* Sun Oct 26 19:32:00 JST 2014 Naoyuki Sawa
 *	- 1st [XB
 *	- ukeep/TclΉ.xlsvɁAΉ󋵂L^čs܂B
 *	* Tue Nov 04 01:55:50 JST 2014 Naoyuki Sawa
 *	- oOCƁAR[h̐s܂B
 *	  cliptcl.hɂ͍ŏ̒`cAAvP[VQƂKv̖`cliptcl.cֈڂ܂B
 *	* Wed Nov 05 21:29:10 JST 2014 Naoyuki Sawa
 *	- Tcl_LreplaceCmd()֐ɓᏈǉ܂BTcllreplaceR}h̎dlɏ]߂łB
 *	* Thu Nov 06 01:04:00 JST 2014 Naoyuki Sawa
 *	- 'string reverse'ǉ܂B'string reverse'́ATcl8.5a6ŒǉꂽR}hłB
 *	* Thu Nov 06 21:20:13 JST 2014 Naoyuki Sawa
 *	- 'lsort'R}h́A'-increasing','-decreasing'IvVΉ܂B
 */
#ifndef __CLIP_TCL_H__
#define __CLIP_TCL_H__

//
//ydvzW[́AK[x[WRN^[Ƃ̕pOƂĂ܂B@@@@@@@@@@@@@@@@@@@@
//EP/ECEł́ATcl_CreateInterp()ĂяoOɁAugc_init(GC_LEVEL_CONSERVATIVE);vsĂĂB
//EPCł́AK[x[WRN^[̃Cu(uBoehm GCv)NĂB@@@@@@@@@@@@@@
//

/****************************************************************************
 *	萔
 ****************************************************************************/
/* ʃR[h */
//When a TCL command returns, the string pointer interp->result points to a string containing return information from the command.
//In addition, the command procedure returns an integer value, which is one of the following:
#define TCL_OK				0				//Command completed normally; interp->result contains the command's result.
#define TCL_ERROR			1				//The command couldn't be completed successfully; interp->result describes what went wrong.
#define TCL_RETURN			2				//The command requests that the current procedure return; interp->result contains the procedure's return value.
#define TCL_BREAK			3				//The command requests that the innermost loop be exited; interp->result is meaningless.
#define TCL_CONTINUE			4				//Go on to the next iteration of the current loop; interp->result is meaninless.
/****************************************************************************
 *	\
 ****************************************************************************/
/* C^v^ */
typedef struct _Tcl_Interp {
	/*--- JtB[h ---*/
	const char*			result;				//Points to result returned by last command.	//AvP[VTcl_Eval*()̌ʂ𓾂邽߂ɂ̃tB[hQƂ邱ƂłBAvP[V`̃R}h֐̃tB[hɌʂi[邱ƂłB
	int				argc;				//
	char**				argv;				//Tcl_CmdProc()ւ̈			//AvP[VTcl_CreateCommand()ŃR}h֐o^AR}h֐͂̃tB[hQƂB̓Iɂ̓rgCR}h̊eTcl_*Cmd()֐̎QƂB
	void*				data;				//
	/*--- ȉ́AAvP[VAAvP[V`̃R}h֐AڎQƂĂ͂ȂB ---*/
	int				noEval;				//Z]ɃR}h̎s}邽߂̃JE^B̓IɂTcl_ExprGetValue()̎QƂB
	int				numLevels;			//Keeps track of how many nested calls to Tcl_Eval are in progress for this interpreter. It's used to delay deletion of the table until all Tcl_Eval invocations are completed.
	struct _Tcl_CallFrame*		framePtr;			//Points to top-most in stack of all nested procedure invocations. NULL means there are no active procedures.
	struct _Tcl_CallFrame*		varFramePtr;			//Points to the call frame whose variables are currently in use (same as framePtr unless an "uplevel" command is being executed). NULL means no procedure is active or "uplevel 0" is being exec'ed.
	struct _Tcl_Table*		commandTablePtr;		//Contains all of the commands currently registered in this interpreter. Indexed by strings; values have type (Tcl_Command*).
	struct _Tcl_Table*		globalTablePtr;			//Contains all global variables for interpreter. Indexed by strings; values have type (Tcl_Var*).
	struct _Tcl_Table*		arraySearchTablePtr;		//Contains all array searches currently active in this interpreter. Indexed by strings; values have type (Tcl_ArraySearch*).
	struct _Tcl_Table*		fileTablePtr;			//Contains all files opened in this interpreter. Indexed by strings; values have type (FILE*).
} Tcl_Interp;
/****************************************************************************
 *	O[o֐
 ****************************************************************************/
Tcl_Interp* Tcl_CreateInterp();
/*--------------------------------------------------------------------------*/
typedef int Tcl_CmdProc(Tcl_Interp* iPtr);
void Tcl_CreateCommand(Tcl_Interp* iPtr, const char* name, Tcl_CmdProc* proc, void* data);
int Tcl_DeleteCommand(Tcl_Interp* iPtr, char* name);
int Tcl_EvalString(Tcl_Interp* iPtr, const char* s);
int Tcl_EvalFile(Tcl_Interp* iPtr, FILE* fp);
/*--------------------------------------------------------------------------*/
char* Tcl_GetVar(Tcl_Interp* iPtr, const char* name);
char* Tcl_SetVar(Tcl_Interp* iPtr, char* name, const char* value);
int Tcl_UnsetVar(Tcl_Interp* iPtr, char* name);
/****************************************************************************
 *	
 ****************************************************************************/

#endif/*__CLIP_TCL_H__*/
