/*
 *	cliptcl.c
 *
 *	TclC^v^
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2014 Naoyuki Sawa
 *
 *	* Sun Oct 26 19:32:00 JST 2014 Naoyuki Sawa
 *	- 1st [XB
 *	- ukeep/TclΉ.xlsvɁAΉ󋵂L^čs܂B
 *	* Tue Nov 04 01:55:50 JST 2014 Naoyuki Sawa
 *	- oOCƁAR[h̐s܂B
 *	  cliptcl.hɂ͍ŏ̒`cAAvP[VQƂKv̖`cliptcl.cֈڂ܂B
 *	* Wed Nov 05 21:29:10 JST 2014 Naoyuki Sawa
 *	- Tcl_LreplaceCmd()֐ɓᏈǉ܂BTcllreplaceR}h̎dlɏ]߂łB
 *	* Thu Nov 06 01:04:00 JST 2014 Naoyuki Sawa
 *	- 'string reverse'ǉ܂B'string reverse'́ATcl8.5a6ŒǉꂽR}hłB
 *	* Thu Nov 06 21:20:13 JST 2014 Naoyuki Sawa
 *	- 'lsort'R}h́A'-increasing','-decreasing'IvVΉ܂B
 */
#include "clip.h"

//
//ydvzW[́AK[x[WRN^[Ƃ̕pOƂĂ܂B@@@@@@@@@@@@@@@@@@@@
//EP/ECEł́ATcl_CreateInterp()ĂяoOɁAugc_init(GC_LEVEL_CONSERVATIVE);vsĂĂB
//EPCł́AK[x[WRN^[̃Cu(uBoehm GCv)NĂB@@@@@@@@@@@@@@
//

/****************************************************************************
 *	[J֐錾
 ****************************************************************************/
//͂܂ꂽvf̔
static char* Tcl_IsEnclosedElement(const char* s, int leftChar, int rightChar, int termChar);
static char* Tcl_IsBracedElement(const char* s, int termChar);
static char* Tcl_IsQuotedElement(const char* s, int termChar);
/*--------------------------------------------------------------------------*/
//STclR}h̔
static int Tcl_CommandComplete(const char* s);
static char* Tcl_WordEnd(const char* s, int nested);
static char* Tcl_QuoteEnd(const char* s, int termChar);
static char* Tcl_VarNameEnd(const char* s);
/*--------------------------------------------------------------------------*/
//XgA񑀍
static int Tcl_SplitList(const char* s, char*** argvPtr);
static char* Tcl_Escape(const char* s);
static char* Tcl_Merge(char** argv);
static char* Tcl_Concat(char** argv);
/*--------------------------------------------------------------------------*/
//ނ̔
#define TCL_CHARTYPE_NORMAL		0	//LȊȎS
#define TCL_CHARTYPE_COMMAND_END	1	//'\0','\n',';'
#define TCL_CHARTYPE_SPACE		2	//'\t','\v','\f','\r',' '
#define TCL_CHARTYPE_QUOTE		3	//'"'
#define TCL_CHARTYPE_DOLLAR		4	//'$'
#define TCL_CHARTYPE_OPEN_BRACKET	5	//'['
#define TCL_CHARTYPE_BACKSLASH		6	//'\'
#define TCL_CHARTYPE_OPEN_BRACE		7	//'{'
//#define TCL_CHARTYPE_CLOSE_BRACE	8	//'}'				ˌTcl6.7̃\[Xł́A'}'ɑ΂镶CLOSE_BRACE`Ă邪ANORMALƓʂȂ̂ŁAʂłB]āACLOSE_BRACE͍폜B
static int Tcl_CharType(int c, int termChar);
/*--------------------------------------------------------------------------*/
//e[u
/* e[u */
typedef struct _Tcl_Table {
	LIST_ENTRY			list_head;			//(Tcl_TableEntry.list_entry)`FCB
} Tcl_Table;
/* e[uGg */
typedef struct _Tcl_TableEntry {
	LIST_ENTRY			list_entry;			//(Tcl_Table.list_head)փ`FC邽߂ɎgpB
	const char*			key;				//L[B	Tcl_CreateTableEntry()ݒ肷B
	void*				value;				//lB		Tcl_CreateTableEntry()VKGg쐬̏lNULLBe[ugpeɂĐݒEύXB
} Tcl_TableEntry;
static Tcl_Table* Tcl_CreateTable();
static Tcl_TableEntry* Tcl_CreateTableEntry(Tcl_Table* tablePtr, const char* key, int* newPtr/*NULLOK*/);
static Tcl_TableEntry* Tcl_FindTableEntry(Tcl_Table* tablePtr, const char* key);
static void Tcl_DeleteTableEntry(Tcl_TableEntry* entryPtr);
/*--------------------------------------------------------------------------*/
//G[bZ[W
static int Tcl_ErrMsg(Tcl_Interp* iPtr, const char* fmt, ...);
static int Tcl_WrongNumOfArgs(Tcl_Interp* iPtr);
static int Tcl_InvalidCmdName(Tcl_Interp* iPtr);
static void Tcl_VarErrMsg(Tcl_Interp* iPtr, const char* name1, const char* name2, const char* operation, const char* reason);
/*--------------------------------------------------------------------------*/
//C^v^
/* R[t[ */
typedef struct _Tcl_CallFrame {
	int				level;				//Level of this procedure, for "uplevel" purposes (i.e. corresponds to nesting of callerVarPtr's, not callerPtr's). 1 means outer-most procedure, 0 means top-level.
	Tcl_Table*			varTablePtr;			//Table containing all of procedure's local variables.
	struct _Tcl_CallFrame*		callerPtr;			//Value of interp->framePtr when this procedure was invoked (i.e. next in stack of all active procedures).
	struct _Tcl_CallFrame*		callerVarPtr;			//Value of interp->varFramePtr when this procedure was invoked (i.e. determines variable scoping within caller; same as callerPtr unless an "uplevel" command or something equivalent was active in the caller).
} Tcl_CallFrame;
//Tcl_Interp* Tcl_CreateInterp();	˃AvP[Vp֐ƂāAcliptcl.hɂĐ錾B
static void Tcl_AppendResultElement(Tcl_Interp* iPtr, const char* elem);
static void Tcl_AppendResultFormat(Tcl_Interp* iPtr, const char* fmt, ...);
/*--------------------------------------------------------------------------*/
//R}h
/* R}h */
typedef struct _Tcl_Command {
	Tcl_CmdProc*			proc;				//R}h֐
	void*				data;				//Cӂ̃f[^
} Tcl_Command;
/* rgCR}h` */
typedef struct _Tcl_BuiltInCmd {
	const char*			name;				//R}h
	Tcl_CmdProc*			proc;				//R}h֐
	unsigned char			minArgc;			//argc̍ŏlB0ȂΌȂB
	unsigned char			maxArgc;			//argc̍őlB0ȂΌȂB
} Tcl_BuiltInCmd;
//VC++6.0ł́Astaticzvfw肹ɑO錾ƃG[ɂȂ邽߁AO錾externōsKv悤B
//gccł́AL̖͐Astaticzvfw肹ɑO錾łB
#ifdef  _MSC_VER
extern const Tcl_BuiltInCmd TBL_BuiltInCmd[];
#else //_MSC_VER
static const Tcl_BuiltInCmd TBL_BuiltInCmd[];
#endif//_MSC_VER
//void Tcl_CreateCommand(Tcl_Interp* iPtr, const char* name, Tcl_CmdProc* proc, void* data);	˃AvP[Vp֐ƂāAcliptcl.hɂĐ錾B
//int Tcl_DeleteCommand(Tcl_Interp* iPtr, char* name);						˃AvP[Vp֐ƂāAcliptcl.hɂĐ錾B
static int Tcl_Eval(Tcl_Interp* iPtr, const char* s, char** termPtr/*NULLOK*/, int termChar);
//int Tcl_EvalString(Tcl_Interp* iPtr, const char* s);	˃AvP[Vp֐ƂāAcliptcl.hɂĐ錾B
//int Tcl_EvalFile(Tcl_Interp* iPtr, FILE* fp);		˃AvP[Vp֐ƂāAcliptcl.hɂĐ錾B
static char** Tcl_ParseWords(Tcl_Interp* iPtr, const char *s, char** termPtr, int termChar);
static char* Tcl_ParseQuotes(Tcl_Interp* iPtr, const char* s, char** termPtr, int rightChar);
static char* Tcl_ParseBraces(Tcl_Interp* iPtr, const char* s, char** termPtr, int termChar);
static char* Tcl_ParseVar(Tcl_Interp* iPtr, const char* s, char** termPtr);
/*--------------------------------------------------------------------------*/
//rgCR}h
static Tcl_CmdProc* Tcl_GetBuiltInCmd(Tcl_Interp* iPtr, const Tcl_BuiltInCmd* pBuiltInCmd, int argcIndex);
/*--------------------------------------------------------------------------*/
//ϐ
/* Tcl_Var.type */
#define TCL_VAR_UNDEFINED		0
#define TCL_VAR_SCALAR			1
#define TCL_VAR_ARRAY			2
#define TCL_VAR_UPVAR			3
typedef struct _Tcl_Var {
	int				type;
	union {
		char*			scalar;
		Tcl_Table*		array;
		Tcl_TableEntry*		upvar;				//̃tB[ȟ^(Tcl_Var*)ɂ邱Ƃ͂łȂBupvarϐoRunset鎞(Tcl_TableEntry*)KvłłB
	} value;
} Tcl_Var;
static void Tcl_SplitVarName(const char* name, char** name1, char** name2);
//char* Tcl_GetVar(Tcl_Interp* iPtr, const char* name);			˃AvP[Vp֐ƂāAcliptcl.hɂĐ錾B
//char* Tcl_SetVar(Tcl_Interp* iPtr, char* name, const char* value);	˃AvP[Vp֐ƂāAcliptcl.hɂĐ錾B
//int Tcl_UnsetVar(Tcl_Interp* iPtr, char* name);			˃AvP[Vp֐ƂāAcliptcl.hɂĐ錾B
static char* Tcl_GetVar2(Tcl_Interp* iPtr, const char* name1, const char* name2);
static char* Tcl_SetVar2(Tcl_Interp* iPtr, const char* name1, const char* name2, const char* value);
static int Tcl_UnsetVar2(Tcl_Interp* iPtr, const char* name1, const char* name2);
/*--------------------------------------------------------------------------*/
//ϊ
static int Tcl_GetInt(Tcl_Interp* iPtr, const char* s, int* intPtr);
static int Tcl_GetDouble(Tcl_Interp* iPtr, const char* s, double* doublePtr);
static int Tcl_GetBoolean(Tcl_Interp* iPtr, const char* s, int* booleanPtr);
static int Tcl_GetIndex(Tcl_Interp* iPtr, const char* s, int* indexPtr, int* endPtr);
/*--------------------------------------------------------------------------*/
//vV[W
/* vV[W̉Xgێ\ */
typedef struct _Tcl_Arg {
	char*				name;				//Name of argument starts here. The name is followed by space for the default, if there is one. The actual size of this field will be as large as necessary to hold both name and default value.
	char*				defValue;			//Pointer to arg's default value, or NULL if no default value.
	struct _Tcl_Arg*		nextArgPtr;			//Next argument for this procedure, or NULL if this is the last argument.
} Tcl_Arg;
/* vV[W */
typedef struct _Tcl_Proc {
	char*				command;			//Command that constitutes the body of the procedure (dynamically allocated).
	Tcl_Arg*			argPtr;				//Pointer to first of procedure's formal arguments, or NULL if none.
} Tcl_Proc;
static int Tcl_InterpProc(Tcl_Interp* iPtr);
static char** Tcl_GetFrame(Tcl_Interp* iPtr, char** argv, Tcl_CallFrame** pFramePtr);
/*--------------------------------------------------------------------------*/
//z񏈗
/* z񑖍 */
typedef struct _Tcl_ArraySearch {
	LIST_ENTRY*			list_entry;			//݂̑ʒułTcl_TableEntrýA(Tcl_TableEntry.list_entry)ւ̃|C^B	Tcl_StartArraySearch()ݒ肵ATcl_NextArrayElement()ύXB
} Tcl_ArraySearch;
/*--------------------------------------------------------------------------*/
//]
/* Tcl_ExprInfo.token */	//Tcl_ExprGetValue()TBL_TokenPrec[]̕тɈv鎖B
#define TCL_TOKEN_END			 0	//'\0'
#define TCL_TOKEN_VALUE			 1	//'$c','[c]','"c"','{c}',e
#define TCL_TOKEN_OPEN_PAREN		 2	//'('
#define TCL_TOKEN_CLOSE_PAREN		 3	//')'
#define TCL_TOKEN_COLON			 4	//':'		//':'Zq̈ł邪A̓sA񉉎ZqƂĈB
//Binary operators:						//                                                               v
#define TCL_TOKEN_QUESTY		 5	//'?'		//'?'͓񍀉ZqłȂA̓sA񍀉ZqƂĈB
#define TCL_TOKEN_OR			 6	//'||'
#define TCL_TOKEN_AND			 7	//'&&'
#define TCL_TOKEN_BIT_OR		 8	//'|'
#define TCL_TOKEN_BIT_XOR		 9	//'^'
#define TCL_TOKEN_BIT_AND		10	//'&'
#define TCL_TOKEN_EQUAL			11	//'=='
#define TCL_TOKEN_NEQ			12	//'!='
#define TCL_TOKEN_LESS			13	//'<'
#define TCL_TOKEN_GREATER		14	//'>'
#define TCL_TOKEN_LEQ			15	//'<='
#define TCL_TOKEN_GEQ			16	//'>='
#define TCL_TOKEN_LEFT_SHIFT		17	//'<<'
#define TCL_TOKEN_RIGHT_SHIFT		18	//'>>'
#define TCL_TOKEN_PLUS			19	//'+'
#define TCL_TOKEN_MINUS			20	//'-'
#define TCL_TOKEN_MULT			21	//'*'
#define TCL_TOKEN_DIVIDE		22	//'/'
#define TCL_TOKEN_MOD			23	//'%'
//Unary operators:
#define	TCL_TOKEN_UNARY_MINUS		24	//'-'
#define TCL_TOKEN_NOT			25	//'!'
#define TCL_TOKEN_BIT_NOT		26	//'~'
/* Tcl_ExprTopLevel()̎sExprێ\ */
typedef struct _Tcl_ExprInfo {
	int				token;			//Type of the last token to be parsed from expr. See below for definitions. Corresponds to the characters just before expr.
	char*				expr;			//Position to the next character to be scanned from the expression string.
} Tcl_ExprInfo;
/* Tcl_Value.type */
#define TCL_TYPE_STRING			 0
#define TCL_TYPE_INT			 1
#define TCL_TYPE_DOUBLE			 2
/* ̕]ɒlێ\ */
typedef struct _Tcl_Value {
	int				type;
	union {
		int			intValue;
		double			doubleValue;
		const char*		stringValue;
	} value;
} Tcl_Value;
static int Tcl_ExprString(Tcl_Interp* iPtr, const char* s);
//static int Tcl_ExprInt(Tcl_Interp* iPtr, const char* s, int* intPtr);			//݂̏ǂgpĂȂ̂ŖBKvɂȂLɂB
//static int Tcl_ExprDouble(Tcl_Interp* iPtr, const char* s, double* doublePtr);	//݂̏ǂgpĂȂ̂ŖBKvɂȂLɂB
static int Tcl_ExprBoolean(Tcl_Interp* iPtr, const char* s, int* booleanPtr);
static int Tcl_ExprTopLevel(Tcl_Interp* iPtr, const char* s, Tcl_Value* valuePtr);
static int Tcl_ExprGetValue(Tcl_Interp* iPtr, Tcl_ExprInfo* infoPtr, int prec, Tcl_Value* valuePtr);
static int Tcl_ExprLex(Tcl_Interp* iPtr, Tcl_ExprInfo* infoPtr, Tcl_Value* valuePtr);
static void Tcl_ExprParseString(Tcl_Interp* iPtr, const char* s, Tcl_Value* valuePtr);
static void Tcl_ExprMakeString(Tcl_Value* valuePtr);
/*--------------------------------------------------------------------------*/
//t@C
static FILE* Tcl_GetFile(Tcl_Interp* iPtr, const char* channelId);
/****************************************************************************
 *	TclC^v^ɈˑȂ֐
 ****************************************************************************/
/*==========================================================================*
 *	͂܂ꂽvf̔
 *==========================================================================*/
/* ̐擪ɁATcľdlɉA{`},,"`"ň͂܂ꂽvfL邩𔻒fB
 * [in]
 *	s		ׂ镶B
 *	leftChar	͂݊JnB'{',,'"'w肵ĂB(̕w\)
 *	rightChar	͂ݏIB'}',,'"'w肵ĂB(̕w\)
 *	termChar	͂ݏI̎̕ƂāAk,,spɉċe镶	Ƃ΁uset x [expr {1+1}]vp[X\Ƃ邽߂̈łB'}'̎󔒂łȂ']'łĂ'}'镶łƔ肵܂B	//{{2014/11/05:(termChar=-1)w肷ƔCӂ̕e悤ɂ܂B(termChar=-1)Tcl_ExprLex()płB}}
 * [out]
 *	߂l		͂܂ꂽvfȂ΁ȀI[|C^ԂBI[|C^Ƃ́ArightChar̎̈ʒułB
 *			͂܂ꂽvfłȂ΁ANULL|C^ԂB
 * [note]
 *	- ֐́ATcl_IsBracedElement()Tcl_IsQuotedElement()̋ʏƂč쐬܂A
 *	  ͔ėpIɍĂ̂ŁAleftChar,rightCharɔCӂ̕w肷邱Ƃł܂B
 *	- s̐擪ɁA͂܂ꂽvfL邩𔻒f@́Aȉ̒ʂłB
 *	  1. 1ڂ͂݊JnłȂ΁A͂܂ꂽvfłȂB
 *	  2. 2ڈȍ~A͂݊Jn,y,͂ݏII[ƂāAGXP[vB
 *	  3. ͂ݏIŏI[ꍇ́A[炷B[0ɂȂꍇA̕𒲂ׂB
 *	  3-1. ͂ݏI̎̕Ak,,sp,,e镶̂ꂩȂ΁A͂܂ꂽvfłB
 *	  3-2. ͂ݏI̎̕ȊO̕Ȃ΁A͂܂ꂽvfłȂB
 *	  4. ͂݊JnŏI[ꍇ́A[𑝂₷B
 *	  5. ȊO̕ŏI[ꍇ́A͂܂ꂽvfłȂB
 *	  ͂܂ꂽvfꍇ́A͂ݏI̎̈ʒuA͂܂ꂽvf̏I[|C^łB
 */
static char* Tcl_IsEnclosedElement(const char* s, int leftChar, int rightChar, int termChar) {
	const char delim[3] = { leftChar, rightChar, '\0' };
	int c, depth = 1;
	/* ŏ̕擾āA֐i߂B
	 * ŏ͂݊̕JnłȂ΁A͂܂ꂽvfł͂ȂB */
	if(*s++ != delim[0]) { return NULL; }
	for(;;) {
		/* GXP[vĂȂ͂݊Jn,͂ݏI,,kɓB܂ŁAGXP[vB
		 * GXP[vʂ́̕AsvȂ̂ŁAɊJB */
		free(strcompress(s, (char**)&s, delim));/* "\t\n\v\f\r "́A͂܂ꂽvf̒ɂẮAI[ł͂ȂB */
		/* GXP[vI[̕擾āA֐i߂B */
		c = *s++;
		/* ͂ݏIȂ΁c
		 * - ͂݊Jnƈ͂ݏIꍇ̂߂ɁA͂ݏIɔfB */
		if(c == delim[1]) {
			/* [炷B */
			depth--;
			/* [0ɂȂc */
			if(!depth) {
//{{2014/11/05:(termChar=-1)w肷ƔCӂ̕e悤ɂ܂B(termChar=-1)Tcl_ExprLex()płB
				/* expr̒ł'{','}'̑Oɂǂ̕LĂǂB */
				if(termChar == -1) { return (char*)s; }
//}}2014/11/05:(termChar=-1)w肷ƔCӂ̕e悤ɂ܂B(termChar=-1)Tcl_ExprLex()płB
				/* ͂ݏI̎̕Ak,,sp,,e镶̂ꂩȂ΁A͂܂ꂽvfłB
				 * ͂ݏI̎̈ʒuA͂܂ꂽvf̏I[|C^łB */
				if(!*s || isspace(*s) || ((*s == '\\') && (*(s+1) == '\n')) || (*s == termChar)) { return (char*)s; }
				/* ȊO̕Ȃ΁A͂܂ꂽvfłȂB */
				break;
			}
		/* ͂݊JnȂ΁c */
		} else if(c == delim[0]) {
			/* [𑝂₷B */
			depth++;
		/* ȊO̕Ȃ΁c */
		} else {
			/* ͂܂ꂽvfłȂB */
			break;
		}
	}
	/* ͂܂ꂽvfłȂ΁ANULLԂB */
	return NULL;
}
/*--------------------------------------------------------------------------*/
/* ̐擪ɁATcľdlɉA{`}ň͂܂ꂽvfL邩𔻒fB
 * s၄
 * Tcl_IsBracedElement(  "{123}"  )	True
 * Tcl_IsBracedElement( "{{123}"  )	False	[0ɂȂOɃkŏI[B
 * Tcl_IsBracedElement(  "{123}}" )	False	͂ݏI̎̕k,,󔒂łȂB
 * Tcl_IsBracedElement( " {123}"  )	False	1ڂ͂݊JnłȂB
 * Tcl_IsBracedElement(  "{123} " )	True
 * Tcl_IsBracedElement( "x{123}"  )	False	1ڂ͂݊JnłȂB
 * Tcl_IsBracedElement(  "{123}x" )	False	͂ݏI̎̕k,,󔒂łȂB
 * Tcl_IsBracedElement("x {123}"  )	False	1ڂ͂݊JnłȂB
 * Tcl_IsBracedElement(  "{123} x")	True
 */
static char* Tcl_IsBracedElement(const char* s, int termChar) {
	return Tcl_IsEnclosedElement(s, '{', '}', termChar);
}
/*--------------------------------------------------------------------------*/
/* ̐擪ɁATcľdlɉA"`"ň͂܂ꂽvfL邩𔻒fB
 * s၄
 * Tcl_IsQuotedElement(  "\"123\""  )	True
 * Tcl_IsQuotedElement("\"\"123\""  )	False	͂ݏI̎̕k,,󔒂łȂB
 * Tcl_IsQuotedElement(  "\"123\"\"")	False	͂ݏI̎̕k,,󔒂łȂB
 * Tcl_IsQuotedElement( " \"123\""  )	False	1ڂ͂݊JnłȂB
 * Tcl_IsQuotedElement(  "\"123\" " )	True
 * Tcl_IsQuotedElement( "x\"123\""  )	False	1ڂ͂݊JnłȂB
 * Tcl_IsQuotedElement(  "\"123\"x" )	False	͂ݏI̎̕k,,󔒂łȂB
 * Tcl_IsQuotedElement("x \"123\""  )	False	1ڂ͂݊JnłȂB
 * Tcl_IsQuotedElement(  "\"123\" x")	True
 */
static char* Tcl_IsQuotedElement(const char* s, int termChar) {
	return Tcl_IsEnclosedElement(s, '"', '"', termChar);
}
/*==========================================================================*
 *	STclR}h̔
 *==========================================================================*/
//݂̎́uinfovɖΉł邪ATcl_CommandComplete()śuinfo completevƓȂ̂ŁAQlƂĈpB
//uTcl 8.4.1 Manual Command Reference - infov(http://www.freesoftnet.co.jp/tclkits/doc/TclCmdRef/TclCmd/info_jp.htm)p:
//info complete command
//commandSTclR}h̏ꍇ1ԂAłȂꍇ0Ԃ܂B
//uSTclR}hvƂ́AĂȂpA劇ʁAʁA܂zvfȂƂӖłB
//̃R}h̓[U[̍sɓnR}h^Cvł悤ɂ邽߂ɁAs(C)w̓͊Ŏgp܂B
//R}hSłȂꍇAXNvg̓R}h邽߂ɁAǉ̍s^Cv܂ŕ]邱Ƃł܂B
/*--------------------------------------------------------------------------*/
/* sASȃR}hł邩𔻒fB
 * SȃR}hƂ́Au(|;){(Sȃ[h){(|;){...v̂ƂłB(Ȑł͂ȂB)
 * SȃR}hȂ΁A0ȊOԂB
 * SȃR}hłȂ΁A0ԂB
 * s}`Xe[ggłꍇ́ASĂ(=Ō)Xe[ggSł邩𔻒fB */
static int Tcl_CommandComplete(const char* s) {
//{{2014/10/25ύX:s󔒂΂łȂARgsǂݔ΂悤ɏCB
//	for(;;) {
//		/* s󔒂΂B */
//		while(isspace(*s)) { s++; }
//		/* 0ȏ̋󔒂ŏI[ĂASȃR}hłB */
//		if(!*s) { return 1; }
//		/* [hSł邩𔻒肷B */
//		s = Tcl_WordEnd(s, 0);
//		/* [hsSȂ΁ASȃR}hłȂB */
//		if(!*s) { return 0; }
//		/* [h̍Ṓ̕A̕pB */
//		s++;
//	}
//2014/10/25ύX:s󔒂΂łȂARgsǂݔ΂悤ɏCB
//̏ȂƁAu#i[vƂRgs͂ĉsƂɁASȃR}hƌȂȂB
//ȂȂ΁Au[v2oCgڂ'['ƌȂAsĂR}hpƔfĂ܂łB
//Tcl6.7̃\[Xł́ATcl_CommandComplete()ɂĂ̓Rgǂݔ΂sĂȂA
//Tcl_CommandComplete()ɂĂATcl_Eval()Ɠl̃Rgǂݔ΂KvƎv̂ŒǉB
//Ȃ݂Ɍɂ́A{2oCgڂ'['ƌȂĂ܂́ARĝ݂Ȃ炸"`"̒łN蓾̂ŁAƖ͑傫̂A
//Ƃ肠AvO{̂̒ł͓{ΉƂĂARgœ{邱Ƃ͓̂ŁARĝ̖ݑΏ邱ƂɂB
//A̕@ŉł̂́AuO[ox̃RgvłAu֐̃ubÑRgv̓{̖͉łȂB
//u֐̃ubÑRgv͂ł͂ȂTcl_WordEnd()̒ŉ߂邩łB
//ǂ̂ƂA{(Rgłł)ȂׂgpȂ悤ɂ̂S낤B
//ɂstrescape(),strcompress()CЂĂstrspn(),strcspn()}`oCgΉɉ邱ƂAe傫߂̂ōsȂƂɂB
//2014/10/25ǋL
//L̑ΉsĂA***Tcl̂̎dl̂߂***ARg̊ʂÂ炢oOɉe邱Ƃ͔ȂB
//Ƃ΁A{tclshőΘb[hŎsA
//  if {1} {
//  #if {2} {
//    puts ok
//  }
//̂悤ɓ͂ƁAsڂ̊ʂĂȂƔfăR}hsȂB(^Z͂ƎsB)
//ł́A^Z͂ĂsꂸAmissing close-braceG[ɂȂB
//Tcl̃Rg̊ʂ̈͂낢Ƃ킩Â炢̂ŁAtclC^v^OiKŉvvZbT(cppƂm4Ƃsed)gďSȋCB
//Tcl̃Rg̊ʂ̈ɂāA֘Aukeep/Why_can_I_not_place_unmatched_braces_in_Tcl_commentsvɕۑB
L_LineStart:
	//s,y,Z~R΂B
	while(isspace(*s) || (*s == ';')) { s++; }
	//0ȏ̋󔒂ŏI[ĂASȃR}hłB
	if(!*s) { return 1; }
	//s,,}`Xe[gg̐擪猩āAŏɌꂽ󔒕'#'Ȃ΃RgsłB
	if(*s == '#') {
		for(;;) {
			s++;								//'#'̎̕֐i߂B
			if((*s == '\n') && (*(s-1) != '\\')) { goto L_LineStart; }	//GXP[vĂȂsȂ΁ARgIƌȂBs̏ɖ߂B	s̏'\n'΂̂ŁAŐi߂Ȃč\ȂB
			if(!*s) { return 0; }						//s̃Rgŕ񂪏Iꍇ́ASȃR}hłȂB
		}
	//RgsłȂ΁c
	} else {
		for(;;) {
			//[hSł邩𔻒肷B
			s = Tcl_WordEnd(s, 0);
			//[hsSȂ΁ASȃR}hłȂB
			if(!*s) { return 0; }
			//[hZ~RŏI[ĂAs̏ɖ߂B												s̏';'΂̂ŁAŐi߂Ȃč\ȂB
			if(*s == ';') { goto L_LineStart; }
			//[h̍Ṓ̕A̕pB
			s++;
			//󔒂΂B
			while(isspace(*s)) {
				if(*s == '\n') { goto L_LineStart; }			//sAs̏ɖ߂B						s̏'\n'΂̂ŁAŐi߂Ȃč\ȂB
				s++;							//󔒂̎̕֐i߂B
			}
			//0ȏ̋󔒂ŏI[ĂASȃR}hłB
			if(!*s) { return 1; }
		}
	}
//}}2014/10/25ύX:s󔒂΂łȂARgsǂݔ΂悤ɏCB
}
/*--------------------------------------------------------------------------*/
/* s̒́AŏɌ[h́AŌ̕ւ̃|C^ԂB((+1)ł͂ȂB)
 * s̒ɁAŏɌ[hsSłꍇ́Akւ̃|C^ԂB
 * s̒ɁA[hȂꍇ́Akւ̃|C^ԂB */
static char* Tcl_WordEnd(const char* s, int nested) {
	char* p = (char*)s;
	/* s󔒂΂B */
	while(isspace(*p)) { p++; }
	/* [hdpŊJnĂc */
	if(*p == '"') {
		/* dpʒu擾B */
		p = Tcl_QuoteEnd(p + 1, '"');
		/* dpĂȂ΁Akւ̃|C^ԂB */
		if(!*p) { return p; }
		/* dpʒúA̕pB
		 * ۂɂ̓G[ł邪Ał͌pBTcl_Eval()ɂăG[ƂB */
		p++;
	/* [hgʂŊJnĂc */
	} else if(*p == '{') {
		/* Egʂ̈ʒu擾B */
//{{bC
//		strcompress(p, &p, "}");			//~~~ł{}̃lXgĂ炸uswitch 1 {{1}svWordEndƌȂĂ܂ĂB~~~
//		/* gʂĂȂ΁Akւ̃|C^ԂB */
//		if(!*p) { return p; }
//		/* Egʂ́A̕pB
//		 * ۂɂ̓G[ł邪Ał͌pBTcl_Eval()ɂăG[ƂB */
//		p++;
//bC
		p = Tcl_IsBracedElement(p, nested ? ']' : 0);	//[`]̒Ȃ'}'̌']'ĂĂok
		/* gʂĂȂ΁Akւ̃|C^ԂB */
		if(!p) { return strchr(s, '\0'); }		//Tcl_IsBracedElement()͕ĂȂNULLԂ̂ŁAēxI[TKvLBbCł̂ŁAłƌ̗ǂ@B
		//Tcl_IsBracedElement()'}'̎̈ʒuԂ̂p++͕sv
//}}bC
	}
	//Handle words that don't start with a brace or double-quote.
	//This code is also invoked if the word starts with a brace or double-quote and there is garbage after the closing brace or quote.
	//This is an error as far as Tcl_Eval is concerned, but for here the garbage is treated as part of the word.
	for(;;) {
///?		/* s󔒂΂B */									//Kvsv?v	2sLɂƁuwhile {1} {svŃ[hIĂ܂svB
///?		while(isspace(*p)) { p++; }									//Kvsv?v	
		/* ꕶ܂ł̕AGXP[vĎ擾B */
		strcompress(p, &p, "\t\n\v\f\r $;[]");
		if(!*p) {
			//Nested commands can't end because of the end of the string.
			if(nested) { return p; }
			if(str_has_suffix(s, "\\\n")) { return p; } //̍Ōɍsp(\+s)L鎞ɃR}hƌȂȂ߂̔łBȂGXP[vꂽ\+s(\\+s)̏ꍇ̓R}hƌȂKvL܂̏Ŕł܂B(\\+s)̏ꍇ͂ʂ炸Ɉԉ̃ubN֍sureturn p-1vŉs̈ʒuԂTcl_CommandComplete()ɂăR}hƔf邩łB
			return p - 1;
		} else if(*p == '$') {
			p = Tcl_VarNameEnd(p + 1);
			if(!*p) { return p; }
			p++;
		} else if(*p == ';') {
			//Include the semi-colon in the word that is returned.
			return p;
		} else if(*p == '[') {
			do {
				p = Tcl_WordEnd(p + 1, 1);
				if(!*p) { return p; }
			} while(*p != ']');
			p++;
		} else if(*p == ']') {
			if(nested) { return p; }
			p++;
		} else /*if(isspace(*p))*/ {
			return p - 1;
		}
	}
}
/*--------------------------------------------------------------------------*/
/* ͂܂ꂽ́AIւ̃|C^ԂB((+1)ł͂ȂB)
 * ͂܂ꂽ񂪁AĂȂꍇ́Akւ̃|C^ԂB
 * śA͂܂ꂽ́AJn̎̕w肷邱ƁB
 * <>u"ABC"v𒲂ׂꍇAs='A'̈ʒu,termChar='"'w肵Aʂ'"'̈ʒuƂȂB
 * <>u(ABC)v𒲂ׂꍇAs='A'̈ʒu,termChar=')'w肵Aʂ')'̈ʒuƂȂB */
static char* Tcl_QuoteEnd(const char* s, int termChar) {
	char* p = (char*)s;
	char* delim = strdup_printf("$[%c", termChar);
	for(;;) {
		strcompress(p, &p, delim);
		if(*p == '$') {
			p = Tcl_VarNameEnd(p + 1);
			if(!*p) { return p; }
			p++;
		} else if(*p == '[') {
			do {
				p = Tcl_WordEnd(p + 1, 1);
				if(!*p) { return p; }
			} while(*p != ']');
			p++;
		} else /*if(!*p || (*p == termChar))*/ {
			return p;
		}
	}
}
/*--------------------------------------------------------------------------*/
/* ϐ́̕AŌ̕ւ̃|C^ԂB((+1)ł͂ȂB)
 * ϐSłȂꍇ́Akւ̃|C^ԂB
 * śAϐɐs'$'́A̕(=ϐ̈ꕶ)w肷邱ƁB
 * <>u$ABCv𒲂ׂꍇAs='A'̈ʒuw肵Aʂ'C'̈ʒuƂȂB
 * <>u${ABC}v𒲂ׂꍇAs='{'̈ʒuw肵Aʂ'}'̈ʒuƂȂB
 * <>u$ABC(123)v𒲂ׂꍇAs='A'̈ʒuw肵Aʂ')'̈ʒuƂȂB */
static char* Tcl_VarNameEnd(const char* s) {
	char* p = (char*)s;
	if(*p == '{') {
		while(*p && (*p != '}')) { p++; }
		return p;
	} else {
		while(iscsym(*p)) { p++; }
		if(*p == '(') { return Tcl_QuoteEnd(p + 1, ')'); }
		return p - 1;
	}
}
/*==========================================================================*
 *	XgA񑀍
 *==========================================================================*/
/* XgƌȂĕAvfz쐬B
 * [in]
 *	s		镶B
 *	argvPtr		vfz̃|C^i[ϐւ̃|C^BNULLw肷Ɗi[ȂB
 * [out]
 *	߂l		vfB
 * [note]
 *	- vfźANULL|C^ŏI[܂B߂l̗vf́AI[NULL|C^܂݂܂B
 *	  (main֐́Aargc,argvƓlłB)
 *	- ĂяoŃJ@́Aȉ̂ƂłBGCgpꍇ́AJsvłB
 *	  const char s[]="1st \"\\x32nd \\x33rd\" {\\x34th \\x35th}";
 *	  char**argv;
 *	  int i,argc=Tcl_SplitList(s,&argv);
 *	  for(i=0;i<argc;i++){//I(argv[i])ł
 *	    printf("[%d] %s\n",i,argv[i]);
 *	  }
 *	  for(i=0;i<argc;i++){free(argv[i]);}//J
 *	  free(argv);                        //
 *	  ʁ
 *	  [0] 1st
 *	  [1] 2nd 3rd
 *	  [2] \x34th \x35th
 */
static int Tcl_SplitList(const char* s, char*** argvPtr/*NULLOK*/) {
	int    argc = 0;
	char** argv = NULL;
	for(;;) {
		char* elem = NULL;
		/* 擪̋󔒂ǂݔ΂B */
		s += strspn(s, "\t\n\v\f\r ");
		/* ̏I[łȂ΁c */
		if(*s) {
			char* endp;
			/* gʂň͂܂ꂽvfȂ΁c */
			if((endp = Tcl_IsBracedElement(s, 0))) {
				/* gʂ̒̕AGXP[vɎ擾B */	//{tclsh̋͏ႤBƂ돭XGŁu{\\}vˁu\\vCu{\}}vˁu\}vCu{\}v˕ĂȂcƂȂ悤BW[݂̌̎ł́u{\}}v˕ĂȂCu{\}vˁu\vƂȂB݂̎͋ɗ'{','}'g킸'\'ŃGXP[v悤ɂĂ̂ŁAōL̖肪݉댯͏̂A[U[͂̉߂ɂČ݉\BpxȂł낤ƂƁA΍􂷂邽߂̃R[hʂĂāA΍􂵂ȂƂɂBAɂȂꍇ͑΍􂹂B	ˁy2014/11/03zĊmFƂA݂̎̂܂܂łtclshƓłBL̒̓͂ԈႦĂ悤B{͌XȂ̂ƍl邪AƉݓIȃoỎ\L邽߁A΂炭̃Rg͎cĂB
				if(!(elem = strndup(s+1, endp-s-2))) { DIE(); }
			/* dpň͂܂ꂽvfȂ΁c */
			} else if((endp = Tcl_IsQuotedElement(s, 0))) {
				/* dp̒̕AGXP[vĎ擾B */
				elem = strcompress(s+1, NULL, "\"");
			/* ͂܂ꂽvfłȂ΁c */
			} else {
				/* 󔒕܂ł̕AGXP[vĎ擾B */
				elem = strcompress(s, &endp, "\t\n\v\f\r ");
			}
			/* I[(̓k)玟̗vfB */
			s = endp;
		}
		/* vfzɁAvf,,NULL|C^i[B */
		if(!(argv = realloc(argv, sizeof(char*) * (argc+1)))) { DIE(); }
		argv[argc] = elem;
		/* vfz̏I[Ȃ΁c */
		if(!elem) {
			/* vfz̃|C^i[BvĂȂΔjB */
			if(argvPtr) { *argvPtr = argv; } else { free(argvPtr); }
			/* vfԂBI[NULL|C^͗vfɊ܂߂ȂB */
			return argc;
		}
		/* vf𑝂₷B */
		argc++;
	}
}
/*--------------------------------------------------------------------------*/
/* GXP[vB
 * 󕶎łꍇ́AIȋvf"\0"ɕϊB
 * [in]
 *	s		GXP[v镶B
 * [out]
 *	߂l		GXP[vʂ̕B
 */
static char* Tcl_Escape(const char* s) {
	char* elem = strescape(s, " $;[]{}");			//GXP[vB
	if(!*elem) { elem = strdup("\\0"); }			//󕶎łꍇ́AIȋvf"\0"ɕϊB	//"\0"̑"{}"ł\܂BǂɂĂ삷͂łB
	return elem;
}
/*--------------------------------------------------------------------------*/
/* |C^z̊evfA"list"R}h̕@ŘAA쐬B
 * [in]
 *	argv		|C^zB	zNULL|C^vfŏI[Ă邱ƁB(main()֐argv[]ƓlłB)
 * [out]
 *	߂l		|C^z̊evfA"list"R}h̕@ŘAB
 *			A郋[́A֐̃RgQƂB
 */
static char* Tcl_Merge(char** argv) {
	char *s = strdup(""), *elem;
	while((elem = *argv++)) {
		elem = Tcl_Escape(elem);			//evfgȂBGXP[vB
	//	if(!*elem) { /** no job **/ }			//󕶎̗vf΂ȂBulist x "" yv̌ʂ́ux yvł͂Ȃux {} yv,,ux \0 yvɂȂB	Tcl_Escape()󕶎ԂƂ͖̂ŁA͖̔ʏłsvłB
		s = strjoin((*s ? " " : NULL), s, elem, NULL);	//Zp[^LB
	}
	return s;
}
/*--------------------------------------------------------------------------*/
/* |C^z̊evfA"concat"R}h̕@ŘAA쐬B
 * [in]
 *	argv		|C^zB	zNULL|C^vfŏI[Ă邱ƁB(main()֐argv[]ƓlłB)
 * [out]
 *	߂l		|C^z̊evfA"concat"R}h̕@ŘAB
 *			A郋[́A֐̃RgQƂB
 */
static char* Tcl_Concat(char** argv) {
	char *s = strdup(""), *elem;
	while((elem = *argv++)) {
		elem = strtrim(elem, 0, NULL);			//evfgBGXP[vȂB
		if(!*elem) { continue; }			//gʂ󕶎ƂȂvf͔΂Buconcat x "" yv̌ʂ́ux  yvł͂Ȃux yvɂȂB
		s = strjoin((*s ? " " : NULL), s, elem, NULL);	//Zp[^LB
	}
	return s;
}
/*==========================================================================*
 *	ނ̔
 *==========================================================================*/
/* c̕ނ𔻒肷BTcl_ParseWords()gpB
 * [in]
 *	c		肷镶B
 *	termChar	lXgR}ȟĂяołꍇ́A(termChar=']')w肷邱ƁB
 *			ȊȌꍇ́A(termChar=0)w肷邱ƁB
 * [out]
 *	߂l		TCL_CHARTYPE_*
 */
static int Tcl_CharType(int c, int termChar) {
	static const char TypeTable[]={
//		1,'}',				//8 TCL_CHARTYPE_CLOSE_BRACE	ˌTcl6.7̃\[Xł́A'}'ɑ΂镶CLOSE_BRACE`Ă邪ANORMALƓʂȂ̂ŁAʂłB]āACLOSE_BRACE͍폜B
		1,'{',				//7 TCL_CHARTYPE_OPEN_BRACE
		1,'\\',				//6 TCL_CHARTYPE_BACKSLASH
		1,'[',				//5 TCL_CHARTYPE_OPEN_BRACKET
		1,'$',				//4 TCL_CHARTYPE_DOLLAR
		1,'"',				//3 TCL_CHARTYPE_QUOTE
		5,'\t','\v','\f','\r',' ',	//2 TCL_CHARTYPE_SPACE
		3,'\0','\n',';'};		//1 TCL_CHARTYPE_COMMAND_END
	const char* p = TypeTable;
//	int t = TCL_CHARTYPE_CLOSE_BRACE;					ˌTcl6.7̃\[Xł́A'}'ɑ΂镶CLOSE_BRACE`Ă邪ANORMALƓʂȂ̂ŁAʂłB]āACLOSE_BRACE͍폜B
	int t = TCL_CHARTYPE_OPEN_BRACE;
	if(c == termChar) { return TCL_CHARTYPE_COMMAND_END; }	//(c=']')&&(termChar=']')̏ꍇ͂TCL_CHARTYPE_COMMAND_ENDƔfB(c='\0')&&(termChar=0)̏ꍇTCL_CHARTYPE_COMMAND_ENDƔf邪ȂB(c='\0')&&(termChar=']')̏ꍇ͉̃[v̒TCL_CHARTYPE_COMMAND_ENDƔfB
	do {
		int n = *p++;
		do {
			if(*p++ == c) { return t; }
		} while(--n);
	} while(--t);
	return TCL_CHARTYPE_NORMAL;
}
/*==========================================================================*
 *	e[u
 *==========================================================================*/
/* e[u쐬B
 * [out]
 *	߂l		e[uւ̃|C^B
 */
static Tcl_Table* Tcl_CreateTable() {
	Tcl_Table* tablePtr = calloc(sizeof(Tcl_Table), 1);	//e[ũmۂB
	InitializeListHead(&tablePtr->list_head);		//_uNXgB
	return tablePtr;
}
/*--------------------------------------------------------------------------*/
/* VKGg쐬,,Gg擾B
 * [in]
 *	tablePtr	e[uւ̃|C^B
 *	key		L[B
 *			VKGg쐬ꍇA֐L[𕡐B֐ԂAĂяo֐keywj󂵂ĂǂB
 *	newPtr		VKGg쐬(1)AGg擾(0)Ai[ϐւ̃|C^B
 *			NULLw肷ƁAi[ȂB
 * [out]
 *	߂l		Ggւ̃|C^B
 */
static Tcl_TableEntry* Tcl_CreateTableEntry(Tcl_Table* tablePtr, const char* key, int* newPtr/*NULLOK*/) {
	Tcl_TableEntry* entryPtr;
	int bNew = 0;								//VK(1)/(0)A(0)ƂĂB
	if(!(entryPtr = Tcl_FindTableEntry(tablePtr, key))) {			//Gg擾BGg΁c
		entryPtr = calloc(sizeof(Tcl_TableEntry), 1);			//VKGg̃mۂB
		InsertTailList(&tablePtr->list_head, &entryPtr->list_entry);	//VKGgAe[ũ_uNXg̖ɒǉB	ɒǉ邱Ƃ͕K{ł͂ȂBǉʒu͕sƍlBɒǉ邱ƂOƂR[hĂ͂ȂB
		entryPtr->key = strdup(key);					//L[𕡐Đݒ肷B					keyAĂяo֐̃X^bNt[ɍ쐬ꂽwĂ\邽߁Â܂ܐݒ肹ɕKvBۂɂ́A݂̎ł͍L̃P[X͖̂ł̂܂ܐݒ肵Ă\Ȃ̂A̕ύXŔ\͗L邽ߊm̂߂ɕ邱ƂɂB
		bNew = 1;							//VK(1)/(0)AVK(1)ƂB
	}
	if(newPtr) { *newPtr = bNew; }						//VK(1)/(0)Ai[ϐւ̃|C^w肳ĂAi[B
	return entryPtr;							//Ggւ̃|C^ԂB
}
/*--------------------------------------------------------------------------*/
/* GgB
 * [in]
 *	tablePtr	e[uւ̃|C^B
 *	key		L[B
 * [out]
 *	߂l		ꍇAGgւ̃|C^ԂB
 *	߂l		ȂꍇANULLԂB
 */
static Tcl_TableEntry* Tcl_FindTableEntry(Tcl_Table* tablePtr, const char* key) {
	LIST_ENTRY* list_head = &tablePtr->list_head;
	LIST_ENTRY* list_entry = list_head->Flink;
	while(list_entry != list_head) {
		Tcl_TableEntry* entryPtr = CONTAINING_RECORD(list_entry, Tcl_TableEntry, list_entry);
		if(!strcmp(entryPtr->key, key)) { return entryPtr; }
		list_entry = list_entry->Flink;
	}
	return NULL;
}
/*--------------------------------------------------------------------------*/
/* Gg폜B
 * [in]
 *	entryPtr	Ggւ̃|C^B
 */
static void Tcl_DeleteTableEntry(Tcl_TableEntry* entryPtr) {
	RemoveEntryList(&entryPtr->list_entry);
}
/****************************************************************************
 *	TclC^v^Ɉˑ֐
 ****************************************************************************/
/*==========================================================================*
 *	G[bZ[W
 *==========================================================================*/
static int Tcl_ErrMsg(Tcl_Interp* iPtr, const char* fmt, ...) {
	va_list ap;
	va_start(ap, fmt);
	if(iPtr->argv) {
		iPtr->result = strdup_printf("%s: \"%s\"", strdup_vprintf(fmt, ap), Tcl_Merge(iPtr->argv));	//vV[WĂяoꂽꍇ
	} else {
		iPtr->result = strdup_printf("%s",         strdup_vprintf(fmt, ap));				//gbvxĂяoꂽꍇ
	}
	va_end(ap);
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
static int Tcl_WrongNumOfArgs(Tcl_Interp* iPtr) {
	return Tcl_ErrMsg(iPtr, "wrong # args");
}
/*--------------------------------------------------------------------------*/
static int Tcl_InvalidCmdName(Tcl_Interp* iPtr) {
	return Tcl_ErrMsg(iPtr, "invalid command name");
}
/*--------------------------------------------------------------------------*/
static const char noSuchVar[]     = "no such variable";
static const char noSuchElement[] = "no such element in array";
static const char needScalar[]    = "variable isn't scalar";
static const char needArray[]     = "variable isn't array";
static void Tcl_VarErrMsg(Tcl_Interp* iPtr, const char* name1, const char* name2, const char* operation, const char* reason) {
	if(name2) {
		Tcl_ErrMsg(iPtr, "can't %s \"%s(%s)\": %s", operation, name1, name2, reason);
	} else {
		Tcl_ErrMsg(iPtr, "can't %s \"%s\": %s", operation, name1, reason);
	}
}
/*==========================================================================*
 *	C^v^
 *==========================================================================*/
/* C^v^쐬B
 * [out]
 *	߂l		C^v^ւ̃|C^B
 */
Tcl_Interp* Tcl_CreateInterp() {
	Tcl_Interp* iPtr;
	/* C^v^쐬B */
	iPtr = calloc(sizeof(Tcl_Interp), 1);
	iPtr->result = "";								//ʂ󕶎ɏB(iPtr->result)QƂꂽꍇ̈SłAۂɂ(ق)svȏłB
	iPtr->commandTablePtr     = Tcl_CreateTable();					//
	iPtr->globalTablePtr      = Tcl_CreateTable();					//ee[uB
	iPtr->arraySearchTablePtr = Tcl_CreateTable();					//
	iPtr->fileTablePtr        = Tcl_CreateTable();					//
	Tcl_CreateTableEntry(iPtr->fileTablePtr, "stdin",  NULL)->value = stdin;	//
	Tcl_CreateTableEntry(iPtr->fileTablePtr, "stdout", NULL)->value = stdout;	//Wo͂o^ĂB
	Tcl_CreateTableEntry(iPtr->fileTablePtr, "stderr", NULL)->value = stderr;	//
	return iPtr;
}
/*--------------------------------------------------------------------------*/
/* ʂ̕ɁAvfǉB
 * [in]
 *	iPtr		C^v^ւ̃|C^B
 *	elem		vfB
 * [note]
 *	- ǉ郋[́A֐̃RgQƂB
 */
static void Tcl_AppendResultElement(Tcl_Interp* iPtr, const char* elem) {
	iPtr->result = strjoin(
		*iPtr->result ? " " : NULL,	//Zp[^LB
		iPtr->result,
		Tcl_Escape(elem),		//GXP[vB
		NULL);
}
/*--------------------------------------------------------------------------*/
/* ʂ̕ɁAꂽǉB
 * [in]
 *	iPtr		C^v^ւ̃|C^B
 *	fmt		w蕶B
 *	...		ψB
 * [note]
 *	- ǉ郋[́A֐̃RgQƂB
 */
static void Tcl_AppendResultFormat(Tcl_Interp* iPtr, const char* fmt, ...) {
	va_list ap;
	va_start(ap, fmt);
	iPtr->result = strjoin(
		NULL,				//Zp[^B
		iPtr->result,
		strdup_vprintf(fmt, ap),	//GXP[vȂB
		NULL);
	va_end(ap);
}
/*--------------------------------------------------------------------------*/
//return ?string?
static int Tcl_ReturnCmd(Tcl_Interp* iPtr) {
	if(iPtr->argc == 2) { iPtr->result = iPtr->argv[1]; }
	return TCL_RETURN;
}
/*--------------------------------------------------------------------------*/
//error message
static int Tcl_ErrorCmd(Tcl_Interp* iPtr) {
	iPtr->result = iPtr->argv[1];
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
//catch script ?varName?
static int Tcl_CatchCmd(Tcl_Interp* iPtr) {
	int retCode = Tcl_EvalString(iPtr, iPtr->argv[1]);
	if(iPtr->argc == 3) {
		if(!Tcl_SetVar(iPtr, iPtr->argv[2], iPtr->result)) {
			return Tcl_ErrMsg(iPtr, "couldn't save command result in variable");
		}
	}
	iPtr->result = strdup_printf("%d", retCode);
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//eval arg ?arg ...?
static int Tcl_EvalCmd(Tcl_Interp* iPtr) {
	return Tcl_EvalString(iPtr, Tcl_Concat(iPtr->argv + 1));	//R}hȍ~AĎsB
}
/*==========================================================================*
 *	R}h
 *==========================================================================*/
/* VKR}ho^,,R}huB
 * [in]
 *	iPtr		C^v^ւ̃|C^B
 *	name		R}hB
 *	proc		R}h֐B
 *	data		Cӂ̃f[^B
 */
void Tcl_CreateCommand(Tcl_Interp* iPtr, const char* name, Tcl_CmdProc* proc, void* data) {
	Tcl_TableEntry* tPtr = Tcl_CreateTableEntry(iPtr->commandTablePtr, name, NULL);	//VKGg쐬,,Gg擾B
	Tcl_Command* cmdPtr = calloc(sizeof(Tcl_Command), 1);	//R}h̃mۂB
	tPtr->value = cmdPtr;	//GgɁAR}hi[BGgꍇ́AR}huB
	cmdPtr->proc = proc;	//R}hɁAR}h֐i[B
	cmdPtr->data = data;	//R}hɁACӂ̃f[^i[B
}
/*--------------------------------------------------------------------------*/
/* R}h폜B
 * [in]
 *	iPtr		C^v^ւ̃|C^B
 *	proc		R}h֐B
 *	data		Cӂ̃f[^B
 * [out]
 *	߂l		Ȃ0ԂB
 *			sȂ0ȊO̒lԂB
 */
int Tcl_DeleteCommand(Tcl_Interp* iPtr, char* name) {
	Tcl_TableEntry* tPtr = Tcl_FindTableEntry(iPtr->commandTablePtr, name);	//GgB
	if(!tPtr) { return -1; }	//Ggꍇ́AG[ƂB
	Tcl_DeleteTableEntry(tPtr);	//Gg폜B
	return 0;
}
/*--------------------------------------------------------------------------*/
/* R}hsB
 * [in]
 *	iPtr		C^v^ւ̃|C^B
 *	s		
 *	termPtr		[note]Q
 *	termChar	
 * [out]
 *	߂l		ʃR[hB
 * [note]
 *	- ֐́AtermCharɎw肷lɂāA2ނ̓sB
 *	  1. (termChar=0)w肵ꍇ:
 *	     sɂ́AR}h̐擪AhXw肷邱ƁB
 *	     ֐́AR}h'\0'܂ł́ASẴ}`Xe[ggsB
 *	     IꑫAtermPtrɂ'\0'̈ʒui[B
 *	  2. (termChar=']')w肵ꍇ:
 *	     sɂ́AR}h'['̎̈ʒuw肷邱ƁB
 *	     ֐́AR}h']'܂ł́ASẴ}`Xe[ggsB
 *	     IꑫAtermPtrɂ']'̈ʒui[B
 */
static int Tcl_Eval(Tcl_Interp* iPtr, const char* s, char** termPtr/*NULLOK*/, int termChar) {
	int retCode;
	char* p = (char*)s;
	char** argv;
	Tcl_TableEntry* tPtr;
	Tcl_CmdProc* cmdProc;
	/* ʂNAĂB
	 *- ȂƁA󕶎sƈȉwhile[vʂ炸AʂsɂȂĂ܂B */
	retCode = TCL_OK;
	iPtr->result = "";
	/* Ăяo̐[𑝂₷B */
	if(iPtr->numLevels >= 99/**/) { DIE(); }
	iPtr->numLevels++;
	//There can be many sub-commands (separated by semi-colons or newlines) in one command string.
	//This outer loop iterates over individual commands.
	//(termChar=']')ŁA']''\0'ɓBꍇ́ATcl_ParseWords()G[oă[v𔲂̂ŁAōlKv͖B
	while(*p != termChar) {
		/* Rgsǂݔ΂BRgsǂݔ΂͂łB
		 * - Tcl͍s̓rɗL'#'RgƌȂȂ̂ŁAR}ȟɌ'#'͍lKvB
		 *   <>u#puts okv̓RgsłBuputs ok #xxxv#ȍ~RgƌȂꂸG[ƂȂB */
		while(isspace(*p) || (*p == ';')) { p++; }	//s,y,Z~R΂B
		if(*p == '#') {	//s,,}`Xe[gg̐擪猩āAŏɌꂽ󔒕'#'Ȃ΃RgsłB
			do {
				p++;	//̕֐i߂B
				if((*p == '\n') && (*(p-1) != '\\')) { p++; break; }	//GXP[vĂȂsȂ΁ARgIƌȂBs̎̕֐i߁AB
			} while(*p);	//s̃Rgŕ񂪏IꍇB
		}
		/* R}h𕪉Az쐬B */
		argv = Tcl_ParseWords(iPtr, p, &p, termChar);	//IȂ΁ApTCL_CHARTYPE_COMMAND_END̈ʒuwB
		if(!argv) {
			retCode = TCL_ERROR;
			break;		//G[ȂΔBĂяo̐[炷KvL邽߁AreturnĂ͂ȂB
		}
		//If this is an empty command (or if we're just parsing commands without evaluating them), then just skip to the next command.
		if(!*argv || iPtr->noEval) { continue; }
		//At long last, invoke the command procedure.
		//Reset the result to its default empty value first (it could have gotten changed by earlier commands in the same command string).	dv
		iPtr->result = "";
		{
			/* Ăяop[^ޔB */
			int    save_argc = iPtr->argc;
			char** save_argv = iPtr->argv;
			void*  save_data = iPtr->data;
			/* Ăяop[^ݒ肷B */
			iPtr->argc = strv_length(argv);		//Tcl_GetBuiltInCmd()QƂ̂ŁAȉ̏ɐݒ肵ĂKvLB
			iPtr->argv = argv;			//
			/* AvP[VTcl_CreateCommand()œo^R}h,,XNvg'proc'Œ`R}hB */
			tPtr = Tcl_FindTableEntry(iPtr->commandTablePtr, argv[0]);
			/* AvP[VTcl_CreateCommand()œo^R}h,,XNvg'proc'Œ`R}hꍇc */
			if(tPtr) {
				/* R}h֐ƁACӂ̃f[^擾B */
				Tcl_Command* cmdPtr = tPtr->value;
				cmdProc    = cmdPtr->proc;
				iPtr->data = cmdPtr->data;	//Cӂ̃f[^L
			/* AvP[VTcl_CreateCommand()œo^R}h,,XNvg'proc'Œ`R}hȂꍇc */
			} else {
				/* rgCR}h֐B
				 * NOTE:AvP[VTcl_CreateCommand()œo^R}h,y,XNvg'proc'Œ`R}hƁArgCR}h֐AʂɌĂ闝Rɂ
				 * Tcl_CreateInterp()ɂărgCR}hTcl_Interp.commandTableɓo^΁AŃrgCR}hKv͖ȂA
				 * AvP[VTcl_CreateCommand()œo^R}h,y,XNvg'proc'Œ`R}hƓlɈ悤ɂȂ̂A
				 * ł́ARAMgpʂ̒ጸD悵āAL̕@͎ȂƂɂB
				 * rgCR}hTcl_Interp.commandTableɓo^Ɠo^m[hp̃ATBL_BuiltInCmd[]̏Əd񂪃ɑ݂邱ƂɂȂ薳ʂłB
				 * ʂ邽߂ɁAł́ArgCR}hTcl_Interp.commandTableɓo^ATBL_BuiltInCmd[]𒼐ڌ悤ɂB */
				cmdProc    = Tcl_GetBuiltInCmd(iPtr, TBL_BuiltInCmd, 0);	//ȂꍇTcl_GetBuiltInCmd()G[bZ[W̊֐ԂBNULLԂƂ͖Bł̏̓G[bZ[W̊֐R}h֐ƓlɎsΗǂBrgCR}h֐ȂꍇʈKv͖B
				iPtr->data = NULL;		//Cӂ̃f[^
			}
			/* R}h֐ĂяoB */
			retCode = (*cmdProc)(iPtr);
		//{{2014/11/03ǉ:ʂ̏G[bZ[Wi[TCL_ERRORԂꍇɁAǂŃG[𔻒fÂ炢ւ̑΍B{́AX̉ʂ̏K؂ȃG[bZ[Wi[悤ɂׂł邪Ab΍ƂĂōsƂɂB
			if((retCode == TCL_ERROR) && !*iPtr->result) { Tcl_ErrMsg(iPtr, "error in evaluating"); }
		//}}2014/11/03ǉ:ʂ̏G[bZ[Wi[TCL_ERRORԂꍇɁAǂŃG[𔻒fÂ炢ւ̑΍B{́AX̉ʂ̏K؂ȃG[bZ[Wi[悤ɂׂł邪Ab΍ƂĂōsƂɂB
			/* Ăяop[^𕜋AB */
			iPtr->argc = save_argc;
			iPtr->argv = save_argv;
			iPtr->data = save_data;
		}
		if(retCode) { break; }	//TCL_OKȊO(=TCL_ERROR,TCL_RETURN,TCL_BREAK,TCL_CONTINUE,...)ȂΔBĂяo̐[炷KvL邽߁AreturnĂ͂ȂB
	}
	/* Ăяo̐[炷B */
	iPtr->numLevels--;
	/* Ăяo̐[0ɂȂc */
	if(!iPtr->numLevels) {
		/* ʃR[hɂāc */
		switch(retCode) {
		case TCL_OK:
		case TCL_ERROR:
			/** no job **/
			break;
		case TCL_RETURN:
			/* gbvxreturnꍇAIƂB */
			retCode = TCL_OK;
			break;
		case TCL_BREAK:
			/* gbvxbreakꍇAG[IƂB */
			retCode = Tcl_ErrMsg(iPtr, "invoked \"break\" outside of a loop");
			break;
		case TCL_CONTINUE:
			/* gbvxcontinueꍇAG[IƂB */
			retCode = Tcl_ErrMsg(iPtr, "invoked \"continue\" outside of a loop");
			break;
		default:
			/* ȊO̖߂l̏ꍇAʂ̕ݒ肵ŁAʏ̃G[ƂB */
			retCode = Tcl_ErrMsg(iPtr, "command returned bad code %d", retCode);
			break;
		}
	}
	if(termPtr) { *termPtr = p; }	//I[ʒui[B
	return retCode;
}
/*--------------------------------------------------------------------------*/
/* sB
 * [in]
 *	iPtr		C^v^ւ̃|C^B
 *	s		B
 * [out]
 *	߂l		ʃR[hB
 */
int Tcl_EvalString(Tcl_Interp* iPtr, const char* s) {
	return Tcl_Eval(iPtr, s, NULL, 0);
}
/*--------------------------------------------------------------------------*/
/* Xg[sB
 * [in]
 *	iPtr		C^v^ւ̃|C^B
 *	s		Xg[B
 * [out]
 *	߂l		ʃR[hB
 * [note]
 *	- Xg[[Ȃ΁A֐͑ΘbIssB
 */
int Tcl_EvalFile(Tcl_Interp* iPtr, FILE* fp) {
	int interactive = isatty(fileno(fp));
	int retCode;
	do {
		const char* s = "";
		/* ΘbIsȂ΁c */
		if(interactive) {
			/* vvg\B */
			fputs("% ", stdout);
			fflush(     stdout);
		}
		do {
			do {
				char line[80/**/];
				/* ǂݍށBI[ȂΔB */
				if(!fgets(line, sizeof line, fp)) { break; }
				/* AB */
				s = strjoin(NULL, s, line, NULL);
			/* sȂΔB */
			} while(!str_has_suffix(s, "\n"));
			/* I[ȂΔB */
			if(feof(fp)) { break; }
		/* R}h܂ŌJԂB */
		} while(!Tcl_CommandComplete(s));
		/* R}hsB */
		retCode = Tcl_EvalString(iPtr, s);
		/* ΘbIsȂ΁c */
		if(interactive) {
			/* ,,G[\B */
			if(retCode) {
				printf("Error");
				if(retCode != TCL_ERROR) { printf(" %d", retCode); }
				if(*iPtr->result) { printf(": %s", iPtr->result); }
			} else {
				if(*iPtr->result) { printf("%s", iPtr->result); }
			}
			if(retCode || *iPtr->result) { printf("\n"); }
		/* ΘbIsłȂ΁c */
		} else {
			if(retCode) { break; }
		}
	/* I[܂ŌJԂB */
	} while(!feof(fp));
	/* Ō̌ʂԂB */
	return retCode;
}
/*--------------------------------------------------------------------------*/
/* [hтp[XB
 * [in]
 *	iPtr		C^v^ւ̃|C^B
 *	s		
 *	termPtr		[note]Q
 *	termChar	
 * [out]
 *	߂l		p[XłA|C^zԂB|C^źANULL|C^ŏI[ĂB
 *			G[Ȃ΁ANULLԂB
 * [note]
 *	- ֐́AtermCharɎw肷lɂāA2ނ̓sB
 *	  1. (termChar=0)w肵ꍇ:
 *	     sɂ́AR}h̐擪AhXw肷邱ƁB
 *	     ֐́AR}h'\0','\n',';'܂ł̃[hzp[XB
 *	     IꑫAtermPtrɂ'\0','\n',';'̈ʒui[B
 *	  2. (termChar=']')w肵ꍇ:
 *	     sɂ́AR}h'['̎̈ʒuw肷邱ƁB
 *	     ֐́AR}h']','\n',';'܂ł̃[hzp[XB
 *	     IꑫAtermPtrɂ']','\n',';'̈ʒui[B
 *	     ']','\n',';''\0'ɓBꍇ́AG[ƂB
 */
static char** Tcl_ParseWords(Tcl_Interp* iPtr, const char *s, char** termPtr, int termChar) {
	int retCode, type, argc = 0;
	char* p = (char*)s;
	char** argv = NULL;
	for(;;) {
		char* elem = strdup("");
		/* s󔒂ǂݔ΂B */
		while((type = Tcl_CharType(*p, termChar)) == TCL_CHARTYPE_SPACE) { p++; }
		/* obNXbV̏ꍇc */
		if(type == TCL_CHARTYPE_BACKSLASH) {
			/* spȂ΁A̍s̐s󔒂ǂݔ΂JԂB */
			if(*(p+1) == '\n') {
				p += 2;
			/* spȊÕobNXbVȂ΁Aʏ핶ƓƂB */
			} else {
				type = TCL_CHARTYPE_NORMAL;
			}
		}
		if(type == TCL_CHARTYPE_COMMAND_END) {
			if(!*p && (termChar == ']')) {	//lXgR}h']'ŏI[OɁȀI[ɓBꍇ́AG[ƂB
				Tcl_ErrMsg(iPtr, "missing close-bracket");
				return NULL;
			}
			break;	//R}hI
		} else if(type == TCL_CHARTYPE_QUOTE) {
			char* value = Tcl_ParseQuotes(iPtr, p+1, &p, '"');	//IȂ΁Ap'"'̈ʒuwB
			if(!value) { return NULL; }
			elem = strjoin(NULL, elem, value, NULL);
			p++;						//p'"'̎֐i߂B
			/* '"'̎ɋ̂́A,I[,sp݂̂łB */
			type = Tcl_CharType(*p, termChar);
			if((type == TCL_CHARTYPE_SPACE) ||				//
			   (type == TCL_CHARTYPE_COMMAND_END) ||			//I[
			  ((type == TCL_CHARTYPE_BACKSLASH) && (*(p+2) == '\n'))) {	//sp
				//L̂ꂩȂokB̃[h́Aus󔒂ǂݔ΂vŁAǂݔ΂B
			} else {
				Tcl_ErrMsg(iPtr, "extra characters after close-quote");
				return NULL;
			}
			//[hI
		} else if(type == TCL_CHARTYPE_OPEN_BRACE) {
			char* value = Tcl_ParseBraces(iPtr, p+1, &p, termChar);	//IȂ΁Ap'}'̈ʒuwB
			if(!value) { return NULL; }
			elem = strjoin(NULL, elem, value, NULL);
			p++;						//p'}'̎֐i߂B
			/* '}'̎ɋ̂́A,I[,sp݂̂łB */
			type = Tcl_CharType(*p, termChar);
			if((type == TCL_CHARTYPE_SPACE) ||				//
			   (type == TCL_CHARTYPE_COMMAND_END) ||			//I[
			  ((type == TCL_CHARTYPE_BACKSLASH) && (*(p+2) == '\n'))) {	//sp
				//L̂ꂩȂokB̃[h́Aus󔒂ǂݔ΂vŁAǂݔ΂B
			} else {
				Tcl_ErrMsg(iPtr, "extra characters after close-brace");
				return NULL;
			}
			//[hI
		} else {
			for(;;) {
				/* ꕶ̎O܂ŃGXP[vAɒǉB */
				char* value = strcompress(p, &p, "\t\n\v\f\r $;[]");	//̓lXgR}hOȂ̂ŁAI[(']'or'\0')̍lsvłB
				elem = strjoin(NULL, elem, value, NULL);
				/* ꕶ̎ނɂāc */
				type = Tcl_CharType(*p, termChar);
				if((type == TCL_CHARTYPE_SPACE) || (type == TCL_CHARTYPE_COMMAND_END)) {
					break;	//[hI
				} else if(type == TCL_CHARTYPE_OPEN_BRACKET) {
					retCode = Tcl_Eval(iPtr, p+1, &p, ']');		//IȂ΁Ap']'̈ʒuwB
					if(retCode) { return NULL; }
					elem = strjoin(NULL, elem, iPtr->result, NULL);
					p++;						//p']'̎֐i߂B
					//[hp
				} else if(type == TCL_CHARTYPE_DOLLAR) {
					value = Tcl_ParseVar(iPtr, p+1, &p);		//IȂ΁Ap͕ϐ(͕ϐ͂'}')̎̈ʒuwB
					if(!value) { return NULL; }
					elem = strjoin(NULL, elem, value, NULL);
					//[hp
				} else {
					elem = strdup_printf("%s%c", elem, *p++);	//ꕶ̃ReLXgł͒ʏ핶B
					//[hp
				}
			}
		}
		/* vfi[B */
		argv = realloc(argv, sizeof(char*) * (argc+1));
		argv[argc++] = elem;
	}
	/* I[NULLi[B */
	argv = realloc(argv, sizeof(char*) * (argc+1));
	argv[argc] = NULL;
	/* I[ʒui[B */
	*termPtr = p;	//pTCL_CHARTYPE_COMMAND_END̈ʒuwB
	return argv;
}
/*--------------------------------------------------------------------------*/
/* '"'̎̕A'"'܂łp[XB́A
 * '('̎̕A')'܂łp[XB҂́Azvfp[XۂɎgpB
 * [in]
 *	iPtr		C^v^ւ̃|C^B
 *	s		
 *	termPtr		[note]Q
 *	rightChar	
 * [out]
 *	߂l		p[XłAԂB
 *			G[Ȃ΁ANULLԂB
 * [note]
 *	- ֐́ArightCharɎw肷lɂāA2ނ̓sB
 *	  1. (rightChar='"')w肵ꍇ:
 *	     sɂ́AR}h'"'̎̈ʒuw肷邱ƁB
 *	     ֐́AR}h'"'܂ł̕p[XB
 *	     IꑫAtermPtrɂ'"'̈ʒui[B
 *	     '"''\0'ɓBꍇ́AG[ƂB
 *	  2. (rightChar=')')w肵ꍇ:
 *	     sɂ́AR}h'('̎̈ʒuw肷邱ƁB
 *	     ֐́AR}h')'܂ł̕p[XB
 *	     IꑫAtermPtrɂ')'̈ʒui[B
 *	     ')''\0'ɓBꍇ́AG[ƂB
 */
static char* Tcl_ParseQuotes(Tcl_Interp* iPtr, const char* s, char** termPtr, int rightChar) {
	int retCode;
	char* p = (char*)s;
	char* delim = strdup_printf("\t\n\v\f\r $;[]%c", rightChar);	//ꕶ+I[
	char* elem = strdup("");
	for(;;) {
		/* ꕶ,,I[̎O܂ŃGXP[vAɒǉB */
		char* value = strcompress(p, &p, delim);		//IȂ΁Ap͓ꕶ,,I[,,k̈ʒuwB
		elem = strjoin(NULL, elem, value, NULL);
		if(!*p) {
			Tcl_ErrMsg(iPtr, "missing %c", rightChar);	//I[ɁȀI[ɓBꍇ́AG[ƂB
			return NULL;
		} else if(*p == rightChar) {
			break;	//I
		} else if(*p == '$') {
			value = Tcl_ParseVar(iPtr, p+1, &p);		//IȂ΁Ap͕ϐ(͕ϐ͂'}')̎̈ʒuwB
			if(!value) { return NULL; }
			elem = strjoin(NULL, elem, value, NULL);
			//p
		} else if(*p == '[') {
			retCode = Tcl_Eval(iPtr, p+1, &p, ']');		//IȂ΁Ap']'̈ʒuwB
			if(retCode) { return NULL; }
			elem = strjoin(NULL, elem, iPtr->result, NULL);
			p++;						//p']'̎֐i߂B
			//p
		} else {
			elem = strdup_printf("%s%c", elem, *p++);	//ꕶ̃ReLXgł͒ʏ핶B
			//p
		}
	}
	*termPtr = p;	//I[,,k̈ʒui[B
	return elem;
}
/*--------------------------------------------------------------------------*/
/* '{'̎̕A'}'܂łp[XB
 * [in]
 *	iPtr		C^v^ւ̃|C^B
 *	s		
 *	termPtr		[note]Q
 *	termChar	
 * [out]
 *	߂l		p[XłAԂB
 *			G[Ȃ΁ANULLԂB
 * [note]
 *	- sɂ́AR}h'{'̎̈ʒuw肷邱ƁB
 *	  ֐́AR}h'}'܂ł̕p[XB
 *	  IꑫAtermPtrɂ'}'̈ʒui[B
 *	  '}''\0'ɓBꍇ́AG[ƂB
 */
static char* Tcl_ParseBraces(Tcl_Interp* iPtr, const char* s, char** termPtr, int termChar) {
	char* p = (char*)s;					//'{'̎̈ʒu
	/* gʂň͂܂ꂽvfłȂ΃G[B */
	char* endp = Tcl_IsBracedElement(p-1, termChar);	//IȂ΁Aendp'}'̎̈ʒuwB
	if(!endp) {
		Tcl_ErrMsg(iPtr, "missing close-brace");
		return NULL;
	}
	endp--;							//endp'}'̈ʒuwB
	/* gʂ̒̕AGXP[vɎ擾B */
	*termPtr = endp;					//'}'̈ʒu
	return strndup(p, endp-p);
}
/*--------------------------------------------------------------------------*/
/* '$'̎̕Aϐ(͕ϐ͂'}')̎̈ʒu܂łp[XAϐ̒l̕ԂB
 * [in]
 *	iPtr		C^v^ւ̃|C^B
 *	s		[note]Q
 *	termPtr		
 * [out]
 *	߂l		p[XłAϐ̒l̕ԂB
 *			G[Ȃ΁ANULLԂB
 * [note]
 *	- sɂ́AR}h'$'̎̈ʒuw肷邱ƁB
 *	  ֐́Aϐ\́Äʒu܂Ńp[XB̓Iɂ́Aȉ̂ꂩ:
 *	  $abc		Ăяosäʒuw肵A֐termPtrc̎̈ʒui[Aϐabc̒lԂB
 *	  ${abc}	Ăяos{̈ʒuw肵A֐termPtr}̎̈ʒui[Aϐabc̒lԂB
 *	  $abc(def)	Ăяosäʒuw肵A֐termPtr)̎̈ʒui[Aϐabc(def)̒lԂB
 */
static char* Tcl_ParseVar(Tcl_Interp* iPtr, const char* s, char** termPtr) {
	char *p = (char*)s, *q;
	char *name1, *name2 = NULL;
	if(*p == '{') {
		p++;							//p='{'̎̈ʒu
		for(q = p; *q != '}'; q++) {				//q='}'̈ʒu܂
			if(!*q) { return NULL; }
		}
		name1 = strndup(p, q-p);				//'{'̎̈ʒu'}'̑Öʒu܂ŕ
		p = q+1;						//p='}'̎̈ʒu
	} else {
		for(q = p; iscsym(*q); q++) { /** no job **/ }		//q=ϐƂėLȕ̎̈ʒu܂
		name1 = strndup(p, q-p);				//ϐ𕡐
		p = q;							//p=ϐƂėLȕ̎̈ʒu
		if(*p == '(') {
			name2 = Tcl_ParseQuotes(iPtr, p+1, &q, ')');	//IȂ΁Ap')'̈ʒuwB
			if(!name2) { return NULL; }
			p = q+1;					//p=')'̎̈ʒu
		}
	}
	*termPtr = p;							//'}'̎̈ʒu,,ϐƂėLȕ̎̈ʒu,,')'̎̈ʒu
	return Tcl_GetVar2(iPtr, name1, name2);
}
/*==========================================================================*
 *	rgCR}h
 *==========================================================================*/
/* rgCR}h֐B
 * [in]
 *	iPtr		C^v^ւ̃|C^B
 *	pBuiltInCmd	rgCR}h`e[uB	(Tcl_BuiltInCmd.name=NULL)ŏI[Ă邱ƁB
 *	argcIndex	rgCR}hrvf̃CfNXB
 * [out]
 *	߂l		ꍇArgCR}h֐ԂB
 *			ȂꍇAG[bZ[W̊֐R}h֐ƂĕԂB
 * [note]
 *	- Ăяoł́AꍇƌȂꍇʂKv͖B
 *	  ̓Iɂ́ATcl_Eval()̎QƂB
 */
static Tcl_CmdProc* Tcl_GetBuiltInCmd(Tcl_Interp* iPtr, const Tcl_BuiltInCmd* pBuiltInCmd, int argcIndex) {
	/* rgCR}h`e[ȕI[ɒB܂Łc */
	while(pBuiltInCmd->name) {
		/* w肳ꂽvfCfNX̗vfArgCR}hvc */
		if((iPtr->argc > argcIndex) && !strcmp(iPtr->argv[argcIndex], pBuiltInCmd->name)) {
			/* argc̍ŏl,ől͈̔͊OȂ΁AG[bZ[W̊֐R}h֐ƂĕԂB */
			if((pBuiltInCmd->minArgc && (iPtr->argc < pBuiltInCmd->minArgc)) ||
			   (pBuiltInCmd->maxArgc && (iPtr->argc > pBuiltInCmd->maxArgc))) {
				return &Tcl_WrongNumOfArgs;			//NOTE:VC++6.0ł'&'tɁureturn Tcl_WrongNumOfArgs;vƏƁuwarning C4550:͈ؽĂ̂Ȃ֐ɑ΂ĕ]܂vƂxoBgccł'&'tĂtȂĂǂBVC++6.0ł̌x邽߂'&'t邱ƂɂB
			}
			/* ꍇArgCR}h֐ԂB */
			return pBuiltInCmd->proc;
		}
		/* rgCR}h`e[u֐i߂B */
		pBuiltInCmd++;
	}
	/* Ȃꍇ́AG[bZ[W̊֐R}h֐ƂĕԂB */
	return &Tcl_InvalidCmdName;						//NOTE:VC++6.0ł'&'tɁureturn Tcl_InvalidCmdName;vƏƁuwarning C4550:͈ؽĂ̂Ȃ֐ɑ΂ĕ]܂vƂxoBgccł'&'tĂtȂĂǂBVC++6.0ł̌x邽߂'&'t邱ƂɂB
}
/*==========================================================================*
 *	ϐ
 *==========================================================================*/
/* ϐƔzvf𕪊B
 * [in]
 *	name		ϐBuabcv́uabc(def)v̌`ł邱ƁB
 * [out]
 *	name1		ϐi[|C^B
 *	name2		zvfi[|C^BzvfꍇNULL|C^i[B
 * [note]
 *	- name="abc"     w肳ꂽꍇAname1="abc",name2=NULL ƂȂB
 *	  name="abc(def)"w肳ꂽꍇAname1="abc",name2="def"ƂȂB
 *	- name="{abc}"   w肷邱Ƃ͂łȂB'{''}'菜́ATcl_ParseVar()ɂčsB
 */
static void Tcl_SplitVarName(const char* name, char** name1, char** name2) {
	char *lp, *rp;
	if((lp = strchr(name, '(')) &&			//'('LA
	   (rp = strchr(  lp, ')')) &&			//'('ȍ~')'LA
	   (!*(rp+1))) {				//')'Ō̕Ȃ΁c
		*name1 = strndup(name, lp-name);	//   ŏ̕A'('̑O̕܂
		*name2 = strndup(lp+1, rp-lp-1);	//'('̎̕A')'̑O̕܂
	} else {
		*name1 = strdup( name);
		*name2 = NULL;
	}
}
/*--------------------------------------------------------------------------*/
/* ϐ̒l̕擾B
 * [in]
 *	name		ϐBuabcv́uabc(def)v̌`ł邱ƁB
 * [out]
 *	߂l		ϐ̒l̕B
 *			G[Ȃ΁ANULLԂB
 */
char* Tcl_GetVar(Tcl_Interp* iPtr, const char* name) {
	char *name1, *name2;
	Tcl_SplitVarName(name, &name1, &name2);
	return Tcl_GetVar2(iPtr, name1, name2);
}
/*--------------------------------------------------------------------------*/
/* VKϐ쐬l̕ݒ肷,,ϐ̒l̕ݒ肷B
 * [in]
 *	name		ϐBuabcv́uabc(def)v̌`ł邱ƁB
 *	value		ϐ̒l̕B
 *			֐𕡐B֐ԂAĂяo֐valuewj󂵂ĂǂB
 * [out]
 *	߂l		ϐ̒l̕B
 *			G[Ȃ΁ANULLԂB
 * [note]
 *	- ֐Ԃvaluê̂ł͂ȂAłB
 *	  ]āAvaluej󂵂ĂA֐Ԃɂ͉eL܂B
 */
char* Tcl_SetVar(Tcl_Interp* iPtr, char* name, const char* value) {
	char *name1, *name2;
	Tcl_SplitVarName(name, &name1, &name2);
	return Tcl_SetVar2(iPtr, name1, name2, value);
}
/*--------------------------------------------------------------------------*/
/* ϐ폜B
 * [in]
 *	name		ϐBuabcv́uabc(def)v̌`ł邱ƁB
 * [out]
 *	߂l		Ȃ0ԂB
 *			sȂ0ȊO̒lԂB
 */
int Tcl_UnsetVar(Tcl_Interp* iPtr, char* name) {
	char *name1, *name2;
	Tcl_SplitVarName(name, &name1, &name2);
	return Tcl_UnsetVar2(iPtr, name1, name2);
}
/*--------------------------------------------------------------------------*/
/* ϐ̒l̕擾B
 * [in]
 *	name1		ϐBuabcv̌`ł邱ƁB
 *	name2		zvfBudefv̌`ł邱ƁBXJȂNULLw肹B
 * [out]
 *	߂l		ϐ̒l̕B
 *			G[Ȃ΁ANULLԂB
 */
static char* Tcl_GetVar2(Tcl_Interp* iPtr, const char* name1, const char* name2) {
	Tcl_Table* tablePtr;
	Tcl_TableEntry* tPtr;
	Tcl_Var* varPtr;
	/* R[t[,,O[o̕ϐe[u擾B */
	tablePtr = iPtr->varFramePtr ? iPtr->varFramePtr->varTablePtr : iPtr->globalTablePtr;
	/* ϐ擾B */
	if(!(tPtr = Tcl_FindTableEntry(tablePtr, name1))) {
		Tcl_VarErrMsg(iPtr, name1, name2, "read", noSuchVar);
		return NULL;
	}
	varPtr = tPtr->value;
	/* ㋉vV[WϐȂ΁c */
	if(varPtr->type == TCL_VAR_UPVAR) {
		tPtr = varPtr->value.upvar;
		varPtr = tPtr->value;
	}
	/* zvfw肳Ăc */
	if(name2) {
		/* zł邱ƂmFB */
		if(varPtr->type != TCL_VAR_ARRAY) {
			Tcl_VarErrMsg(iPtr, name1, name2, "read", needArray);
			return NULL;
		}
		/* zvf擾B */
		if(!(tPtr = Tcl_FindTableEntry(varPtr->value.array, name2))) {
			Tcl_VarErrMsg(iPtr, name1, name2, "read", noSuchElement);
			return NULL;
		}
		varPtr = tPtr->value;
	}
	/* XJł邱ƂmFB */
	if(varPtr->type != TCL_VAR_SCALAR) {
		Tcl_VarErrMsg(iPtr, name1, name2, "read", needScalar);
		return NULL;
	}
	/* ϐ̒l̕ԂB */
	return varPtr->value.scalar;
}
/*--------------------------------------------------------------------------*/
/* VKϐ쐬l̕ݒ肷,,ϐ̒l̕ݒ肷B
 * [in]
 *	name1		ϐBuabcv̌`ł邱ƁB
 *	name2		zvfBudefv̌`ł邱ƁBXJȂNULLw肹B
 *	value		ϐ̒l̕B
 *			֐𕡐B֐ԂAĂяo֐valuewj󂵂ĂǂB
 * [out]
 *	߂l		ϐ̒l̕B
 *			G[Ȃ΁ANULLԂB
 * [note]
 *	- ֐Ԃvaluê̂ł͂ȂAłB
 *	  ]āAvaluej󂵂ĂA֐Ԃɂ͉eL܂B
 */
static char* Tcl_SetVar2(Tcl_Interp* iPtr, const char* name1, const char* name2, const char* value) {
	int bNew;
	Tcl_Table* tablePtr;
	Tcl_TableEntry* tPtr;
	Tcl_Var* varPtr;
	/* R[t[,,O[o̕ϐe[u擾B */
	tablePtr = iPtr->varFramePtr ? iPtr->varFramePtr->varTablePtr : iPtr->globalTablePtr;
	/* ϐ̃Gg쐬,,擾B */
	tPtr = Tcl_CreateTableEntry(tablePtr, name1, &bNew);
	/* VKϐȂ΁c */
	if(bNew) {
		/* ϐ쐬B */
		varPtr = calloc(sizeof(Tcl_Var), 1);
		tPtr->value = varPtr;
	/* ϐȂ΁c */
	} else {
		/* ϐ擾B */
		varPtr = tPtr->value;
		/* ㋉vV[WϐȂ΁c */
		if(varPtr->type == TCL_VAR_UPVAR) {
			tPtr = varPtr->value.upvar;
			varPtr = tPtr->value;
		}
	}
	/* zvfw肳Ăc */
	if(name2) {
		/* `Ȃ΁c */				//`Ƃ́A݂Ȃϐւupvar,,ō쐬ϐ̂ƁB
		if(!varPtr->type) {
			varPtr->type = TCL_VAR_ARRAY;
			varPtr->value.array = Tcl_CreateTable();
		}
		/* zł邱ƂmFB */
		if(varPtr->type != TCL_VAR_ARRAY) {
			Tcl_VarErrMsg(iPtr, name1, name2, "set", needArray);
			return NULL;
		}
		/* zvf̃Gg쐬,,擾B */
		tPtr = Tcl_CreateTableEntry(varPtr->value.array, name2, &bNew);
		/* VK̔zvfȂ΁c */
		if(bNew) {
			/* zvf쐬B */
			varPtr = calloc(sizeof(Tcl_Var), 1);
			tPtr->value = varPtr;
		/* ̔zvfȂ΁c */
		} else {
			/* zvf擾B */
			varPtr = tPtr->value;
		}
	}
	/* `,,XJł邱ƂmFB */		//`Ƃ́A݂Ȃϐւupvar,,ō쐬ϐzvf̂ƁB
	if(varPtr->type && (varPtr->type != TCL_VAR_SCALAR)) {
		Tcl_VarErrMsg(iPtr, name1, name2, "set", needScalar);
		return NULL;
	}
	/* ϐ̒l̕ݒ肷B */
	varPtr->type = TCL_VAR_SCALAR;
	return (varPtr->value.scalar = strdup(value));		//𕡐Đݒ肷BԂB
}
/*--------------------------------------------------------------------------*/
/* ϐ폜B
 * [in]
 *	name1		ϐBuabcv̌`ł邱ƁB
 *	name2		zvfBudefv̌`ł邱ƁBXJȂNULLw肹B
 * [out]
 *	߂l		Ȃ0ԂB
 *			sȂ0ȊO̒lԂB
 */
static int Tcl_UnsetVar2(Tcl_Interp* iPtr, const char* name1, const char* name2) {
	Tcl_Table* tablePtr;
	Tcl_TableEntry* tPtr;
	Tcl_Var* varPtr;
	/* R[t[,,O[o̕ϐe[u擾B */
	tablePtr = iPtr->varFramePtr ? iPtr->varFramePtr->varTablePtr : iPtr->globalTablePtr;
	/* ϐ擾B */
	if(!(tPtr = Tcl_FindTableEntry(tablePtr, name1))) {
		Tcl_VarErrMsg(iPtr, name1, name2, "unset", noSuchVar);
		return -1;
	}
	varPtr = tPtr->value;
	/* ㋉vV[WϐȂ΁c */
	if(varPtr->type == TCL_VAR_UPVAR) {
		tPtr = varPtr->value.upvar;
		varPtr = tPtr->value;
	}
	/* zvfw肳Ăc */
	if(name2) {
		/* zł邱ƂmFB */
		if(varPtr->type != TCL_VAR_ARRAY) {
			Tcl_VarErrMsg(iPtr, name1, name2, "unset", needArray);
			return -1;
		}
		/* zvf擾B */
		if(!(tPtr = Tcl_FindTableEntry(varPtr->value.array, name2))) {
			Tcl_VarErrMsg(iPtr, name1, name2, "unset", noSuchElement);
			return -1;
		}
		varPtr = tPtr->value;
	}
	/* `łȂƂmFB */			//`Ƃ́A݂Ȃϐւupvar̂ƁB
	if(!varPtr->type) {
		Tcl_VarErrMsg(iPtr, name1, name2, "unset", noSuchVar);
		return -1;
	}
	/* ϐ폜B */
	Tcl_DeleteTableEntry(tPtr);
	return 0;
}
/*--------------------------------------------------------------------------*/
//set varName ?value?
static int Tcl_SetCmd(Tcl_Interp* iPtr) {
	const char* s;
	s = (iPtr->argc == 2) ? Tcl_GetVar(iPtr, iPtr->argv[1])
	                      : Tcl_SetVar(iPtr, iPtr->argv[1], iPtr->argv[2]);
	if(!s) { return TCL_ERROR; }
	iPtr->result = s;
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//unset ?name name name ...?
static int Tcl_UnsetCmd(Tcl_Interp* iPtr) {
	char **argv = iPtr->argv + 1, *name;
	while((name = *argv++)) {
		if(Tcl_UnsetVar(iPtr, name)) { return TCL_ERROR; }
	}
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//append varName ?value ...?
//lappend varName ?value ...?
static int Tcl_AppendCmd(Tcl_Interp* iPtr) {
	char **argv = iPtr->argv + 1, *elem;
	char *s = Tcl_GetVar(iPtr, *argv++);
	if(!s) { s = strdup(""); }		//VKϐւappend,lappend́A󕶎񂩂JnB
	while((elem = *argv++)) {
		if(*iPtr->argv[0] == 'l') {	//lappend̏ꍇ
			s = strjoin((*s ? " " : NULL), s, Tcl_Escape(elem), NULL);	//Zp[^LBevfGXP[vB
		} else {			// append̏ꍇ
			s = strjoin(            NULL , s,            elem , NULL);	//Zp[^BevfGXP[vȂB
		}
	}
	s = Tcl_SetVar(iPtr, iPtr->argv[1], s);
	if(!s) { return TCL_ERROR; }
	iPtr->result = s;
	return TCL_OK;
}
/*==========================================================================*
 *	ϊ
 *==========================================================================*/
/* w肳ꂽ񂪁AŐ󔒂SȐł邩mFAϊB
 * [in]
 *	iPtr		C^v^ւ̃|C^B
 *	s		B
 *	intPtr		i[ϐւ̃|C^B
 * [out]
 *	߂l		ʃR[hB
 */
static int Tcl_GetInt(Tcl_Interp* iPtr, const char* s, int* intPtr) {
	char* p = (char*)s;
	int i = strtol(p, &p, 0);		//l擾B
	while(*p && isspace(*p)) { p++; }	//ľ̋󔒂ǂݔ΂B
	if((p == s) || *p) {			//󕶎񂪎w肳ꂽ,,ľɋ󔒈ȊOL΃G[B
		return Tcl_ErrMsg(iPtr, "expected integer but got \"%s\"", s);
	}
	*intPtr = i;
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
/* w肳ꂽ񂪁AŐ󔒂SȎł邩mFAϊB
 * [in]
 *	iPtr		C^v^ւ̃|C^B
 *	s		B
 *	intPtr		i[ϐւ̃|C^B
 * [out]
 *	߂l		ʃR[hB
 */
static int Tcl_GetDouble(Tcl_Interp* iPtr, const char* s, double* doublePtr) {
	char* p = (char*)s;
	double d = strtod(p, &p);		//l擾B
	while(*p && isspace(*p)) { p++; }	//ľ̋󔒂ǂݔ΂B
	if((p == s) || *p) {			//󕶎񂪎w肳ꂽ,,ľɋ󔒈ȊOL΃G[B
		return Tcl_ErrMsg(iPtr, "expected floating-point number but got \"%s\"", s);
	}
	*doublePtr = d;
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
/* w肳ꂽ񂪁AŐ󔒂SȐ^Ulł邩mFAϊB
 * [in]
 *	iPtr		C^v^ւ̃|C^B
 *	s		B
 *	intPtr		i[ϐւ̃|C^B
 * [out]
 *	߂l		ʃR[hB
 */
static int Tcl_GetBoolean(Tcl_Interp* iPtr, const char* s, int* booleanPtr) {
	//gďB
	char* p = strlwr(strtrim(s, 0, NULL));
	//󕶎łȂ΁c
	if(*p) {
		static const char TBL_boolStr[3][2][5/*ő咷*/+1/*nul*/]={
			{"false","true"},
			{"no"   ,"yes" },
			{"off"  ,"on"  },
		};
		int i, mask = 0;
		double d;
		//^Ul̖̂̂ꂩɑOv邩?
		for(i = 0; i < ARRAY_SIZE(TBL_boolStr); i++) {
			if(str_has_prefix(TBL_boolStr[i][0], p)) { mask |= (1<<0); } //Û̖ɈvƂ}[NB
			if(str_has_prefix(TBL_boolStr[i][1], p)) { mask |= (1<<1); } //^̖̂ɈvƂ}[NB
		}
		if(mask == (1<<0)) { *booleanPtr = 0; return TCL_OK; } //Û̖݂̂ɈvAUƌ肷B"o"͗Ɉv̂ŏO邽߂̑΍łB
		if(mask == (1<<1)) { *booleanPtr = 1; return TCL_OK; } //^̖݂̂̂ɈvA^ƌ肷B
		//l? (strtod()ŕϊł̂strtol()͕sv)
		d = strtod(p, &p);	//ȍ~pQƂȂ̂Ŕj󂵂đvB
		if(!*p) {
			*booleanPtr = !!d;
			return TCL_OK;
		}
	}
	//󕶎,,L̕@ŔłȂ΃G[B
	return Tcl_ErrMsg(iPtr, "expected boolean value but got \"%s\"", s);
}
/*--------------------------------------------------------------------------*/
/* CfNX擾B
 * [in]
 *	iPtr		C^v^ւ̃|C^B
 *	s		B
 *	indexPtr	CfNXli[ϐւ̃|C^B
 *			'[+-]integer'̍vli[B
 *	endPtr		'end'̗Li[ϐւ̃|C^B
 *			'end'܂ރCfNXw肾Ȃ΁A    0ȊO̒li[B
 *			'end'܂܂ȂCfNXw肾Ȃ΁A0i[B
 * [out]
 *	߂l		ʃR[hB
 * [note]
 *	- Tcl6.7̎dlł́Aê͉Ľ`łB
 *	  Einteger?[+-]integer?
 *	  E    end?[+-]integer?
 *	  ł͏LɉāA'[+-]integer'2ȏo`e邱ƂɂB
 *	  Einteger?[+-]integer[+-]integer...?
 *	  E    end?[+-]integer[+-]integer...?
 */
static int Tcl_GetIndex(Tcl_Interp* iPtr, const char* s, int* indexPtr, int* endPtr) {
	int index = 0, bEnd = 0;
	//󔒂ǂݔ΂B
	while(isspace(*s)) { s++; }
	//󕶎Ȃ΃G[B
	if(!*s) { goto badIndex; }
	//'end'ŊJnĂc
	if(str_has_prefix(s, "end")) {
		bEnd = 1;
		s += 3;
	}
	for(;;) {
		char* t;
		//󔒂ǂݔ΂B
		while(isspace(*s)) { s++; }
		//I[ȂΔB
		if(!*s) { break; }
		//lϊB
		index += strtol(s, &t, 0);
		//ꕶϊłȂ΃G[B
		if(s == t) { goto badIndex; }
		//̐l(L)ցB
		s = t;
	}
	//CfNX̍v'end'̗Li[B
	*indexPtr = index;
	*endPtr = bEnd;
	return TCL_OK;
badIndex:
	return Tcl_ErrMsg(iPtr, "bad index");
}
/*==========================================================================*
 *	vV[W
 *==========================================================================*/
/* 'proc'Œ`TclvV[ẂATcl_InterpProc()ĎsB */
static int Tcl_InterpProc(Tcl_Interp* iPtr) {
	int retCode, argc;
	char **argv, *value;
	Tcl_Proc* procPtr;
	Tcl_Arg* argPtr;
	Tcl_CallFrame frame;
	/* R[t[쐬AǉB */
	memset(&frame, 0, sizeof frame);
	frame.varTablePtr = Tcl_CreateTable();
	if(iPtr->varFramePtr) { frame.level = iPtr->varFramePtr->level; }
	frame.level++;
	frame.callerPtr    = iPtr->framePtr;
	frame.callerVarPtr = iPtr->varFramePtr;
	iPtr->framePtr     = &frame;
	iPtr->varFramePtr  = &frame;
	//Match the actual arguments against the procedure's formal parameters to compute local variables.
	argc    = iPtr->argc - 1;	//̎c萔
	argv    = iPtr->argv + 1;
	procPtr = iPtr->data;
	for(argPtr = procPtr->argPtr; argPtr; argPtr = argPtr->nextArgPtr) {	//SẲɂāc
		/* Ō̉ŁAOargsȂ΁c */
		if(!argPtr->nextArgPtr && !strcmp(argPtr->name, "args")) {
			value = Tcl_Merge(argv);		//̎cXgɂB
			Tcl_SetVar(iPtr, argPtr->name, value);	//̎cXgɂʂA[Jϐ"args"ɐݒ肷B
			argc = 0;				//̎cSďB
		} else {
			/* ̎c肪L΁c */
			if(argc) {
				         argc--;
				value = *argv++;
			/* ̎c肪AftHglL΁c */
			} else if(argPtr->defValue) {
				value = argPtr->defValue;
			} else {
				retCode = Tcl_ErrMsg(iPtr, "no value given for parameter \"%s\" to \"%s\"", argPtr->name, iPtr->argv[0]);	//s
				goto L_RET;	//R[t[߂KvL̂ŁAreturnĂ͂ȂB
			}
			Tcl_SetVar(iPtr, argPtr->name, value);	//,,ftHglA[Jϐɐݒ肷B
		}
	}
	if(argc) {	//΁c
		retCode = Tcl_ErrMsg(iPtr, "called \"%s\" with too many arguments", iPtr->argv[0]);	//s
		goto L_RET;	//R[t[߂KvL̂ŁAreturnĂ͂ȂB
	}
	/* R}hsB */
	retCode = Tcl_EvalString(iPtr, procPtr->command);
	/* ʃR[hɂāc */
	switch(retCode) {
	case TCL_RETURN:
		/* 'proc'Œ`TclvV[WAreturnŏIꍇAIƂB */
		retCode = TCL_OK;
		break;
	case TCL_BREAK:
		/* 'proc'Œ`TclvV[WAbreakŏIꍇAG[ƂB */
		retCode = Tcl_ErrMsg(iPtr, "invoked \"break\" outside of a loop");
		break;
	case TCL_CONTINUE:
		/* 'proc'Œ`TclvV[WAcontinueŏIꍇAG[ƂB */
		retCode = Tcl_ErrMsg(iPtr, "invoked \"continue\" outside of a loop");
		break;
	}
L_RET:
	/* R[t[폜B */
	iPtr->framePtr    = frame.callerPtr;
	iPtr->varFramePtr = frame.callerVarPtr;
	return retCode;
}
/*--------------------------------------------------------------------------*/
//proc name args body
static int Tcl_ProcCmd(Tcl_Interp* iPtr) {
	int i, argCount, fieldCount;
	char **argArray, **fieldValues;
	Tcl_Arg *argPtr, **lastArgPtr;
	Tcl_Proc* procPtr;
	/* vV[W쐬B */
	procPtr = calloc(sizeof(Tcl_Proc), 1);
	procPtr->command = strdup(iPtr->argv[3]);
	lastArgPtr = &procPtr->argPtr;
	/* Xg𕪊B */
	argCount = Tcl_SplitList(iPtr->argv[2], &argArray);
	for(i = 0; i < argCount; i++) {
		/* ̉AƃftHgl(L)ɕB */
		fieldCount = Tcl_SplitList(argArray[i], &fieldValues);
		if(!fieldCount || !*fieldValues[0]) {
			return Tcl_ErrMsg(iPtr, "procedure \"%s\" has argument with no name", iPtr->argv[1]);
		}
		if(fieldCount > 2) {
			return Tcl_ErrMsg(iPtr, "too many fields in argument specifier \"%s\"", argArray[i]);
		}
		/* 쐬B */
		argPtr = calloc(sizeof(Tcl_Arg), 1);
		argPtr->name = strdup(fieldValues[0]);
		if(fieldCount == 2) { argPtr->defValue = strdup(fieldValues[1]); }
		/* ǉB */
		*lastArgPtr = argPtr;
		lastArgPtr = &argPtr->nextArgPtr;
	}
	/* R}ho^B */
	Tcl_CreateCommand(iPtr, iPtr->argv[1], Tcl_InterpProc, procPtr);
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//rename oldName newName
static int Tcl_RenameCmd(Tcl_Interp* iPtr) {
	Tcl_Command* cmdPtr;
	Tcl_TableEntry *tPtr1, *tPtr2;
	if(!*iPtr->argv[2]) {	//newName󕶎ȂoldNamẽR}h폜B
		if(Tcl_DeleteCommand(iPtr, iPtr->argv[1])) { return TCL_ERROR; }
		return TCL_OK;
	}
	tPtr1 = Tcl_FindTableEntry(iPtr->commandTablePtr, iPtr->argv[1]);
	tPtr2 = Tcl_FindTableEntry(iPtr->commandTablePtr, iPtr->argv[2]);
	if(!tPtr1 || tPtr2) {	//oldNamẽR}h݂ȂAnewNamẽR}h݂G[B
		return Tcl_ErrMsg(iPtr, "can't rename");
	}
	//oldNamẽGg폜AnewNamẽGg쐬AoldNamẽR}hnewNameɕtւB
	cmdPtr = tPtr1->value;
	Tcl_DeleteTableEntry(tPtr1);
	tPtr2 = Tcl_CreateTableEntry(iPtr->commandTablePtr, iPtr->argv[2], NULL);
	tPtr2->value = cmdPtr;
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
/* ㋉vV[W̃R[t[擾B'uplevel''upvar'R}h̎ɗpB
 * [in]
 *	iPtr		C^v^ւ̃|C^B
 *	argv		(iPtr->argv+1)w肹B́A'uplevel''upvar'R}h́u?level?v(L)̈ʒuɑB
 *	pFramePtr	R[t[i[ϐւ̃|C^BgbvxIꂽꍇ́ANULLi[B
 * [out]
 *	߂l		u?level?v(L)Aargvi߂|C^B̓Iɂ́A
 *			u?level?vL΁Aw肳ꂽargv̎̈ʒuԂB
 *			u?level?v΁Aw肳ꂽargv̂܂ܕԂB
 */
static char** Tcl_GetFrame(Tcl_Interp* iPtr, char** argv, Tcl_CallFrame** pFramePtr) {
	Tcl_CallFrame* framePtr = iPtr->varFramePtr;
	const char* s = *argv;
	int level;
	/* ɃgbvxȂ΁AG[ƂB */	//v:gbvxłuuplevel #0vuuplevel 0v͋ׂH
	if(!framePtr) {
		Tcl_ErrMsg(iPtr, "already at top level");
		return NULL;
	}
	//Parse string to figure out which level number to go to.
	if(*s == '#') {			//ΓIxԍ
		if(Tcl_GetInt(iPtr, s+1, &level)) { goto badLevel; }
		argv++;	//xwɈvf1gp
	} else if(isdigit(*s)) {	//xAbvXebv
		if(Tcl_GetInt(iPtr, s  , &level)) { goto badLevel; }
		level = framePtr->level - level;
		argv++;	//xwɈvf1gp
	} else {			//levelȗꂽꍇ̊l1
		level = framePtr->level - 1;
	}
	//Figure out which frame to use, and modify the interpreter so its variables come from that frame.
	if(level) {
		while(framePtr->level != level) {
			if(!(framePtr = framePtr->callerVarPtr)) { goto badLevel; }	//(gbvx`݂̃x)͈̔͊Õxw肳ꂽB
		}
	} else {
		framePtr = NULL;
	}
	*pFramePtr = framePtr;	//R[t[i[B
	return argv;		//xwɗp̎̈ւ̃|C^ԂB
badLevel:
	Tcl_ErrMsg(iPtr, "bad level");
	return NULL;
}
/*--------------------------------------------------------------------------*/
//uplevel ?level? arg ?arg ...?
static int Tcl_UplevelCmd(Tcl_Interp* iPtr) {
	int retCode;
	char** argv;
	Tcl_CallFrame *framePtr, *savedVarFramePtr;
	//Find the level to use for executing the command.
	argv = Tcl_GetFrame(iPtr, iPtr->argv + 1, &framePtr);
	if(!argv) { return TCL_ERROR; }				//xw肪sB
	if(!*argv) { return Tcl_WrongNumOfArgs(iPtr); }		//R}hB
	//Modify the interpreter state to execute in the given frame.
	 savedVarFramePtr = iPtr->varFramePtr;
	iPtr->varFramePtr = framePtr;
	//Execute the residual arguments as a command.
	retCode = Tcl_EvalString(iPtr, Tcl_Concat(argv));	//R}hȍ~AĎsB
	//Restore the variable frame, and return.
	iPtr->varFramePtr = savedVarFramePtr;
	return retCode;
}
/*--------------------------------------------------------------------------*/
//upvar ?level? otherVar myVar ?otherVar myVar ...?
static int Tcl_UpvarCmd(Tcl_Interp* iPtr) {
	char** argv;
	Tcl_CallFrame* framePtr;
	Tcl_Table *tablePtr, *upVarTablePtr;
	//Find the table containing the variable being referenced.
	argv = Tcl_GetFrame(iPtr, iPtr->argv + 1, &framePtr);
	if(!argv) { return TCL_ERROR; }				//xw肪sB
	if(!*argv) { return Tcl_WrongNumOfArgs(iPtr); }		//㋉vV[WϐƁÃ݂vV[W̕ϐAȂƂ1g݈ȏKvB
	/* R[t[,,O[o̕ϐe[u擾B */
	tablePtr = iPtr->varFramePtr ? iPtr->varFramePtr->varTablePtr : iPtr->globalTablePtr;
	/* ㋉vV[W̕ϐe[u擾B */
	upVarTablePtr = framePtr ? framePtr->varTablePtr : iPtr->globalTablePtr;
	//Iterate over all the pairs of (local variable, other variable) names.
	//For each pair, create a table entry in the upper context (if the name wasn't there already), then associate it with a new local variable.
	for(;;) {
		int bNew;
		char *varName, *upVarName;
		Tcl_TableEntry *tPtr1, *tPtr2;
		Tcl_Var *varPtr, *upVarPtr;
		/* ㋉vV[WϐƁA[Jϐ擾B */
		if(!(upVarName = *argv++)) { break; }
		if(!(  varName = *argv++)) { return Tcl_WrongNumOfArgs(iPtr); }	//otherVarmyVarg݂ɂȂĂȂB
		/* ㋉vV[Wϐ̃Gg쐬,,擾B */
		tPtr1 = Tcl_CreateTableEntry(upVarTablePtr, upVarName, &bNew);	//TODO:ł͎QƐ悪zvf̏ꍇɑΉłĂȂB
		/* VK̏㋉vV[WϐȂ΁c */
		if(bNew) {
			/* ϐ쐬B */
			upVarPtr = calloc(sizeof(Tcl_Var), 1);
			tPtr1->value = upVarPtr;
		/* ̏㋉vV[WϐȂ΁c */
		} else {
			/* ϐ擾B */
			upVarPtr = tPtr1->value;
			//QƐ̕ϐupvarȂ΁A̎QƐ̕ϐ擾B dv
			// - ̎QƐ̕ϐupvarł邱Ƃ͖Bupvarϐ̎QƐ́AKupvarȊOłB
			//   XNvgupvar𑽏dɃ`FCĂA̓sxupvarȊOw悤ɉĂ͂B(ōsĂ̂̏łB)
			//   QƐ̕ϐupvarȂ΁AC^v^̃oOłB
			//;vV[Wlev_4ɂāAuOkvƕ\B
			//proc lev_4 {x} { upvar $x y; puts $y }
			//proc lev_3 {x} { upvar $x y; lev_4 y }
			//proc lev_2 {x} { upvar $x y; lev_3 y }
			//proc lev_1 {x} { upvar $x y; lev_2 y }
			//set a Ok
			//lev_1 a
			if(upVarPtr->type == TCL_VAR_UPVAR) {	//
				tPtr1 = upVarPtr->value.upvar;	//dv
				upVarPtr = tPtr1->value;	//
			}
		}
		/* [Jϐ̃Gg쐬,,擾B */
		tPtr2 = Tcl_CreateTableEntry(tablePtr, varName, &bNew);
		/* VK̃[JϐȂ΁c */
		if(bNew) {
			/* ϐ쐬B */
			varPtr = calloc(sizeof(Tcl_Var), 1);
			tPtr2->value = varPtr;
			varPtr->type = TCL_VAR_UPVAR;
		/* ̃[JϐȂ΁c */
		} else {
			/* ϐ擾B */
			varPtr = tPtr2->value;
			/* [Jϐ̏ꍇAsetupvar̓G[łB
			 * globalupvarAupvarupvar̓G[ł͂ȂB */
			if(varPtr->type != TCL_VAR_UPVAR) {
				return Tcl_ErrMsg(iPtr, "variable \"%s\" already exists", varName);
			}
		}
		/* [JϐA㋉vV[Wϐ̃Ggւ́Aupvarݒ,,ύXB */
		varPtr->value.upvar = tPtr1;
	}
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//global varname ?varname ...?
static int Tcl_GlobalCmd(Tcl_Interp* iPtr) {
	char **argv = iPtr->argv + 1, *varName;
	//uTcl 8.4.1 Manual Command Referencevp:
	//̃R}hTclvV[W̎słȂΖ܂B
	//O[oϐe[uɃO[oϐւupvarGgƏzQƂɂȂĂ܂̂ŁAL̒ʂ薳̂B
	if(!iPtr->varFramePtr) { return TCL_OK; }
	/* ϐ擾B */
	while((varName = *argv++)) {
		int bNew;
		Tcl_TableEntry *tPtr1, *tPtr2;
		Tcl_Var *varPtr, *gVarPtr;
		//O[oϐ̃Gg쐬,,擾B */
		tPtr1 = Tcl_CreateTableEntry(iPtr->globalTablePtr, varName, &bNew);
		/* VK̃O[oϐȂ΁c */
		if(bNew) {
			/* ϐ쐬B */
			gVarPtr = calloc(sizeof(Tcl_Var), 1);
			tPtr1->value = gVarPtr;
		/* ̃O[oϐȂ΁c */
		} else {
			/* ϐ擾B */
			gVarPtr = tPtr1->value;
		}
		/* [Jϐ̃Gg쐬,,擾B */
		tPtr2 = Tcl_CreateTableEntry(iPtr->varFramePtr->varTablePtr, varName, &bNew);
		/* VK̃[JϐȂ΁c */
		if(bNew) {
			/* ϐ쐬B */
			varPtr = calloc(sizeof(Tcl_Var), 1);
			tPtr2->value = varPtr;
			varPtr->type = TCL_VAR_UPVAR;
		/* ̃[JϐȂ΁c */
		} else {
			/* ϐ擾B */
			varPtr = tPtr2->value;
			/* [Jϐ̏ꍇAsetglobal̓G[łB
			 * globalglobalAupvarglobal̓G[ł͂ȂB */
			if(varPtr->type != TCL_VAR_UPVAR) {
				return Tcl_ErrMsg(iPtr, "variable \"%s\" already exists", varName);
			}
		}
		/* [JϐA㋉vV[Wϐ̃Ggւ́Aupvarݒ,,ύXB */
		varPtr->value.upvar = tPtr1;
	}
	return TCL_OK;
}
/*==========================================================================*
 *	z񏈗
 *==========================================================================*/
//array size arrayName
//array names arrayName
static int Tcl_ArrayNames(Tcl_Interp* iPtr) {
	Tcl_Var* varPtr = iPtr->data;
	LIST_ENTRY *list_head, *list_entry;
	Tcl_TableEntry* tPtr;
	/* zvf̗vf̃Xg쐬B */
	list_head = &varPtr->value.array->list_head;
	list_entry = list_head->Flink;
	while(list_entry != list_head) {
		tPtr = CONTAINING_RECORD(list_entry, Tcl_TableEntry, list_entry);
		varPtr = tPtr->value;
		Tcl_AppendResultElement(iPtr, tPtr->key);
		list_entry = list_entry->Flink;
	}
	/* 'size'Ȃ΁AvfɕϊB */
	if(*iPtr->argv[1] == 's') {	//sizȅꍇ
		iPtr->result = strdup_printf("%d", Tcl_SplitList(iPtr->result, NULL));
	}
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//array startsearch arrayName
static int Tcl_ArrayStartsearch(Tcl_Interp* iPtr) {
	Tcl_Var* varPtr = iPtr->data;
	Tcl_ArraySearch* arraySearchPtr;
	Tcl_TableEntry* tPtr;
	/* z񑖍쐬B */
	arraySearchPtr = calloc(sizeof(Tcl_ArraySearch), 1);
	arraySearchPtr->list_entry = &varPtr->value.array->list_head;	//'݂̑ʒu'́Aŏ̃Gg̎OwB
	/* z񑖍o^B */
	tPtr = Tcl_CreateTableEntry(
		iPtr->arraySearchTablePtr,
		strdup_printf("%p", arraySearchPtr),	//AhXlL[Ƃ邱ƂɂBӂsearchId쐬ړIłAhXlƂĉ߂邱Ƃ͖B
		NULL);
	tPtr->value = arraySearchPtr;
	/* ʎqԂB */
	iPtr->result = tPtr->key;
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//array nextelement arrayName searchId
static int Tcl_ArrayNextelement(Tcl_Interp* iPtr) {
	Tcl_Var* varPtr = iPtr->data;
	Tcl_TableEntry* tPtr;
	Tcl_ArraySearch* arraySearchPtr;
	LIST_ENTRY* list_entry;
	/* z񑖍擾B */
	tPtr = Tcl_FindTableEntry(iPtr->arraySearchTablePtr, iPtr->argv[3]);
	if(!tPtr) { return TCL_ERROR; }
	arraySearchPtr = tPtr->value;
	/* ̃Gg擾B */
	list_entry = arraySearchPtr->list_entry->Flink;		//̃Gg擾B
	if(list_entry != &varPtr->value.array->list_head) {	//̃GgL΁c
		arraySearchPtr->list_entry = list_entry;	//݂̑ʒuXVB
		tPtr = CONTAINING_RECORD(list_entry, Tcl_TableEntry, list_entry);
		iPtr->result = tPtr->key;
	}
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//array donesearch arrayName searchId
static int Tcl_ArrayDonesearch(Tcl_Interp* iPtr) {
	Tcl_TableEntry* tPtr;
	/* z񑖍擾B */
	tPtr = Tcl_FindTableEntry(iPtr->arraySearchTablePtr, iPtr->argv[3]);
	if(!tPtr) { return TCL_ERROR; }
	/* z񑖍o^B */
	Tcl_DeleteTableEntry(tPtr);
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//array anymore arrayName searchId
static int Tcl_ArrayAnymore(Tcl_Interp* iPtr) {
	Tcl_Var* varPtr = iPtr->data;
	Tcl_TableEntry* tPtr;
	Tcl_ArraySearch* arraySearchPtr;
	/* z񑖍擾B */
	tPtr = Tcl_FindTableEntry(iPtr->arraySearchTablePtr, iPtr->argv[3]);
	if(!tPtr) { return TCL_ERROR; }
	arraySearchPtr = tPtr->value;
	/* ̃GgL1A0ԂB */
	iPtr->result = strdup_printf("%d", (arraySearchPtr->list_entry->Flink != &varPtr->value.array->list_head));
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//array option arrayName ?arg ...?
static int Tcl_ArrayCmd(Tcl_Interp* iPtr) {
	static const Tcl_BuiltInCmd TBL_SubCmd[]={
		{"size",		Tcl_ArrayNames,			3,3},	//array size arrayName	//TuR}h֐ʉB
		{"names",		Tcl_ArrayNames,			3,3},	//array names arrayName	//
		{"startsearch",		Tcl_ArrayStartsearch,		3,3},	//array startsearch arrayName
		{"nextelement",		Tcl_ArrayNextelement,		4,4},	//array nextelement arrayName searchId
		{"donesearch",		Tcl_ArrayDonesearch,		4,4},	//array donesearch arrayName searchId
		{"anymore",		Tcl_ArrayAnymore,		4,4},	//array anymore arrayName searchId
	{0}};//I[
	//
	Tcl_Table* tablePtr;
	Tcl_TableEntry* tPtr;
	Tcl_Var* varPtr;
	Tcl_CmdProc* cmdProc;
	/* ϐe[u擾B */
	tablePtr = iPtr->varFramePtr ? iPtr->varFramePtr->varTablePtr : iPtr->globalTablePtr;
	/* Gg擾B */
	tPtr = Tcl_FindTableEntry(tablePtr, iPtr->argv[2]);
	if(!tPtr) { goto notArray; }
	varPtr = tPtr->value;
	/* ㋉vV[WϐȂ΁c */
	if(varPtr->type == TCL_VAR_UPVAR) {
		tPtr = varPtr->value.upvar;
		varPtr = tPtr->value;
	}
	/* `ς݂̔zł邱ƂmFB */
	if(varPtr->type != TCL_VAR_ARRAY) { goto notArray; }
	/* Cӂ̃f[^ɁAϐi[B(TuR}h֐ŋʂɎgp邽߁B) */
	iPtr->data = varPtr;
	/* TuR}h֐ĂяoB */
	cmdProc = Tcl_GetBuiltInCmd(iPtr, TBL_SubCmd, 1);
	return (*cmdProc)(iPtr);
notArray:
	return Tcl_ErrMsg(iPtr, "\"%s\" isn't an array", iPtr->argv[2]);
}
/*==========================================================================*
 *	Xg
 *==========================================================================*/
//list ?arg ...?
static int Tcl_ListCmd(Tcl_Interp* iPtr) {
	iPtr->result = Tcl_Merge(iPtr->argv + 1);
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//llength list
static int Tcl_LlengthCmd(Tcl_Interp* iPtr) {
	/* Xgɕėvf߁Aʂ̕Ɋi[B */
	iPtr->result = strdup_printf("%d", Tcl_SplitList(iPtr->argv[1], NULL));
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//lindex list index
static int Tcl_LindexCmd(Tcl_Interp* iPtr) {
	int retCode, argc, index, bEnd;
	char** argv;
	/* XgɕB */
	argc = Tcl_SplitList(iPtr->argv[1], &argv);
	/* CfNX擾B */
	retCode = Tcl_GetIndex(iPtr, iPtr->argv[2], &index, &bEnd);
	if(retCode) { return retCode; }
	if(bEnd) { index += (argc - 1); }	//lindexend̓Xg̍Ō̗vfQƂB
	/* XǵACfNXŎw肳ꂽvfAʂ̕Ɋi[B */
	if((unsigned)index < (unsigned)argc) {	//index,,list̗vfȏłꍇA󕶎ԂB
		iPtr->result = argv[index];
	}
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//linsert list index element ?element ...?
static int Tcl_LinsertCmd(Tcl_Interp* iPtr) {
	int retCode, argc, index, bEnd, i, j;
	char** argv;
	/* XgɕB */
	argc = Tcl_SplitList(iPtr->argv[1], &argv);
	/* CfNX擾B */
	retCode = Tcl_GetIndex(iPtr, iPtr->argv[2], &index, &bEnd);
	if(retCode) { return retCode; }
	if(bEnd) { index += argc; }	//lindexend̓Xg̗vfQƂB
	/* XǵACfNXŎw肳ꂽʒuɁAŎw肳ꂽvf}Aʂ̕Ɋi[B */
	for(i = 0; i <       argc; i++) { if(index <= i) { break; } Tcl_AppendResultElement(iPtr,       argv[i]); }
	for(j = 3; j < iPtr->argc; j++) {                           Tcl_AppendResultElement(iPtr, iPtr->argv[j]); }
	for(     ; i <       argc; i++) {                           Tcl_AppendResultElement(iPtr,       argv[i]); }
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//lrange list first last
static int Tcl_LrangeCmd(Tcl_Interp* iPtr) {
	int retCode, argc, first, last, bEnd, i;
	char** argv;
	/* XgɕB */
	argc = Tcl_SplitList(iPtr->argv[1], &argv);
	/* CfNX擾B */
	retCode = Tcl_GetIndex(iPtr, iPtr->argv[2], &first, &bEnd);
	if(retCode) { return retCode; }
	if(bEnd) { first += (argc - 1); }	//lindexend̓Xg̍Ō̗vfQƂB
	retCode = Tcl_GetIndex(iPtr, iPtr->argv[3], &last, &bEnd);
	if(retCode) { return retCode; }
	if(bEnd) { last += (argc - 1); }	//lindexend̓Xg̍Ō̗vfQƂB
	/* XǵACfNXŎw肳ꂽ͈̗͂vfXgAAʂ̕Ɋi[B */
	for(i = 0; i < argc; i++) {
		if((i >= first) && (i <= last)) { Tcl_AppendResultElement(iPtr, argv[i]); }
	}
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//lreplace list first last ?element ...?
static int Tcl_LreplaceCmd(Tcl_Interp* iPtr) {
	int retCode, argc, first, last, bEnd, i, j;
	char** argv;
	/* XgɕB */
	argc = Tcl_SplitList(iPtr->argv[1], &argv);
	/* CfNX擾B */
	retCode = Tcl_GetIndex(iPtr, iPtr->argv[2], &first, &bEnd);
	if(retCode) { return retCode; }
	if(bEnd) { first += (argc - 1); }	//lindexend̓Xg̍Ō̗vfQƂB
	retCode = Tcl_GetIndex(iPtr, iPtr->argv[3], &last, &bEnd);
	if(retCode) { return retCode; }
	if(bEnd) { last += (argc - 1); }	//lindexend̓Xg̍Ō̗vfQƂB
//{{2014/11/05ǉ:Tcl_LreplaceCmd()֐ɓᏈǉ܂BTcllreplaceR}h̎dlɏ]߂łB
//uTcl8.4.1}jA rgCR}ht@X - lreplacev(http://www.freesoftnet.co.jp/tclkits/doc/TclCmdRef/TclCmd/lreplace_jp.htm)p:
//lreplacelist1ȏ̗vfelementŒu邱ƂɂČ`VXgԂ܂B
//firstlastlist̒uׂŏƍŌ̗vf̃CfbNX^܂B
//0͍ŏ̗vfQƂAend(邢͂̏ȗ`)͍Ō̗vfQƂ܂B
//list͋łꍇAfirstlast͖܂B				ځ
//first0̏ꍇAlist̍ŏ̗vfQƂ܂B
//̃Xgɑ΂firstŎvf̓Xgɑ݂ĂȂ΂Ȃ܂B
//last0firstȏłꍇASė^ꂽvf̓Xg֒ǉ܂B
//lastfirst菬ƁAvf͍폜܂B
//Vvffirst̑OɒPɑ}܂B
//element̓X̍폜ꂽʒuɒǉ0ȏ̐Vw肵܂B
//eelement̓Xg̕ʁX̗vfɂȂ܂B
//elementw肳ȂꍇAfirstlast̊Ԃ̗vfPɍ폜܂B
//listȂ΁Aelement̓Xg̍Ōɒǉ܂B
//utclkitsh-8.5.9-win32.upx.exevɂēmF:
//EXgłȂꍇACfNX͈͊OȂ΁AG[ƂȂB
//@́lreplace {a} 9 9 x
//@ʁlist doesn't contain element 9
//EXgłꍇACfNX͖A̗vfʂƂȂB
//@́lreplace {} 9 9 x
//@ʁx
//ECfNXꍇłA\ԈĂ΁AG[ƂȂB
//@́lreplace {} a b x
//@ʁbad index "a": must be integer?[+-]integer? or end?[+-]integer?
	/* ̓Ꮘ͕sRłAsȂɉ̂ATcl̎dlȂ̂ŎdB */
	if(!argc) {
		iPtr->result = Tcl_Merge(iPtr->argv + 4);
		return TCL_OK;
	}
//}}2014/11/05ǉ:Tcl_LreplaceCmd()֐ɓᏈǉ܂BTcllreplaceR}h̎dlɏ]߂łB
	/* XǵACfNXŎw肳ꂽ͈̗͂vfAŎw肳ꂽvfɒuăXgAAʂ̕Ɋi[B */
	if(first <     0) { first = 0; }				//first0̏ꍇAlist̍ŏ̗vfQƂ܂B
	if(first >= argc) { return Tcl_ErrMsg(iPtr, "bad index"); }	//̃Xgɑ΂firstŎvf̓Xgɑ݂ĂȂ΂Ȃ܂B
	for(i = 0; i < argc; i++) {
		if(i == first) { for(j = 4; j < iPtr->argc; j++) { Tcl_AppendResultElement(iPtr, iPtr->argv[j]); } }	//̏Ԃ͕K{Btɂƌ̗vf폜Ȃ̋dlƈĂ܂B
		if((i < first) || (i > last)) {                    Tcl_AppendResultElement(iPtr,       argv[i]); }	//<>ulreplace {A B C} 1 0 xv{A x B C}ƂȂ̂B{A B x C}͌B
	}
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//lsearch list pattern
static int Tcl_LsearchCmd(Tcl_Interp* iPtr) {
	int argc, index = -1, i;
	char** argv;
	/* XgɕB */
	argc = Tcl_SplitList(iPtr->argv[1], &argv);
	/* XǵAp^[ɈvvfB */
	for(i = 0; i < argc; i++) {
		if(string_match(iPtr->argv[2], argv[i])) {
			index = i;
			break;
		}
	}
	/* p^[Ɉvvf̃CfNXAʂ̕Ɋi[B */
	iPtr->result = strdup_printf("%d", index);
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
static int Tcl_LsortCmd_increasing(const void* x, const void* y) {
	return strcmp(*(char**)x, *(char**)y);
}
static int Tcl_LsortCmd_decreasing(const void* x, const void* y) {
	return strcmp(*(char**)y, *(char**)x);
}
//lsort ?options? list
static int Tcl_LsortCmd(Tcl_Interp* iPtr) {
	int (*fn)(const void*, const void*) = Tcl_LsortCmd_increasing;
	int argc;
	char** argv;
	for(argv = iPtr->argv + 1;	//R}h̎̈A
	    *argv && (**argv == '-');	//܂LAIvVwȂ΁c
	    argv++) {			//ȉāÄ֐i߂B
		if(!strcmp(*argv, "-increasing")) { fn = Tcl_LsortCmd_increasing; continue; }
		if(!strcmp(*argv, "-decreasing")) { fn = Tcl_LsortCmd_decreasing; continue; }
		return Tcl_ErrMsg(iPtr, "bad option");
	}
	if(!*argv || *(argv+1)) { return Tcl_WrongNumOfArgs(iPtr); }	//'list'A'list'̌ɗ]ȈL΁AG[ƂB
	/* XgɕB */
	argc = Tcl_SplitList(*argv, &argv);
	/* Xg̗vf\[gB */
	qsort(argv, argc, sizeof(char*), fn);
	/* \[gʂXgAAʂ̕Ɋi[B */
	iPtr->result = Tcl_Merge(argv);
	return TCL_OK;
}
/*==========================================================================*
 *	t@C
 *==========================================================================*/
static const char* Tcl_GlobCmd_pattern;	//Tcl_GlobCmd()Tcl_GlobCmd_filter()
static int Tcl_GlobCmd_filter(const struct dirent* e) {
	// - ɂ́Astring matchɂ͖AglobL̃p^[ƂāAu{a,b,...}vKvłB
	//   u{a,b,...}v̎gppx͒Ⴂ̂ŁAł͑ΉAstring matcĥ܂܎gƂɂB
	// - ɂ́Auglob *v́u.vu..vɃ}b`ȂAł̓}b`B
	//   ̈ႢɂȂ邱Ƃ͏ȂƎv̂ŁÂ܂܂ɂ邱ƂɂB
	return string_match(Tcl_GlobCmd_pattern, e->d_name);
}
//glob ?switches? pattern ?pattern ...?
static int Tcl_GlobCmd(Tcl_Interp* iPtr) {
	int noComplain = 0;
	char** argv = iPtr->argv + 1;	//R}h̎̈
	/* ŏ̈A'-nocomplain'Ȃ΁c */
	if(!strcmp(*argv, "-nocomplain")) {
		noComplain = 1;
		argv++;	//̈
	}
	/* cĂԁAJԂB */
	while((Tcl_GlobCmd_pattern = *argv++)) {
		int n;
		struct dirent** e;
		n = scandir(".", &e, Tcl_GlobCmd_filter, NULL);
		while(n--) { Tcl_AppendResultElement(iPtr, (*e++)->d_name); }	//̃t@C̃p^[Ƀ}b`ꍇAʂ̃Xgɕ񌻂sR邪Aō\ȂB{tclshłȂB
	}
	/* '-nocomplain'w肳Ă炸A}b`Ȃ΁c */
	if(!noComplain && !*iPtr->result) {
		return Tcl_ErrMsg(iPtr, "no files matched glob pattern");
	}
	return TCL_OK;
}
/*==========================================================================*
 *	l
 *==========================================================================*/
//incr varName ?increment?
static int Tcl_IncrCmd(Tcl_Interp* iPtr) {
	int retCode, x = 0, y = 1;
	const char* s;
	/* ϐ̒l擾Bϐ΁A0ƂB */
	s = Tcl_GetVar(iPtr, iPtr->argv[1]);
	if(s) {
		retCode = Tcl_GetInt(iPtr, s, &x);
		if(retCode) { return retCode; }
	}
	/* 擾Bw肳ĂȂ΁A1ƂB */
	if(iPtr->argc == 3) {
		retCode = Tcl_GetInt(iPtr, iPtr->argv[2], &y);
		if(retCode) { return retCode; }
	}
	/* ʂ̕ɁAvli[B */
	s = Tcl_SetVar(iPtr, iPtr->argv[1], strdup_printf("%d", x + y));
	if(!s) { return TCL_ERROR; }
	iPtr->result = s;
	return TCL_OK;
}
/*==========================================================================*
 *	񏈗
 *==========================================================================*/
//concat ?arg ...?
static int Tcl_ConcatCmd(Tcl_Interp* iPtr) {
	iPtr->result = Tcl_Concat(iPtr->argv + 1);
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//join list ?joinString?
static int Tcl_JoinCmd(Tcl_Interp* iPtr) {
	char** argv;
	/* XgɕB */
	Tcl_SplitList(iPtr->argv[1], &argv);
	/* XgAw肳ꂽAŘAāAʂ̕Ɋi[B
	 * A񂪎w肳ĂȂꍇ́A󔒈ꕶƂB */
	iPtr->result = strjoinv((iPtr->argc == 3) ? iPtr->argv[2] : " ", argv);
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//split string ?splitChars?
static int Tcl_SplitCmd(Tcl_Interp* iPtr) {
	const char* splitChars = "\t\n\v\f\r ";
	/* Zbg擾B
	 * Zbgw肳ĂȂꍇ́Aisspace()ƂB */
	if(iPtr->argc == 3) { splitChars = iPtr->argv[2]; }
	/* Zbg󕶎łȂ΁c */
	if(*splitChars) {
		/* 𕪊ZbgŕAXgɂāAʂ̕Ɋi[B */
		char** argv = strsplit_set(iPtr->argv[1], splitChars, 0);
		iPtr->result = Tcl_Merge(argv);
	/* Zbg󕶎Ȃ΁c */
	} else {
		/* ꕶÂɕAXgɂāAʂ̕Ɋi[B */
		const char* s = iPtr->argv[1];
		while(*s) {
			char buf[2] = { *s++ };
			Tcl_AppendResultElement(iPtr, buf);
		}
	}
	return TCL_OK;
}
/*==========================================================================*
 *	]
 *==========================================================================*/
//expr arg ?arg ...?
static int Tcl_ExprCmd(Tcl_Interp* iPtr) {
	return Tcl_ExprString(iPtr, Tcl_Concat(iPtr->argv + 1));	//R}hȍ~Aĕ]B
}
/*--------------------------------------------------------------------------*/
/* sƂĕ]Aʂ𕶎ƂāAʂ̕Ɋi[B
 * [in]
 *	iPtr		C^v^ւ̃|C^B
 *	s		B
 * [out]
 *	߂l		ʃR[hB
 */
static int Tcl_ExprString(Tcl_Interp* iPtr, const char* s) {
	Tcl_Value value;
	int retCode = Tcl_ExprTopLevel(iPtr, s, &value);			//]B
	if(retCode) { return retCode; }
	Tcl_ExprMakeString(&value);
	iPtr->result = value.value.stringValue;
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//݂̏ǂgpĂȂ̂ŖBKvɂȂLɂB
#if 0
/* sƂĕ]Aʂ𐮐ƂāAw肳ꂽϐɊi[B
 * [in]
 *	iPtr		C^v^ւ̃|C^B
 *	s		B
 *	intPtr		ʂ̐i[ϐւ̃|C^B
 * [out]
 *	߂l		ʃR[hB
 * [note]
 *	- Tcl_ExprString()ƈႢAʂ̕ɂ͊i[ȂƂɒӂB
 */
static int Tcl_ExprInt(Tcl_Interp* iPtr, const char* s, int* intPtr) {
	Tcl_Value value;
	int retCode = Tcl_ExprTopLevel(iPtr, s, &value);			//]B
	if(retCode) { return retCode; }
	switch(value.type) {							//ʂ̌^ɂāc
	case TCL_TYPE_STRING:							//^Ȃ΁AG[ƂB	//ɁAlƂăp[Xł镶񂾂Ȃ΁A]ʂ^,,^ɂȂĂ͂Ȃ̂ŁAōēxAlƂăp[Xł镶񂩂ǂKv͖B
		return Tcl_ErrMsg(iPtr, "expression didn't have numeric value");
	case TCL_TYPE_INT:							//^Ȃ΁Aw肳ꂽϐɊi[B
		*intPtr = value.value.intValue;
		break;
	case TCL_TYPE_DOUBLE:							//^Ȃ΁Aw肳ꂽϐɊi[B
		*intPtr = value.value.doubleValue;
		break;
	default:								//ȊǑ^Ȃ΁AW[̃oOłB[U[XNvg̖ł͂ȂB
		DIE();
	}
	return TCL_OK;
}
#endif
/*--------------------------------------------------------------------------*/
//݂̏ǂgpĂȂ̂ŖBKvɂȂLɂB
#if 0
/* sƂĕ]AʂƂāAw肳ꂽϐɊi[B
 * [in]
 *	iPtr		C^v^ւ̃|C^B
 *	s		B
 *	doublePtr	ʂ̎i[ϐւ̃|C^B
 * [out]
 *	߂l		ʃR[hB
 * [note]
 *	- Tcl_ExprString()ƈႢAʂ̕ɂ͊i[ȂƂɒӂB
 */
static int Tcl_ExprDouble(Tcl_Interp* iPtr, const char* s, double* doublePtr) {
	Tcl_Value value;
	int retCode = Tcl_ExprTopLevel(iPtr, s, &value);			//]B
	if(retCode) { return retCode; }
	switch(value.type) {							//ʂ̌^ɂāc
	case TCL_TYPE_STRING:							//^Ȃ΁AG[ƂB	//ɁAlƂăp[Xł镶񂾂Ȃ΁A]ʂ^,,^ɂȂĂ͂Ȃ̂ŁAōēxAlƂăp[Xł镶񂩂ǂKv͖B
		return Tcl_ErrMsg(iPtr, "expression didn't have numeric value");
	case TCL_TYPE_INT:							//^Ȃ΁A^ɕϊAw肳ꂽϐɊi[B
		*doublePtr = value.value.intValue;
		break;
	case TCL_TYPE_DOUBLE:							//^Ȃ΁Â܂܁Aw肳ꂽϐɊi[B
		*doublePtr = value.value.doubleValue;
		break;
	default:								//ȊǑ^Ȃ΁AW[̃oOłB[U[XNvg̖ł͂ȂB
		DIE();
	}
	return TCL_OK;
}
#endif
/*--------------------------------------------------------------------------*/
/* sƂĕ]Aʂ^UlƂāAw肳ꂽϐɊi[B
 * [in]
 *	iPtr		C^v^ւ̃|C^B
 *	s		B
 *	booleanPtr	ʂ̐^Uli[ϐւ̃|C^B
 * [out]
 *	߂l		ʃR[hB
 * [note]
 *	- Tcl_ExprString()ƈႢAʂ̕ɂ͊i[ȂƂɒӂB
 */
static int Tcl_ExprBoolean(Tcl_Interp* iPtr, const char* s, int* booleanPtr) {
	Tcl_Value value;
	int retCode = Tcl_ExprTopLevel(iPtr, s, &value);			//]B
	if(retCode) { return retCode; }
	switch(value.type) {							//ʂ̌^ɂāc
	case TCL_TYPE_STRING:							//^Ȃ΁AG[ƂB	//A^UlƌȂ镶Ȃ΁A^UlɕϊAw肳ꂽϐɊi[B
		retCode = Tcl_GetBoolean(iPtr, value.value.stringValue, booleanPtr);
		if(retCode) { return retCode; }
		break;
	case TCL_TYPE_INT:							//^Ȃ΁A^UlɕϊAw肳ꂽϐɊi[B
		*booleanPtr = !!value.value.intValue;
		break;
	case TCL_TYPE_DOUBLE:							//^Ȃ΁A^UlɕϊAw肳ꂽϐɊi[B
		*booleanPtr = !!value.value.doubleValue;
		break;
	default:								//ȊǑ^Ȃ΁AW[̃oOłB[U[XNvg̖ł͂ȂB
		DIE();
	}
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
/* sƂĕ]Aʂ擾B
 * [in]
 *	iPtr		C^v^ւ̃|C^B
 *	s		B
 *	booleanPtr	ʂi[ϐւ̃|C^B
 * [out]
 *	߂l		ʃR[hB
 */
static int Tcl_ExprTopLevel(Tcl_Interp* iPtr, const char* s, Tcl_Value* valuePtr) {
	int retCode;
	Tcl_ExprInfo info;
	info.expr = (char*)s;							//ExprBtokentB[h͏svłB
	retCode = Tcl_ExprGetValue(iPtr, &info, 0, valuePtr);			//]BD揇ʂ(0)͈͂]BAŜ]B
	if(retCode) { return retCode; }
	if(info.token != TCL_TOKEN_END) {					//IĂȂ΁AG[ƂB
		return Tcl_ErrMsg(iPtr, "syntax error in expression");
	}
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
/* ]Al擾B
 * [in]
 *	iPtr		C^v^ւ̃|C^B
 *	infoPtr		Exprւ̃|C^B
 *	prec		D揇ʂ(prec)͈͂]B		//_:Tcl6.7̎ł͗D揇ʂ݂̂lꌋ@lȂBSčƌȂB̂ߏZq]ȂBƂ΁Au1?0:2?3:4vu4vɂȂĂ܂B{́u0vɂȂׂBTcl8.xł͖Ȃu0vɂȂ悤B		2014/11/04ύX:ZqEɂȂ悤ɏC܂BTBL_TokenPrec[]':'̗D揇ʂ1炷ōς݂܂B':''('')'̗D揇ʂɂȂĂ܂܂A'('')'͗D揇ʂɊÂʂɏ̂Ŗ肠܂B
 *	valuePtr	li[ϐւ̃|C^B
 * [out]
 *	߂l		ʃR[hB
 * [note]
 *	- ֐ɏIꍇAvaluePtr͕]li[ĂB
 *	  infoPtŕAŌɎ擾g[Nނi[ĂB
 *	- infoPtr->typeTCL_TOKEN_VALUEłȂAl̎Ɏ擾g[NނłB	dv!!֐͕̎GłBinfoPtr->typevaluePtrAɓĂƂ͌ȂƂɒӂēǂ܂Ȃ΁Ał܂B
 *	  ֐́Ag[N1ǂ݂Ă邱ƂɁAӂB			ɁAǂinfoPtr->typeǂ݂Ă邩C擾valuePtr̒lǂ܂ňێĂ邩Aӂēǂނ悤ɂKv܂B
 */
static int Tcl_ExprGetValue(Tcl_Interp* iPtr, Tcl_ExprInfo* infoPtr, int prec, Tcl_Value* valuePtr) {
	/* (g[Nށ˗D揇)e[u */
	static const unsigned char TBL_TokenPrec[/*(TCL_TOKEN_*)*/]={
		0,0,0,0,0,	//END,VALUE,OPEN_PAREN,CLOSE_PAREN,COLON	//ZqEƂ邽߂ɁACOLON̗D揇ʂQUESTY̗D揇ʂႭݒ肵B
		1,		//QUESTY					//COLON̗D揇ʂEND,VALUE,OPEN_PAREN,CLOSE_PARENƓł邱ƂɈӖ͖B̃g[N͗DxrOɏ邩łB
		2,		//OR
		3,		//AND
		4,		//BIT_OR
		5,		//BIT_XOR
		6,		//BIT_AND
		7,7,		//EQUAL,NEQ
		8,8,8,8,	//LESS,GREATER,LEQ,GEQ
		9,9,		//LEFT_SHIFT,RIGHT_SHIFT
		10,10,		//PLUS,MINUS
		11,11,11,	//MULT,DIVIDE,MOD
		12,12,12,	//UNARY_MINUS,NOT,BIT_NOT
	};
	//
	int retCode;
	int operator;		//Current operator (either unary or binary).
	Tcl_Value value2;	//Second operand for current operator.		//ǂݔ΂̃_~[ϐƂĂgpB
	/* ŏ̃g[N擾B */
	retCode = Tcl_ExprLex(iPtr, infoPtr, valuePtr);
	if(retCode) { return retCode; }
	/* g[NނoĂB */
	operator = infoPtr->token;
	/* '('Ȃ΁c */
	if(operator == TCL_TOKEN_OPEN_PAREN) {
		/* ')'܂ł]AlƂĎ擾B */
		retCode = Tcl_ExprGetValue(iPtr, infoPtr, TBL_TokenPrec[operator], valuePtr);												//Őǂ݂infoPtr->tokenǍ̕]ΏۂƂȂB
		if(retCode) { return retCode; }
		/* ')'ɁA'\0'ɓBꍇ́AG[ƂB */
		if(infoPtr->token != TCL_TOKEN_CLOSE_PAREN) {
			return Tcl_ErrMsg(iPtr, "unmatched parentheses in expression");
		}
	/* '('ȊOȂ΁c */
	} else {
		/* ŏɌꂽ'-'Ȃ΁APZqƌȂB */
		if(operator == TCL_TOKEN_MINUS) { operator = TCL_TOKEN_UNARY_MINUS; }
		/* PZqȂ΁c */
		if(operator >= TCL_TOKEN_UNARY_MINUS) {
			/* PZq́A퉉Zqg[N擾B */
			retCode = Tcl_ExprGetValue(iPtr, infoPtr, TBL_TokenPrec[operator], valuePtr);	//D揇ʂoperator̗D揇ʂ͈͂]B			//Őǂ݂infoPtr->tokenǍ̕]ΏۂƂȂB
			if(retCode) { return retCode; }
			/* PZqɂāc */
			switch(operator) {
			case TCL_TOKEN_UNARY_MINUS:
				if(valuePtr->type == TCL_TYPE_INT) {
					valuePtr->value.intValue = -valuePtr->value.intValue;
				} else if(valuePtr->type == TCL_TYPE_DOUBLE){
					valuePtr->value.doubleValue = -valuePtr->value.doubleValue;
				} else {
					return Tcl_ErrMsg(iPtr, "illegal operand type");
				}
				break;
			case TCL_TOKEN_NOT:
				if(valuePtr->type == TCL_TYPE_INT) {
					valuePtr->value.intValue = !valuePtr->value.intValue;
				} else if(valuePtr->type == TCL_TYPE_DOUBLE) {
					valuePtr->value.intValue = !valuePtr->value.doubleValue;
					valuePtr->type = TCL_TYPE_INT;
				} else {
					return Tcl_ErrMsg(iPtr, "illegal operand type");
				}
				break;
			case TCL_TOKEN_BIT_NOT:
				if(valuePtr->type == TCL_TYPE_INT) {
					valuePtr->value.intValue = ~valuePtr->value.intValue;
				} else {
					return Tcl_ErrMsg(iPtr, "illegal operand type");
				}
				break;
			default:
				DIE();
			}
			/* PZqKplǍ̏̍ӒlƂȂB
			 * infoPtr->tokenɂ́ÃubN̏̕ŎsTcl_ExprGetValue()ɂāAPZq̓Kp͈͂̒̃g[N擾ς݂łB
			 * <>
			 *	|PQR{STU
			 *	
			 *	@@@Tcl_ExprGetValue()ɂinfoPtr->tokenɎ擾ς݁BTcl_ExprGetValue()̓g[N1ǂ݂邩B
			 *	@@valuePtr->valueɊi[ς݁B(valuePtr->type=TCL_TYPE_INT,valuePtr->value.intValue=-123)ɂȂĂB
			 * ]āǍŉZq擾鏈XLbvB */
			goto L_gotOp;
		/* '('łPZqłȂ΁APƂ̒l擾͂łB
		 * PƂ̒l擾Ȃꍇ́AȂ蕶̏I[ɓBAȂ񍀉ZqoƍlAG[ƂB */
		} else if(operator != TCL_TOKEN_VALUE) {
			return Tcl_ErrMsg(iPtr, "illegal expression");
		}
	}
	/* ̃g[N擾B
	 * infoPtr->token()񍀉Zq擾̂ړIłAl͕svȂ̂Ń_~[Ƃvalue2w肷B
	 * valuePtrwĺǍ̏ŁAgp̂ŁAj󂵂Ă͂ȂB */
	retCode = Tcl_ExprLex(iPtr, infoPtr, &value2);																	//Őǂ݂infoPtr->tokenǍ̕]ΏۂƂȂB
	if(retCode) { return retCode; }
L_gotOp:
	for(;;) {
		/* g[NނoĂB */
		operator = infoPtr->token;
		/* ̏I[,')',':'Ȃ΁A]IB */
		if((operator == TCL_TOKEN_END) || (operator == TCL_TOKEN_CLOSE_PAREN) || (operator == TCL_TOKEN_COLON)) {
			return TCL_OK;
		}
		/* 񍀉ZqłȂ΁AG[ƂB */
		if((operator < TCL_TOKEN_QUESTY) || (operator > TCL_TOKEN_MOD)) {
			return Tcl_ErrMsg(iPtr, "illegal expression");
		}
		/* operator̗D揇ʂAw肳ꂽD揇ʈȉȂ΁A]IB */
		if(TBL_TokenPrec[operator] <= prec) {
			return TCL_OK;
		}
		/* Z]sZq('?','||','&&')Ȃ΁c */
		if((operator == TCL_TOKEN_QUESTY) || (operator == TCL_TOKEN_OR) || (operator == TCL_TOKEN_AND)) {
			/* Ӓl^UlɕϊB */
			switch(valuePtr->type) {
			case TCL_TYPE_STRING:
				retCode = Tcl_GetBoolean(iPtr, valuePtr->value.stringValue, &valuePtr->value.intValue);
				if(retCode) { return retCode; }
				break;
			case TCL_TYPE_INT:
				/** no job **/
				break;
			case TCL_TYPE_DOUBLE:
				valuePtr->value.intValue = !!valuePtr->value.doubleValue;
				break;
			default:
				DIE();
			}
			valuePtr->type = TCL_TYPE_INT;
			/* '?'Ȃ΁c */
			if(operator == TCL_TOKEN_QUESTY) {										//TODO:@ɖ肠BLRgQƂB		2014/11/04ύX:ZqEɂȂ悤ɏC܂BTBL_TokenPrec[]':'̗D揇ʂ1炷ōς݂܂B':''('')'̗D揇ʂɂȂĂ܂܂A'('')'͗D揇ʂɊÂʂɏ̂Ŗ肠܂B
				if(valuePtr->value.intValue) {										//(?:)̑^ȂΑ]O]ȂB
					retCode = Tcl_ExprGetValue(iPtr, infoPtr, TBL_TokenPrec[operator], valuePtr);			//valuePtrɑ擾B		//Őǂ݂infoPtr->tokenǍ̕]ΏۂƂȂB
					if(retCode) { return retCode; }
					if(infoPtr->token != TCL_TOKEN_COLON) { return Tcl_ErrMsg(iPtr, "illegal expression"); }	//':'擾B
					iPtr->noEval++;
					retCode = Tcl_ExprGetValue(iPtr, infoPtr, TBL_TokenPrec[infoPtr->token], &value2);		//Oǂݔ΂Bvalue2̓_~[łB	//Őǂ݂infoPtr->tokenǍ̕]ΏۂƂȂB
					iPtr->noEval--;
					if(retCode) { return retCode; }
				} else {												//(?:)̑UȂΑ]O]B
					iPtr->noEval++;
					retCode = Tcl_ExprGetValue(iPtr, infoPtr, TBL_TokenPrec[operator], &value2);			//ǂݔ΂Bvalue2̓_~[łB	//Őǂ݂infoPtr->tokenǍ̕]ΏۂƂȂB
					iPtr->noEval--;
					if(retCode) { return retCode; }
					if(infoPtr->token != TCL_TOKEN_COLON) { return Tcl_ErrMsg(iPtr, "illegal expression"); }	//':'擾B
					retCode = Tcl_ExprGetValue(iPtr, infoPtr, TBL_TokenPrec[infoPtr->token], valuePtr);		//valuePtrɑO擾B		//Őǂ݂infoPtr->tokenǍ̕]ΏۂƂȂB
					if(retCode) { return retCode; }
				}
			/* '||''&&'ŁAZ]c */
			} else if(((operator == TCL_TOKEN_OR ) &&  valuePtr->value.intValue) ||						//(||)̍Ӓl^ȂΉEӂ]ȂB
			          ((operator == TCL_TOKEN_AND) && !valuePtr->value.intValue)) {						//(&&)̍ӒlUȂΉEӂ]ȂB
				iPtr->noEval++;
				retCode = Tcl_ExprGetValue(iPtr, infoPtr, TBL_TokenPrec[operator], &value2);				//Eӂǂݔ΂Bvalue2̓_~[łB	//Őǂ݂infoPtr->tokenǍ̕]ΏۂƂȂB
				iPtr->noEval--;
				if(retCode) { return retCode; }
			/* '||''&&'ŁAZ]Ȃ΁c */
			} else {
				//valuePtrɉEӒl擾B
				retCode = Tcl_ExprGetValue(iPtr, infoPtr, TBL_TokenPrec[operator], valuePtr);										//Őǂ݂infoPtr->tokenǍ̕]ΏۂƂȂB
				if(retCode) { return retCode; }
				/* EӒl^UlɕϊB */
				switch(valuePtr->type) {
				case TCL_TYPE_STRING:
					retCode = Tcl_GetBoolean(iPtr, valuePtr->value.stringValue, &valuePtr->value.intValue);
					if(retCode) { return retCode; }
					break;
				case TCL_TYPE_INT:
					/** no job **/
					break;
				case TCL_TYPE_DOUBLE:
					valuePtr->value.intValue = !!valuePtr->value.doubleValue;
					break;
				default:
					DIE();
				}
				valuePtr->type = TCL_TYPE_INT;
			}
		/* Z]sZq('?','||','&&')ȊOȂ΁c */
		} else {
			//EӒl擾B
			retCode = Tcl_ExprGetValue(iPtr, infoPtr, TBL_TokenPrec[operator], &value2);											//Őǂ݂infoPtr->tokenǍ̕]ΏۂƂȂB
			if(retCode) { return retCode; }
			//:
			//Tcl6.7̎ł́AŁu(infoPtr->token='(')Ȃ΃G[vƂsĂAӐ}słB
			//Ƃ΁u1+1(v̂悤Ȏ͂ꂽꍇAu1+v̌ɉEӂTcl_ExprGetValue()sƂɁA'('TCL_TOKEN_ENDłTCL_TOKEN_CLOSE_PARENł񍀉ZqłȂ̂ŁAɃG[Ɣ肳Ă͂B
			//(infoPtr->token='(')̎ɁA܂œB邱Ƃ͂Ȃ͂łB]āA͍̔폜邱ƂɂB
			//ԈĂāA܂œB邱ƂƂĂAXG[Ȃ̂ŁAê͎sɑ΂Ă݂̂łB
			//ɑ΂ĉe邱Ƃ͖̂ŁAdȃGoOɂȂ\͒Ⴂ낤B
			/* ZqɂāA炩ߌ^ϊsĂB */
			//At this point we've got two values and an operator.
			//Check to make sure that the particular data types are appropriate for the particular operator, and perform type conversion if necessary.
			switch(operator) {
			//For the operators below, no strings are allowed and ints get converted to floats if necessary.
			case TCL_TOKEN_PLUS:		//'+'
			case TCL_TOKEN_MINUS:		//'-'
			case TCL_TOKEN_MULT:		//'*'
			case TCL_TOKEN_DIVIDE:		//'/'
				if((valuePtr->type == TCL_TYPE_STRING) ||
				   (   value2.type == TCL_TYPE_STRING)) { return Tcl_ErrMsg(iPtr, "illegal operand type"); }
				if(valuePtr->type == TCL_TYPE_DOUBLE) {
					if(value2.type == TCL_TYPE_INT) {
						value2.value.doubleValue = value2.value.intValue;
						value2.type = TCL_TYPE_DOUBLE;
					}
				} else if(value2.type == TCL_TYPE_DOUBLE) {
					if(valuePtr->type == TCL_TYPE_INT) {
						valuePtr->value.doubleValue = valuePtr->value.intValue;
						valuePtr->type = TCL_TYPE_DOUBLE;
					}
				}
				break;
			//For the operators below, only integers are allowed.
			case TCL_TOKEN_BIT_OR:		//'|'
			case TCL_TOKEN_BIT_XOR:		//'^'
			case TCL_TOKEN_BIT_AND:		//'&'
			case TCL_TOKEN_LEFT_SHIFT:	//'<<'
			case TCL_TOKEN_RIGHT_SHIFT:	//'>>'
			case TCL_TOKEN_MOD:		//'%'
				if((valuePtr->type != TCL_TYPE_INT) ||
				   (   value2.type != TCL_TYPE_INT)) { return Tcl_ErrMsg(iPtr, "illegal operand type"); }
				break;
			//For the operators below, any type is allowed but the two operands must have the same type.
			//Convert integers to floats and either to strings, if necessary.
			case TCL_TOKEN_EQUAL:		//'=='
			case TCL_TOKEN_NEQ:		//'!='
			case TCL_TOKEN_LESS:		//'<'
			case TCL_TOKEN_GREATER:		//'>'
			case TCL_TOKEN_LEQ:		//'<='
			case TCL_TOKEN_GEQ:		//'>='
				if(valuePtr->type == TCL_TYPE_STRING) {
					if(value2.type != TCL_TYPE_STRING) {
						Tcl_ExprMakeString(&value2);
					}
				} else if(value2.type == TCL_TYPE_STRING) {
					if(valuePtr->type != TCL_TYPE_STRING) {
						Tcl_ExprMakeString(valuePtr);
					}
				} else if(valuePtr->type == TCL_TYPE_DOUBLE) {
					if(value2.type == TCL_TYPE_INT) {
						value2.value.doubleValue = value2.value.intValue;
						value2.type = TCL_TYPE_DOUBLE;
					}
				} else if(value2.type == TCL_TYPE_DOUBLE) {
					if(valuePtr->type == TCL_TYPE_INT) {
						valuePtr->value.doubleValue = valuePtr->value.intValue;
						valuePtr->type = TCL_TYPE_DOUBLE;
					}
				}
				break;
			default:
				DIE();	//Ŏ~܂Acase̘RƎvAW[̃oOłB[U[XNvg̖ł͂ȂB
			}
			//If necessary, convert one of the operands to the type of the other.
			//If the operands are incompatible with the operator (e.g. "+" on strings) then return an error.
			switch(operator) {
			case TCL_TOKEN_BIT_OR:		//'|'
				valuePtr->value.intValue |= value2.value.intValue;
				break;
			case TCL_TOKEN_BIT_XOR:		//'^'
				valuePtr->value.intValue ^= value2.value.intValue;
				break;
			case TCL_TOKEN_BIT_AND:		//'&'
				valuePtr->value.intValue &= value2.value.intValue;
				break;
			case TCL_TOKEN_EQUAL:		//'=='
				if(valuePtr->type == TCL_TYPE_INT) {
					valuePtr->value.intValue = (valuePtr->value.intValue == value2.value.intValue);
				} else if(valuePtr->type == TCL_TYPE_DOUBLE) {
					valuePtr->value.intValue = (valuePtr->value.doubleValue == value2.value.doubleValue);
				} else {
					valuePtr->value.intValue = !strcmp(valuePtr->value.stringValue, value2.value.stringValue);
				}
				valuePtr->type = TCL_TYPE_INT;
				break;
			case TCL_TOKEN_NEQ:		//'!='
				if(valuePtr->type == TCL_TYPE_INT) {
					valuePtr->value.intValue = (valuePtr->value.intValue != value2.value.intValue);
				} else if(valuePtr->type == TCL_TYPE_DOUBLE) {
					valuePtr->value.intValue = (valuePtr->value.doubleValue != value2.value.doubleValue);
				} else {
					valuePtr->value.intValue = !!strcmp(valuePtr->value.stringValue, value2.value.stringValue);
				}
				valuePtr->type = TCL_TYPE_INT;
				break;
			case TCL_TOKEN_LESS:		//'<'
				if(valuePtr->type == TCL_TYPE_INT) {
					valuePtr->value.intValue = (valuePtr->value.intValue < value2.value.intValue);
				} else if(valuePtr->type == TCL_TYPE_DOUBLE) {
					valuePtr->value.intValue = (valuePtr->value.doubleValue < value2.value.doubleValue);
				} else {
					valuePtr->value.intValue = (strcmp(valuePtr->value.stringValue, value2.value.stringValue) < 0);
				}
				valuePtr->type = TCL_TYPE_INT;
				break;
			case TCL_TOKEN_GREATER:		//'>'
				if(valuePtr->type == TCL_TYPE_INT) {
					valuePtr->value.intValue = (valuePtr->value.intValue > value2.value.intValue);
				} else if(valuePtr->type == TCL_TYPE_DOUBLE) {
					valuePtr->value.intValue = (valuePtr->value.doubleValue > value2.value.doubleValue);
				} else {
					valuePtr->value.intValue = (strcmp(valuePtr->value.stringValue, value2.value.stringValue) > 0);
				}
				valuePtr->type = TCL_TYPE_INT;
				break;
			case TCL_TOKEN_LEQ:		//'<='
				if(valuePtr->type == TCL_TYPE_INT) {
					valuePtr->value.intValue = (valuePtr->value.intValue <= value2.value.intValue);
				} else if(valuePtr->type == TCL_TYPE_DOUBLE) {
					valuePtr->value.intValue = (valuePtr->value.doubleValue <= value2.value.doubleValue);
				} else {
					valuePtr->value.intValue = (strcmp(valuePtr->value.stringValue, value2.value.stringValue) <= 0);
				}
				valuePtr->type = TCL_TYPE_INT;
				break;
			case TCL_TOKEN_GEQ:		//'>='
				if(valuePtr->type == TCL_TYPE_INT) {
					valuePtr->value.intValue = (valuePtr->value.intValue >= value2.value.intValue);
				} else if(valuePtr->type == TCL_TYPE_DOUBLE) {
					valuePtr->value.intValue = (valuePtr->value.doubleValue >= value2.value.doubleValue);
				} else {
					valuePtr->value.intValue = (strcmp(valuePtr->value.stringValue, value2.value.stringValue) >= 0);
				}
				valuePtr->type = TCL_TYPE_INT;
				break;
			case TCL_TOKEN_LEFT_SHIFT:	//'<<'
				valuePtr->value.intValue <<= value2.value.intValue;
				break;
			case TCL_TOKEN_RIGHT_SHIFT:	//'>>'
				valuePtr->value.intValue >>= value2.value.intValue;
				break;
			case TCL_TOKEN_PLUS:		//'+'
				if(valuePtr->type == TCL_TYPE_INT) {
					valuePtr->value.intValue += value2.value.intValue;
				} else {
					valuePtr->value.doubleValue += value2.value.doubleValue;
				}
				break;
			case TCL_TOKEN_MINUS:		//'-'
				if(valuePtr->type == TCL_TYPE_INT) {
					valuePtr->value.intValue -= value2.value.intValue;
				} else {
					valuePtr->value.doubleValue -= value2.value.doubleValue;
				}
				break;
			case TCL_TOKEN_MULT:		//'*'
				if(valuePtr->type == TCL_TYPE_INT) {
					valuePtr->value.intValue *= value2.value.intValue;
				} else {
					valuePtr->value.doubleValue *= value2.value.doubleValue;
				}
				break;
			case TCL_TOKEN_DIVIDE:		//'/'
				if(valuePtr->type == TCL_TYPE_INT) {
					if(!value2.value.intValue) {
						return Tcl_ErrMsg(iPtr, "divide by zero");
					}
					valuePtr->value.intValue /= value2.value.intValue;
				} else {
					if(!value2.value.doubleValue) {
						return Tcl_ErrMsg(iPtr, "divide by zero");
					}
					valuePtr->value.doubleValue /= value2.value.doubleValue;
				}
				break;
			case TCL_TOKEN_MOD:		//'%'
				if(!value2.value.intValue) {
					return Tcl_ErrMsg(iPtr, "divide by zero");
				}
				valuePtr->value.intValue %= value2.value.intValue;
				break;
			default:
				DIE();	//Ŏ~܂Acase̘RƎvAW[̃oOłB[U[XNvg̖ł͂ȂB
			}
		}
	}
}
/*--------------------------------------------------------------------------*/
/* ͂sB
 * [in]
 *	iPtr		C^v^ւ̃|C^B
 *	infoPtr		Exprւ̃|C^B
 *	valuePtr	li[ϐւ̃|C^B
 * [out]
 *	߂l		ʃR[hB
 * [note]
 *	- ֐́AIꍇɁAL̃tB[hݒ肷B
 *	  1.   KA(infoPtr->token)ݒ肷B
 *	  2-1. (infoPtr->token=TCL_TOKEN_VALUE)łꍇA    (valuePtr->type,valuePtr->*Value)ݒ肷B
 *	  2-2. (infoPtr->token=TCL_TOKEN_VALUE)ȊOłꍇA(valuePtr->type,valuePtr->*Value)ύXȂB
 *	  3.   KA(infoPtr->expr)XVB
 */
static int Tcl_ExprLex(Tcl_Interp* iPtr, Tcl_ExprInfo* infoPtr, Tcl_Value* valuePtr) {
	int retCode, c;
	char* value;
	/* s󔒂ǂݔ΂B */
	while(isspace(c = *infoPtr->expr++)) { /** no job **/ }				//infoPtr->expŕAc̎̈ʒuwB
	/* Zq? */
	switch(c) {
	case '\0':
		infoPtr->token = TCL_TOKEN_END;
		infoPtr->expr--;	//'\0'̈ʒu
		return TCL_OK;
	case '$':
		infoPtr->token = TCL_TOKEN_VALUE;
		value = Tcl_ParseVar(iPtr, infoPtr->expr, &infoPtr->expr);		//ϐ̒l擾B
		if(!value) { return TCL_ERROR; }											//TODO:noEvalԂȂΖ`ϐQƂĂG[ɂʂׂB
		Tcl_ExprParseString(iPtr, value, valuePtr);				//ľ^𔻒肵Ali[B
		return TCL_OK;
	case '[':
		infoPtr->token = TCL_TOKEN_VALUE;
		retCode = Tcl_Eval(iPtr, infoPtr->expr, &infoPtr->expr, ']');		//R}hsB				//noEvalԂȂ΁ATcl_Eval()fĎsXLbv̂ŁAnoEvalKv͖B
		if(retCode) { return retCode; }
		infoPtr->expr++;	//']'̎̈ʒu
		Tcl_ExprParseString(iPtr, iPtr->result, valuePtr);			//ľ^𔻒肵Ali[B
	//	iPtr->result = "";													//TODO:mTcl_Eval()i[ʂ̂ĂKv͗L̂A֐̌Ăяoŏ㏑邩炱ŃNAȂĂǂ̂ł́H̍s͍폜ėǂ̂ł́H	ˍ폜Ă݂B肪ꍇ͍ČB
		return TCL_OK;
	case '"':
		infoPtr->token = TCL_TOKEN_VALUE;
		value = Tcl_ParseQuotes(iPtr, infoPtr->expr, &infoPtr->expr, '"');	//dpň͂܂ꂽ擾B	//FTcl_ParseQuotes()͌XA镶̎̕ĂȂ̂ŁAL̔z͕svBu"v̎̌̕ŝ́ATcl_SplitList()ĂяoĂATcl_IsQuotedElement()݂̂łB
		if(!value) { return TCL_ERROR; }											//
		infoPtr->expr++;	//'"'̎̈ʒu											//
		Tcl_ExprParseString(iPtr, value, valuePtr);				//ľ^𔻒肵Ali[B		//
		return TCL_OK;														//
	case '{':															//
		infoPtr->token = TCL_TOKEN_VALUE;											//
		value = Tcl_ParseBraces(iPtr, infoPtr->expr, &infoPtr->expr, -1);	//gʂň͂܂ꂽ擾B		//{{2014/11/05:(termChar=-1)w肷ƔCӂ̕e悤ɂ܂B(termChar=-1)Tcl_ExprLex()płB}}
		if(!value) { return TCL_ERROR; }
		infoPtr->expr++;	//'}'̎̈ʒu
		Tcl_ExprParseString(iPtr, value, valuePtr);				//ľ^𔻒肵Ali[B
		return TCL_OK;
	case '(':
		infoPtr->token = TCL_TOKEN_OPEN_PAREN;
		return TCL_OK;
	case ')':
		infoPtr->token = TCL_TOKEN_CLOSE_PAREN;
		return TCL_OK;
	case ':':
		infoPtr->token = TCL_TOKEN_COLON;
		return TCL_OK;
	case '?':
		infoPtr->token = TCL_TOKEN_QUESTY;
		return TCL_OK;
	case '|':
		switch(*infoPtr->expr++) {
		case '|':								//'||'
			infoPtr->token = TCL_TOKEN_OR;
			return TCL_OK;
		default:								//'|'
			infoPtr->token = TCL_TOKEN_BIT_OR;
			infoPtr->expr--;
			return TCL_OK;
		}
	case '&':
		switch(*infoPtr->expr++) {
		case '&':								//'&&'
			infoPtr->token = TCL_TOKEN_AND;
			return TCL_OK;
		default:								//'&'
			infoPtr->token = TCL_TOKEN_BIT_AND;
			infoPtr->expr--;
			return TCL_OK;
		}
	case '^':
		infoPtr->token = TCL_TOKEN_BIT_XOR;
		return TCL_OK;
	case '=':
		switch(*infoPtr->expr++) {
		case '=':								//'=='
			infoPtr->token = TCL_TOKEN_EQUAL;
			return TCL_OK;
		default:
			return TCL_ERROR;
		}
	case '!':
		switch(*infoPtr->expr++) {
		case '=':								//'!='
			infoPtr->token = TCL_TOKEN_NEQ;
			return TCL_OK;
		default:								//'!'
			infoPtr->token = TCL_TOKEN_NOT;
			infoPtr->expr--;
			return TCL_OK;
		}
	case '<':
		switch(*infoPtr->expr++) {
		case '<':								//'<<'
			infoPtr->token = TCL_TOKEN_LEFT_SHIFT;
			return TCL_OK;
		case '=':								//'<='
			infoPtr->token = TCL_TOKEN_LEQ;
			return TCL_OK;
		default:								//'<'
			infoPtr->token = TCL_TOKEN_LESS;
			infoPtr->expr--;
			return TCL_OK;
		}
	case '>':
		switch(*infoPtr->expr++) {
		case '>':								//'>>'
			infoPtr->token = TCL_TOKEN_RIGHT_SHIFT;
			return TCL_OK;
		case '=':								//'>='
			infoPtr->token = TCL_TOKEN_GEQ;
			return TCL_OK;
		default:								//'>'
			infoPtr->token = TCL_TOKEN_GREATER;
			infoPtr->expr--;
			return TCL_OK;
		}
	case '+':
		infoPtr->token = TCL_TOKEN_PLUS;
		return TCL_OK;
	case '-':
		infoPtr->token = TCL_TOKEN_MINUS;					//͊(Tcl_ExprLex())'-'񍀉ZqƌȂĂB\͊(Tcl_ExprGetValue())fĒPZqɕϊB
		return TCL_OK;
	case '*':
		infoPtr->token = TCL_TOKEN_MULT;
		return TCL_OK;
	case '/':
		infoPtr->token = TCL_TOKEN_DIVIDE;
		return TCL_OK;
	case '%':
		infoPtr->token = TCL_TOKEN_MOD;
		return TCL_OK;
	case '~':
		infoPtr->token = TCL_TOKEN_BIT_NOT;
		return TCL_OK;
	}
	infoPtr->expr--;	//c̈ʒu
	/* l? */									//֐ł'-'ZqƉ߂Al̈ꕔƌȂȂB'-'͏̏Ŕς݂łAւ͓BȂB
	{
		int    intValue;
		char*  intEndp;
		double doubleValue;
		char*  doubleEndp;
		intValue    = strtol(infoPtr->expr, &intEndp, 0);			//Ƃĉ߂Ă݂B
		doubleValue = strtod(infoPtr->expr, &doubleEndp);			//Ƃĉ߂Ă݂B
		if((intEndp    != infoPtr->expr) ||
		   (doubleEndp != infoPtr->expr)) {					//,,́AȂƂƂĉ߂łc
			if(intEndp >= doubleEndp) {					//Œvŉ߂Bŉ߂łꍇ͐ƌȂB
				valuePtr->type = TCL_TYPE_INT;
				valuePtr->value.intValue = intValue;
				infoPtr->expr = intEndp;
			} else {
				valuePtr->type = TCL_TYPE_DOUBLE;
				valuePtr->value.doubleValue = doubleValue;
				infoPtr->expr = doubleEndp;
			}
			infoPtr->token = TCL_TOKEN_VALUE;
			return TCL_OK;
		}
	}
	/* ^UlƂĉ߂ł郊e? */
	{
		int booleanValue;
		char* endp = infoPtr->expr;
		while(iscsym(*endp)) { endp++; }					//PƌȂ͈͂؂oB
		value = strndup(infoPtr->expr, endp - infoPtr->expr);
		retCode = Tcl_GetBoolean(iPtr, value, &booleanValue);			//^UlƂĉ߂Ă݂B
		if(!retCode) {
			valuePtr->type = TCL_TYPE_STRING;				//^UlƂĉ߂łȂ΁A^̒lƂĊi[BŐ^̒lƂ͂ȂB̌̏ŁA^Ul̒P̂܂ܕƂĈ\L邩łB
			valuePtr->value.stringValue = value;
			infoPtr->expr = endp;
			infoPtr->token = TCL_TOKEN_VALUE;
			return TCL_OK;
		}
	}
	return TCL_ERROR;
}
/*--------------------------------------------------------------------------*/
/* ̌^𔻒肵AlƂĊi[B
 * [in]
 *	iPtr		C^v^ւ̃|C^B
 *	s		B
 *	valuePtr	li[ϐւ̃|C^B
 */
static void Tcl_ExprParseString(Tcl_Interp* iPtr, const char* s, Tcl_Value* valuePtr) {
	//󕶎łȂ΁c
	if(*s) {
		char* endp;
		//ƂĕI[܂ŉ߂ł΁AƌȂB
		valuePtr->type = TCL_TYPE_INT;
		valuePtr->value.intValue = strtol(s, &endp, 0);
		while(isspace(*endp)) { endp++; }
		if(!*endp) { return; }
		//ƂĕI[܂ŉ߂ł΁AƌȂB
		valuePtr->type = TCL_TYPE_DOUBLE;
		valuePtr->value.doubleValue = strtod(s, &endp);
		while(isspace(*endp)) { endp++; }
		if(!*endp) { return; }
	}
	//,,Ƃĉ߂łȂ΁AƌȂB
	valuePtr->type = TCL_TYPE_STRING;
	valuePtr->value.stringValue = s;
}
/*--------------------------------------------------------------------------*/
/* l𐔒l^ɕϊB
 * [in]
 *	valuePtr	lϊϐւ̃|C^B
 */
static void Tcl_ExprMakeString(Tcl_Value* valuePtr) {
	switch(valuePtr->type) {
	case TCL_TYPE_STRING:
		/** no job **/
		break;
	case TCL_TYPE_INT:
		valuePtr->value.stringValue = strdup_printf("%d", valuePtr->value.intValue);
		break;
	case TCL_TYPE_DOUBLE:
		valuePtr->value.stringValue = strdup_printf("%g", valuePtr->value.doubleValue);
		//Tcl6.7̎ł́uset x [expr 1.0]vu1vƂȂ肻ȍ~ZĂ܂肪B΍ƂĈȉ̏Tcl7.0Tcl_PrintDouble()obN|[gďCB
		if(!strchr(valuePtr->value.stringValue, '.') &&
		   !strchr(valuePtr->value.stringValue, 'e')) { valuePtr->value.stringValue = strjoin(NULL, valuePtr->value.stringValue, ".0", NULL); }
		break;
	default:
		DIE();
	}
	valuePtr->type = TCL_TYPE_STRING;
}
/*==========================================================================*
 *	\
 *==========================================================================*/
//exit ?returnCode?
static int Tcl_ExitCmd(Tcl_Interp* iPtr) {
	int retCode, status = 0;
	if(iPtr->argc == 2) {						//IR[hw肳ĂAIR[h擾B
		retCode = Tcl_GetInt(iPtr, iPtr->argv[1], &status);
		if(retCode) { return retCode; }
	}
	exit(status);							//IB
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//break
static int Tcl_BreakCmd(Tcl_Interp* iPtr) {
	return TCL_BREAK;
}
/*--------------------------------------------------------------------------*/
//continue
static int Tcl_ContinueCmd(Tcl_Interp* iPtr) {
	return TCL_CONTINUE;
}
/*--------------------------------------------------------------------------*/
//if expr1 ?then? body1 elseif expr2 ?then? body2 elseif ... ?else? ?bodyN?
static int Tcl_IfCmd(Tcl_Interp* iPtr) {
	int retCode, cond, i = 1;
	//Tclif́AŌɎsR}ȟʂԂBifƁAwhileyfoŕA߂l̎dl̈ႢɒӂB
	for(;;) {
		//At this point in the loop, argv and argc refer to an expression to test, either for the main expression or an expression following an "elseif".
		//The arguments after the expression must be "then"(optional) and a script to execute if the expression is true.
		if(i >= iPtr->argc) { return Tcl_ErrMsg(iPtr, "syntax error"); }
		retCode = Tcl_ExprBoolean(iPtr, iPtr->argv[i], &cond);
		if(retCode) { return retCode; }
		i++;
		if((i < iPtr->argc) && !strcmp(iPtr->argv[i], "then")) { i++; }
		if(i >= iPtr->argc) { return Tcl_ErrMsg(iPtr, "syntax error"); }
		if(cond) { return Tcl_EvalString(iPtr, iPtr->argv[i]); }
		//The expression evaluated to false.
		//Skip the command, then see if there is an "else" or "elseif" clause.
		i++;
		if(i >= iPtr->argc) { return TCL_OK; }	//'elseif'߂'else'߂
		//if expr1 ?then? body1 elseif expr2 ?then? body2 elseif ... ?else? ?bodyN?
		//                                                           ~~~~~~elseȗ\ł邱Ƃɒӂ<>if {0} {} else {puts ok}Ƣif {0} {} {puts ok}͓
		if(!strcmp(iPtr->argv[i], "elseif")) { i++; continue; }		//'elseif'ߗLB'elseif'߂bodyȂꍇ͎̃[v̐擪ŃG[oB
		if(!strcmp(iPtr->argv[i], "else")) { i++; }			//'else'𖾎'else'ߗLB'else'߂bodyȂꍇ̓[v𔲂ɃG[oB
		break;								//i='else'𖾎'else'߂bodyÁA'else'ȗ'else'߂bodywĂ͂B[v𔲂B
	}
	if(i != (iPtr->argc - 1)) { return Tcl_ErrMsg(iPtr, "syntax error"); }	//'else'߂bodyȂÁA'else'߂body̌ɗ]ȈLB
	return Tcl_EvalString(iPtr, iPtr->argv[i]);
}
/*--------------------------------------------------------------------------*/
//while test body
static int Tcl_WhileCmd(Tcl_Interp* iPtr) {
	int retCode, cond;
	for(;;) {
		retCode = Tcl_ExprBoolean(iPtr, iPtr->argv[1], &cond);
		if(retCode) { return retCode; }
		if(!cond) { break; }
		retCode = Tcl_EvalString(iPtr, iPtr->argv[2]);
		if(retCode == TCL_BREAK) { break; }
		if(retCode == TCL_CONTINUE) { retCode = TCL_OK; }
		if(retCode) { return retCode; }
	}
	iPtr->result = "";	//Tclwhile,for,foreach́A󕶎ԂdlłBŌɎsR}ȟʂԂ̂ł͂ȂBifƁAwhile,for,foreach́A߂l̎dl̈ႢɒӂB
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//for start test next body
static int Tcl_ForCmd(Tcl_Interp* iPtr) {
	int retCode, cond;
	//start
	retCode = Tcl_EvalString(iPtr, iPtr->argv[1]);
	if(retCode) { return retCode; }
	for(;;) {
		//test
		retCode = Tcl_ExprBoolean(iPtr, iPtr->argv[2], &cond);
		if(retCode) { return retCode; }
		if(!cond) { break; }
		//body
		retCode = Tcl_EvalString(iPtr, iPtr->argv[4]);
		if(retCode == TCL_BREAK) { break; }
		if(retCode == TCL_CONTINUE) { retCode = TCL_OK; }
		if(retCode) { return retCode; }
		//next
		retCode = Tcl_EvalString(iPtr, iPtr->argv[3]);
		if(retCode == TCL_BREAK) { break; }	//TclfoŕAufor {@} {A} {B} {C}vɂāACłȂBłbreakĂBCforƈႤ̂ŒӂB
		if(retCode) { return retCode; }
	}
	iPtr->result = "";	//Tclwhile,for,foreach́A󕶎ԂdlłBŌɎsR}ȟʂԂ̂ł͂ȂBifƁAwhile,for,foreach́A߂l̎dl̈ႢɒӂB
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//foreach varname list body							//uforeach varlist1 list1 ?varlist2 list2 c? bodyv`ɂ͖ΉB
static int Tcl_ForeachCmd(Tcl_Interp* iPtr) {
	int retCode;
	char **argv, *elem;
	Tcl_SplitList(iPtr->argv[2], &argv);
	while((elem = *argv++)) {
		if(!Tcl_SetVar(iPtr, iPtr->argv[1], elem)) { return TCL_ERROR; }
		retCode = Tcl_EvalString(iPtr, iPtr->argv[3]);
		if(retCode == TCL_BREAK) { break; }
		if(retCode == TCL_CONTINUE) { retCode = TCL_OK; }
		if(retCode) { return retCode; }
	}
	iPtr->result = "";	//Tclwhile,for,foreach́A󕶎ԂdlłBŌɎsR}ȟʂԂ̂ł͂ȂBifƁAwhile,for,foreach́A߂l̎dl̈ႢɒӂB
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//switch ?options? string pattern body ?pattern body ...?
//switch ?options? string {pattern body ?pattern body ...?}
static int Tcl_SwitchCmd(Tcl_Interp* iPtr) {
	int retCode;
	int mode = 0;	//0=exact,1=globBregexp͖ΉB
	int cond = 0;	//}b`1ɂȂAȍ~̍ŏɌ'-'ȊObodysB
	char **argv, *str, *pat, *body;
	for(argv = iPtr->argv + 1;	//R}h̎̈A
	    *argv && (**argv == '-');	//܂LAIvVwȂ΁c
	    argv++) {			//ȉāÄ֐i߂B
		if(!strcmp(*argv, "-exact")) { mode = 0; continue; }
		if(!strcmp(*argv, "-glob" )) { mode = 1; continue; }
		if(!strcmp(*argv, "--"    )) {              break; }
		return Tcl_ErrMsg(iPtr, "bad option");
	}
	//string擾A֐i߂B
	if(!(str = *argv++)) { return Tcl_ErrMsg(iPtr, "syntax error"); }
	//uswitch ?options? string {pattern body ?pattern body ...?}v`Ȃ΁A
	//uswitch ?options? string pattern body ?pattern body ...?v`ɕϊB
	if(!*argv) { return Tcl_ErrMsg(iPtr, "syntax error"); }
	if(!*(argv+1)) { Tcl_SplitList(*argv, &argv); }
	//patternbody̑gݍ킹ƂɌJԂB
	while((pat = *argv++)) {
		if(!(body = *argv++)) { return Tcl_ErrMsg(iPtr, "syntax error"); }
		if(!cond) {
			if(!*argv && !strcmp(pat, "default")) {	//Ōpattern'default'̏ꍇ̂defaultƂĈBŌpatternłȂ'default'ƂełB
				cond = 1;
			} else {
				if(!mode) {	//exact
					cond = !strcmp(pat, str);
				} else {	//glob
					cond = string_match(pat, str);
				}
			}
		}
		if(cond && strcmp(body, "-")) {
			retCode = Tcl_EvalString(iPtr, body);
			if(retCode) { return retCode; }
			break;
		}
	}
	return TCL_OK;
}
/*==========================================================================*
 *	񑀍
 *==========================================================================*/
//string length string
static int Tcl_StringLengthCmd(Tcl_Interp* iPtr) {
	iPtr->result = strdup_printf("%d", strlen(iPtr->argv[2]));	//string̕擾Aʂ̕Ɋi[B
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//string index string charIndex
static int Tcl_StringIndexCmd(Tcl_Interp* iPtr) {
	int retCode, len, index, bEnd;
	len = strlen(iPtr->argv[2]);					//string̕擾B
	retCode = Tcl_GetIndex(iPtr, iPtr->argv[3], &index, &bEnd);	//CfNX擾B
	if(retCode) { return retCode; }
	if(bEnd) { index += (len - 1); }	//lindexend͕̍Ō̕QƂB
	if((unsigned)index < (unsigned)len) {				//CfNXstring͈͓̔Ȃ΁c
		iPtr->result = strdup_printf("%c", iPtr->argv[2][index]);	//擾Aʂ̕Ɋi[B
	}
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//string trim string ?chars?
static int Tcl_StringTrimCmd(Tcl_Interp* iPtr) {
	iPtr->result = strtrim(iPtr->argv[2], 0, iPtr->argv[3]);	//(iPtr->argc=3)Ȃ(iPtr->argv[3]=NULL)Ȃ̂strtrim()ɂ󔒕̎wƂĈB
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//string trimleft string ?chars?
static int Tcl_StringTrimleftCmd(Tcl_Interp* iPtr) {
	iPtr->result = strtrim(iPtr->argv[2], 1, iPtr->argv[3]);	//(iPtr->argc=3)Ȃ(iPtr->argv[3]=NULL)Ȃ̂strtrim()ɂ󔒕̎wƂĈB
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//string trimright string ?chars?
static int Tcl_StringTrimrightCmd(Tcl_Interp* iPtr) {
	iPtr->result = strtrim(iPtr->argv[2], 2, iPtr->argv[3]);	//(iPtr->argc=3)Ȃ(iPtr->argv[3]=NULL)Ȃ̂strtrim()ɂ󔒕̎wƂĈB
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//string tolower string
static int Tcl_StringTolowerCmd(Tcl_Interp* iPtr) {
	iPtr->result = strlwr(strdup(iPtr->argv[2]));			//string𕡐AāAʂ̕Ɋi[B
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//string toupper string
static int Tcl_StringToupperCmd(Tcl_Interp* iPtr) {
	iPtr->result = strupr(strdup(iPtr->argv[2]));			//string𕡐A啶āAʂ̕Ɋi[B
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//string reverse string
static int Tcl_StringReverseCmd(Tcl_Interp* iPtr) {
	iPtr->result = strreverse(strdup(iPtr->argv[2]));		//string𕡐A]āAʂ̕Ɋi[B
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//string compare string1 string2
static int Tcl_StringCompareCmd(Tcl_Interp* iPtr) {
	int i = strcmp(iPtr->argv[2], iPtr->argv[3]);			//string1string2rAʂ̕ɁA-1,0,1i[B
	if(i < 0) { i = -1; }
	if(i > 0) { i =  1; }
	iPtr->result = strdup_printf("%d", i);
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//string match pattern string
static int Tcl_StringMatchCmd(Tcl_Interp* iPtr) {
	iPtr->result = strdup_printf("%d", string_match(iPtr->argv[2], iPtr->argv[3]));	//patternstringɃ}b`邩𔻒肵Aʂ̕ɁA0,1i[B
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//string first string1 string2
static int Tcl_StringFirstCmd(Tcl_Interp* iPtr) {
	char* p = strstr(iPtr->argv[3], iPtr->argv[2]);			//string1Astring2̒ɍŏɌʒuB
	int i = p ? (p - iPtr->argv[3]) : -1;				//string1Astring2̒ɌȂ΁A-1ƂB
	iPtr->result = strdup_printf("%d", i);				//string1Astring2̒ɍŏɌʒu,,-1Aʂ̕Ɋi[B
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//string last string1 string2
static int Tcl_StringLastCmd(Tcl_Interp* iPtr) {
	int i = strlen(iPtr->argv[3]);					//string2̕߂B
	while(--i >= 0) {						//string1Astring2̒ɍŌɌʒuB
		if(strstr(iPtr->argv[3] + i, iPtr->argv[2])) { break; }	//string1Astring2̒ɌȂ΁A-1ƂB
	}
	iPtr->result = strdup_printf("%d", i);				//string1Astring2̒ɍŌɌʒu,,-1Aʂ̕Ɋi[B
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//string range string first last
static int Tcl_StringRangeCmd(Tcl_Interp* iPtr) {
	int retCode, len, first, last, bEnd;
	len = strlen(iPtr->argv[2]);					//string̕߂B
	retCode = Tcl_GetIndex(iPtr, iPtr->argv[3], &first, &bEnd);	//CfNX擾B
	if(retCode) { return retCode; }
	if(bEnd) { first += (len - 1); }	//rangeend͕̍Ō̕QƂB
	retCode = Tcl_GetIndex(iPtr, iPtr->argv[4], &last, &bEnd);	//CfNX擾B
	if(retCode) { return retCode; }
	if(bEnd) { last += (len - 1); }		//rangeend͕̍Ō̕QƂB
	if(first < 0) { first = 0; }			//first0̏ꍇAŏ̕QƂ܂B
	if(last > (len - 1)) { last = (len - 1); }	//lastȏ̏ꍇAŌ̕QƂ܂B
	if(first <= last) {						//firstlastȉȂ΁Afirst`last̕Aʂ̕Ɋi[B	last̕܂ނƂɒ
		iPtr->result = strndup(iPtr->argv[2] + first, last - first + 1);
	}
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//string option arg ?arg ...?
static int Tcl_StringCmd(Tcl_Interp* iPtr) {
	static const Tcl_BuiltInCmd TBL_SubCmd[]={
		{"length",		Tcl_StringLengthCmd,		3,3},	//string length string
		{"index",		Tcl_StringIndexCmd,		4,4},	//string index string charIndex
		{"trim",		Tcl_StringTrimCmd,		3,4},	//string trim string ?chars?
		{"trimleft",		Tcl_StringTrimleftCmd,		3,4},	//string trimleft string ?chars?
		{"trimright",		Tcl_StringTrimrightCmd,		3,4},	//string trimright string ?chars?
		{"tolower",		Tcl_StringTolowerCmd,		3,3},	//string tolower string
		{"toupper",		Tcl_StringToupperCmd,		3,3},	//string toupper string
		{"reverse",		Tcl_StringReverseCmd,		3,3},	//string reverse string			//'string reverse'́ATcl8.5a6ŒǉꂽR}hłB
		{"compare",		Tcl_StringCompareCmd,		4,4},	//string compare string1 string2
		{"match",		Tcl_StringMatchCmd,		4,4},	//string match pattern string
		{"first",		Tcl_StringFirstCmd,		4,4},	//string first string1 string2
		{"last",		Tcl_StringLastCmd,		4,4},	//string last string1 string2
		{"range",		Tcl_StringRangeCmd,		5,5},	//string range string first last
	{0}};//I[
	//
	Tcl_CmdProc* cmdProc;
	/* TuR}h֐ĂяoB */
	cmdProc = Tcl_GetBuiltInCmd(iPtr, TBL_SubCmd, 1);
	return (*cmdProc)(iPtr);
}
/*--------------------------------------------------------------------------*/
//format formatString ?arg ...?
static int Tcl_FormatCmd(Tcl_Interp* iPtr) {
	int retCode, intValue;
	double doubleValue;
	char** argv = iPtr->argv + 1;	//R}h̎̈
	char* p = *argv++;		//p=formatString,argv=arg ...
	while(*p) {										//formatString̏I[ɒB܂Łc
		if(*p == '%') {									//'%'Ȃ΁c
			int   len = strcspn(p + 1/*'%'*/, "duioxXcsfeEgG%"/*ϊwq*/);	//'%'ƕϊwq̊ԂɂAx̕擾B
			char* fmt = strndup(p, 1/*'%'*/ + len/*x*/ + 1/*ϊwq*/);	//'%'Ɛxƕϊwq擾B
			switch(*(p + 1/*'%'*/ + len/*x*/)) {				//ϊwqɂāc
			case 'd':
			case 'u':
			case 'i':
			case 'o':
			case 'x':
			case 'X':
			case 'c':
				if(!*argv) { return TCL_ERROR; }				//̉ψAƂĎ擾B
				retCode = Tcl_GetInt(iPtr, *argv++, &intValue);
				if(retCode) { return retCode; }
				Tcl_AppendResultFormat(iPtr, fmt, intValue);			//āAʂ̕ɒǉB
				break;
			case 's':
				if(!*argv) { return TCL_ERROR; }				//̉ψAƂĎ擾B
				Tcl_AppendResultFormat(iPtr, fmt, *argv++);			//āAʂ̕ɒǉB
				break;
			case 'f':
			case 'e':
			case 'E':
			case 'g':
			case 'G':
				if(!*argv) { return TCL_ERROR; }				//̉ψAƂĎ擾B
				retCode = Tcl_GetDouble(iPtr, *argv++, &doubleValue);
				if(retCode) { return retCode; }
				Tcl_AppendResultFormat(iPtr, fmt, doubleValue);			//āAʂ̕ɒǉB
				break;
			case '%':
				Tcl_AppendResultFormat(iPtr, fmt);				//"%%"'%'B̏Tcl_AppendResultFormat()ɂčŝœʈKv͖B
				break;
			default:
				return Tcl_ErrMsg(iPtr, "invalid format");			//ϊwqsB
			}
			p += (1/*'%'*/ + len/*x*/ + 1/*ϊwq*/);			//|C^A'%'Ɛxƕϊwq̎֐i߂B
		} else {
			Tcl_AppendResultFormat(iPtr, "%s", strcompress(p, &p, "%"));		//'%'܂ł̊Ԃ̕AGXP[vāAʂ̕ɒǉB
		}
	}
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
static void Tcl_ScanCmd_callback(struct doscan_store* storePtr, void* param) {
	char*** argvPtr = param;
	int argc = strv_length(*argvPtr);
	switch(storePtr->type) {
	case 'n':
	case 'i':
	case 'd':
	case 'o':
	case 'u':
	case 'x':
	case 'X':
		(*argvPtr)[argc] = strdup_printf("%d", storePtr->value.i);
		break;
	case 'e':
	case 'E':
	case 'f':
	case 'g':
	case 'G':
		(*argvPtr)[argc] = strdup_printf("%g", storePtr->value.f);
		break;
	case 's':
	case 'c':
	case '[':
		(*argvPtr)[argc] = strdup(storePtr->value.s);
		break;
	default:
		DIE();
	}
	*argvPtr = realloc(*argvPtr, sizeof(char*)*(argc+1/*񑝂*/+1/*I[NULL*/));
	(*argvPtr)[argc+1] = NULL;//I[NULL
}
//scan string format ?varName ...?
static int Tcl_ScanCmd(Tcl_Interp* iPtr) {
	char** argv = calloc(sizeof(char*), 1);//argv[0]=I[NULL		//0̕|C^zmۂĂB̌ATcl_ScanCmd_callback()ɂĊgB
	doscan(iPtr->argv[1], iPtr->argv[2], Tcl_ScanCmd_callback, &argv);	//̃XLsA|C^zɊi[B
	if(iPtr->argc == 3) {							//i[ϐw肳ĂȂ΁ASĂ̗vfXgɂāAʂ̕Ɋi[B
		iPtr->result = Tcl_Merge(argv);
	} else {								//i[ϐw肳ĂAX̕ϐɊi[āAvfʂ̕Ɋi[B
		int i, argc = strv_length(argv);
		for(i = 0; i < argc; i++) {
			if((iPtr->argc <= (3+i)) ||				//XLvfɑ΂Ċi[ϐȂA
			   (!Tcl_SetVar(iPtr, iPtr->argv[3+i], argv[i]))) {	//ϐւ̊i[Ɏs(ϐs,ϐ^sȂ)AG[ƂB
				return Tcl_ErrMsg(iPtr, "store error");
			}
		}
		iPtr->result = strdup_printf("%d", argc);
	}
	return TCL_OK;
}
/*==========================================================================*
 *	t@C
 *==========================================================================*/
/* t@C̃GgAt@C擾B
 * [in]
 *	iPtr		C^v^ւ̃|C^B
 *	channelId	`lIDB
 * [out]
 *	߂l		ꍇAt@CԂB
 *			ȂꍇANULLԂB
 */
static FILE* Tcl_GetFile(Tcl_Interp* iPtr, const char* channelId) {
	Tcl_TableEntry* tPtr = Tcl_FindTableEntry(iPtr->fileTablePtr, channelId);
	if(!tPtr) {
		Tcl_ErrMsg(iPtr, "bad channelId");
		return NULL;
	}
	return tPtr->value;
}
/*--------------------------------------------------------------------------*/
//open fileName ?access?
static int Tcl_OpenCmd(Tcl_Interp* iPtr) {
	const char* mode = "r";
	FILE* fp;
	Tcl_TableEntry* tPtr;
	if(iPtr->argc == 3) { mode = iPtr->argv[2]; }			//ANZX[hw肳ĂA擾BANZX[hw肳ĂȂ΁A"r"ƂB
	fp = fopen(iPtr->argv[1], mode);				//t@CJB
	if(!fp) { return Tcl_ErrMsg(iPtr, "open error"); }
	tPtr = Tcl_CreateTableEntry(					//t@C̃Gg쐬B
		iPtr->fileTablePtr,
		strdup_printf("%p", fp),				//AhXlL[Ƃ邱ƂɂBӂsearchId쐬ړIłAhXlƂĉ߂邱Ƃ͖B
		NULL);
	tPtr->value = fp;
	iPtr->result = tPtr->key;					//t@C̃Gg̃L[A`lIDƂāAʂ̕Ɋi[B
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//close channelId
static int Tcl_CloseCmd(Tcl_Interp* iPtr) {
	Tcl_TableEntry* tPtr;
	FILE* fp;
	if(str_has_prefix(iPtr->argv[1], "std")) {			//WnhƁA\łȂɂȂ̂ŁAȂ悤ɂBK{ł͂ȂB
		return Tcl_ErrMsg(iPtr, "std* shouldn't be closed");
	}
	tPtr = Tcl_FindTableEntry(iPtr->fileTablePtr, iPtr->argv[1]);	//t@C̃Gg擾B
	if(!tPtr) { return Tcl_ErrMsg(iPtr, "bad channelId"); }
	fp = tPtr->value;
	fclose(fp);							//t@CB
	Tcl_DeleteTableEntry(tPtr);					//t@C̃Gg폜B
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//flush channelId
static int Tcl_FlushCmd(Tcl_Interp* iPtr) {
	FILE* fp = Tcl_GetFile(iPtr, iPtr->argv[1]);			//t@C擾B
	if(!fp) { return TCL_ERROR; }
	fflush(fp);							//t@CtbVB
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//eof channelId
static int Tcl_EofCmd(Tcl_Interp* iPtr) {
	FILE* fp = Tcl_GetFile(iPtr, iPtr->argv[1]);			//t@C擾B
	if(!fp) { return TCL_ERROR; }
	iPtr->result = strdup_printf("%d", !!feof(fp));			//EOFwqZbgĂ1,ZbgĂȂ0Aʂ̕Ɋi[B
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//tell channelId
static int Tcl_TellCmd(Tcl_Interp* iPtr) {
	FILE* fp = Tcl_GetFile(iPtr, iPtr->argv[1]);			//t@C擾B
	if(!fp) { return TCL_ERROR; }
	iPtr->result = strdup_printf("%d", ftell(fp));			//t@CʒuAʂ̕Ɋi[B
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//seek channelId offset ?origin?
static int Tcl_SeekCmd(Tcl_Interp* iPtr) {
	int retCode, offset, origin = SEEK_SET;
	FILE* fp;
	if(iPtr->argc == 4) {						//ʒuw肳ĂA擾Bʒuw肳ĂȂ΁ASEEK_SETƂB
		if(!strcmp(iPtr->argv[3], "start")) {
			origin = SEEK_SET;
		} else if(!strcmp(iPtr->argv[3], "current")) {
			origin = SEEK_CUR;
		} else if(!strcmp(iPtr->argv[3], "end")) {
			origin = SEEK_END;
		} else {
			return Tcl_ErrMsg(iPtr, "bad origin");
		}
	}
	fp = Tcl_GetFile(iPtr, iPtr->argv[1]);				//t@C擾B
	if(!fp) { return TCL_ERROR; }
	retCode = Tcl_GetInt(iPtr, iPtr->argv[2], &offset);		//ItZbg擾B
	if(retCode) { return retCode; }
	fseek(fp, offset, origin);					//t@CʒuړB
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//gets channelId ?varName?
static int Tcl_GetsCmd(Tcl_Interp* iPtr) {
	int c;
	const char* s = "";
	FILE* fp = Tcl_GetFile(iPtr, iPtr->argv[1]);			//t@C擾B
	if(!fp) { return TCL_ERROR; }
	for(;;) {
		char buf[2] = { c = fgetc(fp) };			//ꕶǂݍށB					//buf[]́Acꕶ琬镶ɂȂB
		if((c == EOF) || (c == '\n')) { break; }		//t@CI[,,sȂΔB			//śAɒǉȂB
		s = strjoin(NULL, s, buf, NULL);			//ɒǉB
	}
	if(iPtr->argc == 2) {						//ϐw肳ĂȂ΁c
		iPtr->result = s;					//ǂݍ񂾕ԂB
	} else {							//ϐw肳Ăc
		int len = strlen(s);					//̒擾B
		if(!len && (c == EOF)) {				//ꕶǂݍ߂At@CI[ɓBc	//sǂݍ񂾏ꍇ́A(-1)ł͂ȂA(0)ԂƂɒӂBsǂݍ񂾏ꍇ(c=='\n')Ȃ̂ŁAL̔ŏOłB
			len = -1;					//̒A(-1)ƂB
		} else {						//ȊOȂ΁c
			if(!Tcl_SetVar(iPtr, iPtr->argv[2], s)) {	//ǂݍ񂾕Aw肳ꂽϐɊi[B
				return Tcl_ErrMsg(iPtr, "store error");
			}
		}
		iPtr->result = strdup_printf("%d", len);		//̒Aʂ̕Ɋi[B
	}
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//puts ?-nonewline? ?channelId? string
static int Tcl_PutsCmd(Tcl_Interp* iPtr) {
	int i = 1, newline = 1;
	FILE* fp = stdout;
	if(!strcmp(iPtr->argv[i], "-nonewline")) {			//ŏ̈'-nonewline'Ȃ΁AB
		newline = 0;
		i++;
	}
	if(iPtr->argc >= (i + 2)) {					//2ȏcĂ΁ÄchannelIdȂāAB
		fp = Tcl_GetFile(iPtr, iPtr->argv[i]);			//t@C擾B
		if(!fp) { return TCL_ERROR; }
		i++;
	}
	if(iPtr->argc != (i + 1)) {					//stringcĂȂAȏ̈cĂAG[ƂB
		return Tcl_WrongNumOfArgs(iPtr);
	}
	fputs(iPtr->argv[i], fp);					//string\B
	if(newline) { fputc('\n', fp); }				//'-nonewline'w肳ĂȂAso͂B
	return TCL_OK;
}
/*--------------------------------------------------------------------------*/
//source fileName
static int Tcl_SourceCmd(Tcl_Interp* iPtr) {
	int retCode;
	FILE* fp = fopen(iPtr->argv[1], "r");					//t@CJB
	if(!fp) { return Tcl_ErrMsg(iPtr, "open error"); }
	retCode = Tcl_EvalFile(iPtr, fp);				//t@C̓esB
	fclose(fp);							//t@CB
	return retCode;
}
/****************************************************************************
 *	rgCR}h`
 ****************************************************************************/
static const Tcl_BuiltInCmd TBL_BuiltInCmd[]={
	{"return",		Tcl_ReturnCmd,		1,2},	//return ?string?
	{"error",		Tcl_ErrorCmd,		2,2},	//error message
	{"catch",		Tcl_CatchCmd,		2,3},	//catch script ?varName?
	{"eval",		Tcl_EvalCmd,		2,0},	//eval arg ?arg ...?
	{"set",			Tcl_SetCmd,		2,3},	//set varName ?value?
	{"unset",		Tcl_UnsetCmd,		1,0},	//unset ?name name name ...?
	{"append",		Tcl_AppendCmd,		2,0},	//append varName ?value ...?	//R}h֐ʉB
	{"lappend",		Tcl_AppendCmd,		2,0},	//lappend varName ?value ...?	//
	{"proc",		Tcl_ProcCmd,		4,4},	//proc name args body
	{"rename",		Tcl_RenameCmd,		3,3},	//rename oldName newName
	{"uplevel",		Tcl_UplevelCmd,		2,0},	//uplevel ?level? arg ?arg ...?
	{"upvar",		Tcl_UpvarCmd,		3,0},	//upvar ?level? otherVar myVar ?otherVar myVar ...?
	{"global",		Tcl_GlobalCmd,		2,0},	//global varname ?varname ...?
	{"array",		Tcl_ArrayCmd,		3,0},	//array option arrayName ?arg ...?
	{"list",		Tcl_ListCmd,		1,0},	//list ?arg ...?
	{"llength",		Tcl_LlengthCmd,		2,2},	//llength list
	{"lindex",		Tcl_LindexCmd,		3,3},	//lindex list index
	{"linsert",		Tcl_LinsertCmd,		4,0},	//linsert list index element ?element ...?	//}vfAŒ1ȏw肵Ȃ΂ȂȂB(Tcldl)
	{"lrange",		Tcl_LrangeCmd,		4,4},	//lrange list first last
	{"lreplace",		Tcl_LreplaceCmd,	4,0},	//lreplace list first last ?element ...?
	{"lsearch",		Tcl_LsearchCmd,		3,3},	//lsearch list pattern
	{"lsort",		Tcl_LsortCmd,		2,0},	//lsort ?options? list
	{"glob",		Tcl_GlobCmd,		2,0},	//glob ?switches? pattern ?pattern ...?
	{"incr",		Tcl_IncrCmd,		2,3},	//incr varName ?increment?
	{"concat",		Tcl_ConcatCmd,		1,0},	//concat ?arg ...?
	{"join",		Tcl_JoinCmd,		2,3},	//join list ?joinString?
	{"split",		Tcl_SplitCmd,		2,3},	//split string ?splitChars?
	{"expr",		Tcl_ExprCmd,		2,0},	//expr arg ?arg ...?
	{"exit",		Tcl_ExitCmd,		1,2},	//exit ?returnCode?
	{"break",		Tcl_BreakCmd,		1,1},	//break
	{"continue",		Tcl_ContinueCmd,	1,1},	//continue
	{"if",			Tcl_IfCmd,		3,0},	//if expr1 ?then? body1 elseif expr2 ?then? body2 elseif ... ?else? ?bodyN?	//uif expr1 body1v3ŏ\ƂBۂɂTcl_IfCmd()̏ŊmFĂ̂ŁAł1ȏw肵ĂΖȂB
	{"while",		Tcl_WhileCmd,		3,3},	//while test body
	{"for",			Tcl_ForCmd,		5,5},	//for start test next body
	{"foreach",		Tcl_ForeachCmd,		4,4},	//foreach varname list body
	{"switch",		Tcl_SwitchCmd,		3,0},	//switch ?options? string pattern body ?pattern body ...?	switch ?options? string {pattern body ?pattern body ...?}	//uswitch string {pattern body}v3ŏ\ƂB
	{"string",		Tcl_StringCmd,		3,0},	//string option arg ?arg ...?
	{"format",		Tcl_FormatCmd,		2,0},	//format formatString ?arg ...?
	{"scan",		Tcl_ScanCmd,		3,0},	//scan string format ?varName ...?
	{"open",		Tcl_OpenCmd,		2,3},	//open fileName ?access?
	{"close",		Tcl_CloseCmd,		2,2},	//close channelId
	{"flush",		Tcl_FlushCmd,		2,2},	//flush channelId
	{"eof",			Tcl_EofCmd,		2,2},	//eof channelId
	{"tell",		Tcl_TellCmd,		2,2},	//tell channelId
	{"seek",		Tcl_SeekCmd,		3,4},	//seek channelId offset ?origin?
	{"gets",		Tcl_GetsCmd,		2,3},	//gets channelId ?varName?
	{"puts",		Tcl_PutsCmd,		2,4},	//puts ?-nonewline? ?channelId? string
	{"source",		Tcl_SourceCmd,		2,2},	//source fileName
//	{"read",		Tcl_ReadCmd,		0,0},	//ΉȂ
//	{"info",		Tcl_InfoCmd,		0,0},	//ΉȂ
//	{"regexp",		Tcl_RegexpCmd,		0,0},	//ΉȂ
//	{"regsub",		Tcl_RegsubCmd,		0,0},	//ΉȂ
//	{"trace",		Tcl_TraceCmd,		0,0},	//ΉȂ
//	{"cd",			Tcl_CdCmd,		0,0},	//ΉȂ
//	{"exec",		Tcl_ExecCmd,		0,0},	//ΉȂ
//	{"file",		Tcl_FileCmd,		0,0},	//ΉȂ
//	{"pwd",			Tcl_PwdCmd,		0,0},	//ΉȂ
//	{"time",		Tcl_TimeCmd,		0,0},	//ΉȂ
{0}};//I[
