/*	
 *	clipssm.h
 *
 *	P/ECE S-SMP (SPC700) Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Sun Jan 04 21:33:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#ifndef __CLIP_SSM_H__
#define __CLIP_SSM_H__

/****************************************************************************
 *
 ****************************************************************************/

/* SSMP_ASMV{`ǂݍ݂܂B
 * SSMP_ASMV{̖`/`ɂC/AZuR[h̐؂ւ́A
 * C\[Xt@C(*.c)ƃAZu\[Xt@C(*.s)QƂ̂ŁA
 * ʂ̃CN[ht@CɕĂ܂B
 * (CL̒`܂ރCN[ht@Ĉ܂܃AZu\[X
 *  CN[hƁAAZuG[ɂȂĂ܂߁B)
 */
#include "clipssma.h"

/* ̃V{`ƁASĂ̖ߎsg[Xo͂܂B
 * ̃V{`Ȃ΁Aeߎs̓g[Xo͂܂B
 * SĂ̖ߎsg[XƂƂĂxȂ̂ŁAʏ͒`ȂłB
 * ȂÃV{`ĂAŜ̃g[XONwgTRACE_ON=1hȂ΁A
 * g[Xo͍͂s܂B
 */
//#define SSMP_TRACE

/********** ȍ~͏Ȃł **********/

/* P/ECEȊOł̓AZuR[h͎gpł܂B
 */
#ifndef PIECE
#undef SSMP_ASM
#endif /*PIECE*/

/* AZuR[h͑S߃g[XɑΉĂȂ̂ŁA
 * AZuR[hgp͊mɑS߃g[XOFFɂ܂B
 */
#ifdef SSMP_ASM
#undef SSMP_TRACE
#endif /*SSMP_ASM*/ 

#ifdef SSMP_TRACE
#define SSMPTRACE	TRACE
#else /*SSMP_TRACE*/
#define SSMPTRACE	1 ? ((void)0) : TRACE
#endif /*SSMP_TRACE*/

/****************************************************************************
 *
 ****************************************************************************/

typedef struct _SSMP SSMP;

/*
 *	SSMPRAO֐̌^`
 */
typedef unsigned char SSMPREADPROC (SSMP* ssmp, unsigned short addr);
typedef          void SSMPWRITEPROC(SSMP* ssmp, unsigned short addr, unsigned char data);

/*
 *	SSMPRA
 */
/*typedef*/ struct _SSMP {
	/*===== WX^ =====*/
	unsigned char  psw;		/* + 0, 1 */
	unsigned char  sp;		/* + 1, 1 */
	unsigned short pc;		/* + 2, 2 */
	unsigned short ya;		/* + 4, 2 */
	unsigned char  x;		/* + 6, 1 */
	unsigned char  resv1[1];	/* + 7, 1 */
	/*=====  =====*/
	int cycle;			/* + 8, 4 */
	unsigned char  sleep;		/* +12, 1 */
	unsigned char  resv2[3];	/* +13, 3 */
	/*===== O֐ =====*/
	SSMPREADPROC*  read;		/* +16, 4 */
	SSMPWRITEPROC* write;		/* +20, 4 */
} /*SSMP*/;				/* =24    */

/*
 *	CXgNV֐錾
 */
typedef                 void SSMPOPPROC (SSMP* ssmp, unsigned char code, int arg1, int arg2);
#define SSMPFN_(OP, FN) void ssmpop_##FN(SSMP* ssmp, unsigned char code, int arg1, int arg2);	/* 錾p */
#include "ssmp/list.h" /* [ssmp.xls]List!C6 */
SSMPFN_("ERROR", ERROR)
#undef  SSMPFN_
#define SSMPFN_(    FN) void ssmpop_##FN(SSMP* ssmp, unsigned char code, int arg1, int arg2)	/* `p */

/*
 *	IyR[h}bvEj[jbNe[u
 */
typedef struct _SSMPOP {
	SSMPOPPROC* proc;	/* + 0, 4 */
	unsigned char addr;	/* + 4, 1 */
	unsigned char cycle;	/* + 5, 1 */
	unsigned short name;	/* + 6, 2 ssmp_op_name_table[]̕ւ̃ItZbgł */
} SSMPOP;			/* = 8    */
#define SSMPOP_(CODE, PROC, ADDR, CYCLE, NAME)	{ ssmpop_##PROC, SSMP_##ADDR, CYCLE, 0x##NAME },
extern const SSMPOP ssmp_op_table[256/*opcode*/];
extern const char ssmp_op_name_table[];	/* j[jbNe[u */

/***** SSMPOP.addr *****/
/*==== operand bytes=0 ====*/
#define SSMP_IMPLIED				 0	/* A,X,Y,etc */
#define SSMP_INDIRECT				 1	/* (X) */
#define SSMP_INDIRECT_AUTO_INCREMENT		 2	/* (X)+ */
#define SSMP_INDIRECT_PAGE_TO_IP		 3	/* (X),(Y) */
/*==== operand bytes=1 ====*/
#define SSMP_INMEDIATE_DATA			 4	/* #inm */
#define SSMP_DIRECT_PAGE			 5	/* dp */
#define SSMP_X_INDEXED_DIRECT_PAGE		 6	/* dp+X */
#define SSMP_Y_INDEXED_DIRECT_PAGE		 7	/* dp+Y */
#define SSMP_X_INDEXED_INDIRECT			 8	/* (dp+X) */
#define SSMP_INDIRECT_Y_INDEXED_INDIRECT	 9	/* (dp)+Y */
#define SSMP_RELATIVE				10	/* rel */
/*==== operand bytes=2 ====*/
#define SSMP_DIRECT_PAGE_TO_DP			11	/* dp(d),dp(s) */
#define SSMP_INMEDIATE_DATA_TO_DP		12	/* dp,#inm */
#define SSMP_DIRECT_PAGE_RELATIVE		13	/* dp,rel */
#define SSMP_ABSOLUTE_BOOLEAN_BIT		14	/* mem.bit */
#define SSMP_ABSOLUTE				15	/* labs */
#define SSMP_X_INDEXED_ABSOLUTE			16	/* labs+X */
#define SSMP_Y_INDEXED_ABSOLUTE			17	/* labs+Y */
#define SSMP_X_INDEXED_ABSOLUTE_INDIRECT	18	/* (labs+X) */
#define SSMP_X_INDEXED_DIRECT_PAGE_RELATIVE	19	/* dp+X,rel */

/****************************************************************************
 *	֐
 ****************************************************************************/

/* SSMPZbgɐݒ肳ASSMPRÃCREAD/WRITE̊O֐łB
 * AvP[V璼ڌĂяoƂ͂܂B
 */
unsigned char ssmp_internal_read (SSMP* ssmp, unsigned short addr);
         void ssmp_internal_write(SSMP* ssmp, unsigned short addr, unsigned char data);

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* 荞݊֘ÃAvP[Vp֐͗pӂĂ܂B
 * {SPC700͊荞݋@\Ă܂AS-SMP͊荞݋@\gĂȂłB
 */

/* SSMPZbg܂B
 * [in]
 *	ssmp		SSMP\́B
 *	read		CREAD O֐ (NULL:RA֐gp)
 *	write		CWRITEO֐ (NULL:RA֐gp)
 * [note]
 *	* read,writeNULLw肷ƁARÅO֐gp܂B
 *	  RÅO֐́Â悤ȓs܂B
 *	  EREAD	SSMP\̂̒64KB̃CzuĂƉ肵ACǂݍ݂܂B
 *	  EWRITE	SSMP\̂̒64KB̃CzuĂƉ肵ACɏ݂܂B
 */
void ssmp_reset(SSMP* ssmp, SSMPREADPROC* read, SSMPWRITEPROC* write);

/* SSMPs܂B
 * [in]
 *	ssmp		SSMP\́B
 *	cycle		sTCNB
 * [note]
 *	* sTCNcycleɒB邩A܂SLEEPԂɂȂ܂Ŏs܂B
 *	  O҂̏ꍇAۂ̎sTCŃAcycleȂ\܂B
 *	  ҂̏ꍇAۂ̎sTCŃAcycleȂȂ\܂B
 *	* ̊֐߂ƂAssmp->cycleɎcsTCNi[Ă܂B
 *	  Ⴆ cycle=100 ŌĂяoAۂɂ 105 TCNsꍇAssmp->cycle=-5 ƂȂ܂B
 */
void ssmp_run(SSMP* ssmp, int cycle);

/* WG[o͂ɁAWX^_vs܂B
 * [in]
 *	ssmp		SSMP\́B
 */
void ssmp_dump(SSMP* ssmp);

#ifdef PIECE
/* SSMPs܂B(X^bNؑցE)
 * [in]
 *	ssmp		SSMP\́B
 *	cycle		sTCNB
 * [note]
 *	* ssmp_run()Ƃ̈Ⴂ́Å֐̎ŝ݁AX^bN0x0e00`0x1000̍RAMɐ؂芷邱ƂłB
 *	- 0x0e00`0x1000́AP/ECEJ[lIɍRAM[`]ĎgpGAłB
 *	  Ⴆ΁ApceLCDTrans()pceFileWriteSct()ÃGAɍRAM[`]܂B
 *	  IɎgp邽߁AAPIɂ0x0e00`0x1000j󂳂邱Ƃ𗯈ӂĂ΁A
 *	  AvP[VvÖ̗gƂ\łB
 *	- ssmp_run()̎́Acallgp񐔂ɑ߁AX^bNRAMɈڂƂɂ͈Ӗ܂B
 *	  ssmp_run2()̓X^bN0x1000ɈڂAssmp_run()ĂяoAX^bNɖ߂ďԂ܂B
 *	- X^bNGA0x0e00`0x1000512oCgȂ̂ŁAssmp_run2()̎gpɂ͏܂B
 *	  Essmp_run()ƂĂ΂閽ߏ֐́A傫ȃX^bNt[mۂĂ͂܂B
 *	    eߏ̎ύXꍇ́AӂĂB
 *	  Essmp_run()Ă΂O֐(READ/WRITE)ł́A傫ȃX^bNt[mۂĂ͂܂B
 *	  EX^bN悤Ȋ荞݃[`Ƃ̕p͕słB
 *	    X^bN0x0e00`0x1000ɐ؂ւĂƂɊ荞݂ƁAX^bNӂ鋰ꂪ邩łB
 *	  Essmp_run2()荞݃[`ŌĂяoĂ͂܂B
 *	    OʂŁApceLCDTrans()0x0e00`0x1000GAgpł\邩łB
 *	- ȏ̂悤Ȑ񂪂̂ŁAssmp_run2()̎gpɂ͏[ȒӂKvłB
 *	  ssmp_run()gꍇɊrׂāAssmp_run2()gꍇ̌ʂ́A20%̍ƂȂ܂B
 */
void ssmp_run2(SSMP* ssmp, int cycle);
#endif /*PIECE*/

#endif /*__CLIP_SSM_H__*/
