;	
;	clipsp2a.s
;
;	P/ECE SPC Driver V2
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2004 Naoyuki Sawa
;
;	* Mon Oct 11 04:21:00 JST 2004 Naoyuki Sawa
;	- 쐬JnB
;
#include "clipsp2a.h"
#include "clipsp2b.h"
#ifdef SPC2_ASM

	.code
	.align 1

;****************************************************************************
;	SPC2CPU
;****************************************************************************

;============================================================================
;	4. 8-BIT ARITHMETIC OPERATION COMMANDS
;============================================================================

	.global spc2cpu_0x88
spc2cpu_0x88: ; ADC A,#inm
	INMEDIATE_DATA
	ld.w %r15, %r12
	xld.ub %r14, [%r0+A]
	ADC
	xld.b [%r0+A], %r13
	ret

	.global spc2cpu_0x86
spc2cpu_0x86: ; ADC A,(X)
	INDIRECT
	READ
	ld.w %r15, %r10
	xld.ub %r14, [%r0+A]
	ADC
	xld.b [%r0+A], %r13
	ret

	.global spc2cpu_0x84
spc2cpu_0x84: ; ADC A,dp
	DIRECT_PAGE
	READ
	ld.w %r15, %r10
	xld.ub %r14, [%r0+A]
	ADC
	xld.b [%r0+A], %r13
	ret

	.global spc2cpu_0x94
spc2cpu_0x94: ; ADC A,dp+X
	X_INDEXED_DIRECT_PAGE
	READ
	ld.w %r15, %r10
	xld.ub %r14, [%r0+A]
	ADC
	xld.b [%r0+A], %r13
	ret

	.global spc2cpu_0x85
spc2cpu_0x85: ; ADC A,labs
	ABSOLUTE
	READ
	ld.w %r15, %r10
	xld.ub %r14, [%r0+A]
	ADC
	xld.b [%r0+A], %r13
	ret

	.global spc2cpu_0x95
spc2cpu_0x95: ; ADC A,labs+X
	X_INDEXED_ABSOLUTE
	READ
	ld.w %r15, %r10
	xld.ub %r14, [%r0+A]
	ADC
	xld.b [%r0+A], %r13
	ret

	.global spc2cpu_0x96
spc2cpu_0x96: ; ADC A,labs+Y
	Y_INDEXED_ABSOLUTE
	READ
	ld.w %r15, %r10
	xld.ub %r14, [%r0+A]
	ADC
	xld.b [%r0+A], %r13
	ret

	.global spc2cpu_0x87
spc2cpu_0x87: ; ADC A,(dp+X)
	X_INDEXED_INDIRECT
	READ
	ld.w %r15, %r10
	xld.ub %r14, [%r0+A]
	ADC
	xld.b [%r0+A], %r13
	ret

	.global spc2cpu_0x97
spc2cpu_0x97: ; ADC A,(dp)+Y
	INDIRECT_Y_INDEXED_INDIRECT
	READ
	ld.w %r15, %r10
	xld.ub %r14, [%r0+A]
	ADC
	xld.b [%r0+A], %r13
	ret

	.global spc2cpu_0x99
spc2cpu_0x99: ; ADC (X),(Y)
	INDIRECT_PAGE_TO_IP
	READ
	ld.w %r15, %r10
	ld.w %r12, %r13
	READ
	ld.w %r14, %r10
	ADC
	WRITE
	ret

	.global spc2cpu_0x89
spc2cpu_0x89: ; ADC dp(d),dp(s)
	DIRECT_PAGE_TO_DP
	READ
	ld.w %r15, %r10
	ld.w %r12, %r13
	READ
	ld.w %r14, %r10
	ADC
	WRITE
	ret

	.global spc2cpu_0x98
spc2cpu_0x98: ; ADC dp,#inm
	INMEDIATE_DATA_TO_DP
	ld.w %r15, %r12
	ld.w %r12, %r13
	READ
	ld.w %r14, %r10
	ADC
	WRITE
	ret

;----------------------------------------------------------------------------

	.global spc2cpu_0xA8
spc2cpu_0xA8: ; SBC A,#inm
	INMEDIATE_DATA
	ld.w %r15, %r12
	xld.ub %r14, [%r0+A]
	SBC
	xld.b [%r0+A], %r13
	ret

	.global spc2cpu_0xA6
spc2cpu_0xA6: ; SBC A,(X)
	INDIRECT
	READ
	ld.w %r15, %r10
	xld.ub %r14, [%r0+A]
	SBC
	xld.b [%r0+A], %r13
	ret

	.global spc2cpu_0xA4
spc2cpu_0xA4: ; SBC A,dp
	DIRECT_PAGE
	READ
	ld.w %r15, %r10
	xld.ub %r14, [%r0+A]
	SBC
	xld.b [%r0+A], %r13
	ret

	.global spc2cpu_0xB4
spc2cpu_0xB4: ; SBC A,dp+X
	X_INDEXED_DIRECT_PAGE
	READ
	ld.w %r15, %r10
	xld.ub %r14, [%r0+A]
	SBC
	xld.b [%r0+A], %r13
	ret

	.global spc2cpu_0xA5
spc2cpu_0xA5: ; SBC A,labs
	ABSOLUTE
	READ
	ld.w %r15, %r10
	xld.ub %r14, [%r0+A]
	SBC
	xld.b [%r0+A], %r13
	ret

	.global spc2cpu_0xB5
spc2cpu_0xB5: ; SBC A,labs+X
	X_INDEXED_ABSOLUTE
	READ
	ld.w %r15, %r10
	xld.ub %r14, [%r0+A]
	SBC
	xld.b [%r0+A], %r13
	ret

	.global spc2cpu_0xB6
spc2cpu_0xB6: ; SBC A,labs+Y
	Y_INDEXED_ABSOLUTE
	READ
	ld.w %r15, %r10
	xld.ub %r14, [%r0+A]
	SBC
	xld.b [%r0+A], %r13
	ret

	.global spc2cpu_0xA7
spc2cpu_0xA7: ; SBC A,(dp+X)
	X_INDEXED_INDIRECT
	READ
	ld.w %r15, %r10
	xld.ub %r14, [%r0+A]
	SBC
	xld.b [%r0+A], %r13
	ret

	.global spc2cpu_0xB7
spc2cpu_0xB7: ; SBC A,(dp)+Y
	INDIRECT_Y_INDEXED_INDIRECT
	READ
	ld.w %r15, %r10
	xld.ub %r14, [%r0+A]
	SBC
	xld.b [%r0+A], %r13
	ret

	.global spc2cpu_0xB9
spc2cpu_0xB9: ; SBC (X),(Y)
	INDIRECT_PAGE_TO_IP
	READ
	ld.w %r15, %r10
	ld.w %r12, %r13
	READ
	ld.w %r14, %r10
	SBC
	WRITE
	ret

	.global spc2cpu_0xA9
spc2cpu_0xA9: ; SBC dp(d),dp(s)
	DIRECT_PAGE_TO_DP
	READ
	ld.w %r15, %r10
	ld.w %r12, %r13
	READ
	ld.w %r14, %r10
	SBC
	WRITE
	ret

	.global spc2cpu_0xB8
spc2cpu_0xB8: ; SBC dp,#inm
	INMEDIATE_DATA_TO_DP
	ld.w %r15, %r12
	ld.w %r12, %r13
	READ
	ld.w %r14, %r10
	SBC
	WRITE
	ret

;----------------------------------------------------------------------------

	.global spc2cpu_0x68
spc2cpu_0x68: ; CMP A,#inm
	INMEDIATE_DATA
	ld.w %r15, %r12
	xld.ub %r14, [%r0+A]
	sub %r14, %r15
	xxor %r14, %r14, 0x100
	xld.h [%r0+PSW_CNZ], %r14
	ret

	.global spc2cpu_0x66
spc2cpu_0x66: ; CMP A,(X)
	INDIRECT
	READ
	ld.w %r15, %r10
	xld.ub %r14, [%r0+A]
	sub %r14, %r15
	xxor %r14, %r14, 0x100
	xld.h [%r0+PSW_CNZ], %r14
	ret

	.global spc2cpu_0x64
spc2cpu_0x64: ; CMP A,dp
	DIRECT_PAGE
	READ
	ld.w %r15, %r10
	xld.ub %r14, [%r0+A]
	sub %r14, %r15
	xxor %r14, %r14, 0x100
	xld.h [%r0+PSW_CNZ], %r14
	ret

	.global spc2cpu_0x74
spc2cpu_0x74: ; CMP A,dp+X
	X_INDEXED_DIRECT_PAGE
	READ
	ld.w %r15, %r10
	xld.ub %r14, [%r0+A]
	sub %r14, %r15
	xxor %r14, %r14, 0x100
	xld.h [%r0+PSW_CNZ], %r14
	ret

	.global spc2cpu_0x65
spc2cpu_0x65: ; CMP A,labs
	ABSOLUTE
	READ
	ld.w %r15, %r10
	xld.ub %r14, [%r0+A]
	sub %r14, %r15
	xxor %r14, %r14, 0x100
	xld.h [%r0+PSW_CNZ], %r14
	ret

	.global spc2cpu_0x75
spc2cpu_0x75: ; CMP A,labs+X
	X_INDEXED_ABSOLUTE
	READ
	ld.w %r15, %r10
	xld.ub %r14, [%r0+A]
	sub %r14, %r15
	xxor %r14, %r14, 0x100
	xld.h [%r0+PSW_CNZ], %r14
	ret

	.global spc2cpu_0x76
spc2cpu_0x76: ; CMP A,labs+Y
	Y_INDEXED_ABSOLUTE
	READ
	ld.w %r15, %r10
	xld.ub %r14, [%r0+A]
	sub %r14, %r15
	xxor %r14, %r14, 0x100
	xld.h [%r0+PSW_CNZ], %r14
	ret

	.global spc2cpu_0x67
spc2cpu_0x67: ; CMP A,(dp+X)
	X_INDEXED_INDIRECT
	READ
	ld.w %r15, %r10
	xld.ub %r14, [%r0+A]
	sub %r14, %r15
	xxor %r14, %r14, 0x100
	xld.h [%r0+PSW_CNZ], %r14
	ret

	.global spc2cpu_0x77
spc2cpu_0x77: ; CMP A,(dp)+Y
	INDIRECT_Y_INDEXED_INDIRECT
	READ
	ld.w %r15, %r10
	xld.ub %r14, [%r0+A]
	sub %r14, %r15
	xxor %r14, %r14, 0x100
	xld.h [%r0+PSW_CNZ], %r14
	ret

	.global spc2cpu_0x79
spc2cpu_0x79: ; CMP (X),(Y)
	INDIRECT_PAGE_TO_IP
	READ
	ld.w %r15, %r10
	READ
	ld.w %r14, %r10
	sub %r14, %r15
	xxor %r14, %r14, 0x100
	xld.h [%r0+PSW_CNZ], %r14
	ret

	.global spc2cpu_0x69
spc2cpu_0x69: ; CMP dp(d),dp(s)
	DIRECT_PAGE_TO_DP
	READ
	ld.w %r15, %r10
	ld.w %r12, %r13
	READ
	ld.w %r14, %r10
	sub %r14, %r15
	xxor %r14, %r14, 0x100
	xld.h [%r0+PSW_CNZ], %r14
	ret

	.global spc2cpu_0x78
spc2cpu_0x78: ; CMP dp,#inm
	INMEDIATE_DATA_TO_DP
	ld.w %r15, %r12
	ld.w %r12, %r13
	READ
	ld.w %r14, %r10
	sub %r14, %r15
	xxor %r14, %r14, 0x100
	xld.h [%r0+PSW_CNZ], %r14
	ret

	.global spc2cpu_0xC8
spc2cpu_0xC8: ; CMP X,#inm
	INMEDIATE_DATA
	ld.w %r15, %r12
	xld.ub %r14, [%r0+X]
	sub %r14, %r15
	xxor %r14, %r14, 0x100
	xld.h [%r0+PSW_CNZ], %r14
	ret

	.global spc2cpu_0x3E
spc2cpu_0x3E: ; CMP X,dp
	DIRECT_PAGE
	READ
	ld.w %r15, %r10
	xld.ub %r14, [%r0+X]
	sub %r14, %r15
	xxor %r14, %r14, 0x100
	xld.h [%r0+PSW_CNZ], %r14
	ret

	.global spc2cpu_0x1E
spc2cpu_0x1E: ; CMP X,labs
	ABSOLUTE
	READ
	ld.w %r15, %r10
	xld.ub %r14, [%r0+X]
	sub %r14, %r15
	xxor %r14, %r14, 0x100
	xld.h [%r0+PSW_CNZ], %r14
	ret

	.global spc2cpu_0xAD
spc2cpu_0xAD: ; CMP Y,#inm
	INMEDIATE_DATA
	ld.w %r15, %r12
	xld.ub %r14, [%r0+Y]
	sub %r14, %r15
	xxor %r14, %r14, 0x100
	xld.h [%r0+PSW_CNZ], %r14
	ret

	.global spc2cpu_0x7E
spc2cpu_0x7E: ; CMP Y,dp
	DIRECT_PAGE
	READ
	ld.w %r15, %r10
	xld.ub %r14, [%r0+Y]
	sub %r14, %r15
	xxor %r14, %r14, 0x100
	xld.h [%r0+PSW_CNZ], %r14
	ret

	.global spc2cpu_0x5E
spc2cpu_0x5E: ; CMP Y,labs
	ABSOLUTE
	READ
	ld.w %r15, %r10
	xld.ub %r14, [%r0+Y]
	sub %r14, %r15
	xxor %r14, %r14, 0x100
	xld.h [%r0+PSW_CNZ], %r14
	ret

;============================================================================
;	6. ADDITION & SUBTRACTION COMMANDS
;============================================================================

	.global spc2cpu_0xBC
spc2cpu_0xBC: ; INC A
	xld.ub %r10, [%r0+A]
	xadd %r13, %r10, 1
	xld.b [%r0+A], %r13
	xld.b [%r0+PSW_NZ], %r13
	ret

	.global spc2cpu_0xAB
spc2cpu_0xAB: ; INC dp
	DIRECT_PAGE
	READ
	xadd %r13, %r10, 1
	WRITE
	xld.b [%r0+PSW_NZ], %r13
	ret

	.global spc2cpu_0xBB
spc2cpu_0xBB: ; INC dp+X
	X_INDEXED_DIRECT_PAGE
	READ
	xadd %r13, %r10, 1
	WRITE
	xld.b [%r0+PSW_NZ], %r13
	ret

	.global spc2cpu_0xAC
spc2cpu_0xAC: ; INC labs
	ABSOLUTE
	READ
	xadd %r13, %r10, 1
	WRITE
	xld.b [%r0+PSW_NZ], %r13
	ret

	.global spc2cpu_0x3D
spc2cpu_0x3D: ; INC X
	xld.ub %r10, [%r0+X]
	xadd %r13, %r10, 1
	xld.b [%r0+X], %r13
	xld.b [%r0+PSW_NZ], %r13
	ret

	.global spc2cpu_0xFC
spc2cpu_0xFC: ; INC Y
	xld.ub %r10, [%r0+Y]
	xadd %r13, %r10, 1
	xld.b [%r0+Y], %r13
	xld.b [%r0+PSW_NZ], %r13
	ret

;----------------------------------------------------------------------------

	.global spc2cpu_0x9C
spc2cpu_0x9C: ; DEC A
	xld.ub %r10, [%r0+A]
	xsub %r13, %r10, 1
	xld.b [%r0+A], %r13
	xld.b [%r0+PSW_NZ], %r13
	ret

	.global spc2cpu_0x8B
spc2cpu_0x8B: ; DEC dp
	DIRECT_PAGE
	READ
	xsub %r13, %r10, 1
	WRITE
	xld.b [%r0+PSW_NZ], %r13
	ret

	.global spc2cpu_0x9B
spc2cpu_0x9B: ; DEC dp-X
	X_INDEXED_DIRECT_PAGE
	READ
	xsub %r13, %r10, 1
	WRITE
	xld.b [%r0+PSW_NZ], %r13
	ret

	.global spc2cpu_0x8C
spc2cpu_0x8C: ; DEC labs
	ABSOLUTE
	READ
	xsub %r13, %r10, 1
	WRITE
	xld.b [%r0+PSW_NZ], %r13
	ret

	.global spc2cpu_0x1D
spc2cpu_0x1D: ; DEC X
	xld.ub %r10, [%r0+X]
	xsub %r13, %r10, 1
	xld.b [%r0+X], %r13
	xld.b [%r0+PSW_NZ], %r13
	ret

	.global spc2cpu_0xDC
spc2cpu_0xDC: ; DEC Y
	xld.ub %r10, [%r0+Y]
	xsub %r13, %r10, 1
	xld.b [%r0+Y], %r13
	xld.b [%r0+PSW_NZ], %r13
	ret

;============================================================================
;	8. 16-BIT TRANSMISION COMMANDS
;============================================================================

	.global spc2cpu_0xBA
spc2cpu_0xBA: ; MOVW YA,dp
	DIRECT_PAGE
	READW				; YA = READW(mem)
	xld.h [%r0+YA], %r10
	xand %r15, %r10, 0xffff		; PSW_NZ = (YA >> 8) | (YA != 0)
	jreq.d 3
	srl %r10, 8			; *delay*
	or %r10, 1
	xld.b [%r0+PSW_NZ], %r10
	ret

	.global spc2cpu_0xDA
spc2cpu_0xDA: ; MOVW dp,YA
	DIRECT_PAGE
	xld.uh %r13, [%r0+YA]
	WRITEW
	ret

;============================================================================
;	9. 16-BIT OPERATION COMMANDS
;============================================================================

	.global spc2cpu_0x3A
spc2cpu_0x3A: ; INCW dp
	DIRECT_PAGE
	READW
	xadd %r13, %r10, 1
	WRITEW
	xand %r15, %r13, 0xffff		; PSW_NZ = (YA >> 8) | (YA != 0)
	jreq.d 3
	srl %r13, 8			; *delay*
	or %r13, 1
	xld.b [%r0+PSW_NZ], %r13
	ret

	.global spc2cpu_0x1A
spc2cpu_0x1A: ; DECW dp
	DIRECT_PAGE
	READW
	xsub %r13, %r10, 1
	WRITEW
	xand %r15, %r13, 0xffff		; PSW_NZ = (YA >> 8) | (YA != 0)
	jreq.d 3
	srl %r13, 8			; *delay*
	or %r13, 1
	xld.b [%r0+PSW_NZ], %r13
	ret

	.global spc2cpu_0x7A
spc2cpu_0x7A: ; ADDW YA,dp
	DIRECT_PAGE
	READW
	ld.w %r15, %r10
	xld.uh %r14, [%r0+YA]
	ADDW
	xld.h [%r0+YA], %r13
	ret

	.global spc2cpu_0x9A
spc2cpu_0x9A: ; SUBW YA,dp
	DIRECT_PAGE
	READW
	ld.w %r15, %r10
	xld.uh %r14, [%r0+YA]
	SUBW
	xld.h [%r0+YA], %r13
	ret

	.global spc2cpu_0x5A
spc2cpu_0x5A: ; CMPW YA,dp
	DIRECT_PAGE
	READW				; tmp = YA - READW(mem)
	ld.w %r15, %r10
	xld.uh %r14, [%r0+YA]
	sub %r14, %r15
	xand %r15, %r14, 0xffff		; PSW_CNZ = ((tmp >> 8) | ((unsigned short)tmp != 0)) ^ 0x100
	jreq.d 3
	srl %r14, 8			; *delay*
	or %r14, 1
	xxor %r14, %r14, 0x100
	xld.h [%r0+PSW_CNZ], %r14
	ret

;============================================================================
;	10. MULTIPLICATION & DIVISON COMMANDS
;============================================================================

	.global spc2cpu_0xCF
spc2cpu_0xCF: ; MUL YA
	xld.ub %r10, [%r0+A]		; YA = A * Y
	xld.ub %r11, [%r0+Y]
	mltu.h %r10, %r11
	ld.w %r10, %alr
	xld.h [%r0+YA], %r10
	ld.w %r11, %r10			; PSW_NZ = (YA >> 8) | (YA != 0)
	xand %r10, %r10, 0xffff
	jreq.d 3
	srl %r11, 8			; *delay*
	or %r11, 1
	xld.b [%r0+PSW_NZ], %r11
	ret

	.global spc2cpu_0x9E
spc2cpu_0x9E: ; DIV YA,X
	DIV
	ret

;============================================================================
;	11. DECIMAL COMPENSATION COMMANDS
;============================================================================

	.global spc2cpu_0xDF
spc2cpu_0xDF: ; DAA A
	DIE 0xDF
	.global spc2cpu_0xBE
spc2cpu_0xBE: ; DAS A
	DIE 0xBE

;============================================================================
;	13. SUB-ROUTINE CALL RETURN COMMANDS
;============================================================================

	.global spc2cpu_0x3F
spc2cpu_0x3F: ; CALL labs
	ABSOLUTE
	ext spc2ram@ah			; tmp = PC - spc2ram
	ext spc2ram@al
	sub %r1, %r1
	xld.w %r10, [%r0+SP]
	xrr %r1, 8			; *SP-- = tmp >> 8
	xld.b [%r10], %r1
	xsub %r10, %r10, 1
	xrl %r1, 8			; *SP-- = tmp
	xld.b [%r10], %r1
	xsub %r10, %r10, 1
	xld.w [%r0+SP], %r10
	ext spc2ram@ah			; PC = &spc2ram[mem]
	ext spc2ram@al
	add %r1, %r12
	ret

	.global spc2cpu_0x4F
spc2cpu_0x4F: ; PCALL upage
	INMEDIATE_DATA
	ext spc2ram@ah			; tmp = PC - spc2ram
	ext spc2ram@al
	sub %r1, %r1
	xld.w %r10, [%r0+SP]
	xrr %r1, 8			; *SP-- = tmp >> 8
	xld.b [%r10], %r1
	xsub %r10, %r10, 1
	xrl %r1, 8			; *SP-- = tmp
	xld.b [%r10], %r1
	xsub %r10, %r10, 1
	xld.w [%r0+SP], %r10
	ext spc2ram+0xff00@ah		; PC = &spc2ram[0xff00 + inm]
	ext spc2ram+0xff00@al
	add %r1, %r12
	ret

#macro TCALL $1
	ext spc2ram@ah			; tmp = PC - spc2ram
	ext spc2ram@al
	sub %r1, %r1
	xld.w %r10, [%r0+SP]
	xrr %r1, 8			; *SP-- = tmp >> 8
	xld.b [%r10], %r1
	xsub %r10, %r10, 1
	xrl %r1, 8			; *SP-- = tmp
	xld.b [%r10], %r1
	xsub %r10, %r10, 1
	xld.w [%r0+SP], %r10
	xld.ub %r10, [spc2ext+((15-$1)<<1)+0]	; PC = &spc2ram[spc2ext[((15 - (n)) << 1) + 0] |
	xld.ub %r11, [spc2ext+((15-$1)<<1)+1]	;               spc2ext[((15 - (n)) << 1) + 1] << 8]
	xsll %r11, 8
	or %r10, %r11
	ext spc2ram@ah
	ext spc2ram@al
	add %r1, %r10
	ret
#endm

	.global spc2cpu_0x01
spc2cpu_0x01: ; TCALL0
	TCALL 0
	.global spc2cpu_0x11
spc2cpu_0x11: ; TCALL1
	TCALL 1
	.global spc2cpu_0x21
spc2cpu_0x21: ; TCALL2
	TCALL 2
	.global spc2cpu_0x31
spc2cpu_0x31: ; TCALL3
	TCALL 3
	.global spc2cpu_0x41
spc2cpu_0x41: ; TCALL4
	TCALL 4
	.global spc2cpu_0x51
spc2cpu_0x51: ; TCALL5
	TCALL 5
	.global spc2cpu_0x61
spc2cpu_0x61: ; TCALL6
	TCALL 6
	.global spc2cpu_0x71
spc2cpu_0x71: ; TCALL7
	TCALL 7
	.global spc2cpu_0x81
spc2cpu_0x81: ; TCALL8
	TCALL 8
	.global spc2cpu_0x91
spc2cpu_0x91: ; TCALL9
	TCALL 9
	.global spc2cpu_0xA1
spc2cpu_0xA1: ; TCALL10
	TCALL 10
	.global spc2cpu_0xB1
spc2cpu_0xB1: ; TCALL11
	TCALL 11
	.global spc2cpu_0xC1
spc2cpu_0xC1: ; TCALL12
	TCALL 12
	.global spc2cpu_0xD1
spc2cpu_0xD1: ; TCALL13
	TCALL 13
	.global spc2cpu_0xE1
spc2cpu_0xE1: ; TCALL14
	TCALL 14
	.global spc2cpu_0xF1
spc2cpu_0xF1: ; TCALL15
	TCALL 15

	.global spc2cpu_0x0F
spc2cpu_0x0F: ; BRK
	DIE 0x0F

	.global spc2cpu_0x6F
spc2cpu_0x6F: ; RET
	xld.w %r10, [%r0+SP]
	xadd %r10, %r10, 1		; tmp  = *++SP
	ld.ub %r12, [%r10]+
	ld.ub %r13, [%r10]		; tmp |= *++SP << 8
	xld.w [%r0+SP], %r10
	xsll %r13, 8
	or %r12, %r13
	ext spc2ram@ah			; PC = &spc2ram[tmp]
	ext spc2ram@al
	add %r1, %r12
	ret

	.global spc2cpu_0x7F
spc2cpu_0x7F: ; RETI
	DIE 0x7F

;============================================================================
;	14. STACK OPERATION COMMANDS
;============================================================================

	.global spc2cpu_0x2D
spc2cpu_0x2D: ; PUSH A
	xld.ub %r10, [%r0+A]
	xld.w %r11, [%r0+SP]
	xld.b [%r11], %r10
	xsub %r11, %r11, 1
	xld.w [%r0+SP], %r11
	ret

	.global spc2cpu_0x4D
spc2cpu_0x4D: ; PUSH X
	xld.ub %r10, [%r0+X]
	xld.w %r11, [%r0+SP]
	xld.b [%r11], %r10
	xsub %r11, %r11, 1
	xld.w [%r0+SP], %r11
	ret

	.global spc2cpu_0x6D
spc2cpu_0x6D: ; PUSH Y
	xld.ub %r10, [%r0+Y]
	xld.w %r11, [%r0+SP]
	xld.b [%r11], %r10
	xsub %r11, %r11, 1
	xld.w [%r0+SP], %r11
	ret

	.global spc2cpu_0x0D
spc2cpu_0x0D: ; PUSH PSW
	PACK_PSW
	xld.w %r11, [%r0+SP]
	xld.b [%r11], %r10
	xsub %r11, %r11, 1
	xld.w [%r0+SP], %r11
	ret

;----------------------------------------------------------------------------

	.global spc2cpu_0xAE
spc2cpu_0xAE: ; POP A
	xld.w %r11, [%r0+SP]
	xadd %r11, %r11, 1
	xld.w [%r0+SP], %r11
	xld.ub %r10, [%r11]
	xld.b [%r0+A], %r10
	ret

	.global spc2cpu_0xCE
spc2cpu_0xCE: ; POP X
	xld.w %r11, [%r0+SP]
	xadd %r11, %r11, 1
	xld.w [%r0+SP], %r11
	xld.ub %r10, [%r11]
	xld.b [%r0+X], %r10
	ret

	.global spc2cpu_0xEE
spc2cpu_0xEE: ; POP Y
	xld.w %r11, [%r0+SP]
	xadd %r11, %r11, 1
	xld.w [%r0+SP], %r11
	xld.ub %r10, [%r11]
	xld.b [%r0+Y], %r10
	ret

	.global spc2cpu_0x8E
spc2cpu_0x8E: ; POP PSW
	xld.w %r11, [%r0+SP]
	xadd %r11, %r11, 1
	xld.w [%r0+SP], %r11
	xld.ub %r12, [%r11]
	UNPACK_PSW
	ret

;============================================================================
;	15. BIT OPERATION COMMANDS
;============================================================================

	.global spc2cpu_0x02
spc2cpu_0x02: ; SET0 dp
	DIRECT_PAGE
	READ
	xoor %r13, %r10, 1<<0
	WRITE
	ret

	.global spc2cpu_0x22
spc2cpu_0x22: ; SET1 dp
	DIRECT_PAGE
	READ
	xoor %r13, %r10, 1<<1
	WRITE
	ret

	.global spc2cpu_0x42
spc2cpu_0x42: ; SET2 dp
	DIRECT_PAGE
	READ
	xoor %r13, %r10, 1<<2
	WRITE
	ret

	.global spc2cpu_0x62
spc2cpu_0x62: ; SET3 dp
	DIRECT_PAGE
	READ
	xoor %r13, %r10, 1<<3
	WRITE
	ret

	.global spc2cpu_0x82
spc2cpu_0x82: ; SET4 dp
	DIRECT_PAGE
	READ
	xoor %r13, %r10, 1<<4
	WRITE
	ret

	.global spc2cpu_0xA2
spc2cpu_0xA2: ; SET5 dp
	DIRECT_PAGE
	READ
	xoor %r13, %r10, 1<<5
	WRITE
	ret

	.global spc2cpu_0xC2
spc2cpu_0xC2: ; SET6 dp
	DIRECT_PAGE
	READ
	xoor %r13, %r10, 1<<6
	WRITE
	ret

	.global spc2cpu_0xE2
spc2cpu_0xE2: ; SET7 dp
	DIRECT_PAGE
	READ
	xoor %r13, %r10, 1<<7
	WRITE
	ret

	.global spc2cpu_0x12
spc2cpu_0x12: ; CLR0 dp
	DIRECT_PAGE
	READ
	xand %r13, %r10, ~(1<<0)
	WRITE
	ret

	.global spc2cpu_0x32
spc2cpu_0x32: ; CLR1 dp
	DIRECT_PAGE
	READ
	xand %r13, %r10, ~(1<<1)
	WRITE
	ret

	.global spc2cpu_0x52
spc2cpu_0x52: ; CLR2 dp
	DIRECT_PAGE
	READ
	xand %r13, %r10, ~(1<<2)
	WRITE
	ret

	.global spc2cpu_0x72
spc2cpu_0x72: ; CLR3 dp
	DIRECT_PAGE
	READ
	xand %r13, %r10, ~(1<<3)
	WRITE
	ret

	.global spc2cpu_0x92
spc2cpu_0x92: ; CLR4 dp
	DIRECT_PAGE
	READ
	xand %r13, %r10, ~(1<<4)
	WRITE
	ret

	.global spc2cpu_0xB2
spc2cpu_0xB2: ; CLR5 dp
	DIRECT_PAGE
	READ
	xand %r13, %r10, ~(1<<5)
	WRITE
	ret

	.global spc2cpu_0xD2
spc2cpu_0xD2: ; CLR6 dp
	DIRECT_PAGE
	READ
	xand %r13, %r10, ~(1<<6)
	WRITE
	ret

	.global spc2cpu_0xF2
spc2cpu_0xF2: ; CLR7 dp
	DIRECT_PAGE
	READ
	xand %r13, %r10, ~(1<<7)
	WRITE
	ret

	.global spc2cpu_0x0E
spc2cpu_0x0E: ; TSET1 labs
	ABSOLUTE
	READ				; %r10 = tmp
	xld.ub %r11, [%r0+A]		; %r11 = A
	ld.w %r13, %r11			; %r13 = A
	or %r13, %r10			; %r13 = tmp | A
	and %r11, %r10			; %r11 = tmp & A
	xld.b [%r0+PSW_NZ], %r11
	WRITE
	ret

	.global spc2cpu_0x4E
spc2cpu_0x4E: ; TCLR1 labs
	ABSOLUTE
	READ				; %r10 = tmp
	xld.ub %r11, [%r0+A]		; %r11 = A
	not %r13, %r11			; %r13 = ~A
	and %r13, %r10			; %r13 = tmp & ~A
	and %r11, %r10			; %r11 = tmp & A
	xld.b [%r0+PSW_NZ], %r11
	WRITE
	ret

	.global spc2cpu_0x4A
spc2cpu_0x4A: ; AND1 C,mem.bit
	ABSOLUTE_BOOLEAN_BIT
	READ
	rr %r10, %r13			; %r13=0`7Ȃ̂extsv
	xld.ub %r11, [%r0+PSW_C]
	and %r11, %r10
	xld.b [%r0+PSW_C], %r11
	ret

	.global spc2cpu_0x6A
spc2cpu_0x6A: ; AND1 C,/mem.bit
	ABSOLUTE_BOOLEAN_BIT
	READ
	not %r10, %r10
	rr %r10, %r13			; %r13=0`7Ȃ̂extsv
	xld.ub %r11, [%r0+PSW_C]
	and %r11, %r10
	xld.b [%r0+PSW_C], %r11
	ret

	.global spc2cpu_0x0A
spc2cpu_0x0A: ; OR1 C,mem.bit
	ABSOLUTE_BOOLEAN_BIT
	READ
	rr %r10, %r13			; %r13=0`7Ȃ̂extsv
	xld.ub %r11, [%r0+PSW_C]
	or %r11, %r10
	xld.b [%r0+PSW_C], %r11
	ret

	.global spc2cpu_0x2A
spc2cpu_0x2A: ; OR1 C,/mem.bit
	ABSOLUTE_BOOLEAN_BIT
	READ
	not %r10, %r10
	rr %r10, %r13			; %r13=0`7Ȃ̂extsv
	xld.ub %r11, [%r0+PSW_C]
	or %r11, %r10
	xld.b [%r0+PSW_C], %r11
	ret

	.global spc2cpu_0x8A
spc2cpu_0x8A: ; EOR1 C,mem.bit
	ABSOLUTE_BOOLEAN_BIT
	READ
	rr %r10, %r13			; %r13=0`7Ȃ̂extsv
	xld.ub %r11, [%r0+PSW_C]
	xor %r11, %r10
	xld.b [%r0+PSW_C], %r11
	ret

	.global spc2cpu_0xEA
spc2cpu_0xEA: ; NOT1 mem.bit
	ABSOLUTE_BOOLEAN_BIT
	READ
	xld.w %r11, 1
	rl %r11, %r13			; %r13=0`7Ȃ̂extsv
	xor %r10, %r11
	ld.w %r13, %r10
	WRITE
	ret

	.global spc2cpu_0xAA
spc2cpu_0xAA: ; MOV1 C,mem.bit
	ABSOLUTE_BOOLEAN_BIT
	READ
	rr %r10, %r13			; %r13=0`7Ȃ̂extsv
	xld.b [%r0+PSW_C], %r10
	ret

	.global spc2cpu_0xCA
spc2cpu_0xCA: ; MOV1 mem.bit,C
	ABSOLUTE_BOOLEAN_BIT
	READ				; %r10 =  READ(mem)
	xld.w %r11, ~1			; %r10 =  READ(mem) & ~(1 << bit)
	rl %r11, %r13			; %r13=0`7Ȃ̂extsv
	and %r10, %r11
	xld.ub %r11, [%r0+PSW_C]	; %r10 = (READ(mem) & ~(1 << bit)) | (PSW_C & 1) << bit
	xand %r11, %r11, 1
	rl %r11, %r13			; %r13=0`7Ȃ̂extsv
	or %r10, %r11
	ld.w %r13, %r10
	WRITE
	ret

;============================================================================
;	16. PROGRAM STATUS FLAG OPERATION COMMANDS
;============================================================================

	.global spc2cpu_0x60
spc2cpu_0x60: ; CLRC
	xbclr [%r0+PSW_C], 0
	ret

	.global spc2cpu_0x80
spc2cpu_0x80: ; SETC
	xbset [%r0+PSW_C], 0
	ret

	.global spc2cpu_0xED
spc2cpu_0xED: ; NOTC
	xbnot [%r0+PSW_C], 0
	ret

	.global spc2cpu_0xE0
spc2cpu_0xE0: ; CLRV
	xbclr [%r0+PSW_V], 7
	ret

	.global spc2cpu_0x20
spc2cpu_0x20: ; CLRP
	xld.w %r10, 0x000
	xld.h [%r0+PSW_P], %r10
	ret

	.global spc2cpu_0x40
spc2cpu_0x40: ; SETP
	xld.w %r10, 0x100
	xld.h [%r0+PSW_P], %r10
	ret

	.global spc2cpu_0xA0
spc2cpu_0xA0: ; EI
	DIE 0xA0
	.global spc2cpu_0xC0
spc2cpu_0xC0: ; DI
	DIE 0xC0

;============================================================================
;	17. OTHER COMMANDS
;============================================================================

	.global spc2cpu_0x00
spc2cpu_0x00: ; NOP
	;** no job **
	ret

	.global spc2cpu_0xEF
spc2cpu_0xEF: ; SLEEP
	DIE 0xEF
	.global spc2cpu_0xFF
spc2cpu_0xFF: ; STOP
	DIE 0xFF

;****************************************************************************

	.align 2

	.global spc2cpu_TABLE
spc2cpu_TABLE:
	.word spc2cpu_0x00 ; NOP
	.word spc2cpu_0x01 ; TCALL0
	.word spc2cpu_0x02 ; SET0 dp
	.word spc2cpu_0x03 ; BBS0 dp,rel
	.word spc2cpu_0x04 ; OR A,dp
	.word spc2cpu_0x05 ; OR A,labs
	.word spc2cpu_0x06 ; OR A,(X)
	.word spc2cpu_0x07 ; OR A,(dp+X)
	.word spc2cpu_0x08 ; OR A,#inm
	.word spc2cpu_0x09 ; OR dp(d),dp(s)
	.word spc2cpu_0x0A ; OR1 C,mem.bit
	.word spc2cpu_0x0B ; ASL dp
	.word spc2cpu_0x0C ; ASL labs
	.word spc2cpu_0x0D ; PUSH PSW
	.word spc2cpu_0x0E ; TSET1 labs
	.word spc2cpu_0x0F ; BRK
	.word spc2cpu_0x10 ; BPL rel
	.word spc2cpu_0x11 ; TCALL1
	.word spc2cpu_0x12 ; CLR0 dp
	.word spc2cpu_0x13 ; BBC0 dp,rel
	.word spc2cpu_0x14 ; OR A,dp+X
	.word spc2cpu_0x15 ; OR A,labs+X
	.word spc2cpu_0x16 ; OR A,labs+Y
	.word spc2cpu_0x17 ; OR A,(dp)+Y
	.word spc2cpu_0x18 ; OR dp,#inm
	.word spc2cpu_0x19 ; OR (X),(Y)
	.word spc2cpu_0x1A ; DECW dp
	.word spc2cpu_0x1B ; ASL dp+X
	.word spc2cpu_0x1C ; ASL A
	.word spc2cpu_0x1D ; DEC X
	.word spc2cpu_0x1E ; CMP X,labs
	.word spc2cpu_0x1F ; JMP (labs+X)
	.word spc2cpu_0x20 ; CLRP
	.word spc2cpu_0x21 ; TCALL2
	.word spc2cpu_0x22 ; SET1 dp
	.word spc2cpu_0x23 ; BBS1 dp,rel
	.word spc2cpu_0x24 ; AND A,dp
	.word spc2cpu_0x25 ; AND A,labs
	.word spc2cpu_0x26 ; AND A,(X)
	.word spc2cpu_0x27 ; AND A,(dp+X)
	.word spc2cpu_0x28 ; AND A,#inm
	.word spc2cpu_0x29 ; AND dp(d),dp(s)
	.word spc2cpu_0x2A ; OR1 C,/mem.bit
	.word spc2cpu_0x2B ; ROL dp
	.word spc2cpu_0x2C ; ROL labs
	.word spc2cpu_0x2D ; PUSH A
	.word spc2cpu_0x2E ; CBNE dp,rel
	.word spc2cpu_0x2F ; BRA rel
	.word spc2cpu_0x30 ; BMI rel
	.word spc2cpu_0x31 ; TCALL3
	.word spc2cpu_0x32 ; CLR1 dp
	.word spc2cpu_0x33 ; BBC1 dp,rel
	.word spc2cpu_0x34 ; AND A,dp+X
	.word spc2cpu_0x35 ; AND A,labs+X
	.word spc2cpu_0x36 ; AND A,labs+Y
	.word spc2cpu_0x37 ; AND A,(dp)+Y
	.word spc2cpu_0x38 ; AND dp,#inm
	.word spc2cpu_0x39 ; AND (X),(Y)
	.word spc2cpu_0x3A ; INCW dp
	.word spc2cpu_0x3B ; ROL dp+X
	.word spc2cpu_0x3C ; ROL A
	.word spc2cpu_0x3D ; INC X
	.word spc2cpu_0x3E ; CMP X,dp
	.word spc2cpu_0x3F ; CALL labs
	.word spc2cpu_0x40 ; SETP
	.word spc2cpu_0x41 ; TCALL4
	.word spc2cpu_0x42 ; SET2 dp
	.word spc2cpu_0x43 ; BBS2 dp,rel
	.word spc2cpu_0x44 ; EOR A,dp
	.word spc2cpu_0x45 ; EOR A,labs
	.word spc2cpu_0x46 ; EOR A,(X)
	.word spc2cpu_0x47 ; EOR A,(dp+X)
	.word spc2cpu_0x48 ; EOR A,#inm
	.word spc2cpu_0x49 ; EOR dp(d),dp(s)
	.word spc2cpu_0x4A ; AND1 C,mem.bit
	.word spc2cpu_0x4B ; LSR dp
	.word spc2cpu_0x4C ; LSR labs
	.word spc2cpu_0x4D ; PUSH X
	.word spc2cpu_0x4E ; TCLR1 labs
	.word spc2cpu_0x4F ; PCALL upage
	.word spc2cpu_0x50 ; BVC rel
	.word spc2cpu_0x51 ; TCALL5
	.word spc2cpu_0x52 ; CLR2 dp
	.word spc2cpu_0x53 ; BBC2 dp,rel
	.word spc2cpu_0x54 ; EOR A,dp+X
	.word spc2cpu_0x55 ; EOR A,labs+X
	.word spc2cpu_0x56 ; EOR A,labs+Y
	.word spc2cpu_0x57 ; EOR A,(dp)+Y
	.word spc2cpu_0x58 ; EOR dp,#inm
	.word spc2cpu_0x59 ; EOR (X),(Y)
	.word spc2cpu_0x5A ; CMPW YA,dp
	.word spc2cpu_0x5B ; LSR dp+X
	.word spc2cpu_0x5C ; LSR A
	.word spc2cpu_0x5D ; MOV X,A
	.word spc2cpu_0x5E ; CMP Y,labs
	.word spc2cpu_0x5F ; JMP labs
	.word spc2cpu_0x60 ; CLRC
	.word spc2cpu_0x61 ; TCALL6
	.word spc2cpu_0x62 ; SET3 dp
	.word spc2cpu_0x63 ; BBS3 dp,rel
	.word spc2cpu_0x64 ; CMP A,dp
	.word spc2cpu_0x65 ; CMP A,labs
	.word spc2cpu_0x66 ; CMP A,(X)
	.word spc2cpu_0x67 ; CMP A,(dp+X)
	.word spc2cpu_0x68 ; CMP A,#inm
	.word spc2cpu_0x69 ; CMP dp(d),dp(s)
	.word spc2cpu_0x6A ; AND1 C,/mem.bit
	.word spc2cpu_0x6B ; ROR dp
	.word spc2cpu_0x6C ; ROR labs
	.word spc2cpu_0x6D ; PUSH Y
	.word spc2cpu_0x6E ; DBNZ dp,rel
	.word spc2cpu_0x6F ; RET
	.word spc2cpu_0x70 ; BVS rel
	.word spc2cpu_0x71 ; TCALL7
	.word spc2cpu_0x72 ; CLR3 dp
	.word spc2cpu_0x73 ; BBC3 dp,rel
	.word spc2cpu_0x74 ; CMP A,dp+X
	.word spc2cpu_0x75 ; CMP A,labs+X
	.word spc2cpu_0x76 ; CMP A,labs+Y
	.word spc2cpu_0x77 ; CMP A,(dp)+Y
	.word spc2cpu_0x78 ; CMP dp,#inm
	.word spc2cpu_0x79 ; CMP (X),(Y)
	.word spc2cpu_0x7A ; ADDW YA,dp
	.word spc2cpu_0x7B ; ROR dp+X
	.word spc2cpu_0x7C ; ROR A
	.word spc2cpu_0x7D ; MOV A,X
	.word spc2cpu_0x7E ; CMP Y,dp
	.word spc2cpu_0x7F ; RETI
	.word spc2cpu_0x80 ; SETC
	.word spc2cpu_0x81 ; TCALL8
	.word spc2cpu_0x82 ; SET4 dp
	.word spc2cpu_0x83 ; BBS4 dp,rel
	.word spc2cpu_0x84 ; ADC A,dp
	.word spc2cpu_0x85 ; ADC A,labs
	.word spc2cpu_0x86 ; ADC A,(X)
	.word spc2cpu_0x87 ; ADC A,(dp+X)
	.word spc2cpu_0x88 ; ADC A,#inm
	.word spc2cpu_0x89 ; ADC dp(d),dp(s)
	.word spc2cpu_0x8A ; EOR1 C,mem.bit
	.word spc2cpu_0x8B ; DEC dp
	.word spc2cpu_0x8C ; DEC labs
	.word spc2cpu_0x8D ; MOV Y,#inm
	.word spc2cpu_0x8E ; POP PSW
	.word spc2cpu_0x8F ; MOV dp,#inm
	.word spc2cpu_0x90 ; BCC rel
	.word spc2cpu_0x91 ; TCALL9
	.word spc2cpu_0x92 ; CLR4 dp
	.word spc2cpu_0x93 ; BBC4 dp,rel
	.word spc2cpu_0x94 ; ADC A,dp+X
	.word spc2cpu_0x95 ; ADC A,labs+X
	.word spc2cpu_0x96 ; ADC A,labs+Y
	.word spc2cpu_0x97 ; ADC A,(dp)+Y
	.word spc2cpu_0x98 ; ADC dp,#inm
	.word spc2cpu_0x99 ; ADC (X),(Y)
	.word spc2cpu_0x9A ; SUBW YA,dp
	.word spc2cpu_0x9B ; DEC dp+X
	.word spc2cpu_0x9C ; DEC A
	.word spc2cpu_0x9D ; MOV X,SP
	.word spc2cpu_0x9E ; DIV YA,X
	.word spc2cpu_0x9F ; XCN A
	.word spc2cpu_0xA0 ; EI
	.word spc2cpu_0xA1 ; TCALL10
	.word spc2cpu_0xA2 ; SET5 dp
	.word spc2cpu_0xA3 ; BBS5 dp,rel
	.word spc2cpu_0xA4 ; SBC A,dp
	.word spc2cpu_0xA5 ; SBC A,labs
	.word spc2cpu_0xA6 ; SBC A,(X)
	.word spc2cpu_0xA7 ; SBC A,(dp+X)
	.word spc2cpu_0xA8 ; SBC A,#inm
	.word spc2cpu_0xA9 ; SBC dp(d),dp(s)
	.word spc2cpu_0xAA ; MOV1 C,mem.bit
	.word spc2cpu_0xAB ; INC dp
	.word spc2cpu_0xAC ; INC labs
	.word spc2cpu_0xAD ; CMP Y,#inm
	.word spc2cpu_0xAE ; POP A
	.word spc2cpu_0xAF ; MOV (X)+,A
	.word spc2cpu_0xB0 ; BCS rel
	.word spc2cpu_0xB1 ; TCALL11
	.word spc2cpu_0xB2 ; CLR5 dp
	.word spc2cpu_0xB3 ; BBC5 dp,rel
	.word spc2cpu_0xB4 ; SBC A,dp+X
	.word spc2cpu_0xB5 ; SBC A,labs+X
	.word spc2cpu_0xB6 ; SBC A,labs+Y
	.word spc2cpu_0xB7 ; SBC A,(dp)+Y
	.word spc2cpu_0xB8 ; SBC dp,#inm
	.word spc2cpu_0xB9 ; SBC (X),(Y)
	.word spc2cpu_0xBA ; MOVW YA,dp
	.word spc2cpu_0xBB ; INC dp+X
	.word spc2cpu_0xBC ; INC A
	.word spc2cpu_0xBD ; MOV SP,X
	.word spc2cpu_0xBE ; DAS A
	.word spc2cpu_0xBF ; MOV A,(X)+
	.word spc2cpu_0xC0 ; DI
	.word spc2cpu_0xC1 ; TCALL12
	.word spc2cpu_0xC2 ; SET6 dp
	.word spc2cpu_0xC3 ; BBS6 dp,rel
	.word spc2cpu_0xC4 ; MOV dp,A
	.word spc2cpu_0xC5 ; MOV labs,A
	.word spc2cpu_0xC6 ; MOV (X),A
	.word spc2cpu_0xC7 ; MOV (dp+X),A
	.word spc2cpu_0xC8 ; CMP X,#inm
	.word spc2cpu_0xC9 ; MOV labs,X
	.word spc2cpu_0xCA ; MOV1 mem.bit,C
	.word spc2cpu_0xCB ; MOV dp,Y
	.word spc2cpu_0xCC ; MOV labs,Y
	.word spc2cpu_0xCD ; MOV X,#inm
	.word spc2cpu_0xCE ; POP X
	.word spc2cpu_0xCF ; MUL YA
	.word spc2cpu_0xD0 ; BNE rel
	.word spc2cpu_0xD1 ; TCALL13
	.word spc2cpu_0xD2 ; CLR6 dp
	.word spc2cpu_0xD3 ; BBC6 dp,rel
	.word spc2cpu_0xD4 ; MOV dp+X,A
	.word spc2cpu_0xD5 ; MOV labs+X,A
	.word spc2cpu_0xD6 ; MOV labs+Y,A
	.word spc2cpu_0xD7 ; MOV (dp)+Y,A
	.word spc2cpu_0xD8 ; MOV dp,X
	.word spc2cpu_0xD9 ; MOV dp+Y,X
	.word spc2cpu_0xDA ; MOVW dp,YA
	.word spc2cpu_0xDB ; MOV dp+X,Y
	.word spc2cpu_0xDC ; DEC Y
	.word spc2cpu_0xDD ; MOV A,Y
	.word spc2cpu_0xDE ; CBNE dp+X,rel
	.word spc2cpu_0xDF ; DAA A
	.word spc2cpu_0xE0 ; CLRV
	.word spc2cpu_0xE1 ; TCALL14
	.word spc2cpu_0xE2 ; SET7 dp
	.word spc2cpu_0xE3 ; BBS7 dp,rel
	.word spc2cpu_0xE4 ; MOV A,dp
	.word spc2cpu_0xE5 ; MOV A,labs
	.word spc2cpu_0xE6 ; MOV A,(X)
	.word spc2cpu_0xE7 ; MOV A,(dp+X)
	.word spc2cpu_0xE8 ; MOV A,#inm
	.word spc2cpu_0xE9 ; MOV X,labs
	.word spc2cpu_0xEA ; NOT1 mem.bit
	.word spc2cpu_0xEB ; MOV Y,dp
	.word spc2cpu_0xEC ; MOV Y,labs
	.word spc2cpu_0xED ; NOTC
	.word spc2cpu_0xEE ; POP Y
	.word spc2cpu_0xEF ; SLEEP
	.word spc2cpu_0xF0 ; BEQ rel
	.word spc2cpu_0xF1 ; TCALL15
	.word spc2cpu_0xF2 ; CLR7 dp
	.word spc2cpu_0xF3 ; BBC7 dp,rel
	.word spc2cpu_0xF4 ; MOV A,dp+X
	.word spc2cpu_0xF5 ; MOV A,labs+X
	.word spc2cpu_0xF6 ; MOV A,labs+Y
	.word spc2cpu_0xF7 ; MOV A,(dp)+Y
	.word spc2cpu_0xF8 ; MOV X,dp
	.word spc2cpu_0xF9 ; MOV X,dp+Y
	.word spc2cpu_0xFA ; MOV dp(d),dp(s)
	.word spc2cpu_0xFB ; MOV Y,dp+X
	.word spc2cpu_0xFC ; INC Y
	.word spc2cpu_0xFD ; MOV Y,A
	.word spc2cpu_0xFE ; DBNZ Y,rel
	.word spc2cpu_0xFF ; STOP

	.align 1

;****************************************************************************

#endif /*SPC2_ASM*/
