/*	
 *	clipslip.h
 *
 *	SLIP(Serial Line Internet Protocol)T[o
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Sun Jul 24 11:35:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 *	* Mon Aug 22 04:24:00 JST 2005 Naoyuki Sawa
 *	- slip_open(),slip_close()->slip_start(),slip_stop()ɖOύX܂B
 */
#ifndef __CLIP_SLIP_H__
#define __CLIP_SLIP_H__

/****************************************************************************
 *	
 ****************************************************************************/

/* SLIPJn܂B
 * [in]
 *	mtu		ő]P[oCg]B(0 = l)
 *	rxdone		MR[obNB(NULL = )
 *	txdone		MR[obNB(NULL = )
 * [note]
 *	* slip_start()ĂяoAvP[V́AIOɕKA
 *	  slip_stop()ĂяoĂB
 *	  slip_stop()ĂяoɏIƁAP/ECEVXeُ퓮ƂȂ܂B
 *	* ő]Pʂ0w肷ƁAl1006oCgƂȂ܂B
 */
void slip_start(int mtu/*=1006*/, void (*rxdone)(), void (*txdone)());

/* SLIPؒf܂B
 * [note]
 *	* slip_stop()́AɈSɌĂяoƂł܂B
 *	  slip_start()ĂяoĂȂĂAslip_stop()ĂяoĂ\܂B
 */
void slip_stop();

/* MpPbgo܂B
 * [in]
 *	dat		opPbgi[obt@B
 *	len		opPbg̍őoCgB
 * [out]
 *	߂l		ۂɎopPbg̃oCgB
 *			MpPbgꍇA0Ԃ܂B
 */
int slip_recv(void* dat/*[len]*/, int len);

/* MpPbgݒ肵܂B
 * [out]
 *	dat		MpPbgB
 *	len		MpPbg̃oCgB
 * [out]
 *	߂l		ۂɑMpPbg̃oCgB
 *			- lenɍő]Pʈȏ̃oCgw肵ꍇAő]Pʂ̃oCgԂ܂B
 *			- M̃pPbgcĂāAMpPbgݒłȂꍇ́A0Ԃ܂B
 *			  ΂炭҂ĂAxslip_send()ĂяoĂB
 */
int slip_send(const void* dat/*[len]*/, int len);

/* MpPbgAnhVFCN񐔂擾܂B
 * [in]
 *	stat		ʂi[SILPSTAT\̂ւ̃|C^B
 */
typedef struct _SLIPSTAT {
	int cslog;	/* "CLIENT""CLIENTSERVER"nhVFCN */
	//		/* (MpPbgɋR܂܂ꂽ"CLIENT"ɑ΂Apȉ񐔂܂݂܂) */
	int rxlog;	/* MpPbg (G[pPbg܂݂܂) */
	int txlog;	/* MpPbg */
} SLIPSTAT;
void slip_stat(SLIPSTAT* stat);

#endif /*__CLIP_SLIP_H__*/
