#include <clip.h>
/*---------------------------------------------------------------------------*/
#define VERSION "20140614"	/* o[W` */
/*---------------------------------------------------------------------------*/
ST_RudCtlInfo stRudCtlInfo;
int iChNum;
int iDataLen;
uint16_t TBL_Data[1000000/**/];
/*---------------------------------------------------------------------------*/
void RudCtl_fnMove(int iRudCtlCh, const ST_RudCtlAct* pRudCtlAct) {
	/** no job **/
}
/*---------------------------------------------------------------------------*/
void RudSeq_fnUser(int iRudSeqCh, int no) {
	/** no job **/
}
/*---------------------------------------------------------------------------*/
int getValue(const char* p) {
	return p ? ShuntingYard_Eval(p) : 0;
}
/*---------------------------------------------------------------------------*/
void loadInfo(TiXmlElement* pRoot) {
	TiXmlElement* pInfo = TiXmlNode_FirstChildElement(TiXmlElement_super(pRoot), "Info");
	if(!pInfo) { DIE(); }
	{
		stRudCtlInfo.fnMove	= RudCtl_fnMove;
		stRudCtlInfo.fCLK	= getValue(TiXmlElement_Attribute(pInfo, "fCLK"));
		{
			TiXmlElement* pCh = TiXmlNode_FirstChildElement(TiXmlElement_super(pInfo), "Ch");
			if(!pCh) { DIE(); }
			do {
				if(iChNum >= ARRAY_SIZE(stRudCtlInfo.TBL_RudCtlChInfo)) { DIE(); }
				stRudCtlInfo.TBL_RudCtlChInfo[iChNum].Sns	= getValue(TiXmlElement_Attribute(pCh, "Sns"));
				stRudCtlInfo.TBL_RudCtlChInfo[iChNum].Bac	= getValue(TiXmlElement_Attribute(pCh, "Bac"));
				{
					int iDir = 0;
					TiXmlElement* pDir = TiXmlNode_FirstChildElement(TiXmlElement_super(pCh), "Dir");
					if(!pDir) { DIE(); }
					do {
						if(iDir >= ARRAY_SIZE(stRudCtlInfo.TBL_RudCtlChInfo[iChNum].Dir)) { DIE(); }
						stRudCtlInfo.TBL_RudCtlChInfo[iChNum].Dir[iDir].PosLim	= getValue(TiXmlElement_Attribute(pDir, "PosLim"));
						stRudCtlInfo.TBL_RudCtlChInfo[iChNum].Dir[iDir].PosFix	= getValue(TiXmlElement_Attribute(pDir, "PosFix"));
						stRudCtlInfo.TBL_RudCtlChInfo[iChNum].Dir[iDir].PosSns	= getValue(TiXmlElement_Attribute(pDir, "PosSns"));
						stRudCtlInfo.TBL_RudCtlChInfo[iChNum].Dir[iDir].n	= getValue(TiXmlElement_Attribute(pDir, "n"));
						stRudCtlInfo.TBL_RudCtlChInfo[iChNum].Dir[iDir].n1	= getValue(TiXmlElement_Attribute(pDir, "n1"));
						stRudCtlInfo.TBL_RudCtlChInfo[iChNum].Dir[iDir].r1	= getValue(TiXmlElement_Attribute(pDir, "r1"));
						stRudCtlInfo.TBL_RudCtlChInfo[iChNum].Dir[iDir].s1	= getValue(TiXmlElement_Attribute(pDir, "s1"));
						stRudCtlInfo.TBL_RudCtlChInfo[iChNum].Dir[iDir].n2	= getValue(TiXmlElement_Attribute(pDir, "n2"));
						stRudCtlInfo.TBL_RudCtlChInfo[iChNum].Dir[iDir].r2	= getValue(TiXmlElement_Attribute(pDir, "r2"));
						stRudCtlInfo.TBL_RudCtlChInfo[iChNum].Dir[iDir].s2	= getValue(TiXmlElement_Attribute(pDir, "s2"));
						stRudCtlInfo.TBL_RudCtlChInfo[iChNum].Dir[iDir].StpTim	= getValue(TiXmlElement_Attribute(pDir, "StpTim"));
						pDir = TiXmlNode_NextSiblingElement(TiXmlElement_super(pDir), "Dir");
						iDir++;
					} while(pDir);
					if(iDir != ARRAY_SIZE(stRudCtlInfo.TBL_RudCtlChInfo[iChNum].Dir)) { DIE(); }
				}
				pCh = TiXmlNode_NextSiblingElement(TiXmlElement_super(pCh), "Ch");
				iChNum++;
			} while(pCh);
		}
	}
}
/*---------------------------------------------------------------------------*/
void loadData(TiXmlElement* pRoot) {
	TiXmlElement* pData = TiXmlNode_FirstChildElement(TiXmlElement_super(pRoot), "Data");
	if(!pData) { DIE(); }
	{
		TiXmlNode* pNode = TiXmlNode_FirstChild(TiXmlElement_super(pData), NULL);
		if(!pNode) { DIE(); }
		{
			TiXmlText* pText = TiXmlNode_ToText(pNode);
			if(!pText) { DIE(); }
			{
				char* p = strtok(strdup(TiXmlNode_Value(TiXmlText_super(pText))), ", ");
				while(p) {
					if(iDataLen >= ARRAY_SIZE(TBL_Data)) { DIE(); }
					TBL_Data[iDataLen++] = strtol(p, &p, 0);
					if(*p) { DIE(); }
					p = strtok(NULL, ", ");
				}
			}
		}
	}
}
/*---------------------------------------------------------------------------*/
void LoadXml(const char* pFileName) {
	TiXmlDocument* pDoc = TiXmlDocument_new(NULL);
	TiXmlDocument_LoadFile(pDoc, pFileName);
	{
		TiXmlElement* pRoot = TiXmlNode_FirstChildElement(TiXmlDocument_super(pDoc), "Root");
		if(!pRoot) { DIE(); }
		loadInfo(pRoot);
		loadData(pRoot);
	}
}
/*---------------------------------------------------------------------------*/
int getSns(int iCh) {
	int PosSns_Min, PosSns_Max;
	       if(RudCtlCh_GetPosSns(iCh, 0) < RudCtlCh_GetPosSns(iCh, 1)) {
		PosSns_Min = RudCtlCh_GetPosSns(iCh, 0);
		PosSns_Max = RudCtlCh_GetPosSns(iCh, 1);
	} else if(RudCtlCh_GetPosSns(iCh, 0) > RudCtlCh_GetPosSns(iCh, 1)) {
		PosSns_Min = RudCtlCh_GetPosSns(iCh, 1);
		PosSns_Max = RudCtlCh_GetPosSns(iCh, 0);
	} else if(RudCtlCh_GetPosSns(iCh, 0) < 0) {
		PosSns_Min = RudCtlCh_GetPosSns(iCh, 0);
		PosSns_Max = 0;
	} else {
		PosSns_Min = 0;
		PosSns_Max = RudCtlCh_GetPosSns(iCh, 0);
	}
	return ((RudCtlCh_GetPos(iCh) >= PosSns_Min) &&
		(RudCtlCh_GetPos(iCh) <= PosSns_Max)) ? RudCtlCh_GetInfo(iCh)->Sns : 0;
}
/*---------------------------------------------------------------------------*/
__declspec(noreturn) static void usage() {
	fprintf(stderr, "dRudSeqS - pX[^[̑`V[PTV~[^ (%s)\n", VERSION);
	fprintf(stderr, "Copyright (C) 2014 Naoyuki Sawa\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "USAGE:\n");
	fprintf(stderr, "  dRudSeqS [options] filename.xml\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "OPTIONS:\n");
	fprintf(stderr, "  -h     g\܂B\n");
	fprintf(stderr, "  -cl `lԍ         w肵Ȃ΁A`l(0)ƂB\n");
	fprintf(stderr, "  -pl ʒu             w肵Ȃ΁Aʒu(0)ƂB\n");
	fprintf(stderr, "  -xl f[^sCfNX w肵Ȃ΁AIB\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "EXAMPLE:\n");
	fprintf(stderr, "  dRudSeqS -c2 -p-10 -x300 sample.xml\n");
	fprintf(stderr, "  sample.xmlǍ݁A`l(2),ʒu(-10)ŁAf[^(300`)sB\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "OUTPUT:\n");
	fprintf(stderr, "  u>vŎn܂s̏o͌`́Au> ʒu  vłB\n");
	fprintf(stderr, "  u>vŎn܂sȊÓAfobO\Ȃ̂ŁAĂB\n");
	exit(EXIT_FAILURE);
}
/*---------------------------------------------------------------------------*/
int optCh;	/* `lԍ */
int optPos;	/* ʒu */
int optData;	/* f[^sCfNX */
/*---------------------------------------------------------------------------*/
int main(int argc, char* argv[]) {
	int opt, cnt;
	/* R}hCIvVB */
	opterr = 0; /* IvVG[͓vOŏ̂ŁAgetopt()ł̃G[\͕svB */
	while((opt = getopt(argc, argv, "hc:p:x:")) != -1) {
		switch(opt) {
		default:
		case 'h': usage();
		case 'c': optCh   = atoi(optarg); break;
		case 'p': optPos  = atoi(optarg); break;
		case 'x': optData = atoi(optarg); break;
		}
	}
	if(optind != (argc - 1)) { usage(); }
	/* XMLt@CǂݍށB */
	LoadXml(argv[optind]);
	if((unsigned)optCh   >= (unsigned)iChNum  ) { die("-cIvV̈słB"); }
	if((unsigned)optData >= (unsigned)iDataLen) { die("-xIvV̈słB"); }
	/* f[^sCfNXw肳Ăc */
	if(optData) {
		/* Rg[ƃV[PTB */
		RudCtl_Init(&stRudCtlInfo);
		RudSeq_Init(RudSeq_fnUser);
		/* Rg[̏(ʒuƃZT)ݒ肷B */
		if(RudCtlCh_GetPosLim(optCh, 0) < RudCtlCh_GetPosLim(optCh, 1)) {
			if((optPos < RudCtlCh_GetPosLim(optCh, 0)) ||
			   (optPos > RudCtlCh_GetPosLim(optCh, 1))) { die("-pIvV̈słB"); }
		} else {
			if((optPos < RudCtlCh_GetPosLim(optCh, 1)) ||
			   (optPos > RudCtlCh_GetPosLim(optCh, 0))) { die("-pIvV̈słB"); }
		}
		RudCtlCh_Get(optCh)->Pos = optPos;
		RudCtl_Exec(getSns(optCh));	/* ZT𔽉f邽߂Ɉs */
		/* f[^sB */
		RudSeqCh_Play(optCh, &TBL_Data[optData]);
		cnt = 0;
		do {
			RudCtl_Exec(getSns(optCh));
			RudSeq_Exec();
			printf(">%d %d %d %d\n",
				cnt++,				/*  */
				RudCtlCh_GetPos(optCh),		/* ʒu */
				RudCtlCh_GetSpd(optCh),		/*  */
				RudCtlCh_Get(optCh)->Act.d);	/*  */
		} while(RudCtlCh_GetSpd(optCh) ||		/* [^[쒆 */
			RudCtlCh_GetStpTim(optCh) ||		/* [^[~㎥ */
		//	RudCtlCh_Get(optCh)->ReqEvt1.Cond ||	/* sv(Cxgsv)L */	˂̌p͕svB̌p܂߂Ă܂ƁACxgsvZTGbWŃZTGbWOɑsvꍇɁAIȂȂB
			RudCtlCh_Get(optCh)->ReqImm2.Cond ||	/* ~㓮v(sv)L */
		//	RudCtlCh_Get(optCh)->ReqEvt2.Cond ||	/* ~㓮v(Cxgsv)L */	˂̌p͕svB̌p܂߂Ă܂ƁACxgsvZTGbWŃZTGbWOɑsvꍇɁAIȂȂB
			stRudSeq.TBL_RudSeqCh[optCh].pInst);	/* V[PT[쒆 */
	}
	return EXIT_SUCCESS;
}
