//---------------------------------------------------------------------------
//
//   MQPlugin.h      Copyright(C) 1999-2004, O.Mizno
//
//    @Metasequoia SDK Rev2.31̎dlɊÂCN[ht@CB
//    vOCJ҂̃t@C̓eύXKv͂ȂB
//
//---------------------------------------------------------------------------

#ifndef MQPluginH
#define MQPluginH

#include <math.h>

// vvZbTMQPLUGIN_VERSION`ĂȂRev2.31ƂĈ
#ifndef MQPLUGIN_VERSION
#define MQPLUGIN_VERSION  0x0231
#endif


#ifndef MQPLUGIN_EXPORTS
#define MQPLUGIN_API extern "C"
#endif

#define MQPLUGIN_EXPORT extern "C" __declspec(dllexport)


#define MQPLUGIN_TYPE_IMPORT   1
#define MQPLUGIN_TYPE_EXPORT   2
#define MQPLUGIN_TYPE_CREATE   3
#define MQPLUGIN_TYPE_OBJECT   4
#define MQPLUGIN_TYPE_SELECT   5

// MQ_ShowFileDialog
#define MQFILE_TYPE_LEFT       0
#define MQFILE_TYPE_RIGHT      1
#define MQFILE_TYPE_UP         2
#define MQFILE_TYPE_DOWN       3
#define MQFILE_TYPE_FRONT      4
#define MQFILE_TYPE_BACK       5

// MQ_GetSystemPath
#define MQFOLDER_ROOT          1
#define MQFOLDER_METASEQ_EXE   2
#define MQFOLDER_METASEQ_INI   3
#define MQFOLDER_DATA          4
#define MQFOLDER_PLUGINS       5

// MQDoc_ClearSelect
#define MQDOC_CLEARSELECT_VERTEX  1
#define MQDOC_CLEARSELECT_LINE    2
#define MQDOC_CLEARSELECT_FACE    4
#define MQDOC_CLEARSELECT_ALL     7

// MQDoc_FindMappingFile
#define MQMAPPING_TEXTURE   1
#define MQMAPPING_ALPHA     2
#define MQMAPPING_BUMP      3

// MQObj_Freeze
#define MQOBJECT_FREEZE_PATCH    0x00000001
#define MQOBJECT_FREEZE_MIRROR   0x00000002
#define MQOBJECT_FREEZE_LATHE    0x00000004
#define MQOBJECT_FREEZE_ALL      0x7FFFFFFF

// MQObj_GetPatchType, MQObj_SetPatchType
#define MQOBJECT_PATCH_MAX       3
#define MQOBJECT_PATCH_NONE      0
#define MQOBJECT_PATCH_SPLINE1   1
#define MQOBJECT_PATCH_SPLINE2   2
#define MQOBJECT_PATCH_CATMULL   3

// MQObj_GetShading, MQObj_SetShading
#define MQOBJECT_SHADE_MAX       1
#define MQOBJECT_SHADE_FLAT      0
#define MQOBJECT_SHADE_GOURAUD   1

// MQObj_GetMirrorType, MQObj_SetMirrorType
#define MQOBJECT_MIRROR_MAX      2
#define MQOBJECT_MIRROR_NONE     0
#define MQOBJECT_MIRROR_NORMAL   1
#define MQOBJECT_MIRROR_JOIN     2

// MQObj_GetMirrorAxis, MQObj_SetMirrorAxis
#define MQOBJECT_MIRROR_AXIS_X   1
#define MQOBJECT_MIRROR_AXIS_Y   2
#define MQOBJECT_MIRROR_AXIS_Z   4

// MQObj_GetLatheType, MQObj_SetLatheType
#define MQOBJECT_LATHE_MAX       3
#define MQOBJECT_LATHE_NONE      0
#define MQOBJECT_LATHE_FRONT     1
#define MQOBJECT_LATHE_BACK      2
#define MQOBJECT_LATHE_BOTH      3

// MQObj_GetLatheAxis, MQObj_SetLatheAxis
#define MQOBJECT_LATHE_X         0
#define MQOBJECT_LATHE_Y         1
#define MQOBJECT_LATHE_Z         2


// MQMat_GetShader, MQMat_SetShader
#define MQMATERIAL_SHADER_CLASSIC      0
#define MQMATERIAL_SHADER_CONSTANT     1
#define MQMATERIAL_SHADER_LAMBERT      2
#define MQMATERIAL_SHADER_PHONG        3
#define MQMATERIAL_SHADER_BLINN        4

// MQMat_GetVertexColor, MQMat_SetVertexColor
#define MQMATERIAL_VERTEXCOLOR_DISABLE		0
#define MQMATERIAL_VERTEXCOLOR_DIFFUSE		1

// MQMat_GetMappingType, MQMat_SetMappingType
#define MQMATERIAL_PROJECTION_UV			0
#define MQMATERIAL_PROJECTION_FLAT			1
#define MQMATERIAL_PROJECTION_CYLINDER		2
#define MQMATERIAL_PROJECTION_SPHERE		3


// MQMat_GetIntValue, MQMat_SetIntValue
// MQMat_GetFloatArray, MQMat_SetFloatArray
#define MQMAT_ID_SHADER 				0x101  // Int Value
#define MQMAT_ID_VERTEXCOLOR    		0x102  // Int Value
#define MQMAT_ID_MAPPROJ 				0x301  // Int Value
#define MQMAT_ID_MAPPROJ_POSITION 		0x302  // Float Array
#define MQMAT_ID_MAPPROJ_SCALING		0x303  // Float Array
#define MQMAT_ID_MAPPROJ_ANGLE 			0x304  // Float Array





typedef BYTE MQBool;

//
// struct MQPoint
//
typedef struct MQPoint
{
public:
	float x,y,z;

	// constructor
	inline MQPoint() { }
	inline MQPoint(float nx, float ny, float nz) {x=nx; y=ny; z=nz;}

	// operator
	inline MQPoint& operator = (const MQPoint& p)
		{x=p.x; y=p.y; z=p.z; return *this;}
	inline MQPoint& operator = (const float& s)
		{x=y=z=s; return *this;}
	inline MQPoint& operator += (const MQPoint& p)
		{x+=p.x; y+=p.y; z+=p.z; return *this;}
	inline MQPoint& operator += (const float& s)
		{x+=s; y+=s; z+=s; return *this;}
	inline MQPoint& operator -= (const MQPoint& p)
		{x-=p.x; y-=p.y; z-=p.z; return *this;}
	inline MQPoint& operator -= (const float& s)
		{x-=s; y-=s; z-=s; return *this;}
	inline MQPoint& operator *= (const MQPoint& p)
		{x*=p.x; y*=p.y; z*=p.z; return *this;}
	inline MQPoint& operator *= (float s)
		{x*=s; y*=s; z*=s; return *this;}
	inline MQPoint& operator /= (float s)
		{x/=s; y/=s; z/=s; return *this;}
	friend inline MQPoint operator + (const MQPoint& p1, const MQPoint& p2)
		{return MQPoint(p1.x+p2.x, p1.y+p2.y, p1.z+p2.z);}
	friend inline MQPoint operator + (const MQPoint& p, const float& s)
		{return MQPoint(p.x+s, p.y+s, p.z+s);}
	friend inline MQPoint operator + (const float& s, const MQPoint& p)
		{return MQPoint(p.x+s, p.y+s, p.z+s);}
	friend inline MQPoint operator - (const MQPoint& p1, const MQPoint& p2)
		{return MQPoint(p1.x-p2.x, p1.y-p2.y, p1.z-p2.z);}
	friend inline MQPoint operator - (const MQPoint& p, const float& s)
		{return MQPoint(p.x-s, p.y-s, p.z-s);}
	friend inline MQPoint operator - (const float& s, const MQPoint& p)
		{return MQPoint(s-p.x, s-p.y, s-p.z);}
	friend inline MQPoint operator * (const MQPoint& p1, const MQPoint& p2)
		{return MQPoint(p1.x*p2.x, p1.y*p2.y, p1.z*p2.z);}
	friend inline MQPoint operator * (const MQPoint& p, const float& s)
		{return MQPoint(p.x*s, p.y*s, p.z*s);}
	friend inline MQPoint operator * (const float& s, const MQPoint& p)
		{return MQPoint(p.x*s, p.y*s, p.z*s);}
	friend inline MQPoint operator / (const MQPoint& p, const float& s)
		{return MQPoint(p.x/s, p.y/s, p.z/s);}
	friend inline bool operator == (const MQPoint& p1, const MQPoint& p2)
		{return (p1.x==p2.x && p1.y==p2.y && p1.z==p2.z);}
	friend inline bool operator != (const MQPoint& p1, const MQPoint& p2)
		{return (p1.x!=p2.x || p1.y!=p2.y || p1.z!=p2.z);}

	inline void zero() { x=y=z=0.0f; }
	inline void one() { x=y=z=1.0f; }
	inline float norm() const { return x*x + y*y + z*z; }
	inline float abs() const { return (float)sqrt(norm()); }
	inline void normalize() {
		float a = abs();
		if(a > 0.0f) *this /= a;
		else zero();
	}
} MQPoint;


//
// struct MQColor
//
typedef struct MQColor
{
	float r,g,b;
public:
	inline MQColor() {}
	inline MQColor(float value) { r=g=b=value; }
	inline MQColor(float nr, float ng, float nb) { r=nr; g=ng; b=nb; }

	friend inline bool operator == (const MQColor& c1, const MQColor& c2)
		{return (c1.r==c2.r && c1.g==c2.g && c1.b==c2.b);}
	friend inline bool operator != (const MQColor& c1, const MQColor& c2)
		{return (c1.r!=c2.r || c1.g!=c2.g || c1.b!=c2.b);}
} MQColor;


//
// struct MQCoordinate
//
typedef struct MQCoordinate
{
	float u,v;
public:
	inline MQCoordinate() {}
	inline MQCoordinate(float nu, float nv) { u=nu; v=nv; }

	friend inline MQCoordinate operator + (const MQCoordinate& p1, const MQCoordinate& p2)
		{return MQCoordinate(p1.u+p2.u, p1.v+p2.v);}
	friend inline MQCoordinate operator + (const MQCoordinate& p, const float& s)
		{return MQCoordinate(p.u+s, p.v+s);}
	friend inline MQCoordinate operator + (const float& s, const MQCoordinate& p)
		{return MQCoordinate(p.u+s, p.v+s);}
	friend inline MQCoordinate operator - (const MQCoordinate& p1, const MQCoordinate& p2)
		{return MQCoordinate(p1.u-p2.u, p1.v-p2.v);}
	friend inline MQCoordinate operator - (const MQCoordinate& p, const float& s)
		{return MQCoordinate(p.u-s, p.v-s);}
	friend inline MQCoordinate operator - (const float& s, const MQCoordinate& p)
		{return MQCoordinate(s-p.u, s-p.v);}
	friend inline MQCoordinate operator * (const MQCoordinate& p1, const MQCoordinate& p2)
		{return MQCoordinate(p1.u*p2.u, p1.v*p2.v);}
	friend inline MQCoordinate operator * (const MQCoordinate& p, const float& s)
		{return MQCoordinate(p.u*s, p.v*s);}
	friend inline MQCoordinate operator * (const float& s, const MQCoordinate& p)
		{return MQCoordinate(p.u*s, p.v*s);}
	friend inline MQCoordinate operator / (const MQCoordinate& p, const float& s)
		{return MQCoordinate(p.u/s, p.v/s);}
	friend inline MQCoordinate operator / (const MQCoordinate& p1, const MQCoordinate& p2)
		{return MQCoordinate(p1.u/p2.u, p1.v/p2.v);}
	friend inline bool operator == (const MQCoordinate& p1, const MQCoordinate& p2)
		{return (p1.u==p2.u && p1.v==p2.v);}
	friend inline bool operator != (const MQCoordinate& p1, const MQCoordinate& p2)
		{return (p1.u!=p2.u || p1.v!=p2.v);}
} MQCoordinate;


typedef struct MQAngle
{
	float head, pich, bank;

	inline MQAngle() {}
	inline MQAngle(float h, float p, float b) { head=h; pich=p; bank=b; }
} MQAngle;

//
// struct MQFileDialogInfo
//
typedef struct {
	DWORD dwSize;
	int type;
	float scale;
	const char *softname;
	int axis_x;
	int axis_y;
	int axis_z;
} MQFileDialogInfo;


//
// struct MQSelectVertex
//
typedef struct MQSelectVertex
{
	int object; // index of object
	int vertex; // index of vertex

	inline MQSelectVertex() {}
	inline MQSelectVertex(int i, int j) { object=i; vertex=j; }
	friend inline bool operator == (const MQSelectVertex& l1, const MQSelectVertex& l2)
		{return (l1.object==l2.object && l1.vertex==l2.vertex);}
	friend inline bool operator != (const MQSelectVertex& l1, const MQSelectVertex& l2)
		{return (l1.object!=l2.object || l1.vertex!=l2.vertex);}
} MQSelectVertex;


//
// struct MQSelectLine
//
typedef struct MQSelectLine
{
	int object; // index of object
	int face;   // index of face
	int line;   // index of line

	inline MQSelectLine() {}
	inline MQSelectLine(int i, int j, int k) { object=i; face=j; line=k; }
	friend inline bool operator == (const MQSelectLine& l1, const MQSelectLine& l2)
		{return (l1.object==l2.object && l1.face==l2.face && l1.line==l2.line);}
	friend inline bool operator != (const MQSelectLine& l1, const MQSelectLine& l2)
		{return (l1.object!=l2.object || l1.face!=l2.face || l1.line!=l2.line);}
} MQSelectLine;


//
// struct MQSelectFace
//
typedef struct MQSelectFace
{
	int object; // index of object
	int face;   // index of face

	inline MQSelectFace() {}
	inline MQSelectFace(int i, int j) { object=i; face=j; }
	friend inline bool operator == (const MQSelectFace& l1, const MQSelectFace& l2)
		{return (l1.object==l2.object && l1.face==l2.face);}
	friend inline bool operator != (const MQSelectFace& l1, const MQSelectFace& l2)
		{return (l1.object!=l2.object || l1.face!=l2.face);}
} MQSelectFace;



#ifndef MQPLUGIN_EXPORTS


class MQCDocument;
#if MQPLUGIN_VERSION >= 0x0210
class MQCScene;
#endif
class MQCObject;
class MQCMaterial;

typedef MQCDocument *MQDocument;
#if MQPLUGIN_VERSION >= 0x0210
typedef MQCScene *MQScene;
#endif
typedef MQCObject *MQObject;
typedef MQCMaterial *MQMaterial;


//
// global function
//
extern HWND (__stdcall *MQ_GetWindowHandle)(void);
extern MQObject (__stdcall *MQ_CreateObject)(void);
extern MQMaterial (__stdcall *MQ_CreateMaterial)(void);
extern void (__stdcall *MQ_ShowFileDialog)(const char *title, MQFileDialogInfo *info);
extern void (__stdcall *MQ_ImportAxis)(MQFileDialogInfo *info, MQPoint *pts, int pts_count);
extern void (__stdcall *MQ_ExportAxis)(MQFileDialogInfo *info, MQPoint *pts, int pts_count);
#if MQPLUGIN_VERSION >= 0x0210
extern BOOL (__stdcall *MQ_LoadImage)(const char *filename, LPVOID *header, LPVOID *buffer, DWORD reserved);
extern BOOL (__stdcall *MQ_GetSystemPath)(char *buffer, int type);
#endif
#if MQPLUGIN_VERSION >= 0x0230
extern void (__stdcall *MQ_RefreshView)(void *reserved);
#endif

//
// class MQDodument
//
extern int  (__stdcall *MQDoc_GetObjectCount)(MQDocument doc);
extern MQObject (__stdcall *MQDoc_GetObject)(MQDocument doc, int index);
extern int  (__stdcall *MQDoc_GetCurrentObjectIndex)(MQDocument doc);
extern void (__stdcall *MQDoc_SetCurrentObjectIndex)(MQDocument doc, int index);
extern int  (__stdcall *MQDoc_AddObject)(MQDocument doc, MQObject obj);
extern void (__stdcall *MQDoc_DeleteObject)(MQDocument doc, int index);
extern int  (__stdcall *MQDoc_GetObjectIndex)(MQDocument doc, MQObject obj);
extern int  (__stdcall *MQDoc_GetMaterialCount)(MQDocument doc);
extern MQMaterial (__stdcall *MQDoc_GetMaterial)(MQDocument doc, int material);
extern int  (__stdcall *MQDoc_GetCurrentMaterialIndex)(MQDocument doc);
extern void (__stdcall *MQDoc_SetCurrentMaterialIndex)(MQDocument doc, int index);
extern int  (__stdcall *MQDoc_AddMaterial)(MQDocument doc, MQMaterial mat);
extern void (__stdcall *MQDoc_DeleteMaterial)(MQDocument doc, int index);
extern void (__stdcall *MQDoc_Compact)(MQDocument doc);
extern void (__stdcall *MQDoc_ClearSelect)(MQDocument doc, DWORD flag);
extern BOOL (__stdcall *MQDoc_AddSelectVertex)(MQDocument doc, int objindex, int vertindex);
extern BOOL (__stdcall *MQDoc_DeleteSelectVertex)(MQDocument doc, int objindex, int vertindex);
extern BOOL (__stdcall *MQDoc_IsSelectVertex)(MQDocument doc, int objindex, int vertindex);
extern BOOL (__stdcall *MQDoc_AddSelectLine)(MQDocument doc, int objindex, int faceindex, int lineindex);
extern BOOL (__stdcall *MQDoc_DeleteSelectLine)(MQDocument doc, int objindex, int faceindex, int lineindex);
extern BOOL (__stdcall *MQDoc_IsSelectLine)(MQDocument doc, int objindex, int faceindex, int lineindex);
extern BOOL (__stdcall *MQDoc_AddSelectFace)(MQDocument doc, int objindex, int faceindex);
extern BOOL (__stdcall *MQDoc_DeleteSelectFace)(MQDocument doc, int objindex, int faceindex);
extern BOOL (__stdcall *MQDoc_IsSelectFace)(MQDocument doc, int objindex, int faceindex);
#if MQPLUGIN_VERSION >= 0x0230
extern BOOL (__stdcall *MQDoc_AddSelectUVVertex)(MQDocument doc, int objindex, int faceindex, int vertindex);
extern BOOL (__stdcall *MQDoc_DeleteSelectUVVertex)(MQDocument doc, int objindex, int faceindex, int vertindex);
extern BOOL (__stdcall *MQDoc_IsSelectUVVertex)(MQDocument doc, int objindex, int faceindex, int vertindex);
#endif
#if MQPLUGIN_VERSION >= 0x0210
extern BOOL (__stdcall *MQDoc_FindMappingFile)(MQDocument doc, char *out_path, const char *filename, DWORD map_type);
extern MQScene (__stdcall *MQDoc_GetScene)(MQDocument doc, int index);
#endif

//
// class MQScene
//
#if MQPLUGIN_VERSION >= 0x0210
extern void (__stdcall *MQScene_InitSize)(MQScene scene, int width, int height);
extern void (__stdcall *MQScene_GetProjMatrix)(MQScene scene, float *matrix);
extern void (__stdcall *MQScene_GetViewMatrix)(MQScene scene, float *matrix);
#endif

//
// class MQObject
//
extern void (__stdcall *MQObj_Delete)(MQObject obj);
extern MQObject (__stdcall *MQObj_Clone)(MQObject obj);
extern void (__stdcall *MQObj_Merge)(MQObject dest, MQObject source);
extern void (__stdcall *MQObj_Freeze)(MQObject obj, DWORD flag);
extern void (__stdcall *MQObj_GetName)(MQObject obj, char *buffer, int size);
extern int  (__stdcall *MQObj_GetVertexCount)(MQObject obj);
extern void (__stdcall *MQObj_GetVertex)(MQObject obj, int index, MQPoint *pts);
extern void (__stdcall *MQObj_SetVertex)(MQObject obj, int index, MQPoint *pts);
extern void (__stdcall *MQObj_GetVertexArray)(MQObject obj, MQPoint *ptsarray);
extern int  (__stdcall *MQObj_GetFaceCount)(MQObject obj);
extern int  (__stdcall *MQObj_GetFacePointCount)(MQObject obj, int face);
extern void (__stdcall *MQObj_GetFacePointArray)(MQObject obj, int face, int *vertex);
extern void (__stdcall *MQObj_GetFaceCoordinateArray)(MQObject obj, int face, MQCoordinate *uvarray);
extern int  (__stdcall *MQObj_GetFaceMaterial)(MQObject obj, int face);
extern void (__stdcall *MQObj_SetName)(MQObject obj, const char *buffer);
extern int  (__stdcall *MQObj_AddVertex)(MQObject obj, MQPoint *p);
extern BOOL (__stdcall *MQObj_DeleteVertex)(MQObject obj, int index, BOOL del_vert);
extern int  (__stdcall *MQObj_GetVertexRefCount)(MQObject obj, int index);
extern DWORD (__stdcall *MQObj_GetVertexColor)(MQObject obj, int index);
extern void (__stdcall *MQObj_SetVertexColor)(MQObject obj, int index, DWORD color);
extern float (__stdcall *MQObj_GetVertexWeight)(MQObject obj, int index);
extern void (__stdcall *MQObj_SetVertexWeight)(MQObject obj, int index, float value);
extern void (__stdcall *MQObj_CopyVertexAttribute)(MQObject obj, int vert1, MQObject obj2, int vert2);
extern int  (__stdcall *MQObj_AddFace)(MQObject obj, int count, int *index);
extern BOOL (__stdcall *MQObj_DeleteFace)(MQObject obj, int index, BOOL del_vert);
extern BOOL (__stdcall *MQObj_InvertFace)(MQObject obj, int index);
extern void (__stdcall *MQObj_SetFaceMaterial)(MQObject obj, int face, int material);
extern void (__stdcall *MQObj_SetFaceCoordinateArray)(MQObject obj, int face, MQCoordinate *uvarray);
#if MQPLUGIN_VERSION >= 0x0230
extern DWORD (__stdcall *MQObj_GetFaceVertexColor)(MQObject obj, int face, int vertex);
extern void (__stdcall *MQObj_SetFaceVertexColor)(MQObject obj, int face, int vertex, DWORD color);
#endif
extern void (__stdcall *MQObj_OptimizeVertex)(MQObject obj, float distance, MQBool *apply);
extern void (__stdcall *MQObj_Compact)(MQObject obj);
extern DWORD (__stdcall *MQObj_GetVisible)(MQObject obj);
extern void (__stdcall *MQObj_SetVisible)(MQObject obj, DWORD visible);
extern DWORD (__stdcall *MQObj_GetPatchType)(MQObject obj);
extern void (__stdcall *MQObj_SetPatchType)(MQObject obj, DWORD type);
extern int  (__stdcall *MQObj_GetPatchSegment)(MQObject obj);
extern void (__stdcall *MQObj_SetPatchSegment)(MQObject obj, int segment);
#if MQPLUGIN_VERSION >= 0x0210
extern int  (__stdcall *MQObj_GetShading)(MQObject obj);
extern void (__stdcall *MQObj_SetShading)(MQObject obj, int type);
extern float (__stdcall *MQObj_GetSmoothAngle)(MQObject obj);
extern void (__stdcall *MQObj_SetSmoothAngle)(MQObject obj, float degree);
extern int  (__stdcall *MQObj_GetMirrorType)(MQObject obj);
extern void (__stdcall *MQObj_SetMirrorType)(MQObject obj, int type);
extern DWORD (__stdcall *MQObj_GetMirrorAxis)(MQObject obj);
extern void (__stdcall *MQObj_SetMirrorAxis)(MQObject obj, DWORD axis);
extern float (__stdcall *MQObj_GetMirrorDistance)(MQObject obj);
extern void (__stdcall *MQObj_SetMirrorDistance)(MQObject obj, float dis);
extern int  (__stdcall *MQObj_GetLatheType)(MQObject obj);
extern void (__stdcall *MQObj_SetLatheType)(MQObject obj, int type);
extern DWORD (__stdcall *MQObj_GetLatheAxis)(MQObject obj);
extern void (__stdcall *MQObj_SetLatheAxis)(MQObject obj, DWORD axis);
extern int  (__stdcall *MQObj_GetLatheSegment)(MQObject obj);
extern void (__stdcall *MQObj_SetLatheSegment)(MQObject obj, int segment);
#endif

//
// class MQMaterial
//
extern void (__stdcall *MQMat_Delete)(MQMaterial mat);
#if MQPLUGIN_VERSION >= 0x0230
extern int (__stdcall *MQMat_GetIntValue)(MQMaterial mat, int type_id);
extern void (__stdcall *MQMat_GetFloatArray)(MQMaterial mat, int type_id, float *array);
#endif
extern void (__stdcall *MQMat_GetName)(MQMaterial mat, char *buffer, int size);
extern void (__stdcall *MQMat_GetColor)(MQMaterial mat, MQColor *color);
extern float (__stdcall *MQMat_GetAlpha)(MQMaterial mat);
extern float (__stdcall *MQMat_GetDiffuse)(MQMaterial mat);
extern float (__stdcall *MQMat_GetAmbient)(MQMaterial mat);
extern float (__stdcall *MQMat_GetEmission)(MQMaterial mat);
extern float (__stdcall *MQMat_GetSpecular)(MQMaterial mat);
extern float (__stdcall *MQMat_GetPower)(MQMaterial mat);
extern void (__stdcall *MQMat_GetTextureName)(MQMaterial mat, char *buffer, int size);
extern void (__stdcall *MQMat_GetAlphaName)(MQMaterial mat, char *buffer, int size);
extern void (__stdcall *MQMat_GetBumpName)(MQMaterial mat, char *buffer, int size);
#if MQPLUGIN_VERSION >= 0x0230
extern void (__stdcall *MQMat_SetIntValue)(MQMaterial mat, int type_id, int value);
extern void (__stdcall *MQMat_SetFloatArray)(MQMaterial mat, int type_id, const float *array);
#endif
extern void (__stdcall *MQMat_SetName)(MQMaterial mat, const char *name);
extern void (__stdcall *MQMat_SetColor)(MQMaterial mat, MQColor *color);
extern void (__stdcall *MQMat_SetAlpha)(MQMaterial mat, float value);
extern void (__stdcall *MQMat_SetDiffuse)(MQMaterial mat, float value);
extern void (__stdcall *MQMat_SetAmbient)(MQMaterial mat, float value);
extern void (__stdcall *MQMat_SetEmission)(MQMaterial mat, float value);
extern void (__stdcall *MQMat_SetSpecular)(MQMaterial mat, float value);
extern void (__stdcall *MQMat_SetPower)(MQMaterial mat, float value);
extern void (__stdcall *MQMat_SetTextureName)(MQMaterial mat, const char *name);
extern void (__stdcall *MQMat_SetAlphaName)(MQMaterial mat, const char *name);
extern void (__stdcall *MQMat_SetBumpName)(MQMaterial mat, const char *name);



//
// class MQCDocument
//
class MQCDocument
{
public:
	int 		GetObjectCount(void);
	MQObject 	GetObject(int index);
	int 		GetCurrentObjectIndex(void);
	void 		SetCurrentObjectIndex(int index);
	int 		AddObject(MQObject obj);
	void 		DeleteObject(int index);
	int 		GetObjectIndex(MQObject obj);
	int 		GetMaterialCount(void);
	MQMaterial 	GetMaterial(int material);
	int 		GetCurrentMaterialIndex(void);
	void 		SetCurrentMaterialIndex(int index);
	int 		AddMaterial(MQMaterial mat);
	void 		DeleteMaterial(int index);
	void 		Compact(void);
	void 		ClearSelect(DWORD flag);
	BOOL 		AddSelectVertex(int objindex, int vertindex);
	BOOL 		DeleteSelectVertex(int objindex, int vertindex);
	BOOL 		IsSelectVertex(int objindex, int vertindex);
	BOOL 		AddSelectVertex(MQSelectVertex sel);
	BOOL 		DeleteSelectVertex(MQSelectVertex sel);
	BOOL 		IsSelectVertex(MQSelectVertex sel);
	BOOL 		AddSelectLine(int objindex, int faceindex, int lineindex);
	BOOL 		DeleteSelectLine(int objindex, int faceindex, int lineindex);
	BOOL 		IsSelectLine(int objindex, int faceindex, int lineindex);
	BOOL 		AddSelectLine(MQSelectLine sel);
	BOOL 		DeleteSelectLine(MQSelectLine sel);
	BOOL 		IsSelectLine(MQSelectLine sel);
	BOOL 		AddSelectFace(int objindex, int faceindex);
	BOOL 		DeleteSelectFace(int objindex, int faceindex);
	BOOL 		IsSelectFace(int objindex, int faceindex);
	BOOL 		AddSelectFace(MQSelectFace sel);
	BOOL 		DeleteSelectFace(MQSelectFace sel);
	BOOL 		IsSelectFace(MQSelectFace sel);
#if MQPLUGIN_VERSION >= 0x0230
	BOOL 		AddSelectUVVertex(int objindex, int faceindex, int vertindex);
	BOOL 		DeleteSelectUVVertex(int objindex, int faceindex, int vertindex);
	BOOL 		IsSelectUVVertex(int objindex, int faceindex, int vertindex);
#endif
#if MQPLUGIN_VERSION >= 0x0210
	BOOL 		FindMappingFile(char *out_path, const char *filename, DWORD map_type);
	MQScene 	GetScene(int index);
#endif
};



#if MQPLUGIN_VERSION >= 0x0210
//
// class MQCScene
//
class MQCScene
{
public:
	void InitSize(int width, int height);
	void GetProjMatrix(float *matrix);
	void GetViewMatrix(float *matrix);
};
#endif


//
// class MQCObject
//
class MQCObject
{
public:
	void 	DeleteThis(void);
	MQObject Clone(void);
	void 	Merge(MQObject source);
	void 	Freeze(DWORD flag);
	void 	GetName(char *buffer, int size);
	int  	GetVertexCount(void);
	MQPoint GetVertex(int index);
	void 	SetVertex(int index, MQPoint pts);
	void 	GetVertexArray(MQPoint *ptsarray);
	int  	GetFaceCount(void);
	int  	GetFacePointCount(int face);
	void 	GetFacePointArray(int face, int *vertex);
	void 	GetFaceCoordinateArray(int face, MQCoordinate *uvarray);
	int  	GetFaceMaterial(int face);
	void 	SetName(const char *buffer);
	int  	AddVertex(MQPoint p);
	BOOL 	DeleteVertex(int index);
	int  	GetVertexRefCount(int index);
	DWORD 	GetVertexColor(int index);
	void 	SetVertexColor(int index, DWORD color);
	float 	GetVertexWeight(int index);
	void 	SetVertexWeight(int index, float value);
	void 	CopyVertexAttribute(int vert1, MQObject obj2, int vert2);
	int  	AddFace(int count, int *index);
	BOOL 	DeleteFace(int index);
	BOOL 	InvertFace(int index);
	void 	SetFaceMaterial(int face, int material);
	void 	SetFaceCoordinateArray(int face, MQCoordinate *uvarray);
#if MQPLUGIN_VERSION >= 0x0230
	DWORD  	GetFaceVertexColor(int face, int vertex);
	void  	SetFaceVertexColor(int face, int vertex, DWORD color);
#endif
	void 	OptimizeVertex(float distance, MQBool *apply);
	void 	Compact(void);
	DWORD 	GetVisible(void);
	void 	SetVisible(DWORD visible);
	DWORD 	GetPatchType(void);
	void 	SetPatchType(DWORD type);
	int  	GetPatchSegment(void);
	void 	SetPatchSegment(int segment);
#if MQPLUGIN_VERSION >= 0x0210
	int  	GetShading(void);
	void 	SetShading(int type);
	float 	GetSmoothAngle(void);
	void 	SetSmoothAngle(float degree);
	int  	GetMirrorType(void);
	void 	SetMirrorType(int type);
	DWORD 	GetMirrorAxis(void);
	void 	SetMirrorAxis(DWORD axis);
	float 	GetMirrorDistance(void);
	void 	SetMirrorDistance(float dis);
	int  	GetLatheType(void);
	void 	SetLatheType(int type);
	DWORD 	GetLatheAxis(void);
	void 	SetLatheAxis(DWORD axis);
	int  	GetLatheSegment(void);
	void 	SetLatheSegment(int segment);
#endif
};


//
// class MQCMaterial
//
class MQCMaterial
{
public:
	void 	DeleteThis(void);
	void 	GetName(char *buffer, int size);
	MQColor GetColor(void);
	float 	GetAlpha(void);
	float 	GetDiffuse(void);
	float 	GetAmbient(void);
	float 	GetEmission(void);
	float 	GetSpecular(void);
	float 	GetPower(void);
	void 	GetTextureName(char *buffer, int size);
	void 	GetAlphaName(char *buffer, int size);
	void 	GetBumpName(char *buffer, int size);
	void 	SetName(const char *name);
	void 	SetColor(MQColor color);
	void 	SetAlpha(float value);
	void 	SetDiffuse(float value);
	void 	SetAmbient(float value);
	void 	SetEmission(float value);
	void 	SetSpecular(float value);
	void 	SetPower(float value);
	void 	SetTextureName(const char *name);
	void 	SetAlphaName(const char *name);
	void 	SetBumpName(const char *name);
#if MQPLUGIN_VERSION >= 0x0230
	int 	GetShader(void);
	int 	GetVertexColor(void);
	int 	GetMappingType(void);
	MQPoint GetMappingPosition(void);
	MQPoint GetMappingScaling(void);
	MQAngle GetMappingAngle(void);
	void 	SetShader(int shader);
	void 	SetVertexColor(int value);
	void 	SetMappingType(int type);
	void 	SetMappingPosition(MQPoint pos);
	void 	SetMappingScaling(MQPoint scale);
	void 	SetMappingAngle(MQAngle angle);
#endif
};





// class MQCDocument
inline int 		MQCDocument::GetObjectCount(void) 			{ return MQDoc_GetObjectCount(this); }
inline MQObject MQCDocument::GetObject(int index) 			{ return MQDoc_GetObject(this, index); }
inline int 		MQCDocument::GetCurrentObjectIndex(void) 	{ return MQDoc_GetCurrentObjectIndex(this); }
inline void 	MQCDocument::SetCurrentObjectIndex(int index) 	{ MQDoc_SetCurrentObjectIndex(this, index); }
inline int 		MQCDocument::AddObject(MQObject obj) 		{ return MQDoc_AddObject(this, obj); }
inline void 	MQCDocument::DeleteObject(int index) 		{ MQDoc_DeleteObject(this, index); }
inline int 		MQCDocument::GetObjectIndex(MQObject obj) 	{ return MQDoc_GetObjectIndex(this, obj); }
inline int 		MQCDocument::GetMaterialCount(void) 		{ return MQDoc_GetMaterialCount(this); }
inline MQMaterial MQCDocument::GetMaterial(int material) 	{ return MQDoc_GetMaterial(this, material); }
inline int 		MQCDocument::GetCurrentMaterialIndex(void) 		{ return MQDoc_GetCurrentMaterialIndex(this); }
inline void 	MQCDocument::SetCurrentMaterialIndex(int index) { MQDoc_SetCurrentMaterialIndex(this, index); }
inline int 		MQCDocument::AddMaterial(MQMaterial mat) 	{ return MQDoc_AddMaterial(this, mat); }
inline void 	MQCDocument::DeleteMaterial(int index) 		{ MQDoc_DeleteMaterial(this, index); }
inline void 	MQCDocument::Compact(void) 					{ MQDoc_Compact(this); }
inline void 	MQCDocument::ClearSelect(DWORD flag) 		{ MQDoc_ClearSelect(this, flag); }
inline BOOL 	MQCDocument::AddSelectVertex(int objindex, int vertindex) 		{ return MQDoc_AddSelectVertex(this, objindex, vertindex); }
inline BOOL 	MQCDocument::DeleteSelectVertex(int objindex, int vertindex) 	{ return MQDoc_DeleteSelectVertex(this, objindex, vertindex); }
inline BOOL 	MQCDocument::IsSelectVertex(int objindex, int vertindex) 		{ return MQDoc_IsSelectVertex(this, objindex, vertindex); }
inline BOOL 	MQCDocument::AddSelectVertex(MQSelectVertex sel) 				{ return MQDoc_AddSelectVertex(this, sel.object, sel.vertex); }
inline BOOL 	MQCDocument::DeleteSelectVertex(MQSelectVertex sel) 			{ return MQDoc_DeleteSelectVertex(this, sel.object, sel.vertex); }
inline BOOL 	MQCDocument::IsSelectVertex(MQSelectVertex sel) 				{ return MQDoc_IsSelectVertex(this, sel.object, sel.vertex); }
inline BOOL 	MQCDocument::AddSelectLine(int objindex, int faceindex, int lineindex) 		{ return MQDoc_AddSelectLine(this, objindex, faceindex, lineindex); }
inline BOOL 	MQCDocument::DeleteSelectLine(int objindex, int faceindex, int lineindex) 	{ return MQDoc_DeleteSelectLine(this, objindex, faceindex, lineindex); }
inline BOOL 	MQCDocument::IsSelectLine(int objindex, int faceindex, int lineindex) 		{ return MQDoc_IsSelectLine(this, objindex, faceindex, lineindex); }
inline BOOL 	MQCDocument::AddSelectLine(MQSelectLine sel) 								{ return MQDoc_AddSelectLine(this, sel.object, sel.face, sel.line); }
inline BOOL 	MQCDocument::DeleteSelectLine(MQSelectLine sel) 							{ return MQDoc_DeleteSelectLine(this, sel.object, sel.face, sel.line); }
inline BOOL 	MQCDocument::IsSelectLine(MQSelectLine sel) 								{ return MQDoc_IsSelectLine(this, sel.object, sel.face, sel.line); }
inline BOOL 	MQCDocument::AddSelectFace(int objindex, int faceindex) 					{ return MQDoc_AddSelectFace(this, objindex, faceindex); }
inline BOOL 	MQCDocument::DeleteSelectFace(int objindex, int faceindex) 					{ return MQDoc_DeleteSelectFace(this, objindex, faceindex); }
inline BOOL 	MQCDocument::IsSelectFace(int objindex, int faceindex) 						{ return MQDoc_IsSelectFace(this, objindex, faceindex); }
inline BOOL 	MQCDocument::AddSelectFace(MQSelectFace sel) 								{ return MQDoc_AddSelectFace(this, sel.object, sel.face); }
inline BOOL 	MQCDocument::DeleteSelectFace(MQSelectFace sel) 							{ return MQDoc_DeleteSelectFace(this, sel.object, sel.face); }
inline BOOL 	MQCDocument::IsSelectFace(MQSelectFace sel) 								{ return MQDoc_IsSelectFace(this, sel.object, sel.face); }
#if MQPLUGIN_VERSION >= 0x0230
inline BOOL 	MQCDocument::AddSelectUVVertex(int objindex, int faceindex, int vertindex)		{ return MQDoc_AddSelectUVVertex(this, objindex, faceindex, vertindex); }
inline BOOL 	MQCDocument::DeleteSelectUVVertex(int objindex, int faceindex, int vertindex)	{ return MQDoc_DeleteSelectUVVertex(this, objindex, faceindex, vertindex); }
inline BOOL 	MQCDocument::IsSelectUVVertex(int objindex, int faceindex, int vertindex)		{ return MQDoc_IsSelectUVVertex(this, objindex, faceindex, vertindex); }
#endif
#if MQPLUGIN_VERSION >= 0x0210
inline BOOL 	MQCDocument::FindMappingFile(char *out_path, const char *filename, DWORD map_type) { return MQDoc_FindMappingFile(this, out_path, filename, map_type); }
inline MQScene 	MQCDocument::GetScene(int index) 	{ return MQDoc_GetScene(this, index); }
#endif


#if MQPLUGIN_VERSION >= 0x0210
// class MQCScene
inline void 	MQCScene::InitSize(int width, int height) 		{ MQScene_InitSize(this, width, height); }
inline void 	MQCScene::GetProjMatrix(float *matrix) 			{ MQScene_GetProjMatrix(this, matrix); }
inline void 	MQCScene::GetViewMatrix(float *matrix) 			{ MQScene_GetViewMatrix(this, matrix); }
#endif


// class MQCObject
inline void 	MQCObject::DeleteThis(void) 					{ MQObj_Delete(this); }
inline MQObject MQCObject::Clone(void) 							{ return MQObj_Clone(this); }
inline void 	MQCObject::Merge(MQObject source) 				{ MQObj_Merge(this, source); }
inline void 	MQCObject::Freeze(DWORD flag) 					{ MQObj_Freeze(this, flag); }
inline void 	MQCObject::GetName(char *buffer, int size) 		{ MQObj_GetName(this, buffer, size); }
inline int  	MQCObject::GetVertexCount(void) 				{ return MQObj_GetVertexCount(this); }
inline MQPoint 	MQCObject::GetVertex(int index) 				{ MQPoint pts; MQObj_GetVertex(this, index, &pts); return pts; }
inline void 	MQCObject::SetVertex(int index, MQPoint pts) 	{ MQObj_SetVertex(this, index, &pts); }
inline void 	MQCObject::GetVertexArray(MQPoint *ptsarray) 	{ MQObj_GetVertexArray(this, ptsarray); }
inline int  	MQCObject::GetFaceCount(void) 					{ return MQObj_GetFaceCount(this); }
inline int  	MQCObject::GetFacePointCount(int face) 			{ return MQObj_GetFacePointCount(this, face); }
inline void 	MQCObject::GetFacePointArray(int face, int *vertex) { MQObj_GetFacePointArray(this, face, vertex); }
inline void 	MQCObject::GetFaceCoordinateArray(int face, MQCoordinate *uvarray) { MQObj_GetFaceCoordinateArray(this, face, uvarray); }
inline int  	MQCObject::GetFaceMaterial(int face) 				{ return MQObj_GetFaceMaterial(this, face); }
inline void 	MQCObject::SetName(const char *buffer)		 		{ MQObj_SetName(this, buffer); }
inline int  	MQCObject::AddVertex(MQPoint p) 					{ return MQObj_AddVertex(this, &p); }
inline BOOL 	MQCObject::DeleteVertex(int index) 					{ return MQObj_DeleteVertex(this, index, TRUE); }
inline int  	MQCObject::GetVertexRefCount(int index) 			{ return MQObj_GetVertexRefCount(this, index); }
inline DWORD 	MQCObject::GetVertexColor(int index) 				{ return MQObj_GetVertexColor(this, index); }
inline void 	MQCObject::SetVertexColor(int index, DWORD color) 	{ MQObj_SetVertexColor(this, index, color); }
inline float 	MQCObject::GetVertexWeight(int index) 				{ return MQObj_GetVertexWeight(this, index); }
inline void 	MQCObject::SetVertexWeight(int index, float value) 	{ MQObj_SetVertexWeight(this, index, value); }
inline void 	MQCObject::CopyVertexAttribute(int vert1, MQObject obj2, int vert2) { MQObj_CopyVertexAttribute(this, vert1, obj2, vert2); }
inline int  	MQCObject::AddFace(int count, int *index) 			{ return MQObj_AddFace(this, count, index); }
inline BOOL 	MQCObject::DeleteFace(int index) 					{ return MQObj_DeleteFace(this, index, TRUE); }
inline BOOL 	MQCObject::InvertFace(int index) 					{ return MQObj_InvertFace(this, index); }
inline void 	MQCObject::SetFaceMaterial(int face, int material) 	{ MQObj_SetFaceMaterial(this, face, material); }
inline void 	MQCObject::SetFaceCoordinateArray(int face, MQCoordinate *uvarray) { MQObj_SetFaceCoordinateArray(this, face, uvarray); }
#if MQPLUGIN_VERSION >= 0x0230
inline DWORD  	MQCObject::GetFaceVertexColor(int face, int vertex) 				{ return MQObj_GetFaceVertexColor(this, face, vertex); }
inline void  	MQCObject::SetFaceVertexColor(int face, int vertex, DWORD color) 	{ MQObj_SetFaceVertexColor(this, face, vertex, color); }
#endif
inline void 	MQCObject::OptimizeVertex(float distance, MQBool *apply) { MQObj_OptimizeVertex(this, distance, apply); }
inline void 	MQCObject::Compact(void) 					{ MQObj_Compact(this); }
inline DWORD 	MQCObject::GetVisible(void) 				{ return MQObj_GetVisible(this); }
inline void 	MQCObject::SetVisible(DWORD visible)	 	{ MQObj_SetVisible(this, visible); }
inline DWORD 	MQCObject::GetPatchType(void) 				{ return MQObj_GetPatchType(this); }
inline void 	MQCObject::SetPatchType(DWORD type) 		{ MQObj_SetPatchType(this, type); }
inline int  	MQCObject::GetPatchSegment(void) 			{ return MQObj_GetPatchSegment(this); }
inline void 	MQCObject::SetPatchSegment(int segment) 	{ MQObj_SetPatchSegment(this, segment); }
#if MQPLUGIN_VERSION >= 0x0210
inline int  	MQCObject::GetShading(void) 			{ return MQObj_GetShading(this); }
inline void 	MQCObject::SetShading(int type) 		{ MQObj_SetShading(this, type); }
inline float 	MQCObject::GetSmoothAngle(void) 		{ return MQObj_GetSmoothAngle(this); }
inline void 	MQCObject::SetSmoothAngle(float degree) { MQObj_SetSmoothAngle(this, degree); }
inline int  	MQCObject::GetMirrorType(void) 			{ return MQObj_GetMirrorType(this); }
inline void 	MQCObject::SetMirrorType(int type) 		{ MQObj_SetMirrorType(this, type); }
inline DWORD 	MQCObject::GetMirrorAxis(void) 			{ return MQObj_GetMirrorAxis(this); }
inline void 	MQCObject::SetMirrorAxis(DWORD axis) 	{ MQObj_SetMirrorAxis(this, axis); }
inline float 	MQCObject::GetMirrorDistance(void) 		{ return MQObj_GetMirrorDistance(this); }
inline void 	MQCObject::SetMirrorDistance(float dis) { MQObj_SetMirrorDistance(this, dis); }
inline int  	MQCObject::GetLatheType(void) 			{ return MQObj_GetLatheType(this); }
inline void 	MQCObject::SetLatheType(int type) 		{ MQObj_SetLatheType(this, type); }
inline DWORD 	MQCObject::GetLatheAxis(void) 			{ return MQObj_GetLatheAxis(this); }
inline void 	MQCObject::SetLatheAxis(DWORD axis) 	{ MQObj_SetLatheAxis(this, axis); }
inline int  	MQCObject::GetLatheSegment(void) 		{ return MQObj_GetLatheSegment(this); }
inline void 	MQCObject::SetLatheSegment(int segment) { MQObj_SetLatheSegment(this, segment); }
#endif


// class MQCMaterial
inline void 	MQCMaterial::DeleteThis(void) 					{ MQMat_Delete(this); }
inline void 	MQCMaterial::GetName(char *buffer, int size) 	{ MQMat_GetName(this, buffer, size); }
#if MQPLUGIN_VERSION >= 0x0230
inline int 		MQCMaterial::GetShader(void) 					{ return MQMat_GetIntValue(this, MQMAT_ID_SHADER); }
inline int 		MQCMaterial::GetVertexColor(void) 				{ return MQMat_GetIntValue(this, MQMAT_ID_VERTEXCOLOR); }
#endif
inline MQColor 	MQCMaterial::GetColor(void) 			{ MQColor color; MQMat_GetColor(this, &color); return color; }
inline float 	MQCMaterial::GetAlpha(void) 			{ return MQMat_GetAlpha(this); }
inline float 	MQCMaterial::GetDiffuse(void) 			{ return MQMat_GetDiffuse(this); }
inline float 	MQCMaterial::GetAmbient(void) 			{ return MQMat_GetAmbient(this); }
inline float 	MQCMaterial::GetEmission(void) 			{ return MQMat_GetEmission(this); }
inline float 	MQCMaterial::GetSpecular(void) 			{ return MQMat_GetSpecular(this); }
inline float 	MQCMaterial::GetPower(void) 			{ return MQMat_GetPower(this); }
#if MQPLUGIN_VERSION >= 0x0230
inline int 		MQCMaterial::GetMappingType(void) 		{ return MQMat_GetIntValue(this, MQMAT_ID_MAPPROJ); }
inline MQPoint 	MQCMaterial::GetMappingPosition(void) 	{ float val[3]; MQMat_GetFloatArray(this, MQMAT_ID_MAPPROJ_POSITION, val); return MQPoint(val[0], val[1], val[2]); }
inline MQPoint 	MQCMaterial::GetMappingScaling(void) 	{ float val[3]; MQMat_GetFloatArray(this, MQMAT_ID_MAPPROJ_SCALING,  val); return MQPoint(val[0], val[1], val[2]); }
inline MQAngle 	MQCMaterial::GetMappingAngle(void) 		{ float val[3]; MQMat_GetFloatArray(this, MQMAT_ID_MAPPROJ_ANGLE,    val); return MQAngle(val[0], val[1], val[2]); }
#endif
inline void 	MQCMaterial::GetTextureName(char *buffer, int size) { MQMat_GetTextureName(this, buffer, size); }
inline void 	MQCMaterial::GetAlphaName(char *buffer, int size) 	{ MQMat_GetAlphaName(this, buffer, size); }
inline void 	MQCMaterial::GetBumpName(char *buffer, int size) 	{ MQMat_GetBumpName(this, buffer, size); }
inline void 	MQCMaterial::SetName(const char *name) 				{ MQMat_SetName(this, name); }
#if MQPLUGIN_VERSION >= 0x0230
inline void 	MQCMaterial::SetShader(int shader) 		{ MQMat_SetIntValue(this, MQMAT_ID_SHADER, shader); }
inline void 	MQCMaterial::SetVertexColor(int value) 	{ MQMat_SetIntValue(this, MQMAT_ID_VERTEXCOLOR, value); }
#endif
inline void 	MQCMaterial::SetColor(MQColor color) 	{ MQMat_SetColor(this, &color); }
inline void 	MQCMaterial::SetAlpha(float value) 		{ MQMat_SetAlpha(this, value); }
inline void 	MQCMaterial::SetDiffuse(float value) 	{ MQMat_SetDiffuse(this, value); }
inline void 	MQCMaterial::SetAmbient(float value) 	{ MQMat_SetAmbient(this, value); }
inline void 	MQCMaterial::SetEmission(float value) 	{ MQMat_SetEmission(this, value); }
inline void 	MQCMaterial::SetSpecular(float value) 	{ MQMat_SetSpecular(this, value); }
inline void 	MQCMaterial::SetPower(float value) 		{ MQMat_SetPower(this, value); }
#if MQPLUGIN_VERSION >= 0x0230
inline void 	MQCMaterial::SetMappingType(int type) 	{ MQMat_SetIntValue(this, MQMAT_ID_MAPPROJ, type); }
inline void 	MQCMaterial::SetMappingPosition(MQPoint pos) 	{ float val[3]; val[0]=pos.x; val[1]=pos.y; val[2]=pos.z; MQMat_SetFloatArray(this, MQMAT_ID_MAPPROJ_POSITION, val); }
inline void 	MQCMaterial::SetMappingScaling(MQPoint scale) 	{ float val[3]; val[0]=scale.x; val[1]=scale.y; val[2]=scale.z; MQMat_SetFloatArray(this, MQMAT_ID_MAPPROJ_SCALING, val); }
inline void 	MQCMaterial::SetMappingAngle(MQAngle angle) 	{ float val[3]; val[0]=angle.head; val[1]=angle.pich; val[2]=angle.bank; MQMat_SetFloatArray(this, MQMAT_ID_MAPPROJ_ANGLE, val); }
#endif
inline void 	MQCMaterial::SetTextureName(const char *name) 	{ MQMat_SetTextureName(this, name); }
inline void 	MQCMaterial::SetAlphaName(const char *name) 	{ MQMat_SetAlphaName(this, name); }
inline void 	MQCMaterial::SetBumpName(const char *name) 		{ MQMat_SetBumpName(this, name); }

#endif //MQPLUGIN_EXPORTS

#endif //MQPluginH


