#include "app.h"
/****************************************************************************
 *	clippce.c
 ****************************************************************************/
char* strcasestr(const char* s1, const char* s2) {
	int n = strlen(s2);
	do {
		if(!strncasecmp(s1, s2, n)) { return (char*)s1; }
	} while(*s1++);
	return NULL;
}
/*--------------------------------------------------------------------------*/
size_t strnlen(const char* string, size_t n) {
	size_t len = 0;
	while((n--) && (*string++)) { len++; }
	return len;
}
/*--------------------------------------------------------------------------*/
//char* strndup(const char* string, size_t n) {//Boehm GC
//	size_t len = strnlen(string, n);
//	char* ptr =  calloc(len + 1, 1);
//	if(ptr) { memcpy(ptr, string, len); }
//	return ptr;
//}
/*--------------------------------------------------------------------------*/
int strcasecmp(const char* s1, const char* s2) {
	return _stricmp(s1, s2);
}
/*--------------------------------------------------------------------------*/
int strncasecmp(const char* s1, const char* s2, size_t n) {
	int c1, c2;
	do {
		if(n-- == 0) return 0;
		c1 = tolower(*s1++ & 0xff);
		c2 = tolower(*s2++ & 0xff);
	} while(c1 != '\0' && c1 == c2);
	return c1 - c2;
}
/*--------------------------------------------------------------------------*/
char* strsep(char** stringp, const char* delim) {
	char* begin = *stringp;
	if(begin) {
		char* end = strpbrk(begin, delim);
		if(end) { *end++ = '\0'; }
		*stringp = end;
	}
	return begin;
}
/*--------------------------------------------------------------------------*/
int isblank(int c) {
	return (c == ' ') || (c == '\t');
}
/*--------------------------------------------------------------------------*/
size_t malloc_usable_size(void* ptr) {
#ifndef GC_H
	return ptr ? _msize(ptr) : 0;
#else //GC_H
	//Boehm GCgpƁAmalloc()̓ubN̓r(=Ǘ̌)̃|C^ԂB
	//GC_size()́AubN̓rw肳ĂAubN̑Ŝ̃TCYԂB
	//malloc()Ԃ|C^ȍ~̃TCY𓾂ɂ́Aȉ̂悤ɌvZȂĂ͂ȂȂB(萄)
	return ptr ? (GC_size(ptr) - ((int)ptr - (int)GC_base(ptr))) : 0;
#endif//GC_H
}
