
    /********************************************************/
    /*                                                      */
    /*                                                      */
    /*         Copyright (C), 1993  SEIKO EPSON Corp.       */
    /*         ALL RIGHTS RESERVED                          */
    /*                                                      */
    /*                                                      */
    /*  file name : stdio.h                                 */
    /*                                                      */
    /*  Revision history                                    */
    /*      93/12/17    first release       S.Akaiwa        */
    /*      97/3/17	modified	    T.Katahira	    */
    /*			change function declaration	    */
    /*					to the ANSI style   */
    /*      14/3/10     modify for P/ECE    Naoyuki Sawa    */
    /*                - P/ECEŕsvȕ폜܂B   */
    /*                - sscanf̐錾C܂B        */
    /*                - getchargetc}N܂B   */
    /*                - putcharputc}N܂B   */
    /*      14/8/7      modify for P/ECE    Naoyuki Sawa    */
    /*                - fcloseall̐錾ǉ܂B     */
    /*      14/10/2   - snprintf(),vsnprintf()̐錾clippce.hinclude/stdio.hֈڂ܂B*/
    /*                - scprintf(),vscprintf(),asprintf(),vasprintf()ǉ܂B         */
    /*      14/10/23  - vscanf(),vsscanf(),vfscanf()ǉ܂Bclipscan.cɂ܂B */
    /*                                                      */
    /********************************************************/
                                        
#ifndef _STDIO_H
#define _STDIO_H

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned long   size_t;         /* size of type */
#endif

typedef long            fpos_t;         /* file type size */


typedef struct  {                       /* FILE structure */
        short           _flg;           /* unget exist flag */
        unsigned char   _buf;           /* unget character */
        int             _fd;            /* file descriptor */  
} FILE;

#if !defined(NULL)
#  define NULL          ((void *)0L)    /* null pointer */
#endif

#define EOF             (-1)            /* eof flag */

#define BUFSIZ          1024

#define SEEK_SET        0               /* seek from beginning */
#define SEEK_CUR        1               /* seek from here */
#define SEEK_END        2               /* seek from end */

#define _NFILE          3
#define FOPEN_MAX       _NFILE

#define FILENAME_MAX    0

#ifdef  UNIX
#define L_tmpnam        25 
#else
#define L_tmpnam        0
#endif

#define TMP_MAX         0

#define _IOFBF          0000            /* fully buffered io */
#define _IOLBF          0000            /* line buffered */
#define _IONBF          0000            /* unbuffered */

extern  FILE            _iob[FOPEN_MAX + 1];

extern	FILE			*stdin;			/* standard input stream */
extern	FILE			*stdout;		/* standard output stream */
extern	FILE			*stderr;		/* standard error stream */

#ifdef va_start
#define _VA_LIST va_list
#else
#define _VA_LIST char *
#endif

/* prototype definition */

extern  FILE    *tmpfile( void );
extern  char    *tmpnam( char * );
extern  int     remove( const char * );
extern  int     rename( const char *, const char * );
extern  FILE    *fopen( const char *, const char * );
extern  FILE    *freopen( const char *, const char *, FILE * );
extern  int     fclose( FILE * );
extern  int     fcloseall( void );				// 2014.08.07 N.SAWA ǉ

extern  void    setbuf( FILE *, char * );
extern  int     setvbuf( FILE *, char *, int, size_t );
extern  int     fflush( FILE * );

extern  void    clearerr( FILE * );
extern  int     feof( FILE * );
extern  int     ferror( FILE * );
extern  void    perror( const char * );

extern  int     fseek( FILE *, long, int );
extern  int     fgetpos( FILE *, fpos_t * );
extern  int     fsetpos(  FILE *, const fpos_t * );
extern  long    ftell( FILE * );
extern  void    rewind( FILE * );

#define getchar() getc(stdin)					// 2014.03.10 N.SAWA ύXB}N܂B
extern  int     fgetc( FILE * );
#define getc(s)  fgetc(s)					// 2014.03.10 N.SAWA ύXB}N܂B

extern  char    *gets( char * );
extern  char    *fgets( char *, int, FILE * );

//#if defined(UNIX) && !defined(ANSI)				// 2014.03.10 N.SAWA 폜
//extern  int     scanf( /* va_alist */ );			// 2014.03.10 N.SAWA 폜
//extern  int     fscanf( /* va_alilst */ );			// 2014.03.10 N.SAWA 폜
//extern  int     sscanf( /* va_alilst */ );			// 2014.03.10 N.SAWA 폜
//#else								// 2014.03.10 N.SAWA 폜
extern  int     scanf( const char *, ... );
extern  int     fscanf( FILE *, const char *, ... );
extern  int     sscanf( const char *, const char *, ... );	// 2014.03.10 N.SAWA ύXBconstĂ̂ŏCB
//#endif							// 2014.03.10 N.SAWA 폜

extern  size_t  fread( void *, size_t, size_t, FILE * );

#define putchar(c) putc((c),stdout)				// 2014.03.10 N.SAWA ύXB}N܂B
extern  int     fputc( int, FILE * );
#define putc(c,s) fputc((c),(s))				// 2014.03.10 N.SAWA ύXB}N܂B

extern  int     puts( const char * );
extern  int     fputs( const char *, FILE * );

extern  int     ungetc( int, FILE * );

//#if defined(UNIX) && !defined(ANSI)				// 2014.03.10 N.SAWA 폜
//extern  int     printf( /* char *, ... */ );			// 2014.03.10 N.SAWA 폜
//extern  int     fprintf( /* FILE *, char *, ... */ );		// 2014.03.10 N.SAWA 폜
//extern  int     sprintf( /* char *, char *, ... */ );		// 2014.03.10 N.SAWA 폜
//extern  int     vprintf( /* char *, va_list */ );		// 2014.03.10 N.SAWA 폜
//extern  int     vfprintf( /* FILE *, char *, va_list */ );	// 2014.03.10 N.SAWA 폜
//extern  int     vsprintf( /* char *, char *, va_list */ );	// 2014.03.10 N.SAWA 폜
//#else								// 2014.03.10 N.SAWA 폜
extern  int     printf( const char *, ...  );
extern  int     fprintf( FILE *, const char *, ... );
extern  int     sprintf( char *, const char *, ... );
extern  int     vprintf( const char *, _VA_LIST );
extern  int     vfprintf( FILE *, const char *, _VA_LIST );
extern  int     vsprintf( char *, const char *, _VA_LIST );
//#endif							// 2014.03.10 N.SAWA 폜

extern  size_t  fwrite( const void *, size_t, size_t, FILE * );

//{{2014/10/02ǉ:snprintf(),vsnprintf()̐錾clippce.hinclude/stdio.hֈڂ܂B
int snprintf(char* out, int cnt, const char* fmt, ...);
int vsnprintf(char* out, int cnt, const char* fmt, va_list ap);
//}}2014/10/02ǉ:snprintf(),vsnprintf()̐錾clippce.hinclude/stdio.hֈڂ܂B

//{{2014/10/02ǉ:scprintf(),vscprintf(),asprintf(),vasprintf()ǉ܂B
int scprintf(const char* fmt, ...);
int vscprintf(const char* fmt, va_list ap);
int asprintf(char** strp, const char* fmt, ...);
int vasprintf(char** strp, const char* fmt, va_list ap);
//}}2014/10/02ǉ:scprintf(),vscprintf(),asprintf(),vasprintf()ǉ܂B

//{{2014/10/23ǉ:vscanf(),vsscanf(),vfscanf()ǉ܂Bclipscan.cɂ܂B
int vscanf(const char* fmt, va_list ap);
int vsscanf(const char* str, const char* fmt, va_list ap);
int vfscanf(FILE* stream, const char* fmt, va_list ap);
//}}2014/10/23ǉ:vscanf(),vsscanf(),vfscanf()ǉ܂Bclipscan.cɂ܂B

#endif _STDIO_H
