	/*********************************************************/
 	/*                                                       */
	/*                                                       */
 	/*         Copyright (C), 1993  SEIKOEPSON Corp.         */
 	/*         ALL RIGHTS RESERVED                           */
 	/*                                                       */
	/*                                                       */
 	/*  file name : stdarg.h                                 */
 	/*                                                       */
	/*  Revision history                                     */
	/*      93/11/30    first release       K.Shinozuka      */
	/*      11/11/22    modify for P/ECE    Naoyuki Sawa     */
	/*                                                       */
	/*    stdarg.h contains followings.                      */
	/*        a declaration of a type                        */
	/*        three definitions of a macro                   */
	/*            for a variable number of arguments         */
	/*            of varying types                           */
	/*                                                       */
	/*********************************************************/

/* * Tue Nov 22 02:15:06 JST 2011 Naoyuki Sawa
 * - /usr/PIECE/include ɂt@CÃt@CD悳悤Aclip.mkɂāACN[hpXݒ肵Ă܂B
 * - smcvals.hCN[hĂȂ΁Astdarg.h̒smcvals.hCN[h悤ɂ܂B
 *   EPSONCustdarg.h́AS1C33A[LeN`ˑ̃wb_t@Csmcvals.h̒Œ`ĂA_BOUNDARYɈˑĂ邩łB
 * - ܂łclipstd.h̒smcvals.hCN[hĂ܂Astdarg.h̒smcvals.hCN[h邱Ƃɂ܂B
 *   ̂悤ɕύXŔAt[EFÃRpCȂǁAclipstd.hoRstdarg.h𒼐ڃCN[hꍇɂAsmcvals.hCN[h悤ɂłB
 * - clipstd.h̒smcvals.h̃CN[h́Â܂܎cĂ܂B
 *   clipstd.h̒stdarg.hCN[hĂ̂ŁAsmcvals.hKCN[hAsmcvals.h𖾎IɃCN[h邱Ƃ͕svɂȂ̂łA
 *   smcvals.hstdarg.ĥ߂łȂ̑ɂlXS1C33A[LeN`ˑ̒`܂ł邽߁AĖIɃCN[h悤cĂƂɂ܂B
 */

#ifndef _STDARG_H
#define _STDARG_H

//{{2011/11/22:ǉ
#include <smcvals.h>	/* smcvals.hgődCN[h̃K[hĂ̂ŁACN[h鑤ł͑dCN[h̃K[h͕svłB */
//}}2011/11/22:ǉ

typedef char *va_list;

#define va_end( tdArgP )    (void) 0
#define _SIZEOF( type )  ((( sizeof( type ) + _BOUNDARY - 1 ) / _BOUNDARY ) * _BOUNDARY )


#ifdef  BIG_ENDIAN
#   define _ENDSIZE( type ) sizeof( type )
#else
#   define _ENDSIZE( type ) ((( sizeof( type ) + _BOUNDARY - 1 ) / _BOUNDARY ) * _BOUNDARY )
#endif


#if !defined(UNIX) || defined(ANSI)

#   define va_start( tdArgP, lastparm )   \
          (void)( tdArgP = (va_list)&(lastparm) + _SIZEOF( lastparm ))   /* initialization of tdArgP */
#   define va_arg( tdArgP, type )    \
          *((type *)( (tdArgP =  tdArgP + _SIZEOF( type )) - _ENDSIZE( type ) ))
                                                /* return next argument and make tdArgP move forward */

#else

#   define va_alist __builtin_va_alist
#   define va_dcl int va_alist;
#   define va_start( tdArgP ) tdArgP = (char *) &va_alist
#   define va_arg( tdArgP, type )    \
          *((type *)(( tdArgP = tdArgP + _SIZEOF( type ) ) - _ENDSIZE( type ) ))
                                                /* return next argument and make tdArgP move forward */

#endif   /* end UNIX & ANSI */

#endif   /* end _STDARG_H */
